#!/bin/sh
#
#    Copyright 2007-2009 Canonical Ltd.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA

LIBFILES="pearlstick.py raw_write.py raw_format.py mountutils.py"
DATAFILES="pearlstick.glade pearlstick.ui"


if [ "$1" = "uninstall" ]; then
    rm -rf /usr/lib/pearlstick
    rm -rf /usr/share/pearlstick
    rm -r /usr/share/applications/pearlstick.desktop
    rm -r /usr/share/applications/pearlstick-kde.desktop
    rm -r /usr/share/applications/pearlstick-format.desktop
    rm -r /usr/share/applications/pearlstick-kde-format.desktop
    rm -f /usr/bin/pearlstick
    rm -rf /usr/share/polkit-1/actions/org.pearllinux.im.policy
    rm -rf /usr/share/kde4/apps/solid/actions/pearlstick-format.desktop
else
    cp share/applications/pearlstick.desktop /usr/share/applications/
    cp share/applications/pearlstick-format.desktop /usr/share/applications/
    cp share/applications/pearlstick-kde.desktop /usr/share/applications/
    cp share/applications/pearlstick-format-kde.desktop /usr/share/applications/
    cp share/polkit/org.pearllinux.im.policy /usr/share/polkit-1/actions
    cp share/kde4/pearlstick-format_action.desktop /usr/share/kde4/apps/solid/actions
    cp pearlstick /usr/bin/
    mkdir -p /usr/lib/pearlstick
    mkdir -p /usr/share/pearlstick

    for item in $LIBFILES; do
        cp lib/$item /usr/lib/pearlstick/
    done

    for item in $DATAFILES; do
        cp share/pearlstick/$item /usr/share/pearlstick/
    done
fi
