/**********************************************************************
 *  main.cpp
 **********************************************************************
 * Copyright (C) 2015 Pearl Authors
 *
 * Authors: Adrian
 *          Pearl Linux <http://mxlinux.org>
 *
 * This file is part of pearl-select-sound.
 *
 * pearl-select-sound is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * pearl-select-sound is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with pearl-select-sound.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************/

#include "mainwindow.h"
#include <unistd.h>
#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <QIcon>


int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    a.setWindowIcon(QIcon::fromTheme("pearl-select-sound"));

    QTranslator qtTran;
    qtTran.load(QString("qt_") + QLocale::system().name());
    a.installTranslator(&qtTran);

    QTranslator appTran;
    appTran.load(QString("pearl-select-sound_") + QLocale::system().name(), "/usr/share/pearl-select-sound/locale");
    a.installTranslator(&appTran);

    MainWindow w;
    if(w.listCards().size() < 1) {
        return 0;
    } else {
        w.show();
        w.getDefault();
        return a.exec();
    }
}
