/* desktop-file-plugin.c generated by valac 0.42.5, the Vala compiler
 * generated from desktop-file-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>


#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ITEM_PROVIDER (synapse_item_provider_get_type ())
#define SYNAPSE_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider))
#define SYNAPSE_IS_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER))
#define SYNAPSE_ITEM_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProviderIface))

typedef struct _SynapseItemProvider SynapseItemProvider;
typedef struct _SynapseItemProviderIface SynapseItemProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN (synapse_desktop_file_plugin_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))

typedef struct _SynapseDesktopFilePlugin SynapseDesktopFilePlugin;
typedef struct _SynapseDesktopFilePluginClass SynapseDesktopFilePluginClass;
typedef struct _SynapseDesktopFilePluginPrivate SynapseDesktopFilePluginPrivate;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH (synapse_desktop_file_plugin_desktop_file_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))

typedef struct _SynapseDesktopFilePluginDesktopFileMatch SynapseDesktopFilePluginDesktopFileMatch;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchClass SynapseDesktopFilePluginDesktopFileMatchClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION (synapse_desktop_file_plugin_open_with_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))

typedef struct _SynapseDesktopFilePluginOpenWithAction SynapseDesktopFilePluginOpenWithAction;
typedef struct _SynapseDesktopFilePluginOpenWithActionClass SynapseDesktopFilePluginOpenWithActionClass;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY (synapse_data_sink_plugin_registry_get_type ())
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistryClass))

typedef struct _SynapseDataSinkPluginRegistry SynapseDataSinkPluginRegistry;
typedef struct _SynapseDataSinkPluginRegistryClass SynapseDataSinkPluginRegistryClass;
typedef void (*SynapsePluginRegisterFunc) (void);

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;

#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFilePluginLoadAllDesktopFilesData SynapseDesktopFilePluginLoadAllDesktopFilesData;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;


#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;


#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH (synapse_desktop_file_plugin_action_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatchClass))

typedef struct _SynapseDesktopFilePluginActionMatch SynapseDesktopFilePluginActionMatch;
typedef struct _SynapseDesktopFilePluginActionMatchClass SynapseDesktopFilePluginActionMatchClass;
typedef struct _Block14Data Block14Data;
typedef struct _SynapseDesktopFilePluginSearchData SynapseDesktopFilePluginSearchData;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
typedef struct _SynapseDesktopFilePluginActionMatchPrivate SynapseDesktopFilePluginActionMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchPrivate SynapseDesktopFilePluginDesktopFileMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES];
typedef struct _SynapseDesktopFilePluginOpenWithActionPrivate SynapseDesktopFilePluginOpenWithActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES];
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS
};
static guint synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseItemProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseItemProvider* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseItemProvider* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_query) (SynapseItemProvider* self, SynapseQuery* query);
	gboolean (*handles_empty_query) (SynapseItemProvider* self);
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseDesktopFilePlugin {
	GObject parent_instance;
	SynapseDesktopFilePluginPrivate * priv;
};

struct _SynapseDesktopFilePluginClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginPrivate {
	gboolean _enabled;
	GeeList* desktop_files;
	gboolean loading_in_progress;
	GeeMap* mimetype_map;
};

struct _SynapseDesktopFilePluginLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFilePlugin* self;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp0_;
	GeeList* _dfi_list;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	gint _dfi_size;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _dfi_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	SynapseDesktopFileInfo* dfi;
	GeeList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	GeeList* _tmp12_;
	SynapseDesktopFileInfo* _tmp13_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp14_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp15_;
};

struct _Block14Data {
	int _ref_count_;
	SynapseDesktopFilePlugin* self;
	gpointer _async_data_;
};

struct _SynapseDesktopFilePluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFilePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block14Data* _data14_;
	gboolean _tmp0_;
	gulong signal_id;
	gulong _tmp1_;
	gulong _tmp2_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp3_;
	SynapseQuery _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp8_;
	SynapseResultSet* _tmp9_;
	SynapseMatcherFlags _tmp10_;
	SynapseQuery _tmp11_;
	SynapseResultSet* _tmp12_;
	GError * _inner_error_;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseDesktopFilePluginActionMatch {
	GObject parent_instance;
	SynapseDesktopFilePluginActionMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginActionMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginActionMatchPrivate {
	gchar* _title;
	gchar* _icon_name;
	gchar* _description;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _filename;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* action_name;
};

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseDesktopFilePluginDesktopFileMatch {
	GObject parent_instance;
	SynapseDesktopFilePluginDesktopFileMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginDesktopFileMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginDesktopFileMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _generic_name;
	gchar* title_folded;
	gchar* _title_unaccented;
	gchar* _desktop_id;
	gchar* _exec;
};

struct _SynapseDesktopFilePluginOpenWithAction {
	GObject parent_instance;
	SynapseDesktopFilePluginOpenWithActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenWithActionClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginOpenWithActionPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	SynapseDesktopFileInfo* _desktop_info;
};


static gint SynapseDesktopFilePlugin_private_offset;
static gpointer synapse_desktop_file_plugin_parent_class = NULL;
static gint SynapseDesktopFilePluginActionMatch_private_offset;
static gpointer synapse_desktop_file_plugin_action_match_parent_class = NULL;
static SynapseMatchIface * synapse_desktop_file_plugin_action_match_synapse_match_parent_iface = NULL;
static gint SynapseDesktopFilePluginDesktopFileMatch_private_offset;
static gpointer synapse_desktop_file_plugin_desktop_file_match_parent_class = NULL;
static SynapseMatchIface * synapse_desktop_file_plugin_desktop_file_match_synapse_match_parent_iface = NULL;
static SynapseApplicationMatchIface * synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = NULL;
static gint SynapseDesktopFilePluginOpenWithAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_with_action_parent_class = NULL;
static SynapseMatchIface * synapse_desktop_file_plugin_open_with_action_synapse_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_desktop_file_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_desktop_file_plugin_synapse_item_provider_parent_iface = NULL;
static SynapseActionProviderIface * synapse_desktop_file_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_item_provider_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_desktop_file_plugin_get_type (void) G_GNUC_CONST;
static GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType synapse_desktop_file_plugin_open_with_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_register_plugin (void);
GType synapse_data_sink_plugin_registry_get_type (void) G_GNUC_CONST;
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_get_default (void);
void synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self,
                                                        GType plugin_type,
                                                        const gchar* title,
                                                        const gchar* description,
                                                        const gchar* icon_name,
                                                        SynapsePluginRegisterFunc reg_func,
                                                        gboolean runnable,
                                                        const gchar* runnable_error);
static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_plugin_load_all_desktop_files_async_ready_wrapper (GObject *source_object,
                                                                             GAsyncResult *res,
                                                                             void *user_data);
static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                                GAsyncResult* _res_);
static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_);
static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type,
                                                                                                             SynapseDesktopFileInfo* info);
static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                                    SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                                    gint base_relevancy);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
gfloat synapse_relevancy_service_get_application_popularity (SynapseRelevancyService* self,
                                                             const gchar* desktop_id);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self);
gint synapse_relevancy_service_compute_relevancy (gint base_relevancy,
                                                  gfloat modifier);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                              SynapseQuery* q,
                                              SynapseResultSet* results,
                                              SynapseMatcherFlags flags);
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self);
const gchar* synapse_match_get_description (SynapseMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static gchar** _vala_array_dup4 (gchar** self,
                          int length);
GType synapse_desktop_file_plugin_action_match_get_type (void) G_GNUC_CONST;
SynapseDesktopFilePluginActionMatch* synapse_desktop_file_plugin_action_match_new (const gchar* desktop_id,
                                                                                   const gchar* action_name);
SynapseDesktopFilePluginActionMatch* synapse_desktop_file_plugin_action_match_construct (GType object_type,
                                                                                         const gchar* desktop_id,
                                                                                         const gchar* action_name);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self);
static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                         SynapseQuery* q);
static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data);
static void synapse_desktop_file_plugin_real_search_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                              SynapseQuery* q,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda20_ (Block14Data* _data14_);
void synapse_item_provider_search (SynapseItemProvider* self,
                                   SynapseQuery* query,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
SynapseResultSet* synapse_item_provider_search_finish (SynapseItemProvider* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ____lambda20__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                              gpointer self);
static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self);
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
static SynapseResultSet* synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                                   SynapseQuery* query,
                                                                   SynapseMatch* match);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                                  const gchar* mime_type);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                                                                SynapseDesktopFileInfo* info);
const gchar* synapse_match_get_title (SynapseMatch* self);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_new (void);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_construct (GType object_type);
static GObject * synapse_desktop_file_plugin_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _synapse_desktop_file_plugin___lambda21_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda21__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                            gpointer self);
static void _synapse_desktop_file_plugin___lambda22_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda22__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                         gpointer self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
void synapse_desktop_file_plugin_action_match_set_app_info (SynapseDesktopFilePluginActionMatch* self,
                                                            GAppInfo* value);
static void synapse_desktop_file_plugin_action_match_real_execute (SynapseMatch* base,
                                                            SynapseMatch* match);
GAppInfo* synapse_desktop_file_plugin_action_match_get_app_info (SynapseDesktopFilePluginActionMatch* self);
const gchar* synapse_desktop_file_plugin_action_match_get_filename (SynapseDesktopFilePluginActionMatch* self);
void synapse_desktop_file_plugin_action_match_set_filename (SynapseDesktopFilePluginActionMatch* self,
                                                            const gchar* value);
gboolean synapse_desktop_file_plugin_action_match_get_needs_terminal (SynapseDesktopFilePluginActionMatch* self);
void synapse_desktop_file_plugin_action_match_set_needs_terminal (SynapseDesktopFilePluginActionMatch* self,
                                                                  gboolean value);
static void synapse_desktop_file_plugin_action_match_finalize (GObject * obj);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
static void _vala_synapse_desktop_file_plugin_action_match_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
static void _vala_synapse_desktop_file_plugin_action_match_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    SynapseDesktopFileInfo* info);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                              const gchar* value);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                                   gboolean value);
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
gchar* synapse_utils_remove_accents (const gchar* input);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                          const gchar* value);
const gchar* synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    const gchar* value);
const gchar* synapse_desktop_file_info_get_generic_name (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_plugin_desktop_file_match_set_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      const gchar* value);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (void);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type);
static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj);
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                             GAppInfo* value);
void synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                             const gchar* value);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static void synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                  SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                    SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base,
                                                                SynapseMatch* match);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj);
static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static void synapse_desktop_file_plugin_finalize (GObject * obj);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
static void _vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
static void _vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static inline gpointer
synapse_desktop_file_plugin_get_instance_private (SynapseDesktopFilePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePlugin_private_offset);
}


static void
synapse_desktop_file_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
	self = (SynapseDesktopFilePlugin*) base;
}


static void
synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
	self = (SynapseDesktopFilePlugin*) base;
}


static void
_synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_desktop_file_plugin_register_plugin ();
}


static void
synapse_desktop_file_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, "Application Search", _ ("Search for and run applications on your computer."), "system-run", _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}


static void
synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFilePluginLoadAllDesktopFilesData, _data_);
}


static void
synapse_desktop_file_plugin_load_all_desktop_files_async_ready_wrapper (GObject *source_object,
                                                                        GAsyncResult *res,
                                                                        void *user_data)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	_data_ = g_slice_new0 (SynapseDesktopFilePluginLoadAllDesktopFilesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_plugin_load_all_desktop_files_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_load_all_desktop_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_desktop_file_plugin_load_all_desktop_files_co (_data_);
}


static void
synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                           GAsyncResult* _res_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static gboolean
_synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_load_all_desktop_files_co (self);
	return result;
}


static gboolean
synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->loading_in_progress = TRUE;
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = synapse_desktop_file_service_get_default ();
	_data_->dfs = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->dfs;
		_data_->_tmp2_ = synapse_desktop_file_service_get_desktop_files (_data_->_tmp1_);
		_data_->_dfi_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_dfi_list;
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_dfi_size = _data_->_tmp5_;
		_data_->_dfi_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_dfi_index;
			_data_->_dfi_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_dfi_index;
			_data_->_tmp8_ = _data_->_dfi_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_dfi_list;
			_data_->_tmp10_ = _data_->_dfi_index;
			_data_->_tmp11_ = gee_list_get (_data_->_tmp9_, _data_->_tmp10_);
			_data_->dfi = (SynapseDesktopFileInfo*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->self->priv->desktop_files;
			_data_->_tmp13_ = _data_->dfi;
			_data_->_tmp14_ = synapse_desktop_file_plugin_desktop_file_match_new_for_info (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			gee_collection_add ((GeeCollection*) _data_->_tmp12_, _data_->_tmp15_);
			_g_object_unref0 (_data_->_tmp15_);
			_g_object_unref0 (_data_->dfi);
		}
		_g_object_unref0 (_data_->_dfi_list);
	}
	_data_->self->priv->loading_in_progress = FALSE;
	g_signal_emit (_data_->self, synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL], 0);
	_g_object_unref0 (_data_->dfs);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint
synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                               SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                               gint base_relevancy)
{
	gint result = 0;
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat popularity = 0.0F;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint r = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (dfm != NULL, 0);
	_tmp0_ = synapse_relevancy_service_get_default ();
	rs = _tmp0_;
	_tmp1_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
	_tmp2_ = _tmp1_;
	popularity = synapse_relevancy_service_get_application_popularity (rs, _tmp2_);
	r = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
	_tmp3_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
	_tmp4_ = _tmp3_;
	synapse_utils_logger_debug ((GObject*) self, "desktop-file-plugin.vala:182: relevancy for %s: %d", _tmp4_, r, NULL);
	result = r;
	_g_object_unref0 (rs);
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch55_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch55_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally55;
	__catch55_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally55:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar**
_vala_array_dup4 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void
synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                         SynapseQuery* q,
                                         SynapseResultSet* results,
                                         SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (q != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = *q;
	_tmp1_ = _tmp0_.query_string_folded;
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
	matchers = _tmp2_;
	{
		GeeList* _dfm_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _dfm_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _dfm_index = 0;
		_tmp3_ = self->priv->desktop_files;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_dfm_list = _tmp4_;
		_tmp5_ = _dfm_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_dfm_size = _tmp7_;
		_dfm_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			SynapseDesktopFilePluginDesktopFileMatch* dfm = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			const gchar* folded_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp14_;
			const gchar* _tmp15_;
			const gchar* unaccented_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* comment = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* generic_name = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean matched = FALSE;
			gchar* id = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			GDesktopAppInfo* desktop_app_info = NULL;
			const gchar* _tmp65_;
			GDesktopAppInfo* _tmp66_;
			gchar** actions = NULL;
			GDesktopAppInfo* _tmp67_;
			gchar** _tmp68_;
			gchar** _tmp69_;
			gchar** _tmp70_;
			gint _tmp70__length1;
			gint actions_length1;
			gint _actions_size_;
			gchar** _tmp71_;
			gint _tmp71__length1;
			gboolean _tmp115_ = FALSE;
			gboolean _tmp116_;
			gboolean _tmp131_ = FALSE;
			gboolean _tmp132_;
			_tmp8_ = _dfm_index;
			_dfm_index = _tmp8_ + 1;
			_tmp9_ = _dfm_index;
			_tmp10_ = _dfm_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _dfm_list;
			_tmp12_ = _dfm_index;
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
			dfm = (SynapseDesktopFilePluginDesktopFileMatch*) _tmp13_;
			_tmp14_ = dfm;
			_tmp15_ = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (_tmp14_);
			folded_title = _tmp15_;
			_tmp16_ = dfm;
			_tmp17_ = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (_tmp16_);
			_tmp18_ = _tmp17_;
			unaccented_title = _tmp18_;
			_tmp19_ = dfm;
			_tmp20_ = synapse_match_get_description ((SynapseMatch*) _tmp19_);
			_tmp21_ = _tmp20_;
			comment = _tmp21_;
			_tmp22_ = dfm;
			_tmp23_ = synapse_desktop_file_plugin_desktop_file_match_get_generic_name (_tmp22_);
			_tmp24_ = _tmp23_;
			generic_name = _tmp24_;
			matched = FALSE;
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp25_;
				GeeList* _tmp26_;
				gint _matcher_size = 0;
				GeeList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _matcher_index = 0;
				_tmp25_ = matchers;
				_tmp26_ = _g_object_ref0 (_tmp25_);
				_matcher_list = _tmp26_;
				_tmp27_ = _matcher_list;
				_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_matcher_size = _tmp29_;
				_matcher_index = -1;
				while (TRUE) {
					gint _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp33_;
					gint _tmp34_;
					gpointer _tmp35_;
					GMatchInfo* info = NULL;
					GeeMapEntry* _tmp36_;
					gconstpointer _tmp37_;
					GRegex* _tmp38_;
					const gchar* _tmp39_;
					GMatchInfo* _tmp40_ = NULL;
					gboolean _tmp41_;
					_tmp30_ = _matcher_index;
					_matcher_index = _tmp30_ + 1;
					_tmp31_ = _matcher_index;
					_tmp32_ = _matcher_size;
					if (!(_tmp31_ < _tmp32_)) {
						break;
					}
					_tmp33_ = _matcher_list;
					_tmp34_ = _matcher_index;
					_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
					matcher = (GeeMapEntry*) _tmp35_;
					_tmp36_ = matcher;
					_tmp37_ = gee_map_entry_get_key (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = folded_title;
					_tmp41_ = g_regex_match ((GRegex*) _tmp38_, _tmp39_, 0, &_tmp40_);
					_g_match_info_unref0 (info);
					info = _tmp40_;
					if (_tmp41_) {
						SynapseDesktopFilePluginDesktopFileMatch* _tmp42_;
						SynapseDesktopFilePluginDesktopFileMatch* _tmp43_;
						GeeMapEntry* _tmp44_;
						gconstpointer _tmp45_;
						gint _tmp46_;
						_tmp42_ = dfm;
						_tmp43_ = dfm;
						_tmp44_ = matcher;
						_tmp45_ = gee_map_entry_get_value (_tmp44_);
						_tmp46_ = _tmp45_;
						synapse_result_set_add (results, (SynapseMatch*) _tmp42_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp43_, (gint) ((gintptr) _tmp46_)));
						matched = TRUE;
						_g_match_info_unref0 (info);
						_g_object_unref0 (matcher);
						break;
					} else {
						gboolean _tmp47_ = FALSE;
						const gchar* _tmp48_;
						_tmp48_ = unaccented_title;
						if (_tmp48_ != NULL) {
							GeeMapEntry* _tmp49_;
							gconstpointer _tmp50_;
							GRegex* _tmp51_;
							const gchar* _tmp52_;
							_tmp49_ = matcher;
							_tmp50_ = gee_map_entry_get_key (_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = unaccented_title;
							_tmp47_ = g_regex_match ((GRegex*) _tmp51_, _tmp52_, 0, NULL);
						} else {
							_tmp47_ = FALSE;
						}
						if (_tmp47_) {
							SynapseDesktopFilePluginDesktopFileMatch* _tmp53_;
							SynapseDesktopFilePluginDesktopFileMatch* _tmp54_;
							GeeMapEntry* _tmp55_;
							gconstpointer _tmp56_;
							gint _tmp57_;
							_tmp53_ = dfm;
							_tmp54_ = dfm;
							_tmp55_ = matcher;
							_tmp56_ = gee_map_entry_get_value (_tmp55_);
							_tmp57_ = _tmp56_;
							synapse_result_set_add (results, (SynapseMatch*) _tmp53_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp54_, ((gint) ((gintptr) _tmp57_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
							matched = TRUE;
							_g_match_info_unref0 (info);
							_g_object_unref0 (matcher);
							break;
						} else {
							GMatchInfo* _tmp58_;
							_tmp58_ = info;
							if (g_match_info_is_partial_match (_tmp58_)) {
								SynapseDesktopFilePluginDesktopFileMatch* _tmp59_;
								SynapseDesktopFilePluginDesktopFileMatch* _tmp60_;
								_tmp59_ = dfm;
								_tmp60_ = dfm;
								synapse_result_set_add (results, (SynapseMatch*) _tmp59_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp60_, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
								matched = TRUE;
								_g_match_info_unref0 (info);
								_g_object_unref0 (matcher);
								break;
							}
						}
					}
					_g_match_info_unref0 (info);
					_g_object_unref0 (matcher);
				}
				_g_object_unref0 (_matcher_list);
			}
			_tmp61_ = dfm;
			_tmp62_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = string_replace (_tmp63_, "application://", "");
			id = _tmp64_;
			_tmp65_ = id;
			_tmp66_ = g_desktop_app_info_new (_tmp65_);
			desktop_app_info = _tmp66_;
			_tmp67_ = desktop_app_info;
			_tmp69_ = _tmp68_ = g_desktop_app_info_list_actions (_tmp67_);
			_tmp70_ = (_tmp69_ != NULL) ? _vala_array_dup4 (_tmp69_, _vala_array_length (_tmp68_)) : ((gpointer) _tmp69_);
			_tmp70__length1 = _vala_array_length (_tmp68_);
			actions = _tmp70_;
			actions_length1 = _tmp70__length1;
			_actions_size_ = actions_length1;
			_tmp71_ = actions;
			_tmp71__length1 = actions_length1;
			{
				gchar** action_collection = NULL;
				gint action_collection_length1 = 0;
				gint _action_collection_size_ = 0;
				gint action_it = 0;
				action_collection = _tmp71_;
				action_collection_length1 = _tmp71__length1;
				for (action_it = 0; action_it < _tmp71__length1; action_it = action_it + 1) {
					gchar* _tmp72_;
					gchar* action = NULL;
					_tmp72_ = g_strdup (action_collection[action_it]);
					action = _tmp72_;
					{
						gchar* title = NULL;
						GDesktopAppInfo* _tmp73_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						gchar* _tmp77_;
						gchar* _tmp78_;
						_tmp73_ = desktop_app_info;
						_tmp74_ = action;
						_tmp75_ = g_desktop_app_info_get_action_name (_tmp73_, _tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = g_utf8_strdown (_tmp76_, (gssize) -1);
						_tmp78_ = _tmp77_;
						_g_free0 (_tmp76_);
						title = _tmp78_;
						{
							GeeList* _matcher_list = NULL;
							GeeList* _tmp79_;
							GeeList* _tmp80_;
							gint _matcher_size = 0;
							GeeList* _tmp81_;
							gint _tmp82_;
							gint _tmp83_;
							gint _matcher_index = 0;
							_tmp79_ = matchers;
							_tmp80_ = _g_object_ref0 (_tmp79_);
							_matcher_list = _tmp80_;
							_tmp81_ = _matcher_list;
							_tmp82_ = gee_collection_get_size ((GeeCollection*) _tmp81_);
							_tmp83_ = _tmp82_;
							_matcher_size = _tmp83_;
							_matcher_index = -1;
							while (TRUE) {
								gint _tmp84_;
								gint _tmp85_;
								gint _tmp86_;
								GeeMapEntry* matcher = NULL;
								GeeList* _tmp87_;
								gint _tmp88_;
								gpointer _tmp89_;
								GMatchInfo* action_info = NULL;
								gboolean _tmp90_ = FALSE;
								gboolean _tmp91_ = FALSE;
								GeeMapEntry* _tmp92_;
								gconstpointer _tmp93_;
								GRegex* _tmp94_;
								const gchar* _tmp95_;
								GMatchInfo* _tmp96_ = NULL;
								gboolean _tmp97_;
								_tmp84_ = _matcher_index;
								_matcher_index = _tmp84_ + 1;
								_tmp85_ = _matcher_index;
								_tmp86_ = _matcher_size;
								if (!(_tmp85_ < _tmp86_)) {
									break;
								}
								_tmp87_ = _matcher_list;
								_tmp88_ = _matcher_index;
								_tmp89_ = gee_list_get (_tmp87_, _tmp88_);
								matcher = (GeeMapEntry*) _tmp89_;
								_tmp92_ = matcher;
								_tmp93_ = gee_map_entry_get_key (_tmp92_);
								_tmp94_ = _tmp93_;
								_tmp95_ = title;
								_tmp97_ = g_regex_match ((GRegex*) _tmp94_, _tmp95_, 0, &_tmp96_);
								_g_match_info_unref0 (action_info);
								action_info = _tmp96_;
								if (_tmp97_) {
									_tmp91_ = TRUE;
								} else {
									const gchar* _tmp98_;
									SynapseQuery _tmp99_;
									const gchar* _tmp100_;
									_tmp98_ = title;
									_tmp99_ = *q;
									_tmp100_ = _tmp99_.query_string_folded;
									_tmp91_ = string_contains (_tmp98_, _tmp100_);
								}
								if (_tmp91_) {
									_tmp90_ = TRUE;
								} else {
									const gchar* _tmp101_;
									SynapseQuery _tmp102_;
									const gchar* _tmp103_;
									_tmp101_ = title;
									_tmp102_ = *q;
									_tmp103_ = _tmp102_.query_string;
									_tmp90_ = g_str_has_prefix (_tmp101_, _tmp103_);
								}
								if (_tmp90_) {
									SynapseDesktopFilePluginActionMatch* am = NULL;
									const gchar* _tmp104_;
									const gchar* _tmp105_;
									SynapseDesktopFilePluginActionMatch* _tmp106_;
									SynapseDesktopFilePluginActionMatch* _tmp107_;
									SynapseDesktopFilePluginDesktopFileMatch* _tmp108_;
									_tmp104_ = id;
									_tmp105_ = action;
									_tmp106_ = synapse_desktop_file_plugin_action_match_new (_tmp104_, _tmp105_);
									am = _tmp106_;
									_tmp107_ = am;
									_tmp108_ = dfm;
									synapse_result_set_add (results, (SynapseMatch*) _tmp107_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp108_, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
									matched = TRUE;
									_g_object_unref0 (am);
									_g_match_info_unref0 (action_info);
									_g_object_unref0 (matcher);
									break;
								} else {
									GMatchInfo* _tmp109_;
									_tmp109_ = action_info;
									if (g_match_info_is_partial_match (_tmp109_)) {
										SynapseDesktopFilePluginActionMatch* am = NULL;
										const gchar* _tmp110_;
										const gchar* _tmp111_;
										SynapseDesktopFilePluginActionMatch* _tmp112_;
										SynapseDesktopFilePluginActionMatch* _tmp113_;
										SynapseDesktopFilePluginDesktopFileMatch* _tmp114_;
										_tmp110_ = id;
										_tmp111_ = action;
										_tmp112_ = synapse_desktop_file_plugin_action_match_new (_tmp110_, _tmp111_);
										am = _tmp112_;
										_tmp113_ = am;
										_tmp114_ = dfm;
										synapse_result_set_add (results, (SynapseMatch*) _tmp113_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp114_, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
										matched = TRUE;
										_g_object_unref0 (am);
										_g_match_info_unref0 (action_info);
										_g_object_unref0 (matcher);
										break;
									}
								}
								_g_match_info_unref0 (action_info);
								_g_object_unref0 (matcher);
							}
							_g_object_unref0 (_matcher_list);
						}
						_g_free0 (title);
						_g_free0 (action);
					}
				}
			}
			_tmp116_ = matched;
			if (!_tmp116_) {
				gboolean _tmp117_ = FALSE;
				const gchar* _tmp118_;
				gchar* _tmp119_;
				gchar* _tmp120_;
				SynapseQuery _tmp121_;
				const gchar* _tmp122_;
				gboolean _tmp123_;
				_tmp118_ = comment;
				_tmp119_ = g_utf8_strdown (_tmp118_, (gssize) -1);
				_tmp120_ = _tmp119_;
				_tmp121_ = *q;
				_tmp122_ = _tmp121_.query_string_folded;
				_tmp123_ = string_contains (_tmp120_, _tmp122_);
				_g_free0 (_tmp120_);
				if (_tmp123_) {
					_tmp117_ = TRUE;
				} else {
					const gchar* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					SynapseQuery _tmp127_;
					const gchar* _tmp128_;
					_tmp124_ = generic_name;
					_tmp125_ = g_utf8_strdown (_tmp124_, (gssize) -1);
					_tmp126_ = _tmp125_;
					_tmp127_ = *q;
					_tmp128_ = _tmp127_.query_string_folded;
					_tmp117_ = string_contains (_tmp126_, _tmp128_);
					_g_free0 (_tmp126_);
				}
				_tmp115_ = _tmp117_;
			} else {
				_tmp115_ = FALSE;
			}
			if (_tmp115_) {
				SynapseDesktopFilePluginDesktopFileMatch* _tmp129_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp130_;
				_tmp129_ = dfm;
				_tmp130_ = dfm;
				synapse_result_set_add (results, (SynapseMatch*) _tmp129_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp130_, (gint) (SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM)));
				matched = TRUE;
			}
			_tmp132_ = matched;
			if (!_tmp132_) {
				SynapseDesktopFilePluginDesktopFileMatch* _tmp133_;
				const gchar* _tmp134_;
				const gchar* _tmp135_;
				SynapseQuery _tmp136_;
				const gchar* _tmp137_;
				_tmp133_ = dfm;
				_tmp134_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = *q;
				_tmp137_ = _tmp136_.query_string;
				_tmp131_ = g_str_has_prefix (_tmp135_, _tmp137_);
			} else {
				_tmp131_ = FALSE;
			}
			if (_tmp131_) {
				SynapseMatchScore _tmp138_ = 0;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp139_;
				const gchar* _tmp140_;
				const gchar* _tmp141_;
				SynapseQuery _tmp142_;
				const gchar* _tmp143_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp144_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp145_;
				_tmp139_ = dfm;
				_tmp140_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = *q;
				_tmp143_ = _tmp142_.query_string;
				if (g_strcmp0 (_tmp141_, _tmp143_) == 0) {
					_tmp138_ = SYNAPSE_MATCH_SCORE_VERY_GOOD;
				} else {
					_tmp138_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
				}
				_tmp144_ = dfm;
				_tmp145_ = dfm;
				synapse_result_set_add (results, (SynapseMatch*) _tmp144_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp145_, (gint) _tmp138_));
			}
			actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (desktop_app_info);
			_g_free0 (id);
			_g_object_unref0 (dfm);
		}
		_g_object_unref0 (_dfm_list);
	}
	_g_object_unref0 (matchers);
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean
synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                SynapseQuery* q)
{
	SynapseDesktopFilePlugin * self;
	gboolean result = FALSE;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	self = (SynapseDesktopFilePlugin*) base;
	g_return_val_if_fail (q != NULL, FALSE);
	_tmp0_ = *q;
	_tmp1_ = _tmp0_.query_type;
	if (!((_tmp1_ & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *q;
	_tmp3_ = _tmp2_.query_string;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void
synapse_desktop_file_plugin_real_search_data_free (gpointer _data)
{
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->q);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFilePluginSearchData, _data_);
}


static void
synapse_desktop_file_plugin_real_search_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	SynapseDesktopFilePluginSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFilePlugin * self;
	SynapseDesktopFilePluginSearchData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_ = {0};
	self = (SynapseDesktopFilePlugin*) base;
	_data_ = g_slice_new0 (SynapseDesktopFilePluginSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_plugin_real_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *q;
	synapse_query_copy (&_tmp1_, &_tmp2_);
	synapse_query_destroy (&_data_->q);
	_data_->q = _tmp2_;
	synapse_desktop_file_plugin_real_search_co (_data_);
}


static SynapseResultSet*
synapse_desktop_file_plugin_real_search_finish (SynapseItemProvider* base,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	SynapseResultSet* result;
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		SynapseDesktopFilePlugin* self;
		self = _data14_->self;
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static void
___lambda20_ (Block14Data* _data14_)
{
	SynapseDesktopFilePlugin* self;
	self = _data14_->self;
	synapse_desktop_file_plugin_real_search_co (_data14_->_async_data_);
}


static void
____lambda20__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                         gpointer self)
{
	___lambda20_ (self);
}


static gboolean
_synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_real_search_co (self);
	return result;
}


static gboolean
synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data14_ = g_slice_new0 (Block14Data);
	_data_->_data14_->_ref_count_ = 1;
	_data_->_data14_->self = g_object_ref (_data_->self);
	_data_->_data14_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->loading_in_progress;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = g_signal_connect_data (_data_->self, "load-complete", (GCallback) ____lambda20__synapse_desktop_file_plugin_load_complete, block14_data_ref (_data_->_data14_), (GClosureNotify) block14_data_unref, 0);
		_data_->signal_id = _data_->_tmp1_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp2_ = _data_->signal_id;
		g_signal_handler_disconnect (_data_->self, _data_->_tmp2_);
	} else {
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, _synapse_desktop_file_plugin_real_search_co_gsource_func, _data_, NULL);
		_data_->_state_ = 2;
		return FALSE;
		_state_2:
		;
	}
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			block14_data_unref (_data_->_data14_);
			_data_->_data14_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block14_data_unref (_data_->_data14_);
			_data_->_data14_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp3_ = synapse_result_set_new ();
	_data_->_result_ = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->q;
	_data_->_tmp5_ = _data_->_tmp4_.query_string;
	_data_->_tmp6_ = strlen (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_tmp7_ == 1) {
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
		_data_->_tmp8_ = _data_->q;
		_data_->_tmp9_ = _data_->_result_;
		_data_->_tmp10_ = _data_->flags;
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_);
	} else {
		_data_->_tmp11_ = _data_->q;
		_data_->_tmp12_ = _data_->_result_;
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp11_, _data_->_tmp12_, 0);
	}
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->_result_);
			block14_data_unref (_data_->_data14_);
			_data_->_data14_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->_result_);
			block14_data_unref (_data_->_data14_);
			_data_->_data14_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_result_;
	block14_data_unref (_data_->_data14_);
	_data_->_data14_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static SynapseResultSet*
synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                 SynapseQuery* query,
                                                 SynapseMatch* match)
{
	SynapseDesktopFilePlugin * self;
	SynapseResultSet* result = NULL;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp2_;
	SynapseUriMatch* _tmp3_;
	SynapseUriMatch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeList* ow_list = NULL;
	GeeMap* _tmp7_;
	SynapseUriMatch* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gpointer _tmp11_;
	GeeList* _tmp12_;
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp46_;
	SynapseQuery _tmp47_;
	const gchar* _tmp48_;
	self = (SynapseDesktopFilePlugin*) base;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		result = NULL;
		return result;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
	uri_match = _tmp2_;
	_tmp3_ = uri_match;
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
	_tmp4_ = uri_match;
	_tmp5_ = synapse_uri_match_get_mime_type (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_object_unref0 (uri_match);
		return result;
	}
	_tmp7_ = self->priv->mimetype_map;
	_tmp8_ = uri_match;
	_tmp9_ = synapse_uri_match_get_mime_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_map_get (_tmp7_, _tmp10_);
	ow_list = (GeeList*) _tmp11_;
	_tmp12_ = ow_list;
	if (_tmp12_ == NULL) {
		GeeLinkedList* _tmp13_;
		GeeMap* _tmp14_;
		SynapseUriMatch* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GeeList* _tmp18_;
		SynapseDesktopFileService* dfs = NULL;
		SynapseDesktopFileService* _tmp19_;
		GeeList* list_for_mimetype = NULL;
		SynapseDesktopFileService* _tmp20_;
		SynapseUriMatch* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GeeList* _tmp24_;
		GeeList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp13_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (ow_list);
		ow_list = (GeeList*) _tmp13_;
		_tmp14_ = self->priv->mimetype_map;
		_tmp15_ = uri_match;
		_tmp16_ = synapse_uri_match_get_mime_type (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = ow_list;
		gee_map_set (_tmp14_, _tmp17_, _tmp18_);
		_tmp19_ = synapse_desktop_file_service_get_default ();
		dfs = _tmp19_;
		_tmp20_ = dfs;
		_tmp21_ = uri_match;
		_tmp22_ = synapse_uri_match_get_mime_type (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = synapse_desktop_file_service_get_desktop_files_for_type (_tmp20_, _tmp23_);
		list_for_mimetype = _tmp24_;
		_tmp25_ = list_for_mimetype;
		_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ > 1) {
			{
				GeeList* _entry_list = NULL;
				GeeList* _tmp28_;
				GeeList* _tmp29_;
				gint _entry_size = 0;
				GeeList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _entry_index = 0;
				_tmp28_ = list_for_mimetype;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_entry_list = _tmp29_;
				_tmp30_ = _entry_list;
				_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_entry_size = _tmp32_;
				_entry_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					gint _tmp35_;
					SynapseDesktopFileInfo* entry = NULL;
					GeeList* _tmp36_;
					gint _tmp37_;
					gpointer _tmp38_;
					GeeList* _tmp39_;
					SynapseDesktopFileInfo* _tmp40_;
					SynapseDesktopFilePluginOpenWithAction* _tmp41_;
					SynapseDesktopFilePluginOpenWithAction* _tmp42_;
					_tmp33_ = _entry_index;
					_entry_index = _tmp33_ + 1;
					_tmp34_ = _entry_index;
					_tmp35_ = _entry_size;
					if (!(_tmp34_ < _tmp35_)) {
						break;
					}
					_tmp36_ = _entry_list;
					_tmp37_ = _entry_index;
					_tmp38_ = gee_list_get (_tmp36_, _tmp37_);
					entry = (SynapseDesktopFileInfo*) _tmp38_;
					_tmp39_ = ow_list;
					_tmp40_ = entry;
					_tmp41_ = synapse_desktop_file_plugin_open_with_action_new (_tmp40_);
					_tmp42_ = _tmp41_;
					gee_collection_add ((GeeCollection*) _tmp39_, _tmp42_);
					_g_object_unref0 (_tmp42_);
					_g_object_unref0 (entry);
				}
				_g_object_unref0 (_entry_list);
			}
		} else {
			result = NULL;
			_g_object_unref0 (list_for_mimetype);
			_g_object_unref0 (dfs);
			_g_object_unref0 (ow_list);
			_g_object_unref0 (uri_match);
			return result;
		}
		_g_object_unref0 (list_for_mimetype);
		_g_object_unref0 (dfs);
	} else {
		GeeList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		_tmp43_ = ow_list;
		_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_ == 0) {
			result = NULL;
			_g_object_unref0 (ow_list);
			_g_object_unref0 (uri_match);
			return result;
		}
	}
	_tmp46_ = synapse_result_set_new ();
	rs = _tmp46_;
	_tmp47_ = *query;
	_tmp48_ = _tmp47_.query_string;
	if (g_strcmp0 (_tmp48_, "") == 0) {
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp49_;
			GeeList* _tmp50_;
			gint _action_size = 0;
			GeeList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gint _action_index = 0;
			_tmp49_ = ow_list;
			_tmp50_ = _g_object_ref0 (_tmp49_);
			_action_list = _tmp50_;
			_tmp51_ = _action_list;
			_tmp52_ = gee_collection_get_size ((GeeCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_action_size = _tmp53_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				SynapseDesktopFilePluginOpenWithAction* action = NULL;
				GeeList* _tmp57_;
				gint _tmp58_;
				gpointer _tmp59_;
				SynapseResultSet* _tmp60_;
				SynapseDesktopFilePluginOpenWithAction* _tmp61_;
				_tmp54_ = _action_index;
				_action_index = _tmp54_ + 1;
				_tmp55_ = _action_index;
				_tmp56_ = _action_size;
				if (!(_tmp55_ < _tmp56_)) {
					break;
				}
				_tmp57_ = _action_list;
				_tmp58_ = _action_index;
				_tmp59_ = gee_list_get (_tmp57_, _tmp58_);
				action = (SynapseDesktopFilePluginOpenWithAction*) _tmp59_;
				_tmp60_ = rs;
				_tmp61_ = action;
				synapse_result_set_add (_tmp60_, (SynapseMatch*) _tmp61_, (gint) SYNAPSE_MATCH_SCORE_POOR);
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp62_;
		const gchar* _tmp63_;
		GeeList* _tmp64_;
		_tmp62_ = *query;
		_tmp63_ = _tmp62_.query_string;
		_tmp64_ = synapse_query_get_matchers_for_query (_tmp63_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
		matchers = _tmp64_;
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp65_;
			GeeList* _tmp66_;
			gint _action_size = 0;
			GeeList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _action_index = 0;
			_tmp65_ = ow_list;
			_tmp66_ = _g_object_ref0 (_tmp65_);
			_action_list = _tmp66_;
			_tmp67_ = _action_list;
			_tmp68_ = gee_collection_get_size ((GeeCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_action_size = _tmp69_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				SynapseDesktopFilePluginOpenWithAction* action = NULL;
				GeeList* _tmp73_;
				gint _tmp74_;
				gpointer _tmp75_;
				_tmp70_ = _action_index;
				_action_index = _tmp70_ + 1;
				_tmp71_ = _action_index;
				_tmp72_ = _action_size;
				if (!(_tmp71_ < _tmp72_)) {
					break;
				}
				_tmp73_ = _action_list;
				_tmp74_ = _action_index;
				_tmp75_ = gee_list_get (_tmp73_, _tmp74_);
				action = (SynapseDesktopFilePluginOpenWithAction*) _tmp75_;
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp76_;
					GeeList* _tmp77_;
					gint _matcher_size = 0;
					GeeList* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					gint _matcher_index = 0;
					_tmp76_ = matchers;
					_tmp77_ = _g_object_ref0 (_tmp76_);
					_matcher_list = _tmp77_;
					_tmp78_ = _matcher_list;
					_tmp79_ = gee_collection_get_size ((GeeCollection*) _tmp78_);
					_tmp80_ = _tmp79_;
					_matcher_size = _tmp80_;
					_matcher_index = -1;
					while (TRUE) {
						gint _tmp81_;
						gint _tmp82_;
						gint _tmp83_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp84_;
						gint _tmp85_;
						gpointer _tmp86_;
						GeeMapEntry* _tmp87_;
						gconstpointer _tmp88_;
						GRegex* _tmp89_;
						SynapseDesktopFilePluginOpenWithAction* _tmp90_;
						const gchar* _tmp91_;
						const gchar* _tmp92_;
						_tmp81_ = _matcher_index;
						_matcher_index = _tmp81_ + 1;
						_tmp82_ = _matcher_index;
						_tmp83_ = _matcher_size;
						if (!(_tmp82_ < _tmp83_)) {
							break;
						}
						_tmp84_ = _matcher_list;
						_tmp85_ = _matcher_index;
						_tmp86_ = gee_list_get (_tmp84_, _tmp85_);
						matcher = (GeeMapEntry*) _tmp86_;
						_tmp87_ = matcher;
						_tmp88_ = gee_map_entry_get_key (_tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = action;
						_tmp91_ = synapse_match_get_title ((SynapseMatch*) _tmp90_);
						_tmp92_ = _tmp91_;
						if (g_regex_match ((GRegex*) _tmp89_, _tmp92_, 0, NULL)) {
							SynapseResultSet* _tmp93_;
							SynapseDesktopFilePluginOpenWithAction* _tmp94_;
							GeeMapEntry* _tmp95_;
							gconstpointer _tmp96_;
							gint _tmp97_;
							_tmp93_ = rs;
							_tmp94_ = action;
							_tmp95_ = matcher;
							_tmp96_ = gee_map_entry_get_value (_tmp95_);
							_tmp97_ = _tmp96_;
							synapse_result_set_add (_tmp93_, (SynapseMatch*) _tmp94_, (gint) ((gintptr) _tmp97_));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
					_g_object_unref0 (_matcher_list);
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
		_g_object_unref0 (matchers);
	}
	result = rs;
	_g_object_unref0 (ow_list);
	_g_object_unref0 (uri_match);
	return result;
}


SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_construct (GType object_type)
{
	SynapseDesktopFilePlugin * self = NULL;
	self = (SynapseDesktopFilePlugin*) g_object_new (object_type, NULL);
	return self;
}


SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_new (void)
{
	return synapse_desktop_file_plugin_construct (SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN);
}


static gboolean
synapse_desktop_file_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDesktopFilePlugin* self;
	gboolean _tmp0_;
	self = (SynapseDesktopFilePlugin*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_real_set_enabled (SynapseActivatable* base,
                                              gboolean value)
{
	SynapseDesktopFilePlugin* self;
	self = (SynapseDesktopFilePlugin*) base;
	if (synapse_desktop_file_plugin_real_get_enabled (base) != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY]);
	}
}


static void
_synapse_desktop_file_plugin___lambda21_ (SynapseDesktopFilePlugin* self)
{
	self->priv->loading_in_progress = TRUE;
}


static void
__synapse_desktop_file_plugin___lambda21__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                       gpointer self)
{
	_synapse_desktop_file_plugin___lambda21_ ((SynapseDesktopFilePlugin*) self);
}


static void
_synapse_desktop_file_plugin___lambda22_ (SynapseDesktopFilePlugin* self)
{
	GeeMap* _tmp0_;
	GeeList* _tmp1_;
	_tmp0_ = self->priv->mimetype_map;
	gee_map_clear (_tmp0_);
	_tmp1_ = self->priv->desktop_files;
	gee_collection_clear ((GeeCollection*) _tmp1_);
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
}


static void
__synapse_desktop_file_plugin___lambda22__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                    gpointer self)
{
	_synapse_desktop_file_plugin___lambda22_ ((SynapseDesktopFilePlugin*) self);
}


static GObject *
synapse_desktop_file_plugin_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePlugin * self;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	_tmp0_ = gee_array_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->desktop_files);
	self->priv->desktop_files = (GeeList*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mimetype_map);
	self->priv->mimetype_map = (GeeMap*) _tmp1_;
	_tmp2_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp2_;
	_tmp3_ = dfs;
	g_signal_connect_object (_tmp3_, "reload-started", (GCallback) __synapse_desktop_file_plugin___lambda21__synapse_desktop_file_service_reload_started, self, 0);
	_tmp4_ = dfs;
	g_signal_connect_object (_tmp4_, "reload-done", (GCallback) __synapse_desktop_file_plugin___lambda22__synapse_desktop_file_service_reload_done, self, 0);
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
	_g_object_unref0 (dfs);
	return obj;
}


static inline gpointer
synapse_desktop_file_plugin_action_match_get_instance_private (SynapseDesktopFilePluginActionMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginActionMatch_private_offset);
}


SynapseDesktopFilePluginActionMatch*
synapse_desktop_file_plugin_action_match_construct (GType object_type,
                                                    const gchar* desktop_id,
                                                    const gchar* action_name)
{
	SynapseDesktopFilePluginActionMatch * self = NULL;
	GDesktopAppInfo* desktop_app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIcon* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	self = (SynapseDesktopFilePluginActionMatch*) g_object_new (object_type, NULL);
	_tmp0_ = g_desktop_app_info_new (desktop_id);
	desktop_app_info = _tmp0_;
	_tmp1_ = g_desktop_app_info_get_action_name (desktop_app_info, action_name);
	_tmp2_ = _tmp1_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_app_info_get_icon ((GAppInfo*) desktop_app_info);
	_tmp4_ = g_icon_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
	_g_free0 (_tmp5_);
	synapse_match_set_description ((SynapseMatch*) self, "");
	synapse_desktop_file_plugin_action_match_set_app_info (self, (GAppInfo*) desktop_app_info);
	_tmp6_ = g_strdup (action_name);
	_g_free0 (self->priv->action_name);
	self->priv->action_name = _tmp6_;
	_g_object_unref0 (desktop_app_info);
	return self;
}


SynapseDesktopFilePluginActionMatch*
synapse_desktop_file_plugin_action_match_new (const gchar* desktop_id,
                                              const gchar* action_name)
{
	return synapse_desktop_file_plugin_action_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, desktop_id, action_name);
}


static void
synapse_desktop_file_plugin_action_match_real_execute (SynapseMatch* base,
                                                       SynapseMatch* match)
{
	SynapseDesktopFilePluginActionMatch * self;
	GAppInfo* _tmp0_;
	const gchar* _tmp1_;
	GAppLaunchContext* _tmp2_;
	GAppLaunchContext* _tmp3_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_app_info;
	_tmp1_ = self->priv->action_name;
	_tmp2_ = g_app_launch_context_new ();
	_tmp3_ = _tmp2_;
	g_desktop_app_info_launch_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo), _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}


static const gchar*
synapse_desktop_file_plugin_action_match_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_action_match_real_set_title (SynapseMatch* base,
                                                         const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_action_match_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_action_match_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_action_match_real_set_icon_name (SynapseMatch* base,
                                                             const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_action_match_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_action_match_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_action_match_real_set_description (SynapseMatch* base,
                                                               const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_action_match_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY]);
	}
}


static gboolean
synapse_desktop_file_plugin_action_match_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginActionMatch* self;
	gboolean _tmp0_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_action_match_real_set_has_thumbnail (SynapseMatch* base,
                                                                 gboolean value)
{
	SynapseDesktopFilePluginActionMatch* self;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	if (synapse_desktop_file_plugin_action_match_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_action_match_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_action_match_real_set_thumbnail_path (SynapseMatch* base,
                                                                  const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_action_match_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_desktop_file_plugin_action_match_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDesktopFilePluginActionMatch* self;
	SynapseMatchType _tmp0_;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_action_match_real_set_match_type (SynapseMatch* base,
                                                              SynapseMatchType value)
{
	SynapseDesktopFilePluginActionMatch* self;
	self = (SynapseDesktopFilePluginActionMatch*) base;
	if (synapse_desktop_file_plugin_action_match_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_plugin_action_match_get_filename (SynapseDesktopFilePluginActionMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_plugin_action_match_set_filename (SynapseDesktopFilePluginActionMatch* self,
                                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_plugin_action_match_get_filename (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY]);
	}
}


GAppInfo*
synapse_desktop_file_plugin_action_match_get_app_info (SynapseDesktopFilePluginActionMatch* self)
{
	GAppInfo* result;
	GAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_plugin_action_match_set_app_info (SynapseDesktopFilePluginActionMatch* self,
                                                       GAppInfo* value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_plugin_action_match_get_app_info (self) != value) {
		GAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY]);
	}
}


gboolean
synapse_desktop_file_plugin_action_match_get_needs_terminal (SynapseDesktopFilePluginActionMatch* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_needs_terminal;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_plugin_action_match_set_needs_terminal (SynapseDesktopFilePluginActionMatch* self,
                                                             gboolean value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_plugin_action_match_get_needs_terminal (self) != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY]);
	}
}


static void
synapse_desktop_file_plugin_action_match_class_init (SynapseDesktopFilePluginActionMatchClass * klass)
{
	synapse_desktop_file_plugin_action_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginActionMatch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_action_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_action_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_action_match_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_desktop_file_plugin_action_match_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_desktop_file_plugin_action_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_action_match_real_execute;
	iface->get_title = synapse_desktop_file_plugin_action_match_real_get_title;
	iface->set_title = synapse_desktop_file_plugin_action_match_real_set_title;
	iface->get_icon_name = synapse_desktop_file_plugin_action_match_real_get_icon_name;
	iface->set_icon_name = synapse_desktop_file_plugin_action_match_real_set_icon_name;
	iface->get_description = synapse_desktop_file_plugin_action_match_real_get_description;
	iface->set_description = synapse_desktop_file_plugin_action_match_real_set_description;
	iface->get_has_thumbnail = synapse_desktop_file_plugin_action_match_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_desktop_file_plugin_action_match_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_desktop_file_plugin_action_match_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_desktop_file_plugin_action_match_real_set_thumbnail_path;
	iface->get_match_type = synapse_desktop_file_plugin_action_match_real_get_match_type;
	iface->set_match_type = synapse_desktop_file_plugin_action_match_real_set_match_type;
}


static void
synapse_desktop_file_plugin_action_match_instance_init (SynapseDesktopFilePluginActionMatch * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = synapse_desktop_file_plugin_action_match_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_icon_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_description = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
}


static void
synapse_desktop_file_plugin_action_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_filename);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->action_name);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_action_match_parent_class)->finalize (obj);
}


GType
synapse_desktop_file_plugin_action_match_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_action_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_action_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginActionMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_action_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginActionMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_action_match_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_action_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_action_match_type_id;
		synapse_desktop_file_plugin_action_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginActionMatch", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_action_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		SynapseDesktopFilePluginActionMatch_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_action_match_type_id, sizeof (SynapseDesktopFilePluginActionMatchPrivate));
		g_once_init_leave (&synapse_desktop_file_plugin_action_match_type_id__volatile, synapse_desktop_file_plugin_action_match_type_id);
	}
	return synapse_desktop_file_plugin_action_match_type_id__volatile;
}


static void
_vala_synapse_desktop_file_plugin_action_match_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_action_match_get_filename (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY:
		g_value_set_object (value, synapse_desktop_file_plugin_action_match_get_app_info (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_plugin_action_match_get_needs_terminal (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_desktop_file_plugin_action_match_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY:
		synapse_desktop_file_plugin_action_match_set_filename (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY:
		synapse_desktop_file_plugin_action_match_set_app_info (self, g_value_get_object (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY:
		synapse_desktop_file_plugin_action_match_set_needs_terminal (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
synapse_desktop_file_plugin_desktop_file_match_get_instance_private (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginDesktopFileMatch_private_offset);
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title_folded;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = synapse_match_get_title ((SynapseMatch*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
		_g_free0 (self->priv->title_folded);
		self->priv->title_folded = _tmp3_;
	}
	_tmp4_ = self->priv->title_folded;
	result = _tmp4_;
	return result;
}


static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type,
                                                                   SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = synapse_desktop_file_info_get_filename (info);
	_tmp1_ = _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, "filename", _tmp1_, "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, NULL);
	synapse_desktop_file_plugin_desktop_file_match_init_from_info (self, info);
	return self;
}


static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info)
{
	return synapse_desktop_file_plugin_desktop_file_match_construct_for_info (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, info);
}


static void
synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               SynapseDesktopFileInfo* info)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = synapse_desktop_file_info_get_name (info);
	_tmp1_ = _tmp0_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp1_);
	_tmp2_ = synapse_desktop_file_info_get_comment (info);
	_tmp3_ = _tmp2_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp3_);
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
	_tmp5_ = _tmp4_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
	_tmp6_ = synapse_desktop_file_info_get_exec (info);
	_tmp7_ = _tmp6_;
	synapse_desktop_file_plugin_desktop_file_match_set_exec (self, _tmp7_);
	_tmp8_ = synapse_desktop_file_info_get_needs_terminal (info);
	_tmp9_ = _tmp8_;
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp9_);
	_tmp10_ = synapse_desktop_file_info_get_name_folded (info);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->title_folded);
	self->priv->title_folded = _tmp11_;
	_tmp12_ = self->priv->title_folded;
	_tmp13_ = synapse_utils_remove_accents (_tmp12_);
	_tmp14_ = _tmp13_;
	synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = synapse_desktop_file_info_get_desktop_id (info);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("application://", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = synapse_desktop_file_info_get_generic_name (info);
	_tmp20_ = _tmp19_;
	synapse_desktop_file_plugin_desktop_file_match_set_generic_name (self, _tmp20_);
}


static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, NULL);
	return self;
}


static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new (void)
{
	return synapse_desktop_file_plugin_desktop_file_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH);
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_title (SynapseMatch* base,
                                                               const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_description (SynapseMatch* base,
                                                                     const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_icon_name (SynapseMatch* base,
                                                                   const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gboolean _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_has_thumbnail (SynapseMatch* base,
                                                                       gboolean value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_thumbnail_path (SynapseMatch* base,
                                                                        const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_desktop_file_plugin_desktop_file_match_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	SynapseMatchType _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_match_type (SynapseMatch* base,
                                                                    SynapseMatchType value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (synapse_desktop_file_plugin_desktop_file_match_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY]);
	}
}


static GAppInfo*
synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (SynapseApplicationMatch* base)
{
	GAppInfo* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	GAppInfo* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_app_info (SynapseApplicationMatch* base,
                                                                  GAppInfo* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (base) != value) {
		GAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY]);
	}
}


static gboolean
synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (SynapseApplicationMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gboolean _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_needs_terminal;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal (SynapseApplicationMatch* base,
                                                                        gboolean value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (base) != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_filename (SynapseApplicationMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_real_set_filename (SynapseApplicationMatch* base,
                                                                  const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_real_get_filename (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_set_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_get_generic_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title_unaccented;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title_unaccented);
		self->priv->_title_unaccented = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY]);
	}
}


static void
synapse_desktop_file_plugin_desktop_file_match_class_init (SynapseDesktopFilePluginDesktopFileMatchClass * klass)
{
	synapse_desktop_file_plugin_desktop_file_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginDesktopFileMatch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_desktop_file_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_desktop_file_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_desktop_file_match_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY] = g_param_spec_string ("title-unaccented", "title-unaccented", "title-unaccented", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_desktop_file_plugin_desktop_file_match_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_desktop_file_plugin_desktop_file_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_desktop_file_plugin_desktop_file_match_real_get_title;
	iface->set_title = synapse_desktop_file_plugin_desktop_file_match_real_set_title;
	iface->get_description = synapse_desktop_file_plugin_desktop_file_match_real_get_description;
	iface->set_description = synapse_desktop_file_plugin_desktop_file_match_real_set_description;
	iface->get_icon_name = synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name;
	iface->set_icon_name = synapse_desktop_file_plugin_desktop_file_match_real_set_icon_name;
	iface->get_has_thumbnail = synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_desktop_file_plugin_desktop_file_match_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_desktop_file_plugin_desktop_file_match_real_set_thumbnail_path;
	iface->get_match_type = synapse_desktop_file_plugin_desktop_file_match_real_get_match_type;
	iface->set_match_type = synapse_desktop_file_plugin_desktop_file_match_real_set_match_type;
}


static void
synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface)
{
	synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_desktop_file_plugin_desktop_file_match_real_get_app_info;
	iface->set_app_info = synapse_desktop_file_plugin_desktop_file_match_real_set_app_info;
	iface->get_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal;
	iface->get_filename = synapse_desktop_file_plugin_desktop_file_match_real_get_filename;
	iface->set_filename = synapse_desktop_file_plugin_desktop_file_match_real_set_filename;
}


static void
synapse_desktop_file_plugin_desktop_file_match_instance_init (SynapseDesktopFilePluginDesktopFileMatch * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = synapse_desktop_file_plugin_desktop_file_match_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
	_tmp2_ = g_strdup ("");
	self->priv->_generic_name = _tmp2_;
	self->priv->title_folded = NULL;
	self->priv->_title_unaccented = NULL;
	self->priv->_desktop_id = NULL;
}


static void
synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_generic_name);
	_g_free0 (self->priv->title_folded);
	_g_free0 (self->priv->_title_unaccented);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class)->finalize (obj);
}


static GType
synapse_desktop_file_plugin_desktop_file_match_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_desktop_file_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginDesktopFileMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_desktop_file_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginDesktopFileMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_desktop_file_match_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_desktop_file_match_type_id;
		synapse_desktop_file_plugin_desktop_file_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginDesktopFileMatch", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
		SynapseDesktopFilePluginDesktopFileMatch_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_desktop_file_match_type_id, sizeof (SynapseDesktopFilePluginDesktopFileMatchPrivate));
		g_once_init_leave (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile, synapse_desktop_file_plugin_desktop_file_match_type_id);
	}
	return synapse_desktop_file_plugin_desktop_file_match_type_id__volatile;
}


static void
_vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_generic_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_generic_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
		synapse_desktop_file_plugin_desktop_file_match_set_exec (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
synapse_desktop_file_plugin_open_with_action_get_instance_private (SynapseDesktopFilePluginOpenWithAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenWithAction_private_offset);
}


static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                        SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginOpenWithAction * self = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	self = (SynapseDesktopFilePluginOpenWithAction*) g_object_new (object_type, NULL);
	synapse_desktop_file_plugin_open_with_action_init_with_info (self, info);
	return self;
}


static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info)
{
	return synapse_desktop_file_plugin_open_with_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, info);
}


static void
synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                             SynapseDesktopFileInfo* info)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = synapse_desktop_file_info_get_name (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Open with %s"), _tmp1_);
	_tmp3_ = _tmp2_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
	_tmp5_ = _tmp4_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
	_tmp6_ = synapse_desktop_file_info_get_name (info);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Opens current selection using %s"), _tmp7_);
	_tmp9_ = _tmp8_;
	synapse_match_set_description ((SynapseMatch*) self, _tmp9_);
	_g_free0 (_tmp9_);
	synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, info);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void
synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base,
                                                           SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
	uri_match = _tmp0_;
	g_return_if_fail (uri_match != NULL);
	_tmp1_ = synapse_uri_match_get_uri (uri_match);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	f = _tmp3_;
	{
		GDesktopAppInfo* app_info = NULL;
		SynapseDesktopFileInfo* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GDesktopAppInfo* _tmp7_;
		GList* files = NULL;
		GFile* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
		GdkAppLaunchContext* _tmp11_;
		_tmp4_ = self->priv->_desktop_info;
		_tmp5_ = synapse_desktop_file_info_get_filename (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_desktop_app_info_new_from_filename (_tmp6_);
		app_info = _tmp7_;
		files = NULL;
		_tmp8_ = _g_object_ref0 (f);
		files = g_list_prepend (files, _tmp8_);
		_tmp9_ = gdk_display_get_default ();
		_tmp10_ = gdk_display_get_app_launch_context (_tmp9_);
		_tmp11_ = _tmp10_;
		g_app_info_launch ((GAppInfo*) app_info, files, (GAppLaunchContext*) _tmp11_, &_inner_error_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app_info);
			goto __catch56_g_error;
		}
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app_info);
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		g_warning ("desktop-file-plugin.vala:364: %s", _tmp13_);
		_g_error_free0 (err);
	}
	__finally56:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}


static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_real_set_title (SynapseMatch* base,
                                                             const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_open_with_action_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_real_set_description (SynapseMatch* base,
                                                                   const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_open_with_action_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_real_set_icon_name (SynapseMatch* base,
                                                                 const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_open_with_action_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginOpenWithAction* self;
	gboolean _tmp0_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_real_set_has_thumbnail (SynapseMatch* base,
                                                                     gboolean value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	if (synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_real_set_thumbnail_path (SynapseMatch* base,
                                                                      const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	if (g_strcmp0 (value, synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_desktop_file_plugin_open_with_action_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDesktopFilePluginOpenWithAction* self;
	SynapseMatchType _tmp0_;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_real_set_match_type (SynapseMatch* base,
                                                                  SynapseMatchType value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
	if (synapse_desktop_file_plugin_open_with_action_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY]);
	}
}


static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_info;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                               SynapseDesktopFileInfo* value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_plugin_open_with_action_get_desktop_info (self) != value) {
		SynapseDesktopFileInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_desktop_info);
		self->priv->_desktop_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY]);
	}
}


static void
synapse_desktop_file_plugin_open_with_action_class_init (SynapseDesktopFilePluginOpenWithActionClass * klass)
{
	synapse_desktop_file_plugin_open_with_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenWithAction_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_with_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_with_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_with_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
synapse_desktop_file_plugin_open_with_action_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_desktop_file_plugin_open_with_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_execute;
	iface->get_title = synapse_desktop_file_plugin_open_with_action_real_get_title;
	iface->set_title = synapse_desktop_file_plugin_open_with_action_real_set_title;
	iface->get_description = synapse_desktop_file_plugin_open_with_action_real_get_description;
	iface->set_description = synapse_desktop_file_plugin_open_with_action_real_set_description;
	iface->get_icon_name = synapse_desktop_file_plugin_open_with_action_real_get_icon_name;
	iface->set_icon_name = synapse_desktop_file_plugin_open_with_action_real_set_icon_name;
	iface->get_has_thumbnail = synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_desktop_file_plugin_open_with_action_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_desktop_file_plugin_open_with_action_real_set_thumbnail_path;
	iface->get_match_type = synapse_desktop_file_plugin_open_with_action_real_get_match_type;
	iface->set_match_type = synapse_desktop_file_plugin_open_with_action_real_set_match_type;
}


static void
synapse_desktop_file_plugin_open_with_action_instance_init (SynapseDesktopFilePluginOpenWithAction * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = synapse_desktop_file_plugin_open_with_action_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_has_thumbnail = FALSE;
}


static void
synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_object_unref0 (self->priv->_desktop_info);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class)->finalize (obj);
}


static GType
synapse_desktop_file_plugin_open_with_action_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_open_with_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_with_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenWithActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_with_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenWithAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_with_action_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_open_with_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_open_with_action_type_id;
		synapse_desktop_file_plugin_open_with_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginOpenWithAction", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_open_with_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		SynapseDesktopFilePluginOpenWithAction_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_open_with_action_type_id, sizeof (SynapseDesktopFilePluginOpenWithActionPrivate));
		g_once_init_leave (&synapse_desktop_file_plugin_open_with_action_type_id__volatile, synapse_desktop_file_plugin_open_with_action_type_id);
	}
	return synapse_desktop_file_plugin_open_with_action_type_id__volatile;
}


static void
_vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
		g_value_set_object (value, synapse_desktop_file_plugin_open_with_action_get_desktop_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
		synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
synapse_desktop_file_plugin_class_init (SynapseDesktopFilePluginClass * klass)
{
	synapse_desktop_file_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL] = g_signal_new ("load-complete", SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	synapse_desktop_file_plugin_register_plugin ();
}


static void
synapse_desktop_file_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface)
{
	synapse_desktop_file_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_deactivate;
	iface->get_enabled = synapse_desktop_file_plugin_real_get_enabled;
	iface->set_enabled = synapse_desktop_file_plugin_real_set_enabled;
}


static void
synapse_desktop_file_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface)
{
	synapse_desktop_file_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_desktop_file_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_desktop_file_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_desktop_file_plugin_real_search_finish;
}


static void
synapse_desktop_file_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface)
{
	synapse_desktop_file_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_desktop_file_plugin_real_find_for_match;
}


static void
synapse_desktop_file_plugin_instance_init (SynapseDesktopFilePlugin * self)
{
	self->priv = synapse_desktop_file_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
	self->priv->loading_in_progress = FALSE;
}


static void
synapse_desktop_file_plugin_finalize (GObject * obj)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	_g_object_unref0 (self->priv->desktop_files);
	_g_object_unref0 (self->priv->mimetype_map);
	G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class)->finalize (obj);
}


GType
synapse_desktop_file_plugin_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePlugin), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_desktop_file_plugin_type_id;
		synapse_desktop_file_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePlugin", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
		g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		SynapseDesktopFilePlugin_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_type_id, sizeof (SynapseDesktopFilePluginPrivate));
		g_once_init_leave (&synapse_desktop_file_plugin_type_id__volatile, synapse_desktop_file_plugin_type_id);
	}
	return synapse_desktop_file_plugin_type_id__volatile;
}


static void
_vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



