/* volume-service.c generated by valac 0.42.5, the Vala compiler
 * generated from volume-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define SYNAPSE_TYPE_VOLUME_SERVICE (synapse_volume_service_get_type ())
#define SYNAPSE_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService))
#define SYNAPSE_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))
#define SYNAPSE_IS_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_IS_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_VOLUME_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))

typedef struct _SynapseVolumeService SynapseVolumeService;
typedef struct _SynapseVolumeServiceClass SynapseVolumeServiceClass;
typedef struct _SynapseVolumeServicePrivate SynapseVolumeServicePrivate;

#define SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT (synapse_volume_service_volume_object_get_type ())
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))

typedef struct _SynapseVolumeServiceVolumeObject SynapseVolumeServiceVolumeObject;
typedef struct _SynapseVolumeServiceVolumeObjectClass SynapseVolumeServiceVolumeObjectClass;
enum  {
	SYNAPSE_VOLUME_SERVICE_0_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_volume_service_properties[SYNAPSE_VOLUME_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
typedef struct _SynapseVolumeServiceVolumeObjectPrivate SynapseVolumeServiceVolumeObjectPrivate;
enum  {
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_0_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_NUM_PROPERTIES];

struct _SynapseVolumeService {
	GObject parent_instance;
	SynapseVolumeServicePrivate * priv;
};

struct _SynapseVolumeServiceClass {
	GObjectClass parent_class;
};

struct _SynapseVolumeServicePrivate {
	GVolumeMonitor* vm;
	GeeMap* volumes;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseVolumeServiceVolumeObject {
	GObject parent_instance;
	SynapseVolumeServiceVolumeObjectPrivate * priv;
};

struct _SynapseVolumeServiceVolumeObjectClass {
	GObjectClass parent_class;
};

struct _SynapseVolumeServiceVolumeObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
	gulong changed_signal_id;
	GVolume* _volume;
};


static gint SynapseVolumeService_private_offset;
static gpointer synapse_volume_service_parent_class = NULL;
static SynapseVolumeService* synapse_volume_service_instance;
static SynapseVolumeService* synapse_volume_service_instance = NULL;
static gint SynapseVolumeServiceVolumeObject_private_offset;
static gpointer synapse_volume_service_volume_object_parent_class = NULL;
static SynapseMatchIface * synapse_volume_service_volume_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface * synapse_volume_service_volume_object_synapse_uri_match_parent_iface = NULL;

GType synapse_volume_service_get_type (void) G_GNUC_CONST;
GType synapse_volume_service_volume_object_get_type (void) G_GNUC_CONST;
SynapseVolumeService* synapse_volume_service_get_default (void);
static SynapseVolumeService* synapse_volume_service_new (void);
static SynapseVolumeService* synapse_volume_service_construct (GType object_type);
void synapse_volume_service_initialize (SynapseVolumeService* self);
static void __lambda11_ (SynapseVolumeService* self,
                  GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_new (GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_construct (GType object_type,
                                                                                  GVolume* volume);
static void ___lambda11__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                 GVolume* volume,
                                                 gpointer self);
static void __lambda12_ (SynapseVolumeService* self,
                  GVolume* volume);
static void ___lambda12__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                   GVolume* volume,
                                                   gpointer self);
static void __lambda13_ (SynapseVolumeService* self,
                  GMount* mount);
void synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self);
static void ___lambda13__g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                GMount* mount,
                                                gpointer self);
static void synapse_volume_service_process_volume_list (SynapseVolumeService* self,
                                                 GList* volume_list);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GeeCollection* synapse_volume_service_get_volumes (SynapseVolumeService* self);
gchar* synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                                  const gchar* uri,
                                                  gchar* * volume_path);
static GObject * synapse_volume_service_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
void synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                      GVolume* value);
gboolean synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self);
GVolume* synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static void _synapse_volume_service_volume_object_update_state_g_volume_changed (GVolume* _sender,
                                                                          gpointer self);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static void synapse_volume_service_volume_object_finalize (GObject * obj);
const gchar* synapse_match_get_description (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
static void _vala_synapse_volume_service_volume_object_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
static void _vala_synapse_volume_service_volume_object_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static void synapse_volume_service_finalize (GObject * obj);


static inline gpointer
synapse_volume_service_get_instance_private (SynapseVolumeService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseVolumeService_private_offset);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


SynapseVolumeService*
synapse_volume_service_get_default (void)
{
	SynapseVolumeService* result = NULL;
	SynapseVolumeService* _tmp0_ = NULL;
	SynapseVolumeService* _tmp1_;
	SynapseVolumeService* _tmp2_;
	SynapseVolumeService* _tmp4_;
	_tmp1_ = synapse_volume_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseVolumeService* _tmp3_;
		_tmp3_ = synapse_volume_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static SynapseVolumeService*
synapse_volume_service_construct (GType object_type)
{
	SynapseVolumeService * self = NULL;
	self = (SynapseVolumeService*) g_object_new (object_type, NULL);
	return self;
}


static SynapseVolumeService*
synapse_volume_service_new (void)
{
	return synapse_volume_service_construct (SYNAPSE_TYPE_VOLUME_SERVICE);
}


static void
__lambda11_ (SynapseVolumeService* self,
             GVolume* volume)
{
	GeeMap* _tmp0_;
	SynapseVolumeServiceVolumeObject* _tmp1_;
	SynapseVolumeServiceVolumeObject* _tmp2_;
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->volumes;
	_tmp1_ = synapse_volume_service_volume_object_new (volume);
	_tmp2_ = _tmp1_;
	gee_map_set (_tmp0_, volume, _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda11__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                            GVolume* volume,
                                            gpointer self)
{
	__lambda11_ ((SynapseVolumeService*) self, volume);
}


static void
__lambda12_ (SynapseVolumeService* self,
             GVolume* volume)
{
	GeeMap* _tmp0_;
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->volumes;
	gee_map_unset (_tmp0_, volume, NULL);
}


static void
___lambda12__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                              GVolume* volume,
                                              gpointer self)
{
	__lambda12_ ((SynapseVolumeService*) self, volume);
}


static void
__lambda13_ (SynapseVolumeService* self,
             GMount* mount)
{
	GVolume* volume = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	GeeMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GVolume* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (mount != NULL);
	_tmp0_ = g_mount_get_volume (mount);
	volume = _tmp0_;
	_tmp1_ = volume;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (volume);
		return;
	}
	_tmp2_ = self->priv->volumes;
	_tmp3_ = gee_map_get_keys (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = volume;
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp5_, _tmp6_);
	_g_object_unref0 (_tmp5_);
	if (_tmp7_) {
		GeeMap* _tmp8_;
		GVolume* _tmp9_;
		gpointer _tmp10_;
		SynapseVolumeServiceVolumeObject* _tmp11_;
		_tmp8_ = self->priv->volumes;
		_tmp9_ = volume;
		_tmp10_ = gee_map_get (_tmp8_, _tmp9_);
		_tmp11_ = (SynapseVolumeServiceVolumeObject*) _tmp10_;
		synapse_volume_service_volume_object_update_state (_tmp11_);
		_g_object_unref0 (_tmp11_);
	}
	_g_object_unref0 (volume);
}


static void
___lambda13__g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                           GMount* mount,
                                           gpointer self)
{
	__lambda13_ ((SynapseVolumeService*) self, mount);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


void
synapse_volume_service_initialize (SynapseVolumeService* self)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GList* volume_list = NULL;
	GVolumeMonitor* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->vm);
	self->priv->vm = _tmp0_;
	_tmp1_ = self->priv->vm;
	g_signal_connect_object (_tmp1_, "volume-added", (GCallback) ___lambda11__g_volume_monitor_volume_added, self, 0);
	_tmp2_ = self->priv->vm;
	g_signal_connect_object (_tmp2_, "volume-removed", (GCallback) ___lambda12__g_volume_monitor_volume_removed, self, 0);
	_tmp3_ = self->priv->vm;
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) ___lambda13__g_volume_monitor_mount_added, self, 0);
	_tmp4_ = self->priv->vm;
	_tmp5_ = g_volume_monitor_get_volumes (_tmp4_);
	volume_list = _tmp5_;
	synapse_volume_service_process_volume_list (self, volume_list);
	(volume_list == NULL) ? NULL : (volume_list = (_g_list_free__g_object_unref0_ (volume_list), NULL));
}


static void
synapse_volume_service_process_volume_list (SynapseVolumeService* self,
                                            GList* volume_list)
{
	g_return_if_fail (self != NULL);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = volume_list;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* volume = NULL;
			volume = (GVolume*) volume_it->data;
			{
				GeeMap* _tmp0_;
				GVolume* _tmp1_;
				GVolume* _tmp2_;
				SynapseVolumeServiceVolumeObject* _tmp3_;
				SynapseVolumeServiceVolumeObject* _tmp4_;
				_tmp0_ = self->priv->volumes;
				_tmp1_ = volume;
				_tmp2_ = volume;
				_tmp3_ = synapse_volume_service_volume_object_new (_tmp2_);
				_tmp4_ = _tmp3_;
				gee_map_set (_tmp0_, _tmp1_, _tmp4_);
				_g_object_unref0 (_tmp4_);
			}
		}
	}
}


GeeCollection*
synapse_volume_service_get_volumes (SynapseVolumeService* self)
{
	GeeCollection* result = NULL;
	GeeMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->volumes;
	_tmp1_ = gee_map_get_values (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gchar*
synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                           const gchar* uri,
                                           gchar* * volume_path)
{
	gchar* _vala_volume_path = NULL;
	gchar* result = NULL;
	GeeSet* g_volumes = NULL;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GFile* f = NULL;
	GFile* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_g_free0 (_vala_volume_path);
	_vala_volume_path = NULL;
	_tmp0_ = self->priv->volumes;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	g_volumes = _tmp2_;
	_tmp3_ = g_file_new_for_uri (uri);
	f = _tmp3_;
	{
		GeeIterator* _volume_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp4_ = g_volumes;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_volume_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GVolume* volume = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFile* root = NULL;
			GVolume* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			_tmp6_ = _volume_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _volume_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			volume = (GVolume*) _tmp8_;
			_tmp9_ = volume;
			_tmp10_ = g_volume_get_activation_root (_tmp9_);
			root = _tmp10_;
			_tmp11_ = root;
			if (_tmp11_ == NULL) {
				GMount* mount = NULL;
				GVolume* _tmp12_;
				GMount* _tmp13_;
				GMount* _tmp14_;
				GMount* _tmp15_;
				GFile* _tmp16_;
				_tmp12_ = volume;
				_tmp13_ = g_volume_get_mount (_tmp12_);
				mount = _tmp13_;
				_tmp14_ = mount;
				if (_tmp14_ == NULL) {
					_g_object_unref0 (mount);
					_g_object_unref0 (root);
					_g_object_unref0 (volume);
					continue;
				}
				_tmp15_ = mount;
				_tmp16_ = g_mount_get_root (_tmp15_);
				_g_object_unref0 (root);
				root = _tmp16_;
				_g_object_unref0 (mount);
			}
			_tmp17_ = f;
			_tmp18_ = root;
			if (g_file_has_prefix (_tmp17_, _tmp18_)) {
				GFile* _tmp19_;
				gchar* _tmp20_;
				GVolume* _tmp21_;
				gchar* _tmp22_;
				_tmp19_ = root;
				_tmp20_ = g_file_get_path (_tmp19_);
				_g_free0 (_vala_volume_path);
				_vala_volume_path = _tmp20_;
				_tmp21_ = volume;
				_tmp22_ = g_volume_get_name (_tmp21_);
				result = _tmp22_;
				_g_object_unref0 (root);
				_g_object_unref0 (volume);
				_g_object_unref0 (_volume_it);
				_g_object_unref0 (f);
				_g_object_unref0 (g_volumes);
				if (volume_path) {
					*volume_path = _vala_volume_path;
				} else {
					_g_free0 (_vala_volume_path);
				}
				return result;
			}
			_g_object_unref0 (root);
			_g_object_unref0 (volume);
		}
		_g_object_unref0 (_volume_it);
	}
	result = NULL;
	_g_object_unref0 (f);
	_g_object_unref0 (g_volumes);
	if (volume_path) {
		*volume_path = _vala_volume_path;
	} else {
		_g_free0 (_vala_volume_path);
	}
	return result;
}


static GObject *
synapse_volume_service_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseVolumeService * self;
	GeeHashMap* _tmp0_;
	parent_class = G_OBJECT_CLASS (synapse_volume_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService);
	synapse_volume_service_instance = self;
	_tmp0_ = gee_hash_map_new (g_volume_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->volumes);
	self->priv->volumes = (GeeMap*) _tmp0_;
	synapse_volume_service_initialize (self);
	return obj;
}


static inline gpointer
synapse_volume_service_volume_object_get_instance_private (SynapseVolumeServiceVolumeObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseVolumeServiceVolumeObject_private_offset);
}


void
synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_volume;
	synapse_volume_service_volume_object_set_volume (self, _tmp0_);
}


gboolean
synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self)
{
	gboolean result = FALSE;
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


SynapseVolumeServiceVolumeObject*
synapse_volume_service_volume_object_construct (GType object_type,
                                                GVolume* volume)
{
	SynapseVolumeServiceVolumeObject * self = NULL;
	g_return_val_if_fail (volume != NULL, NULL);
	self = (SynapseVolumeServiceVolumeObject*) g_object_new (object_type, "volume", volume, NULL);
	return self;
}


SynapseVolumeServiceVolumeObject*
synapse_volume_service_volume_object_new (GVolume* volume)
{
	return synapse_volume_service_volume_object_construct (SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, volume);
}


static const gchar*
synapse_volume_service_volume_object_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_title (SynapseMatch* base,
                                                     const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (g_strcmp0 (value, synapse_volume_service_volume_object_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_volume_service_volume_object_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_description (SynapseMatch* base,
                                                           const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (g_strcmp0 (value, synapse_volume_service_volume_object_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_volume_service_volume_object_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_icon_name (SynapseMatch* base,
                                                         const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (g_strcmp0 (value, synapse_volume_service_volume_object_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_volume_service_volume_object_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseVolumeServiceVolumeObject* self;
	gboolean _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_has_thumbnail (SynapseMatch* base,
                                                             gboolean value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (synapse_volume_service_volume_object_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_volume_service_volume_object_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_thumbnail_path (SynapseMatch* base,
                                                              const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (g_strcmp0 (value, synapse_volume_service_volume_object_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_volume_service_volume_object_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseVolumeServiceVolumeObject* self;
	SynapseMatchType _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_match_type (SynapseMatch* base,
                                                          SynapseMatchType value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (synapse_volume_service_volume_object_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY]);
	}
}


static const gchar*
synapse_volume_service_volume_object_real_get_uri (SynapseUriMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_uri (SynapseUriMatch* base,
                                                   const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (g_strcmp0 (value, synapse_volume_service_volume_object_real_get_uri (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY]);
	}
}


static SynapseQueryFlags
synapse_volume_service_volume_object_real_get_file_type (SynapseUriMatch* base)
{
	SynapseQueryFlags result;
	SynapseVolumeServiceVolumeObject* self;
	SynapseQueryFlags _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_file_type;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_file_type (SynapseUriMatch* base,
                                                         SynapseQueryFlags value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (synapse_volume_service_volume_object_real_get_file_type (base) != value) {
		self->priv->_file_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY]);
	}
}


static const gchar*
synapse_volume_service_volume_object_real_get_mime_type (SynapseUriMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
	self = (SynapseVolumeServiceVolumeObject*) base;
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}


static void
synapse_volume_service_volume_object_real_set_mime_type (SynapseUriMatch* base,
                                                         const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	self = (SynapseVolumeServiceVolumeObject*) base;
	if (g_strcmp0 (value, synapse_volume_service_volume_object_real_get_mime_type (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY]);
	}
}


GVolume*
synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* result;
	GVolume* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}


static void
_synapse_volume_service_volume_object_update_state_g_volume_changed (GVolume* _sender,
                                                                     gpointer self)
{
	synapse_volume_service_volume_object_update_state ((SynapseVolumeServiceVolumeObject*) self);
}


void
synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                 GVolume* value)
{
	GVolume* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SynapseMatchType _tmp7_ = 0;
	GMount* _tmp8_;
	GMount* _tmp9_;
	gboolean _tmp10_;
	SynapseMatchType _tmp11_;
	SynapseMatchType _tmp12_;
	gulong _tmp19_;
	gint _tmp22_ = 0;
	GMount* _tmp23_;
	GMount* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_volume);
	self->priv->_volume = _tmp0_;
	_tmp1_ = g_volume_get_name (value);
	_tmp2_ = _tmp1_;
	synapse_match_set_title ((SynapseMatch*) self, _tmp2_);
	_g_free0 (_tmp2_);
	synapse_match_set_description ((SynapseMatch*) self, "");
	_tmp3_ = g_volume_get_icon (value);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_icon_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
	_tmp8_ = g_volume_get_mount (value);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_ != NULL;
	_g_object_unref0 (_tmp9_);
	if (_tmp10_) {
		_tmp7_ = SYNAPSE_MATCH_TYPE_GENERIC_URI;
	} else {
		_tmp7_ = SYNAPSE_MATCH_TYPE_ACTION;
	}
	synapse_match_set_match_type ((SynapseMatch*) self, _tmp7_);
	_tmp11_ = synapse_match_get_match_type ((SynapseMatch*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		GMount* _tmp13_;
		GMount* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp13_ = g_volume_get_mount (value);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_mount_get_root (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_file_get_uri (_tmp16_);
		_tmp18_ = _tmp17_;
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp18_);
		_g_free0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp14_);
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_PLACES);
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, "");
	} else {
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, NULL);
	}
	_tmp19_ = self->priv->changed_signal_id;
	if (_tmp19_ == ((gulong) 0)) {
		GVolume* _tmp20_;
		gulong _tmp21_;
		_tmp20_ = self->priv->_volume;
		_tmp21_ = g_signal_connect_object (_tmp20_, "changed", (GCallback) _synapse_volume_service_volume_object_update_state_g_volume_changed, self, 0);
		self->priv->changed_signal_id = _tmp21_;
	}
	_tmp23_ = g_volume_get_mount (value);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_ != NULL;
	_g_object_unref0 (_tmp24_);
	if (_tmp25_) {
		_tmp22_ = 1;
	} else {
		_tmp22_ = 0;
	}
	_tmp26_ = synapse_match_get_title ((SynapseMatch*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = synapse_match_get_icon_name ((SynapseMatch*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
	_tmp31_ = _tmp30_;
	synapse_utils_logger_debug ((GObject*) self, "volume-service.vala:163: vo[%p]: %s [%s], has_mount: %d, uri: %s", self, _tmp27_, _tmp29_, _tmp22_, _tmp31_, NULL);
	g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY]);
}


static void
synapse_volume_service_volume_object_class_init (SynapseVolumeServiceVolumeObjectClass * klass)
{
	synapse_volume_service_volume_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseVolumeServiceVolumeObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_volume_service_volume_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_volume_service_volume_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_volume_service_volume_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY] = g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY] = g_param_spec_object ("volume", "volume", "volume", g_volume_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_volume_service_volume_object_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_volume_service_volume_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_volume_service_volume_object_real_get_title;
	iface->set_title = synapse_volume_service_volume_object_real_set_title;
	iface->get_description = synapse_volume_service_volume_object_real_get_description;
	iface->set_description = synapse_volume_service_volume_object_real_set_description;
	iface->get_icon_name = synapse_volume_service_volume_object_real_get_icon_name;
	iface->set_icon_name = synapse_volume_service_volume_object_real_set_icon_name;
	iface->get_has_thumbnail = synapse_volume_service_volume_object_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_volume_service_volume_object_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_volume_service_volume_object_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_volume_service_volume_object_real_set_thumbnail_path;
	iface->get_match_type = synapse_volume_service_volume_object_real_get_match_type;
	iface->set_match_type = synapse_volume_service_volume_object_real_set_match_type;
}


static void
synapse_volume_service_volume_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface)
{
	synapse_volume_service_volume_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_uri = synapse_volume_service_volume_object_real_get_uri;
	iface->set_uri = synapse_volume_service_volume_object_real_set_uri;
	iface->get_file_type = synapse_volume_service_volume_object_real_get_file_type;
	iface->set_file_type = synapse_volume_service_volume_object_real_set_file_type;
	iface->get_mime_type = synapse_volume_service_volume_object_real_get_mime_type;
	iface->set_mime_type = synapse_volume_service_volume_object_real_set_mime_type;
}


static void
synapse_volume_service_volume_object_instance_init (SynapseVolumeServiceVolumeObject * self)
{
	self->priv = synapse_volume_service_volume_object_get_instance_private (self);
}


static void
synapse_volume_service_volume_object_finalize (GObject * obj)
{
	SynapseVolumeServiceVolumeObject * self;
	gulong _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
	_tmp0_ = self->priv->changed_signal_id;
	if (_tmp0_ != ((gulong) 0)) {
		GVolume* _tmp1_;
		gulong _tmp2_;
		_tmp1_ = self->priv->_volume;
		_tmp2_ = self->priv->changed_signal_id;
		g_signal_handler_disconnect (_tmp1_, _tmp2_);
		self->priv->changed_signal_id = (gulong) 0;
	}
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_object_unref0 (self->priv->_volume);
	G_OBJECT_CLASS (synapse_volume_service_volume_object_parent_class)->finalize (obj);
}


GType
synapse_volume_service_volume_object_get_type (void)
{
	static volatile gsize synapse_volume_service_volume_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_volume_service_volume_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseVolumeServiceVolumeObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_volume_service_volume_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseVolumeServiceVolumeObject), 0, (GInstanceInitFunc) synapse_volume_service_volume_object_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_volume_service_volume_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_volume_service_volume_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_volume_service_volume_object_type_id;
		synapse_volume_service_volume_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseVolumeServiceVolumeObject", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_volume_service_volume_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		g_type_add_interface_static (synapse_volume_service_volume_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
		SynapseVolumeServiceVolumeObject_private_offset = g_type_add_instance_private (synapse_volume_service_volume_object_type_id, sizeof (SynapseVolumeServiceVolumeObjectPrivate));
		g_once_init_leave (&synapse_volume_service_volume_object_type_id__volatile, synapse_volume_service_volume_object_type_id);
	}
	return synapse_volume_service_volume_object_type_id__volatile;
}


static void
_vala_synapse_volume_service_volume_object_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	SynapseVolumeServiceVolumeObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
	switch (property_id) {
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY:
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY:
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY:
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY:
		g_value_set_object (value, synapse_volume_service_volume_object_get_volume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_volume_service_volume_object_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	SynapseVolumeServiceVolumeObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
	switch (property_id) {
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY:
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY:
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY:
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY:
		synapse_volume_service_volume_object_set_volume (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
synapse_volume_service_class_init (SynapseVolumeServiceClass * klass)
{
	synapse_volume_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseVolumeService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_volume_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_volume_service_finalize;
}


static void
synapse_volume_service_instance_init (SynapseVolumeService * self)
{
	self->priv = synapse_volume_service_get_instance_private (self);
}


static void
synapse_volume_service_finalize (GObject * obj)
{
	SynapseVolumeService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService);
	synapse_volume_service_instance = NULL;
	_g_object_unref0 (self->priv->vm);
	_g_object_unref0 (self->priv->volumes);
	G_OBJECT_CLASS (synapse_volume_service_parent_class)->finalize (obj);
}


GType
synapse_volume_service_get_type (void)
{
	static volatile gsize synapse_volume_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_volume_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseVolumeServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_volume_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseVolumeService), 0, (GInstanceInitFunc) synapse_volume_service_instance_init, NULL };
		GType synapse_volume_service_type_id;
		synapse_volume_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseVolumeService", &g_define_type_info, 0);
		SynapseVolumeService_private_offset = g_type_add_instance_private (synapse_volume_service_type_id, sizeof (SynapseVolumeServicePrivate));
		g_once_init_leave (&synapse_volume_service_type_id__volatile, synapse_volume_service_type_id);
	}
	return synapse_volume_service_type_id__volatile;
}



