/* match.c generated by valac 0.42.5, the Vala compiler
 * generated from match.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;


#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
enum  {
	SYNAPSE_MATCH_EXECUTED_SIGNAL,
	SYNAPSE_MATCH_NUM_SIGNALS
};
static guint synapse_match_signals[SYNAPSE_MATCH_NUM_SIGNALS] = {0};

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_TYPE_CONTACT_MATCH (synapse_contact_match_get_type ())
#define SYNAPSE_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatch))
#define SYNAPSE_IS_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONTACT_MATCH))
#define SYNAPSE_CONTACT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatchIface))

typedef struct _SynapseContactMatch SynapseContactMatch;
typedef struct _SynapseContactMatchIface SynapseContactMatchIface;

#define SYNAPSE_TYPE_EXTENDED_INFO (synapse_extended_info_get_type ())
#define SYNAPSE_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo))
#define SYNAPSE_IS_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_EXTENDED_INFO))
#define SYNAPSE_EXTENDED_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfoIface))

typedef struct _SynapseExtendedInfo SynapseExtendedInfo;
typedef struct _SynapseExtendedInfoIface SynapseExtendedInfoIface;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;


#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchIface))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchIface SynapseTextMatchIface;

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchIface))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchIface SynapseSearchMatchIface;

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_DEFAULT_MATCH (synapse_default_match_get_type ())
#define SYNAPSE_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch))
#define SYNAPSE_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))
#define SYNAPSE_IS_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_IS_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_DEFAULT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))

typedef struct _SynapseDefaultMatch SynapseDefaultMatch;
typedef struct _SynapseDefaultMatchClass SynapseDefaultMatchClass;
typedef struct _SynapseDefaultMatchPrivate SynapseDefaultMatchPrivate;
enum  {
	SYNAPSE_DEFAULT_MATCH_0_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseContactMatchIface {
	GTypeInterface parent_iface;
	void (*send_message) (SynapseContactMatch* self, const gchar* message, gboolean present);
	void (*open_chat) (SynapseContactMatch* self);
};

struct _SynapseExtendedInfoIface {
	GTypeInterface parent_iface;
	const gchar* (*get_extended_info) (SynapseExtendedInfo* self);
	void (*set_extended_info) (SynapseExtendedInfo* self, const gchar* value);
};

struct _SynapseTextMatchIface {
	GTypeInterface parent_iface;
	gchar* (*get_text) (SynapseTextMatch* self);
	SynapseTextOrigin (*get_text_origin) (SynapseTextMatch* self);
	void (*set_text_origin) (SynapseTextMatch* self, SynapseTextOrigin value);
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatchIface {
	GTypeInterface parent_iface;
	SynapseMatch* (*get_search_source) (SynapseSearchMatch* self);
	void (*set_search_source) (SynapseSearchMatch* self, SynapseMatch* value);
};

struct _SynapseDefaultMatch {
	GObject parent_instance;
	SynapseDefaultMatchPrivate * priv;
};

struct _SynapseDefaultMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDefaultMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
};


static gint SynapseDefaultMatch_private_offset;
static gpointer synapse_default_match_parent_class = NULL;
static SynapseMatchIface * synapse_default_match_synapse_match_parent_iface = NULL;

GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_match_score_get_type (void) G_GNUC_CONST;
void synapse_match_execute (SynapseMatch* self,
                            SynapseMatch* match);
static void synapse_match_real_execute (SynapseMatch* self,
                                 SynapseMatch* match);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
static void synapse_match_real_execute_with_target (SynapseMatch* self,
                                             SynapseMatch* source,
                                             SynapseMatch* target);
gboolean synapse_match_needs_target (SynapseMatch* self);
static gboolean synapse_match_real_needs_target (SynapseMatch* self);
SynapseQueryFlags synapse_match_target_flags (SynapseMatch* self);
static SynapseQueryFlags synapse_match_real_target_flags (SynapseMatch* self);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                             GAppInfo* value);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                                   gboolean value);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
void synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                             const gchar* value);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
GType synapse_contact_match_get_type (void) G_GNUC_CONST;
void synapse_contact_match_send_message (SynapseContactMatch* self,
                                         const gchar* message,
                                         gboolean present);
void synapse_contact_match_open_chat (SynapseContactMatch* self);
GType synapse_extended_info_get_type (void) G_GNUC_CONST;
const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self);
void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                              const gchar* value);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
void synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                         SynapseTextOrigin value);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
GType synapse_search_match_get_type (void) G_GNUC_CONST;
SynapseMatch* synapse_search_match_get_search_source (SynapseSearchMatch* self);
void synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                             SynapseMatch* value);
GType synapse_default_match_get_type (void) G_GNUC_CONST;
SynapseDefaultMatch* synapse_default_match_new (const gchar* query_string);
SynapseDefaultMatch* synapse_default_match_construct (GType object_type,
                                                      const gchar* query_string);
static void synapse_default_match_finalize (GObject * obj);
static void _vala_synapse_default_match_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_synapse_default_match_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);


GType
synapse_match_type_get_type (void)
{
	static volatile gsize synapse_match_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_MATCH_TYPE_UNKNOWN, "SYNAPSE_MATCH_TYPE_UNKNOWN", "unknown"}, {SYNAPSE_MATCH_TYPE_TEXT, "SYNAPSE_MATCH_TYPE_TEXT", "text"}, {SYNAPSE_MATCH_TYPE_APPLICATION, "SYNAPSE_MATCH_TYPE_APPLICATION", "application"}, {SYNAPSE_MATCH_TYPE_GENERIC_URI, "SYNAPSE_MATCH_TYPE_GENERIC_URI", "generic-uri"}, {SYNAPSE_MATCH_TYPE_ACTION, "SYNAPSE_MATCH_TYPE_ACTION", "action"}, {SYNAPSE_MATCH_TYPE_SEARCH, "SYNAPSE_MATCH_TYPE_SEARCH", "search"}, {SYNAPSE_MATCH_TYPE_CONTACT, "SYNAPSE_MATCH_TYPE_CONTACT", "contact"}, {0, NULL, NULL}};
		GType synapse_match_type_type_id;
		synapse_match_type_type_id = g_enum_register_static ("SynapseMatchType", values);
		g_once_init_leave (&synapse_match_type_type_id__volatile, synapse_match_type_type_id);
	}
	return synapse_match_type_type_id__volatile;
}


GType
synapse_match_score_get_type (void)
{
	static volatile gsize synapse_match_score_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_score_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, "SYNAPSE_MATCH_SCORE_INCREMENT_MINOR", "increment-minor"}, {SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, "SYNAPSE_MATCH_SCORE_INCREMENT_SMALL", "increment-small"}, {SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM, "SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM", "increment-medium"}, {SYNAPSE_MATCH_SCORE_INCREMENT_LARGE, "SYNAPSE_MATCH_SCORE_INCREMENT_LARGE", "increment-large"}, {SYNAPSE_MATCH_SCORE_URI_PENALTY, "SYNAPSE_MATCH_SCORE_URI_PENALTY", "uri-penalty"}, {SYNAPSE_MATCH_SCORE_POOR, "SYNAPSE_MATCH_SCORE_POOR", "poor"}, {SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, "SYNAPSE_MATCH_SCORE_BELOW_AVERAGE", "below-average"}, {SYNAPSE_MATCH_SCORE_AVERAGE, "SYNAPSE_MATCH_SCORE_AVERAGE", "average"}, {SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE, "SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE", "above-average"}, {SYNAPSE_MATCH_SCORE_GOOD, "SYNAPSE_MATCH_SCORE_GOOD", "good"}, {SYNAPSE_MATCH_SCORE_VERY_GOOD, "SYNAPSE_MATCH_SCORE_VERY_GOOD", "very-good"}, {SYNAPSE_MATCH_SCORE_EXCELLENT, "SYNAPSE_MATCH_SCORE_EXCELLENT", "excellent"}, {SYNAPSE_MATCH_SCORE_HIGHEST, "SYNAPSE_MATCH_SCORE_HIGHEST", "highest"}, {0, NULL, NULL}};
		GType synapse_match_score_type_id;
		synapse_match_score_type_id = g_enum_register_static ("SynapseMatchScore", values);
		g_once_init_leave (&synapse_match_score_type_id__volatile, synapse_match_score_type_id);
	}
	return synapse_match_score_type_id__volatile;
}


static void
synapse_match_real_execute (SynapseMatch* self,
                            SynapseMatch* match)
{
	synapse_utils_logger_error ((GObject*) self, "execute () is not implemented", NULL);
}


void
synapse_match_execute (SynapseMatch* self,
                       SynapseMatch* match)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->execute (self, match);
}


static void
synapse_match_real_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target)
{
	if (target == NULL) {
		synapse_match_execute (self, source);
	} else {
		synapse_utils_logger_error ((GObject*) self, "execute () is not implemented", NULL);
	}
}


void
synapse_match_execute_with_target (SynapseMatch* self,
                                   SynapseMatch* source,
                                   SynapseMatch* target)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->execute_with_target (self, source, target);
}


static gboolean
synapse_match_real_needs_target (SynapseMatch* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
synapse_match_needs_target (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->needs_target (self);
}


static SynapseQueryFlags
synapse_match_real_target_flags (SynapseMatch* self)
{
	SynapseQueryFlags result = 0;
	result = SYNAPSE_QUERY_FLAGS_ALL;
	return result;
}


SynapseQueryFlags
synapse_match_target_flags (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->target_flags (self);
}


const gchar*
synapse_match_get_title (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_title (self);
}


void
synapse_match_set_title (SynapseMatch* self,
                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_title (self, value);
}


const gchar*
synapse_match_get_description (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_description (self);
}


void
synapse_match_set_description (SynapseMatch* self,
                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_description (self, value);
}


const gchar*
synapse_match_get_icon_name (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_icon_name (self);
}


void
synapse_match_set_icon_name (SynapseMatch* self,
                             const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_icon_name (self, value);
}


gboolean
synapse_match_get_has_thumbnail (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_has_thumbnail (self);
}


void
synapse_match_set_has_thumbnail (SynapseMatch* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_has_thumbnail (self, value);
}


const gchar*
synapse_match_get_thumbnail_path (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_thumbnail_path (self);
}


void
synapse_match_set_thumbnail_path (SynapseMatch* self,
                                  const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_thumbnail_path (self, value);
}


SynapseMatchType
synapse_match_get_match_type (SynapseMatch* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_match_type (self);
}


void
synapse_match_set_match_type (SynapseMatch* self,
                              SynapseMatchType value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_match_type (self, value);
}


static void
synapse_match_default_init (SynapseMatchIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_interface_install_property (iface, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_interface_install_property (iface, g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_interface_install_property (iface, g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_interface_install_property (iface, g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	synapse_match_signals[SYNAPSE_MATCH_EXECUTED_SIGNAL] = g_signal_new ("executed", SYNAPSE_TYPE_MATCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	iface->execute = synapse_match_real_execute;
	iface->execute_with_target = synapse_match_real_execute_with_target;
	iface->needs_target = synapse_match_real_needs_target;
	iface->target_flags = synapse_match_real_target_flags;
}


GType
synapse_match_get_type (void)
{
	static volatile gsize synapse_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_match_type_id;
		synapse_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_match_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&synapse_match_type_id__volatile, synapse_match_type_id);
	}
	return synapse_match_type_id__volatile;
}


GAppInfo*
synapse_application_match_get_app_info (SynapseApplicationMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_app_info (self);
}


void
synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                        GAppInfo* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_app_info (self, value);
}


gboolean
synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_needs_terminal (self);
}


void
synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_needs_terminal (self, value);
}


const gchar*
synapse_application_match_get_filename (SynapseApplicationMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_filename (self);
}


void
synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                        const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_filename (self, value);
}


static void
synapse_application_match_default_init (SynapseApplicationMatchIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


GType
synapse_application_match_get_type (void)
{
	static volatile gsize synapse_application_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_application_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseApplicationMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_application_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_application_match_type_id;
		synapse_application_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseApplicationMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_application_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_application_match_type_id__volatile, synapse_application_match_type_id);
	}
	return synapse_application_match_type_id__volatile;
}


const gchar*
synapse_uri_match_get_uri (SynapseUriMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_uri (self);
}


void
synapse_uri_match_set_uri (SynapseUriMatch* self,
                           const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_uri (self, value);
}


SynapseQueryFlags
synapse_uri_match_get_file_type (SynapseUriMatch* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_file_type (self);
}


void
synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                 SynapseQueryFlags value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_file_type (self, value);
}


const gchar*
synapse_uri_match_get_mime_type (SynapseUriMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_mime_type (self);
}


void
synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_mime_type (self, value);
}


static void
synapse_uri_match_default_init (SynapseUriMatchIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


GType
synapse_uri_match_get_type (void)
{
	static volatile gsize synapse_uri_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_uri_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseUriMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_uri_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_uri_match_type_id;
		synapse_uri_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseUriMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_uri_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_uri_match_type_id__volatile, synapse_uri_match_type_id);
	}
	return synapse_uri_match_type_id__volatile;
}


void
synapse_contact_match_send_message (SynapseContactMatch* self,
                                    const gchar* message,
                                    gboolean present)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_CONTACT_MATCH_GET_INTERFACE (self)->send_message (self, message, present);
}


void
synapse_contact_match_open_chat (SynapseContactMatch* self)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_CONTACT_MATCH_GET_INTERFACE (self)->open_chat (self);
}


static void
synapse_contact_match_default_init (SynapseContactMatchIface * iface)
{
}


GType
synapse_contact_match_get_type (void)
{
	static volatile gsize synapse_contact_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_contact_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseContactMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_contact_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_contact_match_type_id;
		synapse_contact_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseContactMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_contact_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_contact_match_type_id__volatile, synapse_contact_match_type_id);
	}
	return synapse_contact_match_type_id__volatile;
}


const gchar*
synapse_extended_info_get_extended_info (SynapseExtendedInfo* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->get_extended_info (self);
}


void
synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->set_extended_info (self, value);
}


static void
synapse_extended_info_default_init (SynapseExtendedInfoIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_string ("extended-info", "extended-info", "extended-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


GType
synapse_extended_info_get_type (void)
{
	static volatile gsize synapse_extended_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_extended_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseExtendedInfoIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_extended_info_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_extended_info_type_id;
		synapse_extended_info_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseExtendedInfo", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_extended_info_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_extended_info_type_id__volatile, synapse_extended_info_type_id);
	}
	return synapse_extended_info_type_id__volatile;
}


GType
synapse_text_origin_get_type (void)
{
	static volatile gsize synapse_text_origin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_origin_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNAPSE_TEXT_ORIGIN_UNKNOWN, "SYNAPSE_TEXT_ORIGIN_UNKNOWN", "unknown"}, {SYNAPSE_TEXT_ORIGIN_CLIPBOARD, "SYNAPSE_TEXT_ORIGIN_CLIPBOARD", "clipboard"}, {0, NULL, NULL}};
		GType synapse_text_origin_type_id;
		synapse_text_origin_type_id = g_enum_register_static ("SynapseTextOrigin", values);
		g_once_init_leave (&synapse_text_origin_type_id__volatile, synapse_text_origin_type_id);
	}
	return synapse_text_origin_type_id__volatile;
}


gchar*
synapse_text_match_get_text (SynapseTextMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->get_text (self);
}


SynapseTextOrigin
synapse_text_match_get_text_origin (SynapseTextMatch* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->get_text_origin (self);
}


void
synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                    SynapseTextOrigin value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->set_text_origin (self, value);
}


static void
synapse_text_match_default_init (SynapseTextMatchIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


GType
synapse_text_match_get_type (void)
{
	static volatile gsize synapse_text_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseTextMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_text_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_text_match_type_id;
		synapse_text_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseTextMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_text_match_type_id, SYNAPSE_TYPE_MATCH);
		g_once_init_leave (&synapse_text_match_type_id__volatile, synapse_text_match_type_id);
	}
	return synapse_text_match_type_id__volatile;
}


SynapseMatch*
synapse_search_match_get_search_source (SynapseSearchMatch* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return SYNAPSE_SEARCH_MATCH_GET_INTERFACE (self)->get_search_source (self);
}


void
synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                        SynapseMatch* value)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_SEARCH_MATCH_GET_INTERFACE (self)->set_search_source (self, value);
}


static void
synapse_search_match_default_init (SynapseSearchMatchIface * iface)
{
	g_object_interface_install_property (iface, g_param_spec_object ("search-source", "search-source", "search-source", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


GType
synapse_search_match_get_type (void)
{
	static volatile gsize synapse_search_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_search_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_search_match_type_id;
		synapse_search_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseSearchMatch", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_search_match_type_id, SYNAPSE_TYPE_MATCH);
		g_type_interface_add_prerequisite (synapse_search_match_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER);
		g_once_init_leave (&synapse_search_match_type_id__volatile, synapse_search_match_type_id);
	}
	return synapse_search_match_type_id__volatile;
}


static inline gpointer
synapse_default_match_get_instance_private (SynapseDefaultMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDefaultMatch_private_offset);
}


SynapseDefaultMatch*
synapse_default_match_construct (GType object_type,
                                 const gchar* query_string)
{
	SynapseDefaultMatch * self = NULL;
	g_return_val_if_fail (query_string != NULL, NULL);
	self = (SynapseDefaultMatch*) g_object_new (object_type, "title", query_string, "description", "", "has-thumbnail", FALSE, "icon-name", "unknown", "match-type", SYNAPSE_MATCH_TYPE_UNKNOWN, NULL);
	return self;
}


SynapseDefaultMatch*
synapse_default_match_new (const gchar* query_string)
{
	return synapse_default_match_construct (SYNAPSE_TYPE_DEFAULT_MATCH, query_string);
}


static const gchar*
synapse_default_match_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_default_match_real_set_title (SynapseMatch* base,
                                      const gchar* value)
{
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	if (g_strcmp0 (value, synapse_default_match_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_default_match_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_default_match_real_set_description (SynapseMatch* base,
                                            const gchar* value)
{
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	if (g_strcmp0 (value, synapse_default_match_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_default_match_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_default_match_real_set_icon_name (SynapseMatch* base,
                                          const gchar* value)
{
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	if (g_strcmp0 (value, synapse_default_match_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_default_match_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDefaultMatch* self;
	gboolean _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_default_match_real_set_has_thumbnail (SynapseMatch* base,
                                              gboolean value)
{
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	if (synapse_default_match_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_default_match_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_default_match_real_set_thumbnail_path (SynapseMatch* base,
                                               const gchar* value)
{
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	if (g_strcmp0 (value, synapse_default_match_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_default_match_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDefaultMatch* self;
	SynapseMatchType _tmp0_;
	self = (SynapseDefaultMatch*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_default_match_real_set_match_type (SynapseMatch* base,
                                           SynapseMatchType value)
{
	SynapseDefaultMatch* self;
	self = (SynapseDefaultMatch*) base;
	if (synapse_default_match_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY]);
	}
}


static void
synapse_default_match_class_init (SynapseDefaultMatchClass * klass)
{
	synapse_default_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDefaultMatch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_default_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_default_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_default_match_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void
synapse_default_match_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_default_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = synapse_default_match_real_get_title;
	iface->set_title = synapse_default_match_real_set_title;
	iface->get_description = synapse_default_match_real_get_description;
	iface->set_description = synapse_default_match_real_set_description;
	iface->get_icon_name = synapse_default_match_real_get_icon_name;
	iface->set_icon_name = synapse_default_match_real_set_icon_name;
	iface->get_has_thumbnail = synapse_default_match_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_default_match_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_default_match_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_default_match_real_set_thumbnail_path;
	iface->get_match_type = synapse_default_match_real_get_match_type;
	iface->set_match_type = synapse_default_match_real_set_match_type;
}


static void
synapse_default_match_instance_init (SynapseDefaultMatch * self)
{
	self->priv = synapse_default_match_get_instance_private (self);
}


static void
synapse_default_match_finalize (GObject * obj)
{
	SynapseDefaultMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_default_match_parent_class)->finalize (obj);
}


GType
synapse_default_match_get_type (void)
{
	static volatile gsize synapse_default_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_default_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDefaultMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_default_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDefaultMatch), 0, (GInstanceInitFunc) synapse_default_match_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_default_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_default_match_type_id;
		synapse_default_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDefaultMatch", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_default_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		SynapseDefaultMatch_private_offset = g_type_add_instance_private (synapse_default_match_type_id, sizeof (SynapseDefaultMatchPrivate));
		g_once_init_leave (&synapse_default_match_type_id__volatile, synapse_default_match_type_id);
	}
	return synapse_default_match_type_id__volatile;
}


static void
_vala_synapse_default_match_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SynapseDefaultMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch);
	switch (property_id) {
		case SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_default_match_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SynapseDefaultMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch);
	switch (property_id) {
		case SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



