/* desktop-file-service.c generated by valac 0.42.5, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gee.h>
#include <locale.h>


#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;
typedef enum  {
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE = 1 << 3,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR = 1 << 4,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX = 1 << 5,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE = 1 << 6,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY = 1 << 7,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE = 1 << 8,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON = 1 << 9,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD = 1 << 10,
	SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL = 0x3FF
} SynapseDesktopFileInfoEnvironmentType;


#define SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE (synapse_desktop_file_info_environment_type_get_type ())
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_service_properties[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceProcessDirectoryData SynapseDesktopFileServiceProcessDirectoryData;
typedef struct _SynapseDesktopFileServiceLoadAllDesktopFilesData SynapseDesktopFileServiceLoadAllDesktopFilesData;
typedef struct _SynapseDesktopFileServiceReloadDesktopFilesData SynapseDesktopFileServiceReloadDesktopFilesData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadDesktopFileData SynapseDesktopFileServiceLoadDesktopFileData;
typedef struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData SynapseDesktopFileServiceLoadMimeParentsFromFileData;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS
};
static guint synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS] = {0};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()
struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	gchar** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileInfoPrivate {
	gchar* _desktop_id;
	gchar* _name;
	gchar* _generic_name;
	gchar* _comment;
	gchar* _icon_name;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	gchar* name_folded;
	SynapseDesktopFileInfoEnvironmentType _show_in;
};

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileServicePrivate {
	SynapseUtilsAsyncOnce* init_once;
	GeeList* directory_monitors;
	GeeList* all_desktop_files;
	GeeList* non_hidden_desktop_files;
	GeeMap* mimetype_map;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	GeeMultiMap* mimetype_parent_map;
	SynapseDesktopFileInfoEnvironmentType session_type;
	gchar* session_type_str;
	guint timer_id;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFileService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	SynapseUtilsAsyncOnce* _tmp4_;
};

struct _SynapseDesktopFileServiceProcessDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFileService* self;
	GFile* directory;
	gchar* id_prefix;
	GeeSet* monitored_dirs;
	gchar* path;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean exists;
	gboolean _tmp8_;
	GeeIterator* _scanned_dir_it;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	GFile* scanned_dir;
	GeeIterator* _tmp11_;
	gpointer _tmp12_;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp18_;
	GList* files;
	GFileEnumerator* _tmp19_;
	GList* _tmp20_;
	GList* _tmp21_;
	GList* f_collection;
	GList* f_it;
	GFileInfo* _tmp22_;
	GFileInfo* f;
	const gchar* name;
	GFileInfo* _tmp23_;
	const gchar* _tmp24_;
	GFileInfo* _tmp25_;
	GFile* subdir;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	gchar* new_prefix;
	GFile* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GFile* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GFile* _tmp38_;
	GFile* _tmp39_;
	GError* err;
	GError* _tmp40_;
	const gchar* _tmp41_;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFileService* self;
	gchar** data_dirs;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GeeSet* desktop_file_dirs;
	GeeHashSet* _tmp6_;
	GeeMultiMap* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** data_dir_collection;
	gint data_dir_collection_length1;
	gint _data_dir_collection_size_;
	gint data_dir_it;
	const gchar* data_dir;
	gchar* dir_path;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* directory;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GeeSet* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeIterator* _d_it;
	GeeSet* _tmp19_;
	GeeIterator* _tmp20_;
	GeeIterator* _tmp21_;
	GFile* d;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	GFileMonitor* monitor;
	GFile* _tmp24_;
	GFileMonitor* _tmp25_;
	GFileMonitor* _tmp26_;
	GeeList* _tmp27_;
	GFileMonitor* _tmp28_;
	GError* err;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceReloadDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFileService* self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
};

struct _SynapseDesktopFileServiceLoadDesktopFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFileService* self;
	GFile* file;
	gchar* id_prefix;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	gboolean success;
	guint8* _tmp0_;
	gsize _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GKeyFile* keyfile;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gchar* desktop_id;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	SynapseDesktopFileInfo* dfi;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GKeyFile* _tmp14_;
	const gchar* _tmp15_;
	SynapseDesktopFileInfo* _tmp16_;
	SynapseDesktopFileInfo* _tmp17_;
	SynapseDesktopFileInfo* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GeeList* _tmp21_;
	SynapseDesktopFileInfo* _tmp22_;
	gboolean _tmp23_;
	SynapseDesktopFileInfo* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	SynapseDesktopFileInfoEnvironmentType _tmp27_;
	SynapseDesktopFileInfo* _tmp28_;
	SynapseDesktopFileInfoEnvironmentType _tmp29_;
	SynapseDesktopFileInfoEnvironmentType _tmp30_;
	GeeList* _tmp31_;
	SynapseDesktopFileInfo* _tmp32_;
	GError* err;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError * _inner_error_;
};

struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDesktopFileService* self;
	gchar* fi;
	GFile* file;
	GFile* _tmp0_;
	gboolean exists;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GFileInputStream* fis;
	GFile* _tmp3_;
	GFileInputStream* _tmp4_;
	GDataInputStream* dis;
	GFileInputStream* _tmp5_;
	GDataInputStream* _tmp6_;
	gchar* line;
	gchar** mimes;
	gint mimes_length1;
	gint _mimes_size_;
	gint len;
	gchar* _tmp7_;
	GDataInputStream* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	GeeMultiMap* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp26_;
	GError* err;
	GError * _inner_error_;
};


static gint SynapseDesktopFileInfo_private_offset;
static gpointer synapse_desktop_file_info_parent_class = NULL;
static gint SynapseDesktopFileService_private_offset;
static gpointer synapse_desktop_file_service_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;

GQuark synapse_desktop_file_error_quark (void);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
GType synapse_desktop_file_info_environment_type_get_type (void) G_GNUC_CONST;
#define SYNAPSE_DESKTOP_FILE_INFO_GROUP "Desktop Entry"
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                                                   GKeyFile* keyfile,
                                                                   const gchar* desktop_id);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                                         const gchar* path,
                                                                         GKeyFile* keyfile,
                                                                         const gchar* desktop_id);
static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                                  GKeyFile* keyfile);
static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self,
                                                                                    gchar** environments,
                                                                                    int environments_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      const gchar* needle);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                         const gchar* value);
void synapse_desktop_file_info_set_generic_name (SynapseDesktopFileInfo* self,
                                                 const gchar* value);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                         const gchar* value);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                              gboolean value);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                            const gchar* value);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                              const gchar* value);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                                   gboolean value);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                            SynapseDesktopFileInfoEnvironmentType value);
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_utils_logger_warning (GObject* obj,
                                   const gchar* format,
                                   ...);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                             gboolean value);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const gchar* synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                               const gchar* value);
const gchar* synapse_desktop_file_info_get_generic_name (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                             const gchar* value);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_finalize (GObject * obj);
static void _vala_synapse_desktop_file_info_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_desktop_file_info_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
static void synapse_desktop_file_service_initialize_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                     GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self);
static gboolean _synapse_desktop_file_service_initialize_co_gsource_func (gpointer self);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self);
static gchar* synapse_desktop_file_service_get_cache_file_name (SynapseDesktopFileService* self,
                                                         const gchar* dir_name);
static void synapse_desktop_file_service_process_directory_data_free (gpointer _data);
static void synapse_desktop_file_service_process_directory_async_ready_wrapper (GObject *source_object,
                                                                         GAsyncResult *res,
                                                                         void *user_data);
static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                     GFile* directory,
                                                     const gchar* id_prefix,
                                                     GeeSet* monitored_dirs,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
void synapse_utils_query_exists_async (GFile* f,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static void synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                     GFile* file,
                                                     const gchar* id_prefix,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_service_load_all_desktop_files_async_ready_wrapper (GObject *source_object,
                                                                              GAsyncResult *res,
                                                                              void *user_data);
static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_);
static gchar** _vala_array_dup3 (gchar** self,
                          int length);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                               const gchar* fi,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                      GAsyncResult* _res_);
static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                          GFile* file,
                                                                                          GFile* other_file,
                                                                                          GFileMonitorEvent event_type,
                                                                                          gpointer self);
static gboolean __lambda10_ (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                               GAsyncResult* _res_);
static gboolean ___lambda10__gsource_func (gpointer self);
static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_service_reload_desktop_files_async_ready_wrapper (GObject *source_object,
                                                                            GAsyncResult *res,
                                                                            void *user_data);
static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_);
static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data);
static void synapse_desktop_file_service_load_desktop_file_async_ready_wrapper (GObject *source_object,
                                                                         GAsyncResult *res,
                                                                         void *user_data);
static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_);
static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data);
static void synapse_desktop_file_service_load_mime_parents_from_file_async_ready_wrapper (GObject *source_object,
                                                                                   GAsyncResult *res,
                                                                                   void *user_data);
static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                                    const gchar* mime,
                                                    GeeSet* ret);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                                  const gchar* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                                  const gchar* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                                              const gchar* desktop_id);
static GObject * synapse_desktop_file_service_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
static void synapse_desktop_file_service_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark
synapse_desktop_file_error_quark (void)
{
	return g_quark_from_static_string ("synapse-desktop-file-error-quark");
}


static inline gpointer
synapse_desktop_file_info_get_instance_private (SynapseDesktopFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileInfo_private_offset);
}


GType
synapse_desktop_file_info_environment_type_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_environment_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_environment_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE", "mate"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR", "razor"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE", "tde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY", "unity"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON", "pantheon"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
		GType synapse_desktop_file_info_environment_type_type_id;
		synapse_desktop_file_info_environment_type_type_id = g_flags_register_static ("SynapseDesktopFileInfoEnvironmentType", values);
		g_once_init_leave (&synapse_desktop_file_info_environment_type_type_id__volatile, synapse_desktop_file_info_environment_type_type_id);
	}
	return synapse_desktop_file_info_environment_type_type_id__volatile;
}


const gchar*
synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self)
{
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name_folded;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_name;
		_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
		_g_free0 (self->priv->name_folded);
		self->priv->name_folded = _tmp2_;
	}
	_tmp3_ = self->priv->name_folded;
	result = _tmp3_;
	return result;
}


SynapseDesktopFileInfo*
synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                 const gchar* path,
                                                 GKeyFile* keyfile,
                                                 const gchar* desktop_id)
{
	SynapseDesktopFileInfo * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (keyfile != NULL, NULL);
	g_return_val_if_fail (desktop_id != NULL, NULL);
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "filename", path, "desktop-id", desktop_id, NULL);
	synapse_desktop_file_info_init_from_keyfile (self, keyfile);
	return self;
}


SynapseDesktopFileInfo*
synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                           GKeyFile* keyfile,
                                           const gchar* desktop_id)
{
	return synapse_desktop_file_info_construct_for_keyfile (SYNAPSE_TYPE_DESKTOP_FILE_INFO, path, keyfile, desktop_id);
}


static SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self,
                                              gchar** environments,
                                              int environments_length1)
{
	SynapseDesktopFileInfoEnvironmentType result = 0;
	SynapseDesktopFileInfoEnvironmentType _result_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_result_ = 0;
	{
		gchar** env_collection = NULL;
		gint env_collection_length1 = 0;
		gint _env_collection_size_ = 0;
		gint env_it = 0;
		env_collection = environments;
		env_collection_length1 = environments_length1;
		for (env_it = 0; env_it < environments_length1; env_it = env_it + 1) {
			const gchar* env = NULL;
			env = env_collection[env_it];
			{
				gchar* env_up = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
				static GQuark _tmp4_label0 = 0;
				static GQuark _tmp4_label1 = 0;
				static GQuark _tmp4_label2 = 0;
				static GQuark _tmp4_label3 = 0;
				static GQuark _tmp4_label4 = 0;
				static GQuark _tmp4_label5 = 0;
				static GQuark _tmp4_label6 = 0;
				static GQuark _tmp4_label7 = 0;
				static GQuark _tmp4_label8 = 0;
				static GQuark _tmp4_label9 = 0;
				static GQuark _tmp4_label10 = 0;
				_tmp0_ = env;
				_tmp1_ = g_utf8_strup (_tmp0_, (gssize) -1);
				env_up = _tmp1_;
				_tmp2_ = env_up;
				_tmp3_ = _tmp2_;
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("GNOME")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp6_;
							_tmp6_ = _result_;
							_result_ = _tmp6_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("PANTHEON")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp7_;
							_tmp7_ = _result_;
							_result_ = _tmp7_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("KDE")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp8_;
							_tmp8_ = _result_;
							_result_ = _tmp8_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("LXDE")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp9_;
							_tmp9_ = _result_;
							_result_ = _tmp9_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("MATE")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp10_;
							_tmp10_ = _result_;
							_result_ = _tmp10_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("RAZOR")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp11_;
							_tmp11_ = _result_;
							_result_ = _tmp11_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("ROX")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp12_;
							_tmp12_ = _result_;
							_result_ = _tmp12_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label7) ? _tmp4_label7 : (_tmp4_label7 = g_quark_from_static_string ("TDE")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp13_;
							_tmp13_ = _result_;
							_result_ = _tmp13_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label8) ? _tmp4_label8 : (_tmp4_label8 = g_quark_from_static_string ("UNITY")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp14_;
							_tmp14_ = _result_;
							_result_ = _tmp14_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label9) ? _tmp4_label9 : (_tmp4_label9 = g_quark_from_static_string ("XFCE")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp15_;
							_tmp15_ = _result_;
							_result_ = _tmp15_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label10) ? _tmp4_label10 : (_tmp4_label10 = g_quark_from_static_string ("OLD")))) {
					switch (0) {
						default:
						{
							SynapseDesktopFileInfoEnvironmentType _tmp16_;
							_tmp16_ = _result_;
							_result_ = _tmp16_ | SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp17_;
							_tmp17_ = env;
							g_warning ("desktop-file-service.vala:105: %s is not understood", _tmp17_);
							break;
						}
					}
				}
				_g_free0 (env_up);
			}
		}
	}
	result = _result_;
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             const gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                             GKeyFile* keyfile)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyfile != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gboolean _tmp3_ = FALSE;
		GDesktopAppInfo* app_info = NULL;
		GDesktopAppInfo* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		GDesktopAppInfo* _tmp14_;
		const gchar* _tmp15_;
		GDesktopAppInfo* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp30_ = NULL;
		GDesktopAppInfo* _tmp31_;
		const gchar* _tmp32_;
		GIcon* _tmp33_ = NULL;
		GDesktopAppInfo* _tmp34_;
		GIcon* _tmp35_;
		GIcon* _tmp36_;
		GIcon* icon = NULL;
		GIcon* _tmp38_;
		GIcon* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp47_ = FALSE;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp58_ = FALSE;
		const gchar* _tmp59_;
		_tmp1_ = g_key_file_get_string (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Type", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch29_g_error;
		}
		if (g_strcmp0 (_tmp0_, "Application") != 0) {
			GError* _tmp2_;
			_tmp2_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
			_inner_error_ = _tmp2_;
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		_tmp3_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		if (_tmp3_) {
			gchar** categories = NULL;
			gsize _tmp4_ = 0;
			gchar** _tmp5_;
			gint categories_length1;
			gint _categories_size_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp5_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Categories", &_tmp4_, &_inner_error_);
			categories = _tmp5_;
			categories_length1 = _tmp4_;
			_categories_size_ = categories_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			_tmp6_ = categories;
			_tmp6__length1 = categories_length1;
			if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "Screensaver")) {
				GError* _tmp7_;
				_tmp7_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
				_inner_error_ = _tmp7_;
				categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp8_ = g_desktop_app_info_new_from_keyfile (keyfile);
		_g_object_unref0 (app_info);
		app_info = _tmp8_;
		_tmp9_ = app_info;
		if (_tmp9_ == NULL) {
			GError* _tmp10_;
			_tmp10_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Unable to create AppInfo");
			_inner_error_ = _tmp10_;
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		_tmp11_ = app_info;
		_tmp12_ = g_app_info_get_name ((GAppInfo*) _tmp11_);
		synapse_desktop_file_info_set_name (self, _tmp12_);
		_tmp14_ = app_info;
		_tmp15_ = g_desktop_app_info_get_generic_name (_tmp14_);
		_tmp13_ = _tmp15_;
		if (_tmp13_ == NULL) {
			_tmp13_ = "";
		}
		synapse_desktop_file_info_set_generic_name (self, _tmp13_);
		_tmp16_ = app_info;
		_tmp17_ = g_app_info_get_commandline ((GAppInfo*) _tmp16_);
		synapse_desktop_file_info_set_exec (self, _tmp17_);
		_tmp18_ = self->priv->_exec;
		if (_tmp18_ == NULL) {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			GError* _tmp22_;
			GError* _tmp23_;
			_tmp19_ = self->priv->_name;
			_tmp20_ = g_strdup_printf ("Unable to get exec for %s", _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			_inner_error_ = _tmp23_;
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		_tmp25_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		if (_tmp25_) {
			gboolean _tmp26_ = FALSE;
			_tmp26_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Hidden", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (app_info);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			_tmp24_ = _tmp26_;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
		}
		_tmp28_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		if (_tmp28_) {
			gboolean _tmp29_ = FALSE;
			_tmp29_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NoDisplay", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (app_info);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			_tmp27_ = _tmp29_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
		}
		_tmp31_ = app_info;
		_tmp32_ = g_app_info_get_description ((GAppInfo*) _tmp31_);
		_tmp30_ = _tmp32_;
		if (_tmp30_ == NULL) {
			_tmp30_ = "";
		}
		synapse_desktop_file_info_set_comment (self, _tmp30_);
		_tmp34_ = app_info;
		_tmp35_ = g_app_info_get_icon ((GAppInfo*) _tmp34_);
		_tmp36_ = _g_object_ref0 (_tmp35_);
		_tmp33_ = _tmp36_;
		if (_tmp33_ == NULL) {
			GThemedIcon* _tmp37_;
			_tmp37_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
			_g_object_unref0 (_tmp33_);
			_tmp33_ = (GIcon*) _tmp37_;
		}
		_tmp38_ = _g_object_ref0 (_tmp33_);
		icon = _tmp38_;
		_tmp39_ = icon;
		_tmp40_ = g_icon_to_string (_tmp39_);
		_tmp41_ = _tmp40_;
		synapse_desktop_file_info_set_icon_name (self, _tmp41_);
		_g_free0 (_tmp41_);
		_tmp42_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (icon);
			_g_object_unref0 (_tmp33_);
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		if (_tmp42_) {
			gchar** _tmp43_ = NULL;
			gsize _tmp44_ = 0;
			gchar** _tmp45_;
			gint _tmp43__length1;
			gint __tmp43__size_;
			gchar** _tmp46_;
			gint _tmp46__length1;
			_tmp45_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "MimeType", &_tmp44_, &_inner_error_);
			_tmp43_ = _tmp45_;
			_tmp43__length1 = _tmp44_;
			__tmp43__size_ = _tmp43__length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (icon);
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (app_info);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			_tmp46_ = _tmp43_;
			_tmp46__length1 = _tmp43__length1;
			_tmp43_ = NULL;
			_tmp43__length1 = 0;
			self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
			self->mime_types = _tmp46_;
			self->mime_types_length1 = _tmp46__length1;
			_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp47_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (icon);
			_g_object_unref0 (_tmp33_);
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		if (_tmp47_) {
			gboolean _tmp48_ = FALSE;
			_tmp48_ = g_key_file_get_boolean (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "Terminal", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (icon);
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (app_info);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			synapse_desktop_file_info_set_needs_terminal (self, _tmp48_);
		}
		_tmp49_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (icon);
			_g_object_unref0 (_tmp33_);
			_g_object_unref0 (app_info);
			_g_free0 (_tmp0_);
			goto __catch29_g_error;
		}
		if (_tmp49_) {
			gchar** _tmp50_ = NULL;
			gsize _tmp51_ = 0;
			gchar** _tmp52_;
			gint _tmp50__length1;
			gint __tmp50__size_;
			_tmp52_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "OnlyShowIn", &_tmp51_, &_inner_error_);
			_tmp50_ = _tmp52_;
			_tmp50__length1 = _tmp51_;
			__tmp50__size_ = _tmp50__length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (icon);
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (app_info);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			synapse_desktop_file_info_set_show_in (self, synapse_desktop_file_info_parse_environments (self, _tmp50_, _tmp50__length1));
			_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_free), NULL);
		} else {
			gboolean _tmp53_ = FALSE;
			_tmp53_ = g_key_file_has_key (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (icon);
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (app_info);
				_g_free0 (_tmp0_);
				goto __catch29_g_error;
			}
			if (_tmp53_) {
				gchar** _tmp54_ = NULL;
				gsize _tmp55_ = 0;
				gchar** _tmp56_;
				gint _tmp54__length1;
				gint __tmp54__size_;
				SynapseDesktopFileInfoEnvironmentType not_show = 0;
				SynapseDesktopFileInfoEnvironmentType _tmp57_;
				_tmp56_ = g_key_file_get_string_list (keyfile, SYNAPSE_DESKTOP_FILE_INFO_GROUP, "NotShowIn", &_tmp55_, &_inner_error_);
				_tmp54_ = _tmp56_;
				_tmp54__length1 = _tmp55_;
				__tmp54__size_ = _tmp54__length1;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (icon);
					_g_object_unref0 (_tmp33_);
					_g_object_unref0 (app_info);
					_g_free0 (_tmp0_);
					goto __catch29_g_error;
				}
				not_show = synapse_desktop_file_info_parse_environments (self, _tmp54_, _tmp54__length1);
				_tmp57_ = not_show;
				synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL ^ _tmp57_);
				_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_tmp59_ = self->priv->_filename;
		if (g_str_has_suffix (_tmp59_, "gconf-editor.desktop")) {
			_tmp58_ = TRUE;
		} else {
			const gchar* _tmp60_;
			_tmp60_ = self->priv->_filename;
			_tmp58_ = g_str_has_suffix (_tmp60_, "dconf-editor.desktop");
		}
		if (_tmp58_) {
			synapse_desktop_file_info_set_is_hidden (self, FALSE);
		}
		_g_object_unref0 (icon);
		_g_object_unref0 (_tmp33_);
		_g_object_unref0 (app_info);
		_g_free0 (_tmp0_);
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* err = NULL;
		GError* _tmp61_;
		const gchar* _tmp62_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp61_ = err;
		_tmp62_ = _tmp61_->message;
		synapse_utils_logger_warning ((GObject*) self, "%s", _tmp62_, NULL);
		synapse_desktop_file_info_set_is_valid (self, FALSE);
		_g_error_free0 (err);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


SynapseDesktopFileInfo*
synapse_desktop_file_info_construct (GType object_type)
{
	SynapseDesktopFileInfo * self = NULL;
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
	return self;
}


SynapseDesktopFileInfo*
synapse_desktop_file_info_new (void)
{
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
}


const gchar*
synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                          const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_desktop_id (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_info_get_generic_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_generic_name (SynapseDesktopFileInfo* self,
                                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_generic_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_comment (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_comment);
		self->priv->_comment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_icon_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY]);
	}
}


gboolean
synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_needs_terminal;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_info_get_needs_terminal (self) != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                        const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_filename (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY]);
	}
}


const gchar*
synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, synapse_desktop_file_info_get_exec (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY]);
	}
}


gboolean
synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_hidden;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_info_get_is_hidden (self) != value) {
		self->priv->_is_hidden = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY]);
	}
}


gboolean
synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_valid;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_info_get_is_valid (self) != value) {
		self->priv->_is_valid = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY]);
	}
}


SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self)
{
	SynapseDesktopFileInfoEnvironmentType result;
	SynapseDesktopFileInfoEnvironmentType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_show_in;
	result = _tmp0_;
	return result;
}


void
synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                       SynapseDesktopFileInfoEnvironmentType value)
{
	g_return_if_fail (self != NULL);
	if (synapse_desktop_file_info_get_show_in (self) != value) {
		self->priv->_show_in = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY]);
	}
}


static void
synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass)
{
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileInfo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY] = g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY] = g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = synapse_desktop_file_info_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_comment = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_needs_terminal = FALSE;
	self->priv->_is_hidden = FALSE;
	self->priv->_is_valid = TRUE;
	self->mime_types = NULL;
	self->mime_types_length1 = 0;
	self->priv->name_folded = NULL;
	self->priv->_show_in = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL;
}


static void
synapse_desktop_file_info_finalize (GObject * obj)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_generic_name);
	_g_free0 (self->priv->_comment);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_exec);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->name_folded);
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
}


GType
synapse_desktop_file_info_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
		SynapseDesktopFileInfo_private_offset = g_type_add_instance_private (synapse_desktop_file_info_type_id, sizeof (SynapseDesktopFileInfoPrivate));
		g_once_init_leave (&synapse_desktop_file_info_type_id__volatile, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__volatile;
}


static void
_vala_synapse_desktop_file_info_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_desktop_id (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_generic_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_desktop_file_info_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
		synapse_desktop_file_info_set_desktop_id (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY:
		synapse_desktop_file_info_set_generic_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
synapse_desktop_file_service_get_instance_private (SynapseDesktopFileService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileService_private_offset);
}


SynapseDesktopFileService*
synapse_desktop_file_service_get_default (void)
{
	SynapseDesktopFileService* result = NULL;
	SynapseDesktopFileService* _tmp0_ = NULL;
	SynapseDesktopFileService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp4_;
	_tmp1_ = synapse_desktop_file_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseDesktopFileService* _tmp3_;
		_tmp3_ = synapse_desktop_file_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static SynapseDesktopFileService*
synapse_desktop_file_service_construct (GType object_type)
{
	SynapseDesktopFileService * self = NULL;
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
	return self;
}


static SynapseDesktopFileService*
synapse_desktop_file_service_new (void)
{
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
}


static void
synapse_desktop_file_service_initialize_data_free (gpointer _data)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceInitializeData, _data_);
}


static void
synapse_desktop_file_service_initialize_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	SynapseDesktopFileServiceInitializeData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	SynapseDesktopFileService* _tmp0_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_service_initialize_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_desktop_file_service_initialize_co (_data_);
}


void
synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                GAsyncResult* _res_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_desktop_file_service_initialize_co (_data_);
}


static gboolean
_synapse_desktop_file_service_initialize_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_service_initialize_co (self);
	return result;
}


static gboolean
synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->init_once;
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->init_once;
	_data_->_state_ = 1;
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_desktop_file_service_initialize_ready, _data_);
	return FALSE;
	_state_1:
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
	_data_->_tmp2_ = _data_->is_locked;
	if (!_data_->_tmp2_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	synapse_desktop_file_service_get_environment_type (_data_->self);
	_data_->_tmp3_ = _data_->self->priv->session_type_str;
	g_desktop_app_info_set_desktop_env (_data_->_tmp3_);
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_service_initialize_co_gsource_func, _data_, NULL);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_state_ = 3;
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_initialize_ready, _data_);
	return FALSE;
	_state_3:
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
	_data_->_tmp4_ = _data_->self->priv->init_once;
	synapse_utils_async_once_leave (_data_->_tmp4_, (gpointer) ((gintptr) TRUE));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self)
{
	SynapseDesktopFileInfoEnvironmentType result = 0;
	SynapseDesktopFileInfoEnvironmentType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->session_type;
	result = _tmp0_;
	return result;
}


static void
synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self)
{
	const gchar* session_var = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* session = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	session_var = _tmp0_;
	_tmp1_ = session_var;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = g_getenv ("DESKTOP_SESSION");
		session_var = _tmp2_;
	}
	_tmp3_ = session_var;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = session_var;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	session = _tmp5_;
	_tmp7_ = session;
	if (g_str_has_prefix (_tmp7_, "unity")) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = session;
		_tmp6_ = g_str_has_prefix (_tmp8_, "ubuntu");
	}
	if (_tmp6_) {
		gchar* _tmp9_;
		self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY;
		_tmp9_ = g_strdup ("Unity");
		_g_free0 (self->priv->session_type_str);
		self->priv->session_type_str = _tmp9_;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = session;
		if (g_str_has_prefix (_tmp10_, "kde")) {
			gchar* _tmp11_;
			self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
			_tmp11_ = g_strdup ("KDE");
			_g_free0 (self->priv->session_type_str);
			self->priv->session_type_str = _tmp11_;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = session;
			if (g_str_has_prefix (_tmp12_, "gnome")) {
				gchar* _tmp13_;
				self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
				_tmp13_ = g_strdup ("GNOME");
				_g_free0 (self->priv->session_type_str);
				self->priv->session_type_str = _tmp13_;
			} else {
				const gchar* _tmp14_;
				_tmp14_ = session;
				if (g_str_has_prefix (_tmp14_, "lx")) {
					gchar* _tmp15_;
					self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
					_tmp15_ = g_strdup ("LXDE");
					_g_free0 (self->priv->session_type_str);
					self->priv->session_type_str = _tmp15_;
				} else {
					const gchar* _tmp16_;
					_tmp16_ = session;
					if (g_str_has_prefix (_tmp16_, "xfce")) {
						gchar* _tmp17_;
						self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
						_tmp17_ = g_strdup ("XFCE");
						_g_free0 (self->priv->session_type_str);
						self->priv->session_type_str = _tmp17_;
					} else {
						const gchar* _tmp18_;
						_tmp18_ = session;
						if (g_str_has_prefix (_tmp18_, "mate")) {
							gchar* _tmp19_;
							self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE;
							_tmp19_ = g_strdup ("MATE");
							_g_free0 (self->priv->session_type_str);
							self->priv->session_type_str = _tmp19_;
						} else {
							const gchar* _tmp20_;
							_tmp20_ = session;
							if (g_str_has_prefix (_tmp20_, "razor")) {
								gchar* _tmp21_;
								self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR;
								_tmp21_ = g_strdup ("Razor");
								_g_free0 (self->priv->session_type_str);
								self->priv->session_type_str = _tmp21_;
							} else {
								const gchar* _tmp22_;
								_tmp22_ = session;
								if (g_str_has_prefix (_tmp22_, "tde")) {
									gchar* _tmp23_;
									self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE;
									_tmp23_ = g_strdup ("TDE");
									_g_free0 (self->priv->session_type_str);
									self->priv->session_type_str = _tmp23_;
								} else {
									const gchar* _tmp24_;
									_tmp24_ = session;
									if (g_str_has_prefix (_tmp24_, "rox")) {
										gchar* _tmp25_;
										self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
										_tmp25_ = g_strdup ("ROX");
										_g_free0 (self->priv->session_type_str);
										self->priv->session_type_str = _tmp25_;
									} else {
										const gchar* _tmp26_;
										_tmp26_ = session;
										if (g_str_has_prefix (_tmp26_, "pantheon")) {
											gchar* _tmp27_;
											self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON;
											_tmp27_ = g_strdup ("Pantheon");
											_g_free0 (self->priv->session_type_str);
											self->priv->session_type_str = _tmp27_;
										} else {
											g_warning ("desktop-file-service.vala:331: Desktop session type is not recognized," \
" assuming GNOME.");
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (session);
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch30_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch30_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally30;
	__catch30_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
synapse_desktop_file_service_get_cache_file_name (SynapseDesktopFileService* self,
                                                  const gchar* dir_name)
{
	gchar* result = NULL;
	gchar* locale = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* filename = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dir_name != NULL, NULL);
	_tmp0_ = setlocale (LC_MESSAGES, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	locale = _tmp1_;
	_tmp2_ = locale;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_free0 (locale);
		return result;
	}
	_tmp3_ = locale;
	_tmp4_ = string_replace (_tmp3_, ".UTF-8", ".utf8");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("desktop.%s.cache", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	filename = _tmp7_;
	_tmp8_ = filename;
	_tmp9_ = g_build_filename (dir_name, _tmp8_, NULL, NULL);
	result = _tmp9_;
	_g_free0 (filename);
	_g_free0 (locale);
	return result;
}


static void
synapse_desktop_file_service_process_directory_data_free (gpointer _data)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->directory);
	_g_free0 (_data_->id_prefix);
	_g_object_unref0 (_data_->monitored_dirs);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceProcessDirectoryData, _data_);
}


static void
synapse_desktop_file_service_process_directory_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data)
{
	SynapseDesktopFileServiceProcessDirectoryData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                GFile* directory,
                                                const gchar* id_prefix,
                                                GeeSet* monitored_dirs,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GeeSet* _tmp3_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceProcessDirectoryData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_service_process_directory_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_process_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (directory);
	_g_object_unref0 (_data_->directory);
	_data_->directory = _tmp1_;
	_tmp2_ = g_strdup (id_prefix);
	_g_free0 (_data_->id_prefix);
	_data_->id_prefix = _tmp2_;
	_tmp3_ = _g_object_ref0 (monitored_dirs);
	_g_object_unref0 (_data_->monitored_dirs);
	_data_->monitored_dirs = _tmp3_;
	synapse_desktop_file_service_process_directory_co (_data_);
}


static void
synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_desktop_file_service_process_directory_co (_data_);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gboolean
synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_file_get_path (_data_->directory);
		_data_->path = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->path;
		if (_data_->_tmp2_ != NULL) {
			_data_->_tmp3_ = _data_->path;
			_data_->_tmp1_ = g_str_has_suffix (_data_->_tmp3_, "menu-xdg");
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_g_free0 (_data_->path);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!_data_->_task_complete_) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->path;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->path;
			_data_->_tmp4_ = g_str_has_suffix (_data_->_tmp6_, "/screensavers");
		} else {
			_data_->_tmp4_ = FALSE;
		}
		if (_data_->_tmp4_) {
			_g_free0 (_data_->path);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!_data_->_task_complete_) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = _data_->path;
		synapse_utils_logger_debug ((GObject*) _data_->self, "desktop-file-service.vala:361: Searching for desktop files in: %s", _data_->_tmp7_, NULL);
		_data_->_state_ = 1;
		synapse_utils_query_exists_async (_data_->directory, synapse_desktop_file_service_process_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
		_data_->_tmp8_ = _data_->exists;
		if (!_data_->_tmp8_) {
			_g_free0 (_data_->path);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!_data_->_task_complete_) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp9_ = gee_iterable_iterator ((GeeIterable*) _data_->monitored_dirs);
			_data_->_scanned_dir_it = _data_->_tmp9_;
			while (TRUE) {
				_data_->_tmp10_ = _data_->_scanned_dir_it;
				if (!gee_iterator_next (_data_->_tmp10_)) {
					break;
				}
				_data_->_tmp11_ = _data_->_scanned_dir_it;
				_data_->_tmp12_ = gee_iterator_get (_data_->_tmp11_);
				_data_->scanned_dir = (GFile*) _data_->_tmp12_;
				_data_->_tmp13_ = _data_->path;
				_data_->_tmp14_ = _data_->scanned_dir;
				_data_->_tmp15_ = g_file_get_path (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = g_strcmp0 (_data_->_tmp13_, _data_->_tmp16_) == 0;
				_g_free0 (_data_->_tmp16_);
				if (_data_->_tmp17_) {
					_g_object_unref0 (_data_->scanned_dir);
					_g_object_unref0 (_data_->_scanned_dir_it);
					_g_free0 (_data_->path);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!_data_->_task_complete_) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->scanned_dir);
			}
			_g_object_unref0 (_data_->_scanned_dir_it);
		}
		gee_collection_add ((GeeCollection*) _data_->monitored_dirs, _data_->directory);
		_data_->_state_ = 2;
		g_file_enumerate_children_async (_data_->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp18_ = g_file_enumerate_children_finish (_data_->directory, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->path);
			goto __catch31_g_error;
		}
		_data_->_tmp19_ = _data_->enumerator;
		_data_->_state_ = 3;
		g_file_enumerator_next_files_async (_data_->_tmp19_, 1024, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp20_ = g_file_enumerator_next_files_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
		_data_->files = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->enumerator);
			_g_free0 (_data_->path);
			goto __catch31_g_error;
		}
		_data_->_tmp21_ = _data_->files;
		{
			_data_->f_collection = _data_->_tmp21_;
			for (_data_->f_it = _data_->f_collection; _data_->f_it != NULL; _data_->f_it = _data_->f_it->next) {
				_data_->_tmp22_ = _g_object_ref0 ((GFileInfo*) _data_->f_it->data);
				_data_->f = _data_->_tmp22_;
				{
					_data_->_tmp23_ = _data_->f;
					_data_->_tmp24_ = g_file_info_get_name (_data_->_tmp23_);
					_data_->name = _data_->_tmp24_;
					_data_->_tmp25_ = _data_->f;
					if (g_file_info_get_file_type (_data_->_tmp25_) == G_FILE_TYPE_DIRECTORY) {
						_data_->_tmp26_ = _data_->name;
						_data_->_tmp27_ = g_file_get_child (_data_->directory, _data_->_tmp26_);
						_data_->subdir = _data_->_tmp27_;
						_data_->_tmp28_ = _data_->subdir;
						_data_->_tmp29_ = g_file_get_basename (_data_->_tmp28_);
						_data_->_tmp30_ = _data_->_tmp29_;
						_data_->_tmp31_ = g_strdup_printf ("%s%s-", _data_->id_prefix, _data_->_tmp30_);
						_data_->_tmp32_ = _data_->_tmp31_;
						_g_free0 (_data_->_tmp30_);
						_data_->new_prefix = _data_->_tmp32_;
						_data_->_tmp33_ = _data_->subdir;
						_data_->_tmp34_ = _data_->new_prefix;
						_data_->_state_ = 4;
						synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp33_, _data_->_tmp34_, _data_->monitored_dirs, synapse_desktop_file_service_process_directory_ready, _data_);
						return FALSE;
						_state_4:
						synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
						_g_free0 (_data_->new_prefix);
						_g_object_unref0 (_data_->subdir);
					} else {
						_data_->_tmp35_ = _data_->name;
						if (g_str_has_suffix (_data_->_tmp35_, "synapse.desktop")) {
							_g_object_unref0 (_data_->f);
							continue;
						}
						_data_->_tmp36_ = _data_->name;
						if (g_str_has_suffix (_data_->_tmp36_, ".desktop")) {
							_data_->_tmp37_ = _data_->name;
							_data_->_tmp38_ = g_file_get_child (_data_->directory, _data_->_tmp37_);
							_data_->_tmp39_ = _data_->_tmp38_;
							_data_->_state_ = 5;
							synapse_desktop_file_service_load_desktop_file (_data_->self, _data_->_tmp39_, _data_->id_prefix, synapse_desktop_file_service_process_directory_ready, _data_);
							return FALSE;
							_state_5:
							synapse_desktop_file_service_load_desktop_file_finish (_data_->self, _data_->_res_);
							_g_object_unref0 (_data_->_tmp39_);
						}
					}
					_g_object_unref0 (_data_->f);
				}
			}
		}
		(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
		_g_object_unref0 (_data_->enumerator);
		_g_free0 (_data_->path);
	}
	goto __finally31;
	__catch31_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp40_ = _data_->err;
		_data_->_tmp41_ = _data_->_tmp40_->message;
		g_warning ("desktop-file-service.vala:397: %s", _data_->_tmp41_);
		_g_error_free0 (_data_->err);
	}
	__finally31:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceLoadAllDesktopFilesData, _data_);
}


static void
synapse_desktop_file_service_load_all_desktop_files_async_ready_wrapper (GObject *source_object,
                                                                         GAsyncResult *res,
                                                                         void *user_data)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadAllDesktopFilesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_service_load_all_desktop_files_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_all_desktop_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
}


static void
synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static gchar**
_vala_array_dup3 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
}


static void
_synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                     GFile* file,
                                                                                     GFile* other_file,
                                                                                     GFileMonitorEvent event_type,
                                                                                     gpointer self)
{
	synapse_desktop_file_service_desktop_file_directory_changed ((SynapseDesktopFileService*) self);
}


static gboolean
synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->_tmp0_ = g_get_system_data_dirs ();
	_data_->_tmp2_ = (_data_->_tmp1_ != NULL) ? _vala_array_dup3 (_data_->_tmp1_, _vala_array_length (_data_->_tmp0_)) : ((gpointer) _data_->_tmp1_);
	_data_->_tmp2__length1 = _vala_array_length (_data_->_tmp0_);
	_data_->data_dirs = _data_->_tmp2_;
	_data_->data_dirs_length1 = _data_->_tmp2__length1;
	_data_->_data_dirs_size_ = _data_->data_dirs_length1;
	_data_->_tmp3_ = _data_->data_dirs;
	_data_->_tmp3__length1 = _data_->data_dirs_length1;
	_data_->_tmp4_ = g_get_user_data_dir ();
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_vala_array_add6 (&_data_->data_dirs, &_data_->data_dirs_length1, &_data_->_data_dirs_size_, _data_->_tmp5_);
	_data_->_tmp6_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->desktop_file_dirs = (GeeSet*) _data_->_tmp6_;
	_data_->_tmp7_ = _data_->self->priv->mimetype_parent_map;
	gee_multi_map_clear (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->data_dirs;
	_data_->_tmp8__length1 = _data_->data_dirs_length1;
	{
		_data_->data_dir_collection_length1 = 0;
		_data_->_data_dir_collection_size_ = 0;
		_data_->data_dir_collection = _data_->_tmp8_;
		_data_->data_dir_collection_length1 = _data_->_tmp8__length1;
		for (_data_->data_dir_it = 0; _data_->data_dir_it < _data_->_tmp8__length1; _data_->data_dir_it = _data_->data_dir_it + 1) {
			_data_->data_dir = _data_->data_dir_collection[_data_->data_dir_it];
			{
				_data_->_tmp9_ = _data_->data_dir;
				_data_->_tmp10_ = g_build_filename (_data_->_tmp9_, "applications", NULL, NULL);
				_data_->dir_path = _data_->_tmp10_;
				_data_->_tmp11_ = _data_->dir_path;
				_data_->_tmp12_ = g_file_new_for_path (_data_->_tmp11_);
				_data_->directory = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->directory;
				_data_->_tmp14_ = _data_->desktop_file_dirs;
				_data_->_state_ = 1;
				synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp13_, "", _data_->_tmp14_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
				return FALSE;
				_state_1:
				synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
				_data_->_tmp15_ = _data_->data_dir;
				_data_->_tmp16_ = g_build_filename (_data_->_tmp15_, "mime", "subclasses", NULL);
				_g_free0 (_data_->dir_path);
				_data_->dir_path = _data_->_tmp16_;
				_data_->_tmp17_ = _data_->dir_path;
				_data_->_state_ = 2;
				synapse_desktop_file_service_load_mime_parents_from_file (_data_->self, _data_->_tmp17_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
				return FALSE;
				_state_2:
				synapse_desktop_file_service_load_mime_parents_from_file_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->directory);
				_g_free0 (_data_->dir_path);
			}
		}
	}
	synapse_desktop_file_service_create_indices (_data_->self);
	_data_->_tmp18_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->directory_monitors);
	_data_->self->priv->directory_monitors = (GeeList*) _data_->_tmp18_;
	{
		_data_->_tmp19_ = _data_->desktop_file_dirs;
		_data_->_tmp20_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp19_);
		_data_->_d_it = _data_->_tmp20_;
		while (TRUE) {
			_data_->_tmp21_ = _data_->_d_it;
			if (!gee_iterator_next (_data_->_tmp21_)) {
				break;
			}
			_data_->_tmp22_ = _data_->_d_it;
			_data_->_tmp23_ = gee_iterator_get (_data_->_tmp22_);
			_data_->d = (GFile*) _data_->_tmp23_;
			{
				_data_->_tmp24_ = _data_->d;
				_data_->_tmp25_ = g_file_monitor_directory (_data_->_tmp24_, 0, NULL, &_data_->_inner_error_);
				_data_->monitor = _data_->_tmp25_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch32_g_error;
				}
				_data_->_tmp26_ = _data_->monitor;
				g_signal_connect_object (_data_->_tmp26_, "changed", (GCallback) _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed, _data_->self, 0);
				_data_->_tmp27_ = _data_->self->priv->directory_monitors;
				_data_->_tmp28_ = _data_->monitor;
				gee_collection_add ((GeeCollection*) _data_->_tmp27_, _data_->_tmp28_);
				_g_object_unref0 (_data_->monitor);
			}
			goto __finally32;
			__catch32_g_error:
			{
				_data_->err = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp29_ = _data_->err;
				_data_->_tmp30_ = _data_->_tmp29_->message;
				g_warning ("desktop-file-service.vala:432: Unable to monitor directory: %s", _data_->_tmp30_);
				_g_error_free0 (_data_->err);
			}
			__finally32:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->d);
				_g_object_unref0 (_data_->_d_it);
				_g_object_unref0 (_data_->desktop_file_dirs);
				_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->d);
		}
		_g_object_unref0 (_data_->_d_it);
	}
	_g_object_unref0 (_data_->desktop_file_dirs);
	_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean
__lambda10_ (SynapseDesktopFileService* self)
{
	gboolean result = FALSE;
	self->priv->timer_id = (guint) 0;
	synapse_desktop_file_service_reload_desktop_files (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ ((SynapseDesktopFileService*) self);
	return result;
}


static void
synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_signal_emit (self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL], 0);
	_tmp0_ = self->priv->timer_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->timer_id;
		g_source_remove (_tmp1_);
	}
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
}


static void
synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceReloadDesktopFilesData, _data_);
}


static void
synapse_desktop_file_service_reload_desktop_files_async_ready_wrapper (GObject *source_object,
                                                                       GAsyncResult *res,
                                                                       void *user_data)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceReloadDesktopFilesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_service_reload_desktop_files_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_reload_desktop_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
}


static void
synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                          GAsyncResult* _res_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
}


static gboolean
synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("desktop-file-service.vala:460: Reloading desktop files...");
	_data_->_tmp0_ = _data_->self->priv->all_desktop_files;
	gee_collection_clear ((GeeCollection*) _data_->_tmp0_);
	_data_->_tmp1_ = _data_->self->priv->non_hidden_desktop_files;
	gee_collection_clear ((GeeCollection*) _data_->_tmp1_);
	_data_->_state_ = 1;
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_reload_desktop_files_ready, _data_);
	return FALSE;
	_state_1:
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
	g_signal_emit (_data_->self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL], 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->id_prefix);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceLoadDesktopFileData, _data_);
}


static void
synapse_desktop_file_service_load_desktop_file_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                GFile* file,
                                                const gchar* id_prefix,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadDesktopFileData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_service_load_desktop_file_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_desktop_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = g_strdup (id_prefix);
	_g_free0 (_data_->id_prefix);
	_data_->id_prefix = _tmp2_;
	synapse_desktop_file_service_load_desktop_file_co (_data_);
}


static void
synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_desktop_file_service_load_desktop_file_co (_data_);
}


static gboolean
synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->file_contents_length1 = 0;
		_data_->_file_contents_size_ = 0;
		_data_->_tmp0_ = NULL;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->file, NULL, synapse_desktop_file_service_load_desktop_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_load_contents_finish (_data_->file, _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_, NULL, &_data_->_inner_error_);
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
		_data_->file_contents = _data_->_tmp0_;
		_data_->file_contents_length1 = _data_->_tmp1_;
		_data_->_file_contents_size_ = _data_->file_contents_length1;
		_data_->success = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
			goto __catch33_g_error;
		}
		_data_->_tmp3_ = _data_->success;
		if (_data_->_tmp3_) {
			_data_->_tmp4_ = g_key_file_new ();
			_data_->keyfile = _data_->_tmp4_;
			_data_->_tmp5_ = _data_->keyfile;
			_data_->_tmp6_ = _data_->file_contents;
			_data_->_tmp6__length1 = _data_->file_contents_length1;
			_data_->_tmp7_ = _data_->file_contents;
			_data_->_tmp7__length1 = _data_->file_contents_length1;
			g_key_file_load_from_data (_data_->_tmp5_, (const gchar*) _data_->_tmp6_, (gsize) _data_->_tmp7__length1, 0, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_key_file_unref0 (_data_->keyfile);
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
				goto __catch33_g_error;
			}
			_data_->_tmp8_ = g_file_get_basename (_data_->file);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = g_strdup_printf ("%s%s", _data_->id_prefix, _data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_g_free0 (_data_->_tmp9_);
			_data_->desktop_id = _data_->_tmp11_;
			_data_->_tmp12_ = g_file_get_path (_data_->file);
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = _data_->keyfile;
			_data_->_tmp15_ = _data_->desktop_id;
			_data_->_tmp16_ = synapse_desktop_file_info_new_for_keyfile (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_g_free0 (_data_->_tmp13_);
			_data_->dfi = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->dfi;
			_data_->_tmp19_ = synapse_desktop_file_info_get_is_valid (_data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			if (_data_->_tmp20_) {
				_data_->_tmp21_ = _data_->self->priv->all_desktop_files;
				_data_->_tmp22_ = _data_->dfi;
				gee_collection_add ((GeeCollection*) _data_->_tmp21_, _data_->_tmp22_);
				_data_->_tmp24_ = _data_->dfi;
				_data_->_tmp25_ = synapse_desktop_file_info_get_is_hidden (_data_->_tmp24_);
				_data_->_tmp26_ = _data_->_tmp25_;
				if (!_data_->_tmp26_) {
					_data_->_tmp27_ = _data_->self->priv->session_type;
					_data_->_tmp28_ = _data_->dfi;
					_data_->_tmp29_ = synapse_desktop_file_info_get_show_in (_data_->_tmp28_);
					_data_->_tmp30_ = _data_->_tmp29_;
					_data_->_tmp23_ = (_data_->_tmp30_ & _data_->_tmp27_) == _data_->_tmp27_;
				} else {
					_data_->_tmp23_ = FALSE;
				}
				if (_data_->_tmp23_) {
					_data_->_tmp31_ = _data_->self->priv->non_hidden_desktop_files;
					_data_->_tmp32_ = _data_->dfi;
					gee_collection_add ((GeeCollection*) _data_->_tmp31_, _data_->_tmp32_);
				}
			}
			_g_object_unref0 (_data_->dfi);
			_g_free0 (_data_->desktop_id);
			_g_key_file_unref0 (_data_->keyfile);
		}
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
	}
	goto __finally33;
	__catch33_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp33_ = _data_->err;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_warning ("desktop-file-service.vala:497: %s", _data_->_tmp34_);
		_g_error_free0 (_data_->err);
	}
	__finally33:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void
synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GRegex* exec_re = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mimetype_map);
	self->priv->mimetype_map = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exec_map);
	self->priv->exec_map = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->desktop_id_map);
	self->priv->desktop_id_map = (GeeMap*) _tmp2_;
	{
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp4_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch34_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (exec_re);
		exec_re = _tmp5_;
		_g_regex_unref0 (_tmp3_);
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("desktop-file-service.vala:520: %s", _tmp7_);
		_g_error_free0 (err);
		_g_regex_unref0 (exec_re);
		return;
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (exec_re);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GeeList* _dfi_list = NULL;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		gint _dfi_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _dfi_index = 0;
		_tmp8_ = self->priv->all_desktop_files;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_dfi_list = _tmp9_;
		_tmp10_ = _dfi_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_dfi_size = _tmp12_;
		_dfi_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			SynapseDesktopFileInfo* dfi = NULL;
			GeeList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			gchar* exec = NULL;
			gchar* _tmp19_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			GeeList* exec_list = NULL;
			GeeMap* _tmp31_;
			const gchar* _tmp32_;
			gpointer _tmp33_;
			GeeList* _tmp34_;
			GeeList* _tmp39_;
			SynapseDesktopFileInfo* _tmp40_;
			gchar* _tmp41_ = NULL;
			SynapseDesktopFileInfo* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* desktop_id = NULL;
			gchar* _tmp50_;
			GeeMap* _tmp51_;
			const gchar* _tmp52_;
			SynapseDesktopFileInfo* _tmp53_;
			gboolean _tmp54_ = FALSE;
			SynapseDesktopFileInfo* _tmp55_;
			gboolean _tmp56_;
			gboolean _tmp57_;
			SynapseDesktopFileInfo* _tmp60_;
			gchar** _tmp61_;
			gint _tmp61__length1;
			_tmp13_ = _dfi_index;
			_dfi_index = _tmp13_ + 1;
			_tmp14_ = _dfi_index;
			_tmp15_ = _dfi_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _dfi_list;
			_tmp17_ = _dfi_index;
			_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
			dfi = (SynapseDesktopFileInfo*) _tmp18_;
			_tmp19_ = g_strdup ("");
			exec = _tmp19_;
			{
				gchar* _tmp20_ = NULL;
				GRegex* _tmp21_;
				SynapseDesktopFileInfo* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp21_ = exec_re;
				_tmp22_ = dfi;
				_tmp23_ = synapse_desktop_file_info_get_exec (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_regex_replace_literal (_tmp21_, _tmp24_, (gssize) -1, 0, "", 0, &_inner_error_);
				_tmp20_ = _tmp25_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch35_g_regex_error;
					}
					_g_free0 (exec);
					_g_object_unref0 (dfi);
					_g_object_unref0 (_dfi_list);
					_g_regex_unref0 (exec_re);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp26_ = _tmp20_;
				_tmp20_ = NULL;
				_g_free0 (exec);
				exec = _tmp26_;
				_g_free0 (_tmp20_);
			}
			goto __finally35;
			__catch35_g_regex_error:
			{
				GError* err = NULL;
				GError* _tmp27_;
				const gchar* _tmp28_;
				err = _inner_error_;
				_inner_error_ = NULL;
				_tmp27_ = err;
				_tmp28_ = _tmp27_->message;
				synapse_utils_logger_error ((GObject*) self, "%s", _tmp28_, NULL);
				_g_error_free0 (err);
			}
			__finally35:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (exec);
				_g_object_unref0 (dfi);
				_g_object_unref0 (_dfi_list);
				_g_regex_unref0 (exec_re);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp29_ = exec;
			_tmp30_ = string_strip (_tmp29_);
			_g_free0 (exec);
			exec = _tmp30_;
			_tmp31_ = self->priv->exec_map;
			_tmp32_ = exec;
			_tmp33_ = gee_map_get (_tmp31_, _tmp32_);
			exec_list = (GeeList*) _tmp33_;
			_tmp34_ = exec_list;
			if (_tmp34_ == NULL) {
				GeeArrayList* _tmp35_;
				GeeMap* _tmp36_;
				const gchar* _tmp37_;
				GeeList* _tmp38_;
				_tmp35_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (exec_list);
				exec_list = (GeeList*) _tmp35_;
				_tmp36_ = self->priv->exec_map;
				_tmp37_ = exec;
				_tmp38_ = exec_list;
				gee_map_set (_tmp36_, _tmp37_, _tmp38_);
			}
			_tmp39_ = exec_list;
			_tmp40_ = dfi;
			gee_collection_add ((GeeCollection*) _tmp39_, _tmp40_);
			_tmp42_ = dfi;
			_tmp43_ = synapse_desktop_file_info_get_desktop_id (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strdup (_tmp44_);
			_tmp41_ = _tmp45_;
			if (_tmp41_ == NULL) {
				SynapseDesktopFileInfo* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp46_ = dfi;
				_tmp47_ = synapse_desktop_file_info_get_filename (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_path_get_basename (_tmp48_);
				_g_free0 (_tmp41_);
				_tmp41_ = _tmp49_;
			}
			_tmp50_ = g_strdup (_tmp41_);
			desktop_id = _tmp50_;
			_tmp51_ = self->priv->desktop_id_map;
			_tmp52_ = desktop_id;
			_tmp53_ = dfi;
			gee_map_set (_tmp51_, _tmp52_, _tmp53_);
			_tmp55_ = dfi;
			_tmp56_ = synapse_desktop_file_info_get_is_hidden (_tmp55_);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				_tmp54_ = TRUE;
			} else {
				SynapseDesktopFileInfo* _tmp58_;
				gchar** _tmp59_;
				gint _tmp59__length1;
				_tmp58_ = dfi;
				_tmp59_ = _tmp58_->mime_types;
				_tmp59__length1 = _tmp58_->mime_types_length1;
				_tmp54_ = _tmp59_ == NULL;
			}
			if (_tmp54_) {
				_g_free0 (desktop_id);
				_g_free0 (_tmp41_);
				_g_object_unref0 (exec_list);
				_g_free0 (exec);
				_g_object_unref0 (dfi);
				continue;
			}
			_tmp60_ = dfi;
			_tmp61_ = _tmp60_->mime_types;
			_tmp61__length1 = _tmp60_->mime_types_length1;
			{
				gchar** mime_type_collection = NULL;
				gint mime_type_collection_length1 = 0;
				gint _mime_type_collection_size_ = 0;
				gint mime_type_it = 0;
				mime_type_collection = _tmp61_;
				mime_type_collection_length1 = _tmp61__length1;
				for (mime_type_it = 0; mime_type_it < _tmp61__length1; mime_type_it = mime_type_it + 1) {
					const gchar* mime_type = NULL;
					mime_type = mime_type_collection[mime_type_it];
					{
						GeeList* list = NULL;
						GeeMap* _tmp62_;
						const gchar* _tmp63_;
						gpointer _tmp64_;
						GeeList* _tmp65_;
						GeeList* _tmp70_;
						SynapseDesktopFileInfo* _tmp71_;
						_tmp62_ = self->priv->mimetype_map;
						_tmp63_ = mime_type;
						_tmp64_ = gee_map_get (_tmp62_, _tmp63_);
						list = (GeeList*) _tmp64_;
						_tmp65_ = list;
						if (_tmp65_ == NULL) {
							GeeArrayList* _tmp66_;
							GeeMap* _tmp67_;
							const gchar* _tmp68_;
							GeeList* _tmp69_;
							_tmp66_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
							_g_object_unref0 (list);
							list = (GeeList*) _tmp66_;
							_tmp67_ = self->priv->mimetype_map;
							_tmp68_ = mime_type;
							_tmp69_ = list;
							gee_map_set (_tmp67_, _tmp68_, _tmp69_);
						}
						_tmp70_ = list;
						_tmp71_ = dfi;
						gee_collection_add ((GeeCollection*) _tmp70_, _tmp71_);
						_g_object_unref0 (list);
					}
				}
			}
			_g_free0 (desktop_id);
			_g_free0 (_tmp41_);
			_g_object_unref0 (exec_list);
			_g_free0 (exec);
			_g_object_unref0 (dfi);
		}
		_g_object_unref0 (_dfi_list);
	}
	_g_regex_unref0 (exec_re);
}


static void
synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->fi);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceLoadMimeParentsFromFileData, _data_);
}


static void
synapse_desktop_file_service_load_mime_parents_from_file_async_ready_wrapper (GObject *source_object,
                                                                              GAsyncResult *res,
                                                                              void *user_data)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                          const gchar* fi,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	gchar* _tmp1_;
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadMimeParentsFromFileData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_desktop_file_service_load_mime_parents_from_file_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_mime_parents_from_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (fi);
	_g_free0 (_data_->fi);
	_data_->fi = _tmp1_;
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
}


static void
synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
}


static gboolean
synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->fi);
	_data_->file = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->file;
	_data_->_state_ = 1;
	synapse_utils_query_exists_async (_data_->_tmp1_, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
	return FALSE;
	_state_1:
	_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
	_data_->_tmp2_ = _data_->exists;
	if (!_data_->_tmp2_) {
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp3_ = _data_->file;
		_data_->_state_ = 2;
		g_file_read_async (_data_->_tmp3_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = g_file_read_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->fis = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_data_->_tmp5_ = _data_->fis;
		_data_->_tmp6_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp5_);
		_data_->dis = _data_->_tmp6_;
		_data_->line = NULL;
		_data_->mimes = NULL;
		_data_->mimes_length1 = 0;
		_data_->_mimes_size_ = _data_->mimes_length1;
		_data_->len = 0;
		while (TRUE) {
			_data_->_tmp8_ = _data_->dis;
			_data_->_state_ = 3;
			g_data_input_stream_read_line_async (_data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp9_ = g_data_input_stream_read_line_finish (_data_->_tmp8_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->_tmp7_ = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->fis);
				goto __catch36_g_error;
			}
			_data_->_tmp10_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp10_;
			_data_->_tmp11_ = _data_->line;
			if (_data_->_tmp11_ == NULL) {
				_g_free0 (_data_->_tmp7_);
				break;
			}
			_data_->_tmp12_ = _data_->line;
			if (g_str_has_prefix (_data_->_tmp12_, "#")) {
				_g_free0 (_data_->_tmp7_);
				continue;
			}
			_data_->_tmp13_ = _data_->line;
			_data_->_tmp15_ = _data_->_tmp14_ = g_strsplit (_data_->_tmp13_, " ", 0);
			_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
			_data_->mimes = _data_->_tmp15_;
			_data_->mimes_length1 = _vala_array_length (_data_->_tmp14_);
			_data_->_mimes_size_ = _data_->mimes_length1;
			_data_->_tmp16_ = _data_->mimes;
			_data_->_tmp16__length1 = _data_->mimes_length1;
			_data_->len = (gint) g_strv_length (_data_->_tmp16_);
			_data_->_tmp17_ = _data_->len;
			if (_data_->_tmp17_ != 2) {
				_g_free0 (_data_->_tmp7_);
				continue;
			}
			_data_->_tmp18_ = _data_->mimes;
			_data_->_tmp18__length1 = _data_->mimes_length1;
			_data_->_tmp19_ = _data_->_tmp18_[0];
			_data_->_tmp20_ = _data_->mimes;
			_data_->_tmp20__length1 = _data_->mimes_length1;
			_data_->_tmp21_ = _data_->_tmp20_[1];
			if (g_strcmp0 (_data_->_tmp19_, _data_->_tmp21_) == 0) {
				_g_free0 (_data_->_tmp7_);
				continue;
			}
			_data_->_tmp22_ = _data_->self->priv->mimetype_parent_map;
			_data_->_tmp23_ = _data_->mimes;
			_data_->_tmp23__length1 = _data_->mimes_length1;
			_data_->_tmp24_ = _data_->_tmp23_[0];
			_data_->_tmp25_ = _data_->mimes;
			_data_->_tmp25__length1 = _data_->mimes_length1;
			_data_->_tmp26_ = _data_->_tmp25_[1];
			gee_multi_map_set (_data_->_tmp22_, _data_->_tmp24_, _data_->_tmp26_);
			_g_free0 (_data_->_tmp7_);
		}
		_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->fis);
	}
	goto __finally36;
	__catch36_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->err);
	}
	__finally36:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                               const gchar* mime,
                                               GeeSet* ret)
{
	GeeList* dfis = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeCollection* parents = NULL;
	GeeMultiMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime != NULL);
	g_return_if_fail (ret != NULL);
	_tmp0_ = self->priv->mimetype_map;
	_tmp1_ = gee_map_get (_tmp0_, mime);
	dfis = (GeeList*) _tmp1_;
	_tmp2_ = dfis;
	if (_tmp2_ != NULL) {
		GeeList* _tmp3_;
		_tmp3_ = dfis;
		gee_collection_add_all ((GeeCollection*) ret, (GeeCollection*) _tmp3_);
	}
	_tmp4_ = self->priv->mimetype_parent_map;
	_tmp5_ = gee_multi_map_get (_tmp4_, mime);
	parents = _tmp5_;
	_tmp6_ = parents;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (parents);
		_g_object_unref0 (dfis);
		return;
	}
	{
		GeeIterator* _parent_it = NULL;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp7_ = parents;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_parent_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			gchar* parent = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
			_tmp9_ = _parent_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _parent_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			parent = (gchar*) _tmp11_;
			_tmp12_ = parent;
			synapse_desktop_file_service_add_dfi_for_mime (self, _tmp12_, ret);
			_g_free0 (parent);
		}
		_g_object_unref0 (_parent_it);
	}
	_g_object_unref0 (parents);
	_g_object_unref0 (dfis);
}


GeeList*
synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->non_hidden_desktop_files;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


GeeList*
synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_desktop_files;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


GeeList*
synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                         const gchar* mime_type)
{
	GeeList* result = NULL;
	GeeHashSet* dfi_set = NULL;
	GeeHashSet* _tmp0_;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	dfi_set = _tmp0_;
	synapse_desktop_file_service_add_dfi_for_mime (self, mime_type, (GeeSet*) dfi_set);
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = _tmp1_;
	gee_array_list_add_all (ret, (GeeCollection*) dfi_set);
	result = (GeeList*) ret;
	_g_object_unref0 (dfi_set);
	return result;
}


GeeList*
synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                         const gchar* exec)
{
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp1_ = self->priv->exec_map;
	_tmp2_ = gee_map_get (_tmp1_, exec);
	_tmp0_ = (GeeList*) _tmp2_;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp3_;
		_tmp3_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GeeList*) _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}


SynapseDesktopFileInfo*
synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                      const gchar* desktop_id)
{
	SynapseDesktopFileInfo* result = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = self->priv->desktop_id_map;
	_tmp1_ = gee_map_get (_tmp0_, desktop_id);
	result = (SynapseDesktopFileInfo*) _tmp1_;
	return result;
}


static GObject *
synapse_desktop_file_service_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	SynapseUtilsAsyncOnce* _tmp4_;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
	synapse_desktop_file_service_instance = self;
	_tmp0_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->directory_monitors);
	self->priv->directory_monitors = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->all_desktop_files);
	self->priv->all_desktop_files = (GeeList*) _tmp1_;
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	self->priv->non_hidden_desktop_files = (GeeList*) _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mimetype_parent_map);
	self->priv->mimetype_parent_map = (GeeMultiMap*) _tmp3_;
	_tmp4_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
	_synapse_utils_async_once_unref0 (self->priv->init_once);
	self->priv->init_once = _tmp4_;
	synapse_desktop_file_service_initialize (self, NULL, NULL);
	return obj;
}


static void
synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass)
{
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL] = g_signal_new ("reload-started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL] = g_signal_new ("reload-done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self)
{
	gchar* _tmp0_;
	self->priv = synapse_desktop_file_service_get_instance_private (self);
	self->priv->session_type = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
	_tmp0_ = g_strdup ("GNOME");
	self->priv->session_type_str = _tmp0_;
	self->priv->timer_id = (guint) 0;
}


static void
synapse_desktop_file_service_finalize (GObject * obj)
{
	SynapseDesktopFileService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
	synapse_desktop_file_service_instance = NULL;
	_synapse_utils_async_once_unref0 (self->priv->init_once);
	_g_object_unref0 (self->priv->directory_monitors);
	_g_object_unref0 (self->priv->all_desktop_files);
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	_g_object_unref0 (self->priv->mimetype_map);
	_g_object_unref0 (self->priv->exec_map);
	_g_object_unref0 (self->priv->desktop_id_map);
	_g_object_unref0 (self->priv->mimetype_parent_map);
	_g_free0 (self->priv->session_type_str);
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
}


GType
synapse_desktop_file_service_get_type (void)
{
	static volatile gsize synapse_desktop_file_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
		SynapseDesktopFileService_private_offset = g_type_add_instance_private (synapse_desktop_file_service_type_id, sizeof (SynapseDesktopFileServicePrivate));
		g_once_init_leave (&synapse_desktop_file_service_type_id__volatile, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



