/* dbus-service.c generated by valac 0.42.5, the Vala compiler
 * generated from dbus-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define SYNAPSE_TYPE_FREE_DESKTOP_DBUS (synapse_free_desktop_dbus_get_type ())
#define SYNAPSE_FREE_DESKTOP_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS, SynapseFreeDesktopDBus))
#define SYNAPSE_IS_FREE_DESKTOP_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS))
#define SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS, SynapseFreeDesktopDBusIface))

typedef struct _SynapseFreeDesktopDBus SynapseFreeDesktopDBus;
typedef struct _SynapseFreeDesktopDBusIface SynapseFreeDesktopDBusIface;

#define SYNAPSE_TYPE_FREE_DESKTOP_DBUS_PROXY (synapse_free_desktop_dbus_proxy_get_type ())
enum  {
	SYNAPSE_FREE_DESKTOP_DBUS_NAME_OWNER_CHANGED_SIGNAL,
	SYNAPSE_FREE_DESKTOP_DBUS_NUM_SIGNALS
};
static guint synapse_free_desktop_dbus_signals[SYNAPSE_FREE_DESKTOP_DBUS_NUM_SIGNALS] = {0};
typedef GDBusProxy SynapseFreeDesktopDBusProxy;
typedef GDBusProxyClass SynapseFreeDesktopDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseFreeDesktopDbusListQueuedOwnersReadyData SynapseFreeDesktopDbusListQueuedOwnersReadyData;
typedef struct _SynapseFreeDesktopDbusListNamesReadyData SynapseFreeDesktopDbusListNamesReadyData;
typedef struct _SynapseFreeDesktopDbusListActivatableNamesReadyData SynapseFreeDesktopDbusListActivatableNamesReadyData;
typedef struct _SynapseFreeDesktopDbusNameHasOwnerReadyData SynapseFreeDesktopDbusNameHasOwnerReadyData;
typedef struct _SynapseFreeDesktopDbusStartServiceByNameReadyData SynapseFreeDesktopDbusStartServiceByNameReadyData;
typedef struct _SynapseFreeDesktopDbusGetNameOwnerReadyData SynapseFreeDesktopDbusGetNameOwnerReadyData;

#define SYNAPSE_TYPE_DBUS_SERVICE (synapse_dbus_service_get_type ())
#define SYNAPSE_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService))
#define SYNAPSE_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusServiceClass))
#define SYNAPSE_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DBUS_SERVICE))
#define SYNAPSE_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DBUS_SERVICE))
#define SYNAPSE_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusServiceClass))

typedef struct _SynapseDBusService SynapseDBusService;
typedef struct _SynapseDBusServiceClass SynapseDBusServiceClass;
typedef struct _SynapseDBusServicePrivate SynapseDBusServicePrivate;

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
enum  {
	SYNAPSE_DBUS_SERVICE_0_PROPERTY,
	SYNAPSE_DBUS_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_dbus_service_properties[SYNAPSE_DBUS_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDbusServiceInitializeData SynapseDbusServiceInitializeData;
enum  {
	SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL,
	SYNAPSE_DBUS_SERVICE_NUM_SIGNALS
};
static guint synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_NUM_SIGNALS] = {0};

struct _SynapseFreeDesktopDBusIface {
	GTypeInterface parent_iface;
	void (*list_queued_owners) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_queued_owners_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_names) (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*name_has_owner) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*name_has_owner_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
	void (*start_service_by_name) (SynapseFreeDesktopDBus* self, const gchar* name, guint32 flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32 (*start_service_by_name_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
	void (*get_name_owner) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_name_owner_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseFreeDesktopDbusListQueuedOwnersReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

struct _SynapseFreeDesktopDbusListNamesReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SynapseFreeDesktopDbusListActivatableNamesReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SynapseFreeDesktopDbusNameHasOwnerReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

struct _SynapseFreeDesktopDbusStartServiceByNameReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
	guint32 flags;
};

struct _SynapseFreeDesktopDbusGetNameOwnerReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

struct _SynapseDBusService {
	GObject parent_instance;
	SynapseDBusServicePrivate * priv;
};

struct _SynapseDBusServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDBusServicePrivate {
	SynapseFreeDesktopDBus* proxy;
	GeeSet* owned_names;
	GeeSet* activatable_names;
	GeeSet* system_activatable_names;
	SynapseUtilsAsyncOnce* init_once;
};

struct _SynapseDbusServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseDBusService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	gboolean _tmp2_;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	SynapseFreeDesktopDBus* _tmp3_;
	SynapseFreeDesktopDBus* _tmp4_;
	SynapseFreeDesktopDBus* _tmp5_;
	SynapseFreeDesktopDBus* _tmp6_;
	gchar** _tmp7_;
	SynapseFreeDesktopDBus* _tmp8_;
	gint _tmp9_;
	gchar** _tmp10_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** name_collection;
	gint name_collection_length1;
	gint _name_collection_size_;
	gint name_it;
	const gchar* name;
	const gchar* _tmp13_;
	GeeSet* _tmp14_;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	SynapseFreeDesktopDBus* _tmp17_;
	gint _tmp18_;
	gchar** _tmp19_;
	gint _tmp16__length1;
	gint __tmp16__size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** session_act_collection;
	gint session_act_collection_length1;
	gint _session_act_collection_size_;
	gint session_act_it;
	const gchar* session_act;
	GeeSet* _tmp22_;
	const gchar* _tmp23_;
	GError* err;
	GError* _tmp24_;
	const gchar* _tmp25_;
	SynapseFreeDesktopDBus* sys_proxy;
	SynapseFreeDesktopDBus* _tmp26_;
	gchar** _tmp27_;
	SynapseFreeDesktopDBus* _tmp28_;
	gint _tmp29_;
	gchar** _tmp30_;
	gint _tmp27__length1;
	gint __tmp27__size_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gchar** system_act_collection;
	gint system_act_collection_length1;
	gint _system_act_collection_size_;
	gint system_act_it;
	const gchar* system_act;
	GeeSet* _tmp33_;
	const gchar* _tmp34_;
	GError* sys_err;
	GError* _tmp35_;
	const gchar* _tmp36_;
	SynapseUtilsAsyncOnce* _tmp37_;
	GError * _inner_error_;
};


static gint SynapseDBusService_private_offset;
static gpointer synapse_dbus_service_parent_class = NULL;
static SynapseDBusService* synapse_dbus_service_instance;
static SynapseDBusService* synapse_dbus_service_instance = NULL;

GType synapse_free_desktop_dbus_proxy_get_type (void) G_GNUC_CONST;
guint synapse_free_desktop_dbus_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
GType synapse_free_desktop_dbus_get_type (void) G_GNUC_CONST;
void synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                                   const gchar* name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                             GAsyncResult* _res_,
                                                             int* result_length1,
                                                             GError** error);
void synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_names_finish (SynapseFreeDesktopDBus* self,
                                                     GAsyncResult* _res_,
                                                     int* result_length1,
                                                     GError** error);
void synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                                 GAsyncResult* _res_,
                                                                 int* result_length1,
                                                                 GError** error);
void synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                               const gchar* name,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
gboolean synapse_free_desktop_dbus_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
void synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                      const gchar* name,
                                                      guint32 flags,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
guint32 synapse_free_desktop_dbus_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
void synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                               const gchar* name,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
gchar* synapse_free_desktop_dbus_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
#define SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME "org.freedesktop.DBus"
#define SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH "/org/freedesktop/DBus"
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void synapse_free_desktop_dbus_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static void _dbus_handle_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* self,
                                                                GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void synapse_free_desktop_dbus_proxy_list_queued_owners_async (SynapseFreeDesktopDBus* self,
                                                               const gchar* name,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static gchar** synapse_free_desktop_dbus_proxy_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                                   GAsyncResult* _res_,
                                                                   int* result_length1,
                                                                   GError** error);
static void synapse_free_desktop_dbus_proxy_list_names_async (SynapseFreeDesktopDBus* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gchar** synapse_free_desktop_dbus_proxy_list_names_finish (SynapseFreeDesktopDBus* self,
                                                           GAsyncResult* _res_,
                                                           int* result_length1,
                                                           GError** error);
static void synapse_free_desktop_dbus_proxy_list_activatable_names_async (SynapseFreeDesktopDBus* self,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static gchar** synapse_free_desktop_dbus_proxy_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                                       GAsyncResult* _res_,
                                                                       int* result_length1,
                                                                       GError** error);
static void synapse_free_desktop_dbus_proxy_name_has_owner_async (SynapseFreeDesktopDBus* self,
                                                           const gchar* name,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gboolean synapse_free_desktop_dbus_proxy_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void synapse_free_desktop_dbus_proxy_start_service_by_name_async (SynapseFreeDesktopDBus* self,
                                                                  const gchar* name,
                                                                  guint32 flags,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static guint32 synapse_free_desktop_dbus_proxy_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void synapse_free_desktop_dbus_proxy_get_name_owner_async (SynapseFreeDesktopDBus* self,
                                                           const gchar* name,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gchar* synapse_free_desktop_dbus_proxy_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void synapse_free_desktop_dbus_proxy_synapse_free_desktop_dbus_interface_init (SynapseFreeDesktopDBusIface* iface);
static void _dbus_synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_list_queued_owners_ready (GObject * source_object,
                                                               GAsyncResult * _res_,
                                                               gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_list_names_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_list_activatable_names_ready (GObject * source_object,
                                                                   GAsyncResult * _res_,
                                                                   gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_name_has_owner_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_start_service_by_name_ready (GObject * source_object,
                                                                  GAsyncResult * _res_,
                                                                  gpointer _user_data_);
static void _dbus_synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_synapse_free_desktop_dbus_get_name_owner_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void synapse_free_desktop_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* synapse_free_desktop_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean synapse_free_desktop_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _dbus_synapse_free_desktop_dbus_name_owner_changed (GObject* _sender,
                                                         const gchar* name,
                                                         const gchar* old_owner,
                                                         const gchar* new_owner,
                                                         gpointer* _data);
static void _synapse_free_desktop_dbus_unregister_object (gpointer user_data);
GType synapse_dbus_service_get_type (void) G_GNUC_CONST;
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
SynapseDBusService* synapse_dbus_service_get_default (void);
static SynapseDBusService* synapse_dbus_service_new (void);
static SynapseDBusService* synapse_dbus_service_construct (GType object_type);
static void synapse_dbus_service_name_owner_changed (SynapseDBusService* self,
                                              SynapseFreeDesktopDBus* sender,
                                              const gchar* name,
                                              const gchar* old_owner,
                                              const gchar* new_owner);
gboolean synapse_dbus_service_name_has_owner (SynapseDBusService* self,
                                              const gchar* name);
gboolean synapse_dbus_service_name_is_activatable (SynapseDBusService* self,
                                                   const gchar* name);
gboolean synapse_dbus_service_service_is_available (SynapseDBusService* self,
                                                    const gchar* name);
static void synapse_dbus_service_initialize_data_free (gpointer _data);
static void synapse_dbus_service_initialize_async_ready_wrapper (GObject *source_object,
                                                          GAsyncResult *res,
                                                          void *user_data);
void synapse_dbus_service_initialize (SynapseDBusService* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void synapse_dbus_service_initialize_finish (SynapseDBusService* self,
                                             GAsyncResult* _res_);
static gboolean synapse_dbus_service_initialize_co (SynapseDbusServiceInitializeData* _data_);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
static void synapse_dbus_service_initialize_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void _synapse_dbus_service_name_owner_changed_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* _sender,
                                                                                            const gchar* name,
                                                                                            const gchar* old_owner,
                                                                                            const gchar* new_owner,
                                                                                            gpointer self);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GObject * synapse_dbus_service_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
static void synapse_dbus_service_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_name, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_list_queued_owners = {-1, "ListQueuedOwners", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_queued_owners_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_names_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_names_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_names_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_in[] = {NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_list_activatable_names = {-1, "ListActivatableNames", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_list_activatable_names_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_name_has_owner_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_name, &_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_flags, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_start_service_by_name = {-1, "StartServiceByName", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_start_service_by_name_out), NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_in[] = {&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_name, NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_out[] = {&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_result, NULL};
static const GDBusMethodInfo _synapse_free_desktop_dbus_dbus_method_info_get_name_owner = {-1, "GetNameOwner", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_in), (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_get_name_owner_out), NULL};
static const GDBusMethodInfo * const _synapse_free_desktop_dbus_dbus_method_info[] = {&_synapse_free_desktop_dbus_dbus_method_info_list_queued_owners, &_synapse_free_desktop_dbus_dbus_method_info_list_names, &_synapse_free_desktop_dbus_dbus_method_info_list_activatable_names, &_synapse_free_desktop_dbus_dbus_method_info_name_has_owner, &_synapse_free_desktop_dbus_dbus_method_info_start_service_by_name, &_synapse_free_desktop_dbus_dbus_method_info_get_name_owner, NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s", NULL};
static const GDBusArgInfo _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s", NULL};
static const GDBusArgInfo * const _synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed[] = {&_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_name, &_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_old_owner, &_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _synapse_free_desktop_dbus_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_synapse_free_desktop_dbus_dbus_arg_info_name_owner_changed), NULL};
static const GDBusSignalInfo * const _synapse_free_desktop_dbus_dbus_signal_info[] = {&_synapse_free_desktop_dbus_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _synapse_free_desktop_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _synapse_free_desktop_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_synapse_free_desktop_dbus_dbus_method_info), (GDBusSignalInfo **) (&_synapse_free_desktop_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_synapse_free_desktop_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _synapse_free_desktop_dbus_dbus_interface_vtable = {synapse_free_desktop_dbus_dbus_interface_method_call, synapse_free_desktop_dbus_dbus_interface_get_property, synapse_free_desktop_dbus_dbus_interface_set_property};

void
synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                              const gchar* name,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->list_queued_owners (self, name, _callback_, _user_data_);
}


gchar**
synapse_free_desktop_dbus_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                     GAsyncResult* _res_,
                                                     int* result_length1,
                                                     GError** error)
{
	return SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->list_queued_owners_finish (self, _res_, result_length1, error);
}


void
synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


gchar**
synapse_free_desktop_dbus_list_names_finish (SynapseFreeDesktopDBus* self,
                                             GAsyncResult* _res_,
                                             int* result_length1,
                                             GError** error)
{
	return SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


void
synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->list_activatable_names (self, _callback_, _user_data_);
}


gchar**
synapse_free_desktop_dbus_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                         GAsyncResult* _res_,
                                                         int* result_length1,
                                                         GError** error)
{
	return SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->list_activatable_names_finish (self, _res_, result_length1, error);
}


void
synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                          const gchar* name,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->name_has_owner (self, name, _callback_, _user_data_);
}


gboolean
synapse_free_desktop_dbus_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	return SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->name_has_owner_finish (self, _res_, error);
}


void
synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                 const gchar* name,
                                                 guint32 flags,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->start_service_by_name (self, name, flags, _callback_, _user_data_);
}


guint32
synapse_free_desktop_dbus_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	return SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->start_service_by_name_finish (self, _res_, error);
}


void
synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                          const gchar* name,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->get_name_owner (self, name, _callback_, _user_data_);
}


gchar*
synapse_free_desktop_dbus_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	return SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE (self)->get_name_owner_finish (self, _res_, error);
}


static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void
synapse_free_desktop_dbus_default_init (SynapseFreeDesktopDBusIface * iface)
{
	synapse_free_desktop_dbus_signals[SYNAPSE_FREE_DESKTOP_DBUS_NAME_OWNER_CHANGED_SIGNAL] = g_signal_new ("name-owner-changed", SYNAPSE_TYPE_FREE_DESKTOP_DBUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}


GType
synapse_free_desktop_dbus_get_type (void)
{
	static volatile gsize synapse_free_desktop_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_free_desktop_dbus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseFreeDesktopDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_free_desktop_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType synapse_free_desktop_dbus_type_id;
		synapse_free_desktop_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseFreeDesktopDBus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (synapse_free_desktop_dbus_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) synapse_free_desktop_dbus_proxy_get_type);
		g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_synapse_free_desktop_dbus_dbus_interface_info));
		g_type_set_qdata (synapse_free_desktop_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) synapse_free_desktop_dbus_register_object);
		g_once_init_leave (&synapse_free_desktop_dbus_type_id__volatile, synapse_free_desktop_dbus_type_id);
	}
	return synapse_free_desktop_dbus_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (SynapseFreeDesktopDBusProxy, synapse_free_desktop_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (SYNAPSE_TYPE_FREE_DESKTOP_DBUS, synapse_free_desktop_dbus_proxy_synapse_free_desktop_dbus_interface_init) )
static void
synapse_free_desktop_dbus_proxy_class_init (SynapseFreeDesktopDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = synapse_free_desktop_dbus_proxy_g_signal;
}


static void
_dbus_handle_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* self,
                                                           GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp1_;
	gchar* old_owner = NULL;
	GVariant* _tmp2_;
	gchar* new_owner = NULL;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	new_owner = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


static void
synapse_free_desktop_dbus_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_synapse_free_desktop_dbus_name_owner_changed ((SynapseFreeDesktopDBus*) proxy, parameters);
	}
}


static void
synapse_free_desktop_dbus_proxy_init (SynapseFreeDesktopDBusProxy* self)
{
}


static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}


static void
synapse_free_desktop_dbus_proxy_list_queued_owners_async (SynapseFreeDesktopDBus* self,
                                                          const gchar* name,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListQueuedOwners");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	g_object_unref (_message);
}


static gchar**
synapse_free_desktop_dbus_proxy_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                           GAsyncResult* _res_,
                                                           int* result_length1,
                                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	int _result_length1;
	GVariant* _tmp4_;
	gchar** _tmp5_;
	int _tmp5__length;
	int _tmp5__size;
	int _tmp5__length1;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp4_ = g_variant_iter_next_value (&_reply_iter);
	_tmp5_ = g_new (gchar*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	g_variant_iter_init (&_tmp6_, _tmp4_);
	for (; (_tmp7_ = g_variant_iter_next_value (&_tmp6_)) != NULL; _tmp5__length1++) {
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (gchar*, _tmp5_, _tmp5__size + 1);
		}
		_tmp5_[_tmp5__length++] = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
	}
	_result_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	_result = _tmp5_;
	g_variant_unref (_tmp4_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void
synapse_free_desktop_dbus_proxy_list_names_async (SynapseFreeDesktopDBus* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	g_object_unref (_message);
}


static gchar**
synapse_free_desktop_dbus_proxy_list_names_finish (SynapseFreeDesktopDBus* self,
                                                   GAsyncResult* _res_,
                                                   int* result_length1,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	int _result_length1;
	GVariant* _tmp8_;
	gchar** _tmp9_;
	int _tmp9__length;
	int _tmp9__size;
	int _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp8_ = g_variant_iter_next_value (&_reply_iter);
	_tmp9_ = g_new (gchar*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (gchar*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_dup_string (_tmp11_, NULL);
		g_variant_unref (_tmp11_);
	}
	_result_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	_result = _tmp9_;
	g_variant_unref (_tmp8_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void
synapse_free_desktop_dbus_proxy_list_activatable_names_async (SynapseFreeDesktopDBus* self,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListActivatableNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	g_object_unref (_message);
}


static gchar**
synapse_free_desktop_dbus_proxy_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                               GAsyncResult* _res_,
                                                               int* result_length1,
                                                               GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	int _result_length1;
	GVariant* _tmp12_;
	gchar** _tmp13_;
	int _tmp13__length;
	int _tmp13__size;
	int _tmp13__length1;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp12_ = g_variant_iter_next_value (&_reply_iter);
	_tmp13_ = g_new (gchar*, 5);
	_tmp13__length = 0;
	_tmp13__size = 4;
	_tmp13__length1 = 0;
	g_variant_iter_init (&_tmp14_, _tmp12_);
	for (; (_tmp15_ = g_variant_iter_next_value (&_tmp14_)) != NULL; _tmp13__length1++) {
		if (_tmp13__size == _tmp13__length) {
			_tmp13__size = 2 * _tmp13__size;
			_tmp13_ = g_renew (gchar*, _tmp13_, _tmp13__size + 1);
		}
		_tmp13_[_tmp13__length++] = g_variant_dup_string (_tmp15_, NULL);
		g_variant_unref (_tmp15_);
	}
	_result_length1 = _tmp13__length1;
	_tmp13_[_tmp13__length] = NULL;
	_result = _tmp13_;
	g_variant_unref (_tmp12_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void
synapse_free_desktop_dbus_proxy_name_has_owner_async (SynapseFreeDesktopDBus* self,
                                                      const gchar* name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	g_object_unref (_message);
}


static gboolean
synapse_free_desktop_dbus_proxy_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp18_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		gboolean _tmp16_ = FALSE;
		return _tmp16_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp17_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp17_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp18_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp18_);
	g_variant_unref (_tmp18_);
	g_object_unref (_reply_message);
	return _result;
}


static void
synapse_free_desktop_dbus_proxy_start_service_by_name_async (SynapseFreeDesktopDBus* self,
                                                             const gchar* name,
                                                             guint32 flags,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "StartServiceByName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	g_object_unref (_message);
}


static guint32
synapse_free_desktop_dbus_proxy_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp21_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		guint32 _tmp19_ = 0U;
		return _tmp19_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint32 _tmp20_ = 0U;
		g_object_unref (_reply_message);
		return _tmp20_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp21_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp21_);
	g_variant_unref (_tmp21_);
	g_object_unref (_reply_message);
	return _result;
}


static void
synapse_free_desktop_dbus_proxy_get_name_owner_async (SynapseFreeDesktopDBus* self,
                                                      const gchar* name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "GetNameOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	g_object_unref (_message);
}


static gchar*
synapse_free_desktop_dbus_proxy_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp22_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp22_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	g_object_unref (_reply_message);
	return _result;
}


static void
synapse_free_desktop_dbus_proxy_synapse_free_desktop_dbus_interface_init (SynapseFreeDesktopDBusIface* iface)
{
	iface->list_queued_owners = synapse_free_desktop_dbus_proxy_list_queued_owners_async;
	iface->list_queued_owners_finish = synapse_free_desktop_dbus_proxy_list_queued_owners_finish;
	iface->list_names = synapse_free_desktop_dbus_proxy_list_names_async;
	iface->list_names_finish = synapse_free_desktop_dbus_proxy_list_names_finish;
	iface->list_activatable_names = synapse_free_desktop_dbus_proxy_list_activatable_names_async;
	iface->list_activatable_names_finish = synapse_free_desktop_dbus_proxy_list_activatable_names_finish;
	iface->name_has_owner = synapse_free_desktop_dbus_proxy_name_has_owner_async;
	iface->name_has_owner_finish = synapse_free_desktop_dbus_proxy_name_has_owner_finish;
	iface->start_service_by_name = synapse_free_desktop_dbus_proxy_start_service_by_name_async;
	iface->start_service_by_name_finish = synapse_free_desktop_dbus_proxy_start_service_by_name_finish;
	iface->get_name_owner = synapse_free_desktop_dbus_proxy_get_name_owner_async;
	iface->get_name_owner_finish = synapse_free_desktop_dbus_proxy_get_name_owner_finish;
}


static void
_dbus_synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusListQueuedOwnersReadyData* _ready_data;
	GVariant* _tmp23_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusListQueuedOwnersReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->name = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	synapse_free_desktop_dbus_list_queued_owners (self, _ready_data->name, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_list_queued_owners_ready, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_list_queued_owners_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_)
{
	SynapseFreeDesktopDbusListQueuedOwnersReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp24_;
	GVariantBuilder _tmp25_;
	int _tmp26_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = synapse_free_desktop_dbus_list_queued_owners_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp24_ = result;
	g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("as"));
	for (_tmp26_ = 0; _tmp26_ < result_length1; _tmp26_++) {
		g_variant_builder_add_value (&_tmp25_, g_variant_new_string (*_tmp24_));
		_tmp24_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp25_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->name);
	g_slice_free (SynapseFreeDesktopDbusListQueuedOwnersReadyData, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusListNamesReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusListNamesReadyData);
	_ready_data->_invocation_ = invocation;
	synapse_free_desktop_dbus_list_names (self, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_list_names_ready, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_list_names_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	SynapseFreeDesktopDbusListNamesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp27_;
	GVariantBuilder _tmp28_;
	int _tmp29_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = synapse_free_desktop_dbus_list_names_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp27_ = result;
	g_variant_builder_init (&_tmp28_, G_VARIANT_TYPE ("as"));
	for (_tmp29_ = 0; _tmp29_ < result_length1; _tmp29_++) {
		g_variant_builder_add_value (&_tmp28_, g_variant_new_string (*_tmp27_));
		_tmp27_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp28_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SynapseFreeDesktopDbusListNamesReadyData, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusListActivatableNamesReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusListActivatableNamesReadyData);
	_ready_data->_invocation_ = invocation;
	synapse_free_desktop_dbus_list_activatable_names (self, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_list_activatable_names_ready, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_list_activatable_names_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_)
{
	SynapseFreeDesktopDbusListActivatableNamesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp30_;
	GVariantBuilder _tmp31_;
	int _tmp32_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = synapse_free_desktop_dbus_list_activatable_names_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp30_ = result;
	g_variant_builder_init (&_tmp31_, G_VARIANT_TYPE ("as"));
	for (_tmp32_ = 0; _tmp32_ < result_length1; _tmp32_++) {
		g_variant_builder_add_value (&_tmp31_, g_variant_new_string (*_tmp30_));
		_tmp30_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp31_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SynapseFreeDesktopDbusListActivatableNamesReadyData, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusNameHasOwnerReadyData* _ready_data;
	GVariant* _tmp33_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusNameHasOwnerReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->name = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	synapse_free_desktop_dbus_name_has_owner (self, _ready_data->name, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_name_has_owner_ready, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_name_has_owner_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	SynapseFreeDesktopDbusNameHasOwnerReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = synapse_free_desktop_dbus_name_has_owner_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->name);
	g_slice_free (SynapseFreeDesktopDbusNameHasOwnerReadyData, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusStartServiceByNameReadyData* _ready_data;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusStartServiceByNameReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->name = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flags = g_variant_get_uint32 (_tmp35_);
	g_variant_unref (_tmp35_);
	synapse_free_desktop_dbus_start_service_by_name (self, _ready_data->name, _ready_data->flags, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_start_service_by_name_ready, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_start_service_by_name_ready (GObject * source_object,
                                                             GAsyncResult * _res_,
                                                             gpointer _user_data_)
{
	SynapseFreeDesktopDbusStartServiceByNameReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = synapse_free_desktop_dbus_start_service_by_name_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->name);
	g_slice_free (SynapseFreeDesktopDbusStartServiceByNameReadyData, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SynapseFreeDesktopDbusGetNameOwnerReadyData* _ready_data;
	GVariant* _tmp36_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SynapseFreeDesktopDbusGetNameOwnerReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp36_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->name = g_variant_dup_string (_tmp36_, NULL);
	g_variant_unref (_tmp36_);
	synapse_free_desktop_dbus_get_name_owner (self, _ready_data->name, (GAsyncReadyCallback) _dbus_synapse_free_desktop_dbus_get_name_owner_ready, _ready_data);
}


static void
_dbus_synapse_free_desktop_dbus_get_name_owner_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	SynapseFreeDesktopDbusGetNameOwnerReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = synapse_free_desktop_dbus_get_name_owner_finish ((SynapseFreeDesktopDBus*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->name);
	g_slice_free (SynapseFreeDesktopDbusGetNameOwnerReadyData, _ready_data);
}


static void
synapse_free_desktop_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListQueuedOwners") == 0) {
		_dbus_synapse_free_desktop_dbus_list_queued_owners (object, parameters, invocation);
	} else if (strcmp (method_name, "ListNames") == 0) {
		_dbus_synapse_free_desktop_dbus_list_names (object, parameters, invocation);
	} else if (strcmp (method_name, "ListActivatableNames") == 0) {
		_dbus_synapse_free_desktop_dbus_list_activatable_names (object, parameters, invocation);
	} else if (strcmp (method_name, "NameHasOwner") == 0) {
		_dbus_synapse_free_desktop_dbus_name_has_owner (object, parameters, invocation);
	} else if (strcmp (method_name, "StartServiceByName") == 0) {
		_dbus_synapse_free_desktop_dbus_start_service_by_name (object, parameters, invocation);
	} else if (strcmp (method_name, "GetNameOwner") == 0) {
		_dbus_synapse_free_desktop_dbus_get_name_owner (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant*
synapse_free_desktop_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean
synapse_free_desktop_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void
_dbus_synapse_free_desktop_dbus_name_owner_changed (GObject* _sender,
                                                    const gchar* name,
                                                    const gchar* old_owner,
                                                    const gchar* new_owner,
                                                    gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


guint
synapse_free_desktop_dbus_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_synapse_free_desktop_dbus_dbus_interface_info), &_synapse_free_desktop_dbus_dbus_interface_vtable, data, _synapse_free_desktop_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_synapse_free_desktop_dbus_name_owner_changed, data);
	return result;
}


static void
_synapse_free_desktop_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_synapse_free_desktop_dbus_name_owner_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static inline gpointer
synapse_dbus_service_get_instance_private (SynapseDBusService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDBusService_private_offset);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


SynapseDBusService*
synapse_dbus_service_get_default (void)
{
	SynapseDBusService* result = NULL;
	SynapseDBusService* _tmp0_ = NULL;
	SynapseDBusService* _tmp1_;
	SynapseDBusService* _tmp2_;
	SynapseDBusService* _tmp4_;
	_tmp1_ = synapse_dbus_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseDBusService* _tmp3_;
		_tmp3_ = synapse_dbus_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static SynapseDBusService*
synapse_dbus_service_construct (GType object_type)
{
	SynapseDBusService * self = NULL;
	self = (SynapseDBusService*) g_object_new (object_type, NULL);
	return self;
}


static SynapseDBusService*
synapse_dbus_service_new (void)
{
	return synapse_dbus_service_construct (SYNAPSE_TYPE_DBUS_SERVICE);
}


static void
synapse_dbus_service_name_owner_changed (SynapseDBusService* self,
                                         SynapseFreeDesktopDBus* sender,
                                         const gchar* name,
                                         const gchar* old_owner,
                                         const gchar* new_owner)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (old_owner != NULL);
	g_return_if_fail (new_owner != NULL);
	if (g_str_has_prefix (name, ":")) {
		return;
	}
	if (g_strcmp0 (old_owner, "") == 0) {
		GeeSet* _tmp0_;
		_tmp0_ = self->priv->owned_names;
		gee_collection_add ((GeeCollection*) _tmp0_, name);
		g_signal_emit (self, synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL], 0, name, TRUE);
	} else {
		if (g_strcmp0 (new_owner, "") == 0) {
			GeeSet* _tmp1_;
			_tmp1_ = self->priv->owned_names;
			gee_collection_remove ((GeeCollection*) _tmp1_, name);
			g_signal_emit (self, synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL], 0, name, FALSE);
		}
	}
}


gboolean
synapse_dbus_service_name_has_owner (SynapseDBusService* self,
                                     const gchar* name)
{
	gboolean result = FALSE;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->owned_names;
	result = gee_collection_contains ((GeeCollection*) _tmp0_, name);
	return result;
}


gboolean
synapse_dbus_service_name_is_activatable (SynapseDBusService* self,
                                          const gchar* name)
{
	gboolean result = FALSE;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->activatable_names;
	result = gee_collection_contains ((GeeCollection*) _tmp0_, name);
	return result;
}


gboolean
synapse_dbus_service_service_is_available (SynapseDBusService* self,
                                           const gchar* name)
{
	gboolean result = FALSE;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->system_activatable_names;
	result = gee_collection_contains ((GeeCollection*) _tmp0_, name);
	return result;
}


static void
synapse_dbus_service_initialize_data_free (gpointer _data)
{
	SynapseDbusServiceInitializeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDbusServiceInitializeData, _data_);
}


static void
synapse_dbus_service_initialize_async_ready_wrapper (GObject *source_object,
                                                     GAsyncResult *res,
                                                     void *user_data)
{
	SynapseDbusServiceInitializeData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
synapse_dbus_service_initialize (SynapseDBusService* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapseDbusServiceInitializeData* _data_;
	SynapseDBusService* _tmp0_;
	_data_ = g_slice_new0 (SynapseDbusServiceInitializeData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, synapse_dbus_service_initialize_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, synapse_dbus_service_initialize_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_dbus_service_initialize_co (_data_);
}


void
synapse_dbus_service_initialize_finish (SynapseDBusService* self,
                                        GAsyncResult* _res_)
{
	SynapseDbusServiceInitializeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
synapse_dbus_service_initialize_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SynapseDbusServiceInitializeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	synapse_dbus_service_initialize_co (_data_);
}


static void
_synapse_dbus_service_name_owner_changed_synapse_free_desktop_dbus_name_owner_changed (SynapseFreeDesktopDBus* _sender,
                                                                                       const gchar* name,
                                                                                       const gchar* old_owner,
                                                                                       const gchar* new_owner,
                                                                                       gpointer self)
{
	synapse_dbus_service_name_owner_changed ((SynapseDBusService*) self, _sender, name, old_owner, new_owner);
}


static gboolean
synapse_dbus_service_initialize_co (SynapseDbusServiceInitializeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->init_once;
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->init_once;
	_data_->_state_ = 1;
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_dbus_service_initialize_ready, _data_);
	return FALSE;
	_state_1:
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
	_data_->_tmp2_ = _data_->is_locked;
	if (!_data_->_tmp2_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->names_length1 = 0;
	_data_->_names_size_ = 0;
	{
		_data_->_tmp4_ = (SynapseFreeDesktopDBus*) g_initable_new (SYNAPSE_TYPE_FREE_DESKTOP_DBUS_PROXY, NULL, &_data_->_inner_error_, "g-flags", 0, "g-name", SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH, "g-interface-name", "org.freedesktop.DBus", "g-interface-info", g_type_get_qdata (SYNAPSE_TYPE_FREE_DESKTOP_DBUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_data_->_tmp3_ = (SynapseFreeDesktopDBus*) _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->self->priv->proxy);
		_data_->self->priv->proxy = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->self->priv->proxy;
		g_signal_connect_object (_data_->_tmp6_, "name-owner-changed", (GCallback) _synapse_dbus_service_name_owner_changed_synapse_free_desktop_dbus_name_owner_changed, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->proxy;
		_data_->_tmp9_ = 0;
		_data_->_state_ = 2;
		synapse_free_desktop_dbus_list_names (_data_->_tmp8_, synapse_dbus_service_initialize_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = synapse_free_desktop_dbus_list_names_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp10_;
		_data_->_tmp7__length1 = _data_->_tmp9_;
		_data_->__tmp7__size_ = _data_->_tmp7__length1;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->_tmp3_);
			goto __catch27_g_error;
		}
		_data_->_tmp11_ = _data_->_tmp7_;
		_data_->_tmp11__length1 = _data_->_tmp7__length1;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7__length1 = 0;
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
		_data_->names = _data_->_tmp11_;
		_data_->names_length1 = _data_->_tmp11__length1;
		_data_->_names_size_ = _data_->names_length1;
		_data_->_tmp12_ = _data_->names;
		_data_->_tmp12__length1 = _data_->names_length1;
		{
			_data_->name_collection_length1 = 0;
			_data_->_name_collection_size_ = 0;
			_data_->name_collection = _data_->_tmp12_;
			_data_->name_collection_length1 = _data_->_tmp12__length1;
			for (_data_->name_it = 0; _data_->name_it < _data_->_tmp12__length1; _data_->name_it = _data_->name_it + 1) {
				_data_->name = _data_->name_collection[_data_->name_it];
				{
					_data_->_tmp13_ = _data_->name;
					if (g_str_has_prefix (_data_->_tmp13_, ":")) {
						continue;
					}
					_data_->_tmp14_ = _data_->self->priv->owned_names;
					_data_->_tmp15_ = _data_->name;
					gee_collection_add ((GeeCollection*) _data_->_tmp14_, _data_->_tmp15_);
				}
			}
		}
		_data_->_tmp17_ = _data_->self->priv->proxy;
		_data_->_tmp18_ = 0;
		_data_->_state_ = 3;
		synapse_free_desktop_dbus_list_activatable_names (_data_->_tmp17_, synapse_dbus_service_initialize_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp19_ = synapse_free_desktop_dbus_list_activatable_names_finish (_data_->_tmp17_, _data_->_res_, &_data_->_tmp18_, &_data_->_inner_error_);
		_data_->_tmp16_ = _data_->_tmp19_;
		_data_->_tmp16__length1 = _data_->_tmp18_;
		_data_->__tmp16__size_ = _data_->_tmp16__length1;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_data_->_tmp7_ = (_vala_array_free (_data_->_tmp7_, _data_->_tmp7__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp3_);
			goto __catch27_g_error;
		}
		_data_->_tmp20_ = _data_->_tmp16_;
		_data_->_tmp20__length1 = _data_->_tmp16__length1;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16__length1 = 0;
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
		_data_->names = _data_->_tmp20_;
		_data_->names_length1 = _data_->_tmp20__length1;
		_data_->_names_size_ = _data_->names_length1;
		_data_->_tmp21_ = _data_->names;
		_data_->_tmp21__length1 = _data_->names_length1;
		{
			_data_->session_act_collection_length1 = 0;
			_data_->_session_act_collection_size_ = 0;
			_data_->session_act_collection = _data_->_tmp21_;
			_data_->session_act_collection_length1 = _data_->_tmp21__length1;
			for (_data_->session_act_it = 0; _data_->session_act_it < _data_->_tmp21__length1; _data_->session_act_it = _data_->session_act_it + 1) {
				_data_->session_act = _data_->session_act_collection[_data_->session_act_it];
				{
					_data_->_tmp22_ = _data_->self->priv->activatable_names;
					_data_->_tmp23_ = _data_->session_act;
					gee_collection_add ((GeeCollection*) _data_->_tmp22_, _data_->_tmp23_);
				}
			}
		}
		_data_->_tmp16_ = (_vala_array_free (_data_->_tmp16_, _data_->_tmp16__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp7_ = (_vala_array_free (_data_->_tmp7_, _data_->_tmp7__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally27;
	__catch27_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp24_ = _data_->err;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("dbus-service.vala:142: %s", _data_->_tmp25_);
		_g_error_free0 (_data_->err);
	}
	__finally27:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp26_ = (SynapseFreeDesktopDBus*) g_initable_new (SYNAPSE_TYPE_FREE_DESKTOP_DBUS_PROXY, NULL, &_data_->_inner_error_, "g-flags", 0, "g-name", SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH, "g-interface-name", "org.freedesktop.DBus", "g-interface-info", g_type_get_qdata (SYNAPSE_TYPE_FREE_DESKTOP_DBUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_data_->sys_proxy = (SynapseFreeDesktopDBus*) _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		_data_->_tmp28_ = _data_->sys_proxy;
		_data_->_tmp29_ = 0;
		_data_->_state_ = 4;
		synapse_free_desktop_dbus_list_activatable_names (_data_->_tmp28_, synapse_dbus_service_initialize_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp30_ = synapse_free_desktop_dbus_list_activatable_names_finish (_data_->_tmp28_, _data_->_res_, &_data_->_tmp29_, &_data_->_inner_error_);
		_data_->_tmp27_ = _data_->_tmp30_;
		_data_->_tmp27__length1 = _data_->_tmp29_;
		_data_->__tmp27__size_ = _data_->_tmp27__length1;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->sys_proxy);
			goto __catch28_g_error;
		}
		_data_->_tmp31_ = _data_->_tmp27_;
		_data_->_tmp31__length1 = _data_->_tmp27__length1;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27__length1 = 0;
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
		_data_->names = _data_->_tmp31_;
		_data_->names_length1 = _data_->_tmp31__length1;
		_data_->_names_size_ = _data_->names_length1;
		_data_->_tmp32_ = _data_->names;
		_data_->_tmp32__length1 = _data_->names_length1;
		{
			_data_->system_act_collection_length1 = 0;
			_data_->_system_act_collection_size_ = 0;
			_data_->system_act_collection = _data_->_tmp32_;
			_data_->system_act_collection_length1 = _data_->_tmp32__length1;
			for (_data_->system_act_it = 0; _data_->system_act_it < _data_->_tmp32__length1; _data_->system_act_it = _data_->system_act_it + 1) {
				_data_->system_act = _data_->system_act_collection[_data_->system_act_it];
				{
					_data_->_tmp33_ = _data_->self->priv->system_activatable_names;
					_data_->_tmp34_ = _data_->system_act;
					gee_collection_add ((GeeCollection*) _data_->_tmp33_, _data_->_tmp34_);
				}
			}
		}
		_data_->_tmp27_ = (_vala_array_free (_data_->_tmp27_, _data_->_tmp27__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->sys_proxy);
	}
	goto __finally28;
	__catch28_g_error:
	{
		_data_->sys_err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp35_ = _data_->sys_err;
		_data_->_tmp36_ = _data_->_tmp35_->message;
		g_warning ("dbus-service.vala:160: %s", _data_->_tmp36_);
		_g_error_free0 (_data_->sys_err);
	}
	__finally28:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp37_ = _data_->self->priv->init_once;
	synapse_utils_async_once_leave (_data_->_tmp37_, (gpointer) ((gintptr) TRUE));
	_data_->names = (_vala_array_free (_data_->names, _data_->names_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static GObject *
synapse_dbus_service_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDBusService * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	SynapseUtilsAsyncOnce* _tmp3_;
	parent_class = G_OBJECT_CLASS (synapse_dbus_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService);
	synapse_dbus_service_instance = self;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->owned_names);
	self->priv->owned_names = (GeeSet*) _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->activatable_names);
	self->priv->activatable_names = (GeeSet*) _tmp1_;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->system_activatable_names);
	self->priv->system_activatable_names = (GeeSet*) _tmp2_;
	_tmp3_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
	_synapse_utils_async_once_unref0 (self->priv->init_once);
	self->priv->init_once = _tmp3_;
	synapse_dbus_service_initialize (self, NULL, NULL);
	return obj;
}


static void
synapse_dbus_service_class_init (SynapseDBusServiceClass * klass)
{
	synapse_dbus_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDBusService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_dbus_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_dbus_service_finalize;
	synapse_dbus_service_signals[SYNAPSE_DBUS_SERVICE_OWNER_CHANGED_SIGNAL] = g_signal_new ("owner-changed", SYNAPSE_TYPE_DBUS_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
}


static void
synapse_dbus_service_instance_init (SynapseDBusService * self)
{
	self->priv = synapse_dbus_service_get_instance_private (self);
}


static void
synapse_dbus_service_finalize (GObject * obj)
{
	SynapseDBusService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService);
	synapse_dbus_service_instance = NULL;
	_g_object_unref0 (self->priv->proxy);
	_g_object_unref0 (self->priv->owned_names);
	_g_object_unref0 (self->priv->activatable_names);
	_g_object_unref0 (self->priv->system_activatable_names);
	_synapse_utils_async_once_unref0 (self->priv->init_once);
	G_OBJECT_CLASS (synapse_dbus_service_parent_class)->finalize (obj);
}


GType
synapse_dbus_service_get_type (void)
{
	static volatile gsize synapse_dbus_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_dbus_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseDBusServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_dbus_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDBusService), 0, (GInstanceInitFunc) synapse_dbus_service_instance_init, NULL };
		GType synapse_dbus_service_type_id;
		synapse_dbus_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDBusService", &g_define_type_info, 0);
		SynapseDBusService_private_offset = g_type_add_instance_private (synapse_dbus_service_type_id, sizeof (SynapseDBusServicePrivate));
		g_once_init_leave (&synapse_dbus_service_type_id__volatile, synapse_dbus_service_type_id);
	}
	return synapse_dbus_service_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



