/* common-actions.c generated by valac 0.42.5, the Vala compiler
 * generated from common-actions.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>


#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_BASE_ACTION (synapse_base_action_get_type ())
#define SYNAPSE_BASE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction))
#define SYNAPSE_BASE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionClass))
#define SYNAPSE_IS_BASE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_BASE_ACTION))
#define SYNAPSE_IS_BASE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_BASE_ACTION))
#define SYNAPSE_BASE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_BASE_ACTION, SynapseBaseActionClass))

typedef struct _SynapseBaseAction SynapseBaseAction;
typedef struct _SynapseBaseActionClass SynapseBaseActionClass;
typedef struct _SynapseBaseActionPrivate SynapseBaseActionPrivate;
enum  {
	SYNAPSE_BASE_ACTION_0_PROPERTY,
	SYNAPSE_BASE_ACTION_TITLE_PROPERTY,
	SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY,
	SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY,
	SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY,
	SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY,
	SYNAPSE_BASE_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_base_action_properties[SYNAPSE_BASE_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;


#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER (synapse_common_actions_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunner))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))

typedef struct _SynapseCommonActionsRunner SynapseCommonActionsRunner;
typedef struct _SynapseCommonActionsRunnerClass SynapseCommonActionsRunnerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER (synapse_common_actions_terminal_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunner))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))

typedef struct _SynapseCommonActionsTerminalRunner SynapseCommonActionsTerminalRunner;
typedef struct _SynapseCommonActionsTerminalRunnerClass SynapseCommonActionsTerminalRunnerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPENER (synapse_common_actions_opener_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener))
#define SYNAPSE_COMMON_ACTIONS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))

typedef struct _SynapseCommonActionsOpener SynapseCommonActionsOpener;
typedef struct _SynapseCommonActionsOpenerClass SynapseCommonActionsOpenerClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER (synapse_common_actions_open_folder_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolder))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))

typedef struct _SynapseCommonActionsOpenFolder SynapseCommonActionsOpenFolder;
typedef struct _SynapseCommonActionsOpenFolderClass SynapseCommonActionsOpenFolderClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY (synapse_common_actions_clipboard_copy_get_type ())
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopy))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))

typedef struct _SynapseCommonActionsClipboardCopy SynapseCommonActionsClipboardCopy;
typedef struct _SynapseCommonActionsClipboardCopyClass SynapseCommonActionsClipboardCopyClass;
typedef struct _SynapseCommonActionsRunnerPrivate SynapseCommonActionsRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_runner_properties[SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES];
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;


#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
typedef struct _SynapseCommonActionsTerminalRunnerPrivate SynapseCommonActionsTerminalRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_terminal_runner_properties[SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES];
typedef struct _SynapseCommonActionsOpenerPrivate SynapseCommonActionsOpenerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPENER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_opener_properties[SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
typedef struct _SynapseCommonActionsOpenFolderPrivate SynapseCommonActionsOpenFolderPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_open_folder_properties[SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES];
typedef struct _SynapseCommonActionsClipboardCopyPrivate SynapseCommonActionsClipboardCopyPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_clipboard_copy_properties[SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES];

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchIface))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchIface SynapseTextMatchIface;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;


#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseBaseAction {
	GObject parent_instance;
	SynapseBaseActionPrivate * priv;
};

struct _SynapseBaseActionClass {
	GObjectClass parent_class;
	gboolean (*valid_for_match) (SynapseBaseAction* self, SynapseMatch* match);
	gint (*get_relevancy_for_match) (SynapseBaseAction* self, SynapseMatch* match);
	void (*do_execute) (SynapseBaseAction* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseBaseAction* self);
	SynapseQueryFlags (*target_flags) (SynapseBaseAction* self);
};

struct _SynapseBaseActionPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gint _default_relevancy;
	gboolean _notify_match;
};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseCommonActions {
	GObject parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	GObjectClass parent_class;
};

struct _SynapseCommonActionsPrivate {
	gboolean _enabled;
	GeeList* actions;
};

struct _SynapseCommonActionsRunner {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsRunnerPrivate * priv;
};

struct _SynapseCommonActionsRunnerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseCommonActionsTerminalRunner {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsTerminalRunnerPrivate * priv;
};

struct _SynapseCommonActionsTerminalRunnerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsOpener {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsOpenerPrivate * priv;
};

struct _SynapseCommonActionsOpenerClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsOpenerPrivate {
	GRegex* web_uri;
	GRegex* file_path;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseCommonActionsOpenFolder {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsOpenFolderPrivate * priv;
};

struct _SynapseCommonActionsOpenFolderClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseCommonActionsClipboardCopy {
	SynapseBaseAction parent_instance;
	SynapseCommonActionsClipboardCopyPrivate * priv;
};

struct _SynapseCommonActionsClipboardCopyClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseTextMatchIface {
	GTypeInterface parent_iface;
	gchar* (*get_text) (SynapseTextMatch* self);
	SynapseTextOrigin (*get_text_origin) (SynapseTextMatch* self);
	void (*set_text_origin) (SynapseTextMatch* self, SynapseTextOrigin value);
};


static gint SynapseBaseAction_private_offset;
static gpointer synapse_base_action_parent_class = NULL;
static SynapseMatchIface * synapse_base_action_synapse_match_parent_iface = NULL;
static gint SynapseCommonActions_private_offset;
static gpointer synapse_common_actions_parent_class = NULL;
static gpointer synapse_common_actions_runner_parent_class = NULL;
static gpointer synapse_common_actions_terminal_runner_parent_class = NULL;
static gint SynapseCommonActionsOpener_private_offset;
static gpointer synapse_common_actions_opener_parent_class = NULL;
static gpointer synapse_common_actions_open_folder_parent_class = NULL;
static gpointer synapse_common_actions_clipboard_copy_parent_class = NULL;
static SynapseActivatableIface * synapse_common_actions_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_common_actions_synapse_action_provider_parent_iface = NULL;

GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_base_action_get_type (void) G_GNUC_CONST;
gboolean synapse_base_action_valid_for_match (SynapseBaseAction* self,
                                              SynapseMatch* match);
static gboolean synapse_base_action_real_valid_for_match (SynapseBaseAction* self,
                                                   SynapseMatch* match);
gint synapse_base_action_get_relevancy_for_match (SynapseBaseAction* self,
                                                  SynapseMatch* match);
static gint synapse_base_action_real_get_relevancy_for_match (SynapseBaseAction* self,
                                                       SynapseMatch* match);
gint synapse_base_action_get_default_relevancy (SynapseBaseAction* self);
void synapse_base_action_do_execute (SynapseBaseAction* self,
                                     SynapseMatch* source,
                                     SynapseMatch* target);
static void synapse_base_action_real_do_execute (SynapseBaseAction* self,
                                          SynapseMatch* source,
                                          SynapseMatch* target);
static void synapse_base_action_real_execute_with_target (SynapseMatch* base,
                                                   SynapseMatch* source,
                                                   SynapseMatch* target);
gboolean synapse_base_action_get_notify_match (SynapseBaseAction* self);
gboolean synapse_base_action_needs_target (SynapseBaseAction* self);
static gboolean synapse_base_action_real_needs_target (SynapseBaseAction* self);
SynapseQueryFlags synapse_base_action_target_flags (SynapseBaseAction* self);
static SynapseQueryFlags synapse_base_action_real_target_flags (SynapseBaseAction* self);
SynapseBaseAction* synapse_base_action_construct (GType object_type);
void synapse_base_action_set_default_relevancy (SynapseBaseAction* self,
                                                gint value);
void synapse_base_action_set_notify_match (SynapseBaseAction* self,
                                           gboolean value);
static void synapse_base_action_finalize (GObject * obj);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_description (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
static void _vala_synapse_base_action_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
static void _vala_synapse_base_action_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
static void synapse_common_actions_real_activate (SynapseActivatable* base);
static void synapse_common_actions_real_deactivate (SynapseActivatable* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
void synapse_common_actions_open_uri (const gchar* uri);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void synapse_utils_logger_warning (GObject* obj,
                                   const gchar* format,
                                   ...);
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
static GObject * synapse_common_actions_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void);
static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type);
static GType synapse_common_actions_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void);
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type);
static GType synapse_common_actions_terminal_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void);
static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type);
static GType synapse_common_actions_opener_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void);
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type);
static GType synapse_common_actions_open_folder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_new (void);
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_construct (GType object_type);
static GType synapse_common_actions_clipboard_copy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void synapse_common_actions_runner_real_do_execute (SynapseBaseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self,
                                                     GAppInfo* app_info);
void synapse_match_execute (SynapseMatch* self,
                            SynapseMatch* match);
static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseBaseAction* base,
                                                             SynapseMatch* match);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
static void synapse_common_actions_terminal_runner_real_do_execute (SynapseBaseAction* base,
                                                             SynapseMatch* match,
                                                             SynapseMatch* target);
static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseBaseAction* base,
                                                                      SynapseMatch* match);
static void synapse_common_actions_opener_real_do_execute (SynapseBaseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseBaseAction* base,
                                                             SynapseMatch* match);
static GObject * synapse_common_actions_opener_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void synapse_common_actions_opener_finalize (GObject * obj);
static void synapse_common_actions_open_folder_real_do_execute (SynapseBaseAction* base,
                                                         SynapseMatch* match,
                                                         SynapseMatch* target);
static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseBaseAction* base,
                                                                  SynapseMatch* match);
static void synapse_common_actions_clipboard_copy_real_do_execute (SynapseBaseAction* base,
                                                            SynapseMatch* match,
                                                            SynapseMatch* target);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
static gboolean synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseBaseAction* base,
                                                                     SynapseMatch* match);
static gint synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseBaseAction* base,
                                                                         SynapseMatch* match);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
static void synapse_common_actions_finalize (GObject * obj);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
static void _vala_synapse_common_actions_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
static void _vala_synapse_common_actions_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);


static inline gpointer
synapse_base_action_get_instance_private (SynapseBaseAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseBaseAction_private_offset);
}


static gboolean
synapse_base_action_real_valid_for_match (SynapseBaseAction* self,
                                          SynapseMatch* match)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `synapse_base_action_valid_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean
synapse_base_action_valid_for_match (SynapseBaseAction* self,
                                     SynapseMatch* match)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->valid_for_match (self, match);
}


static gint
synapse_base_action_real_get_relevancy_for_match (SynapseBaseAction* self,
                                                  SynapseMatch* match)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (match != NULL, 0);
	_tmp0_ = self->priv->_default_relevancy;
	result = _tmp0_;
	return result;
}


gint
synapse_base_action_get_relevancy_for_match (SynapseBaseAction* self,
                                             SynapseMatch* match)
{
	g_return_val_if_fail (self != NULL, 0);
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->get_relevancy_for_match (self, match);
}


static void
synapse_base_action_real_do_execute (SynapseBaseAction* self,
                                     SynapseMatch* source,
                                     SynapseMatch* target)
{
	g_critical ("Type `%s' does not implement abstract method `synapse_base_action_do_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void
synapse_base_action_do_execute (SynapseBaseAction* self,
                                SynapseMatch* source,
                                SynapseMatch* target)
{
	g_return_if_fail (self != NULL);
	SYNAPSE_BASE_ACTION_GET_CLASS (self)->do_execute (self, source, target);
}


static void
synapse_base_action_real_execute_with_target (SynapseMatch* base,
                                              SynapseMatch* source,
                                              SynapseMatch* target)
{
	SynapseBaseAction * self;
	gboolean _tmp0_;
	self = (SynapseBaseAction*) base;
	synapse_base_action_do_execute (self, source, target);
	_tmp0_ = self->priv->_notify_match;
	if (_tmp0_) {
		g_signal_emit_by_name (source, "executed");
	}
}


static gboolean
synapse_base_action_real_needs_target (SynapseBaseAction* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
synapse_base_action_needs_target (SynapseBaseAction* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->needs_target (self);
}


static SynapseQueryFlags
synapse_base_action_real_target_flags (SynapseBaseAction* self)
{
	SynapseQueryFlags result = 0;
	result = SYNAPSE_QUERY_FLAGS_ALL;
	return result;
}


SynapseQueryFlags
synapse_base_action_target_flags (SynapseBaseAction* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return SYNAPSE_BASE_ACTION_GET_CLASS (self)->target_flags (self);
}


SynapseBaseAction*
synapse_base_action_construct (GType object_type)
{
	SynapseBaseAction * self = NULL;
	self = (SynapseBaseAction*) g_object_new (object_type, NULL);
	return self;
}


static const gchar*
synapse_base_action_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
	self = (SynapseBaseAction*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void
synapse_base_action_real_set_title (SynapseMatch* base,
                                    const gchar* value)
{
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	if (g_strcmp0 (value, synapse_base_action_real_get_title (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_TITLE_PROPERTY]);
	}
}


static const gchar*
synapse_base_action_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
	self = (SynapseBaseAction*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
synapse_base_action_real_set_description (SynapseMatch* base,
                                          const gchar* value)
{
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	if (g_strcmp0 (value, synapse_base_action_real_get_description (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY]);
	}
}


static const gchar*
synapse_base_action_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
	self = (SynapseBaseAction*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


static void
synapse_base_action_real_set_icon_name (SynapseMatch* base,
                                        const gchar* value)
{
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	if (g_strcmp0 (value, synapse_base_action_real_get_icon_name (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY]);
	}
}


static gboolean
synapse_base_action_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseBaseAction* self;
	gboolean _tmp0_;
	self = (SynapseBaseAction*) base;
	_tmp0_ = self->priv->_has_thumbnail;
	result = _tmp0_;
	return result;
}


static void
synapse_base_action_real_set_has_thumbnail (SynapseMatch* base,
                                            gboolean value)
{
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	if (synapse_base_action_real_get_has_thumbnail (base) != value) {
		self->priv->_has_thumbnail = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY]);
	}
}


static const gchar*
synapse_base_action_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseBaseAction* self;
	const gchar* _tmp0_;
	self = (SynapseBaseAction*) base;
	_tmp0_ = self->priv->_thumbnail_path;
	result = _tmp0_;
	return result;
}


static void
synapse_base_action_real_set_thumbnail_path (SynapseMatch* base,
                                             const gchar* value)
{
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	if (g_strcmp0 (value, synapse_base_action_real_get_thumbnail_path (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY]);
	}
}


static SynapseMatchType
synapse_base_action_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseBaseAction* self;
	SynapseMatchType _tmp0_;
	self = (SynapseBaseAction*) base;
	_tmp0_ = self->priv->_match_type;
	result = _tmp0_;
	return result;
}


static void
synapse_base_action_real_set_match_type (SynapseMatch* base,
                                         SynapseMatchType value)
{
	SynapseBaseAction* self;
	self = (SynapseBaseAction*) base;
	if (synapse_base_action_real_get_match_type (base) != value) {
		self->priv->_match_type = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY]);
	}
}


gint
synapse_base_action_get_default_relevancy (SynapseBaseAction* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_default_relevancy;
	result = _tmp0_;
	return result;
}


void
synapse_base_action_set_default_relevancy (SynapseBaseAction* self,
                                           gint value)
{
	g_return_if_fail (self != NULL);
	if (synapse_base_action_get_default_relevancy (self) != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY]);
	}
}


gboolean
synapse_base_action_get_notify_match (SynapseBaseAction* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_notify_match;
	result = _tmp0_;
	return result;
}


void
synapse_base_action_set_notify_match (SynapseBaseAction* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	if (synapse_base_action_get_notify_match (self) != value) {
		self->priv->_notify_match = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_base_action_properties[SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY]);
	}
}


static void
synapse_base_action_class_init (SynapseBaseActionClass * klass)
{
	synapse_base_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseBaseAction_private_offset);
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_base_action_real_valid_for_match;
	((SynapseBaseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseBaseAction*, SynapseMatch*)) synapse_base_action_real_get_relevancy_for_match;
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_base_action_real_do_execute;
	((SynapseBaseActionClass *) klass)->needs_target = (gboolean (*) (SynapseBaseAction*)) synapse_base_action_real_needs_target;
	((SynapseBaseActionClass *) klass)->target_flags = (SynapseQueryFlags (*) (SynapseBaseAction*)) synapse_base_action_real_target_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_base_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_base_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_base_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_TITLE_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY, synapse_base_action_properties[SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY] = g_param_spec_boolean ("notify-match", "notify-match", "notify-match", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_base_action_synapse_match_interface_init (SynapseMatchIface * iface)
{
	synapse_base_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->execute_with_target = (void (*) (SynapseMatch*, SynapseMatch*, SynapseMatch*)) synapse_base_action_real_execute_with_target;
	iface->needs_target = (gboolean (*) (SynapseMatch*)) synapse_base_action_needs_target;
	iface->target_flags = (SynapseQueryFlags (*) (SynapseMatch*)) synapse_base_action_target_flags;
	iface->get_title = synapse_base_action_real_get_title;
	iface->set_title = synapse_base_action_real_set_title;
	iface->get_description = synapse_base_action_real_get_description;
	iface->set_description = synapse_base_action_real_set_description;
	iface->get_icon_name = synapse_base_action_real_get_icon_name;
	iface->set_icon_name = synapse_base_action_real_set_icon_name;
	iface->get_has_thumbnail = synapse_base_action_real_get_has_thumbnail;
	iface->set_has_thumbnail = synapse_base_action_real_set_has_thumbnail;
	iface->get_thumbnail_path = synapse_base_action_real_get_thumbnail_path;
	iface->set_thumbnail_path = synapse_base_action_real_set_thumbnail_path;
	iface->get_match_type = synapse_base_action_real_get_match_type;
	iface->set_match_type = synapse_base_action_real_set_match_type;
}


static void
synapse_base_action_instance_init (SynapseBaseAction * self)
{
	self->priv = synapse_base_action_get_instance_private (self);
	self->priv->_notify_match = TRUE;
}


static void
synapse_base_action_finalize (GObject * obj)
{
	SynapseBaseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	G_OBJECT_CLASS (synapse_base_action_parent_class)->finalize (obj);
}


GType
synapse_base_action_get_type (void)
{
	static volatile gsize synapse_base_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_base_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseBaseActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_base_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseBaseAction), 0, (GInstanceInitFunc) synapse_base_action_instance_init, NULL };
		static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_base_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_base_action_type_id;
		synapse_base_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseBaseAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (synapse_base_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
		SynapseBaseAction_private_offset = g_type_add_instance_private (synapse_base_action_type_id, sizeof (SynapseBaseActionPrivate));
		g_once_init_leave (&synapse_base_action_type_id__volatile, synapse_base_action_type_id);
	}
	return synapse_base_action_type_id__volatile;
}


static void
_vala_synapse_base_action_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapseBaseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction);
	switch (property_id) {
		case SYNAPSE_BASE_ACTION_TITLE_PROPERTY:
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY:
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY:
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
		break;
		case SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_base_action_get_default_relevancy (self));
		break;
		case SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY:
		g_value_set_boolean (value, synapse_base_action_get_notify_match (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_base_action_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapseBaseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_BASE_ACTION, SynapseBaseAction);
	switch (property_id) {
		case SYNAPSE_BASE_ACTION_TITLE_PROPERTY:
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_DESCRIPTION_PROPERTY:
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_ICON_NAME_PROPERTY:
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_HAS_THUMBNAIL_PROPERTY:
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_BASE_ACTION_THUMBNAIL_PATH_PROPERTY:
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_BASE_ACTION_MATCH_TYPE_PROPERTY:
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
		break;
		case SYNAPSE_BASE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
		synapse_base_action_set_default_relevancy (self, g_value_get_int (value));
		break;
		case SYNAPSE_BASE_ACTION_NOTIFY_MATCH_PROPERTY:
		synapse_base_action_set_notify_match (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
synapse_common_actions_get_instance_private (SynapseCommonActions* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActions_private_offset);
}


static void
synapse_common_actions_real_activate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
	self = (SynapseCommonActions*) base;
}


static void
synapse_common_actions_real_deactivate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
	self = (SynapseCommonActions*) base;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static SynapseResultSet*
synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseCommonActions * self;
	SynapseResultSet* result = NULL;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp2_;
	gboolean _tmp3_;
	self = (SynapseCommonActions*) base;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = *query;
	_tmp1_ = _tmp0_.query_string;
	query_empty = g_strcmp0 (_tmp1_, "") == 0;
	_tmp2_ = synapse_result_set_new ();
	results = _tmp2_;
	_tmp3_ = query_empty;
	if (_tmp3_) {
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp4_;
			GeeList* _tmp5_;
			gint _action_size = 0;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _action_index = 0;
			_tmp4_ = self->priv->actions;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_action_list = _tmp5_;
			_tmp6_ = _action_list;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_action_size = _tmp8_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				SynapseBaseAction* action = NULL;
				GeeList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_;
				SynapseBaseAction* _tmp15_;
				_tmp9_ = _action_index;
				_action_index = _tmp9_ + 1;
				_tmp10_ = _action_index;
				_tmp11_ = _action_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _action_list;
				_tmp13_ = _action_index;
				_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
				action = (SynapseBaseAction*) _tmp14_;
				_tmp15_ = action;
				if (synapse_base_action_valid_for_match (_tmp15_, match)) {
					SynapseResultSet* _tmp16_;
					SynapseBaseAction* _tmp17_;
					SynapseBaseAction* _tmp18_;
					_tmp16_ = results;
					_tmp17_ = action;
					_tmp18_ = action;
					synapse_result_set_add (_tmp16_, (SynapseMatch*) _tmp17_, synapse_base_action_get_relevancy_for_match (_tmp18_, match));
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp19_;
		const gchar* _tmp20_;
		GeeList* _tmp21_;
		_tmp19_ = *query;
		_tmp20_ = _tmp19_.query_string;
		_tmp21_ = synapse_query_get_matchers_for_query (_tmp20_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
		matchers = _tmp21_;
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp22_;
			GeeList* _tmp23_;
			gint _action_size = 0;
			GeeList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _action_index = 0;
			_tmp22_ = self->priv->actions;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			_action_list = _tmp23_;
			_tmp24_ = _action_list;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_action_size = _tmp26_;
			_action_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				SynapseBaseAction* action = NULL;
				GeeList* _tmp30_;
				gint _tmp31_;
				gpointer _tmp32_;
				SynapseBaseAction* _tmp33_;
				_tmp27_ = _action_index;
				_action_index = _tmp27_ + 1;
				_tmp28_ = _action_index;
				_tmp29_ = _action_size;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = _action_list;
				_tmp31_ = _action_index;
				_tmp32_ = gee_list_get (_tmp30_, _tmp31_);
				action = (SynapseBaseAction*) _tmp32_;
				_tmp33_ = action;
				if (!synapse_base_action_valid_for_match (_tmp33_, match)) {
					_g_object_unref0 (action);
					continue;
				}
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp34_;
					GeeList* _tmp35_;
					gint _matcher_size = 0;
					GeeList* _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gint _matcher_index = 0;
					_tmp34_ = matchers;
					_tmp35_ = _g_object_ref0 (_tmp34_);
					_matcher_list = _tmp35_;
					_tmp36_ = _matcher_list;
					_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
					_tmp38_ = _tmp37_;
					_matcher_size = _tmp38_;
					_matcher_index = -1;
					while (TRUE) {
						gint _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp42_;
						gint _tmp43_;
						gpointer _tmp44_;
						GeeMapEntry* _tmp45_;
						gconstpointer _tmp46_;
						GRegex* _tmp47_;
						SynapseBaseAction* _tmp48_;
						const gchar* _tmp49_;
						const gchar* _tmp50_;
						_tmp39_ = _matcher_index;
						_matcher_index = _tmp39_ + 1;
						_tmp40_ = _matcher_index;
						_tmp41_ = _matcher_size;
						if (!(_tmp40_ < _tmp41_)) {
							break;
						}
						_tmp42_ = _matcher_list;
						_tmp43_ = _matcher_index;
						_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
						matcher = (GeeMapEntry*) _tmp44_;
						_tmp45_ = matcher;
						_tmp46_ = gee_map_entry_get_key (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = action;
						_tmp49_ = synapse_match_get_title ((SynapseMatch*) _tmp48_);
						_tmp50_ = _tmp49_;
						if (g_regex_match ((GRegex*) _tmp47_, _tmp50_, 0, NULL)) {
							SynapseResultSet* _tmp51_;
							SynapseBaseAction* _tmp52_;
							GeeMapEntry* _tmp53_;
							gconstpointer _tmp54_;
							gint _tmp55_;
							_tmp51_ = results;
							_tmp52_ = action;
							_tmp53_ = matcher;
							_tmp54_ = gee_map_entry_get_value (_tmp53_);
							_tmp55_ = _tmp54_;
							synapse_result_set_add (_tmp51_, (SynapseMatch*) _tmp52_, (gint) ((gintptr) _tmp55_));
							_g_object_unref0 (matcher);
							break;
						}
						_g_object_unref0 (matcher);
					}
					_g_object_unref0 (_matcher_list);
				}
				_g_object_unref0 (action);
			}
			_g_object_unref0 (_action_list);
		}
		_g_object_unref0 (matchers);
	}
	result = results;
	return result;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


void
synapse_common_actions_open_uri (const gchar* uri)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	f = _tmp0_;
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp1_;
		GAppInfo* _tmp2_;
		GList* files = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp5_;
		GdkDisplay* _tmp6_;
		GAppInfo* _tmp7_;
		GList* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
		GdkAppLaunchContext* _tmp11_;
		_tmp1_ = f;
		_tmp2_ = g_file_query_default_handler (_tmp1_, NULL, &_inner_error_);
		app_info = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
		files = NULL;
		_tmp3_ = f;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		files = g_list_prepend (files, _tmp4_);
		_tmp5_ = gdk_display_get_default ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		display = _tmp6_;
		_tmp7_ = app_info;
		_tmp8_ = files;
		_tmp9_ = display;
		_tmp10_ = gdk_display_get_app_launch_context (_tmp9_);
		_tmp11_ = _tmp10_;
		g_app_info_launch (_tmp7_, _tmp8_, (GAppLaunchContext*) _tmp11_, &_inner_error_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (display);
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app_info);
			goto __catch19_g_error;
		}
		_g_object_unref0 (display);
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app_info);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		synapse_utils_logger_warning (NULL, "%s", _tmp13_, NULL);
		_g_error_free0 (err);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
}


SynapseCommonActions*
synapse_common_actions_construct (GType object_type)
{
	SynapseCommonActions * self = NULL;
	self = (SynapseCommonActions*) g_object_new (object_type, NULL);
	return self;
}


SynapseCommonActions*
synapse_common_actions_new (void)
{
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
}


static gboolean
synapse_common_actions_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommonActions* self;
	gboolean _tmp0_;
	self = (SynapseCommonActions*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void
synapse_common_actions_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommonActions* self;
	self = (SynapseCommonActions*) base;
	if (synapse_common_actions_real_get_enabled (base) != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY]);
	}
}


static GObject *
synapse_common_actions_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	SynapseCommonActionsRunner* _tmp2_;
	SynapseCommonActionsRunner* _tmp3_;
	GeeList* _tmp4_;
	SynapseCommonActionsTerminalRunner* _tmp5_;
	SynapseCommonActionsTerminalRunner* _tmp6_;
	GeeList* _tmp7_;
	SynapseCommonActionsOpener* _tmp8_;
	SynapseCommonActionsOpener* _tmp9_;
	GeeList* _tmp10_;
	SynapseCommonActionsOpenFolder* _tmp11_;
	SynapseCommonActionsOpenFolder* _tmp12_;
	GeeList* _tmp13_;
	SynapseCommonActionsClipboardCopy* _tmp14_;
	SynapseCommonActionsClipboardCopy* _tmp15_;
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_BASE_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->actions;
	_tmp2_ = synapse_common_actions_runner_new ();
	_tmp3_ = _tmp2_;
	gee_collection_add ((GeeCollection*) _tmp1_, (SynapseBaseAction*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->actions;
	_tmp5_ = synapse_common_actions_terminal_runner_new ();
	_tmp6_ = _tmp5_;
	gee_collection_add ((GeeCollection*) _tmp4_, (SynapseBaseAction*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->actions;
	_tmp8_ = synapse_common_actions_opener_new ();
	_tmp9_ = _tmp8_;
	gee_collection_add ((GeeCollection*) _tmp7_, (SynapseBaseAction*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->actions;
	_tmp11_ = synapse_common_actions_open_folder_new ();
	_tmp12_ = _tmp11_;
	gee_collection_add ((GeeCollection*) _tmp10_, (SynapseBaseAction*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->actions;
	_tmp14_ = synapse_common_actions_clipboard_copy_new ();
	_tmp15_ = _tmp14_;
	gee_collection_add ((GeeCollection*) _tmp13_, (SynapseBaseAction*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	return obj;
}


static SynapseCommonActionsRunner*
synapse_common_actions_runner_construct (GType object_type)
{
	SynapseCommonActionsRunner * self = NULL;
	self = (SynapseCommonActionsRunner*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
	return self;
}


static SynapseCommonActionsRunner*
synapse_common_actions_runner_new (void)
{
	return synapse_common_actions_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER);
}


static void
synapse_common_actions_runner_real_do_execute (SynapseBaseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsRunner * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsRunner*) base;
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp2_;
		SynapseApplicationMatch* _tmp3_;
		GAppInfo* _tmp4_ = NULL;
		SynapseApplicationMatch* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		GAppInfo* _tmp8_;
		GAppInfo* app = NULL;
		GAppInfo* _tmp13_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_APPLICATION_MATCH) ? ((SynapseApplicationMatch*) match) : NULL);
		app_match = _tmp2_;
		_tmp3_ = app_match;
		g_return_if_fail (_tmp3_ != NULL);
		_tmp5_ = app_match;
		_tmp6_ = synapse_application_match_get_app_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_tmp4_ = _tmp8_;
		if (_tmp4_ == NULL) {
			SynapseApplicationMatch* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GDesktopAppInfo* _tmp12_;
			_tmp9_ = app_match;
			_tmp10_ = synapse_application_match_get_filename (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_desktop_app_info_new_from_filename (_tmp11_);
			_g_object_unref0 (_tmp4_);
			_tmp4_ = (GAppInfo*) _tmp12_;
		}
		_tmp13_ = _tmp4_;
		_tmp4_ = NULL;
		app = _tmp13_;
		{
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp14_;
			GdkDisplay* _tmp15_;
			GAppInfo* _tmp16_;
			GdkDisplay* _tmp17_;
			GdkAppLaunchContext* _tmp18_;
			GdkAppLaunchContext* _tmp19_;
			SynapseRelevancyService* _tmp20_;
			SynapseRelevancyService* _tmp21_;
			GAppInfo* _tmp22_;
			_tmp14_ = gdk_display_get_default ();
			_tmp15_ = _g_object_ref0 (_tmp14_);
			display = _tmp15_;
			_tmp16_ = app;
			_tmp17_ = display;
			_tmp18_ = gdk_display_get_app_launch_context (_tmp17_);
			_tmp19_ = _tmp18_;
			g_app_info_launch (_tmp16_, NULL, (GAppLaunchContext*) _tmp19_, &_inner_error_);
			_g_object_unref0 (_tmp19_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (display);
				goto __catch20_g_error;
			}
			_tmp20_ = synapse_relevancy_service_get_default ();
			_tmp21_ = _tmp20_;
			_tmp22_ = app;
			synapse_relevancy_service_application_launched (_tmp21_, _tmp22_);
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (display);
		}
		goto __finally20;
		__catch20_g_error:
		{
			GError* err = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = err;
			_tmp24_ = _tmp23_->message;
			synapse_utils_logger_warning ((GObject*) self, "%s", _tmp24_, NULL);
			_g_error_free0 (err);
		}
		__finally20:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app);
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (app_match);
	} else {
		synapse_match_execute (match, NULL);
	}
}


static gboolean
synapse_common_actions_runner_real_valid_for_match (SynapseBaseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsRunner * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	self = (SynapseCommonActionsRunner*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SYNAPSE_MATCH_TYPE_SEARCH:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_ACTION:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseApplicationMatch* am = NULL;
			SynapseApplicationMatch* _tmp2_;
			gboolean _tmp3_ = FALSE;
			SynapseApplicationMatch* _tmp4_;
			_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_APPLICATION_MATCH) ? ((SynapseApplicationMatch*) match) : NULL);
			am = _tmp2_;
			_tmp4_ = am;
			if (_tmp4_ == NULL) {
				_tmp3_ = TRUE;
			} else {
				SynapseApplicationMatch* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = am;
				_tmp6_ = synapse_application_match_get_needs_terminal (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp3_ = !_tmp7_;
			}
			result = _tmp3_;
			_g_object_unref0 (am);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void
synapse_common_actions_runner_class_init (SynapseCommonActionsRunnerClass * klass)
{
	synapse_common_actions_runner_parent_class = g_type_class_peek_parent (klass);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_runner_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_runner_real_valid_for_match;
}


static void
synapse_common_actions_runner_instance_init (SynapseCommonActionsRunner * self)
{
}


static GType
synapse_common_actions_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsRunner), 0, (GInstanceInitFunc) synapse_common_actions_runner_instance_init, NULL };
		GType synapse_common_actions_runner_type_id;
		synapse_common_actions_runner_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsRunner", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_runner_type_id__volatile, synapse_common_actions_runner_type_id);
	}
	return synapse_common_actions_runner_type_id__volatile;
}


static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_construct (GType object_type)
{
	SynapseCommonActionsTerminalRunner * self = NULL;
	self = (SynapseCommonActionsTerminalRunner*) g_object_new (object_type, "title", _ ("Run in Terminal"), "description", _ ("Run application or command in terminal"), "icon-name", "terminal", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_new (void)
{
	return synapse_common_actions_terminal_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER);
}


static void
synapse_common_actions_terminal_runner_real_do_execute (SynapseBaseAction* base,
                                                        SynapseMatch* match,
                                                        SynapseMatch* target)
{
	SynapseCommonActionsTerminalRunner * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsTerminalRunner*) base;
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp2_;
		SynapseApplicationMatch* _tmp3_;
		GAppInfo* _tmp4_ = NULL;
		SynapseApplicationMatch* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		GAppInfo* _tmp8_;
		GAppInfo* original = NULL;
		GAppInfo* _tmp13_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_APPLICATION_MATCH) ? ((SynapseApplicationMatch*) match) : NULL);
		app_match = _tmp2_;
		_tmp3_ = app_match;
		g_return_if_fail (_tmp3_ != NULL);
		_tmp5_ = app_match;
		_tmp6_ = synapse_application_match_get_app_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_tmp4_ = _tmp8_;
		if (_tmp4_ == NULL) {
			SynapseApplicationMatch* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GDesktopAppInfo* _tmp12_;
			_tmp9_ = app_match;
			_tmp10_ = synapse_application_match_get_filename (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_desktop_app_info_new_from_filename (_tmp11_);
			_g_object_unref0 (_tmp4_);
			_tmp4_ = (GAppInfo*) _tmp12_;
		}
		_tmp13_ = _tmp4_;
		_tmp4_ = NULL;
		original = _tmp13_;
		{
			GAppInfo* app = NULL;
			GAppInfo* _tmp14_;
			const gchar* _tmp15_;
			GAppInfo* _tmp16_;
			const gchar* _tmp17_;
			GAppInfo* _tmp18_;
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp19_;
			GdkDisplay* _tmp20_;
			GAppInfo* _tmp21_;
			GdkDisplay* _tmp22_;
			GdkAppLaunchContext* _tmp23_;
			GdkAppLaunchContext* _tmp24_;
			_tmp14_ = original;
			_tmp15_ = g_app_info_get_commandline (_tmp14_);
			_tmp16_ = original;
			_tmp17_ = g_app_info_get_name (_tmp16_);
			_tmp18_ = g_app_info_create_from_commandline (_tmp15_, _tmp17_, G_APP_INFO_CREATE_NEEDS_TERMINAL, &_inner_error_);
			app = _tmp18_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch21_g_error;
			}
			_tmp19_ = gdk_display_get_default ();
			_tmp20_ = _g_object_ref0 (_tmp19_);
			display = _tmp20_;
			_tmp21_ = app;
			_tmp22_ = display;
			_tmp23_ = gdk_display_get_app_launch_context (_tmp22_);
			_tmp24_ = _tmp23_;
			g_app_info_launch (_tmp21_, NULL, (GAppLaunchContext*) _tmp24_, &_inner_error_);
			_g_object_unref0 (_tmp24_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (display);
				_g_object_unref0 (app);
				goto __catch21_g_error;
			}
			_g_object_unref0 (display);
			_g_object_unref0 (app);
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError* err = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = err;
			_tmp26_ = _tmp25_->message;
			synapse_utils_logger_warning ((GObject*) self, "%s", _tmp26_, NULL);
			_g_error_free0 (err);
		}
		__finally21:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (original);
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (app_match);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (original);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (app_match);
	}
}


static gboolean
synapse_common_actions_terminal_runner_real_valid_for_match (SynapseBaseAction* base,
                                                             SynapseMatch* match)
{
	SynapseCommonActionsTerminalRunner * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	self = (SynapseCommonActionsTerminalRunner*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseApplicationMatch* am = NULL;
			SynapseApplicationMatch* _tmp2_;
			SynapseApplicationMatch* _tmp3_;
			_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_APPLICATION_MATCH) ? ((SynapseApplicationMatch*) match) : NULL);
			am = _tmp2_;
			_tmp3_ = am;
			result = _tmp3_ != NULL;
			_g_object_unref0 (am);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static void
synapse_common_actions_terminal_runner_class_init (SynapseCommonActionsTerminalRunnerClass * klass)
{
	synapse_common_actions_terminal_runner_parent_class = g_type_class_peek_parent (klass);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_valid_for_match;
}


static void
synapse_common_actions_terminal_runner_instance_init (SynapseCommonActionsTerminalRunner * self)
{
}


static GType
synapse_common_actions_terminal_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_terminal_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_terminal_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsTerminalRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_terminal_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsTerminalRunner), 0, (GInstanceInitFunc) synapse_common_actions_terminal_runner_instance_init, NULL };
		GType synapse_common_actions_terminal_runner_type_id;
		synapse_common_actions_terminal_runner_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsTerminalRunner", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_terminal_runner_type_id__volatile, synapse_common_actions_terminal_runner_type_id);
	}
	return synapse_common_actions_terminal_runner_type_id__volatile;
}


static inline gpointer
synapse_common_actions_opener_get_instance_private (SynapseCommonActionsOpener* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActionsOpener_private_offset);
}


static SynapseCommonActionsOpener*
synapse_common_actions_opener_construct (GType object_type)
{
	SynapseCommonActionsOpener * self = NULL;
	self = (SynapseCommonActionsOpener*) g_object_new (object_type, "title", _ ("Open"), "description", _ ("Open using default application"), "icon-name", "fileopen", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_GOOD, NULL);
	return self;
}


static SynapseCommonActionsOpener*
synapse_common_actions_opener_new (void)
{
	return synapse_common_actions_opener_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPENER);
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static void
synapse_common_actions_opener_real_do_execute (SynapseBaseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsOpener * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
	self = (SynapseCommonActionsOpener*) base;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
	uri_match = _tmp0_;
	_tmp1_ = uri_match;
	if (_tmp1_ != NULL) {
		SynapseUriMatch* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = uri_match;
		_tmp3_ = synapse_uri_match_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		synapse_common_actions_open_uri (_tmp4_);
	} else {
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->file_path;
		_tmp6_ = synapse_match_get_title (match);
		_tmp7_ = _tmp6_;
		if (g_regex_match (_tmp5_, _tmp7_, 0, NULL)) {
			GFile* f = NULL;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp8_ = synapse_match_get_title (match);
			_tmp9_ = _tmp8_;
			if (g_str_has_prefix (_tmp9_, "~")) {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GFile* _tmp17_;
				_tmp10_ = g_get_home_dir ();
				_tmp11_ = synapse_match_get_title (match);
				_tmp12_ = _tmp11_;
				_tmp13_ = string_substring (_tmp12_, (glong) 1, (glong) -1);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_build_filename (_tmp10_, _tmp14_, NULL, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_file_new_for_path (_tmp16_);
				_g_object_unref0 (f);
				f = _tmp17_;
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
			} else {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GFile* _tmp20_;
				_tmp18_ = synapse_match_get_title (match);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_file_new_for_path (_tmp19_);
				_g_object_unref0 (f);
				f = _tmp20_;
			}
			_tmp21_ = f;
			_tmp22_ = g_file_get_uri (_tmp21_);
			_tmp23_ = _tmp22_;
			synapse_common_actions_open_uri (_tmp23_);
			_g_free0 (_tmp23_);
			_g_object_unref0 (f);
		} else {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp24_ = synapse_match_get_title (match);
			_tmp25_ = _tmp24_;
			synapse_common_actions_open_uri (_tmp25_);
		}
	}
	_g_object_unref0 (uri_match);
}


static gboolean
synapse_common_actions_opener_real_valid_for_match (SynapseBaseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsOpener * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	self = (SynapseCommonActionsOpener*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_UNKNOWN:
		{
			gboolean _tmp2_ = FALSE;
			GRegex* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = self->priv->web_uri;
			_tmp4_ = synapse_match_get_title (match);
			_tmp5_ = _tmp4_;
			if (g_regex_match (_tmp3_, _tmp5_, 0, NULL)) {
				_tmp2_ = TRUE;
			} else {
				GRegex* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp6_ = self->priv->file_path;
				_tmp7_ = synapse_match_get_title (match);
				_tmp8_ = _tmp7_;
				_tmp2_ = g_regex_match (_tmp6_, _tmp8_, 0, NULL);
			}
			result = _tmp2_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static GObject *
synapse_common_actions_opener_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActionsOpener * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_common_actions_opener_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("^(ftp|http(s)?)://[^.]+\\.[^.]+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->web_uri);
		self->priv->web_uri = _tmp2_;
		_tmp4_ = g_regex_new ("^(/|~/)[^/]+", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch22_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (self->priv->file_path);
		self->priv->file_path = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		synapse_utils_logger_warning ((GObject*) self, "%s", _tmp7_, NULL);
		_g_error_free0 (err);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void
synapse_common_actions_opener_class_init (SynapseCommonActionsOpenerClass * klass)
{
	synapse_common_actions_opener_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommonActionsOpener_private_offset);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_opener_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_opener_real_valid_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_opener_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_opener_finalize;
}


static void
synapse_common_actions_opener_instance_init (SynapseCommonActionsOpener * self)
{
	self->priv = synapse_common_actions_opener_get_instance_private (self);
}


static void
synapse_common_actions_opener_finalize (GObject * obj)
{
	SynapseCommonActionsOpener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
	_g_regex_unref0 (self->priv->web_uri);
	_g_regex_unref0 (self->priv->file_path);
	G_OBJECT_CLASS (synapse_common_actions_opener_parent_class)->finalize (obj);
}


static GType
synapse_common_actions_opener_get_type (void)
{
	static volatile gsize synapse_common_actions_opener_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_opener_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_opener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpener), 0, (GInstanceInitFunc) synapse_common_actions_opener_instance_init, NULL };
		GType synapse_common_actions_opener_type_id;
		synapse_common_actions_opener_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsOpener", &g_define_type_info, 0);
		SynapseCommonActionsOpener_private_offset = g_type_add_instance_private (synapse_common_actions_opener_type_id, sizeof (SynapseCommonActionsOpenerPrivate));
		g_once_init_leave (&synapse_common_actions_opener_type_id__volatile, synapse_common_actions_opener_type_id);
	}
	return synapse_common_actions_opener_type_id__volatile;
}


static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_construct (GType object_type)
{
	SynapseCommonActionsOpenFolder * self = NULL;
	self = (SynapseCommonActionsOpenFolder*) g_object_new (object_type, "title", _ ("Open folder"), "description", _ ("Open folder containing this file"), "icon-name", "folder-open", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_new (void)
{
	return synapse_common_actions_open_folder_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER);
}


static void
synapse_common_actions_open_folder_real_do_execute (SynapseBaseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	SynapseUriMatch* _tmp1_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (SynapseCommonActionsOpenFolder*) base;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
	uri_match = _tmp0_;
	_tmp1_ = uri_match;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = uri_match;
	_tmp3_ = synapse_uri_match_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_uri (_tmp4_);
	f = _tmp5_;
	_tmp6_ = f;
	_tmp7_ = g_file_get_parent (_tmp6_);
	_g_object_unref0 (f);
	f = _tmp7_;
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp8_;
		GAppInfo* _tmp9_;
		GList* files = NULL;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp12_;
		GdkDisplay* _tmp13_;
		GAppInfo* _tmp14_;
		GList* _tmp15_;
		GdkDisplay* _tmp16_;
		GdkAppLaunchContext* _tmp17_;
		GdkAppLaunchContext* _tmp18_;
		_tmp8_ = f;
		_tmp9_ = g_file_query_default_handler (_tmp8_, NULL, &_inner_error_);
		app_info = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch23_g_error;
		}
		files = NULL;
		_tmp10_ = f;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		files = g_list_prepend (files, _tmp11_);
		_tmp12_ = gdk_display_get_default ();
		_tmp13_ = _g_object_ref0 (_tmp12_);
		display = _tmp13_;
		_tmp14_ = app_info;
		_tmp15_ = files;
		_tmp16_ = display;
		_tmp17_ = gdk_display_get_app_launch_context (_tmp16_);
		_tmp18_ = _tmp17_;
		g_app_info_launch (_tmp14_, _tmp15_, (GAppLaunchContext*) _tmp18_, &_inner_error_);
		_g_object_unref0 (_tmp18_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (display);
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app_info);
			goto __catch23_g_error;
		}
		_g_object_unref0 (display);
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app_info);
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = err;
		_tmp20_ = _tmp19_->message;
		synapse_utils_logger_warning ((GObject*) self, "%s", _tmp20_, NULL);
		_g_error_free0 (err);
	}
	__finally23:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (f);
		_g_object_unref0 (uri_match);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
}


static gboolean
synapse_common_actions_open_folder_real_valid_for_match (SynapseBaseAction* base,
                                                         SynapseMatch* match)
{
	SynapseCommonActionsOpenFolder * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp2_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* parent = NULL;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GFile* _tmp10_;
	self = (SynapseCommonActionsOpenFolder*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		result = FALSE;
		return result;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
	uri_match = _tmp2_;
	_tmp3_ = uri_match;
	_tmp4_ = synapse_uri_match_get_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_uri (_tmp5_);
	f = _tmp6_;
	_tmp7_ = f;
	_tmp8_ = g_file_get_parent (_tmp7_);
	parent = _tmp8_;
	_tmp10_ = parent;
	if (_tmp10_ != NULL) {
		GFile* _tmp11_;
		_tmp11_ = f;
		_tmp9_ = g_file_is_native (_tmp11_);
	} else {
		_tmp9_ = FALSE;
	}
	result = _tmp9_;
	_g_object_unref0 (parent);
	_g_object_unref0 (f);
	_g_object_unref0 (uri_match);
	return result;
}


static void
synapse_common_actions_open_folder_class_init (SynapseCommonActionsOpenFolderClass * klass)
{
	synapse_common_actions_open_folder_parent_class = g_type_class_peek_parent (klass);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_open_folder_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_open_folder_real_valid_for_match;
}


static void
synapse_common_actions_open_folder_instance_init (SynapseCommonActionsOpenFolder * self)
{
}


static GType
synapse_common_actions_open_folder_get_type (void)
{
	static volatile gsize synapse_common_actions_open_folder_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_open_folder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_open_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpenFolder), 0, (GInstanceInitFunc) synapse_common_actions_open_folder_instance_init, NULL };
		GType synapse_common_actions_open_folder_type_id;
		synapse_common_actions_open_folder_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsOpenFolder", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_open_folder_type_id__volatile, synapse_common_actions_open_folder_type_id);
	}
	return synapse_common_actions_open_folder_type_id__volatile;
}


static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_construct (GType object_type)
{
	SynapseCommonActionsClipboardCopy * self = NULL;
	self = (SynapseCommonActionsClipboardCopy*) g_object_new (object_type, "title", _ ("Copy to Clipboard"), "description", _ ("Copy selection to clipboard"), "icon-name", "gtk-copy", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
	return self;
}


static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_new (void)
{
	return synapse_common_actions_clipboard_copy_construct (SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY);
}


static void
synapse_common_actions_clipboard_copy_real_do_execute (SynapseBaseAction* base,
                                                       SynapseMatch* match,
                                                       SynapseMatch* target)
{
	SynapseCommonActionsClipboardCopy * self;
	GtkClipboard* cb = NULL;
	GdkAtom _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	SynapseMatchType _tmp3_;
	SynapseMatchType _tmp4_;
	self = (SynapseCommonActionsClipboardCopy*) base;
	_tmp0_ = GDK_NONE;
	_tmp1_ = gtk_clipboard_get (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cb = _tmp2_;
	_tmp3_ = synapse_match_get_match_type (match);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
		SynapseUriMatch* uri_match = NULL;
		SynapseUriMatch* _tmp5_;
		SynapseUriMatch* _tmp6_;
		GtkClipboard* _tmp7_;
		SynapseUriMatch* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
		uri_match = _tmp5_;
		_tmp6_ = uri_match;
		g_return_if_fail (_tmp6_ != NULL);
		_tmp7_ = cb;
		_tmp8_ = uri_match;
		_tmp9_ = synapse_uri_match_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_clipboard_set_text (_tmp7_, _tmp10_, -1);
		_g_object_unref0 (uri_match);
	} else {
		SynapseMatchType _tmp11_;
		SynapseMatchType _tmp12_;
		_tmp11_ = synapse_match_get_match_type (match);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == SYNAPSE_MATCH_TYPE_TEXT) {
			SynapseTextMatch* text_match = NULL;
			SynapseTextMatch* _tmp13_;
			gchar* _tmp14_ = NULL;
			SynapseTextMatch* _tmp15_;
			gchar* content = NULL;
			gchar* _tmp21_;
			GtkClipboard* _tmp22_;
			const gchar* _tmp23_;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_TEXT_MATCH) ? ((SynapseTextMatch*) match) : NULL);
			text_match = _tmp13_;
			_tmp15_ = text_match;
			if (_tmp15_ != NULL) {
				SynapseTextMatch* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = text_match;
				_tmp17_ = synapse_text_match_get_text (_tmp16_);
				_g_free0 (_tmp14_);
				_tmp14_ = _tmp17_;
			} else {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = synapse_match_get_title (match);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (_tmp14_);
				_tmp14_ = _tmp20_;
			}
			_tmp21_ = g_strdup (_tmp14_);
			content = _tmp21_;
			_tmp22_ = cb;
			_tmp23_ = content;
			gtk_clipboard_set_text (_tmp22_, _tmp23_, -1);
			_g_free0 (content);
			_g_free0 (_tmp14_);
			_g_object_unref0 (text_match);
		}
	}
	_g_object_unref0 (cb);
}


static gboolean
synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseBaseAction* base,
                                                            SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	gboolean result = FALSE;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	self = (SynapseCommonActionsClipboardCopy*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SYNAPSE_MATCH_TYPE_GENERIC_URI:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_TEXT:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gint
synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseBaseAction* base,
                                                                    SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	gint result = 0;
	SynapseTextMatch* text_match = NULL;
	SynapseTextMatch* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SynapseTextMatch* _tmp2_;
	gint _tmp6_;
	gint _tmp7_;
	self = (SynapseCommonActionsClipboardCopy*) base;
	g_return_val_if_fail (match != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_TEXT_MATCH) ? ((SynapseTextMatch*) match) : NULL);
	text_match = _tmp0_;
	_tmp2_ = text_match;
	if (_tmp2_ != NULL) {
		SynapseTextMatch* _tmp3_;
		SynapseTextOrigin _tmp4_;
		SynapseTextOrigin _tmp5_;
		_tmp3_ = text_match;
		_tmp4_ = synapse_text_match_get_text_origin (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == SYNAPSE_TEXT_ORIGIN_CLIPBOARD;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = 0;
		_g_object_unref0 (text_match);
		return result;
	}
	_tmp6_ = synapse_base_action_get_default_relevancy ((SynapseBaseAction*) self);
	_tmp7_ = _tmp6_;
	result = _tmp7_;
	_g_object_unref0 (text_match);
	return result;
}


static void
synapse_common_actions_clipboard_copy_class_init (SynapseCommonActionsClipboardCopyClass * klass)
{
	synapse_common_actions_clipboard_copy_parent_class = g_type_class_peek_parent (klass);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_valid_for_match;
	((SynapseBaseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseBaseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_get_relevancy_for_match;
}


static void
synapse_common_actions_clipboard_copy_instance_init (SynapseCommonActionsClipboardCopy * self)
{
}


static GType
synapse_common_actions_clipboard_copy_get_type (void)
{
	static volatile gsize synapse_common_actions_clipboard_copy_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_clipboard_copy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClipboardCopyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_clipboard_copy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsClipboardCopy), 0, (GInstanceInitFunc) synapse_common_actions_clipboard_copy_instance_init, NULL };
		GType synapse_common_actions_clipboard_copy_type_id;
		synapse_common_actions_clipboard_copy_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseCommonActionsClipboardCopy", &g_define_type_info, 0);
		g_once_init_leave (&synapse_common_actions_clipboard_copy_type_id__volatile, synapse_common_actions_clipboard_copy_type_id);
	}
	return synapse_common_actions_clipboard_copy_type_id__volatile;
}


static void
synapse_common_actions_class_init (SynapseCommonActionsClass * klass)
{
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommonActions_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_common_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_common_actions_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
synapse_common_actions_synapse_activatable_interface_init (SynapseActivatableIface * iface)
{
	synapse_common_actions_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_deactivate;
	iface->get_enabled = synapse_common_actions_real_get_enabled;
	iface->set_enabled = synapse_common_actions_real_set_enabled;
}


static void
synapse_common_actions_synapse_action_provider_interface_init (SynapseActionProviderIface * iface)
{
	synapse_common_actions_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_common_actions_real_find_for_match;
}


static void
synapse_common_actions_instance_init (SynapseCommonActions * self)
{
	self->priv = synapse_common_actions_get_instance_private (self);
	self->priv->_enabled = TRUE;
}


static void
synapse_common_actions_finalize (GObject * obj)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
}


GType
synapse_common_actions_get_type (void)
{
	static volatile gsize synapse_common_actions_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
		static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType synapse_common_actions_type_id;
		synapse_common_actions_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommonActions", &g_define_type_info, 0);
		g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
		g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
		SynapseCommonActions_private_offset = g_type_add_instance_private (synapse_common_actions_type_id, sizeof (SynapseCommonActionsPrivate));
		g_once_init_leave (&synapse_common_actions_type_id__volatile, synapse_common_actions_type_id);
	}
	return synapse_common_actions_type_id__volatile;
}


static void
_vala_synapse_common_actions_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_synapse_common_actions_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
	switch (property_id) {
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



