/* PantherView.c generated by valac 0.42.5, the Vala compiler
 * generated from PantherView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gmenu-tree.h>
#include <cairo.h>
#include <gio/gio.h>

typedef enum  {
	PANTHER_MODALITY_NORMAL_VIEW = 0,
	PANTHER_MODALITY_CATEGORY_VIEW = 1,
	PANTHER_MODALITY_SEARCH_VIEW
} PantherModality;


#define PANTHER_TYPE_MODALITY (panther_modality_get_type ())

#define PANTHER_TYPE_SELECTOR (panther_selector_get_type ())
#define PANTHER_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_TYPE_SELECTOR, PantherSelector))
#define PANTHER_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_TYPE_SELECTOR, PantherSelectorClass))
#define PANTHER_IS_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_TYPE_SELECTOR))
#define PANTHER_IS_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_TYPE_SELECTOR))
#define PANTHER_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_TYPE_SELECTOR, PantherSelectorClass))

typedef struct _PantherSelector PantherSelector;
typedef struct _PantherSelectorClass PantherSelectorClass;
typedef struct _PantherSelectorPrivate PantherSelectorPrivate;
enum  {
	PANTHER_SELECTOR_0_PROPERTY,
	PANTHER_SELECTOR_SELECTED_PROPERTY,
	PANTHER_SELECTOR_NUM_PROPERTIES
};
static GParamSpec* panther_selector_properties[PANTHER_SELECTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PANTHER_SELECTOR_MODE_CHANGED_SIGNAL,
	PANTHER_SELECTOR_NUM_SIGNALS
};
static guint panther_selector_signals[PANTHER_SELECTOR_NUM_SIGNALS] = {0};

#define PANTHER_TYPE_PANTHER_VIEW (panther_panther_view_get_type ())
#define PANTHER_PANTHER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_TYPE_PANTHER_VIEW, PantherPantherView))
#define PANTHER_PANTHER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_TYPE_PANTHER_VIEW, PantherPantherViewClass))
#define PANTHER_IS_PANTHER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_TYPE_PANTHER_VIEW))
#define PANTHER_IS_PANTHER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_TYPE_PANTHER_VIEW))
#define PANTHER_PANTHER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_TYPE_PANTHER_VIEW, PantherPantherViewClass))

typedef struct _PantherPantherView PantherPantherView;
typedef struct _PantherPantherViewClass PantherPantherViewClass;
typedef struct _PantherPantherViewPrivate PantherPantherViewPrivate;

#define PANTHER_BACKEND_TYPE_APP_SYSTEM (panther_backend_app_system_get_type ())
#define PANTHER_BACKEND_APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_BACKEND_TYPE_APP_SYSTEM, PantherBackendAppSystem))
#define PANTHER_BACKEND_APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_BACKEND_TYPE_APP_SYSTEM, PantherBackendAppSystemClass))
#define PANTHER_BACKEND_IS_APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_BACKEND_TYPE_APP_SYSTEM))
#define PANTHER_BACKEND_IS_APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_BACKEND_TYPE_APP_SYSTEM))
#define PANTHER_BACKEND_APP_SYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_BACKEND_TYPE_APP_SYSTEM, PantherBackendAppSystemClass))

typedef struct _PantherBackendAppSystem PantherBackendAppSystem;
typedef struct _PantherBackendAppSystemClass PantherBackendAppSystemClass;

#define PANTHER_BACKEND_TYPE_APP (panther_backend_app_get_type ())
#define PANTHER_BACKEND_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_BACKEND_TYPE_APP, PantherBackendApp))
#define PANTHER_BACKEND_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_BACKEND_TYPE_APP, PantherBackendAppClass))
#define PANTHER_BACKEND_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_BACKEND_TYPE_APP))
#define PANTHER_BACKEND_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_BACKEND_TYPE_APP))
#define PANTHER_BACKEND_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_BACKEND_TYPE_APP, PantherBackendAppClass))

typedef struct _PantherBackendApp PantherBackendApp;
typedef struct _PantherBackendAppClass PantherBackendAppClass;

#define PANTHER_WIDGETS_TYPE_GRID (panther_widgets_grid_get_type ())
#define PANTHER_WIDGETS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_WIDGETS_TYPE_GRID, PantherWidgetsGrid))
#define PANTHER_WIDGETS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_WIDGETS_TYPE_GRID, PantherWidgetsGridClass))
#define PANTHER_WIDGETS_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_WIDGETS_TYPE_GRID))
#define PANTHER_WIDGETS_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_WIDGETS_TYPE_GRID))
#define PANTHER_WIDGETS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_WIDGETS_TYPE_GRID, PantherWidgetsGridClass))

typedef struct _PantherWidgetsGrid PantherWidgetsGrid;
typedef struct _PantherWidgetsGridClass PantherWidgetsGridClass;

#define PANTHER_WIDGETS_TYPE_SEARCH_VIEW (panther_widgets_search_view_get_type ())
#define PANTHER_WIDGETS_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_WIDGETS_TYPE_SEARCH_VIEW, PantherWidgetsSearchView))
#define PANTHER_WIDGETS_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_WIDGETS_TYPE_SEARCH_VIEW, PantherWidgetsSearchViewClass))
#define PANTHER_WIDGETS_IS_SEARCH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_WIDGETS_TYPE_SEARCH_VIEW))
#define PANTHER_WIDGETS_IS_SEARCH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_WIDGETS_TYPE_SEARCH_VIEW))
#define PANTHER_WIDGETS_SEARCH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_WIDGETS_TYPE_SEARCH_VIEW, PantherWidgetsSearchViewClass))

typedef struct _PantherWidgetsSearchView PantherWidgetsSearchView;
typedef struct _PantherWidgetsSearchViewClass PantherWidgetsSearchViewClass;

#define PANTHER_WIDGETS_TYPE_CATEGORY_VIEW (panther_widgets_category_view_get_type ())
#define PANTHER_WIDGETS_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_WIDGETS_TYPE_CATEGORY_VIEW, PantherWidgetsCategoryView))
#define PANTHER_WIDGETS_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_WIDGETS_TYPE_CATEGORY_VIEW, PantherWidgetsCategoryViewClass))
#define PANTHER_WIDGETS_IS_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_WIDGETS_TYPE_CATEGORY_VIEW))
#define PANTHER_WIDGETS_IS_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_WIDGETS_TYPE_CATEGORY_VIEW))
#define PANTHER_WIDGETS_CATEGORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_WIDGETS_TYPE_CATEGORY_VIEW, PantherWidgetsCategoryViewClass))

typedef struct _PantherWidgetsCategoryView PantherWidgetsCategoryView;
typedef struct _PantherWidgetsCategoryViewClass PantherWidgetsCategoryViewClass;

#define PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH (panther_backend_synapse_search_get_type ())
#define PANTHER_BACKEND_SYNAPSE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearch))
#define PANTHER_BACKEND_SYNAPSE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearchClass))
#define PANTHER_BACKEND_IS_SYNAPSE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH))
#define PANTHER_BACKEND_IS_SYNAPSE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH))
#define PANTHER_BACKEND_SYNAPSE_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearchClass))

typedef struct _PantherBackendSynapseSearch PantherBackendSynapseSearch;
typedef struct _PantherBackendSynapseSearchClass PantherBackendSynapseSearchClass;
enum  {
	PANTHER_PANTHER_VIEW_0_PROPERTY,
	PANTHER_PANTHER_VIEW_COLUMNS_PROPERTY,
	PANTHER_PANTHER_VIEW_ROWS_PROPERTY,
	PANTHER_PANTHER_VIEW_NUM_PROPERTIES
};
static GParamSpec* panther_panther_view_properties[PANTHER_PANTHER_VIEW_NUM_PROPERTIES];

#define PANTHER_TYPE_SETTINGS (panther_settings_get_type ())
#define PANTHER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_TYPE_SETTINGS, PantherSettings))
#define PANTHER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_TYPE_SETTINGS, PantherSettingsClass))
#define PANTHER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_TYPE_SETTINGS))
#define PANTHER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_TYPE_SETTINGS))
#define PANTHER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_TYPE_SETTINGS, PantherSettingsClass))

typedef struct _PantherSettings PantherSettings;
typedef struct _PantherSettingsClass PantherSettingsClass;
typedef struct _PantherSettingsPrivate PantherSettingsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchIface))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchIface SynapseSearchMatchIface;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define PANTHER_WIDGETS_TYPE_APP_ENTRY (panther_widgets_app_entry_get_type ())
#define PANTHER_WIDGETS_APP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_WIDGETS_TYPE_APP_ENTRY, PantherWidgetsAppEntry))
#define PANTHER_WIDGETS_APP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_WIDGETS_TYPE_APP_ENTRY, PantherWidgetsAppEntryClass))
#define PANTHER_WIDGETS_IS_APP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_WIDGETS_TYPE_APP_ENTRY))
#define PANTHER_WIDGETS_IS_APP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_WIDGETS_TYPE_APP_ENTRY))
#define PANTHER_WIDGETS_APP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_WIDGETS_TYPE_APP_ENTRY, PantherWidgetsAppEntryClass))

typedef struct _PantherWidgetsAppEntry PantherWidgetsAppEntry;
typedef struct _PantherWidgetsAppEntryClass PantherWidgetsAppEntryClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PantherWidgetsCategoryViewPrivate PantherWidgetsCategoryViewPrivate;

#define PANTHER_WIDGETS_TYPE_SIDEBAR (panther_widgets_sidebar_get_type ())
#define PANTHER_WIDGETS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_WIDGETS_TYPE_SIDEBAR, PantherWidgetsSidebar))
#define PANTHER_WIDGETS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_WIDGETS_TYPE_SIDEBAR, PantherWidgetsSidebarClass))
#define PANTHER_WIDGETS_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_WIDGETS_TYPE_SIDEBAR))
#define PANTHER_WIDGETS_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_WIDGETS_TYPE_SIDEBAR))
#define PANTHER_WIDGETS_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_WIDGETS_TYPE_SIDEBAR, PantherWidgetsSidebarClass))

typedef struct _PantherWidgetsSidebar PantherWidgetsSidebar;
typedef struct _PantherWidgetsSidebarClass PantherWidgetsSidebarClass;
typedef struct _Block3Data Block3Data;
typedef struct _PantherPantherViewSearchData PantherPantherViewSearchData;

struct _PantherSelector {
	GtkButtonBox parent_instance;
	PantherSelectorPrivate * priv;
};

struct _PantherSelectorClass {
	GtkButtonBoxClass parent_class;
};

struct _PantherSelectorPrivate {
	gint _selected;
	GtkToggleButton* view_all;
	GtkToggleButton* view_cats;
};

struct _PantherPantherView {
	GtkWindow parent_instance;
	PantherPantherViewPrivate * priv;
	GtkSearchEntry* search_entry;
	GtkStack* stack;
	PantherSelector* view_selector;
	GtkGrid* top;
	GtkGrid* container;
	GtkFrame* fcontainer;
	GtkStack* main_stack;
	GtkBox* content_area;
	PantherBackendAppSystem* app_system;
	GeeHashMap* apps;
};

struct _PantherPantherViewClass {
	GtkWindowClass parent_class;
};

struct _PantherPantherViewPrivate {
	GtkRevealer* view_selector_revealer;
	PantherWidgetsGrid* grid_view;
	PantherWidgetsSearchView* search_view;
	PantherWidgetsCategoryView* category_view;
	GtkEventBox* event_box;
	GeeArrayList* categories;
	PantherModality modality;
	gboolean can_trigger_hotcorner;
	PantherBackendSynapseSearch* synapse;
	gint default_columns;
	gint default_rows;
	gint column_focus;
	gint row_focus;
	gint category_column_focus;
	gint category_row_focus;
	gint primary_monitor;
	gboolean avoid_show;
};

struct _PantherSettings {
	GObject parent_instance;
	PantherSettingsPrivate * priv;
	gint columns;
	gint rows;
};

struct _PantherSettingsClass {
	GObjectClass parent_class;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatchIface {
	GTypeInterface parent_iface;
	SynapseMatch* (*get_search_source) (SynapseSearchMatch* self);
	void (*set_search_source) (SynapseSearchMatch* self, SynapseMatch* value);
};

struct _PantherWidgetsCategoryView {
	GtkEventBox parent_instance;
	PantherWidgetsCategoryViewPrivate * priv;
	PantherWidgetsSidebar* category_switcher;
	GtkSeparator* separator;
	PantherWidgetsGrid* app_view;
	GeeHashMap* category_ids;
};

struct _PantherWidgetsCategoryViewClass {
	GtkEventBoxClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	PantherPantherView* self;
	GeeList* matches;
	gchar* text;
	gpointer _async_data_;
};

struct _PantherPantherViewSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	PantherPantherView* self;
	gchar* text;
	SynapseSearchMatch* search_match;
	SynapseMatch* target;
	Block3Data* _data3_;
	gchar* stripped;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	PantherModality _tmp2_;
	PantherBackendSynapseSearch* _tmp3_;
	GeeList* _tmp4_;
	PantherBackendSynapseSearch* _tmp5_;
	GeeList* _tmp6_;
};


static gint PantherSelector_private_offset;
static gpointer panther_selector_parent_class = NULL;
static gint PantherPantherView_private_offset;
static gpointer panther_panther_view_parent_class = NULL;
extern gint panther_pixels_ITEM_SIZE;

GType panther_modality_get_type (void) G_GNUC_CONST;
GType panther_selector_get_type (void) G_GNUC_CONST;
PantherSelector* panther_selector_new (GtkOrientation orientation);
PantherSelector* panther_selector_construct (GType object_type,
                                             GtkOrientation orientation);
static gboolean __lambda4_ (PantherSelector* self,
                     GdkEventButton* bt);
void panther_selector_set_selector (PantherSelector* self,
                                    gint v);
static gboolean ___lambda4__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda5_ (PantherSelector* self,
                     GdkEventButton* bt);
static gboolean ___lambda5__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
gint panther_selector_get_selector (PantherSelector* self);
gint panther_selector_get_selected (PantherSelector* self);
void panther_selector_set_selected (PantherSelector* self,
                                    gint value);
static void panther_selector_finalize (GObject * obj);
static void _vala_panther_selector_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_panther_selector_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
GType panther_panther_view_get_type (void) G_GNUC_CONST;
GType panther_backend_app_system_get_type (void) G_GNUC_CONST;
GType panther_backend_app_get_type (void) G_GNUC_CONST;
GType panther_widgets_grid_get_type (void) G_GNUC_CONST;
GType panther_widgets_search_view_get_type (void) G_GNUC_CONST;
GType panther_widgets_category_view_get_type (void) G_GNUC_CONST;
GType panther_backend_synapse_search_get_type (void) G_GNUC_CONST;
PantherPantherView* panther_panther_view_new (void);
PantherPantherView* panther_panther_view_construct (GType object_type);
GType panther_settings_get_type (void) G_GNUC_CONST;
PantherSettings* panther_panther_get_settings (void);
gint panther_settings_get_rows_int (PantherSettings* self);
gint panther_settings_get_columns_int (PantherSettings* self);
static void panther_panther_view_read_settings (PantherPantherView* self,
                                         gboolean first_start,
                                         gboolean check_columns,
                                         gboolean check_rows);
void panther_panther_set_icon_theme (GtkIconTheme* value);
PantherBackendAppSystem* panther_backend_app_system_new (void);
PantherBackendAppSystem* panther_backend_app_system_construct (GType object_type);
PantherBackendSynapseSearch* panther_backend_synapse_search_new (void);
PantherBackendSynapseSearch* panther_backend_synapse_search_construct (GType object_type);
GeeArrayList* panther_backend_app_system_get_categories (PantherBackendAppSystem* self);
GeeHashMap* panther_backend_app_system_get_apps (PantherBackendAppSystem* self);
const gchar* panther_settings_get_screen_resolution (PantherSettings* self);
static void panther_panther_view_setup_size (PantherPantherView* self);
gint panther_panther_view_calculate_grid_height (PantherPantherView* self);
#define PANTHER_PIXELS_BOTTOM_SPACE 128
static void panther_panther_view_setup_ui (PantherPantherView* self);
static void panther_panther_view_connect_signals (PantherPantherView* self);
#define PANTHER_PIXELS_ROW_SPACING 5
gint panther_panther_view_calculate_grid_width (PantherPantherView* self);
void panther_settings_set_screen_resolution (PantherSettings* self,
                                             const gchar* value);
gboolean panther_settings_get_use_category (PantherSettings* self);
gboolean panther_settings_get_show_category_filter (PantherSettings* self);
PantherWidgetsGrid* panther_widgets_grid_new (gint rows,
                                              gint columns);
PantherWidgetsGrid* panther_widgets_grid_construct (GType object_type,
                                                    gint rows,
                                                    gint columns);
PantherWidgetsCategoryView* panther_widgets_category_view_new (PantherPantherView* parent);
PantherWidgetsCategoryView* panther_widgets_category_view_construct (GType object_type,
                                                                     PantherPantherView* parent);
PantherWidgetsSearchView* panther_widgets_search_view_new (PantherPantherView* parent);
PantherWidgetsSearchView* panther_widgets_search_view_construct (GType object_type,
                                                                 PantherPantherView* parent);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
GType synapse_search_match_get_type (void) G_GNUC_CONST;
static void __lambda51_ (PantherPantherView* self,
                  SynapseSearchMatch* match,
                  SynapseMatch* target);
static void panther_panther_view_search (PantherPantherView* self,
                                  const gchar* text,
                                  SynapseSearchMatch* search_match,
                                  SynapseMatch* target,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void panther_panther_view_search_finish (PantherPantherView* self,
                                         GAsyncResult* _res_);
static void ___lambda51__panther_widgets_search_view_start_search (PantherWidgetsSearchView* _sender,
                                                            SynapseSearchMatch* search_match,
                                                            SynapseMatch* target,
                                                            gpointer self);
static void panther_panther_view_set_modality (PantherPantherView* self,
                                        PantherModality new_modality);
void panther_panther_view_grab_device (PantherPantherView* self);
static gboolean ___lambda25_ (PantherPantherView* self);
static gboolean ____lambda25__gsource_func (gpointer self);
static gboolean panther_panther_view_real_button_press_event (GtkWidget* base,
                                                       GdkEventButton* event);
static void panther_panther_view_real_get_preferred_width (GtkWidget* base,
                                                    gint* minimum_width,
                                                    gint* natural_width);
static void panther_panther_view_real_get_preferred_height (GtkWidget* base,
                                                     gint* minimum_height,
                                                     gint* natural_height);
static gboolean panther_panther_view_real_map_event (GtkWidget* base,
                                              GdkEventAny* event);
gboolean panther_panther_view_reset_avoid_show (PantherPantherView* self);
static gboolean __lambda54_ (PantherPantherView* self);
static gboolean ___lambda54__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                 GdkEventFocus* event,
                                                 gpointer self);
static void __lambda55_ (PantherPantherView* self);
static gboolean _panther_panther_view_reset_avoid_show_gsource_func (gpointer self);
static void ___lambda55__gtk_widget_hide (GtkWidget* _sender,
                                   gpointer self);
gboolean panther_panther_view_on_key_press (PantherPantherView* self,
                                            GdkEventKey* event);
static gboolean _panther_panther_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                        GdkEventKey* event,
                                                                        gpointer self);
static gboolean panther_panther_view_search_entry_key_press (PantherPantherView* self,
                                                      GdkEventKey* event);
static gboolean _panther_panther_view_search_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                  GdkEventKey* event,
                                                                                  gpointer self);
static void __lambda56_ (PantherPantherView* self,
                  GtkMenu* menu);
static void __lambda57_ (PantherPantherView* self);
static void ___lambda57__gtk_widget_hide (GtkWidget* _sender,
                                   gpointer self);
static void ___lambda56__gtk_entry_populate_popup (GtkEntry* _sender,
                                            GtkMenu* popup,
                                            gpointer self);
static void __lambda58_ (PantherPantherView* self);
static void ___lambda58__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                   gpointer self);
static void panther_panther_view_search_entry_activated (PantherPantherView* self);
static void _panther_panther_view_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                      gpointer self);
static void __lambda59_ (PantherPantherView* self);
static void ___lambda59__panther_widgets_search_view_app_launched (PantherWidgetsSearchView* _sender,
                                                            gpointer self);
void panther_panther_view_populate_grid_view (PantherPantherView* self);
static void __lambda60_ (PantherPantherView* self);
static void ___lambda60__panther_selector_mode_changed (PantherSelector* _sender,
                                                 gpointer self);
static void __lambda61_ (PantherPantherView* self);
static void ___lambda61__panther_settings_rows_changed (PantherSettings* _sender,
                                                 gpointer self);
static void __lambda62_ (PantherPantherView* self);
static void ___lambda62__panther_settings_columns_changed (PantherSettings* _sender,
                                                    gpointer self);
static void __lambda63_ (PantherPantherView* self);
void panther_widgets_category_view_setup_sidebar (PantherWidgetsCategoryView* self);
static void ___lambda63__panther_backend_app_system_changed (PantherBackendAppSystem* _sender,
                                                      gpointer self);
static void __lambda64_ (PantherPantherView* self);
void panther_panther_view_reposition (PantherPantherView* self);
static void ___lambda64__gdk_screen_size_changed (GdkScreen* _sender,
                                           gpointer self);
static void __lambda65_ (PantherPantherView* self);
static void ___lambda65__gdk_screen_monitors_changed (GdkScreen* _sender,
                                               gpointer self);
static void __lambda66_ (PantherPantherView* self);
static void ___lambda66__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
gboolean panther_settings_get_show_at_top (PantherSettings* self);
static void panther_panther_view_change_view_mode (PantherPantherView* self,
                                            const gchar* key);
gboolean panther_widgets_search_view_launch_selected (PantherWidgetsSearchView* self);
GType panther_widgets_app_entry_get_type (void) G_GNUC_CONST;
void panther_widgets_app_entry_launch_app (PantherWidgetsAppEntry* self);
void panther_widgets_grid_go_to_last (PantherWidgetsGrid* self);
void panther_widgets_grid_go_to_number (PantherWidgetsGrid* self,
                                        gint number);
GType panther_widgets_sidebar_get_type (void) G_GNUC_CONST;
GtkWidget* panther_widgets_grid_get_child_at (PantherWidgetsGrid* self,
                                              gint column,
                                              gint row);
static void panther_panther_view_move_left (PantherPantherView* self,
                                     GdkEventKey* event);
static void panther_panther_view_move_right (PantherPantherView* self,
                                      GdkEventKey* event);
static void panther_panther_view_normal_move_focus (PantherPantherView* self,
                                             gint delta_column,
                                             gint delta_row);
gint panther_widgets_sidebar_get_selected (PantherWidgetsSidebar* self);
void panther_widgets_sidebar_set_selected (PantherWidgetsSidebar* self,
                                           gint value);
static void panther_panther_view_top_left_focus (PantherPantherView* self);
static void panther_panther_view_category_move_focus (PantherPantherView* self,
                                               gint delta_column,
                                               gint delta_row);
void panther_widgets_search_view_up (PantherWidgetsSearchView* self);
void panther_widgets_search_view_down (PantherWidgetsSearchView* self);
void panther_widgets_grid_go_to_previous (PantherWidgetsGrid* self);
void panther_widgets_grid_go_to_next (PantherWidgetsGrid* self);
gint panther_widgets_sidebar_get_cat_size (PantherWidgetsSidebar* self);
static gboolean panther_panther_view_real_scroll_event (GtkWidget* base,
                                                 GdkEventScroll* event);
const gchar* gdk_scroll_direction_to_string (GdkScrollDirection self);
void panther_panther_view_show_panther (PantherPantherView* self);
void panther_settings_set_use_category (PantherSettings* self,
                                        gboolean value);
static void panther_panther_view_search_data_free (gpointer _data);
static void panther_panther_view_search_async_ready_wrapper (GObject *source_object,
                                                      GAsyncResult *res,
                                                      void *user_data);
static gboolean panther_panther_view_search_co (PantherPantherViewSearchData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda52_ (PantherPantherView* self);
static gboolean ____lambda52__gsource_func (gpointer self);
void synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                             SynapseMatch* value);
void panther_backend_synapse_search_search (PantherBackendSynapseSearch* self,
                                            const gchar* text,
                                            SynapseSearchProvider* provider,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
GeeList* panther_backend_synapse_search_search_finish (PantherBackendSynapseSearch* self,
                                                       GAsyncResult* _res_);
static void panther_panther_view_search_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static gboolean __lambda53_ (Block3Data* _data3_);
void panther_widgets_search_view_set_results (PantherWidgetsSearchView* self,
                                              GeeList* matches,
                                              const gchar* search_term);
static gboolean ___lambda53__gsource_func (gpointer self);
void panther_widgets_grid_clear (PantherWidgetsGrid* self);
GSList* panther_backend_app_system_get_apps_by_name (PantherBackendAppSystem* self);
PantherWidgetsAppEntry* panther_widgets_app_entry_new (PantherBackendApp* app);
PantherWidgetsAppEntry* panther_widgets_app_entry_construct (GType object_type,
                                                             PantherBackendApp* app);
static void ____lambda50_ (PantherPantherView* self);
static void _____lambda50__panther_widgets_app_entry_app_launched (PantherWidgetsAppEntry* _sender,
                                                            gpointer self);
void panther_widgets_grid_append (PantherWidgetsGrid* self,
                                  GtkWidget* widget);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
void panther_widgets_grid_resize (PantherWidgetsGrid* self,
                                  gint rows,
                                  gint columns);
void panther_widgets_category_view_show_filtered_apps (PantherWidgetsCategoryView* self,
                                                       const gchar* category);
gint panther_widgets_grid_get_page_columns (PantherWidgetsGrid* self);
gint panther_widgets_grid_get_current_page (PantherWidgetsGrid* self);
gint panther_widgets_grid_get_n_pages (PantherWidgetsGrid* self);
void panther_panther_view_reset_category_focus (PantherPantherView* self);
gint panther_panther_view_get_columns (PantherPantherView* self);
gint panther_panther_view_get_rows (PantherPantherView* self);
gint panther_widgets_grid_get_page_rows (PantherWidgetsGrid* self);
static void panther_panther_view_finalize (GObject * obj);
static void _vala_panther_panther_view_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);


GType
panther_modality_get_type (void)
{
	static volatile gsize panther_modality_type_id__volatile = 0;
	if (g_once_init_enter (&panther_modality_type_id__volatile)) {
		static const GEnumValue values[] = {{PANTHER_MODALITY_NORMAL_VIEW, "PANTHER_MODALITY_NORMAL_VIEW", "normal-view"}, {PANTHER_MODALITY_CATEGORY_VIEW, "PANTHER_MODALITY_CATEGORY_VIEW", "category-view"}, {PANTHER_MODALITY_SEARCH_VIEW, "PANTHER_MODALITY_SEARCH_VIEW", "search-view"}, {0, NULL, NULL}};
		GType panther_modality_type_id;
		panther_modality_type_id = g_enum_register_static ("PantherModality", values);
		g_once_init_leave (&panther_modality_type_id__volatile, panther_modality_type_id);
	}
	return panther_modality_type_id__volatile;
}


static inline gpointer
panther_selector_get_instance_private (PantherSelector* self)
{
	return G_STRUCT_MEMBER_P (self, PantherSelector_private_offset);
}


static gboolean
__lambda4_ (PantherSelector* self,
            GdkEventButton* bt)
{
	gboolean result = FALSE;
	g_return_val_if_fail (bt != NULL, FALSE);
	panther_selector_set_selector (self, 0);
	result = TRUE;
	return result;
}


static gboolean
___lambda4__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda4_ ((PantherSelector*) self, event);
	return result;
}


static gboolean
__lambda5_ (PantherSelector* self,
            GdkEventButton* bt)
{
	gboolean result = FALSE;
	g_return_val_if_fail (bt != NULL, FALSE);
	panther_selector_set_selector (self, 1);
	result = TRUE;
	return result;
}


static gboolean
___lambda5__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda5_ ((PantherSelector*) self, event);
	return result;
}


PantherSelector*
panther_selector_construct (GType object_type,
                            GtkOrientation orientation)
{
	PantherSelector * self = NULL;
	GtkToggleButton* _tmp0_;
	GtkImage* image = NULL;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkToggleButton* _tmp3_;
	GtkImage* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkToggleButton* _tmp9_;
	GtkImage* _tmp10_;
	GtkToggleButton* _tmp11_;
	GtkToggleButton* _tmp12_;
	GtkToggleButton* _tmp13_;
	self = (PantherSelector*) g_object_new (object_type, NULL);
	self->priv->_selected = -1;
	gtk_orientable_set_orientation ((GtkOrientable*) self, orientation);
	gtk_button_box_set_layout ((GtkButtonBox*) self, GTK_BUTTONBOX_START);
	_tmp0_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->view_all);
	self->priv->view_all = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("panther-icons-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = image;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("View as Grid"));
	_tmp3_ = self->priv->view_all;
	_tmp4_ = image;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->view_all;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->view_cats);
	self->priv->view_cats = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("panther-categories-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (image);
	image = _tmp7_;
	_tmp8_ = image;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("View by Category"));
	_tmp9_ = self->priv->view_cats;
	_tmp10_ = image;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->view_cats;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = self->priv->view_all;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "button-release-event", (GCallback) ___lambda4__gtk_widget_button_release_event, self, 0);
	_tmp13_ = self->priv->view_cats;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "button-release-event", (GCallback) ___lambda5__gtk_widget_button_release_event, self, 0);
	_g_object_unref0 (image);
	return self;
}


PantherSelector*
panther_selector_new (GtkOrientation orientation)
{
	return panther_selector_construct (PANTHER_TYPE_SELECTOR, orientation);
}


gint
panther_selector_get_selector (PantherSelector* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}


void
panther_selector_set_selector (PantherSelector* self,
                               gint v)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selected;
	if (_tmp0_ != v) {
		self->priv->_selected = v;
		switch (v) {
			case 0:
			{
				GtkToggleButton* _tmp1_;
				GtkToggleButton* _tmp2_;
				_tmp1_ = self->priv->view_all;
				gtk_toggle_button_set_active (_tmp1_, TRUE);
				_tmp2_ = self->priv->view_cats;
				gtk_toggle_button_set_active (_tmp2_, FALSE);
				break;
			}
			case 1:
			{
				GtkToggleButton* _tmp3_;
				GtkToggleButton* _tmp4_;
				_tmp3_ = self->priv->view_all;
				gtk_toggle_button_set_active (_tmp3_, FALSE);
				_tmp4_ = self->priv->view_cats;
				gtk_toggle_button_set_active (_tmp4_, TRUE);
				break;
			}
			default:
			break;
		}
		g_signal_emit (self, panther_selector_signals[PANTHER_SELECTOR_MODE_CHANGED_SIGNAL], 0);
	}
}


gint
panther_selector_get_selected (PantherSelector* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}


void
panther_selector_set_selected (PantherSelector* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	panther_selector_set_selector (self, value);
	g_object_notify_by_pspec ((GObject *) self, panther_selector_properties[PANTHER_SELECTOR_SELECTED_PROPERTY]);
}


static void
panther_selector_class_init (PantherSelectorClass * klass)
{
	panther_selector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantherSelector_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_panther_selector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_panther_selector_set_property;
	G_OBJECT_CLASS (klass)->finalize = panther_selector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_SELECTOR_SELECTED_PROPERTY, panther_selector_properties[PANTHER_SELECTOR_SELECTED_PROPERTY] = g_param_spec_int ("selected", "selected", "selected", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	panther_selector_signals[PANTHER_SELECTOR_MODE_CHANGED_SIGNAL] = g_signal_new ("mode-changed", PANTHER_TYPE_SELECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
panther_selector_instance_init (PantherSelector * self)
{
	self->priv = panther_selector_get_instance_private (self);
}


static void
panther_selector_finalize (GObject * obj)
{
	PantherSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHER_TYPE_SELECTOR, PantherSelector);
	_g_object_unref0 (self->priv->view_all);
	_g_object_unref0 (self->priv->view_cats);
	G_OBJECT_CLASS (panther_selector_parent_class)->finalize (obj);
}


GType
panther_selector_get_type (void)
{
	static volatile gsize panther_selector_type_id__volatile = 0;
	if (g_once_init_enter (&panther_selector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PantherSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panther_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantherSelector), 0, (GInstanceInitFunc) panther_selector_instance_init, NULL };
		GType panther_selector_type_id;
		panther_selector_type_id = g_type_register_static (gtk_button_box_get_type (), "PantherSelector", &g_define_type_info, 0);
		PantherSelector_private_offset = g_type_add_instance_private (panther_selector_type_id, sizeof (PantherSelectorPrivate));
		g_once_init_leave (&panther_selector_type_id__volatile, panther_selector_type_id);
	}
	return panther_selector_type_id__volatile;
}


static void
_vala_panther_selector_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PantherSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHER_TYPE_SELECTOR, PantherSelector);
	switch (property_id) {
		case PANTHER_SELECTOR_SELECTED_PROPERTY:
		g_value_set_int (value, panther_selector_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_panther_selector_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	PantherSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHER_TYPE_SELECTOR, PantherSelector);
	switch (property_id) {
		case PANTHER_SELECTOR_SELECTED_PROPERTY:
		panther_selector_set_selected (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
panther_panther_view_get_instance_private (PantherPantherView* self)
{
	return G_STRUCT_MEMBER_P (self, PantherPantherView_private_offset);
}


PantherPantherView*
panther_panther_view_construct (GType object_type)
{
	PantherPantherView * self = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkRectangle geometry = {0};
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	gint _tmp4_;
	GdkRectangle _tmp5_ = {0};
	PantherSettings* _tmp6_;
	PantherSettings* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	PantherSettings* _tmp21_;
	PantherSettings* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GtkIconTheme* _tmp36_;
	PantherBackendAppSystem* _tmp37_;
	PantherBackendSynapseSearch* _tmp38_;
	PantherBackendAppSystem* _tmp39_;
	GeeArrayList* _tmp40_;
	PantherBackendAppSystem* _tmp41_;
	GeeHashMap* _tmp42_;
	PantherSettings* _tmp43_;
	PantherSettings* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GdkRectangle _tmp47_;
	gint _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GdkRectangle _tmp51_;
	gint _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gboolean _tmp57_;
	self = (PantherPantherView*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	self->priv->primary_monitor = gdk_screen_get_primary_monitor (_tmp1_);
	_tmp2_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->primary_monitor;
	gdk_screen_get_monitor_geometry (_tmp3_, _tmp4_, &_tmp5_);
	geometry = _tmp5_;
	_tmp6_ = panther_panther_get_settings ();
	_tmp7_ = _tmp6_;
	_tmp8_ = panther_settings_get_rows_int (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 0) {
		PantherSettings* _tmp10_;
		PantherSettings* _tmp11_;
		GdkRectangle _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp10_ = panther_panther_get_settings ();
		_tmp11_ = _tmp10_;
		_tmp12_ = geometry;
		_tmp13_ = _tmp12_.height;
		_tmp14_ = panther_pixels_ITEM_SIZE;
		_tmp11_->rows = ((_tmp13_ * 5) / 9) / _tmp14_;
	} else {
		PantherSettings* _tmp15_;
		PantherSettings* _tmp16_;
		PantherSettings* _tmp17_;
		PantherSettings* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp15_ = panther_panther_get_settings ();
		_tmp16_ = _tmp15_;
		_tmp17_ = panther_panther_get_settings ();
		_tmp18_ = _tmp17_;
		_tmp19_ = panther_settings_get_rows_int (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_->rows = _tmp20_;
	}
	_tmp21_ = panther_panther_get_settings ();
	_tmp22_ = _tmp21_;
	_tmp23_ = panther_settings_get_columns_int (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == 0) {
		PantherSettings* _tmp25_;
		PantherSettings* _tmp26_;
		GdkRectangle _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp25_ = panther_panther_get_settings ();
		_tmp26_ = _tmp25_;
		_tmp27_ = geometry;
		_tmp28_ = _tmp27_.width;
		_tmp29_ = panther_pixels_ITEM_SIZE;
		_tmp26_->columns = ((_tmp28_ * 2) / 5) / _tmp29_;
	} else {
		PantherSettings* _tmp30_;
		PantherSettings* _tmp31_;
		PantherSettings* _tmp32_;
		PantherSettings* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp30_ = panther_panther_get_settings ();
		_tmp31_ = _tmp30_;
		_tmp32_ = panther_panther_get_settings ();
		_tmp33_ = _tmp32_;
		_tmp34_ = panther_settings_get_columns_int (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp31_->columns = _tmp35_;
	}
	gtk_window_set_title ((GtkWindow*) self, "Panther");
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_MENU);
	gtk_window_set_focus_on_map ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	self->priv->avoid_show = FALSE;
	panther_panther_view_read_settings (self, TRUE, TRUE, TRUE);
	_tmp36_ = gtk_icon_theme_get_default ();
	panther_panther_set_icon_theme (_tmp36_);
	_tmp37_ = panther_backend_app_system_new ();
	_g_object_unref0 (self->app_system);
	self->app_system = _tmp37_;
	_tmp38_ = panther_backend_synapse_search_new ();
	_g_object_unref0 (self->priv->synapse);
	self->priv->synapse = _tmp38_;
	_tmp39_ = self->app_system;
	_tmp40_ = panther_backend_app_system_get_categories (_tmp39_);
	_g_object_unref0 (self->priv->categories);
	self->priv->categories = _tmp40_;
	_tmp41_ = self->app_system;
	_tmp42_ = panther_backend_app_system_get_apps (_tmp41_);
	_g_object_unref0 (self->apps);
	self->apps = _tmp42_;
	_tmp43_ = panther_panther_get_settings ();
	_tmp44_ = _tmp43_;
	_tmp45_ = panther_settings_get_screen_resolution (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = geometry;
	_tmp48_ = _tmp47_.width;
	_tmp49_ = g_strdup_printf ("%i", _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = geometry;
	_tmp52_ = _tmp51_.height;
	_tmp53_ = g_strdup_printf ("%i", _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = g_strconcat (_tmp50_, "x", _tmp54_, NULL);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_strcmp0 (_tmp46_, _tmp56_) != 0;
	_g_free0 (_tmp56_);
	_g_free0 (_tmp54_);
	_g_free0 (_tmp50_);
	if (_tmp57_) {
		panther_panther_view_setup_size (self);
	}
	g_object_set ((GtkWidget*) self, "height-request", panther_panther_view_calculate_grid_height (self) + PANTHER_PIXELS_BOTTOM_SPACE, NULL);
	panther_panther_view_setup_ui (self);
	panther_panther_view_connect_signals (self);
	g_debug ("PantherView.vala:196: Apps loaded");
	return self;
}


PantherPantherView*
panther_panther_view_new (void)
{
	return panther_panther_view_construct (PANTHER_TYPE_PANTHER_VIEW);
}


gint
panther_panther_view_calculate_grid_height (PantherPantherView* self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->default_rows;
	_tmp1_ = panther_pixels_ITEM_SIZE;
	_tmp2_ = self->priv->default_rows;
	result = (gint) ((_tmp0_ * _tmp1_) + ((_tmp2_ - 1) * PANTHER_PIXELS_ROW_SPACING));
	return result;
}


gint
panther_panther_view_calculate_grid_width (PantherPantherView* self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->default_columns;
	_tmp1_ = panther_pixels_ITEM_SIZE;
	result = (((gint) _tmp0_) * _tmp1_) + 24;
	return result;
}


static void
panther_panther_view_setup_size (PantherPantherView* self)
{
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkRectangle geometry = {0};
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	gint _tmp4_;
	GdkRectangle _tmp5_ = {0};
	PantherSettings* _tmp6_;
	PantherSettings* _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GdkRectangle _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	PantherSettings* _tmp24_;
	PantherSettings* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	PantherSettings* _tmp31_;
	PantherSettings* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	g_return_if_fail (self != NULL);
	g_debug ("PantherView.vala:209: In setup_size ()");
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	self->priv->primary_monitor = gdk_screen_get_primary_monitor (_tmp1_);
	_tmp2_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->primary_monitor;
	gdk_screen_get_monitor_geometry (_tmp3_, _tmp4_, &_tmp5_);
	geometry = _tmp5_;
	_tmp6_ = panther_panther_get_settings ();
	_tmp7_ = _tmp6_;
	_tmp8_ = geometry;
	_tmp9_ = _tmp8_.width;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = geometry;
	_tmp13_ = _tmp12_.height;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp11_, "x", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	panther_settings_set_screen_resolution (_tmp7_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp11_);
	self->priv->default_columns = 6;
	self->priv->default_rows = 5;
	while (TRUE) {
		GdkRectangle _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp18_ = geometry;
		_tmp19_ = _tmp18_.width;
		if (!(panther_panther_view_calculate_grid_width (self) >= ((2 * _tmp19_) / 3))) {
			break;
		}
		_tmp20_ = self->priv->default_columns;
		self->priv->default_columns = _tmp20_ - 1;
	}
	while (TRUE) {
		GdkRectangle _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = geometry;
		_tmp22_ = _tmp21_.height;
		if (!(panther_panther_view_calculate_grid_height (self) >= ((2 * _tmp22_) / 3))) {
			break;
		}
		_tmp23_ = self->priv->default_rows;
		self->priv->default_rows = _tmp23_ - 1;
	}
	_tmp24_ = panther_panther_get_settings ();
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_->columns;
	_tmp27_ = self->priv->default_columns;
	if (_tmp26_ != _tmp27_) {
		PantherSettings* _tmp28_;
		PantherSettings* _tmp29_;
		gint _tmp30_;
		_tmp28_ = panther_panther_get_settings ();
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->default_columns;
		_tmp29_->columns = _tmp30_;
	}
	_tmp31_ = panther_panther_get_settings ();
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_->rows;
	_tmp34_ = self->priv->default_rows;
	if (_tmp33_ != _tmp34_) {
		PantherSettings* _tmp35_;
		PantherSettings* _tmp36_;
		gint _tmp37_;
		_tmp35_ = panther_panther_get_settings ();
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->default_rows;
		_tmp36_->rows = _tmp37_;
	}
}


static void
__lambda51_ (PantherPantherView* self,
             SynapseSearchMatch* match,
             SynapseMatch* target)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (match != NULL);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	panther_panther_view_search (self, _tmp2_, match, target, NULL, NULL);
}


static void
___lambda51__panther_widgets_search_view_start_search (PantherWidgetsSearchView* _sender,
                                                       SynapseSearchMatch* search_match,
                                                       SynapseMatch* target,
                                                       gpointer self)
{
	__lambda51_ ((PantherPantherView*) self, search_match, target);
}


static void
panther_panther_view_setup_ui (PantherPantherView* self)
{
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	PantherSelector* _tmp9_;
	PantherSelector* _tmp10_;
	PantherSelector* _tmp11_;
	GtkRevealer* _tmp12_;
	GtkRevealer* _tmp13_;
	GtkRevealer* _tmp14_;
	PantherSelector* _tmp15_;
	PantherSettings* _tmp16_;
	PantherSettings* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkSearchEntry* _tmp22_;
	GtkSearchEntry* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchEntry* _tmp26_;
	PantherSettings* _tmp27_;
	PantherSettings* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	GtkGrid* _tmp33_;
	GtkSearchEntry* _tmp34_;
	GtkStack* _tmp35_;
	GtkStack* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	PantherWidgetsGrid* _tmp39_;
	GtkStack* _tmp40_;
	PantherWidgetsGrid* _tmp41_;
	PantherWidgetsCategoryView* _tmp42_;
	GtkStack* _tmp43_;
	PantherWidgetsCategoryView* _tmp44_;
	PantherWidgetsSearchView* _tmp45_;
	PantherWidgetsSearchView* _tmp46_;
	PantherWidgetsSearchView* _tmp47_;
	GtkStack* _tmp48_;
	PantherWidgetsSearchView* _tmp49_;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkStack* _tmp53_;
	GtkFrame* _tmp54_;
	GtkFrame* _tmp55_;
	GtkGrid* _tmp56_;
	GtkEventBox* _tmp57_;
	GtkEventBox* _tmp58_;
	GtkFrame* _tmp59_;
	GtkEventBox* _tmp60_;
	PantherSettings* _tmp61_;
	PantherSettings* _tmp62_;
	gboolean _tmp63_;
	gboolean _tmp64_;
	g_return_if_fail (self != NULL);
	g_debug ("PantherView.vala:233: In setup_ui ()");
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->container);
	self->container = _tmp0_;
	_tmp1_ = self->container;
	gtk_grid_set_row_spacing (_tmp1_, 12);
	_tmp2_ = self->container;
	gtk_grid_set_row_homogeneous (_tmp2_, FALSE);
	_tmp3_ = self->container;
	gtk_grid_set_column_homogeneous (_tmp3_, FALSE);
	_tmp4_ = self->container;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->top);
	self->top = _tmp5_;
	_tmp6_ = self->top;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp6_, GTK_ORIENTATION_HORIZONTAL);
	_tmp7_ = self->top;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 6);
	_tmp8_ = self->top;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp8_, 6);
	_tmp9_ = panther_selector_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->view_selector);
	self->view_selector = _tmp9_;
	_tmp10_ = self->view_selector;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 6);
	_tmp11_ = self->view_selector;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 6);
	_tmp12_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->view_selector_revealer);
	self->priv->view_selector_revealer = _tmp12_;
	_tmp13_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp13_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp14_ = self->priv->view_selector_revealer;
	_tmp15_ = self->view_selector;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = panther_panther_get_settings ();
	_tmp17_ = _tmp16_;
	_tmp18_ = panther_settings_get_use_category (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		PantherSelector* _tmp20_;
		_tmp20_ = self->view_selector;
		panther_selector_set_selected (_tmp20_, 1);
	} else {
		PantherSelector* _tmp21_;
		_tmp21_ = self->view_selector;
		panther_selector_set_selected (_tmp21_, 0);
	}
	_tmp22_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp22_;
	_tmp23_ = self->search_entry;
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp23_, _ ("Search Apps"));
	_tmp24_ = self->search_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	_tmp25_ = self->search_entry;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp25_, 6);
	_tmp26_ = self->search_entry;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp26_, 6);
	_tmp27_ = panther_panther_get_settings ();
	_tmp28_ = _tmp27_;
	_tmp29_ = panther_settings_get_show_category_filter (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		GtkGrid* _tmp31_;
		GtkRevealer* _tmp32_;
		_tmp31_ = self->top;
		_tmp32_ = self->priv->view_selector_revealer;
		gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	}
	_tmp33_ = self->top;
	_tmp34_ = self->search_entry;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp35_;
	_tmp36_ = self->stack;
	gtk_stack_set_transition_type (_tmp36_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp37_ = self->priv->default_rows;
	_tmp38_ = self->priv->default_columns;
	_tmp39_ = panther_widgets_grid_new (_tmp37_, _tmp38_);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->grid_view);
	self->priv->grid_view = _tmp39_;
	_tmp40_ = self->stack;
	_tmp41_ = self->priv->grid_view;
	gtk_stack_add_named (_tmp40_, (GtkWidget*) _tmp41_, "normal");
	_tmp42_ = panther_widgets_category_view_new (self);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->category_view);
	self->priv->category_view = _tmp42_;
	_tmp43_ = self->stack;
	_tmp44_ = self->priv->category_view;
	gtk_stack_add_named (_tmp43_, (GtkWidget*) _tmp44_, "category");
	_tmp45_ = panther_widgets_search_view_new (self);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->search_view);
	self->priv->search_view = _tmp45_;
	_tmp46_ = self->priv->search_view;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp46_, 6);
	_tmp47_ = self->priv->search_view;
	g_signal_connect_object (_tmp47_, "start-search", (GCallback) ___lambda51__panther_widgets_search_view_start_search, self, 0);
	_tmp48_ = self->stack;
	_tmp49_ = self->priv->search_view;
	gtk_stack_add_named (_tmp48_, (GtkWidget*) _tmp49_, "search");
	_tmp50_ = self->container;
	_tmp51_ = self->top;
	gtk_grid_attach (_tmp50_, (GtkWidget*) _tmp51_, 0, 0, 1, 1);
	_tmp52_ = self->container;
	_tmp53_ = self->stack;
	gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 0, 1, 1, 1);
	_tmp54_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->fcontainer);
	self->fcontainer = _tmp54_;
	_tmp55_ = self->fcontainer;
	_tmp56_ = self->container;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->event_box);
	self->priv->event_box = _tmp57_;
	_tmp58_ = self->priv->event_box;
	_tmp59_ = self->fcontainer;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp60_);
	_tmp61_ = panther_panther_get_settings ();
	_tmp62_ = _tmp61_;
	_tmp63_ = panther_settings_get_use_category (_tmp62_);
	_tmp64_ = _tmp63_;
	if (_tmp64_) {
		panther_panther_view_set_modality (self, PANTHER_MODALITY_CATEGORY_VIEW);
	} else {
		panther_panther_view_set_modality (self, PANTHER_MODALITY_NORMAL_VIEW);
	}
	g_debug ("PantherView.vala:306: Ui setup completed");
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gboolean
___lambda25_ (PantherPantherView* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		panther_panther_view_grab_device (self);
	}
	result = FALSE;
	return result;
}


static gboolean
____lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda25_ ((PantherPantherView*) self);
	return result;
}


void
panther_panther_view_grab_device (PantherPantherView* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDevice* pointer = NULL;
	GdkDisplay* _tmp2_;
	GdkDeviceManager* _tmp3_;
	GdkDevice* _tmp4_;
	GdkDevice* _tmp5_;
	GdkDevice* keyboard = NULL;
	GdkDevice* _tmp6_;
	GdkDevice* _tmp7_;
	GdkDevice* _tmp8_;
	GdkDevice* _tmp9_;
	GdkGrabStatus keyboard_status = 0;
	gboolean _tmp10_ = FALSE;
	GdkDevice* _tmp11_;
	GdkGrabStatus pointer_status = 0;
	GdkDevice* _tmp17_;
	GdkWindow* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GdkGrabStatus _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = gdk_display_get_device_manager (_tmp2_);
	_tmp4_ = gdk_device_manager_get_client_pointer (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	pointer = _tmp5_;
	_tmp6_ = pointer;
	_tmp7_ = gdk_device_get_associated_device (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	keyboard = _tmp9_;
	keyboard_status = GDK_GRAB_SUCCESS;
	_tmp11_ = keyboard;
	if (_tmp11_ != NULL) {
		GdkDevice* _tmp12_;
		GdkInputSource _tmp13_;
		GdkInputSource _tmp14_;
		_tmp12_ = keyboard;
		g_object_get (_tmp12_, "input-source", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ == GDK_SOURCE_KEYBOARD;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GdkDevice* _tmp15_;
		GdkWindow* _tmp16_;
		_tmp15_ = keyboard;
		_tmp16_ = gtk_widget_get_window ((GtkWidget*) self);
		keyboard_status = gdk_device_grab (_tmp15_, _tmp16_, GDK_OWNERSHIP_NONE, TRUE, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	}
	_tmp17_ = pointer;
	_tmp18_ = gtk_widget_get_window ((GtkWidget*) self);
	pointer_status = gdk_device_grab (_tmp17_, _tmp18_, GDK_OWNERSHIP_NONE, TRUE, ((GDK_SMOOTH_SCROLL_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	_tmp20_ = pointer_status;
	if (_tmp20_ != GDK_GRAB_SUCCESS) {
		_tmp19_ = TRUE;
	} else {
		GdkGrabStatus _tmp21_;
		_tmp21_ = keyboard_status;
		_tmp19_ = _tmp21_ != GDK_GRAB_SUCCESS;
	}
	if (_tmp19_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda25__gsource_func, g_object_ref (self), g_object_unref);
	}
	_g_object_unref0 (keyboard);
	_g_object_unref0 (pointer);
	_g_object_unref0 (display);
}


static gboolean
panther_panther_view_real_button_press_event (GtkWidget* base,
                                              GdkEventButton* event)
{
	PantherPantherView * self;
	gboolean result = FALSE;
	GdkDevice* pointer = NULL;
	GdkDisplay* _tmp0_;
	GdkDeviceManager* _tmp1_;
	GdkDevice* _tmp2_;
	GdkDevice* _tmp3_;
	GdkDevice* _tmp4_;
	GdkWindow* _tmp5_;
	self = (PantherPantherView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_device_manager (_tmp0_);
	_tmp2_ = gdk_device_manager_get_client_pointer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	pointer = _tmp3_;
	_tmp4_ = pointer;
	_tmp5_ = gdk_device_get_window_at_position (_tmp4_, NULL, NULL);
	if (_tmp5_ == NULL) {
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (pointer);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (pointer);
	return result;
}


static void
panther_panther_view_real_get_preferred_width (GtkWidget* base,
                                               gint* minimum_width,
                                               gint* natural_width)
{
	PantherPantherView * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	GtkEventBox* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (PantherPantherView*) base;
	_tmp0_ = self->priv->event_box;
	gtk_widget_get_preferred_width ((GtkWidget*) _tmp0_, &_tmp1_, &_tmp2_);
	_vala_minimum_width = _tmp1_;
	_vala_natural_width = _tmp2_;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void
panther_panther_view_real_get_preferred_height (GtkWidget* base,
                                                gint* minimum_height,
                                                gint* natural_height)
{
	PantherPantherView * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	GtkEventBox* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (PantherPantherView*) base;
	_tmp0_ = self->priv->event_box;
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp0_, &_tmp1_, &_tmp2_);
	_vala_minimum_height = _tmp1_;
	_vala_natural_height = _tmp2_;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static gboolean
panther_panther_view_real_map_event (GtkWidget* base,
                                     GdkEventAny* event)
{
	PantherPantherView * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (PantherPantherView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		panther_panther_view_grab_device (self);
	}
	result = FALSE;
	return result;
}


gboolean
panther_panther_view_reset_avoid_show (PantherPantherView* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->avoid_show = FALSE;
	result = FALSE;
	return result;
}


static gboolean
__lambda54_ (PantherPantherView* self)
{
	gboolean result = FALSE;
	GtkSearchEntry* _tmp0_;
	_tmp0_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean
___lambda54__gtk_widget_focus_in_event (GtkWidget* _sender,
                                        GdkEventFocus* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda54_ ((PantherPantherView*) self);
	return result;
}


static gboolean
_panther_panther_view_reset_avoid_show_gsource_func (gpointer self)
{
	gboolean result;
	result = panther_panther_view_reset_avoid_show ((PantherPantherView*) self);
	return result;
}


static void
__lambda55_ (PantherPantherView* self)
{
	self->priv->avoid_show = TRUE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _panther_panther_view_reset_avoid_show_gsource_func, g_object_ref (self), g_object_unref);
}


static void
___lambda55__gtk_widget_hide (GtkWidget* _sender,
                              gpointer self)
{
	__lambda55_ ((PantherPantherView*) self);
}


static gboolean
_panther_panther_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                               GdkEventKey* event,
                                                               gpointer self)
{
	gboolean result;
	result = panther_panther_view_on_key_press ((PantherPantherView*) self, event);
	return result;
}


static gboolean
_panther_panther_view_search_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                         GdkEventKey* event,
                                                                         gpointer self)
{
	gboolean result;
	result = panther_panther_view_search_entry_key_press ((PantherPantherView*) self, event);
	return result;
}


static void
__lambda57_ (PantherPantherView* self)
{
	panther_panther_view_grab_device (self);
}


static void
___lambda57__gtk_widget_hide (GtkWidget* _sender,
                              gpointer self)
{
	__lambda57_ ((PantherPantherView*) self);
}


static void
__lambda56_ (PantherPantherView* self,
             GtkMenu* menu)
{
	g_return_if_fail (menu != NULL);
	g_signal_connect_object ((GtkWidget*) menu, "hide", (GCallback) ___lambda57__gtk_widget_hide, self, 0);
}


static void
___lambda56__gtk_entry_populate_popup (GtkEntry* _sender,
                                       GtkMenu* popup,
                                       gpointer self)
{
	__lambda56_ ((PantherPantherView*) self, popup);
}


static void
__lambda58_ (PantherPantherView* self)
{
	PantherModality _tmp0_;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->modality;
	if (_tmp0_ != PANTHER_MODALITY_SEARCH_VIEW) {
		panther_panther_view_set_modality (self, PANTHER_MODALITY_SEARCH_VIEW);
	}
	_tmp1_ = self->search_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	panther_panther_view_search (self, _tmp3_, NULL, NULL, NULL, NULL);
}


static void
___lambda58__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                              gpointer self)
{
	__lambda58_ ((PantherPantherView*) self);
}


static void
_panther_panther_view_search_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                 gpointer self)
{
	panther_panther_view_search_entry_activated ((PantherPantherView*) self);
}


static void
__lambda59_ (PantherPantherView* self)
{
	gtk_widget_hide ((GtkWidget*) self);
}


static void
___lambda59__panther_widgets_search_view_app_launched (PantherWidgetsSearchView* _sender,
                                                       gpointer self)
{
	__lambda59_ ((PantherPantherView*) self);
}


static void
__lambda60_ (PantherPantherView* self)
{
	PantherSelector* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->view_selector;
	_tmp1_ = panther_selector_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	panther_panther_view_set_modality (self, (PantherModality) _tmp2_);
}


static void
___lambda60__panther_selector_mode_changed (PantherSelector* _sender,
                                            gpointer self)
{
	__lambda60_ ((PantherPantherView*) self);
}


static void
__lambda61_ (PantherPantherView* self)
{
	panther_panther_view_read_settings (self, FALSE, FALSE, TRUE);
}


static void
___lambda61__panther_settings_rows_changed (PantherSettings* _sender,
                                            gpointer self)
{
	__lambda61_ ((PantherPantherView*) self);
}


static void
__lambda62_ (PantherPantherView* self)
{
	panther_panther_view_read_settings (self, FALSE, FALSE, TRUE);
}


static void
___lambda62__panther_settings_columns_changed (PantherSettings* _sender,
                                               gpointer self)
{
	__lambda62_ ((PantherPantherView*) self);
}


static void
__lambda63_ (PantherPantherView* self)
{
	PantherBackendAppSystem* _tmp0_;
	GeeArrayList* _tmp1_;
	PantherBackendAppSystem* _tmp2_;
	GeeHashMap* _tmp3_;
	PantherWidgetsCategoryView* _tmp4_;
	_tmp0_ = self->app_system;
	_tmp1_ = panther_backend_app_system_get_categories (_tmp0_);
	_g_object_unref0 (self->priv->categories);
	self->priv->categories = _tmp1_;
	_tmp2_ = self->app_system;
	_tmp3_ = panther_backend_app_system_get_apps (_tmp2_);
	_g_object_unref0 (self->apps);
	self->apps = _tmp3_;
	panther_panther_view_populate_grid_view (self);
	_tmp4_ = self->priv->category_view;
	panther_widgets_category_view_setup_sidebar (_tmp4_);
}


static void
___lambda63__panther_backend_app_system_changed (PantherBackendAppSystem* _sender,
                                                 gpointer self)
{
	__lambda63_ ((PantherPantherView*) self);
}


static void
__lambda64_ (PantherPantherView* self)
{
	GdkRectangle geometry = {0};
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GdkRectangle _tmp4_ = {0};
	PantherSettings* _tmp5_;
	PantherSettings* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp3_ = _tmp2_;
	gdk_screen_get_monitor_geometry (_tmp1_, gdk_screen_get_primary_monitor (_tmp3_), &_tmp4_);
	geometry = _tmp4_;
	_tmp5_ = panther_panther_get_settings ();
	_tmp6_ = _tmp5_;
	_tmp7_ = panther_settings_get_screen_resolution (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = geometry;
	_tmp10_ = _tmp9_.width;
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = geometry;
	_tmp14_ = _tmp13_.height;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp12_, "x", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strcmp0 (_tmp8_, _tmp18_) != 0;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
	if (_tmp19_) {
		panther_panther_view_setup_size (self);
	}
	panther_panther_view_reposition (self);
}


static void
___lambda64__gdk_screen_size_changed (GdkScreen* _sender,
                                      gpointer self)
{
	__lambda64_ ((PantherPantherView*) self);
}


static void
__lambda65_ (PantherPantherView* self)
{
	panther_panther_view_reposition (self);
}


static void
___lambda65__gdk_screen_monitors_changed (GdkScreen* _sender,
                                          gpointer self)
{
	__lambda65_ ((PantherPantherView*) self);
}


static void
__lambda66_ (PantherPantherView* self)
{
	panther_panther_view_reposition (self);
}


static void
___lambda66__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda66_ ((PantherPantherView*) self);
}


static void
panther_panther_view_connect_signals (PantherPantherView* self)
{
	GtkEventBox* _tmp0_;
	GtkSearchEntry* _tmp1_;
	GtkSearchEntry* _tmp2_;
	GtkSearchEntry* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkSearchEntry* _tmp5_;
	PantherWidgetsSearchView* _tmp6_;
	PantherSelector* _tmp7_;
	PantherSettings* _tmp8_;
	PantherSettings* _tmp9_;
	PantherSettings* _tmp10_;
	PantherSettings* _tmp11_;
	PantherBackendAppSystem* _tmp12_;
	GdkScreen* _tmp13_;
	GdkScreen* _tmp14_;
	GdkScreen* _tmp15_;
	GdkScreen* _tmp16_;
	GtkStyleContext* _tmp17_;
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) ___lambda54__gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) ___lambda55__gtk_widget_hide, self, 0);
	_tmp0_ = self->priv->event_box;
	g_signal_connect_object ((GtkWidget*) _tmp0_, "key-press-event", (GCallback) _panther_panther_view_on_key_press_gtk_widget_key_press_event, self, 0);
	_tmp1_ = self->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "key-press-event", (GCallback) _panther_panther_view_search_entry_key_press_gtk_widget_key_press_event, self, 0);
	_tmp2_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp2_, "populate-popup", (GCallback) ___lambda56__gtk_entry_populate_popup, self, 0);
	_tmp3_ = self->search_entry;
	g_signal_connect_object (_tmp3_, "search-changed", (GCallback) ___lambda58__gtk_search_entry_search_changed, self, 0);
	_tmp4_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	_tmp5_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp5_, "activate", (GCallback) _panther_panther_view_search_entry_activated_gtk_entry_activate, self, 0);
	_tmp6_ = self->priv->search_view;
	g_signal_connect_object (_tmp6_, "app-launched", (GCallback) ___lambda59__panther_widgets_search_view_app_launched, self, 0);
	panther_panther_view_populate_grid_view (self);
	_tmp7_ = self->view_selector;
	g_signal_connect_object (_tmp7_, "mode-changed", (GCallback) ___lambda60__panther_selector_mode_changed, self, 0);
	_tmp8_ = panther_panther_get_settings ();
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "rows-changed", (GCallback) ___lambda61__panther_settings_rows_changed, self, 0);
	_tmp10_ = panther_panther_get_settings ();
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "columns-changed", (GCallback) ___lambda62__panther_settings_columns_changed, self, 0);
	_tmp12_ = self->app_system;
	g_signal_connect_object (_tmp12_, "changed", (GCallback) ___lambda63__panther_backend_app_system_changed, self, 0);
	_tmp13_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "size-changed", (GCallback) ___lambda64__gdk_screen_size_changed, self, 0);
	_tmp15_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp16_ = _tmp15_;
	g_signal_connect_object (_tmp16_, "monitors-changed", (GCallback) ___lambda65__gdk_screen_monitors_changed, self, 0);
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) self);
	g_signal_connect_object ((GObject*) _tmp17_, "notify::direction", (GCallback) ___lambda66__g_object_notify, self, 0);
	self->priv->can_trigger_hotcorner = FALSE;
}


void
panther_panther_view_reposition (PantherPantherView* self)
{
	GdkRectangle workspace_area = {0};
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gint new_y = 0;
	PantherSettings* _tmp4_;
	PantherSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkStyleContext* _tmp15_;
	GtkTextDirection _tmp16_;
	GtkTextDirection _tmp17_;
	g_return_if_fail (self != NULL);
	g_debug ("PantherView.vala:445: Repositioning");
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	gdk_screen_get_monitor_workarea (_tmp0_, gdk_screen_get_primary_monitor (_tmp2_), &_tmp3_);
	workspace_area = _tmp3_;
	_tmp4_ = panther_panther_get_settings ();
	_tmp5_ = _tmp4_;
	_tmp6_ = panther_settings_get_show_at_top (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GdkRectangle _tmp8_;
		gint _tmp9_;
		_tmp8_ = workspace_area;
		_tmp9_ = _tmp8_.y;
		new_y = _tmp9_;
	} else {
		GdkRectangle _tmp10_;
		gint _tmp11_;
		GdkRectangle _tmp12_;
		gint _tmp13_;
		GdkWindow* _tmp14_;
		_tmp10_ = workspace_area;
		_tmp11_ = _tmp10_.y;
		_tmp12_ = workspace_area;
		_tmp13_ = _tmp12_.height;
		_tmp14_ = gtk_widget_get_window ((GtkWidget*) self);
		new_y = (_tmp11_ + _tmp13_) - gdk_window_get_height (_tmp14_);
	}
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp16_ = gtk_style_context_get_direction (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == GTK_TEXT_DIR_LTR) {
		GdkRectangle _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp18_ = workspace_area;
		_tmp19_ = _tmp18_.x;
		_tmp20_ = new_y;
		gtk_window_move ((GtkWindow*) self, _tmp19_, _tmp20_);
	} else {
		GdkRectangle _tmp21_;
		gint _tmp22_;
		GdkRectangle _tmp23_;
		gint _tmp24_;
		GdkWindow* _tmp25_;
		gint _tmp26_;
		_tmp21_ = workspace_area;
		_tmp22_ = _tmp21_.x;
		_tmp23_ = workspace_area;
		_tmp24_ = _tmp23_.width;
		_tmp25_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp26_ = new_y;
		gtk_window_move ((GtkWindow*) self, (_tmp22_ + _tmp24_) - gdk_window_get_width (_tmp25_), _tmp26_);
	}
}


static void
panther_panther_view_change_view_mode (PantherPantherView* self,
                                       const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("1")))) {
		switch (0) {
			default:
			{
				PantherSelector* _tmp3_;
				_tmp3_ = self->view_selector;
				panther_selector_set_selected (_tmp3_, 0);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				PantherSelector* _tmp4_;
				_tmp4_ = self->view_selector;
				panther_selector_set_selected (_tmp4_, 1);
				break;
			}
		}
	}
}


static gboolean
panther_panther_view_search_entry_key_press (PantherPantherView* self,
                                             GdkEventKey* event)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event->keyval;
	if (_tmp1_ == GDK_KEY_space) {
		GdkModifierType _tmp2_;
		_tmp2_ = event->state;
		_tmp0_ = (_tmp2_ & GDK_SUPER_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		return result;
	}
	_tmp3_ = event->keyval;
	switch (_tmp3_) {
		case GDK_KEY_Tab:
		{
			result = TRUE;
			return result;
			break;
		}
		case GDK_KEY_Escape:
		{
			GtkSearchEntry* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp4_ = self->search_entry;
			_tmp5_ = gtk_entry_get_text ((GtkEntry*) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ > 0) {
				GtkSearchEntry* _tmp9_;
				_tmp9_ = self->search_entry;
				gtk_entry_set_text ((GtkEntry*) _tmp9_, "");
			} else {
				gtk_widget_hide ((GtkWidget*) self);
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


static void
panther_panther_view_search_entry_activated (PantherPantherView* self)
{
	PantherModality _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->modality;
	if (_tmp0_ == PANTHER_MODALITY_SEARCH_VIEW) {
		PantherWidgetsSearchView* _tmp1_;
		_tmp1_ = self->priv->search_view;
		if (panther_widgets_search_view_launch_selected (_tmp1_)) {
			gtk_widget_hide ((GtkWidget*) self);
		}
	} else {
		GtkWidget* _tmp2_;
		_tmp2_ = gtk_window_get_focus ((GtkWindow*) self);
		if ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, PANTHER_WIDGETS_TYPE_APP_ENTRY) ? ((PantherWidgetsAppEntry*) _tmp2_) : NULL) != NULL) {
			GtkWidget* _tmp3_;
			_tmp3_ = gtk_window_get_focus ((GtkWindow*) self);
			panther_widgets_app_entry_launch_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PANTHER_WIDGETS_TYPE_APP_ENTRY, PantherWidgetsAppEntry));
		}
	}
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch16_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch16_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally16;
	__catch16_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gboolean
panther_panther_view_on_key_press (PantherPantherView* self,
                                   GdkEventKey* event)
{
	gboolean result = FALSE;
	gchar* key = NULL;
	guint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GdkModifierType _tmp3_;
	gboolean _tmp4_ = FALSE;
	GdkModifierType _tmp5_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GQuark _tmp13_ = 0U;
	static GQuark _tmp12_label0 = 0;
	static GQuark _tmp12_label1 = 0;
	static GQuark _tmp12_label2 = 0;
	static GQuark _tmp12_label3 = 0;
	static GQuark _tmp12_label4 = 0;
	static GQuark _tmp12_label5 = 0;
	static GQuark _tmp12_label6 = 0;
	static GQuark _tmp12_label7 = 0;
	static GQuark _tmp12_label8 = 0;
	static GQuark _tmp12_label9 = 0;
	static GQuark _tmp12_label10 = 0;
	static GQuark _tmp12_label11 = 0;
	static GQuark _tmp12_label12 = 0;
	static GQuark _tmp12_label13 = 0;
	static GQuark _tmp12_label14 = 0;
	static GQuark _tmp12_label15 = 0;
	static GQuark _tmp12_label16 = 0;
	static GQuark _tmp12_label17 = 0;
	static GQuark _tmp12_label18 = 0;
	static GQuark _tmp12_label19 = 0;
	static GQuark _tmp12_label20 = 0;
	static GQuark _tmp12_label21 = 0;
	static GQuark _tmp12_label22 = 0;
	static GQuark _tmp12_label23 = 0;
	static GQuark _tmp12_label24 = 0;
	static GQuark _tmp12_label25 = 0;
	static GQuark _tmp12_label26 = 0;
	static GQuark _tmp12_label27 = 0;
	static GQuark _tmp12_label28 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->keyval;
	_tmp1_ = gdk_keyval_name (_tmp0_);
	_tmp2_ = string_replace (_tmp1_, "KP_", "");
	key = _tmp2_;
	_tmp3_ = event->state;
	event->state = _tmp3_ & ((GDK_SHIFT_MASK | GDK_MOD1_MASK) | GDK_CONTROL_MASK);
	_tmp5_ = event->state;
	if ((_tmp5_ & GDK_CONTROL_MASK) != 0) {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = key;
		if (g_strcmp0 (_tmp7_, "1") == 0) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = key;
			_tmp6_ = g_strcmp0 (_tmp8_, "2") == 0;
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = key;
		panther_panther_view_change_view_mode (self, _tmp9_);
		result = TRUE;
		_g_free0 (key);
		return result;
	}
	_tmp10_ = key;
	_tmp11_ = _tmp10_;
	_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
	if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("F4")))) {
		switch (0) {
			default:
			{
				GdkModifierType _tmp14_;
				_tmp14_ = event->state;
				if ((_tmp14_ & GDK_MOD1_MASK) != 0) {
					gtk_widget_hide ((GtkWidget*) self);
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("Escape")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				_tmp15_ = self->search_entry;
				_tmp16_ = gtk_entry_get_text ((GtkEntry*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = strlen (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ > 0) {
					GtkSearchEntry* _tmp20_;
					_tmp20_ = self->search_entry;
					gtk_entry_set_text ((GtkEntry*) _tmp20_, "");
				} else {
					gtk_widget_hide ((GtkWidget*) self);
				}
				result = TRUE;
				_g_free0 (key);
				return result;
			}
		}
	} else if (((_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("Enter")))) || (_tmp13_ == ((0 != _tmp12_label3) ? _tmp12_label3 : (_tmp12_label3 = g_quark_from_static_string ("Return"))))) || (_tmp13_ == ((0 != _tmp12_label4) ? _tmp12_label4 : (_tmp12_label4 = g_quark_from_static_string ("KP_Enter"))))) {
		switch (0) {
			default:
			{
				PantherModality _tmp21_;
				_tmp21_ = self->priv->modality;
				if (_tmp21_ == PANTHER_MODALITY_SEARCH_VIEW) {
					PantherWidgetsSearchView* _tmp22_;
					_tmp22_ = self->priv->search_view;
					if (panther_widgets_search_view_launch_selected (_tmp22_)) {
						gtk_widget_hide ((GtkWidget*) self);
					}
				} else {
					GtkWidget* _tmp23_;
					_tmp23_ = gtk_window_get_focus ((GtkWindow*) self);
					if ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, PANTHER_WIDGETS_TYPE_APP_ENTRY) ? ((PantherWidgetsAppEntry*) _tmp23_) : NULL) != NULL) {
						GtkWidget* _tmp24_;
						_tmp24_ = gtk_window_get_focus ((GtkWindow*) self);
						panther_widgets_app_entry_launch_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, PANTHER_WIDGETS_TYPE_APP_ENTRY, PantherWidgetsAppEntry));
					}
				}
				result = TRUE;
				_g_free0 (key);
				return result;
			}
		}
	} else if ((_tmp13_ == ((0 != _tmp12_label5) ? _tmp12_label5 : (_tmp12_label5 = g_quark_from_static_string ("Alt_L")))) || (_tmp13_ == ((0 != _tmp12_label6) ? _tmp12_label6 : (_tmp12_label6 = g_quark_from_static_string ("Alt_R"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((((((((((_tmp13_ == ((0 != _tmp12_label7) ? _tmp12_label7 : (_tmp12_label7 = g_quark_from_static_string ("0")))) || (_tmp13_ == ((0 != _tmp12_label8) ? _tmp12_label8 : (_tmp12_label8 = g_quark_from_static_string ("1"))))) || (_tmp13_ == ((0 != _tmp12_label9) ? _tmp12_label9 : (_tmp12_label9 = g_quark_from_static_string ("2"))))) || (_tmp13_ == ((0 != _tmp12_label10) ? _tmp12_label10 : (_tmp12_label10 = g_quark_from_static_string ("3"))))) || (_tmp13_ == ((0 != _tmp12_label11) ? _tmp12_label11 : (_tmp12_label11 = g_quark_from_static_string ("4"))))) || (_tmp13_ == ((0 != _tmp12_label12) ? _tmp12_label12 : (_tmp12_label12 = g_quark_from_static_string ("5"))))) || (_tmp13_ == ((0 != _tmp12_label13) ? _tmp12_label13 : (_tmp12_label13 = g_quark_from_static_string ("6"))))) || (_tmp13_ == ((0 != _tmp12_label14) ? _tmp12_label14 : (_tmp12_label14 = g_quark_from_static_string ("7"))))) || (_tmp13_ == ((0 != _tmp12_label15) ? _tmp12_label15 : (_tmp12_label15 = g_quark_from_static_string ("8"))))) || (_tmp13_ == ((0 != _tmp12_label16) ? _tmp12_label16 : (_tmp12_label16 = g_quark_from_static_string ("9"))))) {
		switch (0) {
			default:
			{
				gint page = 0;
				const gchar* _tmp25_;
				GdkModifierType _tmp26_;
				PantherModality _tmp27_;
				GtkSearchEntry* _tmp43_;
				_tmp25_ = key;
				page = atoi (_tmp25_);
				_tmp26_ = event->state;
				if (_tmp26_ != GDK_MOD1_MASK) {
					result = FALSE;
					_g_free0 (key);
					return result;
				}
				_tmp27_ = self->priv->modality;
				if (_tmp27_ == PANTHER_MODALITY_NORMAL_VIEW) {
					gboolean _tmp28_ = FALSE;
					gint _tmp29_;
					_tmp29_ = page;
					if (_tmp29_ < 0) {
						_tmp28_ = TRUE;
					} else {
						gint _tmp30_;
						_tmp30_ = page;
						_tmp28_ = _tmp30_ == 9;
					}
					if (_tmp28_) {
						PantherWidgetsGrid* _tmp31_;
						_tmp31_ = self->priv->grid_view;
						panther_widgets_grid_go_to_last (_tmp31_);
					} else {
						PantherWidgetsGrid* _tmp32_;
						gint _tmp33_;
						_tmp32_ = self->priv->grid_view;
						_tmp33_ = page;
						panther_widgets_grid_go_to_number (_tmp32_, _tmp33_);
					}
				} else {
					PantherModality _tmp34_;
					_tmp34_ = self->priv->modality;
					if (_tmp34_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						gboolean _tmp35_ = FALSE;
						gint _tmp36_;
						_tmp36_ = page;
						if (_tmp36_ < 0) {
							_tmp35_ = TRUE;
						} else {
							gint _tmp37_;
							_tmp37_ = page;
							_tmp35_ = _tmp37_ == 9;
						}
						if (_tmp35_) {
							PantherWidgetsCategoryView* _tmp38_;
							PantherWidgetsGrid* _tmp39_;
							_tmp38_ = self->priv->category_view;
							_tmp39_ = _tmp38_->app_view;
							panther_widgets_grid_go_to_last (_tmp39_);
						} else {
							PantherWidgetsCategoryView* _tmp40_;
							PantherWidgetsGrid* _tmp41_;
							gint _tmp42_;
							_tmp40_ = self->priv->category_view;
							_tmp41_ = _tmp40_->app_view;
							_tmp42_ = page;
							panther_widgets_grid_go_to_number (_tmp41_, _tmp42_);
						}
					} else {
						result = FALSE;
						_g_free0 (key);
						return result;
					}
				}
				_tmp43_ = self->search_entry;
				gtk_widget_grab_focus ((GtkWidget*) _tmp43_);
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label17) ? _tmp12_label17 : (_tmp12_label17 = g_quark_from_static_string ("Tab")))) {
		switch (0) {
			default:
			{
				PantherModality _tmp44_;
				_tmp44_ = self->priv->modality;
				if (_tmp44_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherSelector* _tmp45_;
					GtkWidget* new_focus = NULL;
					PantherWidgetsCategoryView* _tmp46_;
					PantherWidgetsGrid* _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					GtkWidget* _tmp50_;
					GtkWidget* _tmp51_;
					_tmp45_ = self->view_selector;
					panther_selector_set_selected (_tmp45_, 1);
					_tmp46_ = self->priv->category_view;
					_tmp47_ = _tmp46_->app_view;
					_tmp48_ = self->priv->category_column_focus;
					_tmp49_ = self->priv->category_row_focus;
					_tmp50_ = panther_widgets_grid_get_child_at (_tmp47_, _tmp48_, _tmp49_);
					new_focus = _tmp50_;
					_tmp51_ = new_focus;
					if (_tmp51_ != NULL) {
						GtkWidget* _tmp52_;
						_tmp52_ = new_focus;
						gtk_widget_grab_focus (_tmp52_);
					}
					_g_object_unref0 (new_focus);
				} else {
					PantherModality _tmp53_;
					_tmp53_ = self->priv->modality;
					if (_tmp53_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherSelector* _tmp54_;
						GtkWidget* new_focus = NULL;
						PantherWidgetsGrid* _tmp55_;
						gint _tmp56_;
						gint _tmp57_;
						GtkWidget* _tmp58_;
						GtkWidget* _tmp59_;
						_tmp54_ = self->view_selector;
						panther_selector_set_selected (_tmp54_, 0);
						_tmp55_ = self->priv->grid_view;
						_tmp56_ = self->priv->column_focus;
						_tmp57_ = self->priv->row_focus;
						_tmp58_ = panther_widgets_grid_get_child_at (_tmp55_, _tmp56_, _tmp57_);
						new_focus = _tmp58_;
						_tmp59_ = new_focus;
						if (_tmp59_ != NULL) {
							GtkWidget* _tmp60_;
							_tmp60_ = new_focus;
							gtk_widget_grab_focus (_tmp60_);
						}
						_g_object_unref0 (new_focus);
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label18) ? _tmp12_label18 : (_tmp12_label18 = g_quark_from_static_string ("Left")))) {
		switch (0) {
			default:
			{
				gboolean _tmp61_ = FALSE;
				PantherModality _tmp62_;
				GtkStyleContext* _tmp64_;
				GtkTextDirection _tmp65_;
				GtkTextDirection _tmp66_;
				_tmp62_ = self->priv->modality;
				if (_tmp62_ != PANTHER_MODALITY_NORMAL_VIEW) {
					PantherModality _tmp63_;
					_tmp63_ = self->priv->modality;
					_tmp61_ = _tmp63_ != PANTHER_MODALITY_CATEGORY_VIEW;
				} else {
					_tmp61_ = FALSE;
				}
				if (_tmp61_) {
					result = FALSE;
					_g_free0 (key);
					return result;
				}
				_tmp64_ = gtk_widget_get_style_context ((GtkWidget*) self);
				_tmp65_ = gtk_style_context_get_direction (_tmp64_);
				_tmp66_ = _tmp65_;
				if (_tmp66_ == GTK_TEXT_DIR_LTR) {
					panther_panther_view_move_left (self, event);
				} else {
					panther_panther_view_move_right (self, event);
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label19) ? _tmp12_label19 : (_tmp12_label19 = g_quark_from_static_string ("Right")))) {
		switch (0) {
			default:
			{
				gboolean _tmp67_ = FALSE;
				PantherModality _tmp68_;
				GtkStyleContext* _tmp70_;
				GtkTextDirection _tmp71_;
				GtkTextDirection _tmp72_;
				_tmp68_ = self->priv->modality;
				if (_tmp68_ != PANTHER_MODALITY_NORMAL_VIEW) {
					PantherModality _tmp69_;
					_tmp69_ = self->priv->modality;
					_tmp67_ = _tmp69_ != PANTHER_MODALITY_CATEGORY_VIEW;
				} else {
					_tmp67_ = FALSE;
				}
				if (_tmp67_) {
					result = FALSE;
					_g_free0 (key);
					return result;
				}
				_tmp70_ = gtk_widget_get_style_context ((GtkWidget*) self);
				_tmp71_ = gtk_style_context_get_direction (_tmp70_);
				_tmp72_ = _tmp71_;
				if (_tmp72_ == GTK_TEXT_DIR_LTR) {
					panther_panther_view_move_right (self, event);
				} else {
					panther_panther_view_move_left (self, event);
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label20) ? _tmp12_label20 : (_tmp12_label20 = g_quark_from_static_string ("Up")))) {
		switch (0) {
			default:
			{
				PantherModality _tmp73_;
				_tmp73_ = self->priv->modality;
				if (_tmp73_ == PANTHER_MODALITY_NORMAL_VIEW) {
					panther_panther_view_normal_move_focus (self, 0, -1);
				} else {
					PantherModality _tmp74_;
					_tmp74_ = self->priv->modality;
					if (_tmp74_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						GdkModifierType _tmp75_;
						_tmp75_ = event->state;
						if (_tmp75_ == GDK_SHIFT_MASK) {
							PantherWidgetsCategoryView* _tmp76_;
							PantherWidgetsSidebar* _tmp77_;
							gint _tmp78_;
							gint _tmp79_;
							_tmp76_ = self->priv->category_view;
							_tmp77_ = _tmp76_->category_switcher;
							_tmp78_ = panther_widgets_sidebar_get_selected (_tmp77_);
							_tmp79_ = _tmp78_;
							if (_tmp79_ != 0) {
								PantherWidgetsCategoryView* _tmp80_;
								PantherWidgetsSidebar* _tmp81_;
								gint _tmp82_;
								gint _tmp83_;
								_tmp80_ = self->priv->category_view;
								_tmp81_ = _tmp80_->category_switcher;
								_tmp82_ = panther_widgets_sidebar_get_selected (_tmp81_);
								_tmp83_ = _tmp82_;
								panther_widgets_sidebar_set_selected (_tmp81_, _tmp83_ - 1);
								panther_panther_view_top_left_focus (self);
							}
						} else {
							GtkSearchEntry* _tmp84_;
							gboolean _tmp85_;
							gboolean _tmp86_;
							_tmp84_ = self->search_entry;
							g_object_get ((GtkWidget*) _tmp84_, "has-focus", &_tmp85_, NULL);
							_tmp86_ = _tmp85_;
							if (_tmp86_) {
								PantherWidgetsCategoryView* _tmp87_;
								PantherWidgetsSidebar* _tmp88_;
								gint _tmp89_;
								gint _tmp90_;
								_tmp87_ = self->priv->category_view;
								_tmp88_ = _tmp87_->category_switcher;
								_tmp89_ = panther_widgets_sidebar_get_selected (_tmp88_);
								_tmp90_ = _tmp89_;
								panther_widgets_sidebar_set_selected (_tmp88_, _tmp90_ - 1);
							} else {
								panther_panther_view_category_move_focus (self, 0, -1);
							}
						}
					} else {
						PantherModality _tmp91_;
						_tmp91_ = self->priv->modality;
						if (_tmp91_ == PANTHER_MODALITY_SEARCH_VIEW) {
							PantherWidgetsSearchView* _tmp92_;
							_tmp92_ = self->priv->search_view;
							panther_widgets_search_view_up (_tmp92_);
						}
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label21) ? _tmp12_label21 : (_tmp12_label21 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				PantherModality _tmp93_;
				_tmp93_ = self->priv->modality;
				if (_tmp93_ == PANTHER_MODALITY_NORMAL_VIEW) {
					panther_panther_view_normal_move_focus (self, 0, 1);
				} else {
					PantherModality _tmp94_;
					_tmp94_ = self->priv->modality;
					if (_tmp94_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						GdkModifierType _tmp95_;
						_tmp95_ = event->state;
						if (_tmp95_ == GDK_SHIFT_MASK) {
							PantherWidgetsCategoryView* _tmp96_;
							PantherWidgetsSidebar* _tmp97_;
							gint _tmp98_;
							gint _tmp99_;
							_tmp96_ = self->priv->category_view;
							_tmp97_ = _tmp96_->category_switcher;
							_tmp98_ = panther_widgets_sidebar_get_selected (_tmp97_);
							_tmp99_ = _tmp98_;
							panther_widgets_sidebar_set_selected (_tmp97_, _tmp99_ + 1);
							panther_panther_view_top_left_focus (self);
						} else {
							GtkSearchEntry* _tmp100_;
							gboolean _tmp101_;
							gboolean _tmp102_;
							_tmp100_ = self->search_entry;
							g_object_get ((GtkWidget*) _tmp100_, "has-focus", &_tmp101_, NULL);
							_tmp102_ = _tmp101_;
							if (_tmp102_) {
								PantherWidgetsCategoryView* _tmp103_;
								PantherWidgetsSidebar* _tmp104_;
								gint _tmp105_;
								gint _tmp106_;
								_tmp103_ = self->priv->category_view;
								_tmp104_ = _tmp103_->category_switcher;
								_tmp105_ = panther_widgets_sidebar_get_selected (_tmp104_);
								_tmp106_ = _tmp105_;
								panther_widgets_sidebar_set_selected (_tmp104_, _tmp106_ + 1);
							} else {
								panther_panther_view_category_move_focus (self, 0, 1);
							}
						}
					} else {
						PantherModality _tmp107_;
						_tmp107_ = self->priv->modality;
						if (_tmp107_ == PANTHER_MODALITY_SEARCH_VIEW) {
							PantherWidgetsSearchView* _tmp108_;
							_tmp108_ = self->priv->search_view;
							panther_widgets_search_view_down (_tmp108_);
						}
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label22) ? _tmp12_label22 : (_tmp12_label22 = g_quark_from_static_string ("Page_Up")))) {
		switch (0) {
			default:
			{
				PantherModality _tmp109_;
				_tmp109_ = self->priv->modality;
				if (_tmp109_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherWidgetsGrid* _tmp110_;
					_tmp110_ = self->priv->grid_view;
					panther_widgets_grid_go_to_previous (_tmp110_);
				} else {
					PantherModality _tmp111_;
					_tmp111_ = self->priv->modality;
					if (_tmp111_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherWidgetsCategoryView* _tmp112_;
						PantherWidgetsSidebar* _tmp113_;
						gint _tmp114_;
						gint _tmp115_;
						_tmp112_ = self->priv->category_view;
						_tmp113_ = _tmp112_->category_switcher;
						_tmp114_ = panther_widgets_sidebar_get_selected (_tmp113_);
						_tmp115_ = _tmp114_;
						panther_widgets_sidebar_set_selected (_tmp113_, _tmp115_ - 1);
						panther_panther_view_top_left_focus (self);
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label23) ? _tmp12_label23 : (_tmp12_label23 = g_quark_from_static_string ("Page_Down")))) {
		switch (0) {
			default:
			{
				PantherModality _tmp116_;
				_tmp116_ = self->priv->modality;
				if (_tmp116_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherWidgetsGrid* _tmp117_;
					_tmp117_ = self->priv->grid_view;
					panther_widgets_grid_go_to_next (_tmp117_);
				} else {
					PantherModality _tmp118_;
					_tmp118_ = self->priv->modality;
					if (_tmp118_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherWidgetsCategoryView* _tmp119_;
						PantherWidgetsSidebar* _tmp120_;
						gint _tmp121_;
						gint _tmp122_;
						_tmp119_ = self->priv->category_view;
						_tmp120_ = _tmp119_->category_switcher;
						_tmp121_ = panther_widgets_sidebar_get_selected (_tmp120_);
						_tmp122_ = _tmp121_;
						panther_widgets_sidebar_set_selected (_tmp120_, _tmp122_ + 1);
						panther_panther_view_top_left_focus (self);
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label24) ? _tmp12_label24 : (_tmp12_label24 = g_quark_from_static_string ("BackSpace")))) {
		switch (0) {
			default:
			{
				GdkModifierType _tmp123_;
				_tmp123_ = event->state;
				if (_tmp123_ == GDK_SHIFT_MASK) {
					GtkSearchEntry* _tmp124_;
					_tmp124_ = self->search_entry;
					gtk_entry_set_text ((GtkEntry*) _tmp124_, "");
				} else {
					GtkSearchEntry* _tmp125_;
					gboolean _tmp126_;
					gboolean _tmp127_;
					_tmp125_ = self->search_entry;
					g_object_get ((GtkWidget*) _tmp125_, "has-focus", &_tmp126_, NULL);
					_tmp127_ = _tmp126_;
					if (_tmp127_) {
						result = FALSE;
						_g_free0 (key);
						return result;
					} else {
						GtkSearchEntry* _tmp128_;
						GtkSearchEntry* _tmp129_;
						_tmp128_ = self->search_entry;
						gtk_widget_grab_focus ((GtkWidget*) _tmp128_);
						_tmp129_ = self->search_entry;
						g_signal_emit_by_name ((GtkEntry*) _tmp129_, "move-cursor", GTK_MOVEMENT_BUFFER_ENDS, 0, FALSE);
						result = FALSE;
						_g_free0 (key);
						return result;
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label25) ? _tmp12_label25 : (_tmp12_label25 = g_quark_from_static_string ("Home")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp130_;
				const gchar* _tmp131_;
				const gchar* _tmp132_;
				gint _tmp133_;
				gint _tmp134_;
				PantherModality _tmp135_;
				_tmp130_ = self->search_entry;
				_tmp131_ = gtk_entry_get_text ((GtkEntry*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = strlen (_tmp132_);
				_tmp134_ = _tmp133_;
				if (_tmp134_ > 0) {
					result = FALSE;
					_g_free0 (key);
					return result;
				}
				_tmp135_ = self->priv->modality;
				if (_tmp135_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherWidgetsGrid* _tmp136_;
					_tmp136_ = self->priv->grid_view;
					panther_widgets_grid_go_to_number (_tmp136_, 1);
				} else {
					PantherModality _tmp137_;
					_tmp137_ = self->priv->modality;
					if (_tmp137_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherWidgetsCategoryView* _tmp138_;
						PantherWidgetsSidebar* _tmp139_;
						_tmp138_ = self->priv->category_view;
						_tmp139_ = _tmp138_->category_switcher;
						panther_widgets_sidebar_set_selected (_tmp139_, 0);
						panther_panther_view_top_left_focus (self);
					}
				}
				break;
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label26) ? _tmp12_label26 : (_tmp12_label26 = g_quark_from_static_string ("End")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp140_;
				const gchar* _tmp141_;
				const gchar* _tmp142_;
				gint _tmp143_;
				gint _tmp144_;
				PantherModality _tmp145_;
				_tmp140_ = self->search_entry;
				_tmp141_ = gtk_entry_get_text ((GtkEntry*) _tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = strlen (_tmp142_);
				_tmp144_ = _tmp143_;
				if (_tmp144_ > 0) {
					result = FALSE;
					_g_free0 (key);
					return result;
				}
				_tmp145_ = self->priv->modality;
				if (_tmp145_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherWidgetsGrid* _tmp146_;
					_tmp146_ = self->priv->grid_view;
					panther_widgets_grid_go_to_last (_tmp146_);
				} else {
					PantherModality _tmp147_;
					_tmp147_ = self->priv->modality;
					if (_tmp147_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherWidgetsCategoryView* _tmp148_;
						PantherWidgetsSidebar* _tmp149_;
						PantherWidgetsCategoryView* _tmp150_;
						PantherWidgetsSidebar* _tmp151_;
						gint _tmp152_;
						gint _tmp153_;
						_tmp148_ = self->priv->category_view;
						_tmp149_ = _tmp148_->category_switcher;
						_tmp150_ = self->priv->category_view;
						_tmp151_ = _tmp150_->category_switcher;
						_tmp152_ = panther_widgets_sidebar_get_cat_size (_tmp151_);
						_tmp153_ = _tmp152_;
						panther_widgets_sidebar_set_selected (_tmp149_, _tmp153_ - 1);
						panther_panther_view_top_left_focus (self);
					}
				}
				break;
			}
		}
	} else if ((_tmp13_ == ((0 != _tmp12_label27) ? _tmp12_label27 : (_tmp12_label27 = g_quark_from_static_string ("v")))) || (_tmp13_ == ((0 != _tmp12_label28) ? _tmp12_label28 : (_tmp12_label28 = g_quark_from_static_string ("V"))))) {
		switch (0) {
			default:
			{
				GdkModifierType _tmp154_;
				_tmp154_ = event->state;
				if ((_tmp154_ & (GDK_CONTROL_MASK | GDK_SHIFT_MASK)) != 0) {
					GtkSearchEntry* _tmp155_;
					_tmp155_ = self->search_entry;
					gtk_editable_paste_clipboard ((GtkEditable*) _tmp155_);
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp156_;
				gboolean _tmp157_;
				gboolean _tmp158_;
				_tmp156_ = self->search_entry;
				g_object_get ((GtkWidget*) _tmp156_, "has-focus", &_tmp157_, NULL);
				_tmp158_ = _tmp157_;
				if (!_tmp158_) {
					GtkSearchEntry* _tmp159_;
					GtkSearchEntry* _tmp160_;
					GtkSearchEntry* _tmp161_;
					gboolean _tmp162_ = FALSE;
					_tmp159_ = self->search_entry;
					gtk_widget_grab_focus ((GtkWidget*) _tmp159_);
					_tmp160_ = self->search_entry;
					g_signal_emit_by_name ((GtkEntry*) _tmp160_, "move-cursor", GTK_MOVEMENT_BUFFER_ENDS, 0, FALSE);
					_tmp161_ = self->search_entry;
					g_signal_emit_by_name ((GtkWidget*) _tmp161_, "key-press-event", event, &_tmp162_);
				}
				result = FALSE;
				_g_free0 (key);
				return result;
			}
		}
	}
	result = TRUE;
	_g_free0 (key);
	return result;
}


static gboolean
panther_panther_view_real_scroll_event (GtkWidget* base,
                                        GdkEventScroll* event)
{
	PantherPantherView * self;
	gboolean result = FALSE;
	GdkScrollDirection _tmp0_;
	GEnumValue* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	self = (PantherPantherView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->direction;
	_tmp1_ = g_enum_get_value (g_type_class_ref (gdk_scroll_direction_get_type ()), _tmp0_);
	_tmp2_ = (_tmp1_ != NULL) ? _tmp1_->value_name : NULL;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("GDK_SCROLL_UP")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("GDK_SCROLL_LEFT"))))) {
		switch (0) {
			default:
			{
				PantherModality _tmp5_;
				_tmp5_ = self->priv->modality;
				if (_tmp5_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherWidgetsGrid* _tmp6_;
					_tmp6_ = self->priv->grid_view;
					panther_widgets_grid_go_to_previous (_tmp6_);
				} else {
					PantherModality _tmp7_;
					_tmp7_ = self->priv->modality;
					if (_tmp7_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherWidgetsCategoryView* _tmp8_;
						PantherWidgetsGrid* _tmp9_;
						_tmp8_ = self->priv->category_view;
						_tmp9_ = _tmp8_->app_view;
						panther_widgets_grid_go_to_previous (_tmp9_);
					}
				}
				break;
			}
		}
	} else if ((_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("GDK_SCROLL_DOWN")))) || (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("GDK_SCROLL_RIGHT"))))) {
		switch (0) {
			default:
			{
				PantherModality _tmp10_;
				_tmp10_ = self->priv->modality;
				if (_tmp10_ == PANTHER_MODALITY_NORMAL_VIEW) {
					PantherWidgetsGrid* _tmp11_;
					_tmp11_ = self->priv->grid_view;
					panther_widgets_grid_go_to_next (_tmp11_);
				} else {
					PantherModality _tmp12_;
					_tmp12_ = self->priv->modality;
					if (_tmp12_ == PANTHER_MODALITY_CATEGORY_VIEW) {
						PantherWidgetsCategoryView* _tmp13_;
						PantherWidgetsGrid* _tmp14_;
						_tmp13_ = self->priv->category_view;
						_tmp14_ = _tmp13_->app_view;
						panther_widgets_grid_go_to_next (_tmp14_);
					}
				}
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


void
panther_panther_view_show_panther (PantherPantherView* self)
{
	gboolean _tmp0_;
	GtkSearchEntry* _tmp1_;
	GtkGrid* _tmp2_;
	GtkSearchEntry* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkStack* _tmp5_;
	PantherSelector* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkRevealer* _tmp9_;
	GtkStack* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->avoid_show;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp1_, "");
	panther_panther_view_reposition (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp2_ = self->container;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
	gtk_window_present ((GtkWindow*) self);
	gtk_window_set_focus ((GtkWindow*) self, NULL);
	_tmp3_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp4_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp5_ = self->stack;
	gtk_stack_set_transition_type (_tmp5_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp6_ = self->view_selector;
	_tmp7_ = panther_selector_get_selected (_tmp6_);
	_tmp8_ = _tmp7_;
	panther_panther_view_set_modality (self, (PantherModality) _tmp8_);
	_tmp9_ = self->priv->view_selector_revealer;
	gtk_revealer_set_transition_type (_tmp9_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp10_ = self->stack;
	gtk_stack_set_transition_type (_tmp10_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
}


static void
panther_panther_view_move_left (PantherPantherView* self,
                                GdkEventKey* event)
{
	PantherModality _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->modality;
	if (_tmp0_ == PANTHER_MODALITY_NORMAL_VIEW) {
		GdkModifierType _tmp1_;
		_tmp1_ = event->state;
		if (_tmp1_ == GDK_SHIFT_MASK) {
			PantherWidgetsGrid* _tmp2_;
			_tmp2_ = self->priv->grid_view;
			panther_widgets_grid_go_to_previous (_tmp2_);
		} else {
			panther_panther_view_normal_move_focus (self, -1, 0);
		}
	} else {
		PantherModality _tmp3_;
		_tmp3_ = self->priv->modality;
		if (_tmp3_ == PANTHER_MODALITY_CATEGORY_VIEW) {
			GdkModifierType _tmp4_;
			_tmp4_ = event->state;
			if (_tmp4_ == GDK_SHIFT_MASK) {
				PantherWidgetsCategoryView* _tmp5_;
				PantherWidgetsGrid* _tmp6_;
				_tmp5_ = self->priv->category_view;
				_tmp6_ = _tmp5_->app_view;
				panther_widgets_grid_go_to_previous (_tmp6_);
			} else {
				GtkSearchEntry* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = self->search_entry;
				g_object_get ((GtkWidget*) _tmp7_, "has-focus", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					panther_panther_view_category_move_focus (self, -1, 0);
				}
			}
		}
	}
}


static void
panther_panther_view_move_right (PantherPantherView* self,
                                 GdkEventKey* event)
{
	PantherModality _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->modality;
	if (_tmp0_ == PANTHER_MODALITY_NORMAL_VIEW) {
		GdkModifierType _tmp1_;
		_tmp1_ = event->state;
		if (_tmp1_ == GDK_SHIFT_MASK) {
			PantherWidgetsGrid* _tmp2_;
			_tmp2_ = self->priv->grid_view;
			panther_widgets_grid_go_to_next (_tmp2_);
		} else {
			panther_panther_view_normal_move_focus (self, 1, 0);
		}
	} else {
		PantherModality _tmp3_;
		_tmp3_ = self->priv->modality;
		if (_tmp3_ == PANTHER_MODALITY_CATEGORY_VIEW) {
			GdkModifierType _tmp4_;
			_tmp4_ = event->state;
			if (_tmp4_ == GDK_SHIFT_MASK) {
				PantherWidgetsCategoryView* _tmp5_;
				PantherWidgetsGrid* _tmp6_;
				_tmp5_ = self->priv->category_view;
				_tmp6_ = _tmp5_->app_view;
				panther_widgets_grid_go_to_next (_tmp6_);
			} else {
				GtkSearchEntry* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = self->search_entry;
				g_object_get ((GtkWidget*) _tmp7_, "has-focus", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					panther_panther_view_top_left_focus (self);
				} else {
					panther_panther_view_category_move_focus (self, 1, 0);
				}
			}
		}
	}
}


static void
panther_panther_view_set_modality (PantherPantherView* self,
                                   PantherModality new_modality)
{
	PantherModality _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->modality = new_modality;
	_tmp0_ = self->priv->modality;
	switch (_tmp0_) {
		case PANTHER_MODALITY_NORMAL_VIEW:
		{
			PantherSettings* _tmp1_;
			PantherSettings* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			GtkRevealer* _tmp7_;
			GtkStack* _tmp8_;
			GtkSearchEntry* _tmp9_;
			_tmp1_ = panther_panther_get_settings ();
			_tmp2_ = _tmp1_;
			_tmp3_ = panther_settings_get_use_category (_tmp2_);
			_tmp4_ = _tmp3_;
			if (_tmp4_) {
				PantherSettings* _tmp5_;
				PantherSettings* _tmp6_;
				_tmp5_ = panther_panther_get_settings ();
				_tmp6_ = _tmp5_;
				panther_settings_set_use_category (_tmp6_, FALSE);
			}
			_tmp7_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp7_, TRUE);
			_tmp8_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp8_, "normal");
			_tmp9_ = self->search_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
			break;
		}
		case PANTHER_MODALITY_CATEGORY_VIEW:
		{
			PantherSettings* _tmp10_;
			PantherSettings* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			GtkRevealer* _tmp16_;
			GtkStack* _tmp17_;
			GtkSearchEntry* _tmp18_;
			_tmp10_ = panther_panther_get_settings ();
			_tmp11_ = _tmp10_;
			_tmp12_ = panther_settings_get_use_category (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				PantherSettings* _tmp14_;
				PantherSettings* _tmp15_;
				_tmp14_ = panther_panther_get_settings ();
				_tmp15_ = _tmp14_;
				panther_settings_set_use_category (_tmp15_, TRUE);
			}
			_tmp16_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp16_, TRUE);
			_tmp17_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp17_, "category");
			_tmp18_ = self->search_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp18_);
			break;
		}
		case PANTHER_MODALITY_SEARCH_VIEW:
		{
			GtkRevealer* _tmp19_;
			GtkStack* _tmp20_;
			_tmp19_ = self->priv->view_selector_revealer;
			gtk_revealer_set_reveal_child (_tmp19_, FALSE);
			_tmp20_ = self->stack;
			gtk_stack_set_visible_child_name (_tmp20_, "search");
			break;
		}
		default:
		break;
	}
}


static void
panther_panther_view_search_data_free (gpointer _data)
{
	PantherPantherViewSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search_match);
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->self);
	g_slice_free (PantherPantherViewSearchData, _data_);
}


static void
panther_panther_view_search_async_ready_wrapper (GObject *source_object,
                                                 GAsyncResult *res,
                                                 void *user_data)
{
	PantherPantherViewSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
panther_panther_view_search (PantherPantherView* self,
                             const gchar* text,
                             SynapseSearchMatch* search_match,
                             SynapseMatch* target,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	PantherPantherViewSearchData* _data_;
	PantherPantherView* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchMatch* _tmp2_;
	SynapseMatch* _tmp3_;
	_data_ = g_slice_new0 (PantherPantherViewSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, panther_panther_view_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, panther_panther_view_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (_data_->text);
	_data_->text = _tmp1_;
	_tmp2_ = _g_object_ref0 (search_match);
	_g_object_unref0 (_data_->search_match);
	_data_->search_match = _tmp2_;
	_tmp3_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp3_;
	panther_panther_view_search_co (_data_);
}


static void
panther_panther_view_search_finish (PantherPantherView* self,
                                    GAsyncResult* _res_)
{
	PantherPantherViewSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PantherPantherView* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->matches);
		_g_free0 (_data3_->text);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean
___lambda52_ (PantherPantherView* self)
{
	gboolean result = FALSE;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		PantherSelector* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->view_selector;
		_tmp7_ = panther_selector_get_selected (_tmp6_);
		_tmp8_ = _tmp7_;
		panther_panther_view_set_modality (self, (PantherModality) _tmp8_);
	}
	result = FALSE;
	return result;
}


static gboolean
____lambda52__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda52_ ((PantherPantherView*) self);
	return result;
}


static void
panther_panther_view_search_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	PantherPantherViewSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	panther_panther_view_search_co (_data_);
}


static gboolean
__lambda53_ (Block3Data* _data3_)
{
	PantherPantherView* self;
	gboolean result = FALSE;
	PantherWidgetsSearchView* _tmp0_;
	GeeList* _tmp1_;
	self = _data3_->self;
	_tmp0_ = self->priv->search_view;
	_tmp1_ = _data3_->matches;
	panther_widgets_search_view_set_results (_tmp0_, _tmp1_, _data3_->text);
	result = FALSE;
	return result;
}


static gboolean
___lambda53__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda53_ (self);
	return result;
}


static gboolean
panther_panther_view_search_co (PantherPantherViewSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data3_->text);
	_data_->_data3_->text = _data_->text;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = string_strip (_data_->_data3_->text);
	_data_->stripped = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->stripped;
	if (g_strcmp0 (_data_->_tmp1_, "") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda52__gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_free0 (_data_->stripped);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->modality;
	if (_data_->_tmp2_ != PANTHER_MODALITY_SEARCH_VIEW) {
		panther_panther_view_set_modality (_data_->self, PANTHER_MODALITY_SEARCH_VIEW);
	}
	if (_data_->search_match != NULL) {
		synapse_search_match_set_search_source (_data_->search_match, _data_->target);
		_data_->_tmp3_ = _data_->self->priv->synapse;
		_data_->_state_ = 1;
		panther_backend_synapse_search_search (_data_->_tmp3_, _data_->_data3_->text, (SynapseSearchProvider*) _data_->search_match, panther_panther_view_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = panther_backend_synapse_search_search_finish (_data_->_tmp3_, _data_->_res_);
		_g_object_unref0 (_data_->_data3_->matches);
		_data_->_data3_->matches = _data_->_tmp4_;
	} else {
		_data_->_tmp5_ = _data_->self->priv->synapse;
		_data_->_state_ = 2;
		panther_backend_synapse_search_search (_data_->_tmp5_, _data_->_data3_->text, NULL, panther_panther_view_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = panther_backend_synapse_search_search_finish (_data_->_tmp5_, _data_->_res_);
		_g_object_unref0 (_data_->_data3_->matches);
		_data_->_data3_->matches = _data_->_tmp6_;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda53__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
	_g_free0 (_data_->stripped);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
____lambda50_ (PantherPantherView* self)
{
	gtk_widget_hide ((GtkWidget*) self);
}


static void
_____lambda50__panther_widgets_app_entry_app_launched (PantherWidgetsAppEntry* _sender,
                                                       gpointer self)
{
	____lambda50_ ((PantherPantherView*) self);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


void
panther_panther_view_populate_grid_view (PantherPantherView* self)
{
	PantherWidgetsGrid* _tmp0_;
	PantherBackendAppSystem* _tmp1_;
	GSList* _tmp2_;
	GtkStack* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->grid_view;
	panther_widgets_grid_clear (_tmp0_);
	_tmp1_ = self->app_system;
	_tmp2_ = panther_backend_app_system_get_apps_by_name (_tmp1_);
	{
		GSList* app_collection = NULL;
		GSList* app_it = NULL;
		app_collection = _tmp2_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			PantherBackendApp* _tmp3_;
			PantherBackendApp* app = NULL;
			_tmp3_ = _g_object_ref0 ((PantherBackendApp*) app_it->data);
			app = _tmp3_;
			{
				PantherWidgetsAppEntry* app_entry = NULL;
				PantherBackendApp* _tmp4_;
				PantherWidgetsAppEntry* _tmp5_;
				PantherWidgetsAppEntry* _tmp6_;
				PantherWidgetsGrid* _tmp7_;
				PantherWidgetsAppEntry* _tmp8_;
				PantherWidgetsAppEntry* _tmp9_;
				_tmp4_ = app;
				_tmp5_ = panther_widgets_app_entry_new (_tmp4_);
				g_object_ref_sink (_tmp5_);
				app_entry = _tmp5_;
				_tmp6_ = app_entry;
				g_signal_connect_object (_tmp6_, "app-launched", (GCallback) _____lambda50__panther_widgets_app_entry_app_launched, self, 0);
				_tmp7_ = self->priv->grid_view;
				_tmp8_ = app_entry;
				panther_widgets_grid_append (_tmp7_, (GtkWidget*) _tmp8_);
				_tmp9_ = app_entry;
				gtk_widget_show_all ((GtkWidget*) _tmp9_);
				_g_object_unref0 (app_entry);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_slist_free__g_object_unref0_ (app_collection), NULL));
	}
	_tmp10_ = self->stack;
	gtk_stack_set_visible_child_name (_tmp10_, "normal");
}


static void
panther_panther_view_read_settings (PantherPantherView* self,
                                    gboolean first_start,
                                    gboolean check_columns,
                                    gboolean check_rows)
{
	g_return_if_fail (self != NULL);
	if (check_columns) {
		PantherSettings* _tmp0_;
		PantherSettings* _tmp1_;
		gint _tmp2_;
		_tmp0_ = panther_panther_get_settings ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_->columns;
		if (_tmp2_ > 3) {
			PantherSettings* _tmp3_;
			PantherSettings* _tmp4_;
			gint _tmp5_;
			_tmp3_ = panther_panther_get_settings ();
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_->columns;
			self->priv->default_columns = _tmp5_;
		} else {
			PantherSettings* _tmp6_;
			PantherSettings* _tmp7_;
			gint _tmp8_;
			_tmp6_ = panther_panther_get_settings ();
			_tmp7_ = _tmp6_;
			_tmp7_->columns = 4;
			_tmp8_ = _tmp7_->columns;
			self->priv->default_columns = _tmp8_;
		}
	}
	if (check_rows) {
		PantherSettings* _tmp9_;
		PantherSettings* _tmp10_;
		gint _tmp11_;
		_tmp9_ = panther_panther_get_settings ();
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->rows;
		if (_tmp11_ > 1) {
			PantherSettings* _tmp12_;
			PantherSettings* _tmp13_;
			gint _tmp14_;
			_tmp12_ = panther_panther_get_settings ();
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_->rows;
			self->priv->default_rows = _tmp14_;
		} else {
			PantherSettings* _tmp15_;
			PantherSettings* _tmp16_;
			gint _tmp17_;
			_tmp15_ = panther_panther_get_settings ();
			_tmp16_ = _tmp15_;
			_tmp16_->rows = 2;
			_tmp17_ = _tmp16_->rows;
			self->priv->default_rows = _tmp17_;
		}
	}
	if (!first_start) {
		PantherWidgetsGrid* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		PantherWidgetsCategoryView* _tmp21_;
		PantherWidgetsGrid* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		PantherWidgetsCategoryView* _tmp25_;
		PantherWidgetsCategoryView* _tmp26_;
		GeeHashMap* _tmp27_;
		PantherWidgetsCategoryView* _tmp28_;
		PantherWidgetsSidebar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gpointer _tmp32_;
		gchar* _tmp33_;
		_tmp18_ = self->priv->grid_view;
		_tmp19_ = self->priv->default_rows;
		_tmp20_ = self->priv->default_columns;
		panther_widgets_grid_resize (_tmp18_, _tmp19_, _tmp20_);
		panther_panther_view_populate_grid_view (self);
		g_object_set ((GtkWidget*) self, "height-request", panther_panther_view_calculate_grid_height (self) + PANTHER_PIXELS_BOTTOM_SPACE, NULL);
		_tmp21_ = self->priv->category_view;
		_tmp22_ = _tmp21_->app_view;
		_tmp23_ = self->priv->default_rows;
		_tmp24_ = self->priv->default_columns;
		panther_widgets_grid_resize (_tmp22_, _tmp23_, _tmp24_);
		_tmp25_ = self->priv->category_view;
		_tmp26_ = self->priv->category_view;
		_tmp27_ = _tmp26_->category_ids;
		_tmp28_ = self->priv->category_view;
		_tmp29_ = _tmp28_->category_switcher;
		_tmp30_ = panther_widgets_sidebar_get_selected (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp27_, (gpointer) ((gintptr) _tmp31_));
		_tmp33_ = (gchar*) _tmp32_;
		panther_widgets_category_view_show_filtered_apps (_tmp25_, _tmp33_);
		_g_free0 (_tmp33_);
	}
}


static void
panther_panther_view_normal_move_focus (PantherPantherView* self,
                                        gint delta_column,
                                        gint delta_row)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_focus ((GtkWindow*) self);
	if ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, PANTHER_WIDGETS_TYPE_APP_ENTRY) ? ((PantherWidgetsAppEntry*) _tmp0_) : NULL) != NULL) {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		GtkWidget* new_focus = NULL;
		PantherWidgetsGrid* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		gint _tmp13_;
		gint _tmp14_;
		gboolean _tmp15_ = FALSE;
		GtkWidget* _tmp23_;
		_tmp2_ = self->priv->column_focus;
		if ((_tmp2_ + delta_column) < 0) {
			_tmp1_ = TRUE;
		} else {
			gint _tmp3_;
			_tmp3_ = self->priv->row_focus;
			_tmp1_ = (_tmp3_ + delta_row) < 0;
		}
		if (_tmp1_) {
			return;
		}
		_tmp4_ = self->priv->grid_view;
		_tmp5_ = self->priv->column_focus;
		_tmp6_ = self->priv->row_focus;
		_tmp7_ = panther_widgets_grid_get_child_at (_tmp4_, _tmp5_ + delta_column, _tmp6_ + delta_row);
		new_focus = _tmp7_;
		_tmp8_ = new_focus;
		if (_tmp8_ == NULL) {
			if (delta_column <= 0) {
				_g_object_unref0 (new_focus);
				return;
			} else {
				PantherWidgetsGrid* _tmp9_;
				gint _tmp10_;
				GtkWidget* _tmp11_;
				GtkWidget* _tmp12_;
				_tmp9_ = self->priv->grid_view;
				_tmp10_ = self->priv->column_focus;
				_tmp11_ = panther_widgets_grid_get_child_at (_tmp9_, _tmp10_ + delta_column, 0);
				_g_object_unref0 (new_focus);
				new_focus = _tmp11_;
				_tmp12_ = new_focus;
				if (_tmp12_ == NULL) {
					_g_object_unref0 (new_focus);
					return;
				}
				self->priv->row_focus = -delta_row;
			}
		}
		_tmp13_ = self->priv->column_focus;
		self->priv->column_focus = _tmp13_ + delta_column;
		_tmp14_ = self->priv->row_focus;
		self->priv->row_focus = _tmp14_ + delta_row;
		if (delta_column > 0) {
			gint _tmp16_;
			PantherWidgetsGrid* _tmp17_;
			_tmp16_ = self->priv->column_focus;
			_tmp17_ = self->priv->grid_view;
			_tmp15_ = (_tmp16_ % panther_widgets_grid_get_page_columns (_tmp17_)) == 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			PantherWidgetsGrid* _tmp18_;
			_tmp18_ = self->priv->grid_view;
			panther_widgets_grid_go_to_next (_tmp18_);
		} else {
			gboolean _tmp19_ = FALSE;
			if (delta_column < 0) {
				gint _tmp20_;
				PantherWidgetsGrid* _tmp21_;
				_tmp20_ = self->priv->column_focus;
				_tmp21_ = self->priv->grid_view;
				_tmp19_ = ((_tmp20_ + 1) % panther_widgets_grid_get_page_columns (_tmp21_)) == 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				PantherWidgetsGrid* _tmp22_;
				_tmp22_ = self->priv->grid_view;
				panther_widgets_grid_go_to_previous (_tmp22_);
			}
		}
		_tmp23_ = new_focus;
		gtk_widget_grab_focus (_tmp23_);
		_g_object_unref0 (new_focus);
	} else {
		PantherWidgetsGrid* _tmp24_;
		PantherWidgetsGrid* _tmp25_;
		gint _tmp26_;
		_tmp24_ = self->priv->grid_view;
		_tmp25_ = self->priv->grid_view;
		self->priv->column_focus = (panther_widgets_grid_get_current_page (_tmp24_) - 1) * panther_widgets_grid_get_page_columns (_tmp25_);
		_tmp26_ = self->priv->column_focus;
		if (_tmp26_ >= 0) {
			PantherWidgetsGrid* _tmp27_;
			gint _tmp28_;
			GtkWidget* _tmp29_;
			GtkWidget* _tmp30_;
			_tmp27_ = self->priv->grid_view;
			_tmp28_ = self->priv->column_focus;
			_tmp29_ = panther_widgets_grid_get_child_at (_tmp27_, _tmp28_, 0);
			_tmp30_ = _tmp29_;
			gtk_widget_grab_focus (_tmp30_);
			_g_object_unref0 (_tmp30_);
		}
		self->priv->row_focus = 0;
	}
}


static void
panther_panther_view_category_move_focus (PantherPantherView* self,
                                          gint delta_column,
                                          gint delta_row)
{
	GtkWidget* new_focus = NULL;
	PantherWidgetsCategoryView* _tmp0_;
	PantherWidgetsGrid* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	gint _tmp42_;
	gint _tmp43_;
	gboolean _tmp44_ = FALSE;
	GtkWidget* _tmp56_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_view;
	_tmp1_ = _tmp0_->app_view;
	_tmp2_ = self->priv->category_column_focus;
	_tmp3_ = self->priv->category_row_focus;
	_tmp4_ = panther_widgets_grid_get_child_at (_tmp1_, _tmp2_ + delta_column, _tmp3_ + delta_row);
	new_focus = _tmp4_;
	_tmp5_ = new_focus;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		if (delta_row < 0) {
			PantherWidgetsCategoryView* _tmp7_;
			PantherWidgetsSidebar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_tmp7_ = self->priv->category_view;
			_tmp8_ = _tmp7_->category_switcher;
			_tmp9_ = panther_widgets_sidebar_get_selected (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			PantherWidgetsCategoryView* _tmp11_;
			PantherWidgetsSidebar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp11_ = self->priv->category_view;
			_tmp12_ = _tmp11_->category_switcher;
			_tmp13_ = panther_widgets_sidebar_get_selected (_tmp12_);
			_tmp14_ = _tmp13_;
			panther_widgets_sidebar_set_selected (_tmp12_, _tmp14_ - 1);
			panther_panther_view_top_left_focus (self);
			_g_object_unref0 (new_focus);
			return;
		} else {
			gboolean _tmp15_ = FALSE;
			if (delta_row > 0) {
				PantherWidgetsCategoryView* _tmp16_;
				PantherWidgetsSidebar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				PantherWidgetsCategoryView* _tmp20_;
				PantherWidgetsSidebar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				_tmp16_ = self->priv->category_view;
				_tmp17_ = _tmp16_->category_switcher;
				_tmp18_ = panther_widgets_sidebar_get_selected (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = self->priv->category_view;
				_tmp21_ = _tmp20_->category_switcher;
				_tmp22_ = panther_widgets_sidebar_get_cat_size (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp15_ = _tmp19_ != (_tmp23_ - 1);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				PantherWidgetsCategoryView* _tmp24_;
				PantherWidgetsSidebar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp24_ = self->priv->category_view;
				_tmp25_ = _tmp24_->category_switcher;
				_tmp26_ = panther_widgets_sidebar_get_selected (_tmp25_);
				_tmp27_ = _tmp26_;
				panther_widgets_sidebar_set_selected (_tmp25_, _tmp27_ + 1);
				panther_panther_view_top_left_focus (self);
				_g_object_unref0 (new_focus);
				return;
			} else {
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				if (delta_column > 0) {
					gint _tmp30_;
					PantherWidgetsCategoryView* _tmp31_;
					PantherWidgetsGrid* _tmp32_;
					_tmp30_ = self->priv->category_column_focus;
					_tmp31_ = self->priv->category_view;
					_tmp32_ = _tmp31_->app_view;
					_tmp29_ = ((_tmp30_ + delta_column) % panther_widgets_grid_get_page_columns (_tmp32_)) == 0;
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					PantherWidgetsCategoryView* _tmp33_;
					PantherWidgetsGrid* _tmp34_;
					PantherWidgetsCategoryView* _tmp35_;
					PantherWidgetsGrid* _tmp36_;
					_tmp33_ = self->priv->category_view;
					_tmp34_ = _tmp33_->app_view;
					_tmp35_ = self->priv->category_view;
					_tmp36_ = _tmp35_->app_view;
					_tmp28_ = (panther_widgets_grid_get_current_page (_tmp34_) + 1) != panther_widgets_grid_get_n_pages (_tmp36_);
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					PantherWidgetsCategoryView* _tmp37_;
					PantherWidgetsGrid* _tmp38_;
					_tmp37_ = self->priv->category_view;
					_tmp38_ = _tmp37_->app_view;
					panther_widgets_grid_go_to_next (_tmp38_);
					panther_panther_view_top_left_focus (self);
					_g_object_unref0 (new_focus);
					return;
				} else {
					gboolean _tmp39_ = FALSE;
					gint _tmp40_;
					_tmp40_ = self->priv->category_column_focus;
					if (_tmp40_ == 0) {
						_tmp39_ = delta_column < 0;
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						GtkSearchEntry* _tmp41_;
						_tmp41_ = self->search_entry;
						gtk_widget_grab_focus ((GtkWidget*) _tmp41_);
						self->priv->category_column_focus = 0;
						self->priv->category_row_focus = 0;
						_g_object_unref0 (new_focus);
						return;
					} else {
						_g_object_unref0 (new_focus);
						return;
					}
				}
			}
		}
	}
	_tmp42_ = self->priv->category_column_focus;
	self->priv->category_column_focus = _tmp42_ + delta_column;
	_tmp43_ = self->priv->category_row_focus;
	self->priv->category_row_focus = _tmp43_ + delta_row;
	if (delta_column > 0) {
		gint _tmp45_;
		PantherWidgetsCategoryView* _tmp46_;
		PantherWidgetsGrid* _tmp47_;
		_tmp45_ = self->priv->category_column_focus;
		_tmp46_ = self->priv->category_view;
		_tmp47_ = _tmp46_->app_view;
		_tmp44_ = (_tmp45_ % panther_widgets_grid_get_page_columns (_tmp47_)) == 0;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		PantherWidgetsCategoryView* _tmp48_;
		PantherWidgetsGrid* _tmp49_;
		_tmp48_ = self->priv->category_view;
		_tmp49_ = _tmp48_->app_view;
		panther_widgets_grid_go_to_next (_tmp49_);
	} else {
		gboolean _tmp50_ = FALSE;
		if (delta_column < 0) {
			gint _tmp51_;
			PantherWidgetsCategoryView* _tmp52_;
			PantherWidgetsGrid* _tmp53_;
			_tmp51_ = self->priv->category_column_focus;
			_tmp52_ = self->priv->category_view;
			_tmp53_ = _tmp52_->app_view;
			_tmp50_ = ((_tmp51_ + 1) % panther_widgets_grid_get_page_columns (_tmp53_)) == 0;
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			PantherWidgetsCategoryView* _tmp54_;
			PantherWidgetsGrid* _tmp55_;
			_tmp54_ = self->priv->category_view;
			_tmp55_ = _tmp54_->app_view;
			panther_widgets_grid_go_to_previous (_tmp55_);
		}
	}
	_tmp56_ = new_focus;
	gtk_widget_grab_focus (_tmp56_);
	_g_object_unref0 (new_focus);
}


static void
panther_panther_view_top_left_focus (PantherPantherView* self)
{
	gint first_column = 0;
	PantherWidgetsGrid* _tmp0_;
	PantherWidgetsCategoryView* _tmp1_;
	PantherWidgetsGrid* _tmp2_;
	PantherWidgetsCategoryView* _tmp3_;
	PantherWidgetsGrid* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->grid_view;
	_tmp1_ = self->priv->category_view;
	_tmp2_ = _tmp1_->app_view;
	first_column = (panther_widgets_grid_get_current_page (_tmp0_) - 1) * panther_widgets_grid_get_page_columns (_tmp2_);
	_tmp3_ = self->priv->category_view;
	_tmp4_ = _tmp3_->app_view;
	_tmp5_ = panther_widgets_grid_get_child_at (_tmp4_, first_column, 0);
	_tmp6_ = _tmp5_;
	gtk_widget_grab_focus (_tmp6_);
	_g_object_unref0 (_tmp6_);
	self->priv->category_column_focus = first_column;
	self->priv->category_row_focus = 1;
}


void
panther_panther_view_reset_category_focus (PantherPantherView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->category_column_focus = 0;
	self->priv->category_row_focus = 0;
}


gint
panther_panther_view_get_columns (PantherPantherView* self)
{
	gint result;
	PantherWidgetsGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->grid_view;
	result = panther_widgets_grid_get_page_columns (_tmp0_);
	return result;
}


gint
panther_panther_view_get_rows (PantherPantherView* self)
{
	gint result;
	PantherWidgetsGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->grid_view;
	result = panther_widgets_grid_get_page_rows (_tmp0_);
	return result;
}


static void
panther_panther_view_class_init (PantherPantherViewClass * klass)
{
	panther_panther_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantherPantherView_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) panther_panther_view_real_button_press_event;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) panther_panther_view_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) panther_panther_view_real_get_preferred_height;
	((GtkWidgetClass *) klass)->map_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) panther_panther_view_real_map_event;
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) panther_panther_view_real_scroll_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_panther_panther_view_get_property;
	G_OBJECT_CLASS (klass)->finalize = panther_panther_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_PANTHER_VIEW_COLUMNS_PROPERTY, panther_panther_view_properties[PANTHER_PANTHER_VIEW_COLUMNS_PROPERTY] = g_param_spec_int ("columns", "columns", "columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHER_PANTHER_VIEW_ROWS_PROPERTY, panther_panther_view_properties[PANTHER_PANTHER_VIEW_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
panther_panther_view_instance_init (PantherPantherView * self)
{
	self->priv = panther_panther_view_get_instance_private (self);
	self->priv->can_trigger_hotcorner = TRUE;
	self->priv->column_focus = 0;
	self->priv->row_focus = 0;
	self->priv->category_column_focus = 0;
	self->priv->category_row_focus = 0;
	self->priv->primary_monitor = 0;
}


static void
panther_panther_view_finalize (GObject * obj)
{
	PantherPantherView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHER_TYPE_PANTHER_VIEW, PantherPantherView);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->stack);
	_g_object_unref0 (self->view_selector);
	_g_object_unref0 (self->priv->view_selector_revealer);
	_g_object_unref0 (self->priv->grid_view);
	_g_object_unref0 (self->priv->search_view);
	_g_object_unref0 (self->priv->category_view);
	_g_object_unref0 (self->top);
	_g_object_unref0 (self->container);
	_g_object_unref0 (self->fcontainer);
	_g_object_unref0 (self->main_stack);
	_g_object_unref0 (self->content_area);
	_g_object_unref0 (self->priv->event_box);
	_g_object_unref0 (self->app_system);
	_g_object_unref0 (self->priv->categories);
	_g_object_unref0 (self->apps);
	_g_object_unref0 (self->priv->synapse);
	G_OBJECT_CLASS (panther_panther_view_parent_class)->finalize (obj);
}


GType
panther_panther_view_get_type (void)
{
	static volatile gsize panther_panther_view_type_id__volatile = 0;
	if (g_once_init_enter (&panther_panther_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PantherPantherViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panther_panther_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantherPantherView), 0, (GInstanceInitFunc) panther_panther_view_instance_init, NULL };
		GType panther_panther_view_type_id;
		panther_panther_view_type_id = g_type_register_static (gtk_window_get_type (), "PantherPantherView", &g_define_type_info, 0);
		PantherPantherView_private_offset = g_type_add_instance_private (panther_panther_view_type_id, sizeof (PantherPantherViewPrivate));
		g_once_init_leave (&panther_panther_view_type_id__volatile, panther_panther_view_type_id);
	}
	return panther_panther_view_type_id__volatile;
}


static void
_vala_panther_panther_view_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	PantherPantherView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHER_TYPE_PANTHER_VIEW, PantherPantherView);
	switch (property_id) {
		case PANTHER_PANTHER_VIEW_COLUMNS_PROPERTY:
		g_value_set_int (value, panther_panther_view_get_columns (self));
		break;
		case PANTHER_PANTHER_VIEW_ROWS_PROPERTY:
		g_value_set_int (value, panther_panther_view_get_rows (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



