/* SynapseSearch.c generated by valac 0.42.5, the Vala compiler
 * generated from SynapseSearch.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libsoup/soup.h>


#define PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH (panther_backend_synapse_search_get_type ())
#define PANTHER_BACKEND_SYNAPSE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearch))
#define PANTHER_BACKEND_SYNAPSE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearchClass))
#define PANTHER_BACKEND_IS_SYNAPSE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH))
#define PANTHER_BACKEND_IS_SYNAPSE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH))
#define PANTHER_BACKEND_SYNAPSE_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearchClass))

typedef struct _PantherBackendSynapseSearch PantherBackendSynapseSearch;
typedef struct _PantherBackendSynapseSearchClass PantherBackendSynapseSearchClass;
typedef struct _PantherBackendSynapseSearchPrivate PantherBackendSynapseSearchPrivate;
enum  {
	PANTHER_BACKEND_SYNAPSE_SEARCH_0_PROPERTY,
	PANTHER_BACKEND_SYNAPSE_SEARCH_NUM_PROPERTIES
};
static GParamSpec* panther_backend_synapse_search_properties[PANTHER_BACKEND_SYNAPSE_SEARCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_CALCULATOR_PLUGIN (synapse_calculator_plugin_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin))
#define SYNAPSE_CALCULATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginClass))
#define SYNAPSE_IS_CALCULATOR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN))
#define SYNAPSE_IS_CALCULATOR_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CALCULATOR_PLUGIN))
#define SYNAPSE_CALCULATOR_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPluginClass))

typedef struct _SynapseCalculatorPlugin SynapseCalculatorPlugin;
typedef struct _SynapseCalculatorPluginClass SynapseCalculatorPluginClass;

#define SYNAPSE_TYPE_COMMAND_PLUGIN (synapse_command_plugin_get_type ())
#define SYNAPSE_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin))
#define SYNAPSE_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))
#define SYNAPSE_IS_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_IS_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_COMMAND_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))

typedef struct _SynapseCommandPlugin SynapseCommandPlugin;
typedef struct _SynapseCommandPluginClass SynapseCommandPluginClass;

#define SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN (synapse_desktop_file_plugin_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))

typedef struct _SynapseDesktopFilePlugin SynapseDesktopFilePlugin;
typedef struct _SynapseDesktopFilePluginClass SynapseDesktopFilePluginClass;

#define SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN (synapse_system_management_plugin_get_type ())
#define SYNAPSE_SYSTEM_MANAGEMENT_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN, SynapseSystemManagementPlugin))
#define SYNAPSE_SYSTEM_MANAGEMENT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN, SynapseSystemManagementPluginClass))
#define SYNAPSE_IS_SYSTEM_MANAGEMENT_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN))
#define SYNAPSE_IS_SYSTEM_MANAGEMENT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN))
#define SYNAPSE_SYSTEM_MANAGEMENT_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN, SynapseSystemManagementPluginClass))

typedef struct _SynapseSystemManagementPlugin SynapseSystemManagementPlugin;
typedef struct _SynapseSystemManagementPluginClass SynapseSystemManagementPluginClass;

#define SYNAPSE_TYPE_DATA_SINK (synapse_data_sink_get_type ())
#define SYNAPSE_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSink))
#define SYNAPSE_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))
#define SYNAPSE_IS_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_IS_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_DATA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))

typedef struct _SynapseDataSink SynapseDataSink;
typedef struct _SynapseDataSinkClass SynapseDataSinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;


#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT
} SynapseMatchType;


#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PantherBackendSynapseSearchSearchData PantherBackendSynapseSearchSearchData;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _PantherBackendSynapseSearchGetFaviconForMatchData PantherBackendSynapseSearchGetFaviconForMatchData;
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;


#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PantherBackendSynapseSearch {
	GObject parent_instance;
	PantherBackendSynapseSearchPrivate * priv;
};

struct _PantherBackendSynapseSearchClass {
	GObjectClass parent_class;
};

struct _PantherBackendSynapseSearchPrivate {
	GCancellable* current_search;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _PantherBackendSynapseSearchSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	PantherBackendSynapseSearch* self;
	gchar* text;
	SynapseSearchProvider* provider;
	GeeList* result;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	SynapseDataSink* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp4_;
	GeeList* _tmp5_;
	GCancellable* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _PantherBackendSynapseSearchGetFaviconForMatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	SynapseUriMatch* match;
	gint size;
	GCancellable* cancellable;
	GdkPixbuf* result;
	SoupURI* soup_uri;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupURI* _tmp2_;
	SoupURI* _tmp3_;
	const gchar* _tmp4_;
	GdkPixbuf* pixbuf;
	GeeHashMap* _tmp5_;
	SoupURI* _tmp6_;
	const gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	SoupURI* _tmp9_;
	const gchar* _tmp10_;
	gpointer _tmp11_;
	gchar* url;
	SoupURI* _tmp12_;
	const gchar* _tmp13_;
	SoupURI* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	SoupMessage* msg;
	const gchar* _tmp17_;
	SoupMessage* _tmp18_;
	SoupSession* session;
	SoupSession* _tmp19_;
	SoupSession* _tmp20_;
	GInputStream* stream;
	SoupSession* _tmp21_;
	SoupMessage* _tmp22_;
	GInputStream* _tmp23_;
	GInputStream* _tmp24_;
	GdkPixbuf* _tmp25_;
	GInputStream* _tmp26_;
	GdkPixbuf* _tmp27_;
	GdkPixbuf* _tmp28_;
	GdkPixbuf* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GError* e;
	GeeHashMap* _tmp32_;
	SoupURI* _tmp33_;
	const gchar* _tmp34_;
	GdkPixbuf* _tmp35_;
	GError * _inner_error_;
};


static gint PantherBackendSynapseSearch_private_offset;
static gpointer panther_backend_synapse_search_parent_class = NULL;
static GType* panther_backend_synapse_search_plugins;
static gint panther_backend_synapse_search_plugins_length1;
static GType* panther_backend_synapse_search_plugins = NULL;
static gint panther_backend_synapse_search_plugins_length1 = 0;
static gint _panther_backend_synapse_search_plugins_size_ = 0;
static SynapseDataSink* panther_backend_synapse_search_sink;
static SynapseDataSink* panther_backend_synapse_search_sink = NULL;
static GeeHashMap* panther_backend_synapse_search_favicon_cache;
static GeeHashMap* panther_backend_synapse_search_favicon_cache = NULL;

GType panther_backend_synapse_search_get_type (void) G_GNUC_CONST;
GType synapse_calculator_plugin_get_type (void) G_GNUC_CONST;
GType synapse_command_plugin_get_type (void) G_GNUC_CONST;
GType synapse_desktop_file_plugin_get_type (void) G_GNUC_CONST;
GType synapse_system_management_plugin_get_type (void) G_GNUC_CONST;
GType synapse_data_sink_get_type (void) G_GNUC_CONST;
PantherBackendSynapseSearch* panther_backend_synapse_search_new (void);
PantherBackendSynapseSearch* panther_backend_synapse_search_construct (GType object_type);
SynapseDataSink* synapse_data_sink_new (void);
SynapseDataSink* synapse_data_sink_construct (GType object_type);
void synapse_data_sink_register_static_plugin (SynapseDataSink* self,
                                               GType plugin_type);
static void panther_backend_synapse_search_search_data_free (gpointer _data);
static void panther_backend_synapse_search_search_async_ready_wrapper (GObject *source_object,
                                                                GAsyncResult *res,
                                                                void *user_data);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_result_set_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
void panther_backend_synapse_search_search (PantherBackendSynapseSearch* self,
                                            const gchar* text,
                                            SynapseSearchProvider* provider,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
GeeList* panther_backend_synapse_search_search_finish (PantherBackendSynapseSearch* self,
                                                       GAsyncResult* _res_);
static gboolean panther_backend_synapse_search_search_co (PantherBackendSynapseSearchSearchData* _data_);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_search_provider_search (SynapseSearchProvider* self,
                                     const gchar* query,
                                     SynapseQueryFlags flags,
                                     SynapseResultSet* dest_result_set,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
GeeList* synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void panther_backend_synapse_search_search_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
GeeList* panther_backend_synapse_search_find_actions_for_match (SynapseMatch* match);
GeeList* synapse_data_sink_find_actions_for_match (SynapseDataSink* self,
                                                   SynapseMatch* match,
                                                   const gchar* query,
                                                   SynapseQueryFlags flags);
static void panther_backend_synapse_search_get_favicon_for_match_data_free (gpointer _data);
static void panther_backend_synapse_search_get_favicon_for_match_async_ready_wrapper (GObject *source_object,
                                                                               GAsyncResult *res,
                                                                               void *user_data);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
void panther_backend_synapse_search_get_favicon_for_match (SynapseUriMatch* match,
                                                           gint size,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
GdkPixbuf* panther_backend_synapse_search_get_favicon_for_match_finish (GAsyncResult* _res_);
static gboolean panther_backend_synapse_search_get_favicon_for_match_co (PantherBackendSynapseSearchGetFaviconForMatchData* _data_);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static void _vala_SoupURI_free (SoupURI* self);
static void panther_backend_synapse_search_get_favicon_for_match_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
gchar* panther_backend_synapse_search_markup_string_with_search (const gchar* text,
                                                                 const gchar* pattern);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
static void panther_backend_synapse_search_finalize (GObject * obj);


static inline gpointer
panther_backend_synapse_search_get_instance_private (PantherBackendSynapseSearch* self)
{
	return G_STRUCT_MEMBER_P (self, PantherBackendSynapseSearch_private_offset);
}


PantherBackendSynapseSearch*
panther_backend_synapse_search_construct (GType object_type)
{
	PantherBackendSynapseSearch * self = NULL;
	SynapseDataSink* _tmp0_;
	self = (PantherBackendSynapseSearch*) g_object_new (object_type, NULL);
	_tmp0_ = panther_backend_synapse_search_sink;
	if (_tmp0_ == NULL) {
		SynapseDataSink* _tmp1_;
		GType* _tmp2_;
		gint _tmp2__length1;
		GeeHashMap* _tmp5_;
		_tmp1_ = synapse_data_sink_new ();
		_g_object_unref0 (panther_backend_synapse_search_sink);
		panther_backend_synapse_search_sink = _tmp1_;
		_tmp2_ = panther_backend_synapse_search_plugins;
		_tmp2__length1 = panther_backend_synapse_search_plugins_length1;
		{
			GType* plugin_collection = NULL;
			gint plugin_collection_length1 = 0;
			gint _plugin_collection_size_ = 0;
			gint plugin_it = 0;
			plugin_collection = _tmp2_;
			plugin_collection_length1 = _tmp2__length1;
			for (plugin_it = 0; plugin_it < _tmp2__length1; plugin_it = plugin_it + 1) {
				GType plugin = 0UL;
				plugin = plugin_collection[plugin_it];
				{
					SynapseDataSink* _tmp3_;
					GType _tmp4_;
					_tmp3_ = panther_backend_synapse_search_sink;
					_tmp4_ = plugin;
					synapse_data_sink_register_static_plugin (_tmp3_, _tmp4_);
				}
			}
		}
		_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (panther_backend_synapse_search_favicon_cache);
		panther_backend_synapse_search_favicon_cache = _tmp5_;
	}
	return self;
}


PantherBackendSynapseSearch*
panther_backend_synapse_search_new (void)
{
	return panther_backend_synapse_search_construct (PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH);
}


static void
panther_backend_synapse_search_search_data_free (gpointer _data)
{
	PantherBackendSynapseSearchSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->text);
	_g_object_unref0 (_data_->provider);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PantherBackendSynapseSearchSearchData, _data_);
}


static void
panther_backend_synapse_search_search_async_ready_wrapper (GObject *source_object,
                                                           GAsyncResult *res,
                                                           void *user_data)
{
	PantherBackendSynapseSearchSearchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
panther_backend_synapse_search_search (PantherBackendSynapseSearch* self,
                                       const gchar* text,
                                       SynapseSearchProvider* provider,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	PantherBackendSynapseSearchSearchData* _data_;
	PantherBackendSynapseSearch* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchProvider* _tmp2_;
	_data_ = g_slice_new0 (PantherBackendSynapseSearchSearchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, panther_backend_synapse_search_search_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, panther_backend_synapse_search_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (_data_->text);
	_data_->text = _tmp1_;
	_tmp2_ = _g_object_ref0 (provider);
	_g_object_unref0 (_data_->provider);
	_data_->provider = _tmp2_;
	panther_backend_synapse_search_search_co (_data_);
}


GeeList*
panther_backend_synapse_search_search_finish (PantherBackendSynapseSearch* self,
                                              GAsyncResult* _res_)
{
	GeeList* result;
	PantherBackendSynapseSearchSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
panther_backend_synapse_search_search_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	PantherBackendSynapseSearchSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	panther_backend_synapse_search_search_co (_data_);
}


static gboolean
panther_backend_synapse_search_search_co (PantherBackendSynapseSearchSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_search;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->self->priv->current_search;
		g_cancellable_cancel (_data_->_tmp1_);
	}
	if (_data_->provider == NULL) {
		SynapseSearchProvider* _tmp3_;
		_data_->_tmp2_ = panther_backend_synapse_search_sink;
		_tmp3_ = _g_object_ref0 ((SynapseSearchProvider*) _data_->_tmp2_);
		_g_object_unref0 (_data_->provider);
		_data_->provider = _tmp3_;
	}
	_data_->_tmp4_ = synapse_result_set_new ();
	_data_->results = _data_->_tmp4_;
	{
		_data_->_tmp6_ = _data_->self->priv->current_search;
		_data_->_state_ = 1;
		synapse_search_provider_search (_data_->provider, _data_->text, SYNAPSE_QUERY_FLAGS_ALL, _data_->results, _data_->_tmp6_, panther_backend_synapse_search_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = synapse_search_provider_search_finish (_data_->provider, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_data_->result = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp5_);
		_g_object_unref0 (_data_->results);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("SynapseSearch.vala:61: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally12:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_g_object_unref0 (_data_->results);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


GeeList*
panther_backend_synapse_search_find_actions_for_match (SynapseMatch* match)
{
	GeeList* result = NULL;
	SynapseDataSink* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = panther_backend_synapse_search_sink;
	_tmp1_ = synapse_data_sink_find_actions_for_match (_tmp0_, match, NULL, SYNAPSE_QUERY_FLAGS_ALL);
	result = _tmp1_;
	return result;
}


static void
panther_backend_synapse_search_get_favicon_for_match_data_free (gpointer _data)
{
	PantherBackendSynapseSearchGetFaviconForMatchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->match);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (PantherBackendSynapseSearchGetFaviconForMatchData, _data_);
}


static void
panther_backend_synapse_search_get_favicon_for_match_async_ready_wrapper (GObject *source_object,
                                                                          GAsyncResult *res,
                                                                          void *user_data)
{
	PantherBackendSynapseSearchGetFaviconForMatchData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
panther_backend_synapse_search_get_favicon_for_match (SynapseUriMatch* match,
                                                      gint size,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	PantherBackendSynapseSearchGetFaviconForMatchData* _data_;
	SynapseUriMatch* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (PantherBackendSynapseSearchGetFaviconForMatchData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, cancellable, panther_backend_synapse_search_get_favicon_for_match_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, panther_backend_synapse_search_get_favicon_for_match_data_free);
	_tmp0_ = _g_object_ref0 (match);
	_g_object_unref0 (_data_->match);
	_data_->match = _tmp0_;
	_data_->size = size;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	panther_backend_synapse_search_get_favicon_for_match_co (_data_);
}


GdkPixbuf*
panther_backend_synapse_search_get_favicon_for_match_finish (GAsyncResult* _res_)
{
	GdkPixbuf* result;
	PantherBackendSynapseSearchGetFaviconForMatchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
         * Attempts to load a favicon for an UriMatch and caches the icon
         *
         * @param match       The UriMatch
         * @param size        The icon size at which to load the icon. If the favicon is smaller than
         *                    that size, null will be returned
         * @param cancellable Cancellable for the loading operations
         * @return            The pixbuf or null if loading failed or the icon was too small
         */
static void
_vala_SoupURI_free (SoupURI* self)
{
	g_boxed_free (soup_uri_get_type (), self);
}


static void
panther_backend_synapse_search_get_favicon_for_match_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	PantherBackendSynapseSearchGetFaviconForMatchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	panther_backend_synapse_search_get_favicon_for_match_co (_data_);
}


static gboolean
panther_backend_synapse_search_get_favicon_for_match_co (PantherBackendSynapseSearchGetFaviconForMatchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = synapse_uri_match_get_uri (_data_->match);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = soup_uri_new (_data_->_tmp1_);
	_data_->soup_uri = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->soup_uri;
	_data_->_tmp4_ = _data_->_tmp3_->scheme;
	if (!g_str_has_prefix (_data_->_tmp4_, "http")) {
		_data_->result = NULL;
		__vala_SoupURI_free0 (_data_->soup_uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->pixbuf = NULL;
	_data_->_tmp5_ = panther_backend_synapse_search_favicon_cache;
	_data_->_tmp6_ = _data_->soup_uri;
	_data_->_tmp7_ = _data_->_tmp6_->host;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp5_, _data_->_tmp7_)) {
		_data_->_tmp8_ = panther_backend_synapse_search_favicon_cache;
		_data_->_tmp9_ = _data_->soup_uri;
		_data_->_tmp10_ = _data_->_tmp9_->host;
		_data_->_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp8_, _data_->_tmp10_);
		_data_->result = (GdkPixbuf*) _data_->_tmp11_;
		_g_object_unref0 (_data_->pixbuf);
		__vala_SoupURI_free0 (_data_->soup_uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->soup_uri;
	_data_->_tmp13_ = _data_->_tmp12_->scheme;
	_data_->_tmp14_ = _data_->soup_uri;
	_data_->_tmp15_ = _data_->_tmp14_->host;
	_data_->_tmp16_ = g_strdup_printf ("%s://%s/favicon.ico", _data_->_tmp13_, _data_->_tmp15_);
	_data_->url = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->url;
	_data_->_tmp18_ = soup_message_new ("GET", _data_->_tmp17_);
	_data_->msg = _data_->_tmp18_;
	_data_->_tmp19_ = soup_session_new ();
	_data_->session = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->session;
	g_object_set (_data_->_tmp20_, "use-thread-context", TRUE, NULL);
	{
		_data_->_tmp21_ = _data_->session;
		_data_->_tmp22_ = _data_->msg;
		_data_->_state_ = 1;
		soup_session_send_async (_data_->_tmp21_, _data_->_tmp22_, _data_->cancellable, panther_backend_synapse_search_get_favicon_for_match_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp23_ = soup_session_send_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error_);
		_data_->stream = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
		_data_->_tmp24_ = _data_->stream;
		if (_data_->_tmp24_ != NULL) {
			_data_->_tmp26_ = _data_->stream;
			_data_->_state_ = 2;
			gdk_pixbuf_new_from_stream_async (_data_->_tmp26_, _data_->cancellable, panther_backend_synapse_search_get_favicon_for_match_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp27_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp25_ = _data_->_tmp27_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->stream);
				goto __catch13_g_error;
			}
			_data_->_tmp28_ = _data_->_tmp25_;
			_data_->_tmp25_ = NULL;
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp28_;
			_data_->_tmp29_ = _data_->pixbuf;
			_data_->_tmp30_ = gdk_pixbuf_get_width (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			if (_data_->_tmp31_ < _data_->size) {
				_g_object_unref0 (_data_->pixbuf);
				_data_->pixbuf = NULL;
			}
			_g_object_unref0 (_data_->_tmp25_);
		}
		_g_object_unref0 (_data_->stream);
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally13:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->msg);
		_g_free0 (_data_->url);
		_g_object_unref0 (_data_->pixbuf);
		__vala_SoupURI_free0 (_data_->soup_uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->msg);
		_g_free0 (_data_->url);
		_g_object_unref0 (_data_->pixbuf);
		__vala_SoupURI_free0 (_data_->soup_uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!_data_->_task_complete_) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = panther_backend_synapse_search_favicon_cache;
	_data_->_tmp33_ = _data_->soup_uri;
	_data_->_tmp34_ = _data_->_tmp33_->host;
	_data_->_tmp35_ = _data_->pixbuf;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp32_, _data_->_tmp34_, _data_->_tmp35_);
	_data_->result = _data_->pixbuf;
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->msg);
	_g_free0 (_data_->url);
	__vala_SoupURI_free0 (_data_->soup_uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


gchar*
panther_backend_synapse_search_markup_string_with_search (const gchar* text,
                                                          const gchar* pattern)
{
	gchar* result = NULL;
	gchar* markup = NULL;
	gchar* _tmp0_;
	GeeList* matchers = NULL;
	GeeList* _tmp11_;
	gchar* highlighted = NULL;
	const gchar* _tmp68_;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (pattern != NULL, NULL);
	_tmp0_ = g_strdup ("%s");
	markup = _tmp0_;
	if (g_strcmp0 (pattern, "") == 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = markup;
		_tmp2_ = g_markup_escape_text (text, (gssize) -1);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		result = _tmp5_;
		_g_free0 (markup);
		return result;
	}
	if (g_strcmp0 (text, "") == 0) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = markup;
		_tmp7_ = g_markup_escape_text (pattern, (gssize) -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		result = _tmp10_;
		_g_free0 (markup);
		return result;
	}
	_tmp11_ = synapse_query_get_matchers_for_query (pattern, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
	matchers = _tmp11_;
	highlighted = NULL;
	{
		GeeList* _matcher_list = NULL;
		GeeList* _tmp12_;
		GeeList* _tmp13_;
		gint _matcher_size = 0;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _matcher_index = 0;
		_tmp12_ = matchers;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_matcher_list = _tmp13_;
		_tmp14_ = _matcher_list;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_matcher_size = _tmp16_;
		_matcher_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeMapEntry* matcher = NULL;
			GeeList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			GMatchInfo* mi = NULL;
			GeeMapEntry* _tmp23_;
			gconstpointer _tmp24_;
			GRegex* _tmp25_;
			GMatchInfo* _tmp26_ = NULL;
			gboolean _tmp27_;
			_tmp17_ = _matcher_index;
			_matcher_index = _tmp17_ + 1;
			_tmp18_ = _matcher_index;
			_tmp19_ = _matcher_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _matcher_list;
			_tmp21_ = _matcher_index;
			_tmp22_ = gee_list_get (_tmp20_, _tmp21_);
			matcher = (GeeMapEntry*) _tmp22_;
			_tmp23_ = matcher;
			_tmp24_ = gee_map_entry_get_key (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp27_ = g_regex_match ((GRegex*) _tmp25_, text, 0, &_tmp26_);
			_g_match_info_unref0 (mi);
			mi = _tmp26_;
			if (_tmp27_) {
				gint start_pos = 0;
				gint end_pos = 0;
				gint last_pos = 0;
				gint cnt = 0;
				GMatchInfo* _tmp28_;
				GString* res = NULL;
				GString* _tmp29_;
				GString* _tmp65_;
				const gchar* _tmp66_;
				gchar* _tmp67_;
				last_pos = 0;
				_tmp28_ = mi;
				cnt = g_match_info_get_match_count (_tmp28_);
				_tmp29_ = g_string_new ("");
				res = _tmp29_;
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							gint _tmp32_;
							gint _tmp33_;
							GMatchInfo* _tmp34_;
							gint _tmp35_;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gboolean _tmp38_ = FALSE;
							gint _tmp39_;
							GString* _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							gchar* _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
							gchar* _tmp48_;
							gint _tmp49_;
							GString* _tmp50_;
							GMatchInfo* _tmp51_;
							gint _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							gint _tmp57_;
							gint _tmp58_;
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = i;
								i = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							_tmp32_ = i;
							_tmp33_ = cnt;
							if (!(_tmp32_ < _tmp33_)) {
								break;
							}
							_tmp34_ = mi;
							_tmp35_ = i;
							g_match_info_fetch_pos (_tmp34_, _tmp35_, &_tmp36_, &_tmp37_);
							start_pos = _tmp36_;
							end_pos = _tmp37_;
							_tmp39_ = start_pos;
							if (_tmp39_ >= 0) {
								gint _tmp40_;
								_tmp40_ = end_pos;
								_tmp38_ = _tmp40_ >= 0;
							} else {
								_tmp38_ = FALSE;
							}
							g_warn_if_fail (_tmp38_);
							_tmp41_ = res;
							_tmp42_ = last_pos;
							_tmp43_ = start_pos;
							_tmp44_ = last_pos;
							_tmp45_ = string_substring (text, (glong) _tmp42_, (glong) (_tmp43_ - _tmp44_));
							_tmp46_ = _tmp45_;
							_tmp47_ = g_markup_escape_text (_tmp46_, (gssize) -1);
							_tmp48_ = _tmp47_;
							g_string_append (_tmp41_, _tmp48_);
							_g_free0 (_tmp48_);
							_g_free0 (_tmp46_);
							_tmp49_ = end_pos;
							last_pos = _tmp49_;
							_tmp50_ = res;
							_tmp51_ = mi;
							_tmp52_ = i;
							_tmp53_ = g_match_info_fetch (_tmp51_, _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = g_markup_printf_escaped ("<b>%s</b>", _tmp54_);
							_tmp56_ = _tmp55_;
							g_string_append (_tmp50_, _tmp56_);
							_g_free0 (_tmp56_);
							_g_free0 (_tmp54_);
							_tmp57_ = i;
							_tmp58_ = cnt;
							if (_tmp57_ == (_tmp58_ - 1)) {
								GString* _tmp59_;
								gint _tmp60_;
								gchar* _tmp61_;
								gchar* _tmp62_;
								gchar* _tmp63_;
								gchar* _tmp64_;
								_tmp59_ = res;
								_tmp60_ = last_pos;
								_tmp61_ = string_substring (text, (glong) _tmp60_, (glong) -1);
								_tmp62_ = _tmp61_;
								_tmp63_ = g_markup_escape_text (_tmp62_, (gssize) -1);
								_tmp64_ = _tmp63_;
								g_string_append (_tmp59_, _tmp64_);
								_g_free0 (_tmp64_);
								_g_free0 (_tmp62_);
							}
						}
					}
				}
				_tmp65_ = res;
				_tmp66_ = _tmp65_->str;
				_tmp67_ = g_strdup (_tmp66_);
				_g_free0 (highlighted);
				highlighted = _tmp67_;
				_g_string_free0 (res);
				_g_match_info_unref0 (mi);
				_g_object_unref0 (matcher);
				break;
			}
			_g_match_info_unref0 (mi);
			_g_object_unref0 (matcher);
		}
		_g_object_unref0 (_matcher_list);
	}
	_tmp68_ = highlighted;
	if (_tmp68_ != NULL) {
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp69_ = markup;
		_tmp70_ = highlighted;
		_tmp71_ = g_strdup_printf (_tmp69_, _tmp70_);
		result = _tmp71_;
		_g_free0 (highlighted);
		_g_object_unref0 (matchers);
		_g_free0 (markup);
		return result;
	} else {
		const gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		_tmp72_ = markup;
		_tmp73_ = g_markup_escape_text (text, (gssize) -1);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf (_tmp72_, _tmp74_);
		_tmp76_ = _tmp75_;
		_g_free0 (_tmp74_);
		result = _tmp76_;
		_g_free0 (highlighted);
		_g_object_unref0 (matchers);
		_g_free0 (markup);
		return result;
	}
	_g_free0 (highlighted);
	_g_object_unref0 (matchers);
	_g_free0 (markup);
}


static void
panther_backend_synapse_search_class_init (PantherBackendSynapseSearchClass * klass)
{
	GType* _tmp0_;
	panther_backend_synapse_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantherBackendSynapseSearch_private_offset);
	G_OBJECT_CLASS (klass)->finalize = panther_backend_synapse_search_finalize;
	_tmp0_ = g_new0 (GType, 4);
	_tmp0_[0] = SYNAPSE_TYPE_CALCULATOR_PLUGIN;
	_tmp0_[1] = SYNAPSE_TYPE_COMMAND_PLUGIN;
	_tmp0_[2] = SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN;
	_tmp0_[3] = SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN;
	panther_backend_synapse_search_plugins = _tmp0_;
	panther_backend_synapse_search_plugins_length1 = 4;
}


static void
panther_backend_synapse_search_instance_init (PantherBackendSynapseSearch * self)
{
	self->priv = panther_backend_synapse_search_get_instance_private (self);
	self->priv->current_search = NULL;
}


static void
panther_backend_synapse_search_finalize (GObject * obj)
{
	PantherBackendSynapseSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHER_BACKEND_TYPE_SYNAPSE_SEARCH, PantherBackendSynapseSearch);
	_g_object_unref0 (self->priv->current_search);
	G_OBJECT_CLASS (panther_backend_synapse_search_parent_class)->finalize (obj);
}


GType
panther_backend_synapse_search_get_type (void)
{
	static volatile gsize panther_backend_synapse_search_type_id__volatile = 0;
	if (g_once_init_enter (&panther_backend_synapse_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PantherBackendSynapseSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panther_backend_synapse_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantherBackendSynapseSearch), 0, (GInstanceInitFunc) panther_backend_synapse_search_instance_init, NULL };
		GType panther_backend_synapse_search_type_id;
		panther_backend_synapse_search_type_id = g_type_register_static (G_TYPE_OBJECT, "PantherBackendSynapseSearch", &g_define_type_info, 0);
		PantherBackendSynapseSearch_private_offset = g_type_add_instance_private (panther_backend_synapse_search_type_id, sizeof (PantherBackendSynapseSearchPrivate));
		g_once_init_leave (&panther_backend_synapse_search_type_id__volatile, panther_backend_synapse_search_type_id);
	}
	return panther_backend_synapse_search_type_id__volatile;
}



