/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

namespace Synapse {
	public interface Activatable : Object {
		// this property will eventually go away
		public abstract bool enabled { get; set; default = true; }

		public abstract void activate ();
		public abstract void deactivate ();
	}

	public interface Configurable : Object {
		public abstract Gtk.Widget create_config_widget ();
	}

	public interface ItemProvider : Activatable {
		public abstract async ResultSet? search (Query query) throws SearchError;
		public virtual bool handles_query (Query query) {
			return true;
		}

		public virtual bool handles_empty_query () {
			return false;
		}
	}

	public interface ActionProvider : Activatable {
		public abstract ResultSet? find_for_match (ref Query query, Match match);
		public virtual bool handles_unknown () {
			return false;
		}
	}
}
