/* SearchItem.c generated by valac 0.48.13, the Vala compiler
 * generated from SearchItem.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "synapse-core.h"
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM (launcher_widgets_search_item_get_type ())
#define LAUNCHER_WIDGETS_SEARCH_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, LauncherWidgetsSearchItem))
#define LAUNCHER_WIDGETS_SEARCH_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, LauncherWidgetsSearchItemClass))
#define LAUNCHER_WIDGETS_IS_SEARCH_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM))
#define LAUNCHER_WIDGETS_IS_SEARCH_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM))
#define LAUNCHER_WIDGETS_SEARCH_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, LauncherWidgetsSearchItemClass))

typedef struct _LauncherWidgetsSearchItem LauncherWidgetsSearchItem;
typedef struct _LauncherWidgetsSearchItemClass LauncherWidgetsSearchItemClass;
typedef struct _LauncherWidgetsSearchItemPrivate LauncherWidgetsSearchItemPrivate;

#define LAUNCHER_BACKEND_TYPE_APP (launcher_backend_app_get_type ())
#define LAUNCHER_BACKEND_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendApp))
#define LAUNCHER_BACKEND_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendAppClass))
#define LAUNCHER_BACKEND_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_BACKEND_TYPE_APP))
#define LAUNCHER_BACKEND_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_BACKEND_TYPE_APP))
#define LAUNCHER_BACKEND_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendAppClass))

typedef struct _LauncherBackendApp LauncherBackendApp;
typedef struct _LauncherBackendAppClass LauncherBackendAppClass;
enum  {
	LAUNCHER_WIDGETS_SEARCH_ITEM_0_PROPERTY,
	LAUNCHER_WIDGETS_SEARCH_ITEM_APP_PROPERTY,
	LAUNCHER_WIDGETS_SEARCH_ITEM_NUM_PROPERTIES
};
static GParamSpec* launcher_widgets_search_item_properties[LAUNCHER_WIDGETS_SEARCH_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	LAUNCHER_WIDGETS_SEARCH_ITEM_LAUNCH_APP_SIGNAL,
	LAUNCHER_WIDGETS_SEARCH_ITEM_NUM_SIGNALS
};
static guint launcher_widgets_search_item_signals[LAUNCHER_WIDGETS_SEARCH_ITEM_NUM_SIGNALS] = {0};

struct _LauncherWidgetsSearchItem {
	GtkButton parent_instance;
	LauncherWidgetsSearchItemPrivate * priv;
	gboolean dragging;
	gboolean action;
};

struct _LauncherWidgetsSearchItemClass {
	GtkButtonClass parent_class;
};

struct _LauncherWidgetsSearchItemPrivate {
	LauncherBackendApp* _app;
	GtkLabel* name_label;
	GtkImage* icon;
	GCancellable* cancellable;
};

struct _Block11Data {
	int _ref_count_;
	LauncherWidgetsSearchItem* self;
	SynapseApplicationMatch* app_match;
	LauncherBackendApp* app;
};

static gint LauncherWidgetsSearchItem_private_offset;
static gpointer launcher_widgets_search_item_parent_class = NULL;

GType launcher_widgets_search_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherWidgetsSearchItem, g_object_unref)
GType launcher_backend_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherBackendApp, g_object_unref)
#define LAUNCHER_WIDGETS_SEARCH_ITEM_ICON_SIZE 32
LauncherWidgetsSearchItem* launcher_widgets_search_item_new (LauncherBackendApp* app,
                                                             const gchar* search_term,
                                                             gboolean action,
                                                             const gchar* action_title);
LauncherWidgetsSearchItem* launcher_widgets_search_item_construct (GType object_type,
                                                                   LauncherBackendApp* app,
                                                                   const gchar* search_term,
                                                                   gboolean action,
                                                                   const gchar* action_title);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
gchar* launcher_backend_synapse_search_markup_string_with_search (const gchar* text,
                                                                  const gchar* pattern);
const gchar* launcher_backend_app_get_name (LauncherBackendApp* self);
GdkPixbuf* launcher_backend_app_load_icon (LauncherBackendApp* self,
                                           gint size);
SynapseMatch* launcher_backend_app_get_match (LauncherBackendApp* self);
void launcher_backend_synapse_search_get_favicon_for_match (SynapseUriMatch* match,
                                                            gint size,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
GdkPixbuf* launcher_backend_synapse_search_get_favicon_for_match_finish (GAsyncResult* _res_);
static void ___lambda24_ (LauncherWidgetsSearchItem* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda24__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
gboolean launcher_backend_app_launch (LauncherBackendApp* self);
static gboolean _launcher_backend_app_launch_launcher_widgets_search_item_launch_app (LauncherWidgetsSearchItem* _sender,
                                                                               gpointer self);
static void ___lambda25_ (Block11Data* _data11_,
                   GdkDragContext* ctx);
GdkPixbuf* launcher_backend_app_get_icon (LauncherBackendApp* self);
static void ____lambda25__gtk_widget_drag_begin (GtkWidget* _sender,
                                          GdkDragContext* context,
                                          gpointer self);
static void ___lambda26_ (LauncherWidgetsSearchItem* self);
static void ____lambda26__gtk_widget_drag_end (GtkWidget* _sender,
                                        GdkDragContext* context,
                                        gpointer self);
static void ___lambda27_ (Block11Data* _data11_,
                   GdkDragContext* ctx,
                   GtkSelectionData* sel,
                   guint info,
                   guint time);
static void ____lambda27__gtk_widget_drag_data_get (GtkWidget* _sender,
                                             GdkDragContext* context,
                                             GtkSelectionData* selection_data,
                                             guint info,
                                             guint time_,
                                             gpointer self);
static void launcher_widgets_search_item_real_destroy (GtkWidget* base);
LauncherBackendApp* launcher_widgets_search_item_get_app (LauncherWidgetsSearchItem* self);
static void launcher_widgets_search_item_set_app (LauncherWidgetsSearchItem* self,
                                           LauncherBackendApp* value);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void launcher_widgets_search_item_finalize (GObject * obj);
static GType launcher_widgets_search_item_get_type_once (void);
static void _vala_launcher_widgets_search_item_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_launcher_widgets_search_item_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
launcher_widgets_search_item_get_instance_private (LauncherWidgetsSearchItem* self)
{
	return G_STRUCT_MEMBER_P (self, LauncherWidgetsSearchItem_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "../src/Widgets/SearchItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 193 "SearchItem.c"
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 38 "../src/Widgets/SearchItem.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 38 "../src/Widgets/SearchItem.vala"
	return _data11_;
#line 203 "SearchItem.c"
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 38 "../src/Widgets/SearchItem.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 213 "SearchItem.c"
		LauncherWidgetsSearchItem* self;
#line 38 "../src/Widgets/SearchItem.vala"
		self = _data11_->self;
#line 38 "../src/Widgets/SearchItem.vala"
		_g_object_unref0 (_data11_->app_match);
#line 38 "../src/Widgets/SearchItem.vala"
		_g_object_unref0 (_data11_->app);
#line 38 "../src/Widgets/SearchItem.vala"
		_g_object_unref0 (self);
#line 38 "../src/Widgets/SearchItem.vala"
		g_slice_free (Block11Data, _data11_);
#line 225 "SearchItem.c"
	}
}

static void
___lambda24_ (LauncherWidgetsSearchItem* self,
              GObject* obj,
              GAsyncResult* res)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 63 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (res != NULL);
#line 65 "../src/Widgets/SearchItem.vala"
	_tmp0_ = launcher_backend_synapse_search_get_favicon_for_match_finish (res);
#line 65 "../src/Widgets/SearchItem.vala"
	pixbuf = _tmp0_;
#line 66 "../src/Widgets/SearchItem.vala"
	_tmp1_ = pixbuf;
#line 66 "../src/Widgets/SearchItem.vala"
	if (_tmp1_ != NULL) {
#line 247 "SearchItem.c"
		GtkImage* _tmp2_;
		GdkPixbuf* _tmp3_;
#line 67 "../src/Widgets/SearchItem.vala"
		_tmp2_ = self->priv->icon;
#line 67 "../src/Widgets/SearchItem.vala"
		_tmp3_ = pixbuf;
#line 67 "../src/Widgets/SearchItem.vala"
		gtk_image_set_from_pixbuf (_tmp2_, _tmp3_);
#line 256 "SearchItem.c"
	}
#line 63 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (pixbuf);
#line 260 "SearchItem.c"
}

static void
____lambda24__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
#line 62 "../src/Widgets/SearchItem.vala"
	___lambda24_ ((LauncherWidgetsSearchItem*) self, source_object, res);
#line 62 "../src/Widgets/SearchItem.vala"
	g_object_unref (self);
#line 272 "SearchItem.c"
}

static gboolean
_launcher_backend_app_launch_launcher_widgets_search_item_launch_app (LauncherWidgetsSearchItem* _sender,
                                                                      gpointer self)
{
	gboolean result;
	result = launcher_backend_app_launch ((LauncherBackendApp*) self);
#line 80 "../src/Widgets/SearchItem.vala"
	return result;
#line 283 "SearchItem.c"
}

static void
___lambda25_ (Block11Data* _data11_,
              GdkDragContext* ctx)
{
	LauncherWidgetsSearchItem* self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 87 "../src/Widgets/SearchItem.vala"
	self = _data11_->self;
#line 87 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (ctx != NULL);
#line 88 "../src/Widgets/SearchItem.vala"
	self->dragging = TRUE;
#line 89 "../src/Widgets/SearchItem.vala"
	_tmp0_ = launcher_backend_app_get_icon (_data11_->app);
#line 89 "../src/Widgets/SearchItem.vala"
	_tmp1_ = _tmp0_;
#line 89 "../src/Widgets/SearchItem.vala"
	gtk_drag_set_icon_pixbuf (ctx, _tmp1_, 0, 0);
#line 305 "SearchItem.c"
}

static void
____lambda25__gtk_widget_drag_begin (GtkWidget* _sender,
                                     GdkDragContext* context,
                                     gpointer self)
{
#line 87 "../src/Widgets/SearchItem.vala"
	___lambda25_ (self, context);
#line 315 "SearchItem.c"
}

static void
___lambda26_ (LauncherWidgetsSearchItem* self)
{
#line 92 "../src/Widgets/SearchItem.vala"
	self->dragging = FALSE;
#line 323 "SearchItem.c"
}

static void
____lambda26__gtk_widget_drag_end (GtkWidget* _sender,
                                   GdkDragContext* context,
                                   gpointer self)
{
#line 91 "../src/Widgets/SearchItem.vala"
	___lambda26_ ((LauncherWidgetsSearchItem*) self);
#line 333 "SearchItem.c"
}

static void
___lambda27_ (Block11Data* _data11_,
              GdkDragContext* ctx,
              GtkSelectionData* sel,
              guint info,
              guint time)
{
	LauncherWidgetsSearchItem* self;
	SynapseApplicationMatch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
#line 94 "../src/Widgets/SearchItem.vala"
	self = _data11_->self;
#line 94 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (ctx != NULL);
#line 94 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (sel != NULL);
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp0_ = _data11_->app_match;
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp1_ = synapse_application_match_get_filename (_tmp0_);
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp2_ = _tmp1_;
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp4_ = _tmp3_;
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp5_ = g_file_get_uri (_tmp4_);
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp6_ = g_new0 (gchar*, 1 + 1);
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp6_[0] = _tmp5_;
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp7_ = _tmp6_;
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp7__length1 = 1;
#line 95 "../src/Widgets/SearchItem.vala"
	gtk_selection_data_set_uris (sel, _tmp7_);
#line 95 "../src/Widgets/SearchItem.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 95 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (_tmp4_);
#line 385 "SearchItem.c"
}

static void
____lambda27__gtk_widget_drag_data_get (GtkWidget* _sender,
                                        GdkDragContext* context,
                                        GtkSelectionData* selection_data,
                                        guint info,
                                        guint time_,
                                        gpointer self)
{
#line 94 "../src/Widgets/SearchItem.vala"
	___lambda27_ (self, context, selection_data, info, time_);
#line 398 "SearchItem.c"
}

LauncherWidgetsSearchItem*
launcher_widgets_search_item_construct (GType object_type,
                                        LauncherBackendApp* app,
                                        const gchar* search_term,
                                        gboolean action,
                                        const gchar* action_title)
{
	LauncherWidgetsSearchItem * self = NULL;
	Block11Data* _data11_;
	LauncherBackendApp* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gchar* markup = NULL;
	const gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	GtkImage* _tmp14_;
	SynapseUriMatch* uri_match = NULL;
	SynapseMatch* _tmp15_;
	SynapseMatch* _tmp16_;
	SynapseUriMatch* _tmp17_;
	gboolean _tmp18_ = FALSE;
	SynapseUriMatch* _tmp19_;
	GtkBox* box = NULL;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkImage* _tmp32_;
	GtkBox* _tmp33_;
	GtkLabel* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	SynapseMatch* _tmp39_;
	SynapseMatch* _tmp40_;
	SynapseApplicationMatch* _tmp41_;
	SynapseApplicationMatch* _tmp42_;
#line 38 "../src/Widgets/SearchItem.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 38 "../src/Widgets/SearchItem.vala"
	g_return_val_if_fail (search_term != NULL, NULL);
#line 38 "../src/Widgets/SearchItem.vala"
	g_return_val_if_fail (action_title != NULL, NULL);
#line 38 "../src/Widgets/SearchItem.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 38 "../src/Widgets/SearchItem.vala"
	_data11_->_ref_count_ = 1;
#line 38 "../src/Widgets/SearchItem.vala"
	_tmp0_ = _g_object_ref0 (app);
#line 38 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (_data11_->app);
#line 38 "../src/Widgets/SearchItem.vala"
	_data11_->app = _tmp0_;
#line 39 "../src/Widgets/SearchItem.vala"
	self = (LauncherWidgetsSearchItem*) g_object_new (object_type, "app", _data11_->app, NULL);
#line 39 "../src/Widgets/SearchItem.vala"
	_data11_->self = g_object_ref (self);
#line 41 "../src/Widgets/SearchItem.vala"
	self->action = action;
#line 42 "../src/Widgets/SearchItem.vala"
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 42 "../src/Widgets/SearchItem.vala"
	gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_FLAT);
#line 43 "../src/Widgets/SearchItem.vala"
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 43 "../src/Widgets/SearchItem.vala"
	gtk_style_context_add_class (_tmp2_, "app_button");
#line 46 "../src/Widgets/SearchItem.vala"
	if (action) {
#line 474 "SearchItem.c"
		gchar* _tmp3_;
#line 47 "../src/Widgets/SearchItem.vala"
		_tmp3_ = g_strdup (action_title);
#line 47 "../src/Widgets/SearchItem.vala"
		_g_free0 (markup);
#line 47 "../src/Widgets/SearchItem.vala"
		markup = _tmp3_;
#line 482 "SearchItem.c"
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 49 "../src/Widgets/SearchItem.vala"
		_tmp4_ = launcher_backend_app_get_name (_data11_->app);
#line 49 "../src/Widgets/SearchItem.vala"
		_tmp5_ = _tmp4_;
#line 49 "../src/Widgets/SearchItem.vala"
		_tmp6_ = launcher_backend_synapse_search_markup_string_with_search (_tmp5_, search_term);
#line 49 "../src/Widgets/SearchItem.vala"
		_g_free0 (markup);
#line 49 "../src/Widgets/SearchItem.vala"
		markup = _tmp6_;
#line 497 "SearchItem.c"
	}
#line 51 "../src/Widgets/SearchItem.vala"
	_tmp7_ = markup;
#line 51 "../src/Widgets/SearchItem.vala"
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
#line 51 "../src/Widgets/SearchItem.vala"
	g_object_ref_sink (_tmp8_);
#line 51 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (self->priv->name_label);
#line 51 "../src/Widgets/SearchItem.vala"
	self->priv->name_label = _tmp8_;
#line 52 "../src/Widgets/SearchItem.vala"
	_tmp9_ = self->priv->name_label;
#line 52 "../src/Widgets/SearchItem.vala"
	gtk_label_set_ellipsize (_tmp9_, PANGO_ELLIPSIZE_END);
#line 53 "../src/Widgets/SearchItem.vala"
	_tmp10_ = self->priv->name_label;
#line 53 "../src/Widgets/SearchItem.vala"
	gtk_label_set_use_markup (_tmp10_, TRUE);
#line 54 "../src/Widgets/SearchItem.vala"
	_tmp11_ = self->priv->name_label;
#line 54 "../src/Widgets/SearchItem.vala"
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_misc_get_type (), GtkMisc), "xalign", 0.0f, NULL);
#line 56 "../src/Widgets/SearchItem.vala"
	_tmp12_ = launcher_backend_app_load_icon (_data11_->app, LAUNCHER_WIDGETS_SEARCH_ITEM_ICON_SIZE);
#line 56 "../src/Widgets/SearchItem.vala"
	_tmp13_ = _tmp12_;
#line 56 "../src/Widgets/SearchItem.vala"
	_tmp14_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp13_);
#line 56 "../src/Widgets/SearchItem.vala"
	g_object_ref_sink (_tmp14_);
#line 56 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (self->priv->icon);
#line 56 "../src/Widgets/SearchItem.vala"
	self->priv->icon = _tmp14_;
#line 56 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (_tmp13_);
#line 59 "../src/Widgets/SearchItem.vala"
	_tmp15_ = launcher_backend_app_get_match (_data11_->app);
#line 59 "../src/Widgets/SearchItem.vala"
	_tmp16_ = _tmp15_;
#line 59 "../src/Widgets/SearchItem.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) _tmp16_) : NULL);
#line 59 "../src/Widgets/SearchItem.vala"
	uri_match = _tmp17_;
#line 60 "../src/Widgets/SearchItem.vala"
	_tmp19_ = uri_match;
#line 60 "../src/Widgets/SearchItem.vala"
	if (_tmp19_ != NULL) {
#line 547 "SearchItem.c"
		gboolean _tmp20_ = FALSE;
		SynapseUriMatch* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
#line 60 "../src/Widgets/SearchItem.vala"
		_tmp21_ = uri_match;
#line 60 "../src/Widgets/SearchItem.vala"
		_tmp22_ = synapse_uri_match_get_uri (_tmp21_);
#line 60 "../src/Widgets/SearchItem.vala"
		_tmp23_ = _tmp22_;
#line 60 "../src/Widgets/SearchItem.vala"
		if (g_str_has_prefix (_tmp23_, "http")) {
#line 60 "../src/Widgets/SearchItem.vala"
			_tmp20_ = TRUE;
#line 562 "SearchItem.c"
		} else {
			SynapseUriMatch* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
#line 60 "../src/Widgets/SearchItem.vala"
			_tmp24_ = uri_match;
#line 60 "../src/Widgets/SearchItem.vala"
			_tmp25_ = synapse_uri_match_get_uri (_tmp24_);
#line 60 "../src/Widgets/SearchItem.vala"
			_tmp26_ = _tmp25_;
#line 60 "../src/Widgets/SearchItem.vala"
			_tmp20_ = g_str_has_prefix (_tmp26_, "https");
#line 575 "SearchItem.c"
		}
#line 60 "../src/Widgets/SearchItem.vala"
		_tmp18_ = _tmp20_;
#line 579 "SearchItem.c"
	} else {
#line 60 "../src/Widgets/SearchItem.vala"
		_tmp18_ = FALSE;
#line 583 "SearchItem.c"
	}
#line 60 "../src/Widgets/SearchItem.vala"
	if (_tmp18_) {
#line 587 "SearchItem.c"
		GCancellable* _tmp27_;
		SynapseUriMatch* _tmp28_;
		GCancellable* _tmp29_;
#line 61 "../src/Widgets/SearchItem.vala"
		_tmp27_ = g_cancellable_new ();
#line 61 "../src/Widgets/SearchItem.vala"
		_g_object_unref0 (self->priv->cancellable);
#line 61 "../src/Widgets/SearchItem.vala"
		self->priv->cancellable = _tmp27_;
#line 62 "../src/Widgets/SearchItem.vala"
		_tmp28_ = uri_match;
#line 62 "../src/Widgets/SearchItem.vala"
		_tmp29_ = self->priv->cancellable;
#line 62 "../src/Widgets/SearchItem.vala"
		launcher_backend_synapse_search_get_favicon_for_match (_tmp28_, LAUNCHER_WIDGETS_SEARCH_ITEM_ICON_SIZE, _tmp29_, ____lambda24__gasync_ready_callback, g_object_ref (self));
#line 603 "SearchItem.c"
	}
#line 71 "../src/Widgets/SearchItem.vala"
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 71 "../src/Widgets/SearchItem.vala"
	g_object_ref_sink (_tmp30_);
#line 71 "../src/Widgets/SearchItem.vala"
	box = _tmp30_;
#line 72 "../src/Widgets/SearchItem.vala"
	_tmp31_ = box;
#line 72 "../src/Widgets/SearchItem.vala"
	_tmp32_ = self->priv->icon;
#line 72 "../src/Widgets/SearchItem.vala"
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, FALSE, TRUE, (guint) 0);
#line 73 "../src/Widgets/SearchItem.vala"
	_tmp33_ = box;
#line 73 "../src/Widgets/SearchItem.vala"
	_tmp34_ = self->priv->name_label;
#line 73 "../src/Widgets/SearchItem.vala"
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
#line 74 "../src/Widgets/SearchItem.vala"
	_tmp35_ = box;
#line 74 "../src/Widgets/SearchItem.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp35_, 12);
#line 75 "../src/Widgets/SearchItem.vala"
	_tmp36_ = box;
#line 75 "../src/Widgets/SearchItem.vala"
	_tmp37_ = box;
#line 75 "../src/Widgets/SearchItem.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp37_, 3);
#line 75 "../src/Widgets/SearchItem.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp36_, 3);
#line 77 "../src/Widgets/SearchItem.vala"
	_tmp38_ = box;
#line 77 "../src/Widgets/SearchItem.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp38_);
#line 79 "../src/Widgets/SearchItem.vala"
	if (!action) {
#line 80 "../src/Widgets/SearchItem.vala"
		g_signal_connect_object (self, "launch-app", (GCallback) _launcher_backend_app_launch_launcher_widgets_search_item_launch_app, _data11_->app, 0);
#line 643 "SearchItem.c"
	}
#line 82 "../src/Widgets/SearchItem.vala"
	_tmp39_ = launcher_backend_app_get_match (_data11_->app);
#line 82 "../src/Widgets/SearchItem.vala"
	_tmp40_ = _tmp39_;
#line 82 "../src/Widgets/SearchItem.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, SYNAPSE_TYPE_APPLICATION_MATCH) ? ((SynapseApplicationMatch*) _tmp40_) : NULL);
#line 82 "../src/Widgets/SearchItem.vala"
	_data11_->app_match = _tmp41_;
#line 83 "../src/Widgets/SearchItem.vala"
	_tmp42_ = _data11_->app_match;
#line 83 "../src/Widgets/SearchItem.vala"
	if (_tmp42_ != NULL) {
#line 657 "SearchItem.c"
		GtkTargetEntry dnd = {0};
		GtkTargetEntry _tmp43_ = {0};
		GtkTargetEntry _tmp44_;
		GtkTargetEntry* _tmp45_;
		GtkTargetEntry* _tmp46_;
		gint _tmp46__length1;
#line 84 "../src/Widgets/SearchItem.vala"
		_tmp43_.target = "text/uri-list";
#line 84 "../src/Widgets/SearchItem.vala"
		_tmp43_.flags = (guint) 0;
#line 84 "../src/Widgets/SearchItem.vala"
		_tmp43_.info = (guint) 0;
#line 84 "../src/Widgets/SearchItem.vala"
		dnd = _tmp43_;
#line 85 "../src/Widgets/SearchItem.vala"
		_tmp44_ = dnd;
#line 85 "../src/Widgets/SearchItem.vala"
		_tmp45_ = g_new0 (GtkTargetEntry, 1);
#line 85 "../src/Widgets/SearchItem.vala"
		_tmp45_[0] = _tmp44_;
#line 85 "../src/Widgets/SearchItem.vala"
		_tmp46_ = _tmp45_;
#line 85 "../src/Widgets/SearchItem.vala"
		_tmp46__length1 = 1;
#line 85 "../src/Widgets/SearchItem.vala"
		gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, _tmp46_, (gint) 1, GDK_ACTION_COPY);
#line 85 "../src/Widgets/SearchItem.vala"
		_tmp46_ = (g_free (_tmp46_), NULL);
#line 87 "../src/Widgets/SearchItem.vala"
		g_signal_connect_data ((GtkWidget*) self, "drag-begin", (GCallback) ____lambda25__gtk_widget_drag_begin, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 91 "../src/Widgets/SearchItem.vala"
		g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) ____lambda26__gtk_widget_drag_end, self, 0);
#line 94 "../src/Widgets/SearchItem.vala"
		g_signal_connect_data ((GtkWidget*) self, "drag-data-get", (GCallback) ____lambda27__gtk_widget_drag_data_get, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 692 "SearchItem.c"
	}
#line 38 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (box);
#line 38 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (uri_match);
#line 38 "../src/Widgets/SearchItem.vala"
	_g_free0 (markup);
#line 38 "../src/Widgets/SearchItem.vala"
	block11_data_unref (_data11_);
#line 38 "../src/Widgets/SearchItem.vala"
	_data11_ = NULL;
#line 38 "../src/Widgets/SearchItem.vala"
	return self;
#line 706 "SearchItem.c"
}

LauncherWidgetsSearchItem*
launcher_widgets_search_item_new (LauncherBackendApp* app,
                                  const gchar* search_term,
                                  gboolean action,
                                  const gchar* action_title)
{
#line 38 "../src/Widgets/SearchItem.vala"
	return launcher_widgets_search_item_construct (LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, app, search_term, action, action_title);
#line 717 "SearchItem.c"
}

static void
launcher_widgets_search_item_real_destroy (GtkWidget* base)
{
	LauncherWidgetsSearchItem * self;
	GCancellable* _tmp0_;
#line 101 "../src/Widgets/SearchItem.vala"
	self = (LauncherWidgetsSearchItem*) base;
#line 103 "../src/Widgets/SearchItem.vala"
	GTK_WIDGET_CLASS (launcher_widgets_search_item_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton));
#line 105 "../src/Widgets/SearchItem.vala"
	_tmp0_ = self->priv->cancellable;
#line 105 "../src/Widgets/SearchItem.vala"
	if (_tmp0_ != NULL) {
#line 733 "SearchItem.c"
		GCancellable* _tmp1_;
#line 106 "../src/Widgets/SearchItem.vala"
		_tmp1_ = self->priv->cancellable;
#line 106 "../src/Widgets/SearchItem.vala"
		g_cancellable_cancel (_tmp1_);
#line 739 "SearchItem.c"
	}
}

LauncherBackendApp*
launcher_widgets_search_item_get_app (LauncherWidgetsSearchItem* self)
{
	LauncherBackendApp* result;
	LauncherBackendApp* _tmp0_;
#line 27 "../src/Widgets/SearchItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 27 "../src/Widgets/SearchItem.vala"
	_tmp0_ = self->priv->_app;
#line 27 "../src/Widgets/SearchItem.vala"
	result = _tmp0_;
#line 27 "../src/Widgets/SearchItem.vala"
	return result;
#line 756 "SearchItem.c"
}

static void
launcher_widgets_search_item_set_app (LauncherWidgetsSearchItem* self,
                                      LauncherBackendApp* value)
{
	LauncherBackendApp* old_value;
#line 27 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (self != NULL);
#line 27 "../src/Widgets/SearchItem.vala"
	old_value = launcher_widgets_search_item_get_app (self);
#line 27 "../src/Widgets/SearchItem.vala"
	if (old_value != value) {
#line 770 "SearchItem.c"
		LauncherBackendApp* _tmp0_;
#line 27 "../src/Widgets/SearchItem.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 27 "../src/Widgets/SearchItem.vala"
		_g_object_unref0 (self->priv->_app);
#line 27 "../src/Widgets/SearchItem.vala"
		self->priv->_app = _tmp0_;
#line 27 "../src/Widgets/SearchItem.vala"
		g_object_notify_by_pspec ((GObject *) self, launcher_widgets_search_item_properties[LAUNCHER_WIDGETS_SEARCH_ITEM_APP_PROPERTY]);
#line 780 "SearchItem.c"
	}
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 23 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (return_value != NULL);
#line 23 "../src/Widgets/SearchItem.vala"
	g_return_if_fail (n_param_values == 1);
#line 23 "../src/Widgets/SearchItem.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 23 "../src/Widgets/SearchItem.vala"
		data1 = closure->data;
#line 23 "../src/Widgets/SearchItem.vala"
		data2 = param_values->data[0].v_pointer;
#line 809 "SearchItem.c"
	} else {
#line 23 "../src/Widgets/SearchItem.vala"
		data1 = param_values->data[0].v_pointer;
#line 23 "../src/Widgets/SearchItem.vala"
		data2 = closure->data;
#line 815 "SearchItem.c"
	}
#line 23 "../src/Widgets/SearchItem.vala"
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
#line 23 "../src/Widgets/SearchItem.vala"
	v_return = callback (data1, data2);
#line 23 "../src/Widgets/SearchItem.vala"
	g_value_set_boolean (return_value, v_return);
#line 823 "SearchItem.c"
}

static void
launcher_widgets_search_item_class_init (LauncherWidgetsSearchItemClass * klass,
                                         gpointer klass_data)
{
#line 23 "../src/Widgets/SearchItem.vala"
	launcher_widgets_search_item_parent_class = g_type_class_peek_parent (klass);
#line 23 "../src/Widgets/SearchItem.vala"
	g_type_class_adjust_private_offset (klass, &LauncherWidgetsSearchItem_private_offset);
#line 23 "../src/Widgets/SearchItem.vala"
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) launcher_widgets_search_item_real_destroy;
#line 23 "../src/Widgets/SearchItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_launcher_widgets_search_item_get_property;
#line 23 "../src/Widgets/SearchItem.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_launcher_widgets_search_item_set_property;
#line 23 "../src/Widgets/SearchItem.vala"
	G_OBJECT_CLASS (klass)->finalize = launcher_widgets_search_item_finalize;
#line 23 "../src/Widgets/SearchItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_WIDGETS_SEARCH_ITEM_APP_PROPERTY, launcher_widgets_search_item_properties[LAUNCHER_WIDGETS_SEARCH_ITEM_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", LAUNCHER_BACKEND_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 23 "../src/Widgets/SearchItem.vala"
	launcher_widgets_search_item_signals[LAUNCHER_WIDGETS_SEARCH_ITEM_LAUNCH_APP_SIGNAL] = g_signal_new ("launch-app", LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
#line 846 "SearchItem.c"
}

static void
launcher_widgets_search_item_instance_init (LauncherWidgetsSearchItem * self,
                                            gpointer klass)
{
#line 23 "../src/Widgets/SearchItem.vala"
	self->priv = launcher_widgets_search_item_get_instance_private (self);
#line 32 "../src/Widgets/SearchItem.vala"
	self->priv->cancellable = NULL;
#line 33 "../src/Widgets/SearchItem.vala"
	self->dragging = FALSE;
#line 34 "../src/Widgets/SearchItem.vala"
	self->action = FALSE;
#line 861 "SearchItem.c"
}

static void
launcher_widgets_search_item_finalize (GObject * obj)
{
	LauncherWidgetsSearchItem * self;
#line 23 "../src/Widgets/SearchItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, LauncherWidgetsSearchItem);
#line 27 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (self->priv->_app);
#line 29 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (self->priv->name_label);
#line 30 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (self->priv->icon);
#line 32 "../src/Widgets/SearchItem.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 23 "../src/Widgets/SearchItem.vala"
	G_OBJECT_CLASS (launcher_widgets_search_item_parent_class)->finalize (obj);
#line 880 "SearchItem.c"
}

static GType
launcher_widgets_search_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LauncherWidgetsSearchItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_widgets_search_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherWidgetsSearchItem), 0, (GInstanceInitFunc) launcher_widgets_search_item_instance_init, NULL };
	GType launcher_widgets_search_item_type_id;
	launcher_widgets_search_item_type_id = g_type_register_static (gtk_button_get_type (), "LauncherWidgetsSearchItem", &g_define_type_info, 0);
	LauncherWidgetsSearchItem_private_offset = g_type_add_instance_private (launcher_widgets_search_item_type_id, sizeof (LauncherWidgetsSearchItemPrivate));
	return launcher_widgets_search_item_type_id;
}

GType
launcher_widgets_search_item_get_type (void)
{
	static volatile gsize launcher_widgets_search_item_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_widgets_search_item_type_id__volatile)) {
		GType launcher_widgets_search_item_type_id;
		launcher_widgets_search_item_type_id = launcher_widgets_search_item_get_type_once ();
		g_once_init_leave (&launcher_widgets_search_item_type_id__volatile, launcher_widgets_search_item_type_id);
	}
	return launcher_widgets_search_item_type_id__volatile;
}

static void
_vala_launcher_widgets_search_item_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	LauncherWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, LauncherWidgetsSearchItem);
#line 23 "../src/Widgets/SearchItem.vala"
	switch (property_id) {
#line 23 "../src/Widgets/SearchItem.vala"
		case LAUNCHER_WIDGETS_SEARCH_ITEM_APP_PROPERTY:
#line 23 "../src/Widgets/SearchItem.vala"
		g_value_set_object (value, launcher_widgets_search_item_get_app (self));
#line 23 "../src/Widgets/SearchItem.vala"
		break;
#line 921 "SearchItem.c"
		default:
#line 23 "../src/Widgets/SearchItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "../src/Widgets/SearchItem.vala"
		break;
#line 927 "SearchItem.c"
	}
}

static void
_vala_launcher_widgets_search_item_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	LauncherWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LAUNCHER_WIDGETS_TYPE_SEARCH_ITEM, LauncherWidgetsSearchItem);
#line 23 "../src/Widgets/SearchItem.vala"
	switch (property_id) {
#line 23 "../src/Widgets/SearchItem.vala"
		case LAUNCHER_WIDGETS_SEARCH_ITEM_APP_PROPERTY:
#line 23 "../src/Widgets/SearchItem.vala"
		launcher_widgets_search_item_set_app (self, g_value_get_object (value));
#line 23 "../src/Widgets/SearchItem.vala"
		break;
#line 947 "SearchItem.c"
		default:
#line 23 "../src/Widgets/SearchItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "../src/Widgets/SearchItem.vala"
		break;
#line 953 "SearchItem.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

