/* Launchy.c generated by valac 0.48.13, the Vala compiler
 * generated from Launchy.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/*  Copyright (C) 2015 Raster Software Vigo*/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define LAUNCHER_TYPE_LAUNCHY (launcher_launchy_get_type ())
#define LAUNCHER_LAUNCHY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_TYPE_LAUNCHY, LauncherLaunchy))
#define LAUNCHER_LAUNCHY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_TYPE_LAUNCHY, LauncherLaunchyClass))
#define LAUNCHER_IS_LAUNCHY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_TYPE_LAUNCHY))
#define LAUNCHER_IS_LAUNCHY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_TYPE_LAUNCHY))
#define LAUNCHER_LAUNCHY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_TYPE_LAUNCHY, LauncherLaunchyClass))

typedef struct _LauncherLaunchy LauncherLaunchy;
typedef struct _LauncherLaunchyClass LauncherLaunchyClass;
typedef struct _LauncherLaunchyPrivate LauncherLaunchyPrivate;

#define LAUNCHER_TYPE_LAUNCHY_VIEW (launcher_launchy_view_get_type ())
#define LAUNCHER_LAUNCHY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_TYPE_LAUNCHY_VIEW, LauncherLaunchyView))
#define LAUNCHER_LAUNCHY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_TYPE_LAUNCHY_VIEW, LauncherLaunchyViewClass))
#define LAUNCHER_IS_LAUNCHY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_TYPE_LAUNCHY_VIEW))
#define LAUNCHER_IS_LAUNCHY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_TYPE_LAUNCHY_VIEW))
#define LAUNCHER_LAUNCHY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_TYPE_LAUNCHY_VIEW, LauncherLaunchyViewClass))

typedef struct _LauncherLaunchyView LauncherLaunchyView;
typedef struct _LauncherLaunchyViewClass LauncherLaunchyViewClass;

#define LAUNCHER_TYPE_TEST_CLIENT (launcher_test_client_get_type ())
#define LAUNCHER_TEST_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_TYPE_TEST_CLIENT, LauncherTestClient))
#define LAUNCHER_TEST_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_TYPE_TEST_CLIENT, LauncherTestClientClass))
#define LAUNCHER_IS_TEST_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_TYPE_TEST_CLIENT))
#define LAUNCHER_IS_TEST_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_TYPE_TEST_CLIENT))
#define LAUNCHER_TEST_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_TYPE_TEST_CLIENT, LauncherTestClientClass))

typedef struct _LauncherTestClient LauncherTestClient;
typedef struct _LauncherTestClientClass LauncherTestClientClass;

#define LAUNCHER_TYPE_DBUS_SERVICE (launcher_dbus_service_get_type ())
#define LAUNCHER_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_TYPE_DBUS_SERVICE, LauncherDBusService))
#define LAUNCHER_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_TYPE_DBUS_SERVICE, LauncherDBusServiceClass))
#define LAUNCHER_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_TYPE_DBUS_SERVICE))
#define LAUNCHER_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_TYPE_DBUS_SERVICE))
#define LAUNCHER_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_TYPE_DBUS_SERVICE, LauncherDBusServiceClass))

typedef struct _LauncherDBusService LauncherDBusService;
typedef struct _LauncherDBusServiceClass LauncherDBusServiceClass;
enum  {
	LAUNCHER_LAUNCHY_0_PROPERTY,
	LAUNCHER_LAUNCHY_SET_VIEW_WIDTH_PROPERTY,
	LAUNCHER_LAUNCHY_SET_VIEW_HEIGHT_PROPERTY,
	LAUNCHER_LAUNCHY_NUM_PROPERTIES
};
static GParamSpec* launcher_launchy_properties[LAUNCHER_LAUNCHY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define LAUNCHER_TYPE_SETTINGS (launcher_settings_get_type ())
#define LAUNCHER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_TYPE_SETTINGS, LauncherSettings))
#define LAUNCHER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_TYPE_SETTINGS, LauncherSettingsClass))
#define LAUNCHER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_TYPE_SETTINGS))
#define LAUNCHER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_TYPE_SETTINGS))
#define LAUNCHER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_TYPE_SETTINGS, LauncherSettingsClass))

typedef struct _LauncherSettings LauncherSettings;
typedef struct _LauncherSettingsClass LauncherSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define TYPE_REMOTE_CONTROL (remote_control_get_type ())
#define REMOTE_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REMOTE_CONTROL, RemoteControl))
#define REMOTE_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REMOTE_CONTROL, RemoteControlClass))
#define IS_REMOTE_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REMOTE_CONTROL))
#define IS_REMOTE_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REMOTE_CONTROL))
#define REMOTE_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REMOTE_CONTROL, RemoteControlClass))

typedef struct _RemoteControl RemoteControl;
typedef struct _RemoteControlClass RemoteControlClass;
typedef struct _RemoteControlPrivate RemoteControlPrivate;
enum  {
	REMOTE_CONTROL_0_PROPERTY,
	REMOTE_CONTROL_NUM_PROPERTIES
};
static GParamSpec* remote_control_properties[REMOTE_CONTROL_NUM_PROPERTIES];

struct _LauncherLaunchy {
	GtkApplication parent_instance;
	LauncherLaunchyPrivate * priv;
	LauncherLaunchyView* view;
	gboolean launched;
	GtkToggleButton* app_button;
	LauncherTestClient* client;
	LauncherDBusService* dbus_service;
};

struct _LauncherLaunchyClass {
	GtkApplicationClass parent_class;
};

struct _LauncherLaunchyPrivate {
	gint view_width;
	gint view_height;
};

struct _RemoteControl {
	GObject parent_instance;
	RemoteControlPrivate * priv;
};

struct _RemoteControlClass {
	GObjectClass parent_class;
};

extern LauncherLaunchy* app;
LauncherLaunchy* app = NULL;
static gint LauncherLaunchy_private_offset;
static gpointer launcher_launchy_parent_class = NULL;
extern gboolean launcher_launchy_silent;
extern gboolean launcher_launchy_key_activated;
extern gboolean launcher_launchy_command_mode;
gboolean launcher_launchy_silent = FALSE;
gboolean launcher_launchy_command_mode = FALSE;
gboolean launcher_launchy_key_activated = FALSE;
static LauncherSettings* launcher_launchy__settings;
static LauncherSettings* launcher_launchy__settings = NULL;
static GtkIconTheme* launcher_launchy__icon_theme;
static GtkIconTheme* launcher_launchy__icon_theme = NULL;
extern gint launcher_pixels_ITEM_SIZE;
extern gint launcher_pixels_SIDEBAR_WIDTH;
static gpointer remote_control_parent_class = NULL;

GType launcher_launchy_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherLaunchy, g_object_unref)
GType launcher_launchy_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherLaunchyView, g_object_unref)
GType launcher_test_client_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherTestClient, g_object_unref)
GType launcher_dbus_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherDBusService, g_object_unref)
GType launcher_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherSettings, g_object_unref)
LauncherLaunchy* launcher_launchy_new (void);
LauncherLaunchy* launcher_launchy_construct (GType object_type);
LauncherSettings* launcher_settings_new (void);
LauncherSettings* launcher_settings_construct (GType object_type);
static void launcher_launchy_set_settings (LauncherSettings* value);
LauncherSettings* launcher_launchy_get_settings (void);
gint launcher_settings_get_icon_size (LauncherSettings* self);
#define LAUNCHER_PIXELS_PADDING 25
#define LAUNCHER_PIXELS_SIDEBAR_GRID_PADDING 15
gboolean launcher_launchy_realize_view (LauncherLaunchy* self,
                                        cairo_t* cr);
void launcher_launchy_view_reposition (LauncherLaunchyView* self);
static void launcher_launchy_real_activate (GApplication* base);
LauncherLaunchyView* launcher_launchy_view_new (void);
LauncherLaunchyView* launcher_launchy_view_construct (GType object_type);
LauncherDBusService* launcher_dbus_service_new (LauncherLaunchyView* view);
LauncherDBusService* launcher_dbus_service_construct (GType object_type,
                                                      LauncherLaunchyView* view);
void launcher_launchy_view_show_launchy (LauncherLaunchyView* self);
gint launcher_launchy_main (gchar** args,
                            gint args_length1);
void on_bus_aquired (GDBusConnection* conn);
static void _on_bus_aquired_gbus_acquired_callback (GDBusConnection* connection,
                                             const gchar* name,
                                             gpointer self);
static void __lambda60_ (void);
static void ___lambda60__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda61_ (void);
static void ___lambda61__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
GtkIconTheme* launcher_launchy_get_icon_theme (void);
void launcher_launchy_set_icon_theme (GtkIconTheme* value);
void launcher_launchy_set_set_view_width (LauncherLaunchy* self,
                                          gint value);
void launcher_launchy_set_set_view_height (LauncherLaunchy* self,
                                           gint value);
static GObject * launcher_launchy_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void launcher_launchy_finalize (GObject * obj);
static GType launcher_launchy_get_type_once (void);
static void _vala_launcher_launchy_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_launcher_launchy_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
RemoteControl* remote_control_new (void);
RemoteControl* remote_control_construct (GType object_type);
GType remote_control_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RemoteControl, g_object_unref)
guint remote_control_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
gint remote_control_do_ping (RemoteControl* self,
                             gint v);
void remote_control_do_show (RemoteControl* self);
static GType remote_control_get_type_once (void);
static void _dbus_remote_control_do_ping (RemoteControl* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_remote_control_do_show (RemoteControl* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void remote_control_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* remote_control_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static gboolean remote_control_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _remote_control_unregister_object (gpointer user_data);

static const GOptionEntry LAUNCHER_LAUNCHY_entries[4] = {{"silent", 's', 0, G_OPTION_ARG_NONE, &launcher_launchy_silent, "Launch Launchy as a background process without it appearing visually.", NULL}, {"key-activated", 's', 0, G_OPTION_ARG_NONE, &launcher_launchy_key_activated, "Launch Launchy as a background process without it appearing visually.", NULL}, {"command-mode", 'c', 0, G_OPTION_ARG_NONE, &launcher_launchy_command_mode, "This feature is not implemented yet. When it is, description will be c" \
"hanged.", NULL}, {NULL}};
static const GDBusArgInfo _remote_control_dbus_arg_info_do_ping_v = {-1, "v", "i", NULL};
static const GDBusArgInfo _remote_control_dbus_arg_info_do_ping_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _remote_control_dbus_arg_info_do_ping_in[] = {&_remote_control_dbus_arg_info_do_ping_v, NULL};
static const GDBusArgInfo * const _remote_control_dbus_arg_info_do_ping_out[] = {&_remote_control_dbus_arg_info_do_ping_result, NULL};
static const GDBusMethodInfo _remote_control_dbus_method_info_do_ping = {-1, "DoPing", (GDBusArgInfo **) (&_remote_control_dbus_arg_info_do_ping_in), (GDBusArgInfo **) (&_remote_control_dbus_arg_info_do_ping_out), NULL};
static const GDBusArgInfo * const _remote_control_dbus_arg_info_do_show_in[] = {NULL};
static const GDBusArgInfo * const _remote_control_dbus_arg_info_do_show_out[] = {NULL};
static const GDBusMethodInfo _remote_control_dbus_method_info_do_show = {-1, "DoShow", (GDBusArgInfo **) (&_remote_control_dbus_arg_info_do_show_in), (GDBusArgInfo **) (&_remote_control_dbus_arg_info_do_show_out), NULL};
static const GDBusMethodInfo * const _remote_control_dbus_method_info[] = {&_remote_control_dbus_method_info_do_ping, &_remote_control_dbus_method_info_do_show, NULL};
static const GDBusSignalInfo * const _remote_control_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _remote_control_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _remote_control_dbus_interface_info = {-1, "org.enso.launchy.remotecontrol", (GDBusMethodInfo **) (&_remote_control_dbus_method_info), (GDBusSignalInfo **) (&_remote_control_dbus_signal_info), (GDBusPropertyInfo **) (&_remote_control_dbus_property_info), NULL};
static const GDBusInterfaceVTable _remote_control_dbus_interface_vtable = {remote_control_dbus_interface_method_call, remote_control_dbus_interface_get_property, remote_control_dbus_interface_set_property};

static inline gpointer
launcher_launchy_get_instance_private (LauncherLaunchy* self)
{
	return G_STRUCT_MEMBER_P (self, LauncherLaunchy_private_offset);
}

LauncherLaunchy*
launcher_launchy_construct (GType object_type)
{
	LauncherLaunchy * self = NULL;
	LauncherSettings* _tmp0_;
	LauncherSettings* _tmp1_;
	LauncherSettings* _tmp2_;
	LauncherSettings* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 59 "../src/Launchy.vala"
	self = (LauncherLaunchy*) g_object_new (object_type, NULL);
#line 60 "../src/Launchy.vala"
	_tmp0_ = launcher_settings_new ();
#line 60 "../src/Launchy.vala"
	_tmp1_ = _tmp0_;
#line 60 "../src/Launchy.vala"
	launcher_launchy_set_settings (_tmp1_);
#line 60 "../src/Launchy.vala"
	_g_object_unref0 (_tmp1_);
#line 61 "../src/Launchy.vala"
	_tmp2_ = launcher_launchy_get_settings ();
#line 61 "../src/Launchy.vala"
	_tmp3_ = _tmp2_;
#line 61 "../src/Launchy.vala"
	_tmp4_ = launcher_settings_get_icon_size (_tmp3_);
#line 61 "../src/Launchy.vala"
	_tmp5_ = _tmp4_;
#line 61 "../src/Launchy.vala"
	launcher_pixels_ITEM_SIZE = _tmp5_ * 2;
#line 62 "../src/Launchy.vala"
	launcher_pixels_SIDEBAR_WIDTH = ((LAUNCHER_PIXELS_PADDING + launcher_pixels_ITEM_SIZE) - LAUNCHER_PIXELS_SIDEBAR_GRID_PADDING) - 1;
#line 59 "../src/Launchy.vala"
	return self;
#line 316 "Launchy.c"
}

LauncherLaunchy*
launcher_launchy_new (void)
{
#line 59 "../src/Launchy.vala"
	return launcher_launchy_construct (LAUNCHER_TYPE_LAUNCHY);
#line 324 "Launchy.c"
}

gboolean
launcher_launchy_realize_view (LauncherLaunchy* self,
                               cairo_t* cr)
{
	GtkAllocation alloc = {0};
	LauncherLaunchyView* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkAllocation _tmp3_;
	gboolean result = FALSE;
#line 65 "../src/Launchy.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "../src/Launchy.vala"
	_tmp0_ = self->view;
#line 67 "../src/Launchy.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
#line 67 "../src/Launchy.vala"
	alloc = _tmp1_;
#line 68 "../src/Launchy.vala"
	_tmp3_ = alloc;
#line 68 "../src/Launchy.vala"
	if (_tmp3_.width != self->priv->view_width) {
#line 68 "../src/Launchy.vala"
		_tmp2_ = TRUE;
#line 351 "Launchy.c"
	} else {
		GtkAllocation _tmp4_;
#line 68 "../src/Launchy.vala"
		_tmp4_ = alloc;
#line 68 "../src/Launchy.vala"
		_tmp2_ = _tmp4_.height != self->priv->view_height;
#line 358 "Launchy.c"
	}
#line 68 "../src/Launchy.vala"
	if (_tmp2_) {
#line 362 "Launchy.c"
		GtkAllocation _tmp5_;
		GtkAllocation _tmp6_;
		LauncherLaunchyView* _tmp7_;
#line 69 "../src/Launchy.vala"
		_tmp5_ = alloc;
#line 69 "../src/Launchy.vala"
		self->priv->view_width = _tmp5_.width;
#line 70 "../src/Launchy.vala"
		_tmp6_ = alloc;
#line 70 "../src/Launchy.vala"
		self->priv->view_height = _tmp6_.height;
#line 71 "../src/Launchy.vala"
		_tmp7_ = self->view;
#line 71 "../src/Launchy.vala"
		launcher_launchy_view_reposition (_tmp7_);
#line 378 "Launchy.c"
	}
#line 73 "../src/Launchy.vala"
	result = FALSE;
#line 73 "../src/Launchy.vala"
	return result;
#line 384 "Launchy.c"
}

static void
launcher_launchy_real_activate (GApplication* base)
{
	LauncherLaunchy * self;
	GList* _tmp0_;
#line 76 "../src/Launchy.vala"
	self = (LauncherLaunchy*) base;
#line 77 "../src/Launchy.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 77 "../src/Launchy.vala"
	if (_tmp0_ == NULL) {
#line 398 "Launchy.c"
		LauncherLaunchyView* _tmp1_;
		LauncherLaunchyView* _tmp2_;
		LauncherDBusService* _tmp3_;
#line 78 "../src/Launchy.vala"
		self->priv->view_width = -1;
#line 79 "../src/Launchy.vala"
		self->priv->view_height = -1;
#line 80 "../src/Launchy.vala"
		_tmp1_ = launcher_launchy_view_new ();
#line 80 "../src/Launchy.vala"
		g_object_ref_sink (_tmp1_);
#line 80 "../src/Launchy.vala"
		_g_object_unref0 (self->view);
#line 80 "../src/Launchy.vala"
		self->view = _tmp1_;
#line 81 "../src/Launchy.vala"
		_tmp2_ = self->view;
#line 81 "../src/Launchy.vala"
		gtk_window_set_application ((GtkWindow*) _tmp2_, (GtkApplication*) self);
#line 84 "../src/Launchy.vala"
		_tmp3_ = self->dbus_service;
#line 84 "../src/Launchy.vala"
		if (_tmp3_ == NULL) {
#line 422 "Launchy.c"
			LauncherLaunchyView* _tmp4_;
			LauncherDBusService* _tmp5_;
#line 85 "../src/Launchy.vala"
			_tmp4_ = self->view;
#line 85 "../src/Launchy.vala"
			_tmp5_ = launcher_dbus_service_new (_tmp4_);
#line 85 "../src/Launchy.vala"
			_g_object_unref0 (self->dbus_service);
#line 85 "../src/Launchy.vala"
			self->dbus_service = _tmp5_;
#line 433 "Launchy.c"
		}
#line 87 "../src/Launchy.vala"
		if (!launcher_launchy_silent) {
#line 437 "Launchy.c"
			LauncherLaunchyView* _tmp6_;
#line 88 "../src/Launchy.vala"
			_tmp6_ = self->view;
#line 88 "../src/Launchy.vala"
			launcher_launchy_view_show_launchy (_tmp6_);
#line 443 "Launchy.c"
		}
	} else {
		gboolean _tmp7_ = FALSE;
		LauncherLaunchyView* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
#line 91 "../src/Launchy.vala"
		_tmp8_ = self->view;
#line 91 "../src/Launchy.vala"
		_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
#line 91 "../src/Launchy.vala"
		_tmp10_ = _tmp9_;
#line 91 "../src/Launchy.vala"
		if (_tmp10_) {
#line 91 "../src/Launchy.vala"
			_tmp7_ = !launcher_launchy_silent;
#line 460 "Launchy.c"
		} else {
#line 91 "../src/Launchy.vala"
			_tmp7_ = FALSE;
#line 464 "Launchy.c"
		}
#line 91 "../src/Launchy.vala"
		if (_tmp7_) {
#line 468 "Launchy.c"
			LauncherLaunchyView* _tmp11_;
#line 92 "../src/Launchy.vala"
			_tmp11_ = self->view;
#line 92 "../src/Launchy.vala"
			gtk_widget_hide ((GtkWidget*) _tmp11_);
#line 474 "Launchy.c"
		} else {
			LauncherLaunchyView* _tmp12_;
#line 94 "../src/Launchy.vala"
			_tmp12_ = self->view;
#line 94 "../src/Launchy.vala"
			launcher_launchy_view_show_launchy (_tmp12_);
#line 481 "Launchy.c"
		}
	}
#line 97 "../src/Launchy.vala"
	launcher_launchy_silent = FALSE;
#line 486 "Launchy.c"
}

static void
_on_bus_aquired_gbus_acquired_callback (GDBusConnection* connection,
                                        const gchar* name,
                                        gpointer self)
{
#line 127 "../src/Launchy.vala"
	on_bus_aquired (connection);
#line 496 "Launchy.c"
}

static void
__lambda60_ (void)
{
}

static void
___lambda60__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
#line 127 "../src/Launchy.vala"
	__lambda60_ ();
#line 511 "Launchy.c"
}

static void
__lambda61_ (void)
{
}

static void
___lambda61__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
#line 127 "../src/Launchy.vala"
	__lambda61_ ();
#line 526 "Launchy.c"
}

gint
launcher_launchy_main (gchar** args,
                       gint args_length1)
{
	LauncherLaunchy* _tmp10_;
	LauncherLaunchy* _tmp11_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
#line 108 "../src/Launchy.vala"
	gtk_init ((gint*) (&args_length1), &args);
#line 113 "../src/Launchy.vala"
	if (args_length1 > 1) {
#line 541 "Launchy.c"
		GOptionContext* context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionGroup* _tmp3_;
#line 114 "../src/Launchy.vala"
		_tmp0_ = g_option_context_new ("");
#line 114 "../src/Launchy.vala"
		context = _tmp0_;
#line 115 "../src/Launchy.vala"
		_tmp1_ = context;
#line 115 "../src/Launchy.vala"
		g_option_context_add_main_entries (_tmp1_, LAUNCHER_LAUNCHY_entries, "launchy");
#line 116 "../src/Launchy.vala"
		_tmp2_ = context;
#line 116 "../src/Launchy.vala"
		_tmp3_ = gtk_get_option_group (TRUE);
#line 116 "../src/Launchy.vala"
		g_option_context_add_group (_tmp2_, _tmp3_);
#line 561 "Launchy.c"
		{
			GOptionContext* _tmp4_;
#line 119 "../src/Launchy.vala"
			_tmp4_ = context;
#line 119 "../src/Launchy.vala"
			g_option_context_parse (_tmp4_, (gint*) (&args_length1), &args, &_inner_error0_);
#line 119 "../src/Launchy.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 570 "Launchy.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
#line 118 "../src/Launchy.vala"
			e = _inner_error0_;
#line 118 "../src/Launchy.vala"
			_inner_error0_ = NULL;
#line 121 "../src/Launchy.vala"
			_tmp5_ = e;
#line 121 "../src/Launchy.vala"
			_tmp6_ = _tmp5_->message;
#line 121 "../src/Launchy.vala"
			_tmp7_ = g_strconcat (_tmp6_, "\n", NULL);
#line 121 "../src/Launchy.vala"
			_tmp8_ = _tmp7_;
#line 121 "../src/Launchy.vala"
			g_print ("%s", _tmp8_);
#line 121 "../src/Launchy.vala"
			_g_free0 (_tmp8_);
#line 118 "../src/Launchy.vala"
			_g_error_free0 (e);
#line 600 "Launchy.c"
		}
		__finally0:
#line 118 "../src/Launchy.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 605 "Launchy.c"
			gint _tmp9_ = -1;
#line 118 "../src/Launchy.vala"
			_g_option_context_free0 (context);
#line 118 "../src/Launchy.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 118 "../src/Launchy.vala"
			g_clear_error (&_inner_error0_);
#line 118 "../src/Launchy.vala"
			return _tmp9_;
#line 615 "Launchy.c"
		}
#line 113 "../src/Launchy.vala"
		_g_option_context_free0 (context);
#line 619 "Launchy.c"
	}
#line 125 "../src/Launchy.vala"
	_tmp10_ = launcher_launchy_new ();
#line 125 "../src/Launchy.vala"
	_g_object_unref0 (app);
#line 125 "../src/Launchy.vala"
	app = _tmp10_;
#line 127 "../src/Launchy.vala"
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.enso.launchy.remotecontrol", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_on_bus_aquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _on_bus_aquired_gbus_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda60__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda60__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda61__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda61__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
#line 129 "../src/Launchy.vala"
	_tmp11_ = app;
#line 129 "../src/Launchy.vala"
	result = g_application_run ((GApplication*) _tmp11_, (gint) args_length1, args);
#line 129 "../src/Launchy.vala"
	return result;
#line 635 "Launchy.c"
}

int
main (int argc,
      char ** argv)
{
#line 107 "../src/Launchy.vala"
	return launcher_launchy_main (argv, argc);
#line 644 "Launchy.c"
}

LauncherSettings*
launcher_launchy_get_settings (void)
{
	LauncherSettings* result;
	LauncherSettings* _tmp0_;
#line 36 "../src/Launchy.vala"
	_tmp0_ = launcher_launchy__settings;
#line 36 "../src/Launchy.vala"
	result = _tmp0_;
#line 36 "../src/Launchy.vala"
	return result;
#line 658 "Launchy.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 36 "../src/Launchy.vala"
	return self ? g_object_ref (self) : NULL;
#line 666 "Launchy.c"
}

static void
launcher_launchy_set_settings (LauncherSettings* value)
{
	LauncherSettings* _tmp0_;
#line 36 "../src/Launchy.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 36 "../src/Launchy.vala"
	_g_object_unref0 (launcher_launchy__settings);
#line 36 "../src/Launchy.vala"
	launcher_launchy__settings = _tmp0_;
#line 679 "Launchy.c"
}

GtkIconTheme*
launcher_launchy_get_icon_theme (void)
{
	GtkIconTheme* result;
	GtkIconTheme* _tmp0_;
#line 37 "../src/Launchy.vala"
	_tmp0_ = launcher_launchy__icon_theme;
#line 37 "../src/Launchy.vala"
	result = _tmp0_;
#line 37 "../src/Launchy.vala"
	return result;
#line 693 "Launchy.c"
}

void
launcher_launchy_set_icon_theme (GtkIconTheme* value)
{
	GtkIconTheme* _tmp0_;
#line 37 "../src/Launchy.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 37 "../src/Launchy.vala"
	_g_object_unref0 (launcher_launchy__icon_theme);
#line 37 "../src/Launchy.vala"
	launcher_launchy__icon_theme = _tmp0_;
#line 706 "Launchy.c"
}

void
launcher_launchy_set_set_view_width (LauncherLaunchy* self,
                                     gint value)
{
#line 48 "../src/Launchy.vala"
	g_return_if_fail (self != NULL);
#line 49 "../src/Launchy.vala"
	self->priv->view_width = value;
#line 48 "../src/Launchy.vala"
	g_object_notify_by_pspec ((GObject *) self, launcher_launchy_properties[LAUNCHER_LAUNCHY_SET_VIEW_WIDTH_PROPERTY]);
#line 719 "Launchy.c"
}

void
launcher_launchy_set_set_view_height (LauncherLaunchy* self,
                                      gint value)
{
#line 54 "../src/Launchy.vala"
	g_return_if_fail (self != NULL);
#line 55 "../src/Launchy.vala"
	self->priv->view_height = value;
#line 54 "../src/Launchy.vala"
	g_object_notify_by_pspec ((GObject *) self, launcher_launchy_properties[LAUNCHER_LAUNCHY_SET_VIEW_HEIGHT_PROPERTY]);
#line 732 "Launchy.c"
}

static GObject *
launcher_launchy_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LauncherLaunchy * self;
#line 43 "../src/Launchy.vala"
	parent_class = G_OBJECT_CLASS (launcher_launchy_parent_class);
#line 43 "../src/Launchy.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 43 "../src/Launchy.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_TYPE_LAUNCHY, LauncherLaunchy);
#line 44 "../src/Launchy.vala"
	g_application_set_application_id ((GApplication*) self, "org.enso.launchy");
#line 43 "../src/Launchy.vala"
	return obj;
#line 753 "Launchy.c"
}

static void
launcher_launchy_class_init (LauncherLaunchyClass * klass,
                             gpointer klass_data)
{
#line 26 "../src/Launchy.vala"
	launcher_launchy_parent_class = g_type_class_peek_parent (klass);
#line 26 "../src/Launchy.vala"
	g_type_class_adjust_private_offset (klass, &LauncherLaunchy_private_offset);
#line 26 "../src/Launchy.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) launcher_launchy_real_activate;
#line 26 "../src/Launchy.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_launcher_launchy_get_property;
#line 26 "../src/Launchy.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_launcher_launchy_set_property;
#line 26 "../src/Launchy.vala"
	G_OBJECT_CLASS (klass)->constructor = launcher_launchy_constructor;
#line 26 "../src/Launchy.vala"
	G_OBJECT_CLASS (klass)->finalize = launcher_launchy_finalize;
#line 26 "../src/Launchy.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_LAUNCHY_SET_VIEW_WIDTH_PROPERTY, launcher_launchy_properties[LAUNCHER_LAUNCHY_SET_VIEW_WIDTH_PROPERTY] = g_param_spec_int ("set-view-width", "set-view-width", "set-view-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
#line 26 "../src/Launchy.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAUNCHER_LAUNCHY_SET_VIEW_HEIGHT_PROPERTY, launcher_launchy_properties[LAUNCHER_LAUNCHY_SET_VIEW_HEIGHT_PROPERTY] = g_param_spec_int ("set-view-height", "set-view-height", "set-view-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
#line 778 "Launchy.c"
}

static void
launcher_launchy_instance_init (LauncherLaunchy * self,
                                gpointer klass)
{
#line 26 "../src/Launchy.vala"
	self->priv = launcher_launchy_get_instance_private (self);
#line 28 "../src/Launchy.vala"
	self->view = NULL;
#line 32 "../src/Launchy.vala"
	self->launched = FALSE;
#line 38 "../src/Launchy.vala"
	self->dbus_service = NULL;
#line 793 "Launchy.c"
}

static void
launcher_launchy_finalize (GObject * obj)
{
	LauncherLaunchy * self;
#line 26 "../src/Launchy.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_TYPE_LAUNCHY, LauncherLaunchy);
#line 28 "../src/Launchy.vala"
	_g_object_unref0 (self->view);
#line 33 "../src/Launchy.vala"
	_g_object_unref0 (self->app_button);
#line 34 "../src/Launchy.vala"
	_g_object_unref0 (self->client);
#line 38 "../src/Launchy.vala"
	_g_object_unref0 (self->dbus_service);
#line 26 "../src/Launchy.vala"
	G_OBJECT_CLASS (launcher_launchy_parent_class)->finalize (obj);
#line 812 "Launchy.c"
}

static GType
launcher_launchy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LauncherLaunchyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_launchy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherLaunchy), 0, (GInstanceInitFunc) launcher_launchy_instance_init, NULL };
	GType launcher_launchy_type_id;
	launcher_launchy_type_id = g_type_register_static (gtk_application_get_type (), "LauncherLaunchy", &g_define_type_info, 0);
	LauncherLaunchy_private_offset = g_type_add_instance_private (launcher_launchy_type_id, sizeof (LauncherLaunchyPrivate));
	return launcher_launchy_type_id;
}

GType
launcher_launchy_get_type (void)
{
	static volatile gsize launcher_launchy_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_launchy_type_id__volatile)) {
		GType launcher_launchy_type_id;
		launcher_launchy_type_id = launcher_launchy_get_type_once ();
		g_once_init_leave (&launcher_launchy_type_id__volatile, launcher_launchy_type_id);
	}
	return launcher_launchy_type_id__volatile;
}

static void
_vala_launcher_launchy_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	LauncherLaunchy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LAUNCHER_TYPE_LAUNCHY, LauncherLaunchy);
#line 26 "../src/Launchy.vala"
	switch (property_id) {
#line 847 "Launchy.c"
		default:
#line 26 "../src/Launchy.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/Launchy.vala"
		break;
#line 853 "Launchy.c"
	}
}

static void
_vala_launcher_launchy_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	LauncherLaunchy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LAUNCHER_TYPE_LAUNCHY, LauncherLaunchy);
#line 26 "../src/Launchy.vala"
	switch (property_id) {
#line 26 "../src/Launchy.vala"
		case LAUNCHER_LAUNCHY_SET_VIEW_WIDTH_PROPERTY:
#line 26 "../src/Launchy.vala"
		launcher_launchy_set_set_view_width (self, g_value_get_int (value));
#line 26 "../src/Launchy.vala"
		break;
#line 26 "../src/Launchy.vala"
		case LAUNCHER_LAUNCHY_SET_VIEW_HEIGHT_PROPERTY:
#line 26 "../src/Launchy.vala"
		launcher_launchy_set_set_view_height (self, g_value_get_int (value));
#line 26 "../src/Launchy.vala"
		break;
#line 879 "Launchy.c"
		default:
#line 26 "../src/Launchy.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/Launchy.vala"
		break;
#line 885 "Launchy.c"
	}
}

void
on_bus_aquired (GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
#line 133 "../src/Launchy.vala"
	g_return_if_fail (conn != NULL);
#line 895 "Launchy.c"
	{
		RemoteControl* _tmp0_;
		RemoteControl* _tmp1_;
#line 135 "../src/Launchy.vala"
		_tmp0_ = remote_control_new ();
#line 135 "../src/Launchy.vala"
		_tmp1_ = _tmp0_;
#line 135 "../src/Launchy.vala"
		remote_control_register_object (_tmp1_, conn, "/org/enso/launchy/remotecontrol", &_inner_error0_);
#line 135 "../src/Launchy.vala"
		_g_object_unref0 (_tmp1_);
#line 135 "../src/Launchy.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 135 "../src/Launchy.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 911 "Launchy.c"
				goto __catch0_g_io_error;
			}
#line 135 "../src/Launchy.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 135 "../src/Launchy.vala"
			g_clear_error (&_inner_error0_);
#line 135 "../src/Launchy.vala"
			return;
#line 920 "Launchy.c"
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		FILE* _tmp2_;
#line 134 "../src/Launchy.vala"
		g_clear_error (&_inner_error0_);
#line 137 "../src/Launchy.vala"
		_tmp2_ = stderr;
#line 137 "../src/Launchy.vala"
		fprintf (_tmp2_, "Could not register service\n");
#line 933 "Launchy.c"
	}
	__finally0:
#line 134 "../src/Launchy.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 134 "../src/Launchy.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 134 "../src/Launchy.vala"
		g_clear_error (&_inner_error0_);
#line 134 "../src/Launchy.vala"
		return;
#line 944 "Launchy.c"
	}
}

gint
remote_control_do_ping (RemoteControl* self,
                        gint v)
{
	gint result = 0;
#line 144 "../src/Launchy.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 145 "../src/Launchy.vala"
	result = v + 1;
#line 145 "../src/Launchy.vala"
	return result;
#line 959 "Launchy.c"
}

void
remote_control_do_show (RemoteControl* self)
{
	LauncherLaunchy* _tmp0_;
#line 148 "../src/Launchy.vala"
	g_return_if_fail (self != NULL);
#line 149 "../src/Launchy.vala"
	g_print ("Called from DBus\n");
#line 150 "../src/Launchy.vala"
	_tmp0_ = app;
#line 150 "../src/Launchy.vala"
	g_application_activate ((GApplication*) _tmp0_);
#line 974 "Launchy.c"
}

RemoteControl*
remote_control_construct (GType object_type)
{
	RemoteControl * self = NULL;
#line 142 "../src/Launchy.vala"
	self = (RemoteControl*) g_object_new (object_type, NULL);
#line 142 "../src/Launchy.vala"
	return self;
#line 985 "Launchy.c"
}

RemoteControl*
remote_control_new (void)
{
#line 142 "../src/Launchy.vala"
	return remote_control_construct (TYPE_REMOTE_CONTROL);
#line 993 "Launchy.c"
}

static void
remote_control_class_init (RemoteControlClass * klass,
                           gpointer klass_data)
{
#line 142 "../src/Launchy.vala"
	remote_control_parent_class = g_type_class_peek_parent (klass);
#line 1002 "Launchy.c"
}

static void
remote_control_instance_init (RemoteControl * self,
                              gpointer klass)
{
}

static GType
remote_control_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RemoteControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) remote_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RemoteControl), 0, (GInstanceInitFunc) remote_control_instance_init, NULL };
	GType remote_control_type_id;
	remote_control_type_id = g_type_register_static (G_TYPE_OBJECT, "RemoteControl", &g_define_type_info, 0);
	g_type_set_qdata (remote_control_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) remote_control_register_object);
	return remote_control_type_id;
}

GType
remote_control_get_type (void)
{
	static volatile gsize remote_control_type_id__volatile = 0;
	if (g_once_init_enter (&remote_control_type_id__volatile)) {
		GType remote_control_type_id;
		remote_control_type_id = remote_control_get_type_once ();
		g_once_init_leave (&remote_control_type_id__volatile, remote_control_type_id);
	}
	return remote_control_type_id__volatile;
}

static void
_dbus_remote_control_do_ping (RemoteControl* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint v = 0;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	v = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	result = remote_control_do_ping (self, v);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_remote_control_do_show (RemoteControl* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	remote_control_do_show (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
remote_control_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "DoPing") == 0) {
		_dbus_remote_control_do_ping (object, parameters, invocation);
	} else if (strcmp (method_name, "DoShow") == 0) {
		_dbus_remote_control_do_show (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
remote_control_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
remote_control_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
remote_control_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_remote_control_dbus_interface_info), &_remote_control_dbus_interface_vtable, data, _remote_control_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_remote_control_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

