/* SynapseSearch.c generated by valac 0.48.13, the Vala compiler
 * generated from SynapseSearch.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "synapse-plugins.h"
#include "synapse-core.h"
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libsoup/soup.h>

#define LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH (launcher_backend_synapse_search_get_type ())
#define LAUNCHER_BACKEND_SYNAPSE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH, LauncherBackendSynapseSearch))
#define LAUNCHER_BACKEND_SYNAPSE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH, LauncherBackendSynapseSearchClass))
#define LAUNCHER_BACKEND_IS_SYNAPSE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH))
#define LAUNCHER_BACKEND_IS_SYNAPSE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH))
#define LAUNCHER_BACKEND_SYNAPSE_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH, LauncherBackendSynapseSearchClass))

typedef struct _LauncherBackendSynapseSearch LauncherBackendSynapseSearch;
typedef struct _LauncherBackendSynapseSearchClass LauncherBackendSynapseSearchClass;
typedef struct _LauncherBackendSynapseSearchPrivate LauncherBackendSynapseSearchPrivate;
enum  {
	LAUNCHER_BACKEND_SYNAPSE_SEARCH_0_PROPERTY,
	LAUNCHER_BACKEND_SYNAPSE_SEARCH_NUM_PROPERTIES
};
static GParamSpec* launcher_backend_synapse_search_properties[LAUNCHER_BACKEND_SYNAPSE_SEARCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _LauncherBackendSynapseSearchSearchData LauncherBackendSynapseSearchSearchData;
typedef struct _LauncherBackendSynapseSearchSearchActionsData LauncherBackendSynapseSearchSearchActionsData;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _LauncherBackendSynapseSearchGetFaviconForMatchData LauncherBackendSynapseSearchGetFaviconForMatchData;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _LauncherBackendSynapseSearch {
	GObject parent_instance;
	LauncherBackendSynapseSearchPrivate * priv;
};

struct _LauncherBackendSynapseSearchClass {
	GObjectClass parent_class;
};

struct _LauncherBackendSynapseSearchPrivate {
	GCancellable* current_search;
};

struct _LauncherBackendSynapseSearchSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	LauncherBackendSynapseSearch* self;
	gchar* text;
	SynapseSearchProvider* provider;
	GeeList* result;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	SynapseDataSink* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp4_;
	GeeList* _tmp5_;
	GCancellable* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _LauncherBackendSynapseSearchSearchActionsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	LauncherBackendSynapseSearch* self;
	gchar* text;
	SynapseSearchProvider* provider;
	GeeList* result;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	SynapseDataSink* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp4_;
	GeeList* _tmp5_;
	GCancellable* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _LauncherBackendSynapseSearchGetFaviconForMatchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUriMatch* match;
	gint size;
	GCancellable* cancellable;
	GdkPixbuf* result;
	SoupURI* soup_uri;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupURI* _tmp2_;
	gboolean _tmp3_;
	SoupURI* _tmp4_;
	const gchar* _tmp5_;
	SoupURI* _tmp6_;
	const gchar* _tmp7_;
	GdkPixbuf* pixbuf;
	GeeHashMap* _tmp8_;
	SoupURI* _tmp9_;
	const gchar* _tmp10_;
	GeeHashMap* _tmp11_;
	SoupURI* _tmp12_;
	const gchar* _tmp13_;
	gpointer _tmp14_;
	gchar* url;
	SoupURI* _tmp15_;
	const gchar* _tmp16_;
	SoupURI* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	SoupMessage* msg;
	const gchar* _tmp20_;
	SoupMessage* _tmp21_;
	SoupSession* session;
	SoupSession* _tmp22_;
	SoupSession* _tmp23_;
	GInputStream* stream;
	SoupSession* _tmp24_;
	SoupMessage* _tmp25_;
	GInputStream* _tmp26_;
	GInputStream* _tmp27_;
	GdkPixbuf* _tmp28_;
	GInputStream* _tmp29_;
	GdkPixbuf* _tmp30_;
	GdkPixbuf* _tmp31_;
	GdkPixbuf* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GeeHashMap* _tmp35_;
	SoupURI* _tmp36_;
	const gchar* _tmp37_;
	GdkPixbuf* _tmp38_;
	GError* _inner_error0_;
};

static gint LauncherBackendSynapseSearch_private_offset;
static gpointer launcher_backend_synapse_search_parent_class = NULL;
static GType* launcher_backend_synapse_search_plugins;
static gint launcher_backend_synapse_search_plugins_length1;
static GType* launcher_backend_synapse_search_plugins = NULL;
static gint launcher_backend_synapse_search_plugins_length1 = 0;
static gint _launcher_backend_synapse_search_plugins_size_ = 0;
static SynapseDataSink* launcher_backend_synapse_search_sink;
static SynapseDataSink* launcher_backend_synapse_search_sink = NULL;
static GeeHashMap* launcher_backend_synapse_search_favicon_cache;
static GeeHashMap* launcher_backend_synapse_search_favicon_cache = NULL;

GType launcher_backend_synapse_search_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherBackendSynapseSearch, g_object_unref)
LauncherBackendSynapseSearch* launcher_backend_synapse_search_new (void);
LauncherBackendSynapseSearch* launcher_backend_synapse_search_construct (GType object_type);
static void launcher_backend_synapse_search_init_sink (LauncherBackendSynapseSearch* self);
void launcher_backend_synapse_search_get_system_actions (LauncherBackendSynapseSearch* self);
static void launcher_backend_synapse_search_search_data_free (gpointer _data);
void launcher_backend_synapse_search_search (LauncherBackendSynapseSearch* self,
                                             const gchar* text,
                                             SynapseSearchProvider* provider,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
GeeList* launcher_backend_synapse_search_search_finish (LauncherBackendSynapseSearch* self,
                                                        GAsyncResult* _res_);
static gboolean launcher_backend_synapse_search_search_co (LauncherBackendSynapseSearchSearchData* _data_);
static void launcher_backend_synapse_search_search_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void launcher_backend_synapse_search_search_actions_data_free (gpointer _data);
void launcher_backend_synapse_search_search_actions (LauncherBackendSynapseSearch* self,
                                                     const gchar* text,
                                                     SynapseSearchProvider* provider,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
GeeList* launcher_backend_synapse_search_search_actions_finish (LauncherBackendSynapseSearch* self,
                                                                GAsyncResult* _res_);
static gboolean launcher_backend_synapse_search_search_actions_co (LauncherBackendSynapseSearchSearchActionsData* _data_);
static void launcher_backend_synapse_search_search_actions_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
GeeList* launcher_backend_synapse_search_find_actions_for_match (SynapseMatch* match);
static void launcher_backend_synapse_search_get_favicon_for_match_data_free (gpointer _data);
void launcher_backend_synapse_search_get_favicon_for_match (SynapseUriMatch* match,
                                                            gint size,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
GdkPixbuf* launcher_backend_synapse_search_get_favicon_for_match_finish (GAsyncResult* _res_);
static gboolean launcher_backend_synapse_search_get_favicon_for_match_co (LauncherBackendSynapseSearchGetFaviconForMatchData* _data_);
static void _vala_SoupURI_free (SoupURI* self);
static void launcher_backend_synapse_search_get_favicon_for_match_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
gchar* launcher_backend_synapse_search_markup_string_with_search (const gchar* text,
                                                                  const gchar* pattern);
static void launcher_backend_synapse_search_finalize (GObject * obj);
static GType launcher_backend_synapse_search_get_type_once (void);

static inline gpointer
launcher_backend_synapse_search_get_instance_private (LauncherBackendSynapseSearch* self)
{
	return G_STRUCT_MEMBER_P (self, LauncherBackendSynapseSearch_private_offset);
}

LauncherBackendSynapseSearch*
launcher_backend_synapse_search_construct (GType object_type)
{
	LauncherBackendSynapseSearch * self = NULL;
#line 38 "../src/Backend/SynapseSearch.vala"
	self = (LauncherBackendSynapseSearch*) g_object_new (object_type, NULL);
#line 39 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_init_sink (self);
#line 38 "../src/Backend/SynapseSearch.vala"
	return self;
#line 253 "SynapseSearch.c"
}

LauncherBackendSynapseSearch*
launcher_backend_synapse_search_new (void)
{
#line 38 "../src/Backend/SynapseSearch.vala"
	return launcher_backend_synapse_search_construct (LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH);
#line 261 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_init_sink (LauncherBackendSynapseSearch* self)
{
	SynapseDataSink* _tmp0_;
#line 42 "../src/Backend/SynapseSearch.vala"
	g_return_if_fail (self != NULL);
#line 43 "../src/Backend/SynapseSearch.vala"
	g_message ("SynapseSearch.vala:43: init_sink");
#line 44 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = launcher_backend_synapse_search_sink;
#line 44 "../src/Backend/SynapseSearch.vala"
	if (_tmp0_ == NULL) {
#line 276 "SynapseSearch.c"
		SynapseDataSink* _tmp1_;
		GType* _tmp2_;
		gint _tmp2__length1;
		GeeHashMap* _tmp4_;
#line 45 "../src/Backend/SynapseSearch.vala"
		_tmp1_ = synapse_data_sink_new ();
#line 45 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (launcher_backend_synapse_search_sink);
#line 45 "../src/Backend/SynapseSearch.vala"
		launcher_backend_synapse_search_sink = _tmp1_;
#line 46 "../src/Backend/SynapseSearch.vala"
		_tmp2_ = launcher_backend_synapse_search_plugins;
#line 46 "../src/Backend/SynapseSearch.vala"
		_tmp2__length1 = launcher_backend_synapse_search_plugins_length1;
#line 291 "SynapseSearch.c"
		{
			GType* plugin_collection = NULL;
			gint plugin_collection_length1 = 0;
			gint _plugin_collection_size_ = 0;
			gint plugin_it = 0;
#line 46 "../src/Backend/SynapseSearch.vala"
			plugin_collection = _tmp2_;
#line 46 "../src/Backend/SynapseSearch.vala"
			plugin_collection_length1 = _tmp2__length1;
#line 46 "../src/Backend/SynapseSearch.vala"
			for (plugin_it = 0; plugin_it < plugin_collection_length1; plugin_it = plugin_it + 1) {
#line 303 "SynapseSearch.c"
				GType plugin = 0UL;
#line 46 "../src/Backend/SynapseSearch.vala"
				plugin = plugin_collection[plugin_it];
#line 307 "SynapseSearch.c"
				{
					SynapseDataSink* _tmp3_;
#line 47 "../src/Backend/SynapseSearch.vala"
					_tmp3_ = launcher_backend_synapse_search_sink;
#line 47 "../src/Backend/SynapseSearch.vala"
					synapse_data_sink_register_static_plugin (_tmp3_, plugin);
#line 314 "SynapseSearch.c"
				}
			}
		}
#line 50 "../src/Backend/SynapseSearch.vala"
		_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 50 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (launcher_backend_synapse_search_favicon_cache);
#line 50 "../src/Backend/SynapseSearch.vala"
		launcher_backend_synapse_search_favicon_cache = _tmp4_;
#line 324 "SynapseSearch.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 61 "../src/Backend/SynapseSearch.vala"
	return self ? g_object_ref (self) : NULL;
#line 333 "SynapseSearch.c"
}

void
launcher_backend_synapse_search_get_system_actions (LauncherBackendSynapseSearch* self)
{
	SynapseDataSink* _tmp0_;
	GObject* smp = NULL;
	SynapseDataSink* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
#line 54 "../src/Backend/SynapseSearch.vala"
	g_return_if_fail (self != NULL);
#line 55 "../src/Backend/SynapseSearch.vala"
	g_message ("SynapseSearch.vala:55: get_system_actions");
#line 56 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = launcher_backend_synapse_search_sink;
#line 56 "../src/Backend/SynapseSearch.vala"
	if (_tmp0_ == NULL) {
#line 57 "../src/Backend/SynapseSearch.vala"
		launcher_backend_synapse_search_init_sink (self);
#line 354 "SynapseSearch.c"
	}
#line 61 "../src/Backend/SynapseSearch.vala"
	_tmp1_ = launcher_backend_synapse_search_sink;
#line 61 "../src/Backend/SynapseSearch.vala"
	_tmp2_ = synapse_data_sink_get_plugin (_tmp1_, "Synapse.SystemManagementPlugin");
#line 61 "../src/Backend/SynapseSearch.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 61 "../src/Backend/SynapseSearch.vala"
	smp = _tmp3_;
#line 54 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (smp);
#line 366 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_search_data_free (gpointer _data)
{
	LauncherBackendSynapseSearchSearchData* _data_;
	_data_ = _data;
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_free0 (_data_->text);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->provider);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->result);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->self);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_slice_free (LauncherBackendSynapseSearchSearchData, _data_);
#line 384 "SynapseSearch.c"
}

void
launcher_backend_synapse_search_search (LauncherBackendSynapseSearch* self,
                                        const gchar* text,
                                        SynapseSearchProvider* provider,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	LauncherBackendSynapseSearchSearchData* _data_;
	LauncherBackendSynapseSearch* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchProvider* _tmp2_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_ = g_slice_new0 (LauncherBackendSynapseSearchSearchData);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_task_set_task_data (_data_->_async_result, _data_, launcher_backend_synapse_search_search_data_free);
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->self = _tmp0_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp1_ = g_strdup (text);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_free0 (_data_->text);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->text = _tmp1_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp2_ = _g_object_ref0 (provider);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->provider);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->provider = _tmp2_;
#line 23 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_search_co (_data_);
#line 422 "SynapseSearch.c"
}

GeeList*
launcher_backend_synapse_search_search_finish (LauncherBackendSynapseSearch* self,
                                               GAsyncResult* _res_)
{
	GeeList* result;
	LauncherBackendSynapseSearchSearchData* _data_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 23 "../src/Backend/SynapseSearch.vala"
	result = _data_->result;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->result = NULL;
#line 23 "../src/Backend/SynapseSearch.vala"
	return result;
#line 439 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_search_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	LauncherBackendSynapseSearchSearchData* _data_;
#line 84 "../src/Backend/SynapseSearch.vala"
	_data_ = _user_data_;
#line 84 "../src/Backend/SynapseSearch.vala"
	_data_->_source_object_ = source_object;
#line 84 "../src/Backend/SynapseSearch.vala"
	_data_->_res_ = _res_;
#line 84 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_search_co (_data_);
#line 456 "SynapseSearch.c"
}

static gboolean
launcher_backend_synapse_search_search_co (LauncherBackendSynapseSearchSearchData* _data_)
{
#line 73 "../src/Backend/SynapseSearch.vala"
	switch (_data_->_state_) {
#line 73 "../src/Backend/SynapseSearch.vala"
		case 0:
#line 466 "SynapseSearch.c"
		goto _state_0;
#line 73 "../src/Backend/SynapseSearch.vala"
		case 1:
#line 470 "SynapseSearch.c"
		goto _state_1;
		default:
#line 73 "../src/Backend/SynapseSearch.vala"
		g_assert_not_reached ();
#line 475 "SynapseSearch.c"
	}
	_state_0:
#line 75 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp0_ = _data_->self->priv->current_search;
#line 75 "../src/Backend/SynapseSearch.vala"
	if (_data_->_tmp0_ != NULL) {
#line 76 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp1_ = _data_->self->priv->current_search;
#line 76 "../src/Backend/SynapseSearch.vala"
		g_cancellable_cancel (_data_->_tmp1_);
#line 486 "SynapseSearch.c"
	}
#line 78 "../src/Backend/SynapseSearch.vala"
	if (_data_->provider == NULL) {
#line 490 "SynapseSearch.c"
		SynapseSearchProvider* _tmp3_;
#line 79 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp2_ = launcher_backend_synapse_search_sink;
#line 79 "../src/Backend/SynapseSearch.vala"
		_tmp3_ = _g_object_ref0 ((SynapseSearchProvider*) _data_->_tmp2_);
#line 79 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->provider);
#line 79 "../src/Backend/SynapseSearch.vala"
		_data_->provider = _tmp3_;
#line 500 "SynapseSearch.c"
	}
#line 81 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp4_ = synapse_result_set_new ();
#line 81 "../src/Backend/SynapseSearch.vala"
	_data_->results = _data_->_tmp4_;
#line 506 "SynapseSearch.c"
	{
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp6_ = _data_->self->priv->current_search;
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->_state_ = 1;
#line 84 "../src/Backend/SynapseSearch.vala"
		synapse_search_provider_search (_data_->provider, _data_->text, SYNAPSE_QUERY_FLAGS_ALL, _data_->results, _data_->_tmp6_, launcher_backend_synapse_search_search_ready, _data_);
#line 84 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 516 "SynapseSearch.c"
		_state_1:
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp7_ = synapse_search_provider_search_finish (_data_->provider, _data_->_res_, &_data_->_inner_error0_);
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp5_ = _data_->_tmp7_;
#line 84 "../src/Backend/SynapseSearch.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 524 "SynapseSearch.c"
			goto __catch0_g_error;
		}
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp8_ = _data_->_tmp5_;
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp5_ = NULL;
#line 84 "../src/Backend/SynapseSearch.vala"
		_data_->result = _data_->_tmp8_;
#line 84 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->_tmp5_);
#line 84 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->results);
#line 84 "../src/Backend/SynapseSearch.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 84 "../src/Backend/SynapseSearch.vala"
		if (_data_->_state_ != 0) {
#line 84 "../src/Backend/SynapseSearch.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 84 "../src/Backend/SynapseSearch.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 545 "SynapseSearch.c"
			}
		}
#line 84 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 84 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 552 "SynapseSearch.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 83 "../src/Backend/SynapseSearch.vala"
		_data_->e = _data_->_inner_error0_;
#line 83 "../src/Backend/SynapseSearch.vala"
		_data_->_inner_error0_ = NULL;
#line 85 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp9_ = _data_->e;
#line 85 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp10_ = _data_->_tmp9_->message;
#line 85 "../src/Backend/SynapseSearch.vala"
		g_warning ("SynapseSearch.vala:85: %s", _data_->_tmp10_);
#line 83 "../src/Backend/SynapseSearch.vala"
		_g_error_free0 (_data_->e);
#line 569 "SynapseSearch.c"
	}
	__finally0:
#line 83 "../src/Backend/SynapseSearch.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 83 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->results);
#line 83 "../src/Backend/SynapseSearch.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 83 "../src/Backend/SynapseSearch.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 83 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 83 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 584 "SynapseSearch.c"
	}
#line 87 "../src/Backend/SynapseSearch.vala"
	_data_->result = NULL;
#line 87 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->results);
#line 87 "../src/Backend/SynapseSearch.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 87 "../src/Backend/SynapseSearch.vala"
	if (_data_->_state_ != 0) {
#line 87 "../src/Backend/SynapseSearch.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 87 "../src/Backend/SynapseSearch.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 598 "SynapseSearch.c"
		}
	}
#line 87 "../src/Backend/SynapseSearch.vala"
	g_object_unref (_data_->_async_result);
#line 87 "../src/Backend/SynapseSearch.vala"
	return FALSE;
#line 605 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_search_actions_data_free (gpointer _data)
{
	LauncherBackendSynapseSearchSearchActionsData* _data_;
	_data_ = _data;
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_free0 (_data_->text);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->provider);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->result);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->self);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_slice_free (LauncherBackendSynapseSearchSearchActionsData, _data_);
#line 623 "SynapseSearch.c"
}

void
launcher_backend_synapse_search_search_actions (LauncherBackendSynapseSearch* self,
                                                const gchar* text,
                                                SynapseSearchProvider* provider,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	LauncherBackendSynapseSearchSearchActionsData* _data_;
	LauncherBackendSynapseSearch* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchProvider* _tmp2_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_ = g_slice_new0 (LauncherBackendSynapseSearchSearchActionsData);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_task_set_task_data (_data_->_async_result, _data_, launcher_backend_synapse_search_search_actions_data_free);
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->self = _tmp0_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp1_ = g_strdup (text);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_free0 (_data_->text);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->text = _tmp1_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp2_ = _g_object_ref0 (provider);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->provider);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->provider = _tmp2_;
#line 23 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_search_actions_co (_data_);
#line 661 "SynapseSearch.c"
}

GeeList*
launcher_backend_synapse_search_search_actions_finish (LauncherBackendSynapseSearch* self,
                                                       GAsyncResult* _res_)
{
	GeeList* result;
	LauncherBackendSynapseSearchSearchActionsData* _data_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 23 "../src/Backend/SynapseSearch.vala"
	result = _data_->result;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->result = NULL;
#line 23 "../src/Backend/SynapseSearch.vala"
	return result;
#line 678 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_search_actions_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	LauncherBackendSynapseSearchSearchActionsData* _data_;
#line 101 "../src/Backend/SynapseSearch.vala"
	_data_ = _user_data_;
#line 101 "../src/Backend/SynapseSearch.vala"
	_data_->_source_object_ = source_object;
#line 101 "../src/Backend/SynapseSearch.vala"
	_data_->_res_ = _res_;
#line 101 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_search_actions_co (_data_);
#line 695 "SynapseSearch.c"
}

static gboolean
launcher_backend_synapse_search_search_actions_co (LauncherBackendSynapseSearchSearchActionsData* _data_)
{
#line 90 "../src/Backend/SynapseSearch.vala"
	switch (_data_->_state_) {
#line 90 "../src/Backend/SynapseSearch.vala"
		case 0:
#line 705 "SynapseSearch.c"
		goto _state_0;
#line 90 "../src/Backend/SynapseSearch.vala"
		case 1:
#line 709 "SynapseSearch.c"
		goto _state_1;
		default:
#line 90 "../src/Backend/SynapseSearch.vala"
		g_assert_not_reached ();
#line 714 "SynapseSearch.c"
	}
	_state_0:
#line 92 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp0_ = _data_->self->priv->current_search;
#line 92 "../src/Backend/SynapseSearch.vala"
	if (_data_->_tmp0_ != NULL) {
#line 93 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp1_ = _data_->self->priv->current_search;
#line 93 "../src/Backend/SynapseSearch.vala"
		g_cancellable_cancel (_data_->_tmp1_);
#line 725 "SynapseSearch.c"
	}
#line 95 "../src/Backend/SynapseSearch.vala"
	if (_data_->provider == NULL) {
#line 729 "SynapseSearch.c"
		SynapseSearchProvider* _tmp3_;
#line 96 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp2_ = launcher_backend_synapse_search_sink;
#line 96 "../src/Backend/SynapseSearch.vala"
		_tmp3_ = _g_object_ref0 ((SynapseSearchProvider*) _data_->_tmp2_);
#line 96 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->provider);
#line 96 "../src/Backend/SynapseSearch.vala"
		_data_->provider = _tmp3_;
#line 739 "SynapseSearch.c"
	}
#line 98 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp4_ = synapse_result_set_new ();
#line 98 "../src/Backend/SynapseSearch.vala"
	_data_->results = _data_->_tmp4_;
#line 745 "SynapseSearch.c"
	{
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp6_ = _data_->self->priv->current_search;
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->_state_ = 1;
#line 101 "../src/Backend/SynapseSearch.vala"
		synapse_search_provider_search (_data_->provider, _data_->text, SYNAPSE_QUERY_FLAGS_ACTIONS, _data_->results, _data_->_tmp6_, launcher_backend_synapse_search_search_actions_ready, _data_);
#line 101 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 755 "SynapseSearch.c"
		_state_1:
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp7_ = synapse_search_provider_search_finish (_data_->provider, _data_->_res_, &_data_->_inner_error0_);
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp5_ = _data_->_tmp7_;
#line 101 "../src/Backend/SynapseSearch.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 763 "SynapseSearch.c"
			goto __catch0_g_error;
		}
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp8_ = _data_->_tmp5_;
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp5_ = NULL;
#line 101 "../src/Backend/SynapseSearch.vala"
		_data_->result = _data_->_tmp8_;
#line 101 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->_tmp5_);
#line 101 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->results);
#line 101 "../src/Backend/SynapseSearch.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 101 "../src/Backend/SynapseSearch.vala"
		if (_data_->_state_ != 0) {
#line 101 "../src/Backend/SynapseSearch.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 101 "../src/Backend/SynapseSearch.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 784 "SynapseSearch.c"
			}
		}
#line 101 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 101 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 791 "SynapseSearch.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 100 "../src/Backend/SynapseSearch.vala"
		_data_->e = _data_->_inner_error0_;
#line 100 "../src/Backend/SynapseSearch.vala"
		_data_->_inner_error0_ = NULL;
#line 102 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp9_ = _data_->e;
#line 102 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp10_ = _data_->_tmp9_->message;
#line 102 "../src/Backend/SynapseSearch.vala"
		g_warning ("SynapseSearch.vala:102: %s", _data_->_tmp10_);
#line 100 "../src/Backend/SynapseSearch.vala"
		_g_error_free0 (_data_->e);
#line 808 "SynapseSearch.c"
	}
	__finally0:
#line 100 "../src/Backend/SynapseSearch.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 100 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->results);
#line 100 "../src/Backend/SynapseSearch.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 100 "../src/Backend/SynapseSearch.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 100 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 100 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 823 "SynapseSearch.c"
	}
#line 104 "../src/Backend/SynapseSearch.vala"
	_data_->result = NULL;
#line 104 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->results);
#line 104 "../src/Backend/SynapseSearch.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 104 "../src/Backend/SynapseSearch.vala"
	if (_data_->_state_ != 0) {
#line 104 "../src/Backend/SynapseSearch.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 104 "../src/Backend/SynapseSearch.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 837 "SynapseSearch.c"
		}
	}
#line 104 "../src/Backend/SynapseSearch.vala"
	g_object_unref (_data_->_async_result);
#line 104 "../src/Backend/SynapseSearch.vala"
	return FALSE;
#line 844 "SynapseSearch.c"
}

GeeList*
launcher_backend_synapse_search_find_actions_for_match (SynapseMatch* match)
{
	SynapseDataSink* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result = NULL;
#line 107 "../src/Backend/SynapseSearch.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 108 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = launcher_backend_synapse_search_sink;
#line 108 "../src/Backend/SynapseSearch.vala"
	_tmp1_ = synapse_data_sink_find_actions_for_match (_tmp0_, match, NULL, SYNAPSE_QUERY_FLAGS_ALL);
#line 108 "../src/Backend/SynapseSearch.vala"
	result = _tmp1_;
#line 108 "../src/Backend/SynapseSearch.vala"
	return result;
#line 863 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_get_favicon_for_match_data_free (gpointer _data)
{
	LauncherBackendSynapseSearchGetFaviconForMatchData* _data_;
	_data_ = _data;
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->match);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->result);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_slice_free (LauncherBackendSynapseSearchGetFaviconForMatchData, _data_);
#line 879 "SynapseSearch.c"
}

void
launcher_backend_synapse_search_get_favicon_for_match (SynapseUriMatch* match,
                                                       gint size,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	LauncherBackendSynapseSearchGetFaviconForMatchData* _data_;
	SynapseUriMatch* _tmp0_;
	GCancellable* _tmp1_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_ = g_slice_new0 (LauncherBackendSynapseSearchGetFaviconForMatchData);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_task_set_task_data (_data_->_async_result, _data_, launcher_backend_synapse_search_get_favicon_for_match_data_free);
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = _g_object_ref0 (match);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->match);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->match = _tmp0_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->size = size;
#line 23 "../src/Backend/SynapseSearch.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 23 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->cancellable = _tmp1_;
#line 23 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_get_favicon_for_match_co (_data_);
#line 914 "SynapseSearch.c"
}

GdkPixbuf*
launcher_backend_synapse_search_get_favicon_for_match_finish (GAsyncResult* _res_)
{
	GdkPixbuf* result;
	LauncherBackendSynapseSearchGetFaviconForMatchData* _data_;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 23 "../src/Backend/SynapseSearch.vala"
	if (NULL == _data_) {
#line 23 "../src/Backend/SynapseSearch.vala"
		return NULL;
#line 928 "SynapseSearch.c"
	}
#line 23 "../src/Backend/SynapseSearch.vala"
	result = _data_->result;
#line 23 "../src/Backend/SynapseSearch.vala"
	_data_->result = NULL;
#line 23 "../src/Backend/SynapseSearch.vala"
	return result;
#line 936 "SynapseSearch.c"
}

/**
         * Attempts to load a favicon for an UriMatch and caches the icon
         *
         * @param match       The UriMatch
         * @param size        The icon size at which to load the icon. If the favicon is smaller than
         *                    that size, null will be returned
         * @param cancellable Cancellable for the loading operations
         * @return            The pixbuf or null if loading failed or the icon was too small
         */
static void
_vala_SoupURI_free (SoupURI* self)
{
#line 125 "../src/Backend/SynapseSearch.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 953 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_get_favicon_for_match_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	LauncherBackendSynapseSearchGetFaviconForMatchData* _data_;
#line 139 "../src/Backend/SynapseSearch.vala"
	_data_ = _user_data_;
#line 139 "../src/Backend/SynapseSearch.vala"
	_data_->_source_object_ = source_object;
#line 139 "../src/Backend/SynapseSearch.vala"
	_data_->_res_ = _res_;
#line 139 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_get_favicon_for_match_co (_data_);
#line 970 "SynapseSearch.c"
}

static gboolean
launcher_backend_synapse_search_get_favicon_for_match_co (LauncherBackendSynapseSearchGetFaviconForMatchData* _data_)
{
#line 120 "../src/Backend/SynapseSearch.vala"
	switch (_data_->_state_) {
#line 120 "../src/Backend/SynapseSearch.vala"
		case 0:
#line 980 "SynapseSearch.c"
		goto _state_0;
#line 120 "../src/Backend/SynapseSearch.vala"
		case 1:
#line 984 "SynapseSearch.c"
		goto _state_1;
#line 120 "../src/Backend/SynapseSearch.vala"
		case 2:
#line 988 "SynapseSearch.c"
		goto _state_2;
		default:
#line 120 "../src/Backend/SynapseSearch.vala"
		g_assert_not_reached ();
#line 993 "SynapseSearch.c"
	}
	_state_0:
#line 123 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp0_ = synapse_uri_match_get_uri (_data_->match);
#line 123 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 123 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp2_ = soup_uri_new (_data_->_tmp1_);
#line 123 "../src/Backend/SynapseSearch.vala"
	_data_->soup_uri = _data_->_tmp2_;
#line 124 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp4_ = _data_->soup_uri;
#line 124 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp5_ = _data_->_tmp4_->scheme;
#line 124 "../src/Backend/SynapseSearch.vala"
	if (g_str_has_prefix (_data_->_tmp5_, "http")) {
#line 124 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp3_ = TRUE;
#line 1012 "SynapseSearch.c"
	} else {
#line 124 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp6_ = _data_->soup_uri;
#line 124 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp7_ = _data_->_tmp6_->scheme;
#line 124 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp3_ = g_str_has_prefix (_data_->_tmp7_, "https");
#line 1020 "SynapseSearch.c"
	}
#line 124 "../src/Backend/SynapseSearch.vala"
	if (!_data_->_tmp3_) {
#line 125 "../src/Backend/SynapseSearch.vala"
		_data_->result = NULL;
#line 125 "../src/Backend/SynapseSearch.vala"
		__vala_SoupURI_free0 (_data_->soup_uri);
#line 125 "../src/Backend/SynapseSearch.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 125 "../src/Backend/SynapseSearch.vala"
		if (_data_->_state_ != 0) {
#line 125 "../src/Backend/SynapseSearch.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 125 "../src/Backend/SynapseSearch.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1036 "SynapseSearch.c"
			}
		}
#line 125 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 125 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 1043 "SynapseSearch.c"
	}
#line 127 "../src/Backend/SynapseSearch.vala"
	_data_->pixbuf = NULL;
#line 129 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp8_ = launcher_backend_synapse_search_favicon_cache;
#line 129 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp9_ = _data_->soup_uri;
#line 129 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp10_ = _data_->_tmp9_->host;
#line 129 "../src/Backend/SynapseSearch.vala"
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp8_, _data_->_tmp10_)) {
#line 130 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp11_ = launcher_backend_synapse_search_favicon_cache;
#line 130 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp12_ = _data_->soup_uri;
#line 130 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp13_ = _data_->_tmp12_->host;
#line 130 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp11_, _data_->_tmp13_);
#line 130 "../src/Backend/SynapseSearch.vala"
		_data_->result = (GdkPixbuf*) _data_->_tmp14_;
#line 130 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 130 "../src/Backend/SynapseSearch.vala"
		__vala_SoupURI_free0 (_data_->soup_uri);
#line 130 "../src/Backend/SynapseSearch.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 130 "../src/Backend/SynapseSearch.vala"
		if (_data_->_state_ != 0) {
#line 130 "../src/Backend/SynapseSearch.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 130 "../src/Backend/SynapseSearch.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1077 "SynapseSearch.c"
			}
		}
#line 130 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 130 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 1084 "SynapseSearch.c"
	}
#line 132 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp15_ = _data_->soup_uri;
#line 132 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp16_ = _data_->_tmp15_->scheme;
#line 132 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp17_ = _data_->soup_uri;
#line 132 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp18_ = _data_->_tmp17_->host;
#line 132 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp19_ = g_strdup_printf ("%s://%s/favicon.ico", _data_->_tmp16_, _data_->_tmp18_);
#line 132 "../src/Backend/SynapseSearch.vala"
	_data_->url = _data_->_tmp19_;
#line 134 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp20_ = _data_->url;
#line 134 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp21_ = soup_message_new ("GET", _data_->_tmp20_);
#line 134 "../src/Backend/SynapseSearch.vala"
	_data_->msg = _data_->_tmp21_;
#line 135 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp22_ = soup_session_new ();
#line 135 "../src/Backend/SynapseSearch.vala"
	_data_->session = _data_->_tmp22_;
#line 136 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp23_ = _data_->session;
#line 136 "../src/Backend/SynapseSearch.vala"
	g_object_set (_data_->_tmp23_, "use-thread-context", TRUE, NULL);
#line 1112 "SynapseSearch.c"
	{
#line 139 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp24_ = _data_->session;
#line 139 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp25_ = _data_->msg;
#line 139 "../src/Backend/SynapseSearch.vala"
		_data_->_state_ = 1;
#line 139 "../src/Backend/SynapseSearch.vala"
		soup_session_send_async (_data_->_tmp24_, _data_->_tmp25_, _data_->cancellable, launcher_backend_synapse_search_get_favicon_for_match_ready, _data_);
#line 139 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 1124 "SynapseSearch.c"
		_state_1:
#line 139 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp26_ = soup_session_send_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
#line 139 "../src/Backend/SynapseSearch.vala"
		_data_->stream = _data_->_tmp26_;
#line 139 "../src/Backend/SynapseSearch.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1132 "SynapseSearch.c"
			goto __catch0_g_error;
		}
#line 140 "../src/Backend/SynapseSearch.vala"
		_data_->_tmp27_ = _data_->stream;
#line 140 "../src/Backend/SynapseSearch.vala"
		if (_data_->_tmp27_ != NULL) {
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp29_ = _data_->stream;
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->_state_ = 2;
#line 141 "../src/Backend/SynapseSearch.vala"
			gdk_pixbuf_new_from_stream_async (_data_->_tmp29_, _data_->cancellable, launcher_backend_synapse_search_get_favicon_for_match_ready, _data_);
#line 141 "../src/Backend/SynapseSearch.vala"
			return FALSE;
#line 1147 "SynapseSearch.c"
			_state_2:
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp30_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp28_ = _data_->_tmp30_;
#line 141 "../src/Backend/SynapseSearch.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 141 "../src/Backend/SynapseSearch.vala"
				_g_object_unref0 (_data_->stream);
#line 1157 "SynapseSearch.c"
				goto __catch0_g_error;
			}
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp31_ = _data_->_tmp28_;
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp28_ = NULL;
#line 141 "../src/Backend/SynapseSearch.vala"
			_g_object_unref0 (_data_->pixbuf);
#line 141 "../src/Backend/SynapseSearch.vala"
			_data_->pixbuf = _data_->_tmp31_;
#line 144 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp32_ = _data_->pixbuf;
#line 144 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp33_ = gdk_pixbuf_get_width (_data_->_tmp32_);
#line 144 "../src/Backend/SynapseSearch.vala"
			_data_->_tmp34_ = _data_->_tmp33_;
#line 144 "../src/Backend/SynapseSearch.vala"
			if (_data_->_tmp34_ < _data_->size) {
#line 145 "../src/Backend/SynapseSearch.vala"
				_g_object_unref0 (_data_->pixbuf);
#line 145 "../src/Backend/SynapseSearch.vala"
				_data_->pixbuf = NULL;
#line 1180 "SynapseSearch.c"
			}
#line 140 "../src/Backend/SynapseSearch.vala"
			_g_object_unref0 (_data_->_tmp28_);
#line 1184 "SynapseSearch.c"
		}
#line 138 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->stream);
#line 1188 "SynapseSearch.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 138 "../src/Backend/SynapseSearch.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 1195 "SynapseSearch.c"
	}
	__finally0:
#line 138 "../src/Backend/SynapseSearch.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 138 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->session);
#line 138 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->msg);
#line 138 "../src/Backend/SynapseSearch.vala"
		_g_free0 (_data_->url);
#line 138 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 138 "../src/Backend/SynapseSearch.vala"
		__vala_SoupURI_free0 (_data_->soup_uri);
#line 138 "../src/Backend/SynapseSearch.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 138 "../src/Backend/SynapseSearch.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 138 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 138 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 1218 "SynapseSearch.c"
	}
#line 149 "../src/Backend/SynapseSearch.vala"
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 150 "../src/Backend/SynapseSearch.vala"
		_data_->result = NULL;
#line 150 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->session);
#line 150 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->msg);
#line 150 "../src/Backend/SynapseSearch.vala"
		_g_free0 (_data_->url);
#line 150 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 150 "../src/Backend/SynapseSearch.vala"
		__vala_SoupURI_free0 (_data_->soup_uri);
#line 150 "../src/Backend/SynapseSearch.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 150 "../src/Backend/SynapseSearch.vala"
		if (_data_->_state_ != 0) {
#line 150 "../src/Backend/SynapseSearch.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 150 "../src/Backend/SynapseSearch.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1242 "SynapseSearch.c"
			}
		}
#line 150 "../src/Backend/SynapseSearch.vala"
		g_object_unref (_data_->_async_result);
#line 150 "../src/Backend/SynapseSearch.vala"
		return FALSE;
#line 1249 "SynapseSearch.c"
	}
#line 154 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp35_ = launcher_backend_synapse_search_favicon_cache;
#line 154 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp36_ = _data_->soup_uri;
#line 154 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp37_ = _data_->_tmp36_->host;
#line 154 "../src/Backend/SynapseSearch.vala"
	_data_->_tmp38_ = _data_->pixbuf;
#line 154 "../src/Backend/SynapseSearch.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp35_, _data_->_tmp37_, _data_->_tmp38_);
#line 156 "../src/Backend/SynapseSearch.vala"
	_data_->result = _data_->pixbuf;
#line 156 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->session);
#line 156 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (_data_->msg);
#line 156 "../src/Backend/SynapseSearch.vala"
	_g_free0 (_data_->url);
#line 156 "../src/Backend/SynapseSearch.vala"
	__vala_SoupURI_free0 (_data_->soup_uri);
#line 156 "../src/Backend/SynapseSearch.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 156 "../src/Backend/SynapseSearch.vala"
	if (_data_->_state_ != 0) {
#line 156 "../src/Backend/SynapseSearch.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 156 "../src/Backend/SynapseSearch.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1279 "SynapseSearch.c"
		}
	}
#line 156 "../src/Backend/SynapseSearch.vala"
	g_object_unref (_data_->_async_result);
#line 156 "../src/Backend/SynapseSearch.vala"
	return FALSE;
#line 1286 "SynapseSearch.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 1309 "SynapseSearch.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 1318 "SynapseSearch.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1337 "SynapseSearch.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1341 "SynapseSearch.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1347 "SynapseSearch.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1357 "SynapseSearch.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1365 "SynapseSearch.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1369 "SynapseSearch.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 1375 "SynapseSearch.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1385 "SynapseSearch.c"
}

gchar*
launcher_backend_synapse_search_markup_string_with_search (const gchar* text,
                                                           const gchar* pattern)
{
	gchar* markup = NULL;
	gchar* _tmp0_;
	GeeList* matchers = NULL;
	GeeList* _tmp11_;
	gchar* highlighted = NULL;
	const gchar* _tmp53_;
	gchar* result = NULL;
#line 160 "../src/Backend/SynapseSearch.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 160 "../src/Backend/SynapseSearch.vala"
	g_return_val_if_fail (pattern != NULL, NULL);
#line 162 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = g_strdup ("%s");
#line 162 "../src/Backend/SynapseSearch.vala"
	markup = _tmp0_;
#line 164 "../src/Backend/SynapseSearch.vala"
	if (g_strcmp0 (pattern, "") == 0) {
#line 1409 "SynapseSearch.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 165 "../src/Backend/SynapseSearch.vala"
		_tmp1_ = markup;
#line 165 "../src/Backend/SynapseSearch.vala"
		_tmp2_ = g_markup_escape_text (text, (gssize) -1);
#line 165 "../src/Backend/SynapseSearch.vala"
		_tmp3_ = _tmp2_;
#line 165 "../src/Backend/SynapseSearch.vala"
		_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
#line 165 "../src/Backend/SynapseSearch.vala"
		_tmp5_ = _tmp4_;
#line 165 "../src/Backend/SynapseSearch.vala"
		_g_free0 (_tmp3_);
#line 165 "../src/Backend/SynapseSearch.vala"
		result = _tmp5_;
#line 165 "../src/Backend/SynapseSearch.vala"
		_g_free0 (markup);
#line 165 "../src/Backend/SynapseSearch.vala"
		return result;
#line 1433 "SynapseSearch.c"
	}
#line 169 "../src/Backend/SynapseSearch.vala"
	if (g_strcmp0 (text, "") == 0) {
#line 1437 "SynapseSearch.c"
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 170 "../src/Backend/SynapseSearch.vala"
		_tmp6_ = markup;
#line 170 "../src/Backend/SynapseSearch.vala"
		_tmp7_ = g_markup_escape_text (pattern, (gssize) -1);
#line 170 "../src/Backend/SynapseSearch.vala"
		_tmp8_ = _tmp7_;
#line 170 "../src/Backend/SynapseSearch.vala"
		_tmp9_ = g_strdup_printf (_tmp6_, _tmp8_);
#line 170 "../src/Backend/SynapseSearch.vala"
		_tmp10_ = _tmp9_;
#line 170 "../src/Backend/SynapseSearch.vala"
		_g_free0 (_tmp8_);
#line 170 "../src/Backend/SynapseSearch.vala"
		result = _tmp10_;
#line 170 "../src/Backend/SynapseSearch.vala"
		_g_free0 (markup);
#line 170 "../src/Backend/SynapseSearch.vala"
		return result;
#line 1461 "SynapseSearch.c"
	}
#line 173 "../src/Backend/SynapseSearch.vala"
	_tmp11_ = synapse_query_get_matchers_for_query (pattern, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 173 "../src/Backend/SynapseSearch.vala"
	matchers = _tmp11_;
#line 176 "../src/Backend/SynapseSearch.vala"
	highlighted = NULL;
#line 1469 "SynapseSearch.c"
	{
		GeeList* _matcher_list = NULL;
		GeeList* _tmp12_;
		GeeList* _tmp13_;
		gint _matcher_size = 0;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _matcher_index = 0;
#line 177 "../src/Backend/SynapseSearch.vala"
		_tmp12_ = matchers;
#line 177 "../src/Backend/SynapseSearch.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 177 "../src/Backend/SynapseSearch.vala"
		_matcher_list = _tmp13_;
#line 177 "../src/Backend/SynapseSearch.vala"
		_tmp14_ = _matcher_list;
#line 177 "../src/Backend/SynapseSearch.vala"
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
#line 177 "../src/Backend/SynapseSearch.vala"
		_tmp16_ = _tmp15_;
#line 177 "../src/Backend/SynapseSearch.vala"
		_matcher_size = _tmp16_;
#line 177 "../src/Backend/SynapseSearch.vala"
		_matcher_index = -1;
#line 177 "../src/Backend/SynapseSearch.vala"
		while (TRUE) {
#line 1497 "SynapseSearch.c"
			gint _tmp17_;
			gint _tmp18_;
			GeeMapEntry* matcher = NULL;
			GeeList* _tmp19_;
			gpointer _tmp20_;
			GMatchInfo* mi = NULL;
			GeeMapEntry* _tmp21_;
			gconstpointer _tmp22_;
			gconstpointer _tmp23_;
			GMatchInfo* _tmp24_ = NULL;
			gboolean _tmp25_;
#line 177 "../src/Backend/SynapseSearch.vala"
			_matcher_index = _matcher_index + 1;
#line 177 "../src/Backend/SynapseSearch.vala"
			_tmp17_ = _matcher_index;
#line 177 "../src/Backend/SynapseSearch.vala"
			_tmp18_ = _matcher_size;
#line 177 "../src/Backend/SynapseSearch.vala"
			if (!(_tmp17_ < _tmp18_)) {
#line 177 "../src/Backend/SynapseSearch.vala"
				break;
#line 1519 "SynapseSearch.c"
			}
#line 177 "../src/Backend/SynapseSearch.vala"
			_tmp19_ = _matcher_list;
#line 177 "../src/Backend/SynapseSearch.vala"
			_tmp20_ = gee_list_get (_tmp19_, _matcher_index);
#line 177 "../src/Backend/SynapseSearch.vala"
			matcher = (GeeMapEntry*) _tmp20_;
#line 179 "../src/Backend/SynapseSearch.vala"
			_tmp21_ = matcher;
#line 179 "../src/Backend/SynapseSearch.vala"
			_tmp22_ = gee_map_entry_get_key (_tmp21_);
#line 179 "../src/Backend/SynapseSearch.vala"
			_tmp23_ = _tmp22_;
#line 179 "../src/Backend/SynapseSearch.vala"
			_tmp25_ = g_regex_match ((GRegex*) _tmp23_, text, 0, &_tmp24_);
#line 179 "../src/Backend/SynapseSearch.vala"
			_g_match_info_unref0 (mi);
#line 179 "../src/Backend/SynapseSearch.vala"
			mi = _tmp24_;
#line 179 "../src/Backend/SynapseSearch.vala"
			if (_tmp25_) {
#line 1541 "SynapseSearch.c"
				gint start_pos = 0;
				gint end_pos = 0;
				gint last_pos = 0;
				gint cnt = 0;
				GMatchInfo* _tmp26_;
				GString* res = NULL;
				GString* _tmp27_;
				GString* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
#line 182 "../src/Backend/SynapseSearch.vala"
				last_pos = 0;
#line 183 "../src/Backend/SynapseSearch.vala"
				_tmp26_ = mi;
#line 183 "../src/Backend/SynapseSearch.vala"
				cnt = g_match_info_get_match_count (_tmp26_);
#line 184 "../src/Backend/SynapseSearch.vala"
				_tmp27_ = g_string_new ("");
#line 184 "../src/Backend/SynapseSearch.vala"
				res = _tmp27_;
#line 1562 "SynapseSearch.c"
				{
					gint i = 0;
#line 185 "../src/Backend/SynapseSearch.vala"
					i = 1;
#line 1567 "SynapseSearch.c"
					{
						gboolean _tmp28_ = FALSE;
#line 185 "../src/Backend/SynapseSearch.vala"
						_tmp28_ = TRUE;
#line 185 "../src/Backend/SynapseSearch.vala"
						while (TRUE) {
#line 1574 "SynapseSearch.c"
							GMatchInfo* _tmp30_;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gboolean _tmp33_ = FALSE;
							GString* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							GString* _tmp39_;
							GMatchInfo* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
#line 185 "../src/Backend/SynapseSearch.vala"
							if (!_tmp28_) {
#line 1592 "SynapseSearch.c"
								gint _tmp29_;
#line 185 "../src/Backend/SynapseSearch.vala"
								_tmp29_ = i;
#line 185 "../src/Backend/SynapseSearch.vala"
								i = _tmp29_ + 1;
#line 1598 "SynapseSearch.c"
							}
#line 185 "../src/Backend/SynapseSearch.vala"
							_tmp28_ = FALSE;
#line 185 "../src/Backend/SynapseSearch.vala"
							if (!(i < cnt)) {
#line 185 "../src/Backend/SynapseSearch.vala"
								break;
#line 1606 "SynapseSearch.c"
							}
#line 186 "../src/Backend/SynapseSearch.vala"
							_tmp30_ = mi;
#line 186 "../src/Backend/SynapseSearch.vala"
							g_match_info_fetch_pos (_tmp30_, i, &_tmp31_, &_tmp32_);
#line 186 "../src/Backend/SynapseSearch.vala"
							start_pos = _tmp31_;
#line 186 "../src/Backend/SynapseSearch.vala"
							end_pos = _tmp32_;
#line 187 "../src/Backend/SynapseSearch.vala"
							if (start_pos >= 0) {
#line 187 "../src/Backend/SynapseSearch.vala"
								_tmp33_ = end_pos >= 0;
#line 1620 "SynapseSearch.c"
							} else {
#line 187 "../src/Backend/SynapseSearch.vala"
								_tmp33_ = FALSE;
#line 1624 "SynapseSearch.c"
							}
#line 187 "../src/Backend/SynapseSearch.vala"
							g_warn_if_fail (_tmp33_);
#line 188 "../src/Backend/SynapseSearch.vala"
							_tmp34_ = res;
#line 188 "../src/Backend/SynapseSearch.vala"
							_tmp35_ = string_substring (text, (glong) last_pos, (glong) (start_pos - last_pos));
#line 188 "../src/Backend/SynapseSearch.vala"
							_tmp36_ = _tmp35_;
#line 188 "../src/Backend/SynapseSearch.vala"
							_tmp37_ = g_markup_escape_text (_tmp36_, (gssize) -1);
#line 188 "../src/Backend/SynapseSearch.vala"
							_tmp38_ = _tmp37_;
#line 188 "../src/Backend/SynapseSearch.vala"
							g_string_append (_tmp34_, _tmp38_);
#line 188 "../src/Backend/SynapseSearch.vala"
							_g_free0 (_tmp38_);
#line 188 "../src/Backend/SynapseSearch.vala"
							_g_free0 (_tmp36_);
#line 189 "../src/Backend/SynapseSearch.vala"
							last_pos = end_pos;
#line 190 "../src/Backend/SynapseSearch.vala"
							_tmp39_ = res;
#line 190 "../src/Backend/SynapseSearch.vala"
							_tmp40_ = mi;
#line 190 "../src/Backend/SynapseSearch.vala"
							_tmp41_ = g_match_info_fetch (_tmp40_, i);
#line 190 "../src/Backend/SynapseSearch.vala"
							_tmp42_ = _tmp41_;
#line 190 "../src/Backend/SynapseSearch.vala"
							_tmp43_ = g_markup_printf_escaped ("<b>%s</b>", _tmp42_);
#line 190 "../src/Backend/SynapseSearch.vala"
							_tmp44_ = _tmp43_;
#line 190 "../src/Backend/SynapseSearch.vala"
							g_string_append (_tmp39_, _tmp44_);
#line 190 "../src/Backend/SynapseSearch.vala"
							_g_free0 (_tmp44_);
#line 190 "../src/Backend/SynapseSearch.vala"
							_g_free0 (_tmp42_);
#line 191 "../src/Backend/SynapseSearch.vala"
							if (i == (cnt - 1)) {
#line 1666 "SynapseSearch.c"
								GString* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
#line 192 "../src/Backend/SynapseSearch.vala"
								_tmp45_ = res;
#line 192 "../src/Backend/SynapseSearch.vala"
								_tmp46_ = string_substring (text, (glong) last_pos, (glong) -1);
#line 192 "../src/Backend/SynapseSearch.vala"
								_tmp47_ = _tmp46_;
#line 192 "../src/Backend/SynapseSearch.vala"
								_tmp48_ = g_markup_escape_text (_tmp47_, (gssize) -1);
#line 192 "../src/Backend/SynapseSearch.vala"
								_tmp49_ = _tmp48_;
#line 192 "../src/Backend/SynapseSearch.vala"
								g_string_append (_tmp45_, _tmp49_);
#line 192 "../src/Backend/SynapseSearch.vala"
								_g_free0 (_tmp49_);
#line 192 "../src/Backend/SynapseSearch.vala"
								_g_free0 (_tmp47_);
#line 1688 "SynapseSearch.c"
							}
						}
					}
				}
#line 195 "../src/Backend/SynapseSearch.vala"
				_tmp50_ = res;
#line 195 "../src/Backend/SynapseSearch.vala"
				_tmp51_ = _tmp50_->str;
#line 195 "../src/Backend/SynapseSearch.vala"
				_tmp52_ = g_strdup (_tmp51_);
#line 195 "../src/Backend/SynapseSearch.vala"
				_g_free0 (highlighted);
#line 195 "../src/Backend/SynapseSearch.vala"
				highlighted = _tmp52_;
#line 196 "../src/Backend/SynapseSearch.vala"
				_g_string_free0 (res);
#line 196 "../src/Backend/SynapseSearch.vala"
				_g_match_info_unref0 (mi);
#line 196 "../src/Backend/SynapseSearch.vala"
				_g_object_unref0 (matcher);
#line 196 "../src/Backend/SynapseSearch.vala"
				break;
#line 1711 "SynapseSearch.c"
			}
#line 177 "../src/Backend/SynapseSearch.vala"
			_g_match_info_unref0 (mi);
#line 177 "../src/Backend/SynapseSearch.vala"
			_g_object_unref0 (matcher);
#line 1717 "SynapseSearch.c"
		}
#line 177 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (_matcher_list);
#line 1721 "SynapseSearch.c"
	}
#line 200 "../src/Backend/SynapseSearch.vala"
	_tmp53_ = highlighted;
#line 200 "../src/Backend/SynapseSearch.vala"
	if (_tmp53_ != NULL) {
#line 1727 "SynapseSearch.c"
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
#line 201 "../src/Backend/SynapseSearch.vala"
		_tmp54_ = markup;
#line 201 "../src/Backend/SynapseSearch.vala"
		_tmp55_ = highlighted;
#line 201 "../src/Backend/SynapseSearch.vala"
		_tmp56_ = g_strdup_printf (_tmp54_, _tmp55_);
#line 201 "../src/Backend/SynapseSearch.vala"
		result = _tmp56_;
#line 201 "../src/Backend/SynapseSearch.vala"
		_g_free0 (highlighted);
#line 201 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (matchers);
#line 201 "../src/Backend/SynapseSearch.vala"
		_g_free0 (markup);
#line 201 "../src/Backend/SynapseSearch.vala"
		return result;
#line 1747 "SynapseSearch.c"
	} else {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
#line 203 "../src/Backend/SynapseSearch.vala"
		_tmp57_ = markup;
#line 203 "../src/Backend/SynapseSearch.vala"
		_tmp58_ = g_markup_escape_text (text, (gssize) -1);
#line 203 "../src/Backend/SynapseSearch.vala"
		_tmp59_ = _tmp58_;
#line 203 "../src/Backend/SynapseSearch.vala"
		_tmp60_ = g_strdup_printf (_tmp57_, _tmp59_);
#line 203 "../src/Backend/SynapseSearch.vala"
		_tmp61_ = _tmp60_;
#line 203 "../src/Backend/SynapseSearch.vala"
		_g_free0 (_tmp59_);
#line 203 "../src/Backend/SynapseSearch.vala"
		result = _tmp61_;
#line 203 "../src/Backend/SynapseSearch.vala"
		_g_free0 (highlighted);
#line 203 "../src/Backend/SynapseSearch.vala"
		_g_object_unref0 (matchers);
#line 203 "../src/Backend/SynapseSearch.vala"
		_g_free0 (markup);
#line 203 "../src/Backend/SynapseSearch.vala"
		return result;
#line 1776 "SynapseSearch.c"
	}
#line 160 "../src/Backend/SynapseSearch.vala"
	_g_free0 (highlighted);
#line 160 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (matchers);
#line 160 "../src/Backend/SynapseSearch.vala"
	_g_free0 (markup);
#line 1784 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_class_init (LauncherBackendSynapseSearchClass * klass,
                                            gpointer klass_data)
{
	GType* _tmp0_;
#line 23 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_parent_class = g_type_class_peek_parent (klass);
#line 23 "../src/Backend/SynapseSearch.vala"
	g_type_class_adjust_private_offset (klass, &LauncherBackendSynapseSearch_private_offset);
#line 23 "../src/Backend/SynapseSearch.vala"
	G_OBJECT_CLASS (klass)->finalize = launcher_backend_synapse_search_finalize;
#line 25 "../src/Backend/SynapseSearch.vala"
	_tmp0_ = g_new0 (GType, 5);
#line 25 "../src/Backend/SynapseSearch.vala"
	_tmp0_[0] = SYNAPSE_TYPE_CALCULATOR_PLUGIN;
#line 25 "../src/Backend/SynapseSearch.vala"
	_tmp0_[1] = SYNAPSE_TYPE_COMMAND_PLUGIN;
#line 25 "../src/Backend/SynapseSearch.vala"
	_tmp0_[2] = SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN;
#line 25 "../src/Backend/SynapseSearch.vala"
	_tmp0_[3] = SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN;
#line 25 "../src/Backend/SynapseSearch.vala"
	_tmp0_[4] = SYNAPSE_TYPE_WEB_SEARCH_PLUGIN;
#line 25 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_plugins = _tmp0_;
#line 25 "../src/Backend/SynapseSearch.vala"
	launcher_backend_synapse_search_plugins_length1 = 5;
#line 1814 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_instance_init (LauncherBackendSynapseSearch * self,
                                               gpointer klass)
{
#line 23 "../src/Backend/SynapseSearch.vala"
	self->priv = launcher_backend_synapse_search_get_instance_private (self);
#line 36 "../src/Backend/SynapseSearch.vala"
	self->priv->current_search = NULL;
#line 1825 "SynapseSearch.c"
}

static void
launcher_backend_synapse_search_finalize (GObject * obj)
{
	LauncherBackendSynapseSearch * self;
#line 23 "../src/Backend/SynapseSearch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_BACKEND_TYPE_SYNAPSE_SEARCH, LauncherBackendSynapseSearch);
#line 36 "../src/Backend/SynapseSearch.vala"
	_g_object_unref0 (self->priv->current_search);
#line 23 "../src/Backend/SynapseSearch.vala"
	G_OBJECT_CLASS (launcher_backend_synapse_search_parent_class)->finalize (obj);
#line 1838 "SynapseSearch.c"
}

static GType
launcher_backend_synapse_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LauncherBackendSynapseSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_backend_synapse_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherBackendSynapseSearch), 0, (GInstanceInitFunc) launcher_backend_synapse_search_instance_init, NULL };
	GType launcher_backend_synapse_search_type_id;
	launcher_backend_synapse_search_type_id = g_type_register_static (G_TYPE_OBJECT, "LauncherBackendSynapseSearch", &g_define_type_info, 0);
	LauncherBackendSynapseSearch_private_offset = g_type_add_instance_private (launcher_backend_synapse_search_type_id, sizeof (LauncherBackendSynapseSearchPrivate));
	return launcher_backend_synapse_search_type_id;
}

GType
launcher_backend_synapse_search_get_type (void)
{
	static volatile gsize launcher_backend_synapse_search_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_backend_synapse_search_type_id__volatile)) {
		GType launcher_backend_synapse_search_type_id;
		launcher_backend_synapse_search_type_id = launcher_backend_synapse_search_get_type_once ();
		g_once_init_leave (&launcher_backend_synapse_search_type_id__volatile, launcher_backend_synapse_search_type_id);
	}
	return launcher_backend_synapse_search_type_id__volatile;
}

