/* AppSystem.c generated by valac 0.48.13, the Vala compiler
 * generated from AppSystem.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Panther Developers*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gee.h>
#include <gmenu-tree.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define LAUNCHER_BACKEND_TYPE_APP_SYSTEM (launcher_backend_app_system_get_type ())
#define LAUNCHER_BACKEND_APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_BACKEND_TYPE_APP_SYSTEM, LauncherBackendAppSystem))
#define LAUNCHER_BACKEND_APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_BACKEND_TYPE_APP_SYSTEM, LauncherBackendAppSystemClass))
#define LAUNCHER_BACKEND_IS_APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_BACKEND_TYPE_APP_SYSTEM))
#define LAUNCHER_BACKEND_IS_APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_BACKEND_TYPE_APP_SYSTEM))
#define LAUNCHER_BACKEND_APP_SYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_BACKEND_TYPE_APP_SYSTEM, LauncherBackendAppSystemClass))

typedef struct _LauncherBackendAppSystem LauncherBackendAppSystem;
typedef struct _LauncherBackendAppSystemClass LauncherBackendAppSystemClass;
typedef struct _LauncherBackendAppSystemPrivate LauncherBackendAppSystemPrivate;

#define LAUNCHER_BACKEND_TYPE_APP (launcher_backend_app_get_type ())
#define LAUNCHER_BACKEND_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendApp))
#define LAUNCHER_BACKEND_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendAppClass))
#define LAUNCHER_BACKEND_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAUNCHER_BACKEND_TYPE_APP))
#define LAUNCHER_BACKEND_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAUNCHER_BACKEND_TYPE_APP))
#define LAUNCHER_BACKEND_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAUNCHER_BACKEND_TYPE_APP, LauncherBackendAppClass))

typedef struct _LauncherBackendApp LauncherBackendApp;
typedef struct _LauncherBackendAppClass LauncherBackendAppClass;
enum  {
	LAUNCHER_BACKEND_APP_SYSTEM_0_PROPERTY,
	LAUNCHER_BACKEND_APP_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* launcher_backend_app_system_properties[LAUNCHER_BACKEND_APP_SYSTEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GMenuTreeDirectory_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeDirectory_free (var), NULL)))
#define __vala_GMenuTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeIter_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GMenuTreeEntry_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeEntry_free (var), NULL)))
enum  {
	LAUNCHER_BACKEND_APP_SYSTEM_CHANGED_SIGNAL,
	LAUNCHER_BACKEND_APP_SYSTEM_NUM_SIGNALS
};
static guint launcher_backend_app_system_signals[LAUNCHER_BACKEND_APP_SYSTEM_NUM_SIGNALS] = {0};

struct _LauncherBackendAppSystem {
	GObject parent_instance;
	LauncherBackendAppSystemPrivate * priv;
};

struct _LauncherBackendAppSystemClass {
	GObjectClass parent_class;
};

struct _LauncherBackendAppSystemPrivate {
	GeeArrayList* categories;
	GeeHashMap* apps;
	GMenuTree* apps_menu;
};

static gint LauncherBackendAppSystem_private_offset;
static gpointer launcher_backend_app_system_parent_class = NULL;

GType launcher_backend_app_system_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherBackendAppSystem, g_object_unref)
GType launcher_backend_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherBackendApp, g_object_unref)
#define LAUNCHER_BACKEND_APP_SYSTEM_GCC_PANEL_CATEGORY "X-GNOME-Settings-Panel"
void launcher_backend_app_system_update_app_system (LauncherBackendAppSystem* self);
static void launcher_backend_app_system_update_categories_index (LauncherBackendAppSystem* self);
static void launcher_backend_app_system_update_apps (LauncherBackendAppSystem* self);
static void _vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self);
static void _vala_GMenuTreeIter_free (GMenuTreeIter* self);
GeeArrayList* launcher_backend_app_system_get_apps_by_category (LauncherBackendAppSystem* self,
                                                                GMenuTreeDirectory* category);
GeeArrayList* launcher_backend_app_system_get_categories (LauncherBackendAppSystem* self);
GeeArrayList* launcher_backend_app_system_get_saved_apps (LauncherBackendAppSystem* self);
LauncherBackendApp* launcher_backend_app_new (GMenuTreeEntry* entry);
LauncherBackendApp* launcher_backend_app_construct (GType object_type,
                                                    GMenuTreeEntry* entry);
static void _vala_GMenuTreeEntry_free (GMenuTreeEntry* self);
GeeHashMap* launcher_backend_app_system_get_apps (LauncherBackendAppSystem* self);
GSList* launcher_backend_app_system_get_apps_by_name (LauncherBackendAppSystem* self);
const gchar* launcher_backend_app_get_categories (LauncherBackendApp* self);
const gchar* launcher_backend_app_get_exec (LauncherBackendApp* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gint stack_length,
                                      const gchar* needle);
gint launcher_utils_sort_apps_by_name (LauncherBackendApp* a,
                                       LauncherBackendApp* b);
static gint _launcher_utils_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                           gconstpointer b,
                                                           gpointer self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
LauncherBackendAppSystem* launcher_backend_app_system_new (void);
LauncherBackendAppSystem* launcher_backend_app_system_construct (GType object_type);
static GObject * launcher_backend_app_system_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _launcher_backend_app_system_update_app_system_gmenu_tree_changed (GMenuTree* _sender,
                                                                        gpointer self);
static GMenuTreeDirectory* _vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self);
static void launcher_backend_app_system_finalize (GObject * obj);
static GType launcher_backend_app_system_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
launcher_backend_app_system_get_instance_private (LauncherBackendAppSystem* self)
{
	return G_STRUCT_MEMBER_P (self, LauncherBackendAppSystem_private_offset);
}

void
launcher_backend_app_system_update_app_system (LauncherBackendAppSystem* self)
{
	GError* _inner_error0_ = NULL;
#line 50 "../src/Backend/AppSystem.vala"
	g_return_if_fail (self != NULL);
#line 51 "../src/Backend/AppSystem.vala"
	g_debug ("AppSystem.vala:51: Updating Applications menu tree...");
#line 151 "AppSystem.c"
	{
		GMenuTree* _tmp0_;
#line 56 "../src/Backend/AppSystem.vala"
		_tmp0_ = self->priv->apps_menu;
#line 56 "../src/Backend/AppSystem.vala"
		gmenu_tree_load_sync (_tmp0_, &_inner_error0_);
#line 56 "../src/Backend/AppSystem.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 160 "AppSystem.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 55 "../src/Backend/AppSystem.vala"
		e = _inner_error0_;
#line 55 "../src/Backend/AppSystem.vala"
		_inner_error0_ = NULL;
#line 58 "../src/Backend/AppSystem.vala"
		_tmp1_ = e;
#line 58 "../src/Backend/AppSystem.vala"
		_tmp2_ = _tmp1_->message;
#line 58 "../src/Backend/AppSystem.vala"
		g_warning ("AppSystem.vala:58: %s", _tmp2_);
#line 55 "../src/Backend/AppSystem.vala"
		_g_error_free0 (e);
#line 182 "AppSystem.c"
	}
	__finally0:
#line 55 "../src/Backend/AppSystem.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 55 "../src/Backend/AppSystem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 55 "../src/Backend/AppSystem.vala"
		g_clear_error (&_inner_error0_);
#line 55 "../src/Backend/AppSystem.vala"
		return;
#line 193 "AppSystem.c"
	}
#line 61 "../src/Backend/AppSystem.vala"
	launcher_backend_app_system_update_categories_index (self);
#line 62 "../src/Backend/AppSystem.vala"
	launcher_backend_app_system_update_apps (self);
#line 65 "../src/Backend/AppSystem.vala"
	g_signal_emit (self, launcher_backend_app_system_signals[LAUNCHER_BACKEND_APP_SYSTEM_CHANGED_SIGNAL], 0);
#line 201 "AppSystem.c"
}

static void
_vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self)
{
#line 71 "../src/Backend/AppSystem.vala"
	g_boxed_free (gmenu_tree_directory_get_type (), self);
#line 209 "AppSystem.c"
}

static void
_vala_GMenuTreeIter_free (GMenuTreeIter* self)
{
#line 68 "../src/Backend/AppSystem.vala"
	g_boxed_free (gmenu_tree_iter_get_type (), self);
#line 217 "AppSystem.c"
}

static void
launcher_backend_app_system_update_categories_index (LauncherBackendAppSystem* self)
{
	GeeArrayList* _tmp0_;
	GMenuTreeIter* iter = NULL;
	GMenuTree* _tmp1_;
	GMenuTreeDirectory* _tmp2_;
	GMenuTreeDirectory* _tmp3_;
	GMenuTreeIter* _tmp4_;
	GMenuTreeIter* _tmp5_;
	GMenuTreeItemType type = 0;
#line 68 "../src/Backend/AppSystem.vala"
	g_return_if_fail (self != NULL);
#line 69 "../src/Backend/AppSystem.vala"
	_tmp0_ = self->priv->categories;
#line 69 "../src/Backend/AppSystem.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 71 "../src/Backend/AppSystem.vala"
	_tmp1_ = self->priv->apps_menu;
#line 71 "../src/Backend/AppSystem.vala"
	_tmp2_ = gmenu_tree_get_root_directory (_tmp1_);
#line 71 "../src/Backend/AppSystem.vala"
	_tmp3_ = _tmp2_;
#line 71 "../src/Backend/AppSystem.vala"
	_tmp4_ = gmenu_tree_directory_iter (_tmp3_);
#line 71 "../src/Backend/AppSystem.vala"
	_tmp5_ = _tmp4_;
#line 71 "../src/Backend/AppSystem.vala"
	__vala_GMenuTreeDirectory_free0 (_tmp3_);
#line 71 "../src/Backend/AppSystem.vala"
	iter = _tmp5_;
#line 73 "../src/Backend/AppSystem.vala"
	while (TRUE) {
#line 253 "AppSystem.c"
		GMenuTreeIter* _tmp6_;
		GMenuTreeItemType _tmp7_;
		GMenuTreeItemType _tmp8_;
#line 73 "../src/Backend/AppSystem.vala"
		_tmp6_ = iter;
#line 73 "../src/Backend/AppSystem.vala"
		type = gmenu_tree_iter_next (_tmp6_);
#line 73 "../src/Backend/AppSystem.vala"
		_tmp7_ = type;
#line 73 "../src/Backend/AppSystem.vala"
		if (!(_tmp7_ != GMENU_TREE_ITEM_INVALID)) {
#line 73 "../src/Backend/AppSystem.vala"
			break;
#line 267 "AppSystem.c"
		}
#line 74 "../src/Backend/AppSystem.vala"
		_tmp8_ = type;
#line 74 "../src/Backend/AppSystem.vala"
		if (_tmp8_ == GMENU_TREE_ITEM_DIRECTORY) {
#line 273 "AppSystem.c"
			GMenuTreeDirectory* dir = NULL;
			GMenuTreeIter* _tmp9_;
			GMenuTreeDirectory* _tmp10_;
			GMenuTreeDirectory* _tmp11_;
#line 75 "../src/Backend/AppSystem.vala"
			_tmp9_ = iter;
#line 75 "../src/Backend/AppSystem.vala"
			_tmp10_ = gmenu_tree_iter_get_directory (_tmp9_);
#line 75 "../src/Backend/AppSystem.vala"
			dir = _tmp10_;
#line 76 "../src/Backend/AppSystem.vala"
			_tmp11_ = dir;
#line 76 "../src/Backend/AppSystem.vala"
			if (!gmenu_tree_directory_get_is_nodisplay (_tmp11_)) {
#line 288 "AppSystem.c"
				GeeArrayList* _tmp12_;
				GMenuTreeDirectory* _tmp13_;
#line 77 "../src/Backend/AppSystem.vala"
				_tmp12_ = self->priv->categories;
#line 77 "../src/Backend/AppSystem.vala"
				_tmp13_ = dir;
#line 77 "../src/Backend/AppSystem.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
#line 297 "AppSystem.c"
			}
#line 74 "../src/Backend/AppSystem.vala"
			__vala_GMenuTreeDirectory_free0 (dir);
#line 301 "AppSystem.c"
		}
	}
#line 68 "../src/Backend/AppSystem.vala"
	__vala_GMenuTreeIter_free0 (iter);
#line 306 "AppSystem.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 92 "../src/Backend/AppSystem.vala"
	return self ? g_object_ref (self) : NULL;
#line 314 "AppSystem.c"
}

static void
launcher_backend_app_system_update_apps (LauncherBackendAppSystem* self)
{
	GeeHashMap* _tmp0_;
#line 90 "../src/Backend/AppSystem.vala"
	g_return_if_fail (self != NULL);
#line 91 "../src/Backend/AppSystem.vala"
	_tmp0_ = self->priv->apps;
#line 91 "../src/Backend/AppSystem.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
#line 327 "AppSystem.c"
	{
		GeeArrayList* _cat_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _cat_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _cat_index = 0;
#line 92 "../src/Backend/AppSystem.vala"
		_tmp1_ = self->priv->categories;
#line 92 "../src/Backend/AppSystem.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 92 "../src/Backend/AppSystem.vala"
		_cat_list = _tmp2_;
#line 92 "../src/Backend/AppSystem.vala"
		_tmp3_ = _cat_list;
#line 92 "../src/Backend/AppSystem.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 92 "../src/Backend/AppSystem.vala"
		_tmp5_ = _tmp4_;
#line 92 "../src/Backend/AppSystem.vala"
		_cat_size = _tmp5_;
#line 92 "../src/Backend/AppSystem.vala"
		_cat_index = -1;
#line 92 "../src/Backend/AppSystem.vala"
		while (TRUE) {
#line 355 "AppSystem.c"
			gint _tmp6_;
			gint _tmp7_;
			GMenuTreeDirectory* cat = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GeeHashMap* _tmp10_;
			GMenuTreeDirectory* _tmp11_;
			const gchar* _tmp12_;
			GMenuTreeDirectory* _tmp13_;
			GeeArrayList* _tmp14_;
			GeeArrayList* _tmp15_;
#line 92 "../src/Backend/AppSystem.vala"
			_cat_index = _cat_index + 1;
#line 92 "../src/Backend/AppSystem.vala"
			_tmp6_ = _cat_index;
#line 92 "../src/Backend/AppSystem.vala"
			_tmp7_ = _cat_size;
#line 92 "../src/Backend/AppSystem.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 92 "../src/Backend/AppSystem.vala"
				break;
#line 377 "AppSystem.c"
			}
#line 92 "../src/Backend/AppSystem.vala"
			_tmp8_ = _cat_list;
#line 92 "../src/Backend/AppSystem.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _cat_index);
#line 92 "../src/Backend/AppSystem.vala"
			cat = (GMenuTreeDirectory*) _tmp9_;
#line 93 "../src/Backend/AppSystem.vala"
			_tmp10_ = self->priv->apps;
#line 93 "../src/Backend/AppSystem.vala"
			_tmp11_ = cat;
#line 93 "../src/Backend/AppSystem.vala"
			_tmp12_ = gmenu_tree_directory_get_name (_tmp11_);
#line 93 "../src/Backend/AppSystem.vala"
			_tmp13_ = cat;
#line 93 "../src/Backend/AppSystem.vala"
			_tmp14_ = launcher_backend_app_system_get_apps_by_category (self, _tmp13_);
#line 93 "../src/Backend/AppSystem.vala"
			_tmp15_ = _tmp14_;
#line 93 "../src/Backend/AppSystem.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp12_, _tmp15_);
#line 93 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (_tmp15_);
#line 92 "../src/Backend/AppSystem.vala"
			__vala_GMenuTreeDirectory_free0 (cat);
#line 403 "AppSystem.c"
		}
#line 92 "../src/Backend/AppSystem.vala"
		_g_object_unref0 (_cat_list);
#line 407 "AppSystem.c"
	}
}

GeeArrayList*
launcher_backend_app_system_get_categories (LauncherBackendAppSystem* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result = NULL;
#line 96 "../src/Backend/AppSystem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "../src/Backend/AppSystem.vala"
	_tmp0_ = self->priv->categories;
#line 97 "../src/Backend/AppSystem.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 97 "../src/Backend/AppSystem.vala"
	result = _tmp1_;
#line 97 "../src/Backend/AppSystem.vala"
	return result;
#line 427 "AppSystem.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 450 "AppSystem.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 459 "AppSystem.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 478 "AppSystem.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 482 "AppSystem.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 488 "AppSystem.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 498 "AppSystem.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 506 "AppSystem.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 510 "AppSystem.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 516 "AppSystem.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 526 "AppSystem.c"
}

static void
_vala_GMenuTreeEntry_free (GMenuTreeEntry* self)
{
#line 111 "../src/Backend/AppSystem.vala"
	g_boxed_free (gmenu_tree_entry_get_type (), self);
#line 534 "AppSystem.c"
}

GeeArrayList*
launcher_backend_app_system_get_saved_apps (LauncherBackendAppSystem* self)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GFile* config = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* source_dir = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result = NULL;
#line 100 "../src/Backend/AppSystem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 102 "../src/Backend/AppSystem.vala"
	_tmp0_ = gee_array_list_new (LAUNCHER_BACKEND_TYPE_APP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 102 "../src/Backend/AppSystem.vala"
	_result_ = _tmp0_;
#line 103 "../src/Backend/AppSystem.vala"
	_tmp1_ = g_get_user_config_dir ();
#line 103 "../src/Backend/AppSystem.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 103 "../src/Backend/AppSystem.vala"
	config = _tmp2_;
#line 104 "../src/Backend/AppSystem.vala"
	_tmp3_ = config;
#line 104 "../src/Backend/AppSystem.vala"
	_tmp4_ = g_file_get_child (_tmp3_, "panther");
#line 104 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (config);
#line 104 "../src/Backend/AppSystem.vala"
	config = _tmp4_;
#line 105 "../src/Backend/AppSystem.vala"
	_tmp5_ = config;
#line 105 "../src/Backend/AppSystem.vala"
	_tmp6_ = g_file_get_child (_tmp5_, "saved");
#line 105 "../src/Backend/AppSystem.vala"
	source_dir = _tmp6_;
#line 107 "../src/Backend/AppSystem.vala"
	_tmp7_ = source_dir;
#line 107 "../src/Backend/AppSystem.vala"
	if (g_file_query_exists (_tmp7_, NULL)) {
#line 583 "AppSystem.c"
		{
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp8_;
			GFileEnumerator* _tmp9_;
			GFileInfo* info = NULL;
#line 109 "../src/Backend/AppSystem.vala"
			_tmp8_ = source_dir;
#line 109 "../src/Backend/AppSystem.vala"
			_tmp9_ = g_file_enumerate_children (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, 0, NULL, &_inner_error0_);
#line 109 "../src/Backend/AppSystem.vala"
			enumerator = _tmp9_;
#line 109 "../src/Backend/AppSystem.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 597 "AppSystem.c"
				goto __catch0_g_error;
			}
#line 111 "../src/Backend/AppSystem.vala"
			while (TRUE) {
#line 602 "AppSystem.c"
				GFileInfo* _tmp10_ = NULL;
				GFileEnumerator* _tmp11_;
				GFileInfo* _tmp12_;
				GFileInfo* _tmp13_;
				GFileInfo* _tmp14_;
				gchar* filename = NULL;
				GFileInfo* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_ = FALSE;
				GFileInfo* _tmp19_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GMenuTreeEntry* te = NULL;
				GMenuTree* _tmp28_;
				const gchar* _tmp29_;
				GMenuTreeEntry* _tmp30_;
				LauncherBackendApp* app = NULL;
				GMenuTreeEntry* _tmp31_;
				LauncherBackendApp* _tmp32_;
				GeeArrayList* _tmp33_;
				LauncherBackendApp* _tmp34_;
#line 111 "../src/Backend/AppSystem.vala"
				_tmp11_ = enumerator;
#line 111 "../src/Backend/AppSystem.vala"
				_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error0_);
#line 111 "../src/Backend/AppSystem.vala"
				_tmp10_ = _tmp12_;
#line 111 "../src/Backend/AppSystem.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 111 "../src/Backend/AppSystem.vala"
					_g_object_unref0 (info);
#line 111 "../src/Backend/AppSystem.vala"
					_g_object_unref0 (enumerator);
#line 642 "AppSystem.c"
					goto __catch0_g_error;
				}
#line 111 "../src/Backend/AppSystem.vala"
				_tmp13_ = _tmp10_;
#line 111 "../src/Backend/AppSystem.vala"
				_tmp10_ = NULL;
#line 111 "../src/Backend/AppSystem.vala"
				_g_object_unref0 (info);
#line 111 "../src/Backend/AppSystem.vala"
				info = _tmp13_;
#line 111 "../src/Backend/AppSystem.vala"
				_tmp14_ = info;
#line 111 "../src/Backend/AppSystem.vala"
				if (!(_tmp14_ != NULL)) {
#line 111 "../src/Backend/AppSystem.vala"
					_g_object_unref0 (_tmp10_);
#line 111 "../src/Backend/AppSystem.vala"
					break;
#line 661 "AppSystem.c"
				}
#line 112 "../src/Backend/AppSystem.vala"
				_tmp15_ = info;
#line 112 "../src/Backend/AppSystem.vala"
				_tmp16_ = g_file_info_get_name (_tmp15_);
#line 112 "../src/Backend/AppSystem.vala"
				_tmp17_ = g_strdup (_tmp16_);
#line 112 "../src/Backend/AppSystem.vala"
				filename = _tmp17_;
#line 114 "../src/Backend/AppSystem.vala"
				_tmp19_ = info;
#line 114 "../src/Backend/AppSystem.vala"
				if (g_file_info_get_is_hidden (_tmp19_)) {
#line 114 "../src/Backend/AppSystem.vala"
					_tmp18_ = TRUE;
#line 677 "AppSystem.c"
				} else {
					const gchar* _tmp20_;
#line 114 "../src/Backend/AppSystem.vala"
					_tmp20_ = filename;
#line 114 "../src/Backend/AppSystem.vala"
					_tmp18_ = !g_str_has_suffix (_tmp20_, ".saveditem");
#line 684 "AppSystem.c"
				}
#line 114 "../src/Backend/AppSystem.vala"
				if (_tmp18_) {
#line 115 "../src/Backend/AppSystem.vala"
					_g_free0 (filename);
#line 115 "../src/Backend/AppSystem.vala"
					_g_object_unref0 (_tmp10_);
#line 115 "../src/Backend/AppSystem.vala"
					continue;
#line 694 "AppSystem.c"
				}
#line 117 "../src/Backend/AppSystem.vala"
				_tmp21_ = filename;
#line 117 "../src/Backend/AppSystem.vala"
				_tmp22_ = filename;
#line 117 "../src/Backend/AppSystem.vala"
				_tmp23_ = strlen (_tmp22_);
#line 117 "../src/Backend/AppSystem.vala"
				_tmp24_ = _tmp23_;
#line 117 "../src/Backend/AppSystem.vala"
				_tmp25_ = string_substring (_tmp21_, (glong) 0, (glong) (_tmp24_ - 9));
#line 117 "../src/Backend/AppSystem.vala"
				_tmp26_ = _tmp25_;
#line 117 "../src/Backend/AppSystem.vala"
				_tmp27_ = g_strconcat (_tmp26_, "desktop", NULL);
#line 117 "../src/Backend/AppSystem.vala"
				_g_free0 (filename);
#line 117 "../src/Backend/AppSystem.vala"
				filename = _tmp27_;
#line 117 "../src/Backend/AppSystem.vala"
				_g_free0 (_tmp26_);
#line 119 "../src/Backend/AppSystem.vala"
				_tmp28_ = self->priv->apps_menu;
#line 119 "../src/Backend/AppSystem.vala"
				_tmp29_ = filename;
#line 119 "../src/Backend/AppSystem.vala"
				_tmp30_ = gmenu_tree_get_entry_by_id (_tmp28_, _tmp29_);
#line 119 "../src/Backend/AppSystem.vala"
				te = _tmp30_;
#line 120 "../src/Backend/AppSystem.vala"
				_tmp31_ = te;
#line 120 "../src/Backend/AppSystem.vala"
				_tmp32_ = launcher_backend_app_new (_tmp31_);
#line 120 "../src/Backend/AppSystem.vala"
				app = _tmp32_;
#line 122 "../src/Backend/AppSystem.vala"
				_tmp33_ = _result_;
#line 122 "../src/Backend/AppSystem.vala"
				_tmp34_ = app;
#line 122 "../src/Backend/AppSystem.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
#line 111 "../src/Backend/AppSystem.vala"
				_g_object_unref0 (app);
#line 111 "../src/Backend/AppSystem.vala"
				__vala_GMenuTreeEntry_free0 (te);
#line 111 "../src/Backend/AppSystem.vala"
				_g_free0 (filename);
#line 111 "../src/Backend/AppSystem.vala"
				_g_object_unref0 (_tmp10_);
#line 744 "AppSystem.c"
			}
#line 108 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (info);
#line 108 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (enumerator);
#line 750 "AppSystem.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			gchar* _tmp35_ = NULL;
			GFile* _tmp36_;
			gchar* _tmp37_;
			GError* _tmp39_;
			const gchar* _tmp40_;
#line 108 "../src/Backend/AppSystem.vala"
			e = _inner_error0_;
#line 108 "../src/Backend/AppSystem.vala"
			_inner_error0_ = NULL;
#line 125 "../src/Backend/AppSystem.vala"
			_tmp36_ = source_dir;
#line 125 "../src/Backend/AppSystem.vala"
			_tmp37_ = g_file_get_path (_tmp36_);
#line 125 "../src/Backend/AppSystem.vala"
			_tmp35_ = _tmp37_;
#line 125 "../src/Backend/AppSystem.vala"
			if (_tmp35_ == NULL) {
#line 773 "AppSystem.c"
				gchar* _tmp38_;
#line 125 "../src/Backend/AppSystem.vala"
				_tmp38_ = g_strdup ("");
#line 125 "../src/Backend/AppSystem.vala"
				_g_free0 (_tmp35_);
#line 125 "../src/Backend/AppSystem.vala"
				_tmp35_ = _tmp38_;
#line 781 "AppSystem.c"
			}
#line 125 "../src/Backend/AppSystem.vala"
			_tmp39_ = e;
#line 125 "../src/Backend/AppSystem.vala"
			_tmp40_ = _tmp39_->message;
#line 125 "../src/Backend/AppSystem.vala"
			g_critical ("AppSystem.vala:125: Error loading dock elements from '%s'. (%s)", _tmp35_, _tmp40_);
#line 108 "../src/Backend/AppSystem.vala"
			_g_free0 (_tmp35_);
#line 108 "../src/Backend/AppSystem.vala"
			_g_error_free0 (e);
#line 793 "AppSystem.c"
		}
		__finally0:
#line 108 "../src/Backend/AppSystem.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 108 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (source_dir);
#line 108 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (config);
#line 108 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (_result_);
#line 108 "../src/Backend/AppSystem.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 108 "../src/Backend/AppSystem.vala"
			g_clear_error (&_inner_error0_);
#line 108 "../src/Backend/AppSystem.vala"
			return NULL;
#line 810 "AppSystem.c"
		}
	}
#line 129 "../src/Backend/AppSystem.vala"
	result = _result_;
#line 129 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (source_dir);
#line 129 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (config);
#line 129 "../src/Backend/AppSystem.vala"
	return result;
#line 821 "AppSystem.c"
}

GeeArrayList*
launcher_backend_app_system_get_apps_by_category (LauncherBackendAppSystem* self,
                                                  GMenuTreeDirectory* category)
{
	GeeArrayList* app_list = NULL;
	GeeArrayList* _tmp0_;
	GMenuTreeIter* iter = NULL;
	GMenuTreeIter* _tmp1_;
	GMenuTreeItemType type = 0;
	GeeArrayList* result = NULL;
#line 132 "../src/Backend/AppSystem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "../src/Backend/AppSystem.vala"
	g_return_val_if_fail (category != NULL, NULL);
#line 133 "../src/Backend/AppSystem.vala"
	_tmp0_ = gee_array_list_new (LAUNCHER_BACKEND_TYPE_APP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 133 "../src/Backend/AppSystem.vala"
	app_list = _tmp0_;
#line 134 "../src/Backend/AppSystem.vala"
	_tmp1_ = gmenu_tree_directory_iter (category);
#line 134 "../src/Backend/AppSystem.vala"
	iter = _tmp1_;
#line 137 "../src/Backend/AppSystem.vala"
	while (TRUE) {
#line 848 "AppSystem.c"
		GMenuTreeIter* _tmp2_;
		GMenuTreeItemType _tmp3_;
		GMenuTreeItemType _tmp4_;
#line 137 "../src/Backend/AppSystem.vala"
		_tmp2_ = iter;
#line 137 "../src/Backend/AppSystem.vala"
		type = gmenu_tree_iter_next (_tmp2_);
#line 137 "../src/Backend/AppSystem.vala"
		_tmp3_ = type;
#line 137 "../src/Backend/AppSystem.vala"
		if (!(_tmp3_ != GMENU_TREE_ITEM_INVALID)) {
#line 137 "../src/Backend/AppSystem.vala"
			break;
#line 862 "AppSystem.c"
		}
#line 138 "../src/Backend/AppSystem.vala"
		_tmp4_ = type;
#line 138 "../src/Backend/AppSystem.vala"
		switch (_tmp4_) {
#line 138 "../src/Backend/AppSystem.vala"
			case GMENU_TREE_ITEM_DIRECTORY:
#line 870 "AppSystem.c"
			{
				GeeArrayList* _tmp5_;
				GMenuTreeIter* _tmp6_;
				GMenuTreeDirectory* _tmp7_;
				GMenuTreeDirectory* _tmp8_;
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
#line 140 "../src/Backend/AppSystem.vala"
				_tmp5_ = app_list;
#line 140 "../src/Backend/AppSystem.vala"
				_tmp6_ = iter;
#line 140 "../src/Backend/AppSystem.vala"
				_tmp7_ = gmenu_tree_iter_get_directory (_tmp6_);
#line 140 "../src/Backend/AppSystem.vala"
				_tmp8_ = _tmp7_;
#line 140 "../src/Backend/AppSystem.vala"
				_tmp9_ = launcher_backend_app_system_get_apps_by_category (self, _tmp8_);
#line 140 "../src/Backend/AppSystem.vala"
				_tmp10_ = _tmp9_;
#line 140 "../src/Backend/AppSystem.vala"
				gee_array_list_add_all (_tmp5_, (GeeCollection*) _tmp10_);
#line 140 "../src/Backend/AppSystem.vala"
				_g_object_unref0 (_tmp10_);
#line 140 "../src/Backend/AppSystem.vala"
				__vala_GMenuTreeDirectory_free0 (_tmp8_);
#line 141 "../src/Backend/AppSystem.vala"
				break;
#line 898 "AppSystem.c"
			}
#line 138 "../src/Backend/AppSystem.vala"
			case GMENU_TREE_ITEM_ENTRY:
#line 902 "AppSystem.c"
			{
				LauncherBackendApp* app = NULL;
				GMenuTreeIter* _tmp11_;
				GMenuTreeEntry* _tmp12_;
				GMenuTreeEntry* _tmp13_;
				LauncherBackendApp* _tmp14_;
				LauncherBackendApp* _tmp15_;
				GeeArrayList* _tmp16_;
				LauncherBackendApp* _tmp17_;
#line 143 "../src/Backend/AppSystem.vala"
				_tmp11_ = iter;
#line 143 "../src/Backend/AppSystem.vala"
				_tmp12_ = gmenu_tree_iter_get_entry (_tmp11_);
#line 143 "../src/Backend/AppSystem.vala"
				_tmp13_ = _tmp12_;
#line 143 "../src/Backend/AppSystem.vala"
				_tmp14_ = launcher_backend_app_new (_tmp13_);
#line 143 "../src/Backend/AppSystem.vala"
				_tmp15_ = _tmp14_;
#line 143 "../src/Backend/AppSystem.vala"
				__vala_GMenuTreeEntry_free0 (_tmp13_);
#line 143 "../src/Backend/AppSystem.vala"
				app = _tmp15_;
#line 147 "../src/Backend/AppSystem.vala"
				_tmp16_ = app_list;
#line 147 "../src/Backend/AppSystem.vala"
				_tmp17_ = app;
#line 147 "../src/Backend/AppSystem.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
#line 148 "../src/Backend/AppSystem.vala"
				_g_object_unref0 (app);
#line 148 "../src/Backend/AppSystem.vala"
				break;
#line 936 "AppSystem.c"
			}
			default:
#line 138 "../src/Backend/AppSystem.vala"
			break;
#line 941 "AppSystem.c"
		}
	}
#line 152 "../src/Backend/AppSystem.vala"
	result = app_list;
#line 152 "../src/Backend/AppSystem.vala"
	__vala_GMenuTreeIter_free0 (iter);
#line 152 "../src/Backend/AppSystem.vala"
	return result;
#line 950 "AppSystem.c"
}

GeeHashMap*
launcher_backend_app_system_get_apps (LauncherBackendAppSystem* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* result = NULL;
#line 155 "../src/Backend/AppSystem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 156 "../src/Backend/AppSystem.vala"
	_tmp0_ = self->priv->apps;
#line 156 "../src/Backend/AppSystem.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 156 "../src/Backend/AppSystem.vala"
	result = _tmp1_;
#line 156 "../src/Backend/AppSystem.vala"
	return result;
#line 969 "AppSystem.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1531 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1531 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1531 "glib-2.0.vapi"
	return result;
#line 988 "AppSystem.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gint stack_length,
                             const gchar* needle)
{
	gint i;
#line 171 "../src/Backend/AppSystem.vala"
	for (i = 0; i < stack_length; i++) {
#line 171 "../src/Backend/AppSystem.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 171 "../src/Backend/AppSystem.vala"
			return TRUE;
#line 1003 "AppSystem.c"
		}
	}
#line 171 "../src/Backend/AppSystem.vala"
	return FALSE;
#line 1008 "AppSystem.c"
}

static gint
_launcher_utils_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                      gconstpointer b,
                                                      gpointer self)
{
	gint result;
	result = launcher_utils_sort_apps_by_name ((LauncherBackendApp*) a, (LauncherBackendApp*) b);
#line 172 "../src/Backend/AppSystem.vala"
	return result;
#line 1020 "AppSystem.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 173 "../src/Backend/AppSystem.vala"
	if ((*length) == (*size)) {
#line 173 "../src/Backend/AppSystem.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 173 "../src/Backend/AppSystem.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1035 "AppSystem.c"
	}
#line 173 "../src/Backend/AppSystem.vala"
	(*array)[(*length)++] = value;
#line 173 "../src/Backend/AppSystem.vala"
	(*array)[*length] = NULL;
#line 1041 "AppSystem.c"
}

GSList*
launcher_backend_app_system_get_apps_by_name (LauncherBackendAppSystem* self)
{
	GSList* sorted_apps = NULL;
	gchar** sorted_apps_execs = NULL;
	gchar** _tmp0_;
	gint sorted_apps_execs_length1;
	gint _sorted_apps_execs_size_;
	GSList* result = NULL;
#line 159 "../src/Backend/AppSystem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "../src/Backend/AppSystem.vala"
	sorted_apps = NULL;
#line 161 "../src/Backend/AppSystem.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 161 "../src/Backend/AppSystem.vala"
	sorted_apps_execs = _tmp0_;
#line 161 "../src/Backend/AppSystem.vala"
	sorted_apps_execs_length1 = 0;
#line 161 "../src/Backend/AppSystem.vala"
	_sorted_apps_execs_size_ = sorted_apps_execs_length1;
#line 1065 "AppSystem.c"
	{
		GeeIterator* _category_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 163 "../src/Backend/AppSystem.vala"
		_tmp1_ = self->priv->apps;
#line 163 "../src/Backend/AppSystem.vala"
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
#line 163 "../src/Backend/AppSystem.vala"
		_tmp3_ = _tmp2_;
#line 163 "../src/Backend/AppSystem.vala"
		_tmp4_ = _tmp3_;
#line 163 "../src/Backend/AppSystem.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 163 "../src/Backend/AppSystem.vala"
		_tmp6_ = _tmp5_;
#line 163 "../src/Backend/AppSystem.vala"
		_g_object_unref0 (_tmp4_);
#line 163 "../src/Backend/AppSystem.vala"
		_category_it = _tmp6_;
#line 163 "../src/Backend/AppSystem.vala"
		while (TRUE) {
#line 1092 "AppSystem.c"
			GeeIterator* _tmp7_;
			GeeArrayList* category = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
#line 163 "../src/Backend/AppSystem.vala"
			_tmp7_ = _category_it;
#line 163 "../src/Backend/AppSystem.vala"
			if (!gee_iterator_next (_tmp7_)) {
#line 163 "../src/Backend/AppSystem.vala"
				break;
#line 1103 "AppSystem.c"
			}
#line 163 "../src/Backend/AppSystem.vala"
			_tmp8_ = _category_it;
#line 163 "../src/Backend/AppSystem.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 163 "../src/Backend/AppSystem.vala"
			category = (GeeArrayList*) _tmp9_;
#line 1111 "AppSystem.c"
			{
				GeeArrayList* _app_list = NULL;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				gint _app_size = 0;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _app_index = 0;
#line 164 "../src/Backend/AppSystem.vala"
				_tmp10_ = category;
#line 164 "../src/Backend/AppSystem.vala"
				_tmp11_ = _g_object_ref0 (_tmp10_);
#line 164 "../src/Backend/AppSystem.vala"
				_app_list = _tmp11_;
#line 164 "../src/Backend/AppSystem.vala"
				_tmp12_ = _app_list;
#line 164 "../src/Backend/AppSystem.vala"
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
#line 164 "../src/Backend/AppSystem.vala"
				_tmp14_ = _tmp13_;
#line 164 "../src/Backend/AppSystem.vala"
				_app_size = _tmp14_;
#line 164 "../src/Backend/AppSystem.vala"
				_app_index = -1;
#line 164 "../src/Backend/AppSystem.vala"
				while (TRUE) {
#line 1139 "AppSystem.c"
					gint _tmp15_;
					gint _tmp16_;
					LauncherBackendApp* app = NULL;
					GeeArrayList* _tmp17_;
					gpointer _tmp18_;
					gboolean _tmp19_ = FALSE;
					LauncherBackendApp* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					LauncherBackendApp* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gchar** _tmp29_;
					gint _tmp29__length1;
#line 164 "../src/Backend/AppSystem.vala"
					_app_index = _app_index + 1;
#line 164 "../src/Backend/AppSystem.vala"
					_tmp15_ = _app_index;
#line 164 "../src/Backend/AppSystem.vala"
					_tmp16_ = _app_size;
#line 164 "../src/Backend/AppSystem.vala"
					if (!(_tmp15_ < _tmp16_)) {
#line 164 "../src/Backend/AppSystem.vala"
						break;
#line 1164 "AppSystem.c"
					}
#line 164 "../src/Backend/AppSystem.vala"
					_tmp17_ = _app_list;
#line 164 "../src/Backend/AppSystem.vala"
					_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _app_index);
#line 164 "../src/Backend/AppSystem.vala"
					app = (LauncherBackendApp*) _tmp18_;
#line 166 "../src/Backend/AppSystem.vala"
					_tmp20_ = app;
#line 166 "../src/Backend/AppSystem.vala"
					_tmp21_ = launcher_backend_app_get_categories (_tmp20_);
#line 166 "../src/Backend/AppSystem.vala"
					_tmp22_ = _tmp21_;
#line 166 "../src/Backend/AppSystem.vala"
					if (_tmp22_ != NULL) {
#line 1180 "AppSystem.c"
						LauncherBackendApp* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
#line 167 "../src/Backend/AppSystem.vala"
						_tmp23_ = app;
#line 167 "../src/Backend/AppSystem.vala"
						_tmp24_ = launcher_backend_app_get_categories (_tmp23_);
#line 167 "../src/Backend/AppSystem.vala"
						_tmp25_ = _tmp24_;
#line 167 "../src/Backend/AppSystem.vala"
						_tmp19_ = string_contains (_tmp25_, LAUNCHER_BACKEND_APP_SYSTEM_GCC_PANEL_CATEGORY);
#line 1192 "AppSystem.c"
					} else {
#line 166 "../src/Backend/AppSystem.vala"
						_tmp19_ = FALSE;
#line 1196 "AppSystem.c"
					}
#line 166 "../src/Backend/AppSystem.vala"
					if (_tmp19_) {
#line 168 "../src/Backend/AppSystem.vala"
						_g_object_unref0 (app);
#line 168 "../src/Backend/AppSystem.vala"
						continue;
#line 1204 "AppSystem.c"
					}
#line 171 "../src/Backend/AppSystem.vala"
					_tmp26_ = app;
#line 171 "../src/Backend/AppSystem.vala"
					_tmp27_ = launcher_backend_app_get_exec (_tmp26_);
#line 171 "../src/Backend/AppSystem.vala"
					_tmp28_ = _tmp27_;
#line 171 "../src/Backend/AppSystem.vala"
					_tmp29_ = sorted_apps_execs;
#line 171 "../src/Backend/AppSystem.vala"
					_tmp29__length1 = sorted_apps_execs_length1;
#line 171 "../src/Backend/AppSystem.vala"
					if (!_vala_string_array_contains (_tmp29_, _tmp29__length1, _tmp28_)) {
#line 1218 "AppSystem.c"
						LauncherBackendApp* _tmp30_;
						LauncherBackendApp* _tmp31_;
						LauncherBackendApp* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						gchar* _tmp35_;
#line 172 "../src/Backend/AppSystem.vala"
						_tmp30_ = app;
#line 172 "../src/Backend/AppSystem.vala"
						_tmp31_ = _g_object_ref0 (_tmp30_);
#line 172 "../src/Backend/AppSystem.vala"
						sorted_apps = g_slist_insert_sorted_with_data (sorted_apps, _tmp31_, _launcher_utils_sort_apps_by_name_gcompare_data_func, NULL);
#line 173 "../src/Backend/AppSystem.vala"
						_tmp32_ = app;
#line 173 "../src/Backend/AppSystem.vala"
						_tmp33_ = launcher_backend_app_get_exec (_tmp32_);
#line 173 "../src/Backend/AppSystem.vala"
						_tmp34_ = _tmp33_;
#line 173 "../src/Backend/AppSystem.vala"
						_tmp35_ = g_strdup (_tmp34_);
#line 173 "../src/Backend/AppSystem.vala"
						_vala_array_add1 (&sorted_apps_execs, &sorted_apps_execs_length1, &_sorted_apps_execs_size_, _tmp35_);
#line 1241 "AppSystem.c"
					}
#line 164 "../src/Backend/AppSystem.vala"
					_g_object_unref0 (app);
#line 1245 "AppSystem.c"
				}
#line 164 "../src/Backend/AppSystem.vala"
				_g_object_unref0 (_app_list);
#line 1249 "AppSystem.c"
			}
#line 163 "../src/Backend/AppSystem.vala"
			_g_object_unref0 (category);
#line 1253 "AppSystem.c"
		}
#line 163 "../src/Backend/AppSystem.vala"
		_g_object_unref0 (_category_it);
#line 1257 "AppSystem.c"
	}
#line 178 "../src/Backend/AppSystem.vala"
	result = sorted_apps;
#line 178 "../src/Backend/AppSystem.vala"
	sorted_apps_execs = (_vala_array_free (sorted_apps_execs, sorted_apps_execs_length1, (GDestroyNotify) g_free), NULL);
#line 178 "../src/Backend/AppSystem.vala"
	return result;
#line 1265 "AppSystem.c"
}

LauncherBackendAppSystem*
launcher_backend_app_system_construct (GType object_type)
{
	LauncherBackendAppSystem * self = NULL;
#line 21 "../src/Backend/AppSystem.vala"
	self = (LauncherBackendAppSystem*) g_object_new (object_type, NULL);
#line 21 "../src/Backend/AppSystem.vala"
	return self;
#line 1276 "AppSystem.c"
}

LauncherBackendAppSystem*
launcher_backend_app_system_new (void)
{
#line 21 "../src/Backend/AppSystem.vala"
	return launcher_backend_app_system_construct (LAUNCHER_BACKEND_TYPE_APP_SYSTEM);
#line 1284 "AppSystem.c"
}

static void
_launcher_backend_app_system_update_app_system_gmenu_tree_changed (GMenuTree* _sender,
                                                                   gpointer self)
{
#line 42 "../src/Backend/AppSystem.vala"
	launcher_backend_app_system_update_app_system ((LauncherBackendAppSystem*) self);
#line 1293 "AppSystem.c"
}

static GMenuTreeDirectory*
_vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self)
{
#line 45 "../src/Backend/AppSystem.vala"
	return g_boxed_copy (gmenu_tree_directory_get_type (), self);
#line 1301 "AppSystem.c"
}

static GObject *
launcher_backend_app_system_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LauncherBackendAppSystem * self;
	GMenuTree* _tmp0_;
	GMenuTree* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeArrayList* _tmp3_;
#line 35 "../src/Backend/AppSystem.vala"
	parent_class = G_OBJECT_CLASS (launcher_backend_app_system_parent_class);
#line 35 "../src/Backend/AppSystem.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 35 "../src/Backend/AppSystem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_BACKEND_TYPE_APP_SYSTEM, LauncherBackendAppSystem);
#line 41 "../src/Backend/AppSystem.vala"
	_tmp0_ = gmenu_tree_new ("panther-applications.menu", GMENU_TREE_FLAGS_INCLUDE_EXCLUDED | GMENU_TREE_FLAGS_SORT_DISPLAY_NAME);
#line 41 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (self->priv->apps_menu);
#line 41 "../src/Backend/AppSystem.vala"
	self->priv->apps_menu = _tmp0_;
#line 42 "../src/Backend/AppSystem.vala"
	_tmp1_ = self->priv->apps_menu;
#line 42 "../src/Backend/AppSystem.vala"
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _launcher_backend_app_system_update_app_system_gmenu_tree_changed, self, 0);
#line 44 "../src/Backend/AppSystem.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 44 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (self->priv->apps);
#line 44 "../src/Backend/AppSystem.vala"
	self->priv->apps = _tmp2_;
#line 45 "../src/Backend/AppSystem.vala"
	_tmp3_ = gee_array_list_new (gmenu_tree_directory_get_type (), (GBoxedCopyFunc) _vala_GMenuTreeDirectory_copy, (GDestroyNotify) _vala_GMenuTreeDirectory_free, NULL, NULL, NULL);
#line 45 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (self->priv->categories);
#line 45 "../src/Backend/AppSystem.vala"
	self->priv->categories = _tmp3_;
#line 47 "../src/Backend/AppSystem.vala"
	launcher_backend_app_system_update_app_system (self);
#line 35 "../src/Backend/AppSystem.vala"
	return obj;
#line 1348 "AppSystem.c"
}

static void
launcher_backend_app_system_class_init (LauncherBackendAppSystemClass * klass,
                                        gpointer klass_data)
{
#line 21 "../src/Backend/AppSystem.vala"
	launcher_backend_app_system_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/Backend/AppSystem.vala"
	g_type_class_adjust_private_offset (klass, &LauncherBackendAppSystem_private_offset);
#line 21 "../src/Backend/AppSystem.vala"
	G_OBJECT_CLASS (klass)->constructor = launcher_backend_app_system_constructor;
#line 21 "../src/Backend/AppSystem.vala"
	G_OBJECT_CLASS (klass)->finalize = launcher_backend_app_system_finalize;
#line 21 "../src/Backend/AppSystem.vala"
	launcher_backend_app_system_signals[LAUNCHER_BACKEND_APP_SYSTEM_CHANGED_SIGNAL] = g_signal_new ("changed", LAUNCHER_BACKEND_TYPE_APP_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1365 "AppSystem.c"
}

static void
launcher_backend_app_system_instance_init (LauncherBackendAppSystem * self,
                                           gpointer klass)
{
#line 21 "../src/Backend/AppSystem.vala"
	self->priv = launcher_backend_app_system_get_instance_private (self);
#line 25 "../src/Backend/AppSystem.vala"
	self->priv->categories = NULL;
#line 26 "../src/Backend/AppSystem.vala"
	self->priv->apps = NULL;
#line 27 "../src/Backend/AppSystem.vala"
	self->priv->apps_menu = NULL;
#line 1380 "AppSystem.c"
}

static void
launcher_backend_app_system_finalize (GObject * obj)
{
	LauncherBackendAppSystem * self;
#line 21 "../src/Backend/AppSystem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LAUNCHER_BACKEND_TYPE_APP_SYSTEM, LauncherBackendAppSystem);
#line 25 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (self->priv->categories);
#line 26 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (self->priv->apps);
#line 27 "../src/Backend/AppSystem.vala"
	_g_object_unref0 (self->priv->apps_menu);
#line 21 "../src/Backend/AppSystem.vala"
	G_OBJECT_CLASS (launcher_backend_app_system_parent_class)->finalize (obj);
#line 1397 "AppSystem.c"
}

static GType
launcher_backend_app_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LauncherBackendAppSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_backend_app_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LauncherBackendAppSystem), 0, (GInstanceInitFunc) launcher_backend_app_system_instance_init, NULL };
	GType launcher_backend_app_system_type_id;
	launcher_backend_app_system_type_id = g_type_register_static (G_TYPE_OBJECT, "LauncherBackendAppSystem", &g_define_type_info, 0);
	LauncherBackendAppSystem_private_offset = g_type_add_instance_private (launcher_backend_app_system_type_id, sizeof (LauncherBackendAppSystemPrivate));
	return launcher_backend_app_system_type_id;
}

GType
launcher_backend_app_system_get_type (void)
{
	static volatile gsize launcher_backend_app_system_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_backend_app_system_type_id__volatile)) {
		GType launcher_backend_app_system_type_id;
		launcher_backend_app_system_type_id = launcher_backend_app_system_get_type_once ();
		g_once_init_leave (&launcher_backend_app_system_type_id__volatile, launcher_backend_app_system_type_id);
	}
	return launcher_backend_app_system_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

