/* desktop-file-plugin.c generated by valac 0.48.13, the Vala compiler
 * generated from desktop-file-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include "synapse-core.h"
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>

#define SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN (synapse_desktop_file_plugin_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))

typedef struct _SynapseDesktopFilePlugin SynapseDesktopFilePlugin;
typedef struct _SynapseDesktopFilePluginClass SynapseDesktopFilePluginClass;
typedef struct _SynapseDesktopFilePluginPrivate SynapseDesktopFilePluginPrivate;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH (synapse_desktop_file_plugin_desktop_file_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))

typedef struct _SynapseDesktopFilePluginDesktopFileMatch SynapseDesktopFilePluginDesktopFileMatch;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchClass SynapseDesktopFilePluginDesktopFileMatchClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION (synapse_desktop_file_plugin_open_with_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))

typedef struct _SynapseDesktopFilePluginOpenWithAction SynapseDesktopFilePluginOpenWithAction;
typedef struct _SynapseDesktopFilePluginOpenWithActionClass SynapseDesktopFilePluginOpenWithActionClass;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFilePluginLoadAllDesktopFilesData SynapseDesktopFilePluginLoadAllDesktopFilesData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH (synapse_desktop_file_plugin_action_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatchClass))

typedef struct _SynapseDesktopFilePluginActionMatch SynapseDesktopFilePluginActionMatch;
typedef struct _SynapseDesktopFilePluginActionMatchClass SynapseDesktopFilePluginActionMatchClass;
typedef struct _Block1Data Block1Data;
typedef struct _SynapseDesktopFilePluginSearchData SynapseDesktopFilePluginSearchData;
typedef struct _SynapseDesktopFilePluginActionMatchPrivate SynapseDesktopFilePluginActionMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NUM_PROPERTIES];
typedef struct _SynapseDesktopFilePluginDesktopFileMatchPrivate SynapseDesktopFilePluginDesktopFileMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES];
typedef struct _SynapseDesktopFilePluginOpenWithActionPrivate SynapseDesktopFilePluginOpenWithActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS
};
static guint synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseDesktopFilePlugin {
	GObject parent_instance;
	SynapseDesktopFilePluginPrivate * priv;
};

struct _SynapseDesktopFilePluginClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginPrivate {
	gboolean _enabled;
	GeeList* desktop_files;
	gboolean loading_in_progress;
	GeeMap* mimetype_map;
};

struct _SynapseDesktopFilePluginLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp0_;
	GeeList* _dfi_list;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	gint _dfi_size;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _dfi_index;
	gint _tmp6_;
	gint _tmp7_;
	SynapseDesktopFileInfo* dfi;
	GeeList* _tmp8_;
	gpointer _tmp9_;
	GeeList* _tmp10_;
	SynapseDesktopFileInfo* _tmp11_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp12_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp13_;
};

struct _Block1Data {
	int _ref_count_;
	SynapseDesktopFilePlugin* self;
	gpointer _async_data_;
};

struct _SynapseDesktopFilePluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block1Data* _data1_;
	gulong signal_id;
	gulong _tmp0_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseMatcherFlags _tmp8_;
	SynapseQuery _tmp9_;
	SynapseResultSet* _tmp10_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFilePluginActionMatch {
	GObject parent_instance;
	SynapseDesktopFilePluginActionMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginActionMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginActionMatchPrivate {
	gchar* _title;
	gchar* _icon_name;
	gchar* _description;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _filename;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* action_name;
};

struct _SynapseDesktopFilePluginDesktopFileMatch {
	GObject parent_instance;
	SynapseDesktopFilePluginDesktopFileMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginDesktopFileMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginDesktopFileMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _gettext_domain;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _generic_name;
	gchar* title_folded;
	gchar* _title_unaccented;
	gchar* _desktop_id;
	gchar* _exec;
};

struct _SynapseDesktopFilePluginOpenWithAction {
	GObject parent_instance;
	SynapseDesktopFilePluginOpenWithActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenWithActionClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginOpenWithActionPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	SynapseDesktopFileInfo* _desktop_info;
};

static gint SynapseDesktopFilePlugin_private_offset;
static gpointer synapse_desktop_file_plugin_parent_class = NULL;
static gint SynapseDesktopFilePluginActionMatch_private_offset;
static gpointer synapse_desktop_file_plugin_action_match_parent_class = NULL;
static SynapseMatchIface * synapse_desktop_file_plugin_action_match_synapse_match_parent_iface = NULL;
static gint SynapseDesktopFilePluginDesktopFileMatch_private_offset;
static gpointer synapse_desktop_file_plugin_desktop_file_match_parent_class = NULL;
static SynapseMatchIface * synapse_desktop_file_plugin_desktop_file_match_synapse_match_parent_iface = NULL;
static SynapseApplicationMatchIface * synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = NULL;
static gint SynapseDesktopFilePluginOpenWithAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_with_action_parent_class = NULL;
static SynapseMatchIface * synapse_desktop_file_plugin_open_with_action_synapse_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_desktop_file_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_desktop_file_plugin_synapse_item_provider_parent_iface = NULL;
static SynapseActionProviderIface * synapse_desktop_file_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_desktop_file_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePlugin, g_object_unref)
static GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePluginDesktopFileMatch, g_object_unref)
static GType synapse_desktop_file_plugin_open_with_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePluginOpenWithAction, g_object_unref)
static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_register_plugin (void);
static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                                GAsyncResult* _res_);
static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_);
static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type,
                                                                                                             SynapseDesktopFileInfo* info);
static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                                    SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                                    gint base_relevancy);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                              SynapseQuery* q,
                                              SynapseResultSet* results,
                                              SynapseMatcherFlags flags);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self);
GType synapse_desktop_file_plugin_action_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePluginActionMatch, g_object_unref)
SynapseDesktopFilePluginActionMatch* synapse_desktop_file_plugin_action_match_new (const gchar* desktop_id,
                                                                                   const gchar* action_name);
SynapseDesktopFilePluginActionMatch* synapse_desktop_file_plugin_action_match_construct (GType object_type,
                                                                                         const gchar* desktop_id,
                                                                                         const gchar* action_name);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self);
static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                         SynapseQuery* q);
static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data);
static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                              SynapseQuery* q,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_);
static void ____lambda4__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                             gpointer self);
static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self);
static SynapseResultSet* synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                                   SynapseQuery* query,
                                                                   SynapseMatch* match);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                                                                SynapseDesktopFileInfo* info);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_new (void);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_construct (GType object_type);
void synapse_desktop_file_plugin_action_match_set_app_info (SynapseDesktopFilePluginActionMatch* self,
                                                            GAppInfo* value);
static void synapse_desktop_file_plugin_action_match_real_execute (SynapseMatch* base,
                                                            SynapseMatch* match);
GAppInfo* synapse_desktop_file_plugin_action_match_get_app_info (SynapseDesktopFilePluginActionMatch* self);
const gchar* synapse_desktop_file_plugin_action_match_get_filename (SynapseDesktopFilePluginActionMatch* self);
void synapse_desktop_file_plugin_action_match_set_filename (SynapseDesktopFilePluginActionMatch* self,
                                                            const gchar* value);
gboolean synapse_desktop_file_plugin_action_match_get_needs_terminal (SynapseDesktopFilePluginActionMatch* self);
void synapse_desktop_file_plugin_action_match_set_needs_terminal (SynapseDesktopFilePluginActionMatch* self,
                                                                  gboolean value);
static void synapse_desktop_file_plugin_action_match_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_action_match_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_action_match_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_action_match_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static void synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                              const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                          const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                        const gchar* value);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (void);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type);
static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_desktop_file_match_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static void synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                  SynapseDesktopFileInfo* info);
static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                    SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base,
                                                                SynapseMatch* match);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_open_with_action_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GObject * synapse_desktop_file_plugin_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _synapse_desktop_file_plugin___lambda5_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                           gpointer self);
static void _synapse_desktop_file_plugin___lambda6_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                        gpointer self);
static void synapse_desktop_file_plugin_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static gint _vala_array_length (gpointer array);

static const gchar* SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

static inline gpointer
synapse_desktop_file_plugin_get_instance_private (SynapseDesktopFilePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePlugin_private_offset);
}

static void
synapse_desktop_file_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
#line 27 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 469 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
#line 29 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 478 "desktop-file-plugin.c"
}

static void
_synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 125 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_register_plugin ();
#line 486 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
#line 125 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
#line 125 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 125 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, "Application Search", _ ("Search for and run applications on your computer."), "system-run", _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 125 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 502 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = _data;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_slice_free (SynapseDesktopFilePluginLoadAllDesktopFilesData, _data_);
#line 514 "desktop-file-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 522 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_ = g_slice_new0 (SynapseDesktopFilePluginLoadAllDesktopFilesData);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_load_all_desktop_files_data_free);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files_co (_data_);
#line 544 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                           GAsyncResult* _res_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 554 "desktop-file-plugin.c"
}

static gboolean
_synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_load_all_desktop_files_co (self);
#line 160 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 564 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_)
{
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (_data_->_state_) {
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case 0:
#line 574 "desktop-file-plugin.c"
		goto _state_0;
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case 1:
#line 578 "desktop-file-plugin.c"
		goto _state_1;
		default:
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_assert_not_reached ();
#line 583 "desktop-file-plugin.c"
	}
	_state_0:
#line 159 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->self->priv->loading_in_progress = TRUE;
#line 160 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func, _data_, NULL);
#line 161 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_state_ = 1;
#line 161 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return FALSE;
#line 594 "desktop-file-plugin.c"
	_state_1:
	;
#line 163 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_tmp0_ = synapse_desktop_file_service_get_default ();
#line 163 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->dfs = _data_->_tmp0_;
#line 601 "desktop-file-plugin.c"
	{
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp1_ = _data_->dfs;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp2_ = synapse_desktop_file_service_get_desktop_files (_data_->_tmp1_);
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_dfi_list = _data_->_tmp2_;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp3_ = _data_->_dfi_list;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_dfi_size = _data_->_tmp5_;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_dfi_index = -1;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		while (TRUE) {
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_dfi_index = _data_->_dfi_index + 1;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp6_ = _data_->_dfi_index;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp7_ = _data_->_dfi_size;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
				break;
#line 631 "desktop-file-plugin.c"
			}
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp8_ = _data_->_dfi_list;
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp9_ = gee_list_get (_data_->_tmp8_, _data_->_dfi_index);
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->dfi = (SynapseDesktopFileInfo*) _data_->_tmp9_;
#line 166 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp10_ = _data_->self->priv->desktop_files;
#line 166 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp11_ = _data_->dfi;
#line 166 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp12_ = synapse_desktop_file_plugin_desktop_file_match_new_for_info (_data_->_tmp11_);
#line 166 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 166 "../lib/synapse-plugins/desktop-file-plugin.vala"
			gee_collection_add ((GeeCollection*) _data_->_tmp10_, _data_->_tmp13_);
#line 166 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_tmp13_);
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->dfi);
#line 653 "desktop-file-plugin.c"
		}
#line 165 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (_data_->_dfi_list);
#line 657 "desktop-file-plugin.c"
	}
#line 169 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->self->priv->loading_in_progress = FALSE;
#line 170 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_signal_emit (_data_->self, synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL], 0);
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->dfs);
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_data_->_state_ != 0) {
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 673 "desktop-file-plugin.c"
		}
	}
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 158 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return FALSE;
#line 680 "desktop-file-plugin.c"
}

static gint
synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                               SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                               gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat popularity = 0.0F;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint r = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result = 0;
#line 173 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 173 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (dfm != NULL, 0);
#line 174 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_relevancy_service_get_default ();
#line 174 "../lib/synapse-plugins/desktop-file-plugin.vala"
	rs = _tmp0_;
#line 175 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
#line 175 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 175 "../lib/synapse-plugins/desktop-file-plugin.vala"
	popularity = synapse_relevancy_service_get_application_popularity (rs, _tmp2_);
#line 177 "../lib/synapse-plugins/desktop-file-plugin.vala"
	r = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
#line 178 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
#line 178 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 178 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_debug ("desktop-file-plugin.vala:178: relevancy for %s: %d", _tmp4_, r);
#line 180 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = r;
#line 180 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (rs);
#line 180 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 725 "desktop-file-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 747 "desktop-file-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 751 "desktop-file-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 757 "desktop-file-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 761 "desktop-file-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 765 "desktop-file-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 773 "desktop-file-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 805 "desktop-file-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 814 "desktop-file-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 830 "desktop-file-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 839 "desktop-file-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 853 "desktop-file-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 862 "desktop-file-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 871 "desktop-file-plugin.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1531 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1531 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1531 "glib-2.0.vapi"
	return result;
#line 890 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                         SynapseQuery* q,
                                         SynapseResultSet* results,
                                         SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
#line 183 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 183 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (q != NULL);
#line 183 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (results != NULL);
#line 185 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = *q;
#line 185 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_.query_string_folded;
#line 185 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
#line 185 "../lib/synapse-plugins/desktop-file-plugin.vala"
	matchers = _tmp2_;
#line 917 "desktop-file-plugin.c"
	{
		GeeList* _dfm_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _dfm_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _dfm_index = 0;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp3_ = self->priv->desktop_files;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_dfm_list = _tmp4_;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp5_ = _dfm_list;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp7_ = _tmp6_;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_dfm_size = _tmp7_;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_dfm_index = -1;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		while (TRUE) {
#line 945 "desktop-file-plugin.c"
			gint _tmp8_;
			gint _tmp9_;
			SynapseDesktopFilePluginDesktopFileMatch* dfm = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			const gchar* folded_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp12_;
			const gchar* _tmp13_;
			const gchar* unaccented_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* comment = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* generic_name = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* gettext_domain = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* id = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			GDesktopAppInfo* desktop_app_info = NULL;
			const gchar* _tmp30_;
			GDesktopAppInfo* _tmp31_;
			GMatchInfo* info = NULL;
			GDesktopAppInfo* _tmp32_;
			gchar** _tmp33_;
			gchar** _tmp34_;
			gboolean matched = FALSE;
			gchar** keywords = NULL;
			GDesktopAppInfo* _tmp74_;
			gchar** _tmp75_;
			gchar** _tmp76_;
			gint keywords_length1;
			gint _keywords_size_;
			gboolean _tmp129_ = FALSE;
			const gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			SynapseQuery _tmp133_;
			const gchar* _tmp134_;
			gboolean _tmp135_;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_dfm_index = _dfm_index + 1;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp8_ = _dfm_index;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp9_ = _dfm_size;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
				break;
#line 1006 "desktop-file-plugin.c"
			}
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp10_ = _dfm_list;
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp11_ = gee_list_get (_tmp10_, _dfm_index);
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			dfm = (SynapseDesktopFilePluginDesktopFileMatch*) _tmp11_;
#line 188 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp12_ = dfm;
#line 188 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp13_ = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (_tmp12_);
#line 188 "../lib/synapse-plugins/desktop-file-plugin.vala"
			folded_title = _tmp13_;
#line 189 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp14_ = dfm;
#line 189 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp15_ = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (_tmp14_);
#line 189 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp16_ = _tmp15_;
#line 189 "../lib/synapse-plugins/desktop-file-plugin.vala"
			unaccented_title = _tmp16_;
#line 190 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp17_ = dfm;
#line 190 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp18_ = synapse_match_get_description ((SynapseMatch*) _tmp17_);
#line 190 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp19_ = _tmp18_;
#line 190 "../lib/synapse-plugins/desktop-file-plugin.vala"
			comment = _tmp19_;
#line 191 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp20_ = dfm;
#line 191 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp21_ = synapse_desktop_file_plugin_desktop_file_match_get_generic_name (_tmp20_);
#line 191 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp22_ = _tmp21_;
#line 191 "../lib/synapse-plugins/desktop-file-plugin.vala"
			generic_name = _tmp22_;
#line 192 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp23_ = dfm;
#line 192 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp24_ = synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (_tmp23_);
#line 192 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp25_ = _tmp24_;
#line 192 "../lib/synapse-plugins/desktop-file-plugin.vala"
			gettext_domain = _tmp25_;
#line 194 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp26_ = dfm;
#line 194 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp27_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (_tmp26_);
#line 194 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp28_ = _tmp27_;
#line 194 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp29_ = string_replace (_tmp28_, "application://", "");
#line 194 "../lib/synapse-plugins/desktop-file-plugin.vala"
			id = _tmp29_;
#line 195 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp30_ = id;
#line 195 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp31_ = g_desktop_app_info_new (_tmp30_);
#line 195 "../lib/synapse-plugins/desktop-file-plugin.vala"
			desktop_app_info = _tmp31_;
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp32_ = desktop_app_info;
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp34_ = _tmp33_ = g_desktop_app_info_list_actions (_tmp32_);
#line 1072 "desktop-file-plugin.c"
			{
				gchar** action_collection = NULL;
				gint action_collection_length1 = 0;
				gint _action_collection_size_ = 0;
				gint action_it = 0;
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
				action_collection = _tmp34_;
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
				action_collection_length1 = _vala_array_length (_tmp33_);
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
				for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
#line 1084 "desktop-file-plugin.c"
					gchar* _tmp35_;
					gchar* action = NULL;
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp35_ = g_strdup (action_collection[action_it]);
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
					action = _tmp35_;
#line 1091 "desktop-file-plugin.c"
					{
						gchar* title = NULL;
						GDesktopAppInfo* _tmp36_;
						const gchar* _tmp37_;
						gchar* _tmp38_;
						const gchar* _tmp39_;
#line 201 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp36_ = desktop_app_info;
#line 201 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp37_ = action;
#line 201 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp38_ = g_desktop_app_info_get_action_name (_tmp36_, _tmp37_);
#line 201 "../lib/synapse-plugins/desktop-file-plugin.vala"
						title = _tmp38_;
#line 202 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp39_ = gettext_domain;
#line 202 "../lib/synapse-plugins/desktop-file-plugin.vala"
						if (_tmp39_ != NULL) {
#line 1110 "desktop-file-plugin.c"
							const gchar* _tmp40_;
							const gchar* _tmp41_;
							gchar* _tmp42_;
#line 203 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp40_ = gettext_domain;
#line 203 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp41_ = title;
#line 203 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp42_ = g_utf8_strdown (g_dgettext (_tmp40_, _tmp41_), (gssize) -1);
#line 203 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_g_free0 (title);
#line 203 "../lib/synapse-plugins/desktop-file-plugin.vala"
							title = _tmp42_;
#line 1124 "desktop-file-plugin.c"
						} else {
							const gchar* _tmp43_;
							gchar* _tmp44_;
#line 205 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp43_ = title;
#line 205 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) -1);
#line 205 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_g_free0 (title);
#line 205 "../lib/synapse-plugins/desktop-file-plugin.vala"
							title = _tmp44_;
#line 1136 "desktop-file-plugin.c"
						}
						{
							GeeList* _matcher_list = NULL;
							GeeList* _tmp45_;
							GeeList* _tmp46_;
							gint _matcher_size = 0;
							GeeList* _tmp47_;
							gint _tmp48_;
							gint _tmp49_;
							gint _matcher_index = 0;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp45_ = matchers;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp46_ = _g_object_ref0 (_tmp45_);
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_matcher_list = _tmp46_;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp47_ = _matcher_list;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp49_ = _tmp48_;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_matcher_size = _tmp49_;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_matcher_index = -1;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							while (TRUE) {
#line 1165 "desktop-file-plugin.c"
								gint _tmp50_;
								gint _tmp51_;
								GeeMapEntry* matcher = NULL;
								GeeList* _tmp52_;
								gpointer _tmp53_;
								GeeMapEntry* _tmp54_;
								gconstpointer _tmp55_;
								gconstpointer _tmp56_;
								const gchar* _tmp57_;
								GMatchInfo* _tmp58_ = NULL;
								gboolean _tmp59_;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_matcher_index = _matcher_index + 1;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp50_ = _matcher_index;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp51_ = _matcher_size;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								if (!(_tmp50_ < _tmp51_)) {
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
									break;
#line 1187 "desktop-file-plugin.c"
								}
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp52_ = _matcher_list;
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp53_ = gee_list_get (_tmp52_, _matcher_index);
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								matcher = (GeeMapEntry*) _tmp53_;
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp54_ = matcher;
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp55_ = gee_map_entry_get_key (_tmp54_);
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp56_ = _tmp55_;
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp57_ = title;
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp59_ = g_regex_match ((GRegex*) _tmp56_, _tmp57_, 0, &_tmp58_);
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_g_match_info_unref0 (info);
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								info = _tmp58_;
#line 209 "../lib/synapse-plugins/desktop-file-plugin.vala"
								if (_tmp59_) {
#line 1211 "desktop-file-plugin.c"
									SynapseDesktopFilePluginActionMatch* am = NULL;
									const gchar* _tmp60_;
									const gchar* _tmp61_;
									SynapseDesktopFilePluginActionMatch* _tmp62_;
									SynapseDesktopFilePluginActionMatch* _tmp63_;
									SynapseDesktopFilePluginDesktopFileMatch* _tmp64_;
									GeeMapEntry* _tmp65_;
									gconstpointer _tmp66_;
									gconstpointer _tmp67_;
#line 210 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp60_ = id;
#line 210 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp61_ = action;
#line 210 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp62_ = synapse_desktop_file_plugin_action_match_new (_tmp60_, _tmp61_);
#line 210 "../lib/synapse-plugins/desktop-file-plugin.vala"
									am = _tmp62_;
#line 211 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp63_ = am;
#line 211 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp64_ = dfm;
#line 211 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp65_ = matcher;
#line 211 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp66_ = gee_map_entry_get_value (_tmp65_);
#line 211 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp67_ = _tmp66_;
#line 211 "../lib/synapse-plugins/desktop-file-plugin.vala"
									synapse_result_set_add (results, (SynapseMatch*) _tmp63_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp64_, (gint) ((gintptr) _tmp67_)));
#line 212 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_g_object_unref0 (am);
#line 212 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_g_object_unref0 (matcher);
#line 212 "../lib/synapse-plugins/desktop-file-plugin.vala"
									break;
#line 1247 "desktop-file-plugin.c"
								} else {
									GMatchInfo* _tmp68_;
#line 213 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp68_ = info;
#line 213 "../lib/synapse-plugins/desktop-file-plugin.vala"
									if (g_match_info_is_partial_match (_tmp68_)) {
#line 1254 "desktop-file-plugin.c"
										SynapseDesktopFilePluginActionMatch* am = NULL;
										const gchar* _tmp69_;
										const gchar* _tmp70_;
										SynapseDesktopFilePluginActionMatch* _tmp71_;
										SynapseDesktopFilePluginActionMatch* _tmp72_;
										SynapseDesktopFilePluginDesktopFileMatch* _tmp73_;
#line 214 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp69_ = id;
#line 214 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp70_ = action;
#line 214 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp71_ = synapse_desktop_file_plugin_action_match_new (_tmp69_, _tmp70_);
#line 214 "../lib/synapse-plugins/desktop-file-plugin.vala"
										am = _tmp71_;
#line 215 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp72_ = am;
#line 215 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp73_ = dfm;
#line 215 "../lib/synapse-plugins/desktop-file-plugin.vala"
										synapse_result_set_add (results, (SynapseMatch*) _tmp72_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp73_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE));
#line 216 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_g_object_unref0 (am);
#line 216 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_g_object_unref0 (matcher);
#line 216 "../lib/synapse-plugins/desktop-file-plugin.vala"
										break;
#line 1281 "desktop-file-plugin.c"
									}
								}
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_g_object_unref0 (matcher);
#line 1286 "desktop-file-plugin.c"
							}
#line 208 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_g_object_unref0 (_matcher_list);
#line 1290 "desktop-file-plugin.c"
						}
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_g_free0 (title);
#line 200 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_g_free0 (action);
#line 1296 "desktop-file-plugin.c"
					}
				}
			}
#line 222 "../lib/synapse-plugins/desktop-file-plugin.vala"
			matched = FALSE;
#line 223 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp74_ = desktop_app_info;
#line 223 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp76_ = _tmp75_ = g_desktop_app_info_get_keywords (_tmp74_);
#line 223 "../lib/synapse-plugins/desktop-file-plugin.vala"
			keywords = _tmp76_;
#line 223 "../lib/synapse-plugins/desktop-file-plugin.vala"
			keywords_length1 = _vala_array_length (_tmp75_);
#line 223 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_keywords_size_ = keywords_length1;
#line 1312 "desktop-file-plugin.c"
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp77_;
				GeeList* _tmp78_;
				gint _matcher_size = 0;
				GeeList* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				gint _matcher_index = 0;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp77_ = matchers;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp78_ = _g_object_ref0 (_tmp77_);
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_matcher_list = _tmp78_;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp79_ = _matcher_list;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp80_ = gee_collection_get_size ((GeeCollection*) _tmp79_);
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp81_ = _tmp80_;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_matcher_size = _tmp81_;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_matcher_index = -1;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				while (TRUE) {
#line 1340 "desktop-file-plugin.c"
					gint _tmp82_;
					gint _tmp83_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp84_;
					gpointer _tmp85_;
					GeeMapEntry* _tmp86_;
					gconstpointer _tmp87_;
					gconstpointer _tmp88_;
					const gchar* _tmp89_;
					GMatchInfo* _tmp90_ = NULL;
					gboolean _tmp91_;
					gchar** _tmp111_;
					gint _tmp111__length1;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_matcher_index = _matcher_index + 1;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp82_ = _matcher_index;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp83_ = _matcher_size;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					if (!(_tmp82_ < _tmp83_)) {
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
						break;
#line 1364 "desktop-file-plugin.c"
					}
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp84_ = _matcher_list;
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp85_ = gee_list_get (_tmp84_, _matcher_index);
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					matcher = (GeeMapEntry*) _tmp85_;
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp86_ = matcher;
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp87_ = gee_map_entry_get_key (_tmp86_);
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp88_ = _tmp87_;
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp89_ = folded_title;
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp91_ = g_regex_match ((GRegex*) _tmp88_, _tmp89_, 0, &_tmp90_);
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_g_match_info_unref0 (info);
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					info = _tmp90_;
#line 228 "../lib/synapse-plugins/desktop-file-plugin.vala"
					if (_tmp91_) {
#line 1388 "desktop-file-plugin.c"
						SynapseDesktopFilePluginDesktopFileMatch* _tmp92_;
						SynapseDesktopFilePluginDesktopFileMatch* _tmp93_;
						GeeMapEntry* _tmp94_;
						gconstpointer _tmp95_;
						gconstpointer _tmp96_;
#line 229 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp92_ = dfm;
#line 229 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp93_ = dfm;
#line 229 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp94_ = matcher;
#line 229 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp95_ = gee_map_entry_get_value (_tmp94_);
#line 229 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp96_ = _tmp95_;
#line 229 "../lib/synapse-plugins/desktop-file-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp92_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp93_, (gint) ((gintptr) _tmp96_)));
#line 230 "../lib/synapse-plugins/desktop-file-plugin.vala"
						matched = TRUE;
#line 231 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_g_object_unref0 (matcher);
#line 231 "../lib/synapse-plugins/desktop-file-plugin.vala"
						break;
#line 1412 "desktop-file-plugin.c"
					} else {
						gboolean _tmp97_ = FALSE;
						const gchar* _tmp98_;
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp98_ = unaccented_title;
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
						if (_tmp98_ != NULL) {
#line 1420 "desktop-file-plugin.c"
							GeeMapEntry* _tmp99_;
							gconstpointer _tmp100_;
							gconstpointer _tmp101_;
							const gchar* _tmp102_;
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp99_ = matcher;
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp100_ = gee_map_entry_get_key (_tmp99_);
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp101_ = _tmp100_;
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp102_ = unaccented_title;
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp97_ = g_regex_match ((GRegex*) _tmp101_, _tmp102_, 0, NULL);
#line 1435 "desktop-file-plugin.c"
						} else {
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp97_ = FALSE;
#line 1439 "desktop-file-plugin.c"
						}
#line 232 "../lib/synapse-plugins/desktop-file-plugin.vala"
						if (_tmp97_) {
#line 1443 "desktop-file-plugin.c"
							SynapseDesktopFilePluginDesktopFileMatch* _tmp103_;
							SynapseDesktopFilePluginDesktopFileMatch* _tmp104_;
							GeeMapEntry* _tmp105_;
							gconstpointer _tmp106_;
							gconstpointer _tmp107_;
#line 233 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp103_ = dfm;
#line 233 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp104_ = dfm;
#line 233 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp105_ = matcher;
#line 233 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp106_ = gee_map_entry_get_value (_tmp105_);
#line 233 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp107_ = _tmp106_;
#line 233 "../lib/synapse-plugins/desktop-file-plugin.vala"
							synapse_result_set_add (results, (SynapseMatch*) _tmp103_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp104_, ((gint) ((gintptr) _tmp107_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
#line 234 "../lib/synapse-plugins/desktop-file-plugin.vala"
							matched = TRUE;
#line 235 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_g_object_unref0 (matcher);
#line 235 "../lib/synapse-plugins/desktop-file-plugin.vala"
							break;
#line 1467 "desktop-file-plugin.c"
						} else {
							GMatchInfo* _tmp108_;
#line 236 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp108_ = info;
#line 236 "../lib/synapse-plugins/desktop-file-plugin.vala"
							if (g_match_info_is_partial_match (_tmp108_)) {
#line 1474 "desktop-file-plugin.c"
								SynapseDesktopFilePluginDesktopFileMatch* _tmp109_;
								SynapseDesktopFilePluginDesktopFileMatch* _tmp110_;
#line 237 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp109_ = dfm;
#line 237 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp110_ = dfm;
#line 237 "../lib/synapse-plugins/desktop-file-plugin.vala"
								synapse_result_set_add (results, (SynapseMatch*) _tmp109_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp110_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE));
#line 238 "../lib/synapse-plugins/desktop-file-plugin.vala"
								matched = TRUE;
#line 239 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_g_object_unref0 (matcher);
#line 239 "../lib/synapse-plugins/desktop-file-plugin.vala"
								break;
#line 1489 "desktop-file-plugin.c"
							}
						}
					}
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp111_ = keywords;
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp111__length1 = keywords_length1;
#line 1497 "desktop-file-plugin.c"
					{
						gchar** keyword_collection = NULL;
						gint keyword_collection_length1 = 0;
						gint _keyword_collection_size_ = 0;
						gint keyword_it = 0;
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
						keyword_collection = _tmp111_;
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
						keyword_collection_length1 = _tmp111__length1;
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
						for (keyword_it = 0; keyword_it < keyword_collection_length1; keyword_it = keyword_it + 1) {
#line 1509 "desktop-file-plugin.c"
							gchar* _tmp112_;
							gchar* keyword = NULL;
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp112_ = g_strdup (keyword_collection[keyword_it]);
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
							keyword = _tmp112_;
#line 1516 "desktop-file-plugin.c"
							{
								const gchar* _tmp113_;
								gchar* _tmp114_;
								GeeMapEntry* _tmp115_;
								gconstpointer _tmp116_;
								gconstpointer _tmp117_;
								const gchar* _tmp118_;
								GMatchInfo* _tmp119_ = NULL;
								gboolean _tmp120_;
#line 243 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp113_ = keyword;
#line 243 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp114_ = g_utf8_strdown (_tmp113_, (gssize) -1);
#line 243 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_g_free0 (keyword);
#line 243 "../lib/synapse-plugins/desktop-file-plugin.vala"
								keyword = _tmp114_;
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp115_ = matcher;
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp116_ = gee_map_entry_get_key (_tmp115_);
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp117_ = _tmp116_;
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp118_ = keyword;
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_tmp120_ = g_regex_match ((GRegex*) _tmp117_, _tmp118_, 0, &_tmp119_);
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_g_match_info_unref0 (info);
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								info = _tmp119_;
#line 244 "../lib/synapse-plugins/desktop-file-plugin.vala"
								if (_tmp120_) {
#line 1550 "desktop-file-plugin.c"
									SynapseDesktopFilePluginDesktopFileMatch* _tmp121_;
									SynapseDesktopFilePluginDesktopFileMatch* _tmp122_;
									GeeMapEntry* _tmp123_;
									gconstpointer _tmp124_;
									gconstpointer _tmp125_;
#line 245 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp121_ = dfm;
#line 245 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp122_ = dfm;
#line 245 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp123_ = matcher;
#line 245 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp124_ = gee_map_entry_get_value (_tmp123_);
#line 245 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp125_ = _tmp124_;
#line 245 "../lib/synapse-plugins/desktop-file-plugin.vala"
									synapse_result_set_add (results, (SynapseMatch*) _tmp121_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp122_, ((gint) ((gintptr) _tmp125_)) - SYNAPSE_MATCH_SCORE_INCREMENT_LARGE));
#line 246 "../lib/synapse-plugins/desktop-file-plugin.vala"
									matched = TRUE;
#line 247 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_g_free0 (keyword);
#line 247 "../lib/synapse-plugins/desktop-file-plugin.vala"
									break;
#line 1574 "desktop-file-plugin.c"
								} else {
									GMatchInfo* _tmp126_;
#line 248 "../lib/synapse-plugins/desktop-file-plugin.vala"
									_tmp126_ = info;
#line 248 "../lib/synapse-plugins/desktop-file-plugin.vala"
									if (g_match_info_is_partial_match (_tmp126_)) {
#line 1581 "desktop-file-plugin.c"
										SynapseDesktopFilePluginDesktopFileMatch* _tmp127_;
										SynapseDesktopFilePluginDesktopFileMatch* _tmp128_;
#line 249 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp127_ = dfm;
#line 249 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_tmp128_ = dfm;
#line 249 "../lib/synapse-plugins/desktop-file-plugin.vala"
										synapse_result_set_add (results, (SynapseMatch*) _tmp127_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp128_, (gint) (SYNAPSE_MATCH_SCORE_POOR - SYNAPSE_MATCH_SCORE_INCREMENT_LARGE)));
#line 250 "../lib/synapse-plugins/desktop-file-plugin.vala"
										matched = TRUE;
#line 251 "../lib/synapse-plugins/desktop-file-plugin.vala"
										_g_free0 (keyword);
#line 251 "../lib/synapse-plugins/desktop-file-plugin.vala"
										break;
#line 1596 "desktop-file-plugin.c"
									}
								}
#line 242 "../lib/synapse-plugins/desktop-file-plugin.vala"
								_g_free0 (keyword);
#line 1601 "desktop-file-plugin.c"
							}
						}
					}
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_g_object_unref0 (matcher);
#line 1607 "desktop-file-plugin.c"
				}
#line 224 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_object_unref0 (_matcher_list);
#line 1611 "desktop-file-plugin.c"
			}
#line 256 "../lib/synapse-plugins/desktop-file-plugin.vala"
			if (matched) {
#line 257 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_match_info_unref0 (info);
#line 257 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_object_unref0 (desktop_app_info);
#line 257 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_free0 (id);
#line 257 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_object_unref0 (dfm);
#line 257 "../lib/synapse-plugins/desktop-file-plugin.vala"
				continue;
#line 1625 "desktop-file-plugin.c"
			}
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp130_ = comment;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp131_ = g_utf8_strdown (_tmp130_, (gssize) -1);
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp132_ = _tmp131_;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp133_ = *q;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp134_ = _tmp133_.query_string_folded;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp135_ = string_contains (_tmp132_, _tmp134_);
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_free0 (_tmp132_);
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			if (_tmp135_) {
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp129_ = TRUE;
#line 1645 "desktop-file-plugin.c"
			} else {
				const gchar* _tmp136_;
				gchar* _tmp137_;
				gchar* _tmp138_;
				SynapseQuery _tmp139_;
				const gchar* _tmp140_;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp136_ = generic_name;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp137_ = g_utf8_strdown (_tmp136_, (gssize) -1);
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp138_ = _tmp137_;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp139_ = *q;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp140_ = _tmp139_.query_string_folded;
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp129_ = string_contains (_tmp138_, _tmp140_);
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_free0 (_tmp138_);
#line 1666 "desktop-file-plugin.c"
			}
#line 260 "../lib/synapse-plugins/desktop-file-plugin.vala"
			if (_tmp129_) {
#line 1670 "desktop-file-plugin.c"
				SynapseDesktopFilePluginDesktopFileMatch* _tmp141_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp142_;
#line 261 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp141_ = dfm;
#line 261 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp142_ = dfm;
#line 261 "../lib/synapse-plugins/desktop-file-plugin.vala"
				synapse_result_set_add (results, (SynapseMatch*) _tmp141_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp142_, (gint) (SYNAPSE_MATCH_SCORE_BELOW_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM)));
#line 1679 "desktop-file-plugin.c"
			} else {
				SynapseDesktopFilePluginDesktopFileMatch* _tmp143_;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				SynapseQuery _tmp146_;
				const gchar* _tmp147_;
#line 262 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp143_ = dfm;
#line 262 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp144_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp143_);
#line 262 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp145_ = _tmp144_;
#line 262 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp146_ = *q;
#line 262 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp147_ = _tmp146_.query_string;
#line 262 "../lib/synapse-plugins/desktop-file-plugin.vala"
				if (g_str_has_prefix (_tmp145_, _tmp147_)) {
#line 1698 "desktop-file-plugin.c"
					SynapseMatchScore _tmp148_ = 0;
					SynapseDesktopFilePluginDesktopFileMatch* _tmp149_;
					const gchar* _tmp150_;
					const gchar* _tmp151_;
					SynapseQuery _tmp152_;
					const gchar* _tmp153_;
					SynapseDesktopFilePluginDesktopFileMatch* _tmp154_;
					SynapseDesktopFilePluginDesktopFileMatch* _tmp155_;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp149_ = dfm;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp150_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp149_);
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp151_ = _tmp150_;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp152_ = *q;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp153_ = _tmp152_.query_string;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					if (g_strcmp0 (_tmp151_, _tmp153_) == 0) {
#line 264 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp148_ = SYNAPSE_MATCH_SCORE_VERY_GOOD;
#line 1721 "desktop-file-plugin.c"
					} else {
#line 264 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp148_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 1725 "desktop-file-plugin.c"
					}
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp154_ = dfm;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp155_ = dfm;
#line 263 "../lib/synapse-plugins/desktop-file-plugin.vala"
					synapse_result_set_add (results, (SynapseMatch*) _tmp154_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp155_, (gint) _tmp148_));
#line 1733 "desktop-file-plugin.c"
				}
			}
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_match_info_unref0 (info);
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (desktop_app_info);
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_free0 (id);
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (dfm);
#line 1744 "desktop-file-plugin.c"
		}
#line 187 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (_dfm_list);
#line 1748 "desktop-file-plugin.c"
	}
#line 183 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (matchers);
#line 1752 "desktop-file-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 1773 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                SynapseQuery* q)
{
	SynapseDesktopFilePlugin * self;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result = FALSE;
#line 269 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 269 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (q != NULL, FALSE);
#line 271 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = *q;
#line 271 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 271 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (!((_tmp1_ & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
#line 272 "../lib/synapse-plugins/desktop-file-plugin.vala"
		result = FALSE;
#line 272 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return result;
#line 1803 "desktop-file-plugin.c"
	}
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = *q;
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = _tmp2_.query_string;
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp5_ = _tmp4_;
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp5_);
#line 274 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_tmp6_) {
#line 275 "../lib/synapse-plugins/desktop-file-plugin.vala"
		result = FALSE;
#line 275 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return result;
#line 1823 "desktop-file-plugin.c"
	}
#line 278 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = TRUE;
#line 278 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 1829 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_search_data_free (gpointer _data)
{
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = _data;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_slice_free (SynapseDesktopFilePluginSearchData, _data_);
#line 1845 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFilePlugin * self;
	SynapseDesktopFilePluginSearchData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_ = g_slice_new0 (SynapseDesktopFilePluginSearchData);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_real_search_data_free);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = *q;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_real_search_co (_data_);
#line 1884 "desktop-file-plugin.c"
}

static SynapseResultSet*
synapse_desktop_file_plugin_search_finish (SynapseItemProvider* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	SynapseResultSet* result;
	SynapseDesktopFilePluginSearchData* _data_;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (NULL == _data_) {
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return NULL;
#line 1900 "desktop-file-plugin.c"
	}
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _data_->result;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->result = NULL;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 1908 "desktop-file-plugin.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return _data1_;
#line 1918 "desktop-file-plugin.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1928 "desktop-file-plugin.c"
		SynapseDesktopFilePlugin* self;
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self = _data1_->self;
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self);
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_slice_free (Block1Data, _data1_);
#line 1936 "desktop-file-plugin.c"
	}
}

static void
___lambda4_ (Block1Data* _data1_)
{
	SynapseDesktopFilePlugin* self;
#line 284 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = _data1_->self;
#line 285 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_real_search_co (_data1_->_async_data_);
#line 1948 "desktop-file-plugin.c"
}

static void
____lambda4__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                        gpointer self)
{
#line 284 "../lib/synapse-plugins/desktop-file-plugin.vala"
	___lambda4_ (self);
#line 1957 "desktop-file-plugin.c"
}

static gboolean
_synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_real_search_co (self);
#line 293 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 1967 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_)
{
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (_data_->_state_) {
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case 0:
#line 1977 "desktop-file-plugin.c"
		goto _state_0;
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case 1:
#line 1981 "desktop-file-plugin.c"
		goto _state_1;
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case 2:
#line 1985 "desktop-file-plugin.c"
		goto _state_2;
		default:
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_assert_not_reached ();
#line 1990 "desktop-file-plugin.c"
	}
	_state_0:
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 281 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 282 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_data_->self->priv->loading_in_progress) {
#line 284 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp0_ = g_signal_connect_data (_data_->self, "load-complete", (GCallback) ____lambda4__synapse_desktop_file_plugin_load_complete, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
#line 284 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->signal_id = _data_->_tmp0_;
#line 287 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_state_ = 1;
#line 287 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return FALSE;
#line 2011 "desktop-file-plugin.c"
		_state_1:
		;
#line 288 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_signal_handler_disconnect (_data_->self, _data_->signal_id);
#line 2016 "desktop-file-plugin.c"
	} else {
#line 293 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, _synapse_desktop_file_plugin_real_search_co_gsource_func, _data_, NULL);
#line 294 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_state_ = 2;
#line 294 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return FALSE;
#line 2024 "desktop-file-plugin.c"
		_state_2:
		;
	}
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			return FALSE;
#line 2044 "desktop-file-plugin.c"
		} else {
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 297 "../lib/synapse-plugins/desktop-file-plugin.vala"
			return FALSE;
#line 2058 "desktop-file-plugin.c"
		}
	}
#line 300 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_tmp1_ = synapse_result_set_new ();
#line 300 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 303 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 303 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
#line 303 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_tmp4_ = strlen (_data_->_tmp3_);
#line 303 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 303 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_data_->_tmp5_ == 1) {
#line 304 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
#line 306 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp6_ = _data_->q;
#line 306 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp7_ = _data_->_result_;
#line 306 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp8_ = _data_->flags;
#line 306 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_);
#line 2085 "desktop-file-plugin.c"
	} else {
#line 308 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp9_ = _data_->q;
#line 308 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_data_->_tmp10_ = _data_->_result_;
#line 308 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp9_, _data_->_tmp10_, 0);
#line 2093 "desktop-file-plugin.c"
	}
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			return FALSE;
#line 2113 "desktop-file-plugin.c"
		} else {
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 311 "../lib/synapse-plugins/desktop-file-plugin.vala"
			return FALSE;
#line 2129 "desktop-file-plugin.c"
		}
	}
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->result = _data_->_result_;
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	block1_data_unref (_data_->_data1_);
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_data_->_data1_ = NULL;
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_data_->_state_ != 0) {
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2146 "desktop-file-plugin.c"
		}
	}
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 313 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return FALSE;
#line 2153 "desktop-file-plugin.c"
}

static SynapseResultSet*
synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                 SynapseQuery* query,
                                                 SynapseMatch* match)
{
	SynapseDesktopFilePlugin * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp2_;
	SynapseUriMatch* _tmp3_;
	SynapseUriMatch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeList* ow_list = NULL;
	GeeMap* _tmp7_;
	SynapseUriMatch* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gpointer _tmp11_;
	GeeList* _tmp12_;
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp44_;
	SynapseQuery _tmp45_;
	const gchar* _tmp46_;
	SynapseResultSet* result = NULL;
#line 357 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 357 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 357 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 358 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_match_get_match_type (match);
#line 358 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 358 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_tmp1_ != SYNAPSE_MATCH_TYPE_GENERIC_URI) {
#line 359 "../lib/synapse-plugins/desktop-file-plugin.vala"
		result = NULL;
#line 359 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return result;
#line 2198 "desktop-file-plugin.c"
	}
#line 362 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
#line 362 "../lib/synapse-plugins/desktop-file-plugin.vala"
	uri_match = _tmp2_;
#line 363 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = uri_match;
#line 363 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = uri_match;
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp5_ = synapse_uri_match_get_mime_type (_tmp4_);
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp6_ = _tmp5_;
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_tmp6_ == NULL) {
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
		result = NULL;
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (uri_match);
#line 365 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return result;
#line 2222 "desktop-file-plugin.c"
	}
#line 367 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp7_ = self->priv->mimetype_map;
#line 367 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp8_ = uri_match;
#line 367 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp9_ = synapse_uri_match_get_mime_type (_tmp8_);
#line 367 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp10_ = _tmp9_;
#line 367 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp11_ = gee_map_get (_tmp7_, _tmp10_);
#line 367 "../lib/synapse-plugins/desktop-file-plugin.vala"
	ow_list = (GeeList*) _tmp11_;
#line 369 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp12_ = ow_list;
#line 369 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_tmp12_ == NULL) {
#line 2240 "desktop-file-plugin.c"
		GeeLinkedList* _tmp13_;
		GeeMap* _tmp14_;
		SynapseUriMatch* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GeeList* _tmp18_;
		SynapseDesktopFileService* dfs = NULL;
		SynapseDesktopFileService* _tmp19_;
		GeeList* list_for_mimetype = NULL;
		SynapseDesktopFileService* _tmp20_;
		SynapseUriMatch* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GeeList* _tmp24_;
		GeeList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
#line 371 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp13_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 371 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (ow_list);
#line 371 "../lib/synapse-plugins/desktop-file-plugin.vala"
		ow_list = (GeeList*) _tmp13_;
#line 372 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp14_ = self->priv->mimetype_map;
#line 372 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp15_ = uri_match;
#line 372 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp16_ = synapse_uri_match_get_mime_type (_tmp15_);
#line 372 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp17_ = _tmp16_;
#line 372 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp18_ = ow_list;
#line 372 "../lib/synapse-plugins/desktop-file-plugin.vala"
		gee_map_set (_tmp14_, _tmp17_, _tmp18_);
#line 373 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp19_ = synapse_desktop_file_service_get_default ();
#line 373 "../lib/synapse-plugins/desktop-file-plugin.vala"
		dfs = _tmp19_;
#line 374 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp20_ = dfs;
#line 374 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp21_ = uri_match;
#line 374 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp22_ = synapse_uri_match_get_mime_type (_tmp21_);
#line 374 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp23_ = _tmp22_;
#line 374 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp24_ = synapse_desktop_file_service_get_desktop_files_for_type (_tmp20_, _tmp23_);
#line 374 "../lib/synapse-plugins/desktop-file-plugin.vala"
		list_for_mimetype = _tmp24_;
#line 376 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp25_ = list_for_mimetype;
#line 376 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
#line 376 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp27_ = _tmp26_;
#line 376 "../lib/synapse-plugins/desktop-file-plugin.vala"
		if (_tmp27_ > 1) {
#line 2300 "desktop-file-plugin.c"
			{
				GeeList* _entry_list = NULL;
				GeeList* _tmp28_;
				GeeList* _tmp29_;
				gint _entry_size = 0;
				GeeList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _entry_index = 0;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp28_ = list_for_mimetype;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp29_ = _g_object_ref0 (_tmp28_);
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_entry_list = _tmp29_;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp30_ = _entry_list;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp32_ = _tmp31_;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_entry_size = _tmp32_;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_entry_index = -1;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				while (TRUE) {
#line 2328 "desktop-file-plugin.c"
					gint _tmp33_;
					gint _tmp34_;
					SynapseDesktopFileInfo* entry = NULL;
					GeeList* _tmp35_;
					gpointer _tmp36_;
					GeeList* _tmp37_;
					SynapseDesktopFileInfo* _tmp38_;
					SynapseDesktopFilePluginOpenWithAction* _tmp39_;
					SynapseDesktopFilePluginOpenWithAction* _tmp40_;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_entry_index = _entry_index + 1;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp33_ = _entry_index;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp34_ = _entry_size;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					if (!(_tmp33_ < _tmp34_)) {
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
						break;
#line 2348 "desktop-file-plugin.c"
					}
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp35_ = _entry_list;
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp36_ = gee_list_get (_tmp35_, _entry_index);
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					entry = (SynapseDesktopFileInfo*) _tmp36_;
#line 378 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp37_ = ow_list;
#line 378 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp38_ = entry;
#line 378 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp39_ = synapse_desktop_file_plugin_open_with_action_new (_tmp38_);
#line 378 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp40_ = _tmp39_;
#line 378 "../lib/synapse-plugins/desktop-file-plugin.vala"
					gee_collection_add ((GeeCollection*) _tmp37_, _tmp40_);
#line 378 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_g_object_unref0 (_tmp40_);
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_g_object_unref0 (entry);
#line 2370 "desktop-file-plugin.c"
				}
#line 377 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_object_unref0 (_entry_list);
#line 2374 "desktop-file-plugin.c"
			}
		} else {
#line 381 "../lib/synapse-plugins/desktop-file-plugin.vala"
			result = NULL;
#line 381 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (list_for_mimetype);
#line 381 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (dfs);
#line 381 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (ow_list);
#line 381 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (uri_match);
#line 381 "../lib/synapse-plugins/desktop-file-plugin.vala"
			return result;
#line 2389 "desktop-file-plugin.c"
		}
#line 369 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (list_for_mimetype);
#line 369 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (dfs);
#line 2395 "desktop-file-plugin.c"
	} else {
		GeeList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
#line 382 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp41_ = ow_list;
#line 382 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
#line 382 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp43_ = _tmp42_;
#line 382 "../lib/synapse-plugins/desktop-file-plugin.vala"
		if (_tmp43_ == 0) {
#line 383 "../lib/synapse-plugins/desktop-file-plugin.vala"
			result = NULL;
#line 383 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (ow_list);
#line 383 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (uri_match);
#line 383 "../lib/synapse-plugins/desktop-file-plugin.vala"
			return result;
#line 2416 "desktop-file-plugin.c"
		}
	}
#line 386 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp44_ = synapse_result_set_new ();
#line 386 "../lib/synapse-plugins/desktop-file-plugin.vala"
	rs = _tmp44_;
#line 388 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp45_ = *query;
#line 388 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp46_ = _tmp45_.query_string;
#line 388 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (_tmp46_, "") == 0) {
#line 2429 "desktop-file-plugin.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp47_;
			GeeList* _tmp48_;
			gint _action_size = 0;
			GeeList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _action_index = 0;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp47_ = ow_list;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp48_ = _g_object_ref0 (_tmp47_);
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_action_list = _tmp48_;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp49_ = _action_list;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp51_ = _tmp50_;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_action_size = _tmp51_;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_action_index = -1;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			while (TRUE) {
#line 2457 "desktop-file-plugin.c"
				gint _tmp52_;
				gint _tmp53_;
				SynapseDesktopFilePluginOpenWithAction* action = NULL;
				GeeList* _tmp54_;
				gpointer _tmp55_;
				SynapseResultSet* _tmp56_;
				SynapseDesktopFilePluginOpenWithAction* _tmp57_;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_action_index = _action_index + 1;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp52_ = _action_index;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp53_ = _action_size;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				if (!(_tmp52_ < _tmp53_)) {
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
					break;
#line 2475 "desktop-file-plugin.c"
				}
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp54_ = _action_list;
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp55_ = gee_list_get (_tmp54_, _action_index);
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				action = (SynapseDesktopFilePluginOpenWithAction*) _tmp55_;
#line 390 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp56_ = rs;
#line 390 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp57_ = action;
#line 390 "../lib/synapse-plugins/desktop-file-plugin.vala"
				synapse_result_set_add (_tmp56_, (SynapseMatch*) _tmp57_, (gint) SYNAPSE_MATCH_SCORE_POOR);
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_object_unref0 (action);
#line 2491 "desktop-file-plugin.c"
			}
#line 389 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_action_list);
#line 2495 "desktop-file-plugin.c"
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp58_;
		const gchar* _tmp59_;
		GeeList* _tmp60_;
#line 393 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp58_ = *query;
#line 393 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp59_ = _tmp58_.query_string;
#line 393 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp60_ = synapse_query_get_matchers_for_query (_tmp59_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 393 "../lib/synapse-plugins/desktop-file-plugin.vala"
		matchers = _tmp60_;
#line 2510 "desktop-file-plugin.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp61_;
			GeeList* _tmp62_;
			gint _action_size = 0;
			GeeList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gint _action_index = 0;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp61_ = ow_list;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp62_ = _g_object_ref0 (_tmp61_);
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_action_list = _tmp62_;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp63_ = _action_list;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_tmp65_ = _tmp64_;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_action_size = _tmp65_;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_action_index = -1;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			while (TRUE) {
#line 2538 "desktop-file-plugin.c"
				gint _tmp66_;
				gint _tmp67_;
				SynapseDesktopFilePluginOpenWithAction* action = NULL;
				GeeList* _tmp68_;
				gpointer _tmp69_;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_action_index = _action_index + 1;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp66_ = _action_index;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp67_ = _action_size;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				if (!(_tmp66_ < _tmp67_)) {
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
					break;
#line 2554 "desktop-file-plugin.c"
				}
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp68_ = _action_list;
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp69_ = gee_list_get (_tmp68_, _action_index);
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				action = (SynapseDesktopFilePluginOpenWithAction*) _tmp69_;
#line 2562 "desktop-file-plugin.c"
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp70_;
					GeeList* _tmp71_;
					gint _matcher_size = 0;
					GeeList* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					gint _matcher_index = 0;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp70_ = matchers;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp71_ = _g_object_ref0 (_tmp70_);
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_matcher_list = _tmp71_;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp72_ = _matcher_list;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp73_ = gee_collection_get_size ((GeeCollection*) _tmp72_);
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_tmp74_ = _tmp73_;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_matcher_size = _tmp74_;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_matcher_index = -1;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					while (TRUE) {
#line 2590 "desktop-file-plugin.c"
						gint _tmp75_;
						gint _tmp76_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp77_;
						gpointer _tmp78_;
						GeeMapEntry* _tmp79_;
						gconstpointer _tmp80_;
						gconstpointer _tmp81_;
						SynapseDesktopFilePluginOpenWithAction* _tmp82_;
						const gchar* _tmp83_;
						const gchar* _tmp84_;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_matcher_index = _matcher_index + 1;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp75_ = _matcher_index;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp76_ = _matcher_size;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						if (!(_tmp75_ < _tmp76_)) {
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
							break;
#line 2612 "desktop-file-plugin.c"
						}
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp77_ = _matcher_list;
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp78_ = gee_list_get (_tmp77_, _matcher_index);
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						matcher = (GeeMapEntry*) _tmp78_;
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp79_ = matcher;
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp80_ = gee_map_entry_get_key (_tmp79_);
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp81_ = _tmp80_;
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp82_ = action;
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp83_ = synapse_match_get_title ((SynapseMatch*) _tmp82_);
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_tmp84_ = _tmp83_;
#line 396 "../lib/synapse-plugins/desktop-file-plugin.vala"
						if (g_regex_match ((GRegex*) _tmp81_, _tmp84_, 0, NULL)) {
#line 2634 "desktop-file-plugin.c"
							SynapseResultSet* _tmp85_;
							SynapseDesktopFilePluginOpenWithAction* _tmp86_;
							GeeMapEntry* _tmp87_;
							gconstpointer _tmp88_;
							gconstpointer _tmp89_;
#line 397 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp85_ = rs;
#line 397 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp86_ = action;
#line 397 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp87_ = matcher;
#line 397 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp88_ = gee_map_entry_get_value (_tmp87_);
#line 397 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_tmp89_ = _tmp88_;
#line 397 "../lib/synapse-plugins/desktop-file-plugin.vala"
							synapse_result_set_add (_tmp85_, (SynapseMatch*) _tmp86_, (gint) ((gintptr) _tmp89_));
#line 398 "../lib/synapse-plugins/desktop-file-plugin.vala"
							_g_object_unref0 (matcher);
#line 398 "../lib/synapse-plugins/desktop-file-plugin.vala"
							break;
#line 2656 "desktop-file-plugin.c"
						}
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
						_g_object_unref0 (matcher);
#line 2660 "desktop-file-plugin.c"
					}
#line 395 "../lib/synapse-plugins/desktop-file-plugin.vala"
					_g_object_unref0 (_matcher_list);
#line 2664 "desktop-file-plugin.c"
				}
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_object_unref0 (action);
#line 2668 "desktop-file-plugin.c"
			}
#line 394 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_action_list);
#line 2672 "desktop-file-plugin.c"
		}
#line 388 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (matchers);
#line 2676 "desktop-file-plugin.c"
	}
#line 404 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = rs;
#line 404 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (ow_list);
#line 404 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (uri_match);
#line 404 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 2686 "desktop-file-plugin.c"
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_construct (GType object_type)
{
	SynapseDesktopFilePlugin * self = NULL;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) g_object_new (object_type, NULL);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return self;
#line 2697 "desktop-file-plugin.c"
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_new (void)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_construct (SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN);
#line 2705 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDesktopFilePlugin* self;
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = self->priv->_enabled;
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 2719 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_set_enabled (SynapseActivatable* base,
                                              gboolean value)
{
	SynapseDesktopFilePlugin* self;
	gboolean old_value;
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_real_get_enabled (base);
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_enabled = value;
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY]);
#line 2738 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_action_match_get_instance_private (SynapseDesktopFilePluginActionMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginActionMatch_private_offset);
}

SynapseDesktopFilePluginActionMatch*
synapse_desktop_file_plugin_action_match_construct (GType object_type,
                                                    const gchar* desktop_id,
                                                    const gchar* action_name)
{
	SynapseDesktopFilePluginActionMatch * self = NULL;
	GDesktopAppInfo* desktop_app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	gchar* textdomain = NULL;
	GDesktopAppInfo* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GDesktopAppInfo* _tmp12_;
	GIcon* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GDesktopAppInfo* _tmp16_;
	gchar* _tmp17_;
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (action_name != NULL, NULL);
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) g_object_new (object_type, NULL);
#line 47 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = g_desktop_app_info_new (desktop_id);
#line 47 "../lib/synapse-plugins/desktop-file-plugin.vala"
	desktop_app_info = _tmp0_;
#line 48 "../lib/synapse-plugins/desktop-file-plugin.vala"
	textdomain = NULL;
#line 2779 "desktop-file-plugin.c"
	{
		const gchar** domain_key_collection = NULL;
		gint domain_key_collection_length1 = 0;
		gint _domain_key_collection_size_ = 0;
		gint domain_key_it = 0;
#line 50 "../lib/synapse-plugins/desktop-file-plugin.vala"
		domain_key_collection = SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_SUPPORTED_GETTEXT_DOMAINS_KEYS;
#line 50 "../lib/synapse-plugins/desktop-file-plugin.vala"
		domain_key_collection_length1 = G_N_ELEMENTS (SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_SUPPORTED_GETTEXT_DOMAINS_KEYS);
#line 50 "../lib/synapse-plugins/desktop-file-plugin.vala"
		for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
#line 2791 "desktop-file-plugin.c"
			const gchar* domain_key = NULL;
#line 50 "../lib/synapse-plugins/desktop-file-plugin.vala"
			domain_key = domain_key_collection[domain_key_it];
#line 2795 "desktop-file-plugin.c"
			{
				GDesktopAppInfo* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
#line 51 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp1_ = desktop_app_info;
#line 51 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp2_ = domain_key;
#line 51 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp3_ = g_desktop_app_info_get_string (_tmp1_, _tmp2_);
#line 51 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_g_free0 (textdomain);
#line 51 "../lib/synapse-plugins/desktop-file-plugin.vala"
				textdomain = _tmp3_;
#line 52 "../lib/synapse-plugins/desktop-file-plugin.vala"
				_tmp4_ = textdomain;
#line 52 "../lib/synapse-plugins/desktop-file-plugin.vala"
				if (_tmp4_ != NULL) {
#line 53 "../lib/synapse-plugins/desktop-file-plugin.vala"
					break;
#line 2817 "desktop-file-plugin.c"
				}
			}
		}
	}
#line 57 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp5_ = desktop_app_info;
#line 57 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp6_ = g_desktop_app_info_get_action_name (_tmp5_, action_name);
#line 57 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp7_ = _tmp6_;
#line 57 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp7_);
#line 57 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp7_);
#line 58 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp8_ = textdomain;
#line 58 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_tmp8_ != NULL) {
#line 2836 "desktop-file-plugin.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
#line 59 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp9_ = textdomain;
#line 59 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp10_ = synapse_match_get_title ((SynapseMatch*) self);
#line 59 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp11_ = _tmp10_;
#line 59 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_dgettext (_tmp9_, _tmp11_));
#line 2848 "desktop-file-plugin.c"
	}
#line 62 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp12_ = desktop_app_info;
#line 62 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp13_ = g_app_info_get_icon ((GAppInfo*) _tmp12_);
#line 62 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp14_ = g_icon_to_string (_tmp13_);
#line 62 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp15_ = _tmp14_;
#line 62 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp15_);
#line 62 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp15_);
#line 63 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, "");
#line 64 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp16_ = desktop_app_info;
#line 64 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_action_match_set_app_info (self, (GAppInfo*) _tmp16_);
#line 65 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp17_ = g_strdup (action_name);
#line 65 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->action_name);
#line 65 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->action_name = _tmp17_;
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (textdomain);
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (desktop_app_info);
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return self;
#line 2880 "desktop-file-plugin.c"
}

SynapseDesktopFilePluginActionMatch*
synapse_desktop_file_plugin_action_match_new (const gchar* desktop_id,
                                              const gchar* action_name)
{
#line 46 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_action_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, desktop_id, action_name);
#line 2889 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_execute (SynapseMatch* base,
                                                       SynapseMatch* match)
{
	SynapseDesktopFilePluginActionMatch * self;
	GAppInfo* _tmp0_;
	const gchar* _tmp1_;
	GAppLaunchContext* _tmp2_;
	GAppLaunchContext* _tmp3_;
#line 68 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 69 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_app_info;
#line 69 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = self->priv->action_name;
#line 69 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = g_app_launch_context_new ();
#line 69 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = _tmp2_;
#line 69 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_desktop_app_info_launch_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo), _tmp1_, _tmp3_);
#line 69 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_tmp3_);
#line 2915 "desktop-file-plugin.c"
}

static const gchar*
synapse_desktop_file_plugin_action_match_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 2932 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_set_title (SynapseMatch* base,
                                                         const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	gchar* old_value;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_real_get_title (base);
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2947 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_title);
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_title = _tmp0_;
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY]);
#line 2957 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_action_match_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_icon_name;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 2975 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_set_icon_name (SynapseMatch* base,
                                                             const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	gchar* old_value;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_real_get_icon_name (base);
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2990 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_icon_name);
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_icon_name = _tmp0_;
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY]);
#line 3000 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_action_match_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_description;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3018 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_set_description (SynapseMatch* base,
                                                               const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	gchar* old_value;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_real_get_description (base);
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3033 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_description);
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_description = _tmp0_;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY]);
#line 3043 "desktop-file-plugin.c"
	}
}

static gboolean
synapse_desktop_file_plugin_action_match_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginActionMatch* self;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = self->priv->_has_thumbnail;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3058 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_set_has_thumbnail (SynapseMatch* base,
                                                                 gboolean value)
{
	SynapseDesktopFilePluginActionMatch* self;
	gboolean old_value;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_real_get_has_thumbnail (base);
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_has_thumbnail = value;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY]);
#line 3077 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_action_match_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginActionMatch* self;
	const gchar* _tmp0_;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3095 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_set_thumbnail_path (SynapseMatch* base,
                                                                  const gchar* value)
{
	SynapseDesktopFilePluginActionMatch* self;
	gchar* old_value;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_real_get_thumbnail_path (base);
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3110 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY]);
#line 3120 "desktop-file-plugin.c"
	}
}

static SynapseMatchType
synapse_desktop_file_plugin_action_match_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDesktopFilePluginActionMatch* self;
	SynapseMatchType _tmp0_;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_match_type;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3138 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_real_set_match_type (SynapseMatch* base,
                                                              SynapseMatchType value)
{
	SynapseDesktopFilePluginActionMatch* self;
	SynapseMatchType old_value;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginActionMatch*) base;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_real_get_match_type (base);
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_match_type = value;
#line 37 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY]);
#line 3157 "desktop-file-plugin.c"
	}
}

const gchar*
synapse_desktop_file_plugin_action_match_get_filename (SynapseDesktopFilePluginActionMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_filename;
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3174 "desktop-file-plugin.c"
}

void
synapse_desktop_file_plugin_action_match_set_filename (SynapseDesktopFilePluginActionMatch* self,
                                                       const gchar* value)
{
	gchar* old_value;
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_get_filename (self);
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3188 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_filename);
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_filename = _tmp0_;
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY]);
#line 3198 "desktop-file-plugin.c"
	}
}

GAppInfo*
synapse_desktop_file_plugin_action_match_get_app_info (SynapseDesktopFilePluginActionMatch* self)
{
	GAppInfo* result;
	GAppInfo* _tmp0_;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_app_info;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3215 "desktop-file-plugin.c"
}

void
synapse_desktop_file_plugin_action_match_set_app_info (SynapseDesktopFilePluginActionMatch* self,
                                                       GAppInfo* value)
{
	GAppInfo* old_value;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_get_app_info (self);
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 3229 "desktop-file-plugin.c"
		GAppInfo* _tmp0_;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_app_info);
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_app_info = _tmp0_;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY]);
#line 3239 "desktop-file-plugin.c"
	}
}

gboolean
synapse_desktop_file_plugin_action_match_get_needs_terminal (SynapseDesktopFilePluginActionMatch* self)
{
	gboolean result;
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = self->priv->_needs_terminal;
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3253 "desktop-file-plugin.c"
}

void
synapse_desktop_file_plugin_action_match_set_needs_terminal (SynapseDesktopFilePluginActionMatch* self,
                                                             gboolean value)
{
	gboolean old_value;
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_action_match_get_needs_terminal (self);
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_needs_terminal = value;
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY]);
#line 3271 "desktop-file-plugin.c"
	}
}

static void
synapse_desktop_file_plugin_action_match_class_init (SynapseDesktopFilePluginActionMatchClass * klass,
                                                     gpointer klass_data)
{
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_action_match_parent_class = g_type_class_peek_parent (klass);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginActionMatch_private_offset);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_action_match_get_property;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_action_match_set_property;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_action_match_finalize;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_plugin_action_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3307 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_synapse_match_interface_init (SynapseMatchIface * iface,
                                                                       gpointer iface_data)
{
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_action_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_action_match_real_execute;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_title = synapse_desktop_file_plugin_action_match_real_get_title;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_title = synapse_desktop_file_plugin_action_match_real_set_title;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_icon_name = synapse_desktop_file_plugin_action_match_real_get_icon_name;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_icon_name = synapse_desktop_file_plugin_action_match_real_set_icon_name;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_description = synapse_desktop_file_plugin_action_match_real_get_description;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_description = synapse_desktop_file_plugin_action_match_real_set_description;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_has_thumbnail = synapse_desktop_file_plugin_action_match_real_get_has_thumbnail;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_has_thumbnail = synapse_desktop_file_plugin_action_match_real_set_has_thumbnail;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_thumbnail_path = synapse_desktop_file_plugin_action_match_real_get_thumbnail_path;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_thumbnail_path = synapse_desktop_file_plugin_action_match_real_set_thumbnail_path;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_match_type = synapse_desktop_file_plugin_action_match_real_get_match_type;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_match_type = synapse_desktop_file_plugin_action_match_real_set_match_type;
#line 3342 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_instance_init (SynapseDesktopFilePluginActionMatch * self,
                                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_action_match_get_instance_private (self);
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = g_strdup ("");
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_icon_name = _tmp0_;
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = g_strdup ("");
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_description = _tmp1_;
#line 35 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_has_thumbnail = FALSE;
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_app_info = NULL;
#line 41 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_needs_terminal = FALSE;
#line 3367 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_action_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginActionMatch * self;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
#line 32 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_title);
#line 33 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_icon_name);
#line 34 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_description);
#line 36 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 38 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_filename);
#line 40 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_app_info);
#line 44 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->action_name);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_action_match_parent_class)->finalize (obj);
#line 3392 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_action_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginActionMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_action_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginActionMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_action_match_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_action_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_desktop_file_plugin_action_match_type_id;
	synapse_desktop_file_plugin_action_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginActionMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_desktop_file_plugin_action_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	SynapseDesktopFilePluginActionMatch_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_action_match_type_id, sizeof (SynapseDesktopFilePluginActionMatchPrivate));
	return synapse_desktop_file_plugin_action_match_type_id;
}

GType
synapse_desktop_file_plugin_action_match_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_action_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_action_match_type_id__volatile)) {
		GType synapse_desktop_file_plugin_action_match_type_id;
		synapse_desktop_file_plugin_action_match_type_id = synapse_desktop_file_plugin_action_match_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_action_match_type_id__volatile, synapse_desktop_file_plugin_action_match_type_id);
	}
	return synapse_desktop_file_plugin_action_match_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_action_match_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_action_match_get_filename (self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_action_match_get_app_info (self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_desktop_file_plugin_action_match_get_needs_terminal (self));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 3483 "desktop-file-plugin.c"
		default:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 3489 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_action_match_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	SynapseDesktopFilePluginActionMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_ACTION_MATCH, SynapseDesktopFilePluginActionMatch);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_TITLE_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_ICON_NAME_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_DESCRIPTION_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_MATCH_TYPE_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_FILENAME_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_action_match_set_filename (self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_APP_INFO_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_action_match_set_app_info (self, g_value_get_object (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ACTION_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_action_match_set_needs_terminal (self, g_value_get_boolean (value));
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 3557 "desktop-file-plugin.c"
		default:
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 3563 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_desktop_file_match_get_instance_private (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginDesktopFileMatch_private_offset);
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result = NULL;
#line 92 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->title_folded;
#line 93 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (_tmp0_ == NULL) {
#line 3585 "desktop-file-plugin.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 94 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp1_ = synapse_match_get_title ((SynapseMatch*) self);
#line 94 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp2_ = _tmp1_;
#line 94 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
#line 94 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->title_folded);
#line 94 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->title_folded = _tmp3_;
#line 3599 "desktop-file-plugin.c"
	}
#line 97 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = self->priv->title_folded;
#line 97 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp4_;
#line 97 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3607 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct_for_info (GType object_type,
                                                                   SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 105 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 106 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_desktop_file_info_get_filename (info);
#line 106 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 106 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, "filename", _tmp1_, "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, NULL);
#line 107 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_init_from_info (self, info);
#line 105 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return self;
#line 3629 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new_for_info (SynapseDesktopFileInfo* info)
{
#line 105 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_desktop_file_match_construct_for_info (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, info);
#line 3637 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_init_from_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               SynapseDesktopFileInfo* info)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
#line 110 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 110 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (info != NULL);
#line 111 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_desktop_file_info_get_name (info);
#line 111 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 111 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp1_);
#line 112 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = synapse_desktop_file_info_get_comment (info);
#line 112 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = _tmp2_;
#line 112 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp3_);
#line 113 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
#line 113 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp5_ = _tmp4_;
#line 113 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
#line 114 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp6_ = synapse_desktop_file_info_get_exec (info);
#line 114 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp7_ = _tmp6_;
#line 114 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_exec (self, _tmp7_);
#line 115 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp8_ = synapse_desktop_file_info_get_needs_terminal (info);
#line 115 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp9_ = _tmp8_;
#line 115 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp9_);
#line 116 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp10_ = synapse_desktop_file_info_get_name_folded (info);
#line 116 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 116 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->title_folded);
#line 116 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->title_folded = _tmp11_;
#line 117 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp12_ = self->priv->title_folded;
#line 117 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp13_ = synapse_utils_remove_accents (_tmp12_);
#line 117 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp14_ = _tmp13_;
#line 117 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, _tmp14_);
#line 117 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp14_);
#line 118 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp15_ = synapse_desktop_file_info_get_desktop_id (info);
#line 118 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp16_ = _tmp15_;
#line 118 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp17_ = g_strconcat ("application://", _tmp16_, NULL);
#line 118 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp18_ = _tmp17_;
#line 118 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, _tmp18_);
#line 118 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp18_);
#line 119 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp19_ = synapse_desktop_file_info_get_generic_name (info);
#line 119 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp20_ = _tmp19_;
#line 119 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_generic_name (self, _tmp20_);
#line 120 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp21_ = synapse_desktop_file_info_get_gettext_domain (info);
#line 120 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp22_ = _tmp21_;
#line 120 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (self, _tmp22_);
#line 3743 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, NULL);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return self;
#line 3754 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new (void)
{
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_desktop_file_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH);
#line 3762 "desktop-file-plugin.c"
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3779 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_title (SynapseMatch* base,
                                                               const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* old_value;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_title (base);
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3794 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_title);
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_title = _tmp0_;
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY]);
#line 3804 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_description;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3822 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_description (SynapseMatch* base,
                                                                     const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* old_value;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_description (base);
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3837 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_description);
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_description = _tmp0_;
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY]);
#line 3847 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_gettext_domain;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3864 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                   const gchar* value)
{
	gchar* old_value;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (self);
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3878 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_gettext_domain);
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_gettext_domain = _tmp0_;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY]);
#line 3888 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_icon_name;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3906 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_icon_name (SynapseMatch* base,
                                                                   const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* old_value;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name (base);
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3921 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_icon_name);
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_icon_name = _tmp0_;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY]);
#line 3931 "desktop-file-plugin.c"
	}
}

static gboolean
synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = self->priv->_has_thumbnail;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3946 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_has_thumbnail (SynapseMatch* base,
                                                                       gboolean value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gboolean old_value;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail (base);
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_has_thumbnail = value;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY]);
#line 3965 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 3983 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_thumbnail_path (SynapseMatch* base,
                                                                        const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* old_value;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path (base);
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3998 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY]);
#line 4008 "desktop-file-plugin.c"
	}
}

static SynapseMatchType
synapse_desktop_file_plugin_desktop_file_match_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	SynapseMatchType _tmp0_;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_match_type;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4026 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_match_type (SynapseMatch* base,
                                                                    SynapseMatchType value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	SynapseMatchType old_value;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_match_type (base);
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_match_type = value;
#line 81 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY]);
#line 4045 "desktop-file-plugin.c"
	}
}

static GAppInfo*
synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (SynapseApplicationMatch* base)
{
	GAppInfo* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	GAppInfo* _tmp0_;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_app_info;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4063 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_app_info (SynapseApplicationMatch* base,
                                                                  GAppInfo* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	GAppInfo* old_value;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_app_info (base);
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 4078 "desktop-file-plugin.c"
		GAppInfo* _tmp0_;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_app_info);
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_app_info = _tmp0_;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY]);
#line 4088 "desktop-file-plugin.c"
	}
}

static gboolean
synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (SynapseApplicationMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = self->priv->_needs_terminal;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4103 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal (SynapseApplicationMatch* base,
                                                                        gboolean value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gboolean old_value;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal (base);
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_needs_terminal = value;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY]);
#line 4122 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_real_get_filename (SynapseApplicationMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginDesktopFileMatch* self;
	const gchar* _tmp0_;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_filename;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4140 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_real_set_filename (SynapseApplicationMatch* base,
                                                                  const gchar* value)
{
	SynapseDesktopFilePluginDesktopFileMatch* self;
	gchar* old_value;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) base;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_real_get_filename (base);
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4155 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_filename);
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_filename = _tmp0_;
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY]);
#line 4165 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_generic_name;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4182 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_generic_name (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 const gchar* value)
{
	gchar* old_value;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_generic_name (self);
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4196 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_generic_name);
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_generic_name = _tmp0_;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY]);
#line 4206 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title_unaccented;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4223 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                     const gchar* value)
{
	gchar* old_value;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self);
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4237 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_title_unaccented);
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_title_unaccented = _tmp0_;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY]);
#line 4247 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4264 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               const gchar* value)
{
	gchar* old_value;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self);
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4278 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_desktop_id);
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_desktop_id = _tmp0_;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY]);
#line 4288 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_exec;
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4305 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                         const gchar* value)
{
	gchar* old_value;
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_exec (self);
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4319 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_exec);
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_exec = _tmp0_;
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY]);
#line 4329 "desktop-file-plugin.c"
	}
}

static void
synapse_desktop_file_plugin_desktop_file_match_class_init (SynapseDesktopFilePluginDesktopFileMatchClass * klass,
                                                           gpointer klass_data)
{
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_parent_class = g_type_class_peek_parent (klass);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginDesktopFileMatch_private_offset);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_desktop_file_match_get_property;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_desktop_file_match_set_property;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_desktop_file_match_finalize;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY] = g_param_spec_string ("gettext-domain", "gettext-domain", "gettext-domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY] = g_param_spec_string ("title-unaccented", "title-unaccented", "title-unaccented", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4375 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_synapse_match_interface_init (SynapseMatchIface * iface,
                                                                             gpointer iface_data)
{
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_title = synapse_desktop_file_plugin_desktop_file_match_real_get_title;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_title = synapse_desktop_file_plugin_desktop_file_match_real_set_title;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_description = synapse_desktop_file_plugin_desktop_file_match_real_get_description;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_description = synapse_desktop_file_plugin_desktop_file_match_real_set_description;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_icon_name = synapse_desktop_file_plugin_desktop_file_match_real_get_icon_name;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_icon_name = synapse_desktop_file_plugin_desktop_file_match_real_set_icon_name;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_has_thumbnail = synapse_desktop_file_plugin_desktop_file_match_real_get_has_thumbnail;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_has_thumbnail = synapse_desktop_file_plugin_desktop_file_match_real_set_has_thumbnail;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_thumbnail_path = synapse_desktop_file_plugin_desktop_file_match_real_get_thumbnail_path;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_thumbnail_path = synapse_desktop_file_plugin_desktop_file_match_real_set_thumbnail_path;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_match_type = synapse_desktop_file_plugin_desktop_file_match_real_get_match_type;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_match_type = synapse_desktop_file_plugin_desktop_file_match_real_set_match_type;
#line 4408 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface,
                                                                                         gpointer iface_data)
{
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_app_info = synapse_desktop_file_plugin_desktop_file_match_real_get_app_info;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_app_info = synapse_desktop_file_plugin_desktop_file_match_real_set_app_info;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_get_needs_terminal;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_needs_terminal = synapse_desktop_file_plugin_desktop_file_match_real_set_needs_terminal;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_filename = synapse_desktop_file_plugin_desktop_file_match_real_get_filename;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_filename = synapse_desktop_file_plugin_desktop_file_match_real_set_filename;
#line 4429 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_instance_init (SynapseDesktopFilePluginDesktopFileMatch * self,
                                                              gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_desktop_file_match_get_instance_private (self);
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = g_strdup ("");
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_description = _tmp0_;
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_gettext_domain = NULL;
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = g_strdup ("");
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_icon_name = _tmp1_;
#line 79 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_has_thumbnail = FALSE;
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_app_info = NULL;
#line 85 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_needs_terminal = FALSE;
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = g_strdup ("");
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_generic_name = _tmp2_;
#line 91 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->title_folded = NULL;
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_title_unaccented = NULL;
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_desktop_id = NULL;
#line 4467 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 75 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_title);
#line 76 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_description);
#line 77 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_gettext_domain);
#line 78 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_icon_name);
#line 80 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 84 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_app_info);
#line 86 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_filename);
#line 89 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_generic_name);
#line 91 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->title_folded);
#line 100 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_title_unaccented);
#line 101 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_desktop_id);
#line 103 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_exec);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class)->finalize (obj);
#line 4502 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_desktop_file_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginDesktopFileMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_desktop_file_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginDesktopFileMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_desktop_file_match_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_desktop_file_match_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_desktop_file_plugin_desktop_file_match_type_id;
	synapse_desktop_file_plugin_desktop_file_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginDesktopFileMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_desktop_file_match_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
	SynapseDesktopFilePluginDesktopFileMatch_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_desktop_file_match_type_id, sizeof (SynapseDesktopFilePluginDesktopFileMatchPrivate));
	return synapse_desktop_file_plugin_desktop_file_match_type_id;
}

static GType
synapse_desktop_file_plugin_desktop_file_match_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_desktop_file_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile)) {
		GType synapse_desktop_file_plugin_desktop_file_match_type_id;
		synapse_desktop_file_plugin_desktop_file_match_type_id = synapse_desktop_file_plugin_desktop_file_match_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile, synapse_desktop_file_plugin_desktop_file_match_type_id);
	}
	return synapse_desktop_file_plugin_desktop_file_match_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_gettext_domain (self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_generic_name (self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 4625 "desktop-file-plugin.c"
		default:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 4631 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESCRIPTION_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GETTEXT_DOMAIN_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_gettext_domain (self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_ICON_NAME_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_MATCH_TYPE_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_APP_INFO_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_FILENAME_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GENERIC_NAME_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_generic_name (self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_exec (self, g_value_get_string (value));
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 4729 "desktop-file-plugin.c"
		default:
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 73 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 4735 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_open_with_action_get_instance_private (SynapseDesktopFilePluginOpenWithAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenWithAction_private_offset);
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                        SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginOpenWithAction * self = NULL;
#line 327 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 328 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) g_object_new (object_type, NULL);
#line 329 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_with_action_init_with_info (self, info);
#line 327 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return self;
#line 4758 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info)
{
#line 327 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_open_with_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, info);
#line 4766 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_init_with_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                             SynapseDesktopFileInfo* info)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 332 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 332 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (info != NULL);
#line 333 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_desktop_file_info_get_name (info);
#line 333 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 333 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = g_strdup_printf (_ ("Open with %s"), _tmp1_);
#line 333 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = _tmp2_;
#line 333 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp3_);
#line 333 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp3_);
#line 334 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = synapse_desktop_file_info_get_icon_name (info);
#line 334 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp5_ = _tmp4_;
#line 334 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp5_);
#line 335 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp6_ = synapse_desktop_file_info_get_name (info);
#line 335 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp7_ = _tmp6_;
#line 335 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp8_ = g_strdup_printf (_ ("Opens current selection using %s"), _tmp7_);
#line 335 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp9_ = _tmp8_;
#line 335 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp9_);
#line 335 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp9_);
#line 336 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, info);
#line 4819 "desktop-file-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 4827 "desktop-file-plugin.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 4835 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_execute (SynapseMatch* base,
                                                           SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
#line 339 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 340 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL);
#line 340 "../lib/synapse-plugins/desktop-file-plugin.vala"
	uri_match = _tmp0_;
#line 341 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (uri_match != NULL);
#line 343 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = synapse_uri_match_get_uri (uri_match);
#line 343 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 343 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = g_file_new_for_uri (_tmp2_);
#line 343 "../lib/synapse-plugins/desktop-file-plugin.vala"
	f = _tmp3_;
#line 4866 "desktop-file-plugin.c"
	{
		GDesktopAppInfo* app_info = NULL;
		SynapseDesktopFileInfo* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GDesktopAppInfo* _tmp7_;
		GList* files = NULL;
		GFile* _tmp8_;
		GdkDisplay* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
		GdkAppLaunchContext* _tmp11_;
#line 345 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp4_ = self->priv->_desktop_info;
#line 345 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp5_ = synapse_desktop_file_info_get_filename (_tmp4_);
#line 345 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp6_ = _tmp5_;
#line 345 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp7_ = g_desktop_app_info_new_from_filename (_tmp6_);
#line 345 "../lib/synapse-plugins/desktop-file-plugin.vala"
		app_info = _tmp7_;
#line 346 "../lib/synapse-plugins/desktop-file-plugin.vala"
		files = NULL;
#line 347 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp8_ = _g_object_ref0 (f);
#line 347 "../lib/synapse-plugins/desktop-file-plugin.vala"
		files = g_list_prepend (files, _tmp8_);
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp9_ = gdk_display_get_default ();
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp10_ = gdk_display_get_app_launch_context (_tmp9_);
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp11_ = _tmp10_;
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_app_info_launch ((GAppInfo*) app_info, files, (GAppLaunchContext*) _tmp11_, &_inner_error0_);
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (_tmp11_);
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 348 "../lib/synapse-plugins/desktop-file-plugin.vala"
			_g_object_unref0 (app_info);
#line 4910 "desktop-file-plugin.c"
			goto __catch0_g_error;
		}
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (app_info);
#line 4917 "desktop-file-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		err = _inner_error0_;
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_inner_error0_ = NULL;
#line 350 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp12_ = err;
#line 350 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp13_ = _tmp12_->message;
#line 350 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_warning ("desktop-file-plugin.vala:350: %s", _tmp13_);
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_error_free0 (err);
#line 4937 "desktop-file-plugin.c"
	}
	__finally0:
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (f);
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (uri_match);
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 344 "../lib/synapse-plugins/desktop-file-plugin.vala"
		return;
#line 4952 "desktop-file-plugin.c"
	}
#line 339 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (f);
#line 339 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (uri_match);
#line 4958 "desktop-file-plugin.c"
}

static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 4975 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_set_title (SynapseMatch* base,
                                                             const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* old_value;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_real_get_title (base);
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4990 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_title);
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_title = _tmp0_;
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY]);
#line 5000 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_description;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 5018 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_set_description (SynapseMatch* base,
                                                                   const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* old_value;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_real_get_description (base);
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5033 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_description);
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_description = _tmp0_;
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY]);
#line 5043 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_icon_name;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 5061 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_set_icon_name (SynapseMatch* base,
                                                                 const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* old_value;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_real_get_icon_name (base);
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5076 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_icon_name);
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_icon_name = _tmp0_;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY]);
#line 5086 "desktop-file-plugin.c"
	}
}

static gboolean
synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDesktopFilePluginOpenWithAction* self;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = self->priv->_has_thumbnail;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 5101 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_set_has_thumbnail (SynapseMatch* base,
                                                                     gboolean value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	gboolean old_value;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail (base);
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_has_thumbnail = value;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY]);
#line 5120 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDesktopFilePluginOpenWithAction* self;
	const gchar* _tmp0_;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 5138 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_set_thumbnail_path (SynapseMatch* base,
                                                                      const gchar* value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	gchar* old_value;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path (base);
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5153 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY]);
#line 5163 "desktop-file-plugin.c"
	}
}

static SynapseMatchType
synapse_desktop_file_plugin_open_with_action_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDesktopFilePluginOpenWithAction* self;
	SynapseMatchType _tmp0_;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_match_type;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 5181 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_set_match_type (SynapseMatch* base,
                                                                  SynapseMatchType value)
{
	SynapseDesktopFilePluginOpenWithAction* self;
	SynapseMatchType old_value;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_real_get_match_type (base);
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_match_type = value;
#line 323 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY]);
#line 5200 "desktop-file-plugin.c"
	}
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return result;
#line 5217 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                               SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_get_desktop_info (self);
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 5231 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY]);
#line 5241 "desktop-file-plugin.c"
	}
}

static void
synapse_desktop_file_plugin_open_with_action_class_init (SynapseDesktopFilePluginOpenWithActionClass * klass,
                                                         gpointer klass_data)
{
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_with_action_parent_class = g_type_class_peek_parent (klass);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenWithAction_private_offset);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_with_action_get_property;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_with_action_set_property;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_with_action_finalize;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5273 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_synapse_match_interface_init (SynapseMatchIface * iface,
                                                                           gpointer iface_data)
{
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_with_action_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_execute;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_title = synapse_desktop_file_plugin_open_with_action_real_get_title;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_title = synapse_desktop_file_plugin_open_with_action_real_set_title;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_description = synapse_desktop_file_plugin_open_with_action_real_get_description;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_description = synapse_desktop_file_plugin_open_with_action_real_set_description;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_icon_name = synapse_desktop_file_plugin_open_with_action_real_get_icon_name;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_icon_name = synapse_desktop_file_plugin_open_with_action_real_set_icon_name;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_has_thumbnail = synapse_desktop_file_plugin_open_with_action_real_get_has_thumbnail;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_has_thumbnail = synapse_desktop_file_plugin_open_with_action_real_set_has_thumbnail;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_thumbnail_path = synapse_desktop_file_plugin_open_with_action_real_get_thumbnail_path;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_thumbnail_path = synapse_desktop_file_plugin_open_with_action_real_set_thumbnail_path;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_match_type = synapse_desktop_file_plugin_open_with_action_real_get_match_type;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_match_type = synapse_desktop_file_plugin_open_with_action_real_set_match_type;
#line 5308 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_instance_init (SynapseDesktopFilePluginOpenWithAction * self,
                                                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_open_with_action_get_instance_private (self);
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = g_strdup ("");
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_description = _tmp0_;
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = g_strdup ("");
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_icon_name = _tmp1_;
#line 321 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_has_thumbnail = FALSE;
#line 5329 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenWithAction * self;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 318 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_title);
#line 319 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_description);
#line 320 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_icon_name);
#line 322 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 325 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class)->finalize (obj);
#line 5350 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_open_with_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenWithActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_with_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenWithAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_with_action_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_open_with_action_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_desktop_file_plugin_open_with_action_type_id;
	synapse_desktop_file_plugin_open_with_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePluginOpenWithAction", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_desktop_file_plugin_open_with_action_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	SynapseDesktopFilePluginOpenWithAction_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_open_with_action_type_id, sizeof (SynapseDesktopFilePluginOpenWithActionPrivate));
	return synapse_desktop_file_plugin_open_with_action_type_id;
}

static GType
synapse_desktop_file_plugin_open_with_action_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_open_with_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_with_action_type_id__volatile)) {
		GType synapse_desktop_file_plugin_open_with_action_type_id;
		synapse_desktop_file_plugin_open_with_action_type_id = synapse_desktop_file_plugin_open_with_action_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_open_with_action_type_id__volatile, synapse_desktop_file_plugin_open_with_action_type_id);
	}
	return synapse_desktop_file_plugin_open_with_action_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_open_with_action_get_desktop_info (self));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5429 "desktop-file-plugin.c"
		default:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5435 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_TITLE_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESCRIPTION_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_ICON_NAME_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_HAS_THUMBNAIL_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_THUMBNAIL_PATH_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_MATCH_TYPE_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, g_value_get_object (value));
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5491 "desktop-file-plugin.c"
		default:
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 316 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5497 "desktop-file-plugin.c"
	}
}

static void
_synapse_desktop_file_plugin___lambda5_ (SynapseDesktopFilePlugin* self)
{
#line 144 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->loading_in_progress = TRUE;
#line 5506 "desktop-file-plugin.c"
}

static void
__synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                      gpointer self)
{
#line 143 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_synapse_desktop_file_plugin___lambda5_ ((SynapseDesktopFilePlugin*) self);
#line 5515 "desktop-file-plugin.c"
}

static void
_synapse_desktop_file_plugin___lambda6_ (SynapseDesktopFilePlugin* self)
{
	GeeMap* _tmp0_;
	GeeList* _tmp1_;
#line 147 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->mimetype_map;
#line 147 "../lib/synapse-plugins/desktop-file-plugin.vala"
	gee_map_clear (_tmp0_);
#line 148 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = self->priv->desktop_files;
#line 148 "../lib/synapse-plugins/desktop-file-plugin.vala"
	gee_collection_clear ((GeeCollection*) _tmp1_);
#line 149 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
#line 5533 "desktop-file-plugin.c"
}

static void
__synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                   gpointer self)
{
#line 146 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_synapse_desktop_file_plugin___lambda6_ ((SynapseDesktopFilePlugin*) self);
#line 5542 "desktop-file-plugin.c"
}

static GObject *
synapse_desktop_file_plugin_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePlugin * self;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
#line 138 "../lib/synapse-plugins/desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class);
#line 138 "../lib/synapse-plugins/desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 138 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 139 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 139 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->desktop_files);
#line 139 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->desktop_files = (GeeList*) _tmp0_;
#line 140 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 140 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 140 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->mimetype_map = (GeeMap*) _tmp1_;
#line 142 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp2_ = synapse_desktop_file_service_get_default ();
#line 142 "../lib/synapse-plugins/desktop-file-plugin.vala"
	dfs = _tmp2_;
#line 143 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp3_ = dfs;
#line 143 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_signal_connect_object (_tmp3_, "reload-started", (GCallback) __synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started, self, 0);
#line 146 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_tmp4_ = dfs;
#line 146 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_signal_connect_object (_tmp4_, "reload-done", (GCallback) __synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done, self, 0);
#line 152 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
#line 138 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (dfs);
#line 138 "../lib/synapse-plugins/desktop-file-plugin.vala"
	return obj;
#line 5595 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_class_init (SynapseDesktopFilePluginClass * klass,
                                        gpointer klass_data)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePlugin_private_offset);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_get_property;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_set_property;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_constructor;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_finalize;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL] = g_signal_new ("load-complete", SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 133 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_register_plugin ();
#line 5620 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_activate;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_deactivate;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->get_enabled = synapse_desktop_file_plugin_real_get_enabled;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->set_enabled = synapse_desktop_file_plugin_real_set_enabled;
#line 5637 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                  gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_desktop_file_plugin_real_handles_query;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_desktop_file_plugin_real_search;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_desktop_file_plugin_search_finish;
#line 5652 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                                    gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_desktop_file_plugin_real_find_for_match;
#line 5663 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_instance_init (SynapseDesktopFilePlugin * self,
                                           gpointer klass)
{
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_get_instance_private (self);
#line 25 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->_enabled = TRUE;
#line 156 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self->priv->loading_in_progress = FALSE;
#line 5676 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_finalize (GObject * obj)
{
	SynapseDesktopFilePlugin * self;
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 136 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->desktop_files);
#line 355 "../lib/synapse-plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class)->finalize (obj);
#line 5691 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePlugin), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_desktop_file_plugin_type_id;
	synapse_desktop_file_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseDesktopFilePlugin_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_type_id, sizeof (SynapseDesktopFilePluginPrivate));
	return synapse_desktop_file_plugin_type_id;
}

GType
synapse_desktop_file_plugin_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_type_id__volatile)) {
		GType synapse_desktop_file_plugin_type_id;
		synapse_desktop_file_plugin_type_id = synapse_desktop_file_plugin_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_type_id__volatile, synapse_desktop_file_plugin_type_id);
	}
	return synapse_desktop_file_plugin_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5738 "desktop-file-plugin.c"
		default:
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5744 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5764 "desktop-file-plugin.c"
		default:
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/desktop-file-plugin.vala"
		break;
#line 5770 "desktop-file-plugin.c"
	}
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

