/* command-plugin.c generated by valac 0.48.13, the Vala compiler
 * generated from command-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include "synapse-core.h"
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define SYNAPSE_TYPE_COMMAND_PLUGIN (synapse_command_plugin_get_type ())
#define SYNAPSE_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin))
#define SYNAPSE_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))
#define SYNAPSE_IS_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_IS_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_COMMAND_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))

typedef struct _SynapseCommandPlugin SynapseCommandPlugin;
typedef struct _SynapseCommandPluginClass SynapseCommandPluginClass;
typedef struct _SynapseCommandPluginPrivate SynapseCommandPluginPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT (synapse_command_plugin_command_object_get_type ())
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))

typedef struct _SynapseCommandPluginCommandObject SynapseCommandPluginCommandObject;
typedef struct _SynapseCommandPluginCommandObjectClass SynapseCommandPluginCommandObjectClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseCommandPluginSearchData SynapseCommandPluginSearchData;
typedef struct _SynapseCommandPluginCommandObjectPrivate SynapseCommandPluginCommandObjectPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseCommandPlugin {
	GObject parent_instance;
	SynapseCommandPluginPrivate * priv;
};

struct _SynapseCommandPluginClass {
	GObjectClass parent_class;
};

struct _SynapseCommandPluginPrivate {
	gboolean _enabled;
	GeeSet* past_commands;
	GRegex* split_regex;
};

struct _SynapseCommandPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCommandPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp2_;
	gchar* stripped;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GeeSet* _tmp11_;
	const gchar* _tmp12_;
	GeeIterator* _command_it;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	gchar* command;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	SynapseResultSet* _tmp20_;
	const gchar* _tmp21_;
	SynapseCommandPluginCommandObject* _tmp22_;
	SynapseCommandPluginCommandObject* _tmp23_;
	gchar** args;
	GRegex* _tmp24_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint args_length1;
	gint _args_size_;
	gchar* valid_cmd;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	SynapseCommandPluginCommandObject* co;
	const gchar* _tmp34_;
	SynapseCommandPluginCommandObject* _tmp35_;
	SynapseCommandPluginCommandObject* _tmp36_;
	SynapseResultSet* _tmp37_;
	SynapseCommandPluginCommandObject* _tmp38_;
	SynapseCommandPluginCommandObject* _tmp39_;
	SynapseResultSet* _tmp40_;
	const gchar* _tmp41_;
	SynapseCommandPluginCommandObject* _tmp42_;
	SynapseCommandPluginCommandObject* _tmp43_;
	GError* _inner_error0_;
};

struct _SynapseCommandPluginCommandObject {
	GObject parent_instance;
	SynapseCommandPluginCommandObjectPrivate * priv;
};

struct _SynapseCommandPluginCommandObjectClass {
	GObjectClass parent_class;
};

struct _SynapseCommandPluginCommandObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _command;
};

static gint SynapseCommandPlugin_private_offset;
static gpointer synapse_command_plugin_parent_class = NULL;
static gint SynapseCommandPluginCommandObject_private_offset;
static gpointer synapse_command_plugin_command_object_parent_class = NULL;
static SynapseMatchIface * synapse_command_plugin_command_object_synapse_match_parent_iface = NULL;
static SynapseApplicationMatchIface * synapse_command_plugin_command_object_synapse_application_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_command_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_command_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_command_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommandPlugin, g_object_unref)
static void synapse_command_plugin_real_activate (SynapseActivatable* base);
static void synapse_command_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_command_plugin_register_plugin (void);
static void _synapse_command_plugin_register_plugin_synapse_plugin_register_func (void);
static GType synapse_command_plugin_command_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommandPluginCommandObject, g_object_unref)
static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                                                     const gchar* exec);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type,
                                                                                    const gchar* cmd);
static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                              SynapseMatch* match);
static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self);
static void synapse_command_plugin_real_search_data_free (gpointer _data);
static void synapse_command_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_);
static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self);
static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                      gpointer self);
SynapseCommandPlugin* synapse_command_plugin_new (void);
SynapseCommandPlugin* synapse_command_plugin_construct (GType object_type);
static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                        const gchar* value);
static void synapse_command_plugin_command_object_finalize (GObject * obj);
static GType synapse_command_plugin_command_object_get_type_once (void);
static void _vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static GObject * synapse_command_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_command_plugin_finalize (GObject * obj);
static GType synapse_command_plugin_get_type_once (void);
static void _vala_synapse_command_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_command_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
synapse_command_plugin_get_instance_private (SynapseCommandPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPlugin_private_offset);
}

static void
synapse_command_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
#line 27 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 268 "command-plugin.c"
}

static void
synapse_command_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
#line 29 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 277 "command-plugin.c"
}

static void
_synapse_command_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 61 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_register_plugin ();
#line 285 "command-plugin.c"
}

static void
synapse_command_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
#line 61 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
#line 61 "../lib/synapse-plugins/command-plugin.vala"
	_tmp1_ = _tmp0_;
#line 61 "../lib/synapse-plugins/command-plugin.vala"
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_COMMAND_PLUGIN, "Command Search", _ ("Find and execute arbitrary commands."), "system-run", _synapse_command_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 61 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 301 "command-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 94 "../lib/synapse-plugins/command-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 309 "command-plugin.c"
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                  const gchar* exec)
{
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp0_;
	GeeList* df_list = NULL;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	SynapseDesktopFileInfo* dfi = NULL;
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp17_;
	SynapseDesktopFileInfo* _tmp18_;
	SynapseCommandPluginCommandObject* result = NULL;
#line 86 "../lib/synapse-plugins/command-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "../lib/synapse-plugins/command-plugin.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 90 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = synapse_desktop_file_service_get_default ();
#line 90 "../lib/synapse-plugins/command-plugin.vala"
	dfs = _tmp0_;
#line 91 "../lib/synapse-plugins/command-plugin.vala"
	_tmp1_ = dfs;
#line 91 "../lib/synapse-plugins/command-plugin.vala"
	_tmp2_ = synapse_desktop_file_service_get_desktop_files_for_exec (_tmp1_, exec);
#line 91 "../lib/synapse-plugins/command-plugin.vala"
	df_list = _tmp2_;
#line 92 "../lib/synapse-plugins/command-plugin.vala"
	dfi = NULL;
#line 342 "command-plugin.c"
	{
		GeeList* _df_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _df_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _df_index = 0;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_tmp3_ = df_list;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_df_list = _tmp4_;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_tmp5_ = _df_list;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_tmp7_ = _tmp6_;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_df_size = _tmp7_;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_df_index = -1;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		while (TRUE) {
#line 370 "command-plugin.c"
			gint _tmp8_;
			gint _tmp9_;
			SynapseDesktopFileInfo* df = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			SynapseDesktopFileInfo* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			SynapseDesktopFileInfo* _tmp15_;
			SynapseDesktopFileInfo* _tmp16_;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			_df_index = _df_index + 1;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			_tmp8_ = _df_index;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			_tmp9_ = _df_size;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 94 "../lib/synapse-plugins/command-plugin.vala"
				break;
#line 391 "command-plugin.c"
			}
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			_tmp10_ = _df_list;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			_tmp11_ = gee_list_get (_tmp10_, _df_index);
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			df = (SynapseDesktopFileInfo*) _tmp11_;
#line 95 "../lib/synapse-plugins/command-plugin.vala"
			_tmp12_ = df;
#line 95 "../lib/synapse-plugins/command-plugin.vala"
			_tmp13_ = synapse_desktop_file_info_get_is_hidden (_tmp12_);
#line 95 "../lib/synapse-plugins/command-plugin.vala"
			_tmp14_ = _tmp13_;
#line 95 "../lib/synapse-plugins/command-plugin.vala"
			if (!_tmp14_) {
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				result = NULL;
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (df);
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (_df_list);
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (dfi);
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (df_list);
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (dfs);
#line 96 "../lib/synapse-plugins/command-plugin.vala"
				return result;
#line 421 "command-plugin.c"
			}
#line 98 "../lib/synapse-plugins/command-plugin.vala"
			_tmp15_ = df;
#line 98 "../lib/synapse-plugins/command-plugin.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 98 "../lib/synapse-plugins/command-plugin.vala"
			_g_object_unref0 (dfi);
#line 98 "../lib/synapse-plugins/command-plugin.vala"
			dfi = _tmp16_;
#line 94 "../lib/synapse-plugins/command-plugin.vala"
			_g_object_unref0 (df);
#line 433 "command-plugin.c"
		}
#line 94 "../lib/synapse-plugins/command-plugin.vala"
		_g_object_unref0 (_df_list);
#line 437 "command-plugin.c"
	}
#line 101 "../lib/synapse-plugins/command-plugin.vala"
	_tmp17_ = synapse_command_plugin_command_object_new (exec);
#line 101 "../lib/synapse-plugins/command-plugin.vala"
	co = _tmp17_;
#line 102 "../lib/synapse-plugins/command-plugin.vala"
	_tmp18_ = dfi;
#line 102 "../lib/synapse-plugins/command-plugin.vala"
	if (_tmp18_ != NULL) {
#line 447 "command-plugin.c"
		SynapseCommandPluginCommandObject* _tmp19_;
		SynapseDesktopFileInfo* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		SynapseDesktopFileInfo* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gboolean _tmp30_ = FALSE;
		SynapseDesktopFileInfo* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
#line 103 "../lib/synapse-plugins/command-plugin.vala"
		_tmp19_ = co;
#line 103 "../lib/synapse-plugins/command-plugin.vala"
		_tmp20_ = dfi;
#line 103 "../lib/synapse-plugins/command-plugin.vala"
		_tmp21_ = synapse_desktop_file_info_get_name (_tmp20_);
#line 103 "../lib/synapse-plugins/command-plugin.vala"
		_tmp22_ = _tmp21_;
#line 103 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) _tmp19_, _tmp22_);
#line 104 "../lib/synapse-plugins/command-plugin.vala"
		_tmp23_ = dfi;
#line 104 "../lib/synapse-plugins/command-plugin.vala"
		_tmp24_ = synapse_desktop_file_info_get_comment (_tmp23_);
#line 104 "../lib/synapse-plugins/command-plugin.vala"
		_tmp25_ = _tmp24_;
#line 104 "../lib/synapse-plugins/command-plugin.vala"
		if (g_strcmp0 (_tmp25_, "") != 0) {
#line 477 "command-plugin.c"
			SynapseCommandPluginCommandObject* _tmp26_;
			SynapseDesktopFileInfo* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
#line 105 "../lib/synapse-plugins/command-plugin.vala"
			_tmp26_ = co;
#line 105 "../lib/synapse-plugins/command-plugin.vala"
			_tmp27_ = dfi;
#line 105 "../lib/synapse-plugins/command-plugin.vala"
			_tmp28_ = synapse_desktop_file_info_get_comment (_tmp27_);
#line 105 "../lib/synapse-plugins/command-plugin.vala"
			_tmp29_ = _tmp28_;
#line 105 "../lib/synapse-plugins/command-plugin.vala"
			synapse_match_set_description ((SynapseMatch*) _tmp26_, _tmp29_);
#line 492 "command-plugin.c"
		}
#line 108 "../lib/synapse-plugins/command-plugin.vala"
		_tmp31_ = dfi;
#line 108 "../lib/synapse-plugins/command-plugin.vala"
		_tmp32_ = synapse_desktop_file_info_get_icon_name (_tmp31_);
#line 108 "../lib/synapse-plugins/command-plugin.vala"
		_tmp33_ = _tmp32_;
#line 108 "../lib/synapse-plugins/command-plugin.vala"
		if (_tmp33_ != NULL) {
#line 502 "command-plugin.c"
			SynapseDesktopFileInfo* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
#line 108 "../lib/synapse-plugins/command-plugin.vala"
			_tmp34_ = dfi;
#line 108 "../lib/synapse-plugins/command-plugin.vala"
			_tmp35_ = synapse_desktop_file_info_get_icon_name (_tmp34_);
#line 108 "../lib/synapse-plugins/command-plugin.vala"
			_tmp36_ = _tmp35_;
#line 108 "../lib/synapse-plugins/command-plugin.vala"
			_tmp30_ = g_strcmp0 (_tmp36_, "") != 0;
#line 514 "command-plugin.c"
		} else {
#line 108 "../lib/synapse-plugins/command-plugin.vala"
			_tmp30_ = FALSE;
#line 518 "command-plugin.c"
		}
#line 108 "../lib/synapse-plugins/command-plugin.vala"
		if (_tmp30_) {
#line 522 "command-plugin.c"
			SynapseCommandPluginCommandObject* _tmp37_;
			SynapseDesktopFileInfo* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
#line 109 "../lib/synapse-plugins/command-plugin.vala"
			_tmp37_ = co;
#line 109 "../lib/synapse-plugins/command-plugin.vala"
			_tmp38_ = dfi;
#line 109 "../lib/synapse-plugins/command-plugin.vala"
			_tmp39_ = synapse_desktop_file_info_get_icon_name (_tmp38_);
#line 109 "../lib/synapse-plugins/command-plugin.vala"
			_tmp40_ = _tmp39_;
#line 109 "../lib/synapse-plugins/command-plugin.vala"
			synapse_match_set_icon_name ((SynapseMatch*) _tmp37_, _tmp40_);
#line 537 "command-plugin.c"
		}
	}
#line 113 "../lib/synapse-plugins/command-plugin.vala"
	result = co;
#line 113 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (dfi);
#line 113 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (df_list);
#line 113 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (dfs);
#line 113 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 550 "command-plugin.c"
}

static void
synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                         SynapseMatch* match)
{
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp0_;
	SynapseCommandPluginCommandObject* _tmp1_;
	GeeSet* _tmp2_;
	SynapseCommandPluginCommandObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
#line 116 "../lib/synapse-plugins/command-plugin.vala"
	g_return_if_fail (self != NULL);
#line 116 "../lib/synapse-plugins/command-plugin.vala"
	g_return_if_fail (match != NULL);
#line 117 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = _g_object_ref0 (SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT (match) ? ((SynapseCommandPluginCommandObject*) match) : NULL);
#line 117 "../lib/synapse-plugins/command-plugin.vala"
	co = _tmp0_;
#line 118 "../lib/synapse-plugins/command-plugin.vala"
	_tmp1_ = co;
#line 118 "../lib/synapse-plugins/command-plugin.vala"
	if (_tmp1_ == NULL) {
#line 119 "../lib/synapse-plugins/command-plugin.vala"
		_g_object_unref0 (co);
#line 119 "../lib/synapse-plugins/command-plugin.vala"
		return;
#line 580 "command-plugin.c"
	}
#line 122 "../lib/synapse-plugins/command-plugin.vala"
	_tmp2_ = self->priv->past_commands;
#line 122 "../lib/synapse-plugins/command-plugin.vala"
	_tmp3_ = co;
#line 122 "../lib/synapse-plugins/command-plugin.vala"
	_tmp4_ = synapse_command_plugin_command_object_get_command (_tmp3_);
#line 122 "../lib/synapse-plugins/command-plugin.vala"
	_tmp5_ = _tmp4_;
#line 122 "../lib/synapse-plugins/command-plugin.vala"
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp5_);
#line 116 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (co);
#line 594 "command-plugin.c"
}

static void
synapse_command_plugin_real_search_data_free (gpointer _data)
{
	SynapseCommandPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	g_slice_free (SynapseCommandPluginSearchData, _data_);
#line 610 "command-plugin.c"
}

static void
synapse_command_plugin_real_search (SynapseItemProvider* base,
                                    SynapseQuery* q,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseCommandPlugin * self;
	SynapseCommandPluginSearchData* _data_;
	SynapseCommandPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_data_ = g_slice_new0 (SynapseCommandPluginSearchData);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_command_plugin_real_search_data_free);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_tmp1_ = *q;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_real_search_co (_data_);
#line 649 "command-plugin.c"
}

static SynapseResultSet*
synapse_command_plugin_search_finish (SynapseItemProvider* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SynapseResultSet* result;
	SynapseCommandPluginSearchData* _data_;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	if (NULL == _data_) {
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		return NULL;
#line 665 "command-plugin.c"
	}
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	result = _data_->result;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	_data_->result = NULL;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 673 "command-plugin.c"
}

static gboolean
_synapse_command_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_command_plugin_real_search_co (self);
#line 131 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 683 "command-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 704 "command-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 726 "command-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 730 "command-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 736 "command-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 740 "command-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 744 "command-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 752 "command-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 784 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 793 "command-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 809 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 818 "command-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 832 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 841 "command-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 850 "command-plugin.c"
}

static void
_synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                 gpointer self)
{
#line 166 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_command_executed ((SynapseCommandPlugin*) self, _sender);
#line 859 "command-plugin.c"
}

static gboolean
synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_)
{
#line 125 "../lib/synapse-plugins/command-plugin.vala"
	switch (_data_->_state_) {
#line 125 "../lib/synapse-plugins/command-plugin.vala"
		case 0:
#line 869 "command-plugin.c"
		goto _state_0;
#line 125 "../lib/synapse-plugins/command-plugin.vala"
		case 1:
#line 873 "command-plugin.c"
		goto _state_1;
		default:
#line 125 "../lib/synapse-plugins/command-plugin.vala"
		g_assert_not_reached ();
#line 878 "command-plugin.c"
	}
	_state_0:
#line 127 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 127 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_type;
#line 127 "../lib/synapse-plugins/command-plugin.vala"
	if (!((_data_->_tmp1_ & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
#line 128 "../lib/synapse-plugins/command-plugin.vala"
		_data_->result = NULL;
#line 128 "../lib/synapse-plugins/command-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 128 "../lib/synapse-plugins/command-plugin.vala"
		if (_data_->_state_ != 0) {
#line 128 "../lib/synapse-plugins/command-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 128 "../lib/synapse-plugins/command-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 897 "command-plugin.c"
			}
		}
#line 128 "../lib/synapse-plugins/command-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 128 "../lib/synapse-plugins/command-plugin.vala"
		return FALSE;
#line 904 "command-plugin.c"
	}
#line 131 "../lib/synapse-plugins/command-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_command_plugin_real_search_co_gsource_func, _data_, NULL);
#line 132 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_state_ = 1;
#line 132 "../lib/synapse-plugins/command-plugin.vala"
	return FALSE;
#line 912 "command-plugin.c"
	_state_1:
	;
#line 134 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp2_ = synapse_result_set_new ();
#line 134 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_result_ = _data_->_tmp2_;
#line 135 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp3_ = _data_->q;
#line 135 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp4_ = _data_->_tmp3_.query_string;
#line 135 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp5_ = string_strip (_data_->_tmp4_);
#line 135 "../lib/synapse-plugins/command-plugin.vala"
	_data_->stripped = _data_->_tmp5_;
#line 137 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp6_ = _data_->stripped;
#line 137 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (_data_->_tmp6_, "") == 0) {
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		_data_->result = NULL;
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (_data_->stripped);
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		_g_object_unref0 (_data_->_result_);
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		if (_data_->_state_ != 0) {
#line 138 "../lib/synapse-plugins/command-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 138 "../lib/synapse-plugins/command-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 945 "command-plugin.c"
			}
		}
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 138 "../lib/synapse-plugins/command-plugin.vala"
		return FALSE;
#line 952 "command-plugin.c"
	}
#line 141 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp7_ = _data_->stripped;
#line 141 "../lib/synapse-plugins/command-plugin.vala"
	if (g_str_has_prefix (_data_->_tmp7_, "~/")) {
#line 142 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp8_ = _data_->stripped;
#line 142 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp9_ = g_get_home_dir ();
#line 142 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp10_ = string_replace (_data_->_tmp8_, "~", _data_->_tmp9_);
#line 142 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (_data_->stripped);
#line 142 "../lib/synapse-plugins/command-plugin.vala"
		_data_->stripped = _data_->_tmp10_;
#line 968 "command-plugin.c"
	}
#line 145 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp11_ = _data_->self->priv->past_commands;
#line 145 "../lib/synapse-plugins/command-plugin.vala"
	_data_->_tmp12_ = _data_->stripped;
#line 145 "../lib/synapse-plugins/command-plugin.vala"
	if (!gee_collection_contains ((GeeCollection*) _data_->_tmp11_, _data_->_tmp12_)) {
#line 976 "command-plugin.c"
		{
#line 146 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp13_ = _data_->self->priv->past_commands;
#line 146 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
#line 146 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_command_it = _data_->_tmp14_;
#line 146 "../lib/synapse-plugins/command-plugin.vala"
			while (TRUE) {
#line 146 "../lib/synapse-plugins/command-plugin.vala"
				_data_->_tmp15_ = _data_->_command_it;
#line 146 "../lib/synapse-plugins/command-plugin.vala"
				if (!gee_iterator_next (_data_->_tmp15_)) {
#line 146 "../lib/synapse-plugins/command-plugin.vala"
					break;
#line 992 "command-plugin.c"
				}
#line 146 "../lib/synapse-plugins/command-plugin.vala"
				_data_->_tmp16_ = _data_->_command_it;
#line 146 "../lib/synapse-plugins/command-plugin.vala"
				_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
#line 146 "../lib/synapse-plugins/command-plugin.vala"
				_data_->command = (gchar*) _data_->_tmp17_;
#line 147 "../lib/synapse-plugins/command-plugin.vala"
				_data_->_tmp18_ = _data_->command;
#line 147 "../lib/synapse-plugins/command-plugin.vala"
				_data_->_tmp19_ = _data_->stripped;
#line 147 "../lib/synapse-plugins/command-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp18_, _data_->_tmp19_)) {
#line 148 "../lib/synapse-plugins/command-plugin.vala"
					_data_->_tmp20_ = _data_->_result_;
#line 148 "../lib/synapse-plugins/command-plugin.vala"
					_data_->_tmp21_ = _data_->command;
#line 148 "../lib/synapse-plugins/command-plugin.vala"
					_data_->_tmp22_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp21_);
#line 148 "../lib/synapse-plugins/command-plugin.vala"
					_data_->_tmp23_ = _data_->_tmp22_;
#line 148 "../lib/synapse-plugins/command-plugin.vala"
					synapse_result_set_add (_data_->_tmp20_, (SynapseMatch*) _data_->_tmp23_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 148 "../lib/synapse-plugins/command-plugin.vala"
					_g_object_unref0 (_data_->_tmp23_);
#line 1018 "command-plugin.c"
				}
#line 146 "../lib/synapse-plugins/command-plugin.vala"
				_g_free0 (_data_->command);
#line 1022 "command-plugin.c"
			}
#line 146 "../lib/synapse-plugins/command-plugin.vala"
			_g_object_unref0 (_data_->_command_it);
#line 1026 "command-plugin.c"
		}
#line 152 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp24_ = _data_->self->priv->split_regex;
#line 152 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp25_ = _data_->stripped;
#line 152 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp27_ = _data_->_tmp26_ = g_regex_split (_data_->_tmp24_, _data_->_tmp25_, 0);
#line 152 "../lib/synapse-plugins/command-plugin.vala"
		_data_->args = _data_->_tmp27_;
#line 152 "../lib/synapse-plugins/command-plugin.vala"
		_data_->args_length1 = _vala_array_length (_data_->_tmp26_);
#line 152 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_args_size_ = _data_->args_length1;
#line 153 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp28_ = _data_->args;
#line 153 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp28__length1 = _data_->args_length1;
#line 153 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp29_ = _data_->_tmp28_[0];
#line 153 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp30_ = g_find_program_in_path (_data_->_tmp29_);
#line 153 "../lib/synapse-plugins/command-plugin.vala"
		_data_->valid_cmd = _data_->_tmp30_;
#line 155 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp31_ = _data_->valid_cmd;
#line 155 "../lib/synapse-plugins/command-plugin.vala"
		if (_data_->_tmp31_ != NULL) {
#line 157 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp32_ = _data_->args;
#line 157 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp32__length1 = _data_->args_length1;
#line 157 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp33_ = _data_->_tmp32_[0];
#line 157 "../lib/synapse-plugins/command-plugin.vala"
			if (g_strcmp0 (_data_->_tmp33_, "rm") == 0) {
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				_data_->result = NULL;
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				_g_free0 (_data_->valid_cmd);
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				_g_free0 (_data_->stripped);
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				if (_data_->_state_ != 0) {
#line 158 "../lib/synapse-plugins/command-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 158 "../lib/synapse-plugins/command-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1080 "command-plugin.c"
					}
				}
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 158 "../lib/synapse-plugins/command-plugin.vala"
				return FALSE;
#line 1087 "command-plugin.c"
			}
#line 160 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp34_ = _data_->stripped;
#line 160 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp35_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp34_);
#line 160 "../lib/synapse-plugins/command-plugin.vala"
			_data_->co = _data_->_tmp35_;
#line 161 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp36_ = _data_->co;
#line 161 "../lib/synapse-plugins/command-plugin.vala"
			if (_data_->_tmp36_ == NULL) {
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				_data_->result = NULL;
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (_data_->co);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				_g_free0 (_data_->valid_cmd);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				_g_free0 (_data_->stripped);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				if (_data_->_state_ != 0) {
#line 162 "../lib/synapse-plugins/command-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 162 "../lib/synapse-plugins/command-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1119 "command-plugin.c"
					}
				}
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 162 "../lib/synapse-plugins/command-plugin.vala"
				return FALSE;
#line 1126 "command-plugin.c"
			}
#line 165 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp37_ = _data_->_result_;
#line 165 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp38_ = _data_->co;
#line 165 "../lib/synapse-plugins/command-plugin.vala"
			synapse_result_set_add (_data_->_tmp37_, (SynapseMatch*) _data_->_tmp38_, (gint) SYNAPSE_MATCH_SCORE_POOR);
#line 166 "../lib/synapse-plugins/command-plugin.vala"
			_data_->_tmp39_ = _data_->co;
#line 166 "../lib/synapse-plugins/command-plugin.vala"
			g_signal_connect_object ((SynapseMatch*) _data_->_tmp39_, "executed", (GCallback) _synapse_command_plugin_command_executed_synapse_match_executed, _data_->self, 0);
#line 155 "../lib/synapse-plugins/command-plugin.vala"
			_g_object_unref0 (_data_->co);
#line 1140 "command-plugin.c"
		}
#line 145 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (_data_->valid_cmd);
#line 145 "../lib/synapse-plugins/command-plugin.vala"
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 1146 "command-plugin.c"
	} else {
#line 169 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp40_ = _data_->_result_;
#line 169 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp41_ = _data_->stripped;
#line 169 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp42_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp41_);
#line 169 "../lib/synapse-plugins/command-plugin.vala"
		_data_->_tmp43_ = _data_->_tmp42_;
#line 169 "../lib/synapse-plugins/command-plugin.vala"
		synapse_result_set_add (_data_->_tmp40_, (SynapseMatch*) _data_->_tmp43_, (gint) SYNAPSE_MATCH_SCORE_VERY_GOOD);
#line 169 "../lib/synapse-plugins/command-plugin.vala"
		_g_object_unref0 (_data_->_tmp43_);
#line 1160 "command-plugin.c"
	}
#line 171 "../lib/synapse-plugins/command-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 171 "../lib/synapse-plugins/command-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			_g_free0 (_data_->stripped);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			return FALSE;
#line 1178 "command-plugin.c"
		} else {
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			_g_free0 (_data_->stripped);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 171 "../lib/synapse-plugins/command-plugin.vala"
			return FALSE;
#line 1192 "command-plugin.c"
		}
	}
#line 173 "../lib/synapse-plugins/command-plugin.vala"
	_data_->result = _data_->_result_;
#line 173 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (_data_->stripped);
#line 173 "../lib/synapse-plugins/command-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 173 "../lib/synapse-plugins/command-plugin.vala"
	if (_data_->_state_ != 0) {
#line 173 "../lib/synapse-plugins/command-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 173 "../lib/synapse-plugins/command-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1207 "command-plugin.c"
		}
	}
#line 173 "../lib/synapse-plugins/command-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 173 "../lib/synapse-plugins/command-plugin.vala"
	return FALSE;
#line 1214 "command-plugin.c"
}

SynapseCommandPlugin*
synapse_command_plugin_construct (GType object_type)
{
	SynapseCommandPlugin * self = NULL;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) g_object_new (object_type, NULL);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	return self;
#line 1225 "command-plugin.c"
}

SynapseCommandPlugin*
synapse_command_plugin_new (void)
{
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	return synapse_command_plugin_construct (SYNAPSE_TYPE_COMMAND_PLUGIN);
#line 1233 "command-plugin.c"
}

static gboolean
synapse_command_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommandPlugin* self;
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	result = self->priv->_enabled;
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1247 "command-plugin.c"
}

static void
synapse_command_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommandPlugin* self;
	gboolean old_value;
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_real_get_enabled (base);
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	if (old_value != value) {
#line 25 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_enabled = value;
#line 25 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY]);
#line 1266 "command-plugin.c"
	}
}

static inline gpointer
synapse_command_plugin_command_object_get_instance_private (SynapseCommandPluginCommandObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPluginCommandObject_private_offset);
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_construct (GType object_type,
                                                 const gchar* cmd)
{
	SynapseCommandPluginCommandObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 46 "../lib/synapse-plugins/command-plugin.vala"
	g_return_val_if_fail (cmd != NULL, NULL);
#line 47 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = g_strdup_printf (_ ("Execute '%s'"), cmd);
#line 47 "../lib/synapse-plugins/command-plugin.vala"
	_tmp1_ = _tmp0_;
#line 47 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) g_object_new (object_type, "title", _tmp1_, "description", _ ("Run command"), "command", cmd, "icon-name", "application-x-executable", "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, "needs-terminal", g_str_has_prefix (cmd, "sudo "), NULL);
#line 47 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (_tmp1_);
#line 1294 "command-plugin.c"
	{
		GAppInfo* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GAppInfo* _tmp9_;
		GAppInfo* _tmp10_;
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp3_ = string_replace (cmd, "\"", "\\\"");
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp4_ = _tmp3_;
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp5_ = g_strconcat ("sh -c \"", _tmp4_, NULL);
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp6_ = _tmp5_;
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp7_ = g_strconcat (_tmp6_, "\"", NULL);
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp8_ = _tmp7_;
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp9_ = g_app_info_create_from_commandline (_tmp8_, NULL, 0, &_inner_error0_);
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp10_ = _tmp9_;
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (_tmp8_);
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (_tmp6_);
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (_tmp4_);
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		_tmp2_ = _tmp10_;
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1331 "command-plugin.c"
			goto __catch0_g_error;
		}
#line 53 "../lib/synapse-plugins/command-plugin.vala"
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, _tmp2_);
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		_g_object_unref0 (_tmp2_);
#line 1338 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		err = _inner_error0_;
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		_inner_error0_ = NULL;
#line 55 "../lib/synapse-plugins/command-plugin.vala"
		_tmp11_ = err;
#line 55 "../lib/synapse-plugins/command-plugin.vala"
		_tmp12_ = _tmp11_->message;
#line 55 "../lib/synapse-plugins/command-plugin.vala"
		g_warning ("command-plugin.vala:55: %s", _tmp12_);
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		_g_error_free0 (err);
#line 1358 "command-plugin.c"
	}
	__finally0:
#line 52 "../lib/synapse-plugins/command-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 52 "../lib/synapse-plugins/command-plugin.vala"
		return NULL;
#line 1369 "command-plugin.c"
	}
#line 46 "../lib/synapse-plugins/command-plugin.vala"
	return self;
#line 1373 "command-plugin.c"
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_new (const gchar* cmd)
{
#line 46 "../lib/synapse-plugins/command-plugin.vala"
	return synapse_command_plugin_command_object_construct (SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, cmd);
#line 1381 "command-plugin.c"
}

static const gchar*
synapse_command_plugin_command_object_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1398 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_title (SynapseMatch* base,
                                                      const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	gchar* old_value;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_title (base);
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1413 "command-plugin.c"
		gchar* _tmp0_;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 33 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (self->priv->_title);
#line 33 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_title = _tmp0_;
#line 33 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY]);
#line 1423 "command-plugin.c"
	}
}

static const gchar*
synapse_command_plugin_command_object_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_description;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1441 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_description (SynapseMatch* base,
                                                            const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	gchar* old_value;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_description (base);
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1456 "command-plugin.c"
		gchar* _tmp0_;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (self->priv->_description);
#line 34 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_description = _tmp0_;
#line 34 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY]);
#line 1466 "command-plugin.c"
	}
}

static const gchar*
synapse_command_plugin_command_object_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_icon_name;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1484 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_icon_name (SynapseMatch* base,
                                                          const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	gchar* old_value;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_icon_name (base);
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1499 "command-plugin.c"
		gchar* _tmp0_;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 35 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (self->priv->_icon_name);
#line 35 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_icon_name = _tmp0_;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY]);
#line 1509 "command-plugin.c"
	}
}

static gboolean
synapse_command_plugin_command_object_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseCommandPluginCommandObject* self;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	result = self->priv->_has_thumbnail;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1524 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_has_thumbnail (SynapseMatch* base,
                                                              gboolean value)
{
	SynapseCommandPluginCommandObject* self;
	gboolean old_value;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_has_thumbnail (base);
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	if (old_value != value) {
#line 36 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_has_thumbnail = value;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY]);
#line 1543 "command-plugin.c"
	}
}

static const gchar*
synapse_command_plugin_command_object_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1561 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_thumbnail_path (SynapseMatch* base,
                                                               const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	gchar* old_value;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_thumbnail_path (base);
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1576 "command-plugin.c"
		gchar* _tmp0_;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 37 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 37 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 37 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY]);
#line 1586 "command-plugin.c"
	}
}

static SynapseMatchType
synapse_command_plugin_command_object_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseCommandPluginCommandObject* self;
	SynapseMatchType _tmp0_;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_match_type;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1604 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_match_type (SynapseMatch* base,
                                                           SynapseMatchType value)
{
	SynapseCommandPluginCommandObject* self;
	SynapseMatchType old_value;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_match_type (base);
#line 38 "../lib/synapse-plugins/command-plugin.vala"
	if (old_value != value) {
#line 38 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_match_type = value;
#line 38 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY]);
#line 1623 "command-plugin.c"
	}
}

static GAppInfo*
synapse_command_plugin_command_object_real_get_app_info (SynapseApplicationMatch* base)
{
	GAppInfo* result;
	SynapseCommandPluginCommandObject* self;
	GAppInfo* _tmp0_;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_app_info;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1641 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_app_info (SynapseApplicationMatch* base,
                                                         GAppInfo* value)
{
	SynapseCommandPluginCommandObject* self;
	GAppInfo* old_value;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_app_info (base);
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	if (old_value != value) {
#line 1656 "command-plugin.c"
		GAppInfo* _tmp0_;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 41 "../lib/synapse-plugins/command-plugin.vala"
		_g_object_unref0 (self->priv->_app_info);
#line 41 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_app_info = _tmp0_;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY]);
#line 1666 "command-plugin.c"
	}
}

static gboolean
synapse_command_plugin_command_object_real_get_needs_terminal (SynapseApplicationMatch* base)
{
	gboolean result;
	SynapseCommandPluginCommandObject* self;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	result = self->priv->_needs_terminal;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1681 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_needs_terminal (SynapseApplicationMatch* base,
                                                               gboolean value)
{
	SynapseCommandPluginCommandObject* self;
	gboolean old_value;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_needs_terminal (base);
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	if (old_value != value) {
#line 42 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_needs_terminal = value;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY]);
#line 1700 "command-plugin.c"
	}
}

static const gchar*
synapse_command_plugin_command_object_real_get_filename (SynapseApplicationMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_filename;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1718 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_real_set_filename (SynapseApplicationMatch* base,
                                                         const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	gchar* old_value;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) base;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_real_get_filename (base);
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1733 "command-plugin.c"
		gchar* _tmp0_;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 43 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (self->priv->_filename);
#line 43 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_filename = _tmp0_;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY]);
#line 1743 "command-plugin.c"
	}
}

static const gchar*
synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = self->priv->_command;
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	result = _tmp0_;
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	return result;
#line 1760 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                   const gchar* value)
{
	gchar* old_value;
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	g_return_if_fail (self != NULL);
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_get_command (self);
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1774 "command-plugin.c"
		gchar* _tmp0_;
#line 44 "../lib/synapse-plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 44 "../lib/synapse-plugins/command-plugin.vala"
		_g_free0 (self->priv->_command);
#line 44 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->_command = _tmp0_;
#line 44 "../lib/synapse-plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY]);
#line 1784 "command-plugin.c"
	}
}

static void
synapse_command_plugin_command_object_class_init (SynapseCommandPluginCommandObjectClass * klass,
                                                  gpointer klass_data)
{
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_command_object_parent_class = g_type_class_peek_parent (klass);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommandPluginCommandObject_private_offset);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_command_object_get_property;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_command_object_set_property;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_command_object_finalize;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY] = g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1822 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_synapse_match_interface_init (SynapseMatchIface * iface,
                                                                    gpointer iface_data)
{
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_command_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_title = synapse_command_plugin_command_object_real_get_title;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_title = synapse_command_plugin_command_object_real_set_title;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_description = synapse_command_plugin_command_object_real_get_description;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_description = synapse_command_plugin_command_object_real_set_description;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_icon_name = synapse_command_plugin_command_object_real_get_icon_name;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_icon_name = synapse_command_plugin_command_object_real_set_icon_name;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_has_thumbnail = synapse_command_plugin_command_object_real_get_has_thumbnail;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_has_thumbnail = synapse_command_plugin_command_object_real_set_has_thumbnail;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_thumbnail_path = synapse_command_plugin_command_object_real_get_thumbnail_path;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_thumbnail_path = synapse_command_plugin_command_object_real_set_thumbnail_path;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_match_type = synapse_command_plugin_command_object_real_get_match_type;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_match_type = synapse_command_plugin_command_object_real_set_match_type;
#line 1855 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface,
                                                                                gpointer iface_data)
{
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_command_object_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_app_info = synapse_command_plugin_command_object_real_get_app_info;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_app_info = synapse_command_plugin_command_object_real_set_app_info;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_needs_terminal = synapse_command_plugin_command_object_real_get_needs_terminal;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_needs_terminal = synapse_command_plugin_command_object_real_set_needs_terminal;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_filename = synapse_command_plugin_command_object_real_get_filename;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_filename = synapse_command_plugin_command_object_real_set_filename;
#line 1876 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_instance_init (SynapseCommandPluginCommandObject * self,
                                                     gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	self->priv = synapse_command_plugin_command_object_get_instance_private (self);
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = g_strdup ("");
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_description = _tmp0_;
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	_tmp1_ = g_strdup ("");
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_icon_name = _tmp1_;
#line 36 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_has_thumbnail = FALSE;
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_app_info = NULL;
#line 42 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_needs_terminal = FALSE;
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_filename = NULL;
#line 1903 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_finalize (GObject * obj)
{
	SynapseCommandPluginCommandObject * self;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 33 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (self->priv->_title);
#line 34 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (self->priv->_description);
#line 35 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (self->priv->_icon_name);
#line 37 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 41 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (self->priv->_app_info);
#line 43 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (self->priv->_filename);
#line 44 "../lib/synapse-plugins/command-plugin.vala"
	_g_free0 (self->priv->_command);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (synapse_command_plugin_command_object_parent_class)->finalize (obj);
#line 1928 "command-plugin.c"
}

static GType
synapse_command_plugin_command_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginCommandObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_command_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPluginCommandObject), 0, (GInstanceInitFunc) synapse_command_plugin_command_object_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_command_plugin_command_object_type_id;
	synapse_command_plugin_command_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPluginCommandObject", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
	SynapseCommandPluginCommandObject_private_offset = g_type_add_instance_private (synapse_command_plugin_command_object_type_id, sizeof (SynapseCommandPluginCommandObjectPrivate));
	return synapse_command_plugin_command_object_type_id;
}

static GType
synapse_command_plugin_command_object_get_type (void)
{
	static volatile gsize synapse_command_plugin_command_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_command_object_type_id__volatile)) {
		GType synapse_command_plugin_command_object_type_id;
		synapse_command_plugin_command_object_type_id = synapse_command_plugin_command_object_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_command_object_type_id__volatile, synapse_command_plugin_command_object_type_id);
	}
	return synapse_command_plugin_command_object_type_id__volatile;
}

static void
_vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	switch (property_id) {
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_string (value, synapse_command_plugin_command_object_get_command (self));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2027 "command-plugin.c"
		default:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2033 "command-plugin.c"
	}
}

static void
_vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
	switch (property_id) {
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_TITLE_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_DESCRIPTION_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_ICON_NAME_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_HAS_THUMBNAIL_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_THUMBNAIL_PATH_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_MATCH_TYPE_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		synapse_command_plugin_command_object_set_command (self, g_value_get_string (value));
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2107 "command-plugin.c"
		default:
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2113 "command-plugin.c"
	}
}

static GObject *
synapse_command_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommandPlugin * self;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 75 "../lib/synapse-plugins/command-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_command_plugin_parent_class);
#line 75 "../lib/synapse-plugins/command-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 75 "../lib/synapse-plugins/command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 77 "../lib/synapse-plugins/command-plugin.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 77 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (self->priv->past_commands);
#line 77 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->past_commands = (GeeSet*) _tmp0_;
#line 2139 "command-plugin.c"
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		_tmp2_ = g_regex_new ("\\s+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		_tmp1_ = _tmp2_;
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "../lib/synapse-plugins/command-plugin.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2152 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 80 "../lib/synapse-plugins/command-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 80 "../lib/synapse-plugins/command-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 2159 "command-plugin.c"
		}
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		_tmp3_ = _tmp1_;
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		_tmp1_ = NULL;
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		_g_regex_unref0 (self->priv->split_regex);
#line 80 "../lib/synapse-plugins/command-plugin.vala"
		self->priv->split_regex = _tmp3_;
#line 79 "../lib/synapse-plugins/command-plugin.vala"
		_g_regex_unref0 (_tmp1_);
#line 2171 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 79 "../lib/synapse-plugins/command-plugin.vala"
		err = _inner_error0_;
#line 79 "../lib/synapse-plugins/command-plugin.vala"
		_inner_error0_ = NULL;
#line 82 "../lib/synapse-plugins/command-plugin.vala"
		_tmp4_ = err;
#line 82 "../lib/synapse-plugins/command-plugin.vala"
		_tmp5_ = _tmp4_->message;
#line 82 "../lib/synapse-plugins/command-plugin.vala"
		g_critical ("command-plugin.vala:82: %s", _tmp5_);
#line 79 "../lib/synapse-plugins/command-plugin.vala"
		_g_error_free0 (err);
#line 2191 "command-plugin.c"
	}
	__finally0:
#line 79 "../lib/synapse-plugins/command-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 79 "../lib/synapse-plugins/command-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 79 "../lib/synapse-plugins/command-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 2200 "command-plugin.c"
	}
#line 75 "../lib/synapse-plugins/command-plugin.vala"
	return obj;
#line 2204 "command-plugin.c"
}

static void
synapse_command_plugin_class_init (SynapseCommandPluginClass * klass,
                                   gpointer klass_data)
{
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommandPlugin_private_offset);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_get_property;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_set_property;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_command_plugin_constructor;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_finalize;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_register_plugin ();
#line 2227 "command-plugin.c"
}

static void
synapse_command_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_activate;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_deactivate;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	iface->get_enabled = synapse_command_plugin_real_get_enabled;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	iface->set_enabled = synapse_command_plugin_real_set_enabled;
#line 2244 "command-plugin.c"
}

static void
synapse_command_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                             gpointer iface_data)
{
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	synapse_command_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_command_plugin_real_search;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_command_plugin_search_finish;
#line 2257 "command-plugin.c"
}

static void
synapse_command_plugin_instance_init (SynapseCommandPlugin * self,
                                      gpointer klass)
{
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	self->priv = synapse_command_plugin_get_instance_private (self);
#line 25 "../lib/synapse-plugins/command-plugin.vala"
	self->priv->_enabled = TRUE;
#line 2268 "command-plugin.c"
}

static void
synapse_command_plugin_finalize (GObject * obj)
{
	SynapseCommandPlugin * self;
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 72 "../lib/synapse-plugins/command-plugin.vala"
	_g_object_unref0 (self->priv->past_commands);
#line 73 "../lib/synapse-plugins/command-plugin.vala"
	_g_regex_unref0 (self->priv->split_regex);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	G_OBJECT_CLASS (synapse_command_plugin_parent_class)->finalize (obj);
#line 2283 "command-plugin.c"
}

static GType
synapse_command_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPlugin), 0, (GInstanceInitFunc) synapse_command_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_command_plugin_type_id;
	synapse_command_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseCommandPlugin_private_offset = g_type_add_instance_private (synapse_command_plugin_type_id, sizeof (SynapseCommandPluginPrivate));
	return synapse_command_plugin_type_id;
}

GType
synapse_command_plugin_get_type (void)
{
	static volatile gsize synapse_command_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_type_id__volatile)) {
		GType synapse_command_plugin_type_id;
		synapse_command_plugin_type_id = synapse_command_plugin_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_type_id__volatile, synapse_command_plugin_type_id);
	}
	return synapse_command_plugin_type_id__volatile;
}

static void
_vala_synapse_command_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2328 "command-plugin.c"
		default:
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2334 "command-plugin.c"
	}
}

static void
_vala_synapse_command_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
	switch (property_id) {
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2354 "command-plugin.c"
		default:
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../lib/synapse-plugins/command-plugin.vala"
		break;
#line 2360 "command-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

