/* volume-service.c generated by valac 0.48.13, the Vala compiler
 * generated from volume-service.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define SYNAPSE_TYPE_VOLUME_SERVICE (synapse_volume_service_get_type ())
#define SYNAPSE_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService))
#define SYNAPSE_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))
#define SYNAPSE_IS_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_IS_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_VOLUME_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))

typedef struct _SynapseVolumeService SynapseVolumeService;
typedef struct _SynapseVolumeServiceClass SynapseVolumeServiceClass;
typedef struct _SynapseVolumeServicePrivate SynapseVolumeServicePrivate;

#define SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT (synapse_volume_service_volume_object_get_type ())
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))

typedef struct _SynapseVolumeServiceVolumeObject SynapseVolumeServiceVolumeObject;
typedef struct _SynapseVolumeServiceVolumeObjectClass SynapseVolumeServiceVolumeObjectClass;
enum  {
	SYNAPSE_VOLUME_SERVICE_0_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_volume_service_properties[SYNAPSE_VOLUME_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT,
	SYNAPSE_MATCH_TYPE_INTERNET
} SynapseMatchType;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;
typedef struct _SynapseVolumeServiceVolumeObjectPrivate SynapseVolumeServiceVolumeObjectPrivate;
enum  {
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_0_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_NUM_PROPERTIES];

struct _SynapseVolumeService {
	GObject parent_instance;
	SynapseVolumeServicePrivate * priv;
};

struct _SynapseVolumeServiceClass {
	GObjectClass parent_class;
};

struct _SynapseVolumeServicePrivate {
	GVolumeMonitor* vm;
	GeeMap* volumes;
};

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseVolumeServiceVolumeObject {
	GObject parent_instance;
	SynapseVolumeServiceVolumeObjectPrivate * priv;
};

struct _SynapseVolumeServiceVolumeObjectClass {
	GObjectClass parent_class;
};

struct _SynapseVolumeServiceVolumeObjectPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
	gulong changed_signal_id;
	GVolume* _volume;
};

static gint SynapseVolumeService_private_offset;
static gpointer synapse_volume_service_parent_class = NULL;
static SynapseVolumeService* synapse_volume_service_instance;
static SynapseVolumeService* synapse_volume_service_instance = NULL;
static gint SynapseVolumeServiceVolumeObject_private_offset;
static gpointer synapse_volume_service_volume_object_parent_class = NULL;
static SynapseMatchIface * synapse_volume_service_volume_object_synapse_match_parent_iface = NULL;
static SynapseUriMatchIface * synapse_volume_service_volume_object_synapse_uri_match_parent_iface = NULL;

GType synapse_volume_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeService, g_object_unref)
GType synapse_volume_service_volume_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeServiceVolumeObject, g_object_unref)
SynapseVolumeService* synapse_volume_service_get_default (void);
static SynapseVolumeService* synapse_volume_service_new (void);
static SynapseVolumeService* synapse_volume_service_construct (GType object_type);
void synapse_volume_service_initialize (SynapseVolumeService* self);
static void __lambda8_ (SynapseVolumeService* self,
                 GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_new (GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_construct (GType object_type,
                                                                                  GVolume* volume);
static void ___lambda8__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                GVolume* volume,
                                                gpointer self);
static void __lambda9_ (SynapseVolumeService* self,
                 GVolume* volume);
static void ___lambda9__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                  GVolume* volume,
                                                  gpointer self);
static void __lambda10_ (SynapseVolumeService* self,
                  GMount* mount);
void synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self);
static void ___lambda10__g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                GMount* mount,
                                                gpointer self);
static void synapse_volume_service_process_volume_list (SynapseVolumeService* self,
                                                 GList* volume_list);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GeeCollection* synapse_volume_service_get_volumes (SynapseVolumeService* self);
gchar* synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                                  const gchar* uri,
                                                  gchar* * volume_path);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
void synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                      GVolume* value);
gboolean synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self);
GVolume* synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static void _synapse_volume_service_volume_object_update_state_g_volume_changed (GVolume* _sender,
                                                                          gpointer self);
void synapse_utils_logger_debug (GObject* obj,
                                 const gchar* format,
                                 ...);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
const gchar* synapse_match_get_description (SynapseMatch* self);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
static void synapse_volume_service_volume_object_finalize (GObject * obj);
static GType synapse_volume_service_volume_object_get_type_once (void);
static void _vala_synapse_volume_service_volume_object_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_synapse_volume_service_volume_object_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static GObject * synapse_volume_service_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_volume_service_finalize (GObject * obj);
static GType synapse_volume_service_get_type_once (void);

static inline gpointer
synapse_volume_service_get_instance_private (SynapseVolumeService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseVolumeService_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 28 "../lib/synapse-core/volume-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 303 "volume-service.c"
}

SynapseVolumeService*
synapse_volume_service_get_default (void)
{
	SynapseVolumeService* _tmp0_ = NULL;
	SynapseVolumeService* _tmp1_;
	SynapseVolumeService* _tmp2_;
	SynapseVolumeService* _tmp4_;
	SynapseVolumeService* result = NULL;
#line 28 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = synapse_volume_service_instance;
#line 28 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 28 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = _tmp2_;
#line 28 "../lib/synapse-core/volume-service.vala"
	if (_tmp0_ == NULL) {
#line 322 "volume-service.c"
		SynapseVolumeService* _tmp3_;
#line 28 "../lib/synapse-core/volume-service.vala"
		_tmp3_ = synapse_volume_service_new ();
#line 28 "../lib/synapse-core/volume-service.vala"
		_g_object_unref0 (_tmp0_);
#line 28 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = _tmp3_;
#line 330 "volume-service.c"
	}
#line 28 "../lib/synapse-core/volume-service.vala"
	_tmp4_ = _tmp0_;
#line 28 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = NULL;
#line 28 "../lib/synapse-core/volume-service.vala"
	result = _tmp4_;
#line 28 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp0_);
#line 28 "../lib/synapse-core/volume-service.vala"
	return result;
#line 342 "volume-service.c"
}

static SynapseVolumeService*
synapse_volume_service_construct (GType object_type)
{
	SynapseVolumeService * self = NULL;
#line 31 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeService*) g_object_new (object_type, NULL);
#line 31 "../lib/synapse-core/volume-service.vala"
	return self;
#line 353 "volume-service.c"
}

static SynapseVolumeService*
synapse_volume_service_new (void)
{
#line 31 "../lib/synapse-core/volume-service.vala"
	return synapse_volume_service_construct (SYNAPSE_TYPE_VOLUME_SERVICE);
#line 361 "volume-service.c"
}

static void
__lambda8_ (SynapseVolumeService* self,
            GVolume* volume)
{
	GeeMap* _tmp0_;
	SynapseVolumeServiceVolumeObject* _tmp1_;
	SynapseVolumeServiceVolumeObject* _tmp2_;
#line 50 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (volume != NULL);
#line 51 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 51 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = synapse_volume_service_volume_object_new (volume);
#line 51 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 51 "../lib/synapse-core/volume-service.vala"
	gee_map_set (_tmp0_, volume, _tmp2_);
#line 51 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp2_);
#line 383 "volume-service.c"
}

static void
___lambda8__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                           GVolume* volume,
                                           gpointer self)
{
#line 50 "../lib/synapse-core/volume-service.vala"
	__lambda8_ ((SynapseVolumeService*) self, volume);
#line 393 "volume-service.c"
}

static void
__lambda9_ (SynapseVolumeService* self,
            GVolume* volume)
{
	GeeMap* _tmp0_;
#line 53 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (volume != NULL);
#line 54 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 54 "../lib/synapse-core/volume-service.vala"
	gee_map_unset (_tmp0_, volume, NULL);
#line 407 "volume-service.c"
}

static void
___lambda9__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                             GVolume* volume,
                                             gpointer self)
{
#line 53 "../lib/synapse-core/volume-service.vala"
	__lambda9_ ((SynapseVolumeService*) self, volume);
#line 417 "volume-service.c"
}

static void
__lambda10_ (SynapseVolumeService* self,
             GMount* mount)
{
	GVolume* volume = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	GeeMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GVolume* _tmp6_;
	gboolean _tmp7_;
#line 56 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (mount != NULL);
#line 57 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = g_mount_get_volume (mount);
#line 57 "../lib/synapse-core/volume-service.vala"
	volume = _tmp0_;
#line 58 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = volume;
#line 58 "../lib/synapse-core/volume-service.vala"
	if (_tmp1_ == NULL) {
#line 59 "../lib/synapse-core/volume-service.vala"
		_g_object_unref0 (volume);
#line 59 "../lib/synapse-core/volume-service.vala"
		return;
#line 447 "volume-service.c"
	}
#line 62 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = self->priv->volumes;
#line 62 "../lib/synapse-core/volume-service.vala"
	_tmp3_ = gee_map_get_keys (_tmp2_);
#line 62 "../lib/synapse-core/volume-service.vala"
	_tmp4_ = _tmp3_;
#line 62 "../lib/synapse-core/volume-service.vala"
	_tmp5_ = _tmp4_;
#line 62 "../lib/synapse-core/volume-service.vala"
	_tmp6_ = volume;
#line 62 "../lib/synapse-core/volume-service.vala"
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp5_, _tmp6_);
#line 62 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp5_);
#line 62 "../lib/synapse-core/volume-service.vala"
	if (_tmp7_) {
#line 465 "volume-service.c"
		GeeMap* _tmp8_;
		GVolume* _tmp9_;
		gpointer _tmp10_;
		SynapseVolumeServiceVolumeObject* _tmp11_;
#line 63 "../lib/synapse-core/volume-service.vala"
		_tmp8_ = self->priv->volumes;
#line 63 "../lib/synapse-core/volume-service.vala"
		_tmp9_ = volume;
#line 63 "../lib/synapse-core/volume-service.vala"
		_tmp10_ = gee_map_get (_tmp8_, _tmp9_);
#line 63 "../lib/synapse-core/volume-service.vala"
		_tmp11_ = (SynapseVolumeServiceVolumeObject*) _tmp10_;
#line 63 "../lib/synapse-core/volume-service.vala"
		synapse_volume_service_volume_object_update_state (_tmp11_);
#line 63 "../lib/synapse-core/volume-service.vala"
		_g_object_unref0 (_tmp11_);
#line 482 "volume-service.c"
	}
#line 56 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (volume);
#line 486 "volume-service.c"
}

static void
___lambda10__g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                           GMount* mount,
                                           gpointer self)
{
#line 56 "../lib/synapse-core/volume-service.vala"
	__lambda10_ ((SynapseVolumeService*) self, mount);
#line 496 "volume-service.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 47 "../lib/synapse-core/volume-service.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 504 "volume-service.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 47 "../lib/synapse-core/volume-service.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 512 "volume-service.c"
}

void
synapse_volume_service_initialize (SynapseVolumeService* self)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GList* volume_list = NULL;
	GVolumeMonitor* _tmp4_;
	GList* _tmp5_;
#line 47 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 48 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = g_volume_monitor_get ();
#line 48 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (self->priv->vm);
#line 48 "../lib/synapse-core/volume-service.vala"
	self->priv->vm = _tmp0_;
#line 50 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = self->priv->vm;
#line 50 "../lib/synapse-core/volume-service.vala"
	g_signal_connect_object (_tmp1_, "volume-added", (GCallback) ___lambda8__g_volume_monitor_volume_added, self, 0);
#line 53 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = self->priv->vm;
#line 53 "../lib/synapse-core/volume-service.vala"
	g_signal_connect_object (_tmp2_, "volume-removed", (GCallback) ___lambda9__g_volume_monitor_volume_removed, self, 0);
#line 56 "../lib/synapse-core/volume-service.vala"
	_tmp3_ = self->priv->vm;
#line 56 "../lib/synapse-core/volume-service.vala"
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) ___lambda10__g_volume_monitor_mount_added, self, 0);
#line 68 "../lib/synapse-core/volume-service.vala"
	_tmp4_ = self->priv->vm;
#line 68 "../lib/synapse-core/volume-service.vala"
	_tmp5_ = g_volume_monitor_get_volumes (_tmp4_);
#line 68 "../lib/synapse-core/volume-service.vala"
	volume_list = _tmp5_;
#line 69 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_process_volume_list (self, volume_list);
#line 47 "../lib/synapse-core/volume-service.vala"
	(volume_list == NULL) ? NULL : (volume_list = (_g_list_free__g_object_unref0_ (volume_list), NULL));
#line 555 "volume-service.c"
}

static void
synapse_volume_service_process_volume_list (SynapseVolumeService* self,
                                            GList* volume_list)
{
#line 72 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 564 "volume-service.c"
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
#line 73 "../lib/synapse-core/volume-service.vala"
		volume_collection = volume_list;
#line 73 "../lib/synapse-core/volume-service.vala"
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
#line 572 "volume-service.c"
			GVolume* volume = NULL;
#line 73 "../lib/synapse-core/volume-service.vala"
			volume = (GVolume*) volume_it->data;
#line 576 "volume-service.c"
			{
				GeeMap* _tmp0_;
				GVolume* _tmp1_;
				GVolume* _tmp2_;
				SynapseVolumeServiceVolumeObject* _tmp3_;
				SynapseVolumeServiceVolumeObject* _tmp4_;
#line 74 "../lib/synapse-core/volume-service.vala"
				_tmp0_ = self->priv->volumes;
#line 74 "../lib/synapse-core/volume-service.vala"
				_tmp1_ = volume;
#line 74 "../lib/synapse-core/volume-service.vala"
				_tmp2_ = volume;
#line 74 "../lib/synapse-core/volume-service.vala"
				_tmp3_ = synapse_volume_service_volume_object_new (_tmp2_);
#line 74 "../lib/synapse-core/volume-service.vala"
				_tmp4_ = _tmp3_;
#line 74 "../lib/synapse-core/volume-service.vala"
				gee_map_set (_tmp0_, _tmp1_, _tmp4_);
#line 74 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (_tmp4_);
#line 597 "volume-service.c"
			}
		}
	}
}

GeeCollection*
synapse_volume_service_get_volumes (SynapseVolumeService* self)
{
	GeeMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result = NULL;
#line 78 "../lib/synapse-core/volume-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 79 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 79 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = gee_map_get_values (_tmp0_);
#line 79 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 79 "../lib/synapse-core/volume-service.vala"
	result = _tmp2_;
#line 79 "../lib/synapse-core/volume-service.vala"
	return result;
#line 622 "volume-service.c"
}

gchar*
synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                           const gchar* uri,
                                           gchar* * volume_path)
{
	gchar* _vala_volume_path = NULL;
	GeeSet* g_volumes = NULL;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GFile* f = NULL;
	GFile* _tmp3_;
	gchar* result = NULL;
#line 82 "../lib/synapse-core/volume-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 82 "../lib/synapse-core/volume-service.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 83 "../lib/synapse-core/volume-service.vala"
	_g_free0 (_vala_volume_path);
#line 83 "../lib/synapse-core/volume-service.vala"
	_vala_volume_path = NULL;
#line 84 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 84 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = gee_map_get_keys (_tmp0_);
#line 84 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 84 "../lib/synapse-core/volume-service.vala"
	g_volumes = _tmp2_;
#line 86 "../lib/synapse-core/volume-service.vala"
	_tmp3_ = g_file_new_for_uri (uri);
#line 86 "../lib/synapse-core/volume-service.vala"
	f = _tmp3_;
#line 658 "volume-service.c"
	{
		GeeIterator* _volume_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
#line 88 "../lib/synapse-core/volume-service.vala"
		_tmp4_ = g_volumes;
#line 88 "../lib/synapse-core/volume-service.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 88 "../lib/synapse-core/volume-service.vala"
		_volume_it = _tmp5_;
#line 88 "../lib/synapse-core/volume-service.vala"
		while (TRUE) {
#line 671 "volume-service.c"
			GeeIterator* _tmp6_;
			GVolume* volume = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFile* root = NULL;
			GVolume* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp17_;
			GFile* _tmp18_;
#line 88 "../lib/synapse-core/volume-service.vala"
			_tmp6_ = _volume_it;
#line 88 "../lib/synapse-core/volume-service.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 88 "../lib/synapse-core/volume-service.vala"
				break;
#line 688 "volume-service.c"
			}
#line 88 "../lib/synapse-core/volume-service.vala"
			_tmp7_ = _volume_it;
#line 88 "../lib/synapse-core/volume-service.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 88 "../lib/synapse-core/volume-service.vala"
			volume = (GVolume*) _tmp8_;
#line 89 "../lib/synapse-core/volume-service.vala"
			_tmp9_ = volume;
#line 89 "../lib/synapse-core/volume-service.vala"
			_tmp10_ = g_volume_get_activation_root (_tmp9_);
#line 89 "../lib/synapse-core/volume-service.vala"
			root = _tmp10_;
#line 90 "../lib/synapse-core/volume-service.vala"
			_tmp11_ = root;
#line 90 "../lib/synapse-core/volume-service.vala"
			if (_tmp11_ == NULL) {
#line 706 "volume-service.c"
				GMount* mount = NULL;
				GVolume* _tmp12_;
				GMount* _tmp13_;
				GMount* _tmp14_;
				GMount* _tmp15_;
				GFile* _tmp16_;
#line 91 "../lib/synapse-core/volume-service.vala"
				_tmp12_ = volume;
#line 91 "../lib/synapse-core/volume-service.vala"
				_tmp13_ = g_volume_get_mount (_tmp12_);
#line 91 "../lib/synapse-core/volume-service.vala"
				mount = _tmp13_;
#line 92 "../lib/synapse-core/volume-service.vala"
				_tmp14_ = mount;
#line 92 "../lib/synapse-core/volume-service.vala"
				if (_tmp14_ == NULL) {
#line 93 "../lib/synapse-core/volume-service.vala"
					_g_object_unref0 (mount);
#line 93 "../lib/synapse-core/volume-service.vala"
					_g_object_unref0 (root);
#line 93 "../lib/synapse-core/volume-service.vala"
					_g_object_unref0 (volume);
#line 93 "../lib/synapse-core/volume-service.vala"
					continue;
#line 731 "volume-service.c"
				}
#line 95 "../lib/synapse-core/volume-service.vala"
				_tmp15_ = mount;
#line 95 "../lib/synapse-core/volume-service.vala"
				_tmp16_ = g_mount_get_root (_tmp15_);
#line 95 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (root);
#line 95 "../lib/synapse-core/volume-service.vala"
				root = _tmp16_;
#line 90 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (mount);
#line 743 "volume-service.c"
			}
#line 98 "../lib/synapse-core/volume-service.vala"
			_tmp17_ = f;
#line 98 "../lib/synapse-core/volume-service.vala"
			_tmp18_ = root;
#line 98 "../lib/synapse-core/volume-service.vala"
			if (g_file_has_prefix (_tmp17_, _tmp18_)) {
#line 751 "volume-service.c"
				GFile* _tmp19_;
				gchar* _tmp20_;
				GVolume* _tmp21_;
				gchar* _tmp22_;
#line 99 "../lib/synapse-core/volume-service.vala"
				_tmp19_ = root;
#line 99 "../lib/synapse-core/volume-service.vala"
				_tmp20_ = g_file_get_path (_tmp19_);
#line 99 "../lib/synapse-core/volume-service.vala"
				_g_free0 (_vala_volume_path);
#line 99 "../lib/synapse-core/volume-service.vala"
				_vala_volume_path = _tmp20_;
#line 100 "../lib/synapse-core/volume-service.vala"
				_tmp21_ = volume;
#line 100 "../lib/synapse-core/volume-service.vala"
				_tmp22_ = g_volume_get_name (_tmp21_);
#line 100 "../lib/synapse-core/volume-service.vala"
				result = _tmp22_;
#line 100 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (root);
#line 100 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (volume);
#line 100 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (_volume_it);
#line 100 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (f);
#line 100 "../lib/synapse-core/volume-service.vala"
				_g_object_unref0 (g_volumes);
#line 100 "../lib/synapse-core/volume-service.vala"
				if (volume_path) {
#line 100 "../lib/synapse-core/volume-service.vala"
					*volume_path = _vala_volume_path;
#line 784 "volume-service.c"
				} else {
#line 100 "../lib/synapse-core/volume-service.vala"
					_g_free0 (_vala_volume_path);
#line 788 "volume-service.c"
				}
#line 100 "../lib/synapse-core/volume-service.vala"
				return result;
#line 792 "volume-service.c"
			}
#line 88 "../lib/synapse-core/volume-service.vala"
			_g_object_unref0 (root);
#line 88 "../lib/synapse-core/volume-service.vala"
			_g_object_unref0 (volume);
#line 798 "volume-service.c"
		}
#line 88 "../lib/synapse-core/volume-service.vala"
		_g_object_unref0 (_volume_it);
#line 802 "volume-service.c"
	}
#line 104 "../lib/synapse-core/volume-service.vala"
	result = NULL;
#line 104 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (f);
#line 104 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (g_volumes);
#line 104 "../lib/synapse-core/volume-service.vala"
	if (volume_path) {
#line 104 "../lib/synapse-core/volume-service.vala"
		*volume_path = _vala_volume_path;
#line 814 "volume-service.c"
	} else {
#line 104 "../lib/synapse-core/volume-service.vala"
		_g_free0 (_vala_volume_path);
#line 818 "volume-service.c"
	}
#line 104 "../lib/synapse-core/volume-service.vala"
	return result;
#line 822 "volume-service.c"
}

static inline gpointer
synapse_volume_service_volume_object_get_instance_private (SynapseVolumeServiceVolumeObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseVolumeServiceVolumeObject_private_offset);
}

void
synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* _tmp0_;
#line 150 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 151 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_volume;
#line 151 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_volume_object_set_volume (self, _tmp0_);
#line 841 "volume-service.c"
}

gboolean
synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	gboolean result = FALSE;
#line 154 "../lib/synapse-core/volume-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_volume;
#line 155 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = g_volume_get_mount (_tmp0_);
#line 155 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 155 "../lib/synapse-core/volume-service.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 155 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp2_);
#line 155 "../lib/synapse-core/volume-service.vala"
	result = _tmp3_;
#line 155 "../lib/synapse-core/volume-service.vala"
	return result;
#line 868 "volume-service.c"
}

SynapseVolumeServiceVolumeObject*
synapse_volume_service_volume_object_construct (GType object_type,
                                                GVolume* volume)
{
	SynapseVolumeServiceVolumeObject * self = NULL;
#line 158 "../lib/synapse-core/volume-service.vala"
	g_return_val_if_fail (volume != NULL, NULL);
#line 159 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) g_object_new (object_type, "volume", volume, NULL);
#line 158 "../lib/synapse-core/volume-service.vala"
	return self;
#line 882 "volume-service.c"
}

SynapseVolumeServiceVolumeObject*
synapse_volume_service_volume_object_new (GVolume* volume)
{
#line 158 "../lib/synapse-core/volume-service.vala"
	return synapse_volume_service_volume_object_construct (SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, volume);
#line 890 "volume-service.c"
}

static const gchar*
synapse_volume_service_volume_object_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
#line 108 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 108 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_title;
#line 108 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 108 "../lib/synapse-core/volume-service.vala"
	return result;
#line 907 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_title (SynapseMatch* base,
                                                     const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	gchar* old_value;
#line 108 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 108 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_title (base);
#line 108 "../lib/synapse-core/volume-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 922 "volume-service.c"
		gchar* _tmp0_;
#line 108 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = g_strdup (value);
#line 108 "../lib/synapse-core/volume-service.vala"
		_g_free0 (self->priv->_title);
#line 108 "../lib/synapse-core/volume-service.vala"
		self->priv->_title = _tmp0_;
#line 108 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY]);
#line 932 "volume-service.c"
	}
}

static const gchar*
synapse_volume_service_volume_object_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
#line 109 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 109 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_description;
#line 109 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 109 "../lib/synapse-core/volume-service.vala"
	return result;
#line 950 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_description (SynapseMatch* base,
                                                           const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	gchar* old_value;
#line 109 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 109 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_description (base);
#line 109 "../lib/synapse-core/volume-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 965 "volume-service.c"
		gchar* _tmp0_;
#line 109 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = g_strdup (value);
#line 109 "../lib/synapse-core/volume-service.vala"
		_g_free0 (self->priv->_description);
#line 109 "../lib/synapse-core/volume-service.vala"
		self->priv->_description = _tmp0_;
#line 109 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY]);
#line 975 "volume-service.c"
	}
}

static const gchar*
synapse_volume_service_volume_object_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
#line 110 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 110 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_icon_name;
#line 110 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 110 "../lib/synapse-core/volume-service.vala"
	return result;
#line 993 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_icon_name (SynapseMatch* base,
                                                         const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	gchar* old_value;
#line 110 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 110 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_icon_name (base);
#line 110 "../lib/synapse-core/volume-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1008 "volume-service.c"
		gchar* _tmp0_;
#line 110 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = g_strdup (value);
#line 110 "../lib/synapse-core/volume-service.vala"
		_g_free0 (self->priv->_icon_name);
#line 110 "../lib/synapse-core/volume-service.vala"
		self->priv->_icon_name = _tmp0_;
#line 110 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY]);
#line 1018 "volume-service.c"
	}
}

static gboolean
synapse_volume_service_volume_object_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseVolumeServiceVolumeObject* self;
#line 111 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 111 "../lib/synapse-core/volume-service.vala"
	result = self->priv->_has_thumbnail;
#line 111 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1033 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_has_thumbnail (SynapseMatch* base,
                                                             gboolean value)
{
	SynapseVolumeServiceVolumeObject* self;
	gboolean old_value;
#line 111 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 111 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_has_thumbnail (base);
#line 111 "../lib/synapse-core/volume-service.vala"
	if (old_value != value) {
#line 111 "../lib/synapse-core/volume-service.vala"
		self->priv->_has_thumbnail = value;
#line 111 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY]);
#line 1052 "volume-service.c"
	}
}

static const gchar*
synapse_volume_service_volume_object_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
#line 112 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 112 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 112 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 112 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1070 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_thumbnail_path (SynapseMatch* base,
                                                              const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	gchar* old_value;
#line 112 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 112 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_thumbnail_path (base);
#line 112 "../lib/synapse-core/volume-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1085 "volume-service.c"
		gchar* _tmp0_;
#line 112 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = g_strdup (value);
#line 112 "../lib/synapse-core/volume-service.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 112 "../lib/synapse-core/volume-service.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 112 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY]);
#line 1095 "volume-service.c"
	}
}

static SynapseMatchType
synapse_volume_service_volume_object_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseVolumeServiceVolumeObject* self;
	SynapseMatchType _tmp0_;
#line 113 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 113 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_match_type;
#line 113 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 113 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1113 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_match_type (SynapseMatch* base,
                                                          SynapseMatchType value)
{
	SynapseVolumeServiceVolumeObject* self;
	SynapseMatchType old_value;
#line 113 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 113 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_match_type (base);
#line 113 "../lib/synapse-core/volume-service.vala"
	if (old_value != value) {
#line 113 "../lib/synapse-core/volume-service.vala"
		self->priv->_match_type = value;
#line 113 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY]);
#line 1132 "volume-service.c"
	}
}

static const gchar*
synapse_volume_service_volume_object_real_get_uri (SynapseUriMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
#line 116 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 116 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_uri;
#line 116 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 116 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1150 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_uri (SynapseUriMatch* base,
                                                   const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	gchar* old_value;
#line 116 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 116 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_uri (base);
#line 116 "../lib/synapse-core/volume-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1165 "volume-service.c"
		gchar* _tmp0_;
#line 116 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = g_strdup (value);
#line 116 "../lib/synapse-core/volume-service.vala"
		_g_free0 (self->priv->_uri);
#line 116 "../lib/synapse-core/volume-service.vala"
		self->priv->_uri = _tmp0_;
#line 116 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY]);
#line 1175 "volume-service.c"
	}
}

static SynapseQueryFlags
synapse_volume_service_volume_object_real_get_file_type (SynapseUriMatch* base)
{
	SynapseQueryFlags result;
	SynapseVolumeServiceVolumeObject* self;
	SynapseQueryFlags _tmp0_;
#line 117 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 117 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_file_type;
#line 117 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 117 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1193 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_file_type (SynapseUriMatch* base,
                                                         SynapseQueryFlags value)
{
	SynapseVolumeServiceVolumeObject* self;
	SynapseQueryFlags old_value;
#line 117 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 117 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_file_type (base);
#line 117 "../lib/synapse-core/volume-service.vala"
	if (old_value != value) {
#line 117 "../lib/synapse-core/volume-service.vala"
		self->priv->_file_type = value;
#line 117 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY]);
#line 1212 "volume-service.c"
	}
}

static const gchar*
synapse_volume_service_volume_object_real_get_mime_type (SynapseUriMatch* base)
{
	const gchar* result;
	SynapseVolumeServiceVolumeObject* self;
	const gchar* _tmp0_;
#line 118 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 118 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_mime_type;
#line 118 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 118 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1230 "volume-service.c"
}

static void
synapse_volume_service_volume_object_real_set_mime_type (SynapseUriMatch* base,
                                                         const gchar* value)
{
	SynapseVolumeServiceVolumeObject* self;
	gchar* old_value;
#line 118 "../lib/synapse-core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) base;
#line 118 "../lib/synapse-core/volume-service.vala"
	old_value = synapse_volume_service_volume_object_real_get_mime_type (base);
#line 118 "../lib/synapse-core/volume-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1245 "volume-service.c"
		gchar* _tmp0_;
#line 118 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = g_strdup (value);
#line 118 "../lib/synapse-core/volume-service.vala"
		_g_free0 (self->priv->_mime_type);
#line 118 "../lib/synapse-core/volume-service.vala"
		self->priv->_mime_type = _tmp0_;
#line 118 "../lib/synapse-core/volume-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY]);
#line 1255 "volume-service.c"
	}
}

GVolume*
synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* result;
	GVolume* _tmp0_;
#line 124 "../lib/synapse-core/volume-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = self->priv->_volume;
#line 124 "../lib/synapse-core/volume-service.vala"
	result = _tmp0_;
#line 124 "../lib/synapse-core/volume-service.vala"
	return result;
#line 1272 "volume-service.c"
}

static void
_synapse_volume_service_volume_object_update_state_g_volume_changed (GVolume* _sender,
                                                                     gpointer self)
{
#line 143 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_volume_object_update_state ((SynapseVolumeServiceVolumeObject*) self);
#line 1281 "volume-service.c"
}

void
synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                 GVolume* value)
{
	GVolume* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SynapseMatchType _tmp7_ = 0;
	GMount* _tmp8_;
	GMount* _tmp9_;
	gboolean _tmp10_;
	SynapseMatchType _tmp11_;
	SynapseMatchType _tmp12_;
	gint _tmp21_ = 0;
	GMount* _tmp22_;
	GMount* _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
#line 125 "../lib/synapse-core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 126 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 126 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (self->priv->_volume);
#line 126 "../lib/synapse-core/volume-service.vala"
	self->priv->_volume = _tmp0_;
#line 127 "../lib/synapse-core/volume-service.vala"
	_tmp1_ = g_volume_get_name (value);
#line 127 "../lib/synapse-core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 127 "../lib/synapse-core/volume-service.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp2_);
#line 127 "../lib/synapse-core/volume-service.vala"
	_g_free0 (_tmp2_);
#line 128 "../lib/synapse-core/volume-service.vala"
	synapse_match_set_description ((SynapseMatch*) self, "");
#line 129 "../lib/synapse-core/volume-service.vala"
	_tmp3_ = g_volume_get_icon (value);
#line 129 "../lib/synapse-core/volume-service.vala"
	_tmp4_ = _tmp3_;
#line 129 "../lib/synapse-core/volume-service.vala"
	_tmp5_ = g_icon_to_string (_tmp4_);
#line 129 "../lib/synapse-core/volume-service.vala"
	_tmp6_ = _tmp5_;
#line 129 "../lib/synapse-core/volume-service.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp6_);
#line 129 "../lib/synapse-core/volume-service.vala"
	_g_free0 (_tmp6_);
#line 129 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp4_);
#line 130 "../lib/synapse-core/volume-service.vala"
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
#line 131 "../lib/synapse-core/volume-service.vala"
	_tmp8_ = g_volume_get_mount (value);
#line 131 "../lib/synapse-core/volume-service.vala"
	_tmp9_ = _tmp8_;
#line 131 "../lib/synapse-core/volume-service.vala"
	_tmp10_ = _tmp9_ != NULL;
#line 131 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp9_);
#line 131 "../lib/synapse-core/volume-service.vala"
	if (_tmp10_) {
#line 132 "../lib/synapse-core/volume-service.vala"
		_tmp7_ = SYNAPSE_MATCH_TYPE_GENERIC_URI;
#line 1357 "volume-service.c"
	} else {
#line 132 "../lib/synapse-core/volume-service.vala"
		_tmp7_ = SYNAPSE_MATCH_TYPE_ACTION;
#line 1361 "volume-service.c"
	}
#line 131 "../lib/synapse-core/volume-service.vala"
	synapse_match_set_match_type ((SynapseMatch*) self, _tmp7_);
#line 134 "../lib/synapse-core/volume-service.vala"
	_tmp11_ = synapse_match_get_match_type ((SynapseMatch*) self);
#line 134 "../lib/synapse-core/volume-service.vala"
	_tmp12_ = _tmp11_;
#line 134 "../lib/synapse-core/volume-service.vala"
	if (_tmp12_ == SYNAPSE_MATCH_TYPE_GENERIC_URI) {
#line 1371 "volume-service.c"
		GMount* _tmp13_;
		GMount* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 135 "../lib/synapse-core/volume-service.vala"
		_tmp13_ = g_volume_get_mount (value);
#line 135 "../lib/synapse-core/volume-service.vala"
		_tmp14_ = _tmp13_;
#line 135 "../lib/synapse-core/volume-service.vala"
		_tmp15_ = g_mount_get_root (_tmp14_);
#line 135 "../lib/synapse-core/volume-service.vala"
		_tmp16_ = _tmp15_;
#line 135 "../lib/synapse-core/volume-service.vala"
		_tmp17_ = g_file_get_uri (_tmp16_);
#line 135 "../lib/synapse-core/volume-service.vala"
		_tmp18_ = _tmp17_;
#line 135 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp18_);
#line 135 "../lib/synapse-core/volume-service.vala"
		_g_free0 (_tmp18_);
#line 135 "../lib/synapse-core/volume-service.vala"
		_g_object_unref0 (_tmp16_);
#line 135 "../lib/synapse-core/volume-service.vala"
		_g_object_unref0 (_tmp14_);
#line 136 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_PLACES);
#line 137 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, "");
#line 1402 "volume-service.c"
	} else {
#line 139 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, NULL);
#line 1406 "volume-service.c"
	}
#line 142 "../lib/synapse-core/volume-service.vala"
	if (self->priv->changed_signal_id == ((gulong) 0)) {
#line 1410 "volume-service.c"
		GVolume* _tmp19_;
		gulong _tmp20_;
#line 143 "../lib/synapse-core/volume-service.vala"
		_tmp19_ = self->priv->_volume;
#line 143 "../lib/synapse-core/volume-service.vala"
		_tmp20_ = g_signal_connect_object (_tmp19_, "changed", (GCallback) _synapse_volume_service_volume_object_update_state_g_volume_changed, self, 0);
#line 143 "../lib/synapse-core/volume-service.vala"
		self->priv->changed_signal_id = _tmp20_;
#line 1419 "volume-service.c"
	}
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp22_ = g_volume_get_mount (value);
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp23_ = _tmp22_;
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp24_ = _tmp23_ != NULL;
#line 146 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (_tmp23_);
#line 146 "../lib/synapse-core/volume-service.vala"
	if (_tmp24_) {
#line 146 "../lib/synapse-core/volume-service.vala"
		_tmp21_ = 1;
#line 1433 "volume-service.c"
	} else {
#line 146 "../lib/synapse-core/volume-service.vala"
		_tmp21_ = 0;
#line 1437 "volume-service.c"
	}
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp25_ = synapse_match_get_title ((SynapseMatch*) self);
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp26_ = _tmp25_;
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp27_ = synapse_match_get_icon_name ((SynapseMatch*) self);
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp28_ = _tmp27_;
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp29_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
#line 146 "../lib/synapse-core/volume-service.vala"
	_tmp30_ = _tmp29_;
#line 146 "../lib/synapse-core/volume-service.vala"
	synapse_utils_logger_debug ((GObject*) self, "volume-service.vala:146: vo[%p]: %s [%s], has_mount: %d, uri: %s", self, _tmp26_, _tmp28_, _tmp21_, _tmp30_, NULL);
#line 125 "../lib/synapse-core/volume-service.vala"
	g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY]);
#line 1455 "volume-service.c"
}

static void
synapse_volume_service_volume_object_class_init (SynapseVolumeServiceVolumeObjectClass * klass,
                                                 gpointer klass_data)
{
#line 107 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_volume_object_parent_class = g_type_class_peek_parent (klass);
#line 107 "../lib/synapse-core/volume-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseVolumeServiceVolumeObject_private_offset);
#line 107 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_volume_service_volume_object_get_property;
#line 107 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_volume_service_volume_object_set_property;
#line 107 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_volume_service_volume_object_finalize;
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY] = g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 107 "../lib/synapse-core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY] = g_param_spec_object ("volume", "volume", "volume", g_volume_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1492 "volume-service.c"
}

static void
synapse_volume_service_volume_object_synapse_match_interface_init (SynapseMatchIface * iface,
                                                                   gpointer iface_data)
{
#line 107 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_volume_object_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_title = synapse_volume_service_volume_object_real_get_title;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_title = synapse_volume_service_volume_object_real_set_title;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_description = synapse_volume_service_volume_object_real_get_description;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_description = synapse_volume_service_volume_object_real_set_description;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_icon_name = synapse_volume_service_volume_object_real_get_icon_name;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_icon_name = synapse_volume_service_volume_object_real_set_icon_name;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_has_thumbnail = synapse_volume_service_volume_object_real_get_has_thumbnail;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_has_thumbnail = synapse_volume_service_volume_object_real_set_has_thumbnail;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_thumbnail_path = synapse_volume_service_volume_object_real_get_thumbnail_path;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_thumbnail_path = synapse_volume_service_volume_object_real_set_thumbnail_path;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_match_type = synapse_volume_service_volume_object_real_get_match_type;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_match_type = synapse_volume_service_volume_object_real_set_match_type;
#line 1525 "volume-service.c"
}

static void
synapse_volume_service_volume_object_synapse_uri_match_interface_init (SynapseUriMatchIface * iface,
                                                                       gpointer iface_data)
{
#line 107 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_volume_object_synapse_uri_match_parent_iface = g_type_interface_peek_parent (iface);
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_uri = synapse_volume_service_volume_object_real_get_uri;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_uri = synapse_volume_service_volume_object_real_set_uri;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_file_type = synapse_volume_service_volume_object_real_get_file_type;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_file_type = synapse_volume_service_volume_object_real_set_file_type;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->get_mime_type = synapse_volume_service_volume_object_real_get_mime_type;
#line 107 "../lib/synapse-core/volume-service.vala"
	iface->set_mime_type = synapse_volume_service_volume_object_real_set_mime_type;
#line 1546 "volume-service.c"
}

static void
synapse_volume_service_volume_object_instance_init (SynapseVolumeServiceVolumeObject * self,
                                                    gpointer klass)
{
#line 107 "../lib/synapse-core/volume-service.vala"
	self->priv = synapse_volume_service_volume_object_get_instance_private (self);
#line 1555 "volume-service.c"
}

static void
synapse_volume_service_volume_object_finalize (GObject * obj)
{
	SynapseVolumeServiceVolumeObject * self;
#line 107 "../lib/synapse-core/volume-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
#line 163 "../lib/synapse-core/volume-service.vala"
	if (self->priv->changed_signal_id != ((gulong) 0)) {
#line 1566 "volume-service.c"
		GVolume* _tmp0_;
#line 164 "../lib/synapse-core/volume-service.vala"
		_tmp0_ = self->priv->_volume;
#line 164 "../lib/synapse-core/volume-service.vala"
		g_signal_handler_disconnect (_tmp0_, self->priv->changed_signal_id);
#line 165 "../lib/synapse-core/volume-service.vala"
		self->priv->changed_signal_id = (gulong) 0;
#line 1574 "volume-service.c"
	}
#line 108 "../lib/synapse-core/volume-service.vala"
	_g_free0 (self->priv->_title);
#line 109 "../lib/synapse-core/volume-service.vala"
	_g_free0 (self->priv->_description);
#line 110 "../lib/synapse-core/volume-service.vala"
	_g_free0 (self->priv->_icon_name);
#line 112 "../lib/synapse-core/volume-service.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 116 "../lib/synapse-core/volume-service.vala"
	_g_free0 (self->priv->_uri);
#line 118 "../lib/synapse-core/volume-service.vala"
	_g_free0 (self->priv->_mime_type);
#line 122 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (self->priv->_volume);
#line 107 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (synapse_volume_service_volume_object_parent_class)->finalize (obj);
#line 1592 "volume-service.c"
}

static GType
synapse_volume_service_volume_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseVolumeServiceVolumeObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_volume_service_volume_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseVolumeServiceVolumeObject), 0, (GInstanceInitFunc) synapse_volume_service_volume_object_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_volume_service_volume_object_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_uri_match_info = { (GInterfaceInitFunc) synapse_volume_service_volume_object_synapse_uri_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_volume_service_volume_object_type_id;
	synapse_volume_service_volume_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseVolumeServiceVolumeObject", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_volume_service_volume_object_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	g_type_add_interface_static (synapse_volume_service_volume_object_type_id, SYNAPSE_TYPE_URI_MATCH, &synapse_uri_match_info);
	SynapseVolumeServiceVolumeObject_private_offset = g_type_add_instance_private (synapse_volume_service_volume_object_type_id, sizeof (SynapseVolumeServiceVolumeObjectPrivate));
	return synapse_volume_service_volume_object_type_id;
}

GType
synapse_volume_service_volume_object_get_type (void)
{
	static volatile gsize synapse_volume_service_volume_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_volume_service_volume_object_type_id__volatile)) {
		GType synapse_volume_service_volume_object_type_id;
		synapse_volume_service_volume_object_type_id = synapse_volume_service_volume_object_get_type_once ();
		g_once_init_leave (&synapse_volume_service_volume_object_type_id__volatile, synapse_volume_service_volume_object_type_id);
	}
	return synapse_volume_service_volume_object_type_id__volatile;
}

static void
_vala_synapse_volume_service_volume_object_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	SynapseVolumeServiceVolumeObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
#line 107 "../lib/synapse-core/volume-service.vala"
	switch (property_id) {
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_string (value, synapse_uri_match_get_uri ((SynapseUriMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_flags (value, synapse_uri_match_get_file_type ((SynapseUriMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_string (value, synapse_uri_match_get_mime_type ((SynapseUriMatch*) self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		g_value_set_object (value, synapse_volume_service_volume_object_get_volume (self));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 1691 "volume-service.c"
		default:
#line 107 "../lib/synapse-core/volume-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 1697 "volume-service.c"
	}
}

static void
_vala_synapse_volume_service_volume_object_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	SynapseVolumeServiceVolumeObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
#line 107 "../lib/synapse-core/volume-service.vala"
	switch (property_id) {
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_TITLE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_DESCRIPTION_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_ICON_NAME_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_HAS_THUMBNAIL_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_THUMBNAIL_PATH_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MATCH_TYPE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_URI_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, g_value_get_string (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_FILE_TYPE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, g_value_get_flags (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_MIME_TYPE_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, g_value_get_string (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 107 "../lib/synapse-core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY:
#line 107 "../lib/synapse-core/volume-service.vala"
		synapse_volume_service_volume_object_set_volume (self, g_value_get_object (value));
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 1771 "volume-service.c"
		default:
#line 107 "../lib/synapse-core/volume-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 107 "../lib/synapse-core/volume-service.vala"
		break;
#line 1777 "volume-service.c"
	}
}

static GObject *
synapse_volume_service_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseVolumeService * self;
	GeeHashMap* _tmp0_;
#line 40 "../lib/synapse-core/volume-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_volume_service_parent_class);
#line 40 "../lib/synapse-core/volume-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 40 "../lib/synapse-core/volume-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService);
#line 41 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_instance = self;
#line 42 "../lib/synapse-core/volume-service.vala"
	_tmp0_ = gee_hash_map_new (g_volume_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 42 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (self->priv->volumes);
#line 42 "../lib/synapse-core/volume-service.vala"
	self->priv->volumes = (GeeMap*) _tmp0_;
#line 44 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_initialize (self);
#line 40 "../lib/synapse-core/volume-service.vala"
	return obj;
#line 1808 "volume-service.c"
}

static void
synapse_volume_service_class_init (SynapseVolumeServiceClass * klass,
                                   gpointer klass_data)
{
#line 24 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_parent_class = g_type_class_peek_parent (klass);
#line 24 "../lib/synapse-core/volume-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseVolumeService_private_offset);
#line 24 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_volume_service_constructor;
#line 24 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_volume_service_finalize;
#line 1823 "volume-service.c"
}

static void
synapse_volume_service_instance_init (SynapseVolumeService * self,
                                      gpointer klass)
{
#line 24 "../lib/synapse-core/volume-service.vala"
	self->priv = synapse_volume_service_get_instance_private (self);
#line 1832 "volume-service.c"
}

static void
synapse_volume_service_finalize (GObject * obj)
{
	SynapseVolumeService * self;
#line 24 "../lib/synapse-core/volume-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService);
#line 34 "../lib/synapse-core/volume-service.vala"
	synapse_volume_service_instance = NULL;
#line 37 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (self->priv->vm);
#line 38 "../lib/synapse-core/volume-service.vala"
	_g_object_unref0 (self->priv->volumes);
#line 24 "../lib/synapse-core/volume-service.vala"
	G_OBJECT_CLASS (synapse_volume_service_parent_class)->finalize (obj);
#line 1849 "volume-service.c"
}

static GType
synapse_volume_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseVolumeServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_volume_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseVolumeService), 0, (GInstanceInitFunc) synapse_volume_service_instance_init, NULL };
	GType synapse_volume_service_type_id;
	synapse_volume_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseVolumeService", &g_define_type_info, 0);
	SynapseVolumeService_private_offset = g_type_add_instance_private (synapse_volume_service_type_id, sizeof (SynapseVolumeServicePrivate));
	return synapse_volume_service_type_id;
}

GType
synapse_volume_service_get_type (void)
{
	static volatile gsize synapse_volume_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_volume_service_type_id__volatile)) {
		GType synapse_volume_service_type_id;
		synapse_volume_service_type_id = synapse_volume_service_get_type_once ();
		g_once_init_leave (&synapse_volume_service_type_id__volatile, synapse_volume_service_type_id);
	}
	return synapse_volume_service_type_id__volatile;
}

