/* query.c generated by valac 0.48.13, the Vala compiler
 * generated from query.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()

GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
void synapse_query_init (SynapseQuery *self,
                         guint query_id,
                         const gchar* query,
                         SynapseQueryFlags flags,
                         guint num_results);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
GQuark synapse_search_error_quark (void);
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint __lambda5_ (GeeMapEntry* a,
                 GeeMapEntry* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GType
synapse_query_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE, "SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE", "include-remote"}, {SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "SYNAPSE_QUERY_FLAGS_UNCATEGORIZED", "uncategorized"}, {SYNAPSE_QUERY_FLAGS_APPLICATIONS, "SYNAPSE_QUERY_FLAGS_APPLICATIONS", "applications"}, {SYNAPSE_QUERY_FLAGS_ACTIONS, "SYNAPSE_QUERY_FLAGS_ACTIONS", "actions"}, {SYNAPSE_QUERY_FLAGS_AUDIO, "SYNAPSE_QUERY_FLAGS_AUDIO", "audio"}, {SYNAPSE_QUERY_FLAGS_VIDEO, "SYNAPSE_QUERY_FLAGS_VIDEO", "video"}, {SYNAPSE_QUERY_FLAGS_DOCUMENTS, "SYNAPSE_QUERY_FLAGS_DOCUMENTS", "documents"}, {SYNAPSE_QUERY_FLAGS_IMAGES, "SYNAPSE_QUERY_FLAGS_IMAGES", "images"}, {SYNAPSE_QUERY_FLAGS_FILES, "SYNAPSE_QUERY_FLAGS_FILES", "files"}, {SYNAPSE_QUERY_FLAGS_PLACES, "SYNAPSE_QUERY_FLAGS_PLACES", "places"}, {SYNAPSE_QUERY_FLAGS_INTERNET, "SYNAPSE_QUERY_FLAGS_INTERNET", "internet"}, {SYNAPSE_QUERY_FLAGS_TEXT, "SYNAPSE_QUERY_FLAGS_TEXT", "text"}, {SYNAPSE_QUERY_FLAGS_CONTACTS, "SYNAPSE_QUERY_FLAGS_CONTACTS", "contacts"}, {SYNAPSE_QUERY_FLAGS_ALL, "SYNAPSE_QUERY_FLAGS_ALL", "all"}, {SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT, "SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT", "local-content"}, {0, NULL, NULL}};
	GType synapse_query_flags_type_id;
	synapse_query_flags_type_id = g_flags_register_static ("SynapseQueryFlags", values);
	return synapse_query_flags_type_id;
}

GType
synapse_query_flags_get_type (void)
{
	static volatile gsize synapse_query_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_flags_type_id__volatile)) {
		GType synapse_query_flags_type_id;
		synapse_query_flags_type_id = synapse_query_flags_get_type_once ();
		g_once_init_leave (&synapse_query_flags_type_id__volatile, synapse_query_flags_type_id);
	}
	return synapse_query_flags_type_id__volatile;
}

static GType
synapse_matcher_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_MATCHER_FLAGS_NO_REVERSED, "SYNAPSE_MATCHER_FLAGS_NO_REVERSED", "no-reversed"}, {SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING, "SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING", "no-substring"}, {SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, "SYNAPSE_MATCHER_FLAGS_NO_PARTIAL", "no-partial"}, {SYNAPSE_MATCHER_FLAGS_NO_FUZZY, "SYNAPSE_MATCHER_FLAGS_NO_FUZZY", "no-fuzzy"}, {0, NULL, NULL}};
	GType synapse_matcher_flags_type_id;
	synapse_matcher_flags_type_id = g_flags_register_static ("SynapseMatcherFlags", values);
	return synapse_matcher_flags_type_id;
}

GType
synapse_matcher_flags_get_type (void)
{
	static volatile gsize synapse_matcher_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_matcher_flags_type_id__volatile)) {
		GType synapse_matcher_flags_type_id;
		synapse_matcher_flags_type_id = synapse_matcher_flags_get_type_once ();
		g_once_init_leave (&synapse_matcher_flags_type_id__volatile, synapse_matcher_flags_type_id);
	}
	return synapse_matcher_flags_type_id__volatile;
}

void
synapse_query_init (SynapseQuery *self,
                    guint query_id,
                    const gchar* query,
                    SynapseQueryFlags flags,
                    guint num_results)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 93 "../lib/synapse-core/query.vala"
	g_return_if_fail (query != NULL);
#line 93 "../lib/synapse-core/query.vala"
	memset (self, 0, sizeof (SynapseQuery));
#line 94 "../lib/synapse-core/query.vala"
	(*self).query_id = query_id;
#line 95 "../lib/synapse-core/query.vala"
	_tmp0_ = g_strdup (query);
#line 95 "../lib/synapse-core/query.vala"
	_g_free0 ((*self).query_string);
#line 95 "../lib/synapse-core/query.vala"
	(*self).query_string = _tmp0_;
#line 96 "../lib/synapse-core/query.vala"
	_tmp1_ = g_utf8_casefold (query, (gssize) -1);
#line 96 "../lib/synapse-core/query.vala"
	_g_free0 ((*self).query_string_folded);
#line 96 "../lib/synapse-core/query.vala"
	(*self).query_string_folded = _tmp1_;
#line 97 "../lib/synapse-core/query.vala"
	(*self).query_type = flags;
#line 98 "../lib/synapse-core/query.vala"
	(*self).max_results = num_results;
#line 215 "query.c"
}

gboolean
synapse_query_is_cancelled (SynapseQuery *self)
{
	GCancellable* _tmp0_;
	gboolean result = FALSE;
#line 102 "../lib/synapse-core/query.vala"
	_tmp0_ = (*self).cancellable;
#line 102 "../lib/synapse-core/query.vala"
	result = g_cancellable_is_cancelled (_tmp0_);
#line 102 "../lib/synapse-core/query.vala"
	return result;
#line 229 "query.c"
}

void
synapse_query_check_cancellable (SynapseQuery *self,
                                 GError** error)
{
	GCancellable* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 106 "../lib/synapse-core/query.vala"
	_tmp0_ = (*self).cancellable;
#line 106 "../lib/synapse-core/query.vala"
	if (g_cancellable_is_cancelled (_tmp0_)) {
#line 242 "query.c"
		GError* _tmp1_;
#line 107 "../lib/synapse-core/query.vala"
		_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
#line 107 "../lib/synapse-core/query.vala"
		_inner_error0_ = _tmp1_;
#line 107 "../lib/synapse-core/query.vala"
		if (_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 107 "../lib/synapse-core/query.vala"
			g_propagate_error (error, _inner_error0_);
#line 107 "../lib/synapse-core/query.vala"
			return;
#line 254 "query.c"
		} else {
#line 107 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 107 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 107 "../lib/synapse-core/query.vala"
			return;
#line 262 "query.c"
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 285 "query.c"
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 148 "../lib/synapse-core/query.vala"
	if ((*length) == (*size)) {
#line 148 "../lib/synapse-core/query.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 148 "../lib/synapse-core/query.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 300 "query.c"
	}
#line 148 "../lib/synapse-core/query.vala"
	(*array)[(*length)++] = value;
#line 148 "../lib/synapse-core/query.vala"
	(*array)[*length] = NULL;
#line 306 "query.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 320 "query.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 324 "query.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 330 "query.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 335 "query.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 341 "query.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 345 "query.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 349 "query.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 353 "query.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 357 "query.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 361 "query.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 375 "query.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 384 "query.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 391 "query.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 397 "query.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 405 "query.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 409 "query.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 415 "query.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 420 "query.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 426 "query.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 430 "query.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 434 "query.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 440 "query.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 446 "query.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 458 "query.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 462 "query.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 466 "query.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 471 "query.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 479 "query.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 501 "query.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 510 "query.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 519 "query.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 525 "query.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 533 "query.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 545 "query.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 551 "query.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 555 "query.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 563 "query.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 574 "query.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 583 "query.c"
	}
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 195 "../lib/synapse-core/query.vala"
	if ((*length) == (*size)) {
#line 195 "../lib/synapse-core/query.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 195 "../lib/synapse-core/query.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 599 "query.c"
	}
#line 195 "../lib/synapse-core/query.vala"
	(*array)[(*length)++] = value;
#line 195 "../lib/synapse-core/query.vala"
	(*array)[*length] = NULL;
#line 605 "query.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 220 "../lib/synapse-core/query.vala"
	return self ? g_object_ref (self) : NULL;
#line 613 "query.c"
}

static gint
__lambda5_ (GeeMapEntry* a,
            GeeMapEntry* b)
{
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gint result = 0;
#line 222 "../lib/synapse-core/query.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 222 "../lib/synapse-core/query.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 223 "../lib/synapse-core/query.vala"
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 224 "../lib/synapse-core/query.vala"
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 225 "../lib/synapse-core/query.vala"
	_tmp0_ = gee_map_entry_get_value (e2);
#line 225 "../lib/synapse-core/query.vala"
	_tmp1_ = _tmp0_;
#line 225 "../lib/synapse-core/query.vala"
	_tmp2_ = gee_map_entry_get_value (e1);
#line 225 "../lib/synapse-core/query.vala"
	_tmp3_ = _tmp2_;
#line 225 "../lib/synapse-core/query.vala"
	result = ((gint) ((gintptr) _tmp1_)) - ((gint) ((gintptr) _tmp3_));
#line 225 "../lib/synapse-core/query.vala"
	return result;
#line 647 "query.c"
}

static gint
___lambda5__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda5_ ((GeeMapEntry*) a, (GeeMapEntry*) b);
#line 222 "../lib/synapse-core/query.vala"
	return result;
#line 659 "query.c"
}

GeeList*
synapse_query_get_matchers_for_query (const gchar* query,
                                      SynapseMatcherFlags match_flags,
                                      GRegexCompileFlags flags)
{
	GeeHashMap* results = NULL;
	GeeHashMap* _tmp0_;
	GRegex* re = NULL;
	gchar** individual_words = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint individual_words_length1;
	gint _individual_words_size_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar** individual_chars = NULL;
	gchar** _tmp91_;
	gchar** _tmp92_;
	gint individual_chars_length1;
	gint _individual_chars_size_;
	gchar** escaped_chars = NULL;
	gchar** _tmp93_;
	gint escaped_chars_length1;
	gint _escaped_chars_size_;
	gchar** _tmp94_;
	gint _tmp94__length1;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp111_ = FALSE;
	GeeArrayList* sorted_results = NULL;
	GeeArrayList* _tmp123_;
	GeeSet* entries = NULL;
	GeeSet* _tmp124_;
	GeeSet* _tmp125_;
	GeeSet* _tmp126_;
	GError* _inner_error0_ = NULL;
	GeeList* result = NULL;
#line 111 "../lib/synapse-core/query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 125 "../lib/synapse-core/query.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, (GDestroyNotify) g_regex_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 125 "../lib/synapse-core/query.vala"
	results = _tmp0_;
#line 709 "query.c"
	{
		GRegex* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
#line 129 "../lib/synapse-core/query.vala"
		_tmp2_ = g_regex_escape_string (query, -1);
#line 129 "../lib/synapse-core/query.vala"
		_tmp3_ = _tmp2_;
#line 129 "../lib/synapse-core/query.vala"
		_tmp4_ = g_strdup_printf ("^(%s)$", _tmp3_);
#line 129 "../lib/synapse-core/query.vala"
		_tmp5_ = _tmp4_;
#line 129 "../lib/synapse-core/query.vala"
		_tmp6_ = g_regex_new (_tmp5_, flags, 0, &_inner_error0_);
#line 129 "../lib/synapse-core/query.vala"
		_tmp7_ = _tmp6_;
#line 129 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp5_);
#line 129 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp3_);
#line 129 "../lib/synapse-core/query.vala"
		_tmp1_ = _tmp7_;
#line 129 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 129 "../lib/synapse-core/query.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 742 "query.c"
				goto __catch0_g_regex_error;
			}
#line 129 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 129 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 129 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 129 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 129 "../lib/synapse-core/query.vala"
			return NULL;
#line 755 "query.c"
		}
#line 129 "../lib/synapse-core/query.vala"
		_tmp8_ = _tmp1_;
#line 129 "../lib/synapse-core/query.vala"
		_tmp1_ = NULL;
#line 129 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (re);
#line 129 "../lib/synapse-core/query.vala"
		re = _tmp8_;
#line 130 "../lib/synapse-core/query.vala"
		_tmp9_ = re;
#line 130 "../lib/synapse-core/query.vala"
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp9_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_HIGHEST)));
#line 128 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (_tmp1_);
#line 771 "query.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 128 "../lib/synapse-core/query.vala"
		g_clear_error (&_inner_error0_);
#line 778 "query.c"
	}
	__finally0:
#line 128 "../lib/synapse-core/query.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 128 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (re);
#line 128 "../lib/synapse-core/query.vala"
		_g_object_unref0 (results);
#line 128 "../lib/synapse-core/query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 128 "../lib/synapse-core/query.vala"
		g_clear_error (&_inner_error0_);
#line 128 "../lib/synapse-core/query.vala"
		return NULL;
#line 793 "query.c"
	}
	{
		GRegex* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_;
#line 134 "../lib/synapse-core/query.vala"
		_tmp11_ = g_regex_escape_string (query, -1);
#line 134 "../lib/synapse-core/query.vala"
		_tmp12_ = _tmp11_;
#line 134 "../lib/synapse-core/query.vala"
		_tmp13_ = g_strdup_printf ("^(%s)", _tmp12_);
#line 134 "../lib/synapse-core/query.vala"
		_tmp14_ = _tmp13_;
#line 134 "../lib/synapse-core/query.vala"
		_tmp15_ = g_regex_new (_tmp14_, flags, 0, &_inner_error0_);
#line 134 "../lib/synapse-core/query.vala"
		_tmp16_ = _tmp15_;
#line 134 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp14_);
#line 134 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp12_);
#line 134 "../lib/synapse-core/query.vala"
		_tmp10_ = _tmp16_;
#line 134 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 134 "../lib/synapse-core/query.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 827 "query.c"
				goto __catch1_g_regex_error;
			}
#line 134 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 134 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 134 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 134 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 134 "../lib/synapse-core/query.vala"
			return NULL;
#line 840 "query.c"
		}
#line 134 "../lib/synapse-core/query.vala"
		_tmp17_ = _tmp10_;
#line 134 "../lib/synapse-core/query.vala"
		_tmp10_ = NULL;
#line 134 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (re);
#line 134 "../lib/synapse-core/query.vala"
		re = _tmp17_;
#line 135 "../lib/synapse-core/query.vala"
		_tmp18_ = re;
#line 135 "../lib/synapse-core/query.vala"
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp18_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_EXCELLENT)));
#line 133 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (_tmp10_);
#line 856 "query.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
#line 133 "../lib/synapse-core/query.vala"
		g_clear_error (&_inner_error0_);
#line 863 "query.c"
	}
	__finally1:
#line 133 "../lib/synapse-core/query.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 133 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (re);
#line 133 "../lib/synapse-core/query.vala"
		_g_object_unref0 (results);
#line 133 "../lib/synapse-core/query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 133 "../lib/synapse-core/query.vala"
		g_clear_error (&_inner_error0_);
#line 133 "../lib/synapse-core/query.vala"
		return NULL;
#line 878 "query.c"
	}
	{
		GRegex* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GRegex* _tmp24_;
		GRegex* _tmp25_;
		GRegex* _tmp26_;
		GRegex* _tmp27_;
#line 139 "../lib/synapse-core/query.vala"
		_tmp20_ = g_regex_escape_string (query, -1);
#line 139 "../lib/synapse-core/query.vala"
		_tmp21_ = _tmp20_;
#line 139 "../lib/synapse-core/query.vala"
		_tmp22_ = g_strdup_printf ("\\b(%s)", _tmp21_);
#line 139 "../lib/synapse-core/query.vala"
		_tmp23_ = _tmp22_;
#line 139 "../lib/synapse-core/query.vala"
		_tmp24_ = g_regex_new (_tmp23_, flags, 0, &_inner_error0_);
#line 139 "../lib/synapse-core/query.vala"
		_tmp25_ = _tmp24_;
#line 139 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp23_);
#line 139 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp21_);
#line 139 "../lib/synapse-core/query.vala"
		_tmp19_ = _tmp25_;
#line 139 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 139 "../lib/synapse-core/query.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 912 "query.c"
				goto __catch2_g_regex_error;
			}
#line 139 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 139 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 139 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 139 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 139 "../lib/synapse-core/query.vala"
			return NULL;
#line 925 "query.c"
		}
#line 139 "../lib/synapse-core/query.vala"
		_tmp26_ = _tmp19_;
#line 139 "../lib/synapse-core/query.vala"
		_tmp19_ = NULL;
#line 139 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (re);
#line 139 "../lib/synapse-core/query.vala"
		re = _tmp26_;
#line 140 "../lib/synapse-core/query.vala"
		_tmp27_ = re;
#line 140 "../lib/synapse-core/query.vala"
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp27_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_VERY_GOOD)));
#line 138 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (_tmp19_);
#line 941 "query.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
#line 138 "../lib/synapse-core/query.vala"
		g_clear_error (&_inner_error0_);
#line 948 "query.c"
	}
	__finally2:
#line 138 "../lib/synapse-core/query.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 138 "../lib/synapse-core/query.vala"
		_g_regex_unref0 (re);
#line 138 "../lib/synapse-core/query.vala"
		_g_object_unref0 (results);
#line 138 "../lib/synapse-core/query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 138 "../lib/synapse-core/query.vala"
		g_clear_error (&_inner_error0_);
#line 138 "../lib/synapse-core/query.vala"
		return NULL;
#line 963 "query.c"
	}
#line 144 "../lib/synapse-core/query.vala"
	_tmp28_ = string_strip (query);
#line 144 "../lib/synapse-core/query.vala"
	_tmp29_ = _tmp28_;
#line 144 "../lib/synapse-core/query.vala"
	_tmp31_ = _tmp30_ = g_regex_split_simple ("\\s+", _tmp29_, 0, 0);
#line 144 "../lib/synapse-core/query.vala"
	_tmp32_ = _tmp31_;
#line 144 "../lib/synapse-core/query.vala"
	_tmp32__length1 = _vala_array_length (_tmp30_);
#line 144 "../lib/synapse-core/query.vala"
	_g_free0 (_tmp29_);
#line 144 "../lib/synapse-core/query.vala"
	individual_words = _tmp32_;
#line 144 "../lib/synapse-core/query.vala"
	individual_words_length1 = _tmp32__length1;
#line 144 "../lib/synapse-core/query.vala"
	_individual_words_size_ = individual_words_length1;
#line 145 "../lib/synapse-core/query.vala"
	_tmp33_ = individual_words;
#line 145 "../lib/synapse-core/query.vala"
	_tmp33__length1 = individual_words_length1;
#line 145 "../lib/synapse-core/query.vala"
	if (_tmp33__length1 >= 2) {
#line 989 "query.c"
		gchar** escaped_words = NULL;
		gchar** _tmp34_;
		gint escaped_words_length1;
		gint _escaped_words_size_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* pattern = NULL;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
#line 146 "../lib/synapse-core/query.vala"
		_tmp34_ = g_new0 (gchar*, 0 + 1);
#line 146 "../lib/synapse-core/query.vala"
		escaped_words = _tmp34_;
#line 146 "../lib/synapse-core/query.vala"
		escaped_words_length1 = 0;
#line 146 "../lib/synapse-core/query.vala"
		_escaped_words_size_ = escaped_words_length1;
#line 147 "../lib/synapse-core/query.vala"
		_tmp35_ = individual_words;
#line 147 "../lib/synapse-core/query.vala"
		_tmp35__length1 = individual_words_length1;
#line 1015 "query.c"
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
#line 147 "../lib/synapse-core/query.vala"
			word_collection = _tmp35_;
#line 147 "../lib/synapse-core/query.vala"
			word_collection_length1 = _tmp35__length1;
#line 147 "../lib/synapse-core/query.vala"
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
#line 1027 "query.c"
				const gchar* word = NULL;
#line 147 "../lib/synapse-core/query.vala"
				word = word_collection[word_it];
#line 1031 "query.c"
				{
					const gchar* _tmp36_;
					gchar* _tmp37_;
#line 148 "../lib/synapse-core/query.vala"
					_tmp36_ = word;
#line 148 "../lib/synapse-core/query.vala"
					_tmp37_ = g_regex_escape_string (_tmp36_, -1);
#line 148 "../lib/synapse-core/query.vala"
					_vala_array_add6 (&escaped_words, &escaped_words_length1, &_escaped_words_size_, _tmp37_);
#line 1041 "query.c"
				}
			}
		}
#line 150 "../lib/synapse-core/query.vala"
		_tmp38_ = escaped_words;
#line 150 "../lib/synapse-core/query.vala"
		_tmp38__length1 = escaped_words_length1;
#line 150 "../lib/synapse-core/query.vala"
		_tmp39_ = _vala_g_strjoinv (").+\\b(", _tmp38_, (gint) _tmp38__length1);
#line 150 "../lib/synapse-core/query.vala"
		_tmp40_ = _tmp39_;
#line 150 "../lib/synapse-core/query.vala"
		_tmp41_ = g_strdup_printf ("\\b(%s)", _tmp40_);
#line 150 "../lib/synapse-core/query.vala"
		_tmp42_ = _tmp41_;
#line 150 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp40_);
#line 150 "../lib/synapse-core/query.vala"
		pattern = _tmp42_;
#line 1061 "query.c"
		{
			GRegex* _tmp43_ = NULL;
			const gchar* _tmp44_;
			GRegex* _tmp45_;
			GRegex* _tmp46_;
			GRegex* _tmp47_;
#line 153 "../lib/synapse-core/query.vala"
			_tmp44_ = pattern;
#line 153 "../lib/synapse-core/query.vala"
			_tmp45_ = g_regex_new (_tmp44_, flags, 0, &_inner_error0_);
#line 153 "../lib/synapse-core/query.vala"
			_tmp43_ = _tmp45_;
#line 153 "../lib/synapse-core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "../lib/synapse-core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1078 "query.c"
					goto __catch3_g_regex_error;
				}
#line 153 "../lib/synapse-core/query.vala"
				_g_free0 (pattern);
#line 153 "../lib/synapse-core/query.vala"
				escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 153 "../lib/synapse-core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 153 "../lib/synapse-core/query.vala"
				_g_regex_unref0 (re);
#line 153 "../lib/synapse-core/query.vala"
				_g_object_unref0 (results);
#line 153 "../lib/synapse-core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 153 "../lib/synapse-core/query.vala"
				g_clear_error (&_inner_error0_);
#line 153 "../lib/synapse-core/query.vala"
				return NULL;
#line 1097 "query.c"
			}
#line 153 "../lib/synapse-core/query.vala"
			_tmp46_ = _tmp43_;
#line 153 "../lib/synapse-core/query.vala"
			_tmp43_ = NULL;
#line 153 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 153 "../lib/synapse-core/query.vala"
			re = _tmp46_;
#line 154 "../lib/synapse-core/query.vala"
			_tmp47_ = re;
#line 154 "../lib/synapse-core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp47_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_GOOD)));
#line 152 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (_tmp43_);
#line 1113 "query.c"
		}
		goto __finally3;
		__catch3_g_regex_error:
		{
#line 152 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1120 "query.c"
		}
		__finally3:
#line 152 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 152 "../lib/synapse-core/query.vala"
			_g_free0 (pattern);
#line 152 "../lib/synapse-core/query.vala"
			escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 152 "../lib/synapse-core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 152 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 152 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 152 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 152 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 152 "../lib/synapse-core/query.vala"
			return NULL;
#line 1141 "query.c"
		}
#line 158 "../lib/synapse-core/query.vala"
		if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_REVERSED) == SYNAPSE_MATCHER_FLAGS_NO_REVERSED)) {
#line 1145 "query.c"
			gchar** _tmp48_;
			gint _tmp48__length1;
#line 159 "../lib/synapse-core/query.vala"
			_tmp48_ = escaped_words;
#line 159 "../lib/synapse-core/query.vala"
			_tmp48__length1 = escaped_words_length1;
#line 159 "../lib/synapse-core/query.vala"
			if (_tmp48__length1 == 2) {
#line 1154 "query.c"
				gchar* reversed = NULL;
				gchar** _tmp49_;
				gint _tmp49__length1;
				const gchar* _tmp50_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
#line 160 "../lib/synapse-core/query.vala"
				_tmp49_ = escaped_words;
#line 160 "../lib/synapse-core/query.vala"
				_tmp49__length1 = escaped_words_length1;
#line 160 "../lib/synapse-core/query.vala"
				_tmp50_ = _tmp49_[1];
#line 160 "../lib/synapse-core/query.vala"
				_tmp51_ = escaped_words;
#line 160 "../lib/synapse-core/query.vala"
				_tmp51__length1 = escaped_words_length1;
#line 160 "../lib/synapse-core/query.vala"
				_tmp52_ = _tmp51_[0];
#line 160 "../lib/synapse-core/query.vala"
				_tmp53_ = g_strjoin (").+\\b(", _tmp50_, _tmp52_, NULL, NULL);
#line 160 "../lib/synapse-core/query.vala"
				_tmp54_ = _tmp53_;
#line 160 "../lib/synapse-core/query.vala"
				_tmp55_ = g_strdup_printf ("\\b(%s)", _tmp54_);
#line 160 "../lib/synapse-core/query.vala"
				_tmp56_ = _tmp55_;
#line 160 "../lib/synapse-core/query.vala"
				_g_free0 (_tmp54_);
#line 160 "../lib/synapse-core/query.vala"
				reversed = _tmp56_;
#line 1190 "query.c"
				{
					GRegex* _tmp57_ = NULL;
					const gchar* _tmp58_;
					GRegex* _tmp59_;
					GRegex* _tmp60_;
					GRegex* _tmp61_;
#line 162 "../lib/synapse-core/query.vala"
					_tmp58_ = reversed;
#line 162 "../lib/synapse-core/query.vala"
					_tmp59_ = g_regex_new (_tmp58_, flags, 0, &_inner_error0_);
#line 162 "../lib/synapse-core/query.vala"
					_tmp57_ = _tmp59_;
#line 162 "../lib/synapse-core/query.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 162 "../lib/synapse-core/query.vala"
						if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1207 "query.c"
							goto __catch4_g_regex_error;
						}
#line 162 "../lib/synapse-core/query.vala"
						_g_free0 (reversed);
#line 162 "../lib/synapse-core/query.vala"
						_g_free0 (pattern);
#line 162 "../lib/synapse-core/query.vala"
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 162 "../lib/synapse-core/query.vala"
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 162 "../lib/synapse-core/query.vala"
						_g_regex_unref0 (re);
#line 162 "../lib/synapse-core/query.vala"
						_g_object_unref0 (results);
#line 162 "../lib/synapse-core/query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 162 "../lib/synapse-core/query.vala"
						g_clear_error (&_inner_error0_);
#line 162 "../lib/synapse-core/query.vala"
						return NULL;
#line 1228 "query.c"
					}
#line 162 "../lib/synapse-core/query.vala"
					_tmp60_ = _tmp57_;
#line 162 "../lib/synapse-core/query.vala"
					_tmp57_ = NULL;
#line 162 "../lib/synapse-core/query.vala"
					_g_regex_unref0 (re);
#line 162 "../lib/synapse-core/query.vala"
					re = _tmp60_;
#line 163 "../lib/synapse-core/query.vala"
					_tmp61_ = re;
#line 163 "../lib/synapse-core/query.vala"
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp61_, (gpointer) ((gintptr) ((gint) (SYNAPSE_MATCH_SCORE_GOOD - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR))));
#line 161 "../lib/synapse-core/query.vala"
					_g_regex_unref0 (_tmp57_);
#line 1244 "query.c"
				}
				goto __finally4;
				__catch4_g_regex_error:
				{
#line 161 "../lib/synapse-core/query.vala"
					g_clear_error (&_inner_error0_);
#line 1251 "query.c"
				}
				__finally4:
#line 161 "../lib/synapse-core/query.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 161 "../lib/synapse-core/query.vala"
					_g_free0 (reversed);
#line 161 "../lib/synapse-core/query.vala"
					_g_free0 (pattern);
#line 161 "../lib/synapse-core/query.vala"
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 161 "../lib/synapse-core/query.vala"
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 161 "../lib/synapse-core/query.vala"
					_g_regex_unref0 (re);
#line 161 "../lib/synapse-core/query.vala"
					_g_object_unref0 (results);
#line 161 "../lib/synapse-core/query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 161 "../lib/synapse-core/query.vala"
					g_clear_error (&_inner_error0_);
#line 161 "../lib/synapse-core/query.vala"
					return NULL;
#line 1274 "query.c"
				}
#line 159 "../lib/synapse-core/query.vala"
				_g_free0 (reversed);
#line 1278 "query.c"
			} else {
				gchar* orred = NULL;
				gchar** _tmp62_;
				gint _tmp62__length1;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* any_order = NULL;
				gchar* _tmp67_;
#line 167 "../lib/synapse-core/query.vala"
				_tmp62_ = escaped_words;
#line 167 "../lib/synapse-core/query.vala"
				_tmp62__length1 = escaped_words_length1;
#line 167 "../lib/synapse-core/query.vala"
				_tmp63_ = _vala_g_strjoinv (")|(?:", _tmp62_, (gint) _tmp62__length1);
#line 167 "../lib/synapse-core/query.vala"
				_tmp64_ = _tmp63_;
#line 167 "../lib/synapse-core/query.vala"
				_tmp65_ = g_strdup_printf ("\\b((?:%s))", _tmp64_);
#line 167 "../lib/synapse-core/query.vala"
				_tmp66_ = _tmp65_;
#line 167 "../lib/synapse-core/query.vala"
				_g_free0 (_tmp64_);
#line 167 "../lib/synapse-core/query.vala"
				orred = _tmp66_;
#line 168 "../lib/synapse-core/query.vala"
				_tmp67_ = g_strdup ("");
#line 168 "../lib/synapse-core/query.vala"
				any_order = _tmp67_;
#line 1309 "query.c"
				{
					gint i = 0;
#line 169 "../lib/synapse-core/query.vala"
					i = 0;
#line 1314 "query.c"
					{
						gboolean _tmp68_ = FALSE;
#line 169 "../lib/synapse-core/query.vala"
						_tmp68_ = TRUE;
#line 169 "../lib/synapse-core/query.vala"
						while (TRUE) {
#line 1321 "query.c"
							gchar** _tmp70_;
							gint _tmp70__length1;
							gboolean is_last = FALSE;
							gchar** _tmp71_;
							gint _tmp71__length1;
							const gchar* _tmp72_;
							const gchar* _tmp73_;
							gchar* _tmp74_;
#line 169 "../lib/synapse-core/query.vala"
							if (!_tmp68_) {
#line 1332 "query.c"
								gint _tmp69_;
#line 169 "../lib/synapse-core/query.vala"
								_tmp69_ = i;
#line 169 "../lib/synapse-core/query.vala"
								i = _tmp69_ + 1;
#line 1338 "query.c"
							}
#line 169 "../lib/synapse-core/query.vala"
							_tmp68_ = FALSE;
#line 169 "../lib/synapse-core/query.vala"
							_tmp70_ = escaped_words;
#line 169 "../lib/synapse-core/query.vala"
							_tmp70__length1 = escaped_words_length1;
#line 169 "../lib/synapse-core/query.vala"
							if (!(i < _tmp70__length1)) {
#line 169 "../lib/synapse-core/query.vala"
								break;
#line 1350 "query.c"
							}
#line 170 "../lib/synapse-core/query.vala"
							_tmp71_ = escaped_words;
#line 170 "../lib/synapse-core/query.vala"
							_tmp71__length1 = escaped_words_length1;
#line 170 "../lib/synapse-core/query.vala"
							is_last = i == (_tmp71__length1 - 1);
#line 171 "../lib/synapse-core/query.vala"
							_tmp72_ = any_order;
#line 171 "../lib/synapse-core/query.vala"
							_tmp73_ = orred;
#line 171 "../lib/synapse-core/query.vala"
							_tmp74_ = g_strconcat (_tmp72_, _tmp73_, NULL);
#line 171 "../lib/synapse-core/query.vala"
							_g_free0 (any_order);
#line 171 "../lib/synapse-core/query.vala"
							any_order = _tmp74_;
#line 172 "../lib/synapse-core/query.vala"
							if (!is_last) {
#line 1370 "query.c"
								const gchar* _tmp75_;
								gchar* _tmp76_;
#line 173 "../lib/synapse-core/query.vala"
								_tmp75_ = any_order;
#line 173 "../lib/synapse-core/query.vala"
								_tmp76_ = g_strconcat (_tmp75_, ".+", NULL);
#line 173 "../lib/synapse-core/query.vala"
								_g_free0 (any_order);
#line 173 "../lib/synapse-core/query.vala"
								any_order = _tmp76_;
#line 1381 "query.c"
							}
						}
					}
				}
				{
					GRegex* _tmp77_ = NULL;
					const gchar* _tmp78_;
					GRegex* _tmp79_;
					GRegex* _tmp80_;
					GRegex* _tmp81_;
#line 177 "../lib/synapse-core/query.vala"
					_tmp78_ = any_order;
#line 177 "../lib/synapse-core/query.vala"
					_tmp79_ = g_regex_new (_tmp78_, flags, 0, &_inner_error0_);
#line 177 "../lib/synapse-core/query.vala"
					_tmp77_ = _tmp79_;
#line 177 "../lib/synapse-core/query.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 177 "../lib/synapse-core/query.vala"
						if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1402 "query.c"
							goto __catch5_g_regex_error;
						}
#line 177 "../lib/synapse-core/query.vala"
						_g_free0 (any_order);
#line 177 "../lib/synapse-core/query.vala"
						_g_free0 (orred);
#line 177 "../lib/synapse-core/query.vala"
						_g_free0 (pattern);
#line 177 "../lib/synapse-core/query.vala"
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 177 "../lib/synapse-core/query.vala"
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 177 "../lib/synapse-core/query.vala"
						_g_regex_unref0 (re);
#line 177 "../lib/synapse-core/query.vala"
						_g_object_unref0 (results);
#line 177 "../lib/synapse-core/query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 177 "../lib/synapse-core/query.vala"
						g_clear_error (&_inner_error0_);
#line 177 "../lib/synapse-core/query.vala"
						return NULL;
#line 1425 "query.c"
					}
#line 177 "../lib/synapse-core/query.vala"
					_tmp80_ = _tmp77_;
#line 177 "../lib/synapse-core/query.vala"
					_tmp77_ = NULL;
#line 177 "../lib/synapse-core/query.vala"
					_g_regex_unref0 (re);
#line 177 "../lib/synapse-core/query.vala"
					re = _tmp80_;
#line 178 "../lib/synapse-core/query.vala"
					_tmp81_ = re;
#line 178 "../lib/synapse-core/query.vala"
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp81_, (gpointer) ((gintptr) ((gint) (SYNAPSE_MATCH_SCORE_AVERAGE + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR))));
#line 176 "../lib/synapse-core/query.vala"
					_g_regex_unref0 (_tmp77_);
#line 1441 "query.c"
				}
				goto __finally5;
				__catch5_g_regex_error:
				{
#line 176 "../lib/synapse-core/query.vala"
					g_clear_error (&_inner_error0_);
#line 1448 "query.c"
				}
				__finally5:
#line 176 "../lib/synapse-core/query.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 176 "../lib/synapse-core/query.vala"
					_g_free0 (any_order);
#line 176 "../lib/synapse-core/query.vala"
					_g_free0 (orred);
#line 176 "../lib/synapse-core/query.vala"
					_g_free0 (pattern);
#line 176 "../lib/synapse-core/query.vala"
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 176 "../lib/synapse-core/query.vala"
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 176 "../lib/synapse-core/query.vala"
					_g_regex_unref0 (re);
#line 176 "../lib/synapse-core/query.vala"
					_g_object_unref0 (results);
#line 176 "../lib/synapse-core/query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 176 "../lib/synapse-core/query.vala"
					g_clear_error (&_inner_error0_);
#line 176 "../lib/synapse-core/query.vala"
					return NULL;
#line 1473 "query.c"
				}
#line 159 "../lib/synapse-core/query.vala"
				_g_free0 (any_order);
#line 159 "../lib/synapse-core/query.vala"
				_g_free0 (orred);
#line 1479 "query.c"
			}
		}
#line 145 "../lib/synapse-core/query.vala"
		_g_free0 (pattern);
#line 145 "../lib/synapse-core/query.vala"
		escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 1486 "query.c"
	}
#line 184 "../lib/synapse-core/query.vala"
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING) == SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING)) {
#line 1490 "query.c"
		{
			GRegex* _tmp82_ = NULL;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			GRegex* _tmp87_;
			GRegex* _tmp88_;
			GRegex* _tmp89_;
			GRegex* _tmp90_;
#line 186 "../lib/synapse-core/query.vala"
			_tmp83_ = g_regex_escape_string (query, -1);
#line 186 "../lib/synapse-core/query.vala"
			_tmp84_ = _tmp83_;
#line 186 "../lib/synapse-core/query.vala"
			_tmp85_ = g_strdup_printf ("(%s)", _tmp84_);
#line 186 "../lib/synapse-core/query.vala"
			_tmp86_ = _tmp85_;
#line 186 "../lib/synapse-core/query.vala"
			_tmp87_ = g_regex_new (_tmp86_, flags, 0, &_inner_error0_);
#line 186 "../lib/synapse-core/query.vala"
			_tmp88_ = _tmp87_;
#line 186 "../lib/synapse-core/query.vala"
			_g_free0 (_tmp86_);
#line 186 "../lib/synapse-core/query.vala"
			_g_free0 (_tmp84_);
#line 186 "../lib/synapse-core/query.vala"
			_tmp82_ = _tmp88_;
#line 186 "../lib/synapse-core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 186 "../lib/synapse-core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1523 "query.c"
					goto __catch6_g_regex_error;
				}
#line 186 "../lib/synapse-core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 186 "../lib/synapse-core/query.vala"
				_g_regex_unref0 (re);
#line 186 "../lib/synapse-core/query.vala"
				_g_object_unref0 (results);
#line 186 "../lib/synapse-core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 186 "../lib/synapse-core/query.vala"
				g_clear_error (&_inner_error0_);
#line 186 "../lib/synapse-core/query.vala"
				return NULL;
#line 1538 "query.c"
			}
#line 186 "../lib/synapse-core/query.vala"
			_tmp89_ = _tmp82_;
#line 186 "../lib/synapse-core/query.vala"
			_tmp82_ = NULL;
#line 186 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 186 "../lib/synapse-core/query.vala"
			re = _tmp89_;
#line 187 "../lib/synapse-core/query.vala"
			_tmp90_ = re;
#line 187 "../lib/synapse-core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp90_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_BELOW_AVERAGE)));
#line 185 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (_tmp82_);
#line 1554 "query.c"
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
#line 185 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1561 "query.c"
		}
		__finally6:
#line 185 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "../lib/synapse-core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 185 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 185 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 185 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 185 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 185 "../lib/synapse-core/query.vala"
			return NULL;
#line 1578 "query.c"
		}
	}
#line 192 "../lib/synapse-core/query.vala"
	_tmp92_ = _tmp91_ = g_regex_split_simple ("\\s*", query, 0, 0);
#line 192 "../lib/synapse-core/query.vala"
	individual_chars = _tmp92_;
#line 192 "../lib/synapse-core/query.vala"
	individual_chars_length1 = _vala_array_length (_tmp91_);
#line 192 "../lib/synapse-core/query.vala"
	_individual_chars_size_ = individual_chars_length1;
#line 193 "../lib/synapse-core/query.vala"
	_tmp93_ = g_new0 (gchar*, 0 + 1);
#line 193 "../lib/synapse-core/query.vala"
	escaped_chars = _tmp93_;
#line 193 "../lib/synapse-core/query.vala"
	escaped_chars_length1 = 0;
#line 193 "../lib/synapse-core/query.vala"
	_escaped_chars_size_ = escaped_chars_length1;
#line 194 "../lib/synapse-core/query.vala"
	_tmp94_ = individual_chars;
#line 194 "../lib/synapse-core/query.vala"
	_tmp94__length1 = individual_chars_length1;
#line 1601 "query.c"
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
#line 194 "../lib/synapse-core/query.vala"
		word_collection = _tmp94_;
#line 194 "../lib/synapse-core/query.vala"
		word_collection_length1 = _tmp94__length1;
#line 194 "../lib/synapse-core/query.vala"
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
#line 1613 "query.c"
			const gchar* word = NULL;
#line 194 "../lib/synapse-core/query.vala"
			word = word_collection[word_it];
#line 1617 "query.c"
			{
				const gchar* _tmp95_;
				gchar* _tmp96_;
#line 195 "../lib/synapse-core/query.vala"
				_tmp95_ = word;
#line 195 "../lib/synapse-core/query.vala"
				_tmp96_ = g_regex_escape_string (_tmp95_, -1);
#line 195 "../lib/synapse-core/query.vala"
				_vala_array_add7 (&escaped_chars, &escaped_chars_length1, &_escaped_chars_size_, _tmp96_);
#line 1627 "query.c"
			}
		}
	}
#line 199 "../lib/synapse-core/query.vala"
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) == SYNAPSE_MATCHER_FLAGS_NO_PARTIAL)) {
#line 1633 "query.c"
		gchar** _tmp99_;
		gint _tmp99__length1;
#line 199 "../lib/synapse-core/query.vala"
		_tmp99_ = individual_words;
#line 199 "../lib/synapse-core/query.vala"
		_tmp99__length1 = individual_words_length1;
#line 199 "../lib/synapse-core/query.vala"
		_tmp98_ = _tmp99__length1 == 1;
#line 1642 "query.c"
	} else {
#line 199 "../lib/synapse-core/query.vala"
		_tmp98_ = FALSE;
#line 1646 "query.c"
	}
#line 199 "../lib/synapse-core/query.vala"
	if (_tmp98_) {
#line 1650 "query.c"
		gchar** _tmp100_;
		gint _tmp100__length1;
#line 199 "../lib/synapse-core/query.vala"
		_tmp100_ = individual_chars;
#line 199 "../lib/synapse-core/query.vala"
		_tmp100__length1 = individual_chars_length1;
#line 199 "../lib/synapse-core/query.vala"
		_tmp97_ = _tmp100__length1 <= 5;
#line 1659 "query.c"
	} else {
#line 199 "../lib/synapse-core/query.vala"
		_tmp97_ = FALSE;
#line 1663 "query.c"
	}
#line 199 "../lib/synapse-core/query.vala"
	if (_tmp97_) {
#line 1667 "query.c"
		gchar* pattern = NULL;
		gchar** _tmp101_;
		gint _tmp101__length1;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
#line 200 "../lib/synapse-core/query.vala"
		_tmp101_ = escaped_chars;
#line 200 "../lib/synapse-core/query.vala"
		_tmp101__length1 = escaped_chars_length1;
#line 200 "../lib/synapse-core/query.vala"
		_tmp102_ = _vala_g_strjoinv (").+\\b(", _tmp101_, (gint) _tmp101__length1);
#line 200 "../lib/synapse-core/query.vala"
		_tmp103_ = _tmp102_;
#line 200 "../lib/synapse-core/query.vala"
		_tmp104_ = g_strdup_printf ("\\b(%s)", _tmp103_);
#line 200 "../lib/synapse-core/query.vala"
		_tmp105_ = _tmp104_;
#line 200 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp103_);
#line 200 "../lib/synapse-core/query.vala"
		pattern = _tmp105_;
#line 1691 "query.c"
		{
			GRegex* _tmp106_ = NULL;
			const gchar* _tmp107_;
			GRegex* _tmp108_;
			GRegex* _tmp109_;
			GRegex* _tmp110_;
#line 203 "../lib/synapse-core/query.vala"
			_tmp107_ = pattern;
#line 203 "../lib/synapse-core/query.vala"
			_tmp108_ = g_regex_new (_tmp107_, flags, 0, &_inner_error0_);
#line 203 "../lib/synapse-core/query.vala"
			_tmp106_ = _tmp108_;
#line 203 "../lib/synapse-core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 203 "../lib/synapse-core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1708 "query.c"
					goto __catch7_g_regex_error;
				}
#line 203 "../lib/synapse-core/query.vala"
				_g_free0 (pattern);
#line 203 "../lib/synapse-core/query.vala"
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 203 "../lib/synapse-core/query.vala"
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 203 "../lib/synapse-core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 203 "../lib/synapse-core/query.vala"
				_g_regex_unref0 (re);
#line 203 "../lib/synapse-core/query.vala"
				_g_object_unref0 (results);
#line 203 "../lib/synapse-core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 203 "../lib/synapse-core/query.vala"
				g_clear_error (&_inner_error0_);
#line 203 "../lib/synapse-core/query.vala"
				return NULL;
#line 1729 "query.c"
			}
#line 203 "../lib/synapse-core/query.vala"
			_tmp109_ = _tmp106_;
#line 203 "../lib/synapse-core/query.vala"
			_tmp106_ = NULL;
#line 203 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 203 "../lib/synapse-core/query.vala"
			re = _tmp109_;
#line 204 "../lib/synapse-core/query.vala"
			_tmp110_ = re;
#line 204 "../lib/synapse-core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp110_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE)));
#line 202 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (_tmp106_);
#line 1745 "query.c"
		}
		goto __finally7;
		__catch7_g_regex_error:
		{
#line 202 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1752 "query.c"
		}
		__finally7:
#line 202 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 202 "../lib/synapse-core/query.vala"
			_g_free0 (pattern);
#line 202 "../lib/synapse-core/query.vala"
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 202 "../lib/synapse-core/query.vala"
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 202 "../lib/synapse-core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 202 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 202 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 202 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 202 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 202 "../lib/synapse-core/query.vala"
			return NULL;
#line 1775 "query.c"
		}
#line 199 "../lib/synapse-core/query.vala"
		_g_free0 (pattern);
#line 1779 "query.c"
	}
#line 208 "../lib/synapse-core/query.vala"
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_FUZZY) == SYNAPSE_MATCHER_FLAGS_NO_FUZZY)) {
#line 1783 "query.c"
		gchar** _tmp112_;
		gint _tmp112__length1;
#line 208 "../lib/synapse-core/query.vala"
		_tmp112_ = escaped_chars;
#line 208 "../lib/synapse-core/query.vala"
		_tmp112__length1 = escaped_chars_length1;
#line 208 "../lib/synapse-core/query.vala"
		_tmp111_ = _tmp112__length1 > 0;
#line 1792 "query.c"
	} else {
#line 208 "../lib/synapse-core/query.vala"
		_tmp111_ = FALSE;
#line 1796 "query.c"
	}
#line 208 "../lib/synapse-core/query.vala"
	if (_tmp111_) {
#line 1800 "query.c"
		gchar* pattern = NULL;
		gchar** _tmp113_;
		gint _tmp113__length1;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
#line 209 "../lib/synapse-core/query.vala"
		_tmp113_ = escaped_chars;
#line 209 "../lib/synapse-core/query.vala"
		_tmp113__length1 = escaped_chars_length1;
#line 209 "../lib/synapse-core/query.vala"
		_tmp114_ = _vala_g_strjoinv (").*(", _tmp113_, (gint) _tmp113__length1);
#line 209 "../lib/synapse-core/query.vala"
		_tmp115_ = _tmp114_;
#line 209 "../lib/synapse-core/query.vala"
		_tmp116_ = g_strdup_printf ("\\b(%s)", _tmp115_);
#line 209 "../lib/synapse-core/query.vala"
		_tmp117_ = _tmp116_;
#line 209 "../lib/synapse-core/query.vala"
		_g_free0 (_tmp115_);
#line 209 "../lib/synapse-core/query.vala"
		pattern = _tmp117_;
#line 1824 "query.c"
		{
			GRegex* _tmp118_ = NULL;
			const gchar* _tmp119_;
			GRegex* _tmp120_;
			GRegex* _tmp121_;
			GRegex* _tmp122_;
#line 212 "../lib/synapse-core/query.vala"
			_tmp119_ = pattern;
#line 212 "../lib/synapse-core/query.vala"
			_tmp120_ = g_regex_new (_tmp119_, flags, 0, &_inner_error0_);
#line 212 "../lib/synapse-core/query.vala"
			_tmp118_ = _tmp120_;
#line 212 "../lib/synapse-core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 212 "../lib/synapse-core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1841 "query.c"
					goto __catch8_g_regex_error;
				}
#line 212 "../lib/synapse-core/query.vala"
				_g_free0 (pattern);
#line 212 "../lib/synapse-core/query.vala"
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 212 "../lib/synapse-core/query.vala"
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 212 "../lib/synapse-core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 212 "../lib/synapse-core/query.vala"
				_g_regex_unref0 (re);
#line 212 "../lib/synapse-core/query.vala"
				_g_object_unref0 (results);
#line 212 "../lib/synapse-core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 212 "../lib/synapse-core/query.vala"
				g_clear_error (&_inner_error0_);
#line 212 "../lib/synapse-core/query.vala"
				return NULL;
#line 1862 "query.c"
			}
#line 212 "../lib/synapse-core/query.vala"
			_tmp121_ = _tmp118_;
#line 212 "../lib/synapse-core/query.vala"
			_tmp118_ = NULL;
#line 212 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 212 "../lib/synapse-core/query.vala"
			re = _tmp121_;
#line 213 "../lib/synapse-core/query.vala"
			_tmp122_ = re;
#line 213 "../lib/synapse-core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp122_, (gpointer) ((gintptr) ((gint) SYNAPSE_MATCH_SCORE_POOR)));
#line 211 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (_tmp118_);
#line 1878 "query.c"
		}
		goto __finally8;
		__catch8_g_regex_error:
		{
#line 211 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1885 "query.c"
		}
		__finally8:
#line 211 "../lib/synapse-core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 211 "../lib/synapse-core/query.vala"
			_g_free0 (pattern);
#line 211 "../lib/synapse-core/query.vala"
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 211 "../lib/synapse-core/query.vala"
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 211 "../lib/synapse-core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 211 "../lib/synapse-core/query.vala"
			_g_regex_unref0 (re);
#line 211 "../lib/synapse-core/query.vala"
			_g_object_unref0 (results);
#line 211 "../lib/synapse-core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 211 "../lib/synapse-core/query.vala"
			g_clear_error (&_inner_error0_);
#line 211 "../lib/synapse-core/query.vala"
			return NULL;
#line 1908 "query.c"
		}
#line 208 "../lib/synapse-core/query.vala"
		_g_free0 (pattern);
#line 1912 "query.c"
	}
#line 217 "../lib/synapse-core/query.vala"
	_tmp123_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 217 "../lib/synapse-core/query.vala"
	sorted_results = _tmp123_;
#line 218 "../lib/synapse-core/query.vala"
	_tmp124_ = gee_abstract_map_get_entries ((GeeAbstractMap*) results);
#line 218 "../lib/synapse-core/query.vala"
	_tmp125_ = _tmp124_;
#line 218 "../lib/synapse-core/query.vala"
	entries = _tmp125_;
#line 220 "../lib/synapse-core/query.vala"
	_tmp126_ = _g_object_ref0 (entries);
#line 220 "../lib/synapse-core/query.vala"
	g_object_set_data_full ((GObject*) sorted_results, "entries-ref", _tmp126_, g_object_unref);
#line 221 "../lib/synapse-core/query.vala"
	gee_array_list_add_all (sorted_results, (GeeCollection*) entries);
#line 222 "../lib/synapse-core/query.vala"
	gee_list_sort ((GeeList*) sorted_results, ___lambda5__gcompare_data_func, NULL, NULL);
#line 228 "../lib/synapse-core/query.vala"
	result = (GeeList*) sorted_results;
#line 228 "../lib/synapse-core/query.vala"
	_g_object_unref0 (entries);
#line 228 "../lib/synapse-core/query.vala"
	escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 228 "../lib/synapse-core/query.vala"
	individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 228 "../lib/synapse-core/query.vala"
	individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 228 "../lib/synapse-core/query.vala"
	_g_regex_unref0 (re);
#line 228 "../lib/synapse-core/query.vala"
	_g_object_unref0 (results);
#line 228 "../lib/synapse-core/query.vala"
	return result;
#line 1948 "query.c"
}

void
synapse_query_copy (const SynapseQuery* self,
                    SynapseQuery* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	SynapseQueryFlags _tmp6_;
#line 85 "../lib/synapse-core/query.vala"
	_tmp0_ = (*self).query_string;
#line 85 "../lib/synapse-core/query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 85 "../lib/synapse-core/query.vala"
	_g_free0 ((*dest).query_string);
#line 85 "../lib/synapse-core/query.vala"
	(*dest).query_string = _tmp1_;
#line 85 "../lib/synapse-core/query.vala"
	_tmp2_ = (*self).query_string_folded;
#line 85 "../lib/synapse-core/query.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 85 "../lib/synapse-core/query.vala"
	_g_free0 ((*dest).query_string_folded);
#line 85 "../lib/synapse-core/query.vala"
	(*dest).query_string_folded = _tmp3_;
#line 85 "../lib/synapse-core/query.vala"
	_tmp4_ = (*self).cancellable;
#line 85 "../lib/synapse-core/query.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 85 "../lib/synapse-core/query.vala"
	_g_object_unref0 ((*dest).cancellable);
#line 85 "../lib/synapse-core/query.vala"
	(*dest).cancellable = _tmp5_;
#line 85 "../lib/synapse-core/query.vala"
	_tmp6_ = (*self).query_type;
#line 85 "../lib/synapse-core/query.vala"
	(*dest).query_type = _tmp6_;
#line 85 "../lib/synapse-core/query.vala"
	(*dest).max_results = (*self).max_results;
#line 85 "../lib/synapse-core/query.vala"
	(*dest).query_id = (*self).query_id;
#line 1994 "query.c"
}

void
synapse_query_destroy (SynapseQuery* self)
{
#line 86 "../lib/synapse-core/query.vala"
	_g_free0 ((*self).query_string);
#line 87 "../lib/synapse-core/query.vala"
	_g_free0 ((*self).query_string_folded);
#line 88 "../lib/synapse-core/query.vala"
	_g_object_unref0 ((*self).cancellable);
#line 2006 "query.c"
}

SynapseQuery*
synapse_query_dup (const SynapseQuery* self)
{
	SynapseQuery* dup;
#line 85 "../lib/synapse-core/query.vala"
	dup = g_new0 (SynapseQuery, 1);
#line 85 "../lib/synapse-core/query.vala"
	synapse_query_copy (self, dup);
#line 85 "../lib/synapse-core/query.vala"
	return dup;
#line 2019 "query.c"
}

void
synapse_query_free (SynapseQuery* self)
{
#line 85 "../lib/synapse-core/query.vala"
	synapse_query_destroy (self);
#line 85 "../lib/synapse-core/query.vala"
	g_free (self);
#line 2029 "query.c"
}

static GType
synapse_query_get_type_once (void)
{
	GType synapse_query_type_id;
	synapse_query_type_id = g_boxed_type_register_static ("SynapseQuery", (GBoxedCopyFunc) synapse_query_dup, (GBoxedFreeFunc) synapse_query_free);
	return synapse_query_type_id;
}

GType
synapse_query_get_type (void)
{
	static volatile gsize synapse_query_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_type_id__volatile)) {
		GType synapse_query_type_id;
		synapse_query_type_id = synapse_query_get_type_once ();
		g_once_init_leave (&synapse_query_type_id__volatile, synapse_query_type_id);
	}
	return synapse_query_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2059 "query.c"
		gint i;
#line 284 "../lib/synapse-core/data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 284 "../lib/synapse-core/data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 284 "../lib/synapse-core/data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2067 "query.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 284 "../lib/synapse-core/data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 284 "../lib/synapse-core/data-sink.vala"
	g_free (array);
#line 2082 "query.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 284 "../lib/synapse-core/data-sink.vala"
	if (array) {
#line 284 "../lib/synapse-core/data-sink.vala"
		while (((gpointer*) array)[length]) {
#line 284 "../lib/synapse-core/data-sink.vala"
			length++;
#line 2096 "query.c"
		}
	}
#line 284 "../lib/synapse-core/data-sink.vala"
	return length;
#line 2101 "query.c"
}

