/* match.c generated by valac 0.48.13, the Vala compiler
 * generated from match.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*              Alberto Aldegheri <albyrock87+dev@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

typedef enum  {
	SYNAPSE_MATCH_TYPE_UNKNOWN = 0,
	SYNAPSE_MATCH_TYPE_TEXT,
	SYNAPSE_MATCH_TYPE_APPLICATION,
	SYNAPSE_MATCH_TYPE_GENERIC_URI,
	SYNAPSE_MATCH_TYPE_ACTION,
	SYNAPSE_MATCH_TYPE_SEARCH,
	SYNAPSE_MATCH_TYPE_CONTACT,
	SYNAPSE_MATCH_TYPE_INTERNET
} SynapseMatchType;

#define SYNAPSE_TYPE_MATCH_TYPE (synapse_match_type_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchIface))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchIface SynapseMatchIface;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_MATCH_TYPE_SCORE (synapse_match_score_get_type ())
enum  {
	SYNAPSE_MATCH_EXECUTED_SIGNAL,
	SYNAPSE_MATCH_NUM_SIGNALS
};
static guint synapse_match_signals[SYNAPSE_MATCH_NUM_SIGNALS] = {0};

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchIface))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchIface SynapseApplicationMatchIface;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchIface))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchIface SynapseUriMatchIface;

#define SYNAPSE_TYPE_CONTACT_MATCH (synapse_contact_match_get_type ())
#define SYNAPSE_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatch))
#define SYNAPSE_IS_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONTACT_MATCH))
#define SYNAPSE_CONTACT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatchIface))

typedef struct _SynapseContactMatch SynapseContactMatch;
typedef struct _SynapseContactMatchIface SynapseContactMatchIface;

#define SYNAPSE_TYPE_EXTENDED_INFO (synapse_extended_info_get_type ())
#define SYNAPSE_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo))
#define SYNAPSE_IS_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_EXTENDED_INFO))
#define SYNAPSE_EXTENDED_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfoIface))

typedef struct _SynapseExtendedInfo SynapseExtendedInfo;
typedef struct _SynapseExtendedInfoIface SynapseExtendedInfoIface;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchIface))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchIface SynapseTextMatchIface;

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchIface))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchIface SynapseSearchMatchIface;

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_DEFAULT_MATCH (synapse_default_match_get_type ())
#define SYNAPSE_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch))
#define SYNAPSE_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))
#define SYNAPSE_IS_DEFAULT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_IS_DEFAULT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEFAULT_MATCH))
#define SYNAPSE_DEFAULT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatchClass))

typedef struct _SynapseDefaultMatch SynapseDefaultMatch;
typedef struct _SynapseDefaultMatchClass SynapseDefaultMatchClass;
typedef struct _SynapseDefaultMatchPrivate SynapseDefaultMatchPrivate;
enum  {
	SYNAPSE_DEFAULT_MATCH_0_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY,
	SYNAPSE_DEFAULT_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseMatchIface {
	GTypeInterface parent_iface;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
	const gchar* (*get_title) (SynapseMatch* self);
	void (*set_title) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_description) (SynapseMatch* self);
	void (*set_description) (SynapseMatch* self, const gchar* value);
	const gchar* (*get_icon_name) (SynapseMatch* self);
	void (*set_icon_name) (SynapseMatch* self, const gchar* value);
	gboolean (*get_has_thumbnail) (SynapseMatch* self);
	void (*set_has_thumbnail) (SynapseMatch* self, gboolean value);
	const gchar* (*get_thumbnail_path) (SynapseMatch* self);
	void (*set_thumbnail_path) (SynapseMatch* self, const gchar* value);
	SynapseMatchType (*get_match_type) (SynapseMatch* self);
	void (*set_match_type) (SynapseMatch* self, SynapseMatchType value);
};

struct _SynapseApplicationMatchIface {
	GTypeInterface parent_iface;
	GAppInfo* (*get_app_info) (SynapseApplicationMatch* self);
	void (*set_app_info) (SynapseApplicationMatch* self, GAppInfo* value);
	gboolean (*get_needs_terminal) (SynapseApplicationMatch* self);
	void (*set_needs_terminal) (SynapseApplicationMatch* self, gboolean value);
	const gchar* (*get_filename) (SynapseApplicationMatch* self);
	void (*set_filename) (SynapseApplicationMatch* self, const gchar* value);
};

struct _SynapseUriMatchIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (SynapseUriMatch* self);
	void (*set_uri) (SynapseUriMatch* self, const gchar* value);
	SynapseQueryFlags (*get_file_type) (SynapseUriMatch* self);
	void (*set_file_type) (SynapseUriMatch* self, SynapseQueryFlags value);
	const gchar* (*get_mime_type) (SynapseUriMatch* self);
	void (*set_mime_type) (SynapseUriMatch* self, const gchar* value);
};

struct _SynapseContactMatchIface {
	GTypeInterface parent_iface;
	void (*send_message) (SynapseContactMatch* self, const gchar* message, gboolean present);
	void (*open_chat) (SynapseContactMatch* self);
};

struct _SynapseExtendedInfoIface {
	GTypeInterface parent_iface;
	const gchar* (*get_extended_info) (SynapseExtendedInfo* self);
	void (*set_extended_info) (SynapseExtendedInfo* self, const gchar* value);
};

struct _SynapseTextMatchIface {
	GTypeInterface parent_iface;
	gchar* (*get_text) (SynapseTextMatch* self);
	SynapseTextOrigin (*get_text_origin) (SynapseTextMatch* self);
	void (*set_text_origin) (SynapseTextMatch* self, SynapseTextOrigin value);
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatchIface {
	GTypeInterface parent_iface;
	SynapseMatch* (*get_search_source) (SynapseSearchMatch* self);
	void (*set_search_source) (SynapseSearchMatch* self, SynapseMatch* value);
};

struct _SynapseDefaultMatch {
	GObject parent_instance;
	SynapseDefaultMatchPrivate * priv;
};

struct _SynapseDefaultMatchClass {
	GObjectClass parent_class;
};

struct _SynapseDefaultMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
	SynapseMatchType _match_type;
};

static gint SynapseDefaultMatch_private_offset;
static gpointer synapse_default_match_parent_class = NULL;
static SynapseMatchIface * synapse_default_match_synapse_match_parent_iface = NULL;

GType synapse_match_type_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
GType synapse_match_score_get_type (void) G_GNUC_CONST;
void synapse_match_execute (SynapseMatch* self,
                            SynapseMatch* match);
static void synapse_match_real_execute (SynapseMatch* self,
                                 SynapseMatch* match);
void synapse_utils_logger_error (GObject* obj,
                                 const gchar* format,
                                 ...);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
static void synapse_match_real_execute_with_target (SynapseMatch* self,
                                             SynapseMatch* source,
                                             SynapseMatch* target);
gboolean synapse_match_needs_target (SynapseMatch* self);
static gboolean synapse_match_real_needs_target (SynapseMatch* self);
SynapseQueryFlags synapse_match_target_flags (SynapseMatch* self);
static SynapseQueryFlags synapse_match_real_target_flags (SynapseMatch* self);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
SynapseMatchType synapse_match_get_match_type (SynapseMatch* self);
void synapse_match_set_match_type (SynapseMatch* self,
                                   SynapseMatchType value);
static GType synapse_match_get_type_once (void);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                             GAppInfo* value);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                                   gboolean value);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
void synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                             const gchar* value);
static GType synapse_application_match_get_type_once (void);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static GType synapse_uri_match_get_type_once (void);
GType synapse_contact_match_get_type (void) G_GNUC_CONST;
void synapse_contact_match_send_message (SynapseContactMatch* self,
                                         const gchar* message,
                                         gboolean present);
void synapse_contact_match_open_chat (SynapseContactMatch* self);
static GType synapse_contact_match_get_type_once (void);
GType synapse_extended_info_get_type (void) G_GNUC_CONST;
const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self);
void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                              const gchar* value);
static GType synapse_extended_info_get_type_once (void);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
void synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                         SynapseTextOrigin value);
static GType synapse_text_match_get_type_once (void);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
GType synapse_search_match_get_type (void) G_GNUC_CONST;
SynapseMatch* synapse_search_match_get_search_source (SynapseSearchMatch* self);
void synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                             SynapseMatch* value);
static GType synapse_search_match_get_type_once (void);
GType synapse_default_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDefaultMatch, g_object_unref)
SynapseDefaultMatch* synapse_default_match_new (const gchar* query_string);
SynapseDefaultMatch* synapse_default_match_construct (GType object_type,
                                                      const gchar* query_string);
static void synapse_default_match_finalize (GObject * obj);
static GType synapse_default_match_get_type_once (void);
static void _vala_synapse_default_match_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_synapse_default_match_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static GType
synapse_match_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_MATCH_TYPE_UNKNOWN, "SYNAPSE_MATCH_TYPE_UNKNOWN", "unknown"}, {SYNAPSE_MATCH_TYPE_TEXT, "SYNAPSE_MATCH_TYPE_TEXT", "text"}, {SYNAPSE_MATCH_TYPE_APPLICATION, "SYNAPSE_MATCH_TYPE_APPLICATION", "application"}, {SYNAPSE_MATCH_TYPE_GENERIC_URI, "SYNAPSE_MATCH_TYPE_GENERIC_URI", "generic-uri"}, {SYNAPSE_MATCH_TYPE_ACTION, "SYNAPSE_MATCH_TYPE_ACTION", "action"}, {SYNAPSE_MATCH_TYPE_SEARCH, "SYNAPSE_MATCH_TYPE_SEARCH", "search"}, {SYNAPSE_MATCH_TYPE_CONTACT, "SYNAPSE_MATCH_TYPE_CONTACT", "contact"}, {SYNAPSE_MATCH_TYPE_INTERNET, "SYNAPSE_MATCH_TYPE_INTERNET", "internet"}, {0, NULL, NULL}};
	GType synapse_match_type_type_id;
	synapse_match_type_type_id = g_enum_register_static ("SynapseMatchType", values);
	return synapse_match_type_type_id;
}

GType
synapse_match_type_get_type (void)
{
	static volatile gsize synapse_match_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_type_id__volatile)) {
		GType synapse_match_type_type_id;
		synapse_match_type_type_id = synapse_match_type_get_type_once ();
		g_once_init_leave (&synapse_match_type_type_id__volatile, synapse_match_type_type_id);
	}
	return synapse_match_type_type_id__volatile;
}

static GType
synapse_match_score_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, "SYNAPSE_MATCH_SCORE_INCREMENT_MINOR", "increment-minor"}, {SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, "SYNAPSE_MATCH_SCORE_INCREMENT_SMALL", "increment-small"}, {SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM, "SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM", "increment-medium"}, {SYNAPSE_MATCH_SCORE_INCREMENT_LARGE, "SYNAPSE_MATCH_SCORE_INCREMENT_LARGE", "increment-large"}, {SYNAPSE_MATCH_SCORE_URI_PENALTY, "SYNAPSE_MATCH_SCORE_URI_PENALTY", "uri-penalty"}, {SYNAPSE_MATCH_SCORE_POOR, "SYNAPSE_MATCH_SCORE_POOR", "poor"}, {SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, "SYNAPSE_MATCH_SCORE_BELOW_AVERAGE", "below-average"}, {SYNAPSE_MATCH_SCORE_AVERAGE, "SYNAPSE_MATCH_SCORE_AVERAGE", "average"}, {SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE, "SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE", "above-average"}, {SYNAPSE_MATCH_SCORE_GOOD, "SYNAPSE_MATCH_SCORE_GOOD", "good"}, {SYNAPSE_MATCH_SCORE_VERY_GOOD, "SYNAPSE_MATCH_SCORE_VERY_GOOD", "very-good"}, {SYNAPSE_MATCH_SCORE_EXCELLENT, "SYNAPSE_MATCH_SCORE_EXCELLENT", "excellent"}, {SYNAPSE_MATCH_SCORE_HIGHEST, "SYNAPSE_MATCH_SCORE_HIGHEST", "highest"}, {0, NULL, NULL}};
	GType synapse_match_score_type_id;
	synapse_match_score_type_id = g_enum_register_static ("SynapseMatchScore", values);
	return synapse_match_score_type_id;
}

GType
synapse_match_score_get_type (void)
{
	static volatile gsize synapse_match_score_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_score_type_id__volatile)) {
		GType synapse_match_score_type_id;
		synapse_match_score_type_id = synapse_match_score_get_type_once ();
		g_once_init_leave (&synapse_match_score_type_id__volatile, synapse_match_score_type_id);
	}
	return synapse_match_score_type_id__volatile;
}

static void
synapse_match_real_execute (SynapseMatch* self,
                            SynapseMatch* match)
{
#line 64 "../lib/synapse-core/match.vala"
	synapse_utils_logger_error ((GObject*) self, "execute () is not implemented", NULL);
#line 443 "match.c"
}

void
synapse_match_execute (SynapseMatch* self,
                       SynapseMatch* match)
{
#line 63 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 63 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->execute (self, match);
#line 454 "match.c"
}

static void
synapse_match_real_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target)
{
#line 68 "../lib/synapse-core/match.vala"
	if (target == NULL) {
#line 69 "../lib/synapse-core/match.vala"
		synapse_match_execute (self, source);
#line 466 "match.c"
	} else {
#line 71 "../lib/synapse-core/match.vala"
		synapse_utils_logger_error ((GObject*) self, "execute () is not implemented", NULL);
#line 470 "match.c"
	}
}

void
synapse_match_execute_with_target (SynapseMatch* self,
                                   SynapseMatch* source,
                                   SynapseMatch* target)
{
#line 67 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 67 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->execute_with_target (self, source, target);
#line 483 "match.c"
}

static gboolean
synapse_match_real_needs_target (SynapseMatch* self)
{
	gboolean result = FALSE;
#line 76 "../lib/synapse-core/match.vala"
	result = FALSE;
#line 76 "../lib/synapse-core/match.vala"
	return result;
#line 494 "match.c"
}

gboolean
synapse_match_needs_target (SynapseMatch* self)
{
#line 75 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 75 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->needs_target (self);
#line 504 "match.c"
}

static SynapseQueryFlags
synapse_match_real_target_flags (SynapseMatch* self)
{
	SynapseQueryFlags result = 0U;
#line 80 "../lib/synapse-core/match.vala"
	result = SYNAPSE_QUERY_FLAGS_ALL;
#line 80 "../lib/synapse-core/match.vala"
	return result;
#line 515 "match.c"
}

SynapseQueryFlags
synapse_match_target_flags (SynapseMatch* self)
{
#line 79 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 79 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->target_flags (self);
#line 525 "match.c"
}

const gchar*
synapse_match_get_title (SynapseMatch* self)
{
#line 56 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_title (self);
#line 535 "match.c"
}

void
synapse_match_set_title (SynapseMatch* self,
                         const gchar* value)
{
#line 56 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 56 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_title (self, value);
#line 546 "match.c"
}

const gchar*
synapse_match_get_description (SynapseMatch* self)
{
#line 57 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_description (self);
#line 556 "match.c"
}

void
synapse_match_set_description (SynapseMatch* self,
                               const gchar* value)
{
#line 57 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 57 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_description (self, value);
#line 567 "match.c"
}

const gchar*
synapse_match_get_icon_name (SynapseMatch* self)
{
#line 58 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_icon_name (self);
#line 577 "match.c"
}

void
synapse_match_set_icon_name (SynapseMatch* self,
                             const gchar* value)
{
#line 58 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 58 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_icon_name (self, value);
#line 588 "match.c"
}

gboolean
synapse_match_get_has_thumbnail (SynapseMatch* self)
{
#line 59 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_has_thumbnail (self);
#line 598 "match.c"
}

void
synapse_match_set_has_thumbnail (SynapseMatch* self,
                                 gboolean value)
{
#line 59 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 59 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_has_thumbnail (self, value);
#line 609 "match.c"
}

const gchar*
synapse_match_get_thumbnail_path (SynapseMatch* self)
{
#line 60 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_thumbnail_path (self);
#line 619 "match.c"
}

void
synapse_match_set_thumbnail_path (SynapseMatch* self,
                                  const gchar* value)
{
#line 60 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 60 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_thumbnail_path (self, value);
#line 630 "match.c"
}

SynapseMatchType
synapse_match_get_match_type (SynapseMatch* self)
{
#line 61 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "../lib/synapse-core/match.vala"
	return SYNAPSE_MATCH_GET_INTERFACE (self)->get_match_type (self);
#line 640 "match.c"
}

void
synapse_match_set_match_type (SynapseMatch* self,
                              SynapseMatchType value)
{
#line 61 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 61 "../lib/synapse-core/match.vala"
	SYNAPSE_MATCH_GET_INTERFACE (self)->set_match_type (self, value);
#line 651 "match.c"
}

static void
synapse_match_default_init (SynapseMatchIface * iface,
                            gpointer iface_data)
{
#line 36 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "../lib/synapse-core/match.vala"
	synapse_match_signals[SYNAPSE_MATCH_EXECUTED_SIGNAL] = g_signal_new ("executed", SYNAPSE_TYPE_MATCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "../lib/synapse-core/match.vala"
	iface->execute = synapse_match_real_execute;
#line 36 "../lib/synapse-core/match.vala"
	iface->execute_with_target = synapse_match_real_execute_with_target;
#line 36 "../lib/synapse-core/match.vala"
	iface->needs_target = synapse_match_real_needs_target;
#line 36 "../lib/synapse-core/match.vala"
	iface->target_flags = synapse_match_real_target_flags;
#line 680 "match.c"
}

static GType
synapse_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_match_type_id;
	synapse_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseMatch", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_match_type_id, G_TYPE_OBJECT);
	return synapse_match_type_id;
}

GType
synapse_match_get_type (void)
{
	static volatile gsize synapse_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_id__volatile)) {
		GType synapse_match_type_id;
		synapse_match_type_id = synapse_match_get_type_once ();
		g_once_init_leave (&synapse_match_type_id__volatile, synapse_match_type_id);
	}
	return synapse_match_type_id__volatile;
}

GAppInfo*
synapse_application_match_get_app_info (SynapseApplicationMatch* self)
{
#line 87 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "../lib/synapse-core/match.vala"
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_app_info (self);
#line 712 "match.c"
}

void
synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                        GAppInfo* value)
{
#line 87 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 87 "../lib/synapse-core/match.vala"
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_app_info (self, value);
#line 723 "match.c"
}

gboolean
synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self)
{
#line 88 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 88 "../lib/synapse-core/match.vala"
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_needs_terminal (self);
#line 733 "match.c"
}

void
synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                              gboolean value)
{
#line 88 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 88 "../lib/synapse-core/match.vala"
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_needs_terminal (self, value);
#line 744 "match.c"
}

const gchar*
synapse_application_match_get_filename (SynapseApplicationMatch* self)
{
#line 89 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "../lib/synapse-core/match.vala"
	return SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->get_filename (self);
#line 754 "match.c"
}

void
synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                        const gchar* value)
{
#line 89 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 89 "../lib/synapse-core/match.vala"
	SYNAPSE_APPLICATION_MATCH_GET_INTERFACE (self)->set_filename (self, value);
#line 765 "match.c"
}

static void
synapse_application_match_default_init (SynapseApplicationMatchIface * iface,
                                        gpointer iface_data)
{
#line 86 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 86 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 86 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 778 "match.c"
}

static GType
synapse_application_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseApplicationMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_application_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_application_match_type_id;
	synapse_application_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseApplicationMatch", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_application_match_type_id, SYNAPSE_TYPE_MATCH);
	return synapse_application_match_type_id;
}

GType
synapse_application_match_get_type (void)
{
	static volatile gsize synapse_application_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_application_match_type_id__volatile)) {
		GType synapse_application_match_type_id;
		synapse_application_match_type_id = synapse_application_match_get_type_once ();
		g_once_init_leave (&synapse_application_match_type_id__volatile, synapse_application_match_type_id);
	}
	return synapse_application_match_type_id__volatile;
}

const gchar*
synapse_uri_match_get_uri (SynapseUriMatch* self)
{
#line 93 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "../lib/synapse-core/match.vala"
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_uri (self);
#line 810 "match.c"
}

void
synapse_uri_match_set_uri (SynapseUriMatch* self,
                           const gchar* value)
{
#line 93 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 93 "../lib/synapse-core/match.vala"
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_uri (self, value);
#line 821 "match.c"
}

SynapseQueryFlags
synapse_uri_match_get_file_type (SynapseUriMatch* self)
{
#line 94 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 94 "../lib/synapse-core/match.vala"
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_file_type (self);
#line 831 "match.c"
}

void
synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                 SynapseQueryFlags value)
{
#line 94 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 94 "../lib/synapse-core/match.vala"
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_file_type (self, value);
#line 842 "match.c"
}

const gchar*
synapse_uri_match_get_mime_type (SynapseUriMatch* self)
{
#line 95 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "../lib/synapse-core/match.vala"
	return SYNAPSE_URI_MATCH_GET_INTERFACE (self)->get_mime_type (self);
#line 852 "match.c"
}

void
synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                 const gchar* value)
{
#line 95 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 95 "../lib/synapse-core/match.vala"
	SYNAPSE_URI_MATCH_GET_INTERFACE (self)->set_mime_type (self, value);
#line 863 "match.c"
}

static void
synapse_uri_match_default_init (SynapseUriMatchIface * iface,
                                gpointer iface_data)
{
#line 92 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 92 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 92 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 876 "match.c"
}

static GType
synapse_uri_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUriMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_uri_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_uri_match_type_id;
	synapse_uri_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseUriMatch", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_uri_match_type_id, SYNAPSE_TYPE_MATCH);
	return synapse_uri_match_type_id;
}

GType
synapse_uri_match_get_type (void)
{
	static volatile gsize synapse_uri_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_uri_match_type_id__volatile)) {
		GType synapse_uri_match_type_id;
		synapse_uri_match_type_id = synapse_uri_match_get_type_once ();
		g_once_init_leave (&synapse_uri_match_type_id__volatile, synapse_uri_match_type_id);
	}
	return synapse_uri_match_type_id__volatile;
}

void
synapse_contact_match_send_message (SynapseContactMatch* self,
                                    const gchar* message,
                                    gboolean present)
{
#line 99 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 99 "../lib/synapse-core/match.vala"
	SYNAPSE_CONTACT_MATCH_GET_INTERFACE (self)->send_message (self, message, present);
#line 910 "match.c"
}

void
synapse_contact_match_open_chat (SynapseContactMatch* self)
{
#line 100 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 100 "../lib/synapse-core/match.vala"
	SYNAPSE_CONTACT_MATCH_GET_INTERFACE (self)->open_chat (self);
#line 920 "match.c"
}

static void
synapse_contact_match_default_init (SynapseContactMatchIface * iface,
                                    gpointer iface_data)
{
}

static GType
synapse_contact_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseContactMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_contact_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_contact_match_type_id;
	synapse_contact_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseContactMatch", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_contact_match_type_id, SYNAPSE_TYPE_MATCH);
	return synapse_contact_match_type_id;
}

GType
synapse_contact_match_get_type (void)
{
	static volatile gsize synapse_contact_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_contact_match_type_id__volatile)) {
		GType synapse_contact_match_type_id;
		synapse_contact_match_type_id = synapse_contact_match_get_type_once ();
		g_once_init_leave (&synapse_contact_match_type_id__volatile, synapse_contact_match_type_id);
	}
	return synapse_contact_match_type_id__volatile;
}

const gchar*
synapse_extended_info_get_extended_info (SynapseExtendedInfo* self)
{
#line 104 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "../lib/synapse-core/match.vala"
	return SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->get_extended_info (self);
#line 958 "match.c"
}

void
synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                         const gchar* value)
{
#line 104 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 104 "../lib/synapse-core/match.vala"
	SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->set_extended_info (self, value);
#line 969 "match.c"
}

static void
synapse_extended_info_default_init (SynapseExtendedInfoIface * iface,
                                    gpointer iface_data)
{
#line 103 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_string ("extended-info", "extended-info", "extended-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 978 "match.c"
}

static GType
synapse_extended_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseExtendedInfoIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_extended_info_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_extended_info_type_id;
	synapse_extended_info_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseExtendedInfo", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_extended_info_type_id, SYNAPSE_TYPE_MATCH);
	return synapse_extended_info_type_id;
}

GType
synapse_extended_info_get_type (void)
{
	static volatile gsize synapse_extended_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_extended_info_type_id__volatile)) {
		GType synapse_extended_info_type_id;
		synapse_extended_info_type_id = synapse_extended_info_get_type_once ();
		g_once_init_leave (&synapse_extended_info_type_id__volatile, synapse_extended_info_type_id);
	}
	return synapse_extended_info_type_id__volatile;
}

static GType
synapse_text_origin_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_TEXT_ORIGIN_UNKNOWN, "SYNAPSE_TEXT_ORIGIN_UNKNOWN", "unknown"}, {SYNAPSE_TEXT_ORIGIN_CLIPBOARD, "SYNAPSE_TEXT_ORIGIN_CLIPBOARD", "clipboard"}, {0, NULL, NULL}};
	GType synapse_text_origin_type_id;
	synapse_text_origin_type_id = g_enum_register_static ("SynapseTextOrigin", values);
	return synapse_text_origin_type_id;
}

GType
synapse_text_origin_get_type (void)
{
	static volatile gsize synapse_text_origin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_origin_type_id__volatile)) {
		GType synapse_text_origin_type_id;
		synapse_text_origin_type_id = synapse_text_origin_get_type_once ();
		g_once_init_leave (&synapse_text_origin_type_id__volatile, synapse_text_origin_type_id);
	}
	return synapse_text_origin_type_id__volatile;
}

gchar*
synapse_text_match_get_text (SynapseTextMatch* self)
{
#line 114 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "../lib/synapse-core/match.vala"
	return SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->get_text (self);
#line 1031 "match.c"
}

SynapseTextOrigin
synapse_text_match_get_text_origin (SynapseTextMatch* self)
{
#line 113 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 113 "../lib/synapse-core/match.vala"
	return SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->get_text_origin (self);
#line 1041 "match.c"
}

void
synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                    SynapseTextOrigin value)
{
#line 113 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 113 "../lib/synapse-core/match.vala"
	SYNAPSE_TEXT_MATCH_GET_INTERFACE (self)->set_text_origin (self, value);
#line 1052 "match.c"
}

static void
synapse_text_match_default_init (SynapseTextMatchIface * iface,
                                 gpointer iface_data)
{
#line 112 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1061 "match.c"
}

static GType
synapse_text_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseTextMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_text_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_text_match_type_id;
	synapse_text_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseTextMatch", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_text_match_type_id, SYNAPSE_TYPE_MATCH);
	return synapse_text_match_type_id;
}

GType
synapse_text_match_get_type (void)
{
	static volatile gsize synapse_text_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_match_type_id__volatile)) {
		GType synapse_text_match_type_id;
		synapse_text_match_type_id = synapse_text_match_get_type_once ();
		g_once_init_leave (&synapse_text_match_type_id__volatile, synapse_text_match_type_id);
	}
	return synapse_text_match_type_id__volatile;
}

SynapseMatch*
synapse_search_match_get_search_source (SynapseSearchMatch* self)
{
#line 118 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "../lib/synapse-core/match.vala"
	return SYNAPSE_SEARCH_MATCH_GET_INTERFACE (self)->get_search_source (self);
#line 1093 "match.c"
}

void
synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                        SynapseMatch* value)
{
#line 118 "../lib/synapse-core/match.vala"
	g_return_if_fail (self != NULL);
#line 118 "../lib/synapse-core/match.vala"
	SYNAPSE_SEARCH_MATCH_GET_INTERFACE (self)->set_search_source (self, value);
#line 1104 "match.c"
}

static void
synapse_search_match_default_init (SynapseSearchMatchIface * iface,
                                   gpointer iface_data)
{
#line 117 "../lib/synapse-core/match.vala"
	g_object_interface_install_property (iface, g_param_spec_object ("search-source", "search-source", "search-source", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1113 "match.c"
}

static GType
synapse_search_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchMatchIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_match_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_search_match_type_id;
	synapse_search_match_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseSearchMatch", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_search_match_type_id, SYNAPSE_TYPE_MATCH);
	g_type_interface_add_prerequisite (synapse_search_match_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER);
	return synapse_search_match_type_id;
}

GType
synapse_search_match_get_type (void)
{
	static volatile gsize synapse_search_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_search_match_type_id__volatile)) {
		GType synapse_search_match_type_id;
		synapse_search_match_type_id = synapse_search_match_get_type_once ();
		g_once_init_leave (&synapse_search_match_type_id__volatile, synapse_search_match_type_id);
	}
	return synapse_search_match_type_id__volatile;
}

static inline gpointer
synapse_default_match_get_instance_private (SynapseDefaultMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDefaultMatch_private_offset);
}

SynapseDefaultMatch*
synapse_default_match_construct (GType object_type,
                                 const gchar* query_string)
{
	SynapseDefaultMatch * self = NULL;
#line 129 "../lib/synapse-core/match.vala"
	g_return_val_if_fail (query_string != NULL, NULL);
#line 130 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) g_object_new (object_type, "title", query_string, "description", "", "has-thumbnail", FALSE, "icon-name", "unknown", "match-type", SYNAPSE_MATCH_TYPE_UNKNOWN, NULL);
#line 129 "../lib/synapse-core/match.vala"
	return self;
#line 1156 "match.c"
}

SynapseDefaultMatch*
synapse_default_match_new (const gchar* query_string)
{
#line 129 "../lib/synapse-core/match.vala"
	return synapse_default_match_construct (SYNAPSE_TYPE_DEFAULT_MATCH, query_string);
#line 1164 "match.c"
}

static const gchar*
synapse_default_match_real_get_title (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
#line 122 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 122 "../lib/synapse-core/match.vala"
	_tmp0_ = self->priv->_title;
#line 122 "../lib/synapse-core/match.vala"
	result = _tmp0_;
#line 122 "../lib/synapse-core/match.vala"
	return result;
#line 1181 "match.c"
}

static void
synapse_default_match_real_set_title (SynapseMatch* base,
                                      const gchar* value)
{
	SynapseDefaultMatch* self;
	gchar* old_value;
#line 122 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 122 "../lib/synapse-core/match.vala"
	old_value = synapse_default_match_real_get_title (base);
#line 122 "../lib/synapse-core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1196 "match.c"
		gchar* _tmp0_;
#line 122 "../lib/synapse-core/match.vala"
		_tmp0_ = g_strdup (value);
#line 122 "../lib/synapse-core/match.vala"
		_g_free0 (self->priv->_title);
#line 122 "../lib/synapse-core/match.vala"
		self->priv->_title = _tmp0_;
#line 122 "../lib/synapse-core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY]);
#line 1206 "match.c"
	}
}

static const gchar*
synapse_default_match_real_get_description (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
#line 123 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 123 "../lib/synapse-core/match.vala"
	_tmp0_ = self->priv->_description;
#line 123 "../lib/synapse-core/match.vala"
	result = _tmp0_;
#line 123 "../lib/synapse-core/match.vala"
	return result;
#line 1224 "match.c"
}

static void
synapse_default_match_real_set_description (SynapseMatch* base,
                                            const gchar* value)
{
	SynapseDefaultMatch* self;
	gchar* old_value;
#line 123 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 123 "../lib/synapse-core/match.vala"
	old_value = synapse_default_match_real_get_description (base);
#line 123 "../lib/synapse-core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1239 "match.c"
		gchar* _tmp0_;
#line 123 "../lib/synapse-core/match.vala"
		_tmp0_ = g_strdup (value);
#line 123 "../lib/synapse-core/match.vala"
		_g_free0 (self->priv->_description);
#line 123 "../lib/synapse-core/match.vala"
		self->priv->_description = _tmp0_;
#line 123 "../lib/synapse-core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY]);
#line 1249 "match.c"
	}
}

static const gchar*
synapse_default_match_real_get_icon_name (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
#line 124 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 124 "../lib/synapse-core/match.vala"
	_tmp0_ = self->priv->_icon_name;
#line 124 "../lib/synapse-core/match.vala"
	result = _tmp0_;
#line 124 "../lib/synapse-core/match.vala"
	return result;
#line 1267 "match.c"
}

static void
synapse_default_match_real_set_icon_name (SynapseMatch* base,
                                          const gchar* value)
{
	SynapseDefaultMatch* self;
	gchar* old_value;
#line 124 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 124 "../lib/synapse-core/match.vala"
	old_value = synapse_default_match_real_get_icon_name (base);
#line 124 "../lib/synapse-core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1282 "match.c"
		gchar* _tmp0_;
#line 124 "../lib/synapse-core/match.vala"
		_tmp0_ = g_strdup (value);
#line 124 "../lib/synapse-core/match.vala"
		_g_free0 (self->priv->_icon_name);
#line 124 "../lib/synapse-core/match.vala"
		self->priv->_icon_name = _tmp0_;
#line 124 "../lib/synapse-core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY]);
#line 1292 "match.c"
	}
}

static gboolean
synapse_default_match_real_get_has_thumbnail (SynapseMatch* base)
{
	gboolean result;
	SynapseDefaultMatch* self;
#line 125 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 125 "../lib/synapse-core/match.vala"
	result = self->priv->_has_thumbnail;
#line 125 "../lib/synapse-core/match.vala"
	return result;
#line 1307 "match.c"
}

static void
synapse_default_match_real_set_has_thumbnail (SynapseMatch* base,
                                              gboolean value)
{
	SynapseDefaultMatch* self;
	gboolean old_value;
#line 125 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 125 "../lib/synapse-core/match.vala"
	old_value = synapse_default_match_real_get_has_thumbnail (base);
#line 125 "../lib/synapse-core/match.vala"
	if (old_value != value) {
#line 125 "../lib/synapse-core/match.vala"
		self->priv->_has_thumbnail = value;
#line 125 "../lib/synapse-core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY]);
#line 1326 "match.c"
	}
}

static const gchar*
synapse_default_match_real_get_thumbnail_path (SynapseMatch* base)
{
	const gchar* result;
	SynapseDefaultMatch* self;
	const gchar* _tmp0_;
#line 126 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 126 "../lib/synapse-core/match.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 126 "../lib/synapse-core/match.vala"
	result = _tmp0_;
#line 126 "../lib/synapse-core/match.vala"
	return result;
#line 1344 "match.c"
}

static void
synapse_default_match_real_set_thumbnail_path (SynapseMatch* base,
                                               const gchar* value)
{
	SynapseDefaultMatch* self;
	gchar* old_value;
#line 126 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 126 "../lib/synapse-core/match.vala"
	old_value = synapse_default_match_real_get_thumbnail_path (base);
#line 126 "../lib/synapse-core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1359 "match.c"
		gchar* _tmp0_;
#line 126 "../lib/synapse-core/match.vala"
		_tmp0_ = g_strdup (value);
#line 126 "../lib/synapse-core/match.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 126 "../lib/synapse-core/match.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 126 "../lib/synapse-core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY]);
#line 1369 "match.c"
	}
}

static SynapseMatchType
synapse_default_match_real_get_match_type (SynapseMatch* base)
{
	SynapseMatchType result;
	SynapseDefaultMatch* self;
	SynapseMatchType _tmp0_;
#line 127 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 127 "../lib/synapse-core/match.vala"
	_tmp0_ = self->priv->_match_type;
#line 127 "../lib/synapse-core/match.vala"
	result = _tmp0_;
#line 127 "../lib/synapse-core/match.vala"
	return result;
#line 1387 "match.c"
}

static void
synapse_default_match_real_set_match_type (SynapseMatch* base,
                                           SynapseMatchType value)
{
	SynapseDefaultMatch* self;
	SynapseMatchType old_value;
#line 127 "../lib/synapse-core/match.vala"
	self = (SynapseDefaultMatch*) base;
#line 127 "../lib/synapse-core/match.vala"
	old_value = synapse_default_match_real_get_match_type (base);
#line 127 "../lib/synapse-core/match.vala"
	if (old_value != value) {
#line 127 "../lib/synapse-core/match.vala"
		self->priv->_match_type = value;
#line 127 "../lib/synapse-core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY]);
#line 1406 "match.c"
	}
}

static void
synapse_default_match_class_init (SynapseDefaultMatchClass * klass,
                                  gpointer klass_data)
{
#line 121 "../lib/synapse-core/match.vala"
	synapse_default_match_parent_class = g_type_class_peek_parent (klass);
#line 121 "../lib/synapse-core/match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDefaultMatch_private_offset);
#line 121 "../lib/synapse-core/match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_default_match_get_property;
#line 121 "../lib/synapse-core/match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_default_match_set_property;
#line 121 "../lib/synapse-core/match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_default_match_finalize;
#line 121 "../lib/synapse-core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 121 "../lib/synapse-core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 121 "../lib/synapse-core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 121 "../lib/synapse-core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 121 "../lib/synapse-core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 121 "../lib/synapse-core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY, synapse_default_match_properties[SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY] = g_param_spec_enum ("match-type", "match-type", "match-type", SYNAPSE_TYPE_MATCH_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1436 "match.c"
}

static void
synapse_default_match_synapse_match_interface_init (SynapseMatchIface * iface,
                                                    gpointer iface_data)
{
#line 121 "../lib/synapse-core/match.vala"
	synapse_default_match_synapse_match_parent_iface = g_type_interface_peek_parent (iface);
#line 121 "../lib/synapse-core/match.vala"
	iface->get_title = synapse_default_match_real_get_title;
#line 121 "../lib/synapse-core/match.vala"
	iface->set_title = synapse_default_match_real_set_title;
#line 121 "../lib/synapse-core/match.vala"
	iface->get_description = synapse_default_match_real_get_description;
#line 121 "../lib/synapse-core/match.vala"
	iface->set_description = synapse_default_match_real_set_description;
#line 121 "../lib/synapse-core/match.vala"
	iface->get_icon_name = synapse_default_match_real_get_icon_name;
#line 121 "../lib/synapse-core/match.vala"
	iface->set_icon_name = synapse_default_match_real_set_icon_name;
#line 121 "../lib/synapse-core/match.vala"
	iface->get_has_thumbnail = synapse_default_match_real_get_has_thumbnail;
#line 121 "../lib/synapse-core/match.vala"
	iface->set_has_thumbnail = synapse_default_match_real_set_has_thumbnail;
#line 121 "../lib/synapse-core/match.vala"
	iface->get_thumbnail_path = synapse_default_match_real_get_thumbnail_path;
#line 121 "../lib/synapse-core/match.vala"
	iface->set_thumbnail_path = synapse_default_match_real_set_thumbnail_path;
#line 121 "../lib/synapse-core/match.vala"
	iface->get_match_type = synapse_default_match_real_get_match_type;
#line 121 "../lib/synapse-core/match.vala"
	iface->set_match_type = synapse_default_match_real_set_match_type;
#line 1469 "match.c"
}

static void
synapse_default_match_instance_init (SynapseDefaultMatch * self,
                                     gpointer klass)
{
#line 121 "../lib/synapse-core/match.vala"
	self->priv = synapse_default_match_get_instance_private (self);
#line 1478 "match.c"
}

static void
synapse_default_match_finalize (GObject * obj)
{
	SynapseDefaultMatch * self;
#line 121 "../lib/synapse-core/match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch);
#line 122 "../lib/synapse-core/match.vala"
	_g_free0 (self->priv->_title);
#line 123 "../lib/synapse-core/match.vala"
	_g_free0 (self->priv->_description);
#line 124 "../lib/synapse-core/match.vala"
	_g_free0 (self->priv->_icon_name);
#line 126 "../lib/synapse-core/match.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 121 "../lib/synapse-core/match.vala"
	G_OBJECT_CLASS (synapse_default_match_parent_class)->finalize (obj);
#line 1497 "match.c"
}

static GType
synapse_default_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDefaultMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_default_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDefaultMatch), 0, (GInstanceInitFunc) synapse_default_match_instance_init, NULL };
	static const GInterfaceInfo synapse_match_info = { (GInterfaceInitFunc) synapse_default_match_synapse_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_default_match_type_id;
	synapse_default_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDefaultMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_default_match_type_id, SYNAPSE_TYPE_MATCH, &synapse_match_info);
	SynapseDefaultMatch_private_offset = g_type_add_instance_private (synapse_default_match_type_id, sizeof (SynapseDefaultMatchPrivate));
	return synapse_default_match_type_id;
}

GType
synapse_default_match_get_type (void)
{
	static volatile gsize synapse_default_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_default_match_type_id__volatile)) {
		GType synapse_default_match_type_id;
		synapse_default_match_type_id = synapse_default_match_get_type_once ();
		g_once_init_leave (&synapse_default_match_type_id__volatile, synapse_default_match_type_id);
	}
	return synapse_default_match_type_id__volatile;
}

static void
_vala_synapse_default_match_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SynapseDefaultMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch);
#line 121 "../lib/synapse-core/match.vala"
	switch (property_id) {
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		g_value_set_string (value, synapse_match_get_title ((SynapseMatch*) self));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		g_value_set_string (value, synapse_match_get_description ((SynapseMatch*) self));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		g_value_set_string (value, synapse_match_get_icon_name ((SynapseMatch*) self));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail ((SynapseMatch*) self));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path ((SynapseMatch*) self));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		g_value_set_enum (value, synapse_match_get_match_type ((SynapseMatch*) self));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 1570 "match.c"
		default:
#line 121 "../lib/synapse-core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 1576 "match.c"
	}
}

static void
_vala_synapse_default_match_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SynapseDefaultMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEFAULT_MATCH, SynapseDefaultMatch);
#line 121 "../lib/synapse-core/match.vala"
	switch (property_id) {
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_TITLE_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		synapse_match_set_title ((SynapseMatch*) self, g_value_get_string (value));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_DESCRIPTION_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		synapse_match_set_description ((SynapseMatch*) self, g_value_get_string (value));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_ICON_NAME_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		synapse_match_set_icon_name ((SynapseMatch*) self, g_value_get_string (value));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		synapse_match_set_has_thumbnail ((SynapseMatch*) self, g_value_get_boolean (value));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		synapse_match_set_thumbnail_path ((SynapseMatch*) self, g_value_get_string (value));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 121 "../lib/synapse-core/match.vala"
		case SYNAPSE_DEFAULT_MATCH_MATCH_TYPE_PROPERTY:
#line 121 "../lib/synapse-core/match.vala"
		synapse_match_set_match_type ((SynapseMatch*) self, g_value_get_enum (value));
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 1626 "match.c"
		default:
#line 121 "../lib/synapse-core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 121 "../lib/synapse-core/match.vala"
		break;
#line 1632 "match.c"
	}
}

